// Copyright (C) 2005 - Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Containing Verilog Model for the Atoms:                                   //
//                                                                           //
//                         stratixiigx_hssi_receiver                         //
//                         stratixiigx_hssi_transmitter                      //
//                         stratixiigx_hssi_central_management_unit          //
//                         stratixiigx_hssi_cmu_pll                          //
//                         stratixiigx_hssi_cmu_clock_divider                //
//                         stratixiigx_hssi_refclk_divider                   //
//                         stratixiigx_hssi_calibration_block                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



`timescale 1 ps / 1 ps
module stratixiigx_hssi_aux_clock_div (
    clk,     // input clock
    reset,   // reset
    enable_d, // enable DPRIO
    d,        // division factor for DPRIO support
    clkout   // divided clock
);
input clk,reset;
input enable_d;
input [7:0] d;
output clkout;


parameter clk_divide_by  = 1;
parameter extra_latency  = 0;

integer clk_edges,m;
reg [2*extra_latency:0] div_n_register;

wire [7:0] d_factor;


assign d_factor = (enable_d === 1'b1) ? d : clk_divide_by;

initial
begin
    div_n_register = 'b0;
    clk_edges = -1;
    m = 0;
end

always @(d_factor)
begin
    div_n_register = 'b0;
    clk_edges = -1;
    m = 0;
end

always @(posedge clk or negedge clk or posedge reset)
begin
    if (reset === 1'b1) 
    begin
        clk_edges = -1;
        div_n_register <= 'b0;
    end
    else
    begin
        if (clk_edges == -1) 
        begin
            div_n_register[0] <= clk;
            if (clk == 1'b1) clk_edges = 0;
        end
        else if (clk_edges % d_factor == 0) 
            div_n_register[0] <= ~div_n_register[0];
        if (clk_edges >= 0 || clk == 1'b1)
            clk_edges = (clk_edges + 1) % (2*d_factor) ;
    end
    for (m = 0; m < 2*extra_latency; m=m+1)
            div_n_register[m+1] <= div_n_register[m];
end

assign clkout = div_n_register[2*extra_latency];

endmodule


`timescale 1 ps / 1 ps

module stratixiigx_hssi_aux_clock_mult (
    clk,     // input clock
    adjust,  // adjust frequency
    adjust_without_lol,
    reset,   // reset
    enable_m, // enable DPRIO
    m,        // multiplication factor for DPRIO support
    clkout,  // multiplied clock
    busy     // state
);
input clk,adjust,reset;
input adjust_without_lol;
input enable_m;
input [7:0] m; 
output clkout;
output [1:0] busy;
reg [1:0] busy;


parameter clk_multiply_by  = 1;

`define S2GX_HSSI_CLOCK_MULT_INITIAL 2'b01
`define S2GX_HSSI_CLOCK_MULT_ACTIVE  2'b11
`define S2GX_HSSI_CLOCK_MULT_INACTIVE  2'b00

reg  clk_adjust_settled;
real last_rising_edge,clk_period;
integer clk_fast_period,clk_adjust,clk_adjust_interval,clk_adjust_running,clk_sync_period;
reg  mult_n;
integer n;

wire [7:0] m_factor;

assign m_factor = (enable_m === 1'b1) ? m : clk_multiply_by;

// At start of reconfiguration, set multiplier to reset state

always @(m_factor)
begin
    busy <= `S2GX_HSSI_CLOCK_MULT_INITIAL;
    last_rising_edge = 0;
    mult_n = 'b0;
    n = 0;
end

initial
begin
    busy = `S2GX_HSSI_CLOCK_MULT_INITIAL;
    last_rising_edge = 0;
    mult_n = 'b0;
    n = 0;
end


always @(posedge adjust) busy <= `S2GX_HSSI_CLOCK_MULT_INITIAL;

always @(posedge clk or posedge reset)
begin
    if (reset === 1'b1) 
    begin
        mult_n = 1'b0;
        busy <= `S2GX_HSSI_CLOCK_MULT_INITIAL;
    end
    else
    begin
        if (busy == `S2GX_HSSI_CLOCK_MULT_INITIAL && adjust_without_lol == 1'b0)        // first rising edge
        begin 
            mult_n = 1'b0;
            last_rising_edge = $realtime;
            busy <= `S2GX_HSSI_CLOCK_MULT_ACTIVE;
        end
        else 
        begin
            if (busy == `S2GX_HSSI_CLOCK_MULT_INITIAL && adjust_without_lol == 1'b1)
            begin 
                mult_n = 1'b0;
                last_rising_edge = $realtime;
                busy <= `S2GX_HSSI_CLOCK_MULT_ACTIVE;
            end
            if (busy == `S2GX_HSSI_CLOCK_MULT_ACTIVE)    // second rising edge
            begin
                clk_period = $realtime - last_rising_edge;
                clk_fast_period = clk_period/m_factor - 0.5;
                clk_adjust = clk_period - clk_fast_period * m_factor;
                busy <= `S2GX_HSSI_CLOCK_MULT_INACTIVE;
            end
            mult_n = ~mult_n;
            if (clk_adjust > 0) clk_adjust_running = clk_adjust + 1;
            clk_adjust_settled = (clk_adjust == 0);                    // if no adjustment necessary
            for (n = m_factor; n >= 1 ; n=n-1)
            begin
                if (clk_adjust_settled == 1'b0) 
                begin
                    clk_adjust_running = clk_adjust_running - 1;
                    clk_adjust_interval = n/clk_adjust_running;
                    if (n % clk_adjust_running == 0) 
                        clk_adjust_settled = 1'b1;
                    clk_sync_period = clk_fast_period + 1;       
                end
                else
                begin
                    if (clk_adjust == 0)
                        clk_sync_period = clk_fast_period;
                    else
                    begin
                        if (n % clk_adjust_interval == 0) 
                            clk_sync_period = clk_fast_period + 1;     
                        else
                            clk_sync_period = clk_fast_period;
                    end
                end
                if (reset == 1'b1) mult_n = 1'b0;
                else
                begin
                    #(clk_sync_period/2) mult_n = ~mult_n; 
                    if (n > 1) #(clk_sync_period - clk_sync_period/2) mult_n = ~mult_n; 
                end
            end
        end
    end
end

assign clkout = mult_n;

endmodule


`timescale 1 ps / 1 ps
module stratixiigx_hssi_aux_clock_phaseshift (
    clk,     // input clock
    clkout   // delayed clock
);
input clk;
output clkout;
parameter clk_phase_shift_by  = 0;

reg pclk;

always @(clk) pclk <=  #(clk_phase_shift_by) clk;

assign clkout = pclk;
endmodule


`timescale 1 ps / 1 ps
module stratixiigx_hssi_tx_channel_clk_div (
    dpriodisable,
    dprioin,
    clkin0,clkin1,     // CMU PLL clocks
    reset,
    vcobypassin,       // VCO Bypass
    lclkout,           // Low speed clock
    fclkout            // Fast speed clock
);
input  dpriodisable;
input [9:0] dprioin;
input  clkin0,clkin1;
input  reset;
input  vcobypassin;
output lclkout,fclkout;

parameter clkin0_select = "true"; // true => select clkin0, false => select clkin1
parameter clk_divide_by_n = 1;    // n=1,2,4
parameter clk_divide_by_m = 4;    // m=4,5
parameter clk_divide_by_2_select = "true"; // true => use /2 divider, false => bypass
parameter allow_vco_bypass = "false";
parameter lclkout_latency = 0;
parameter fclkout_latency = 0;
parameter lclkout_phase_shift = 0;
parameter fclkout_phase_shift = 0; 

wire divide_by_n_in,divide_by_n_out,divide_by_m_out,divide_by_2_out; // divider i/o
wire lclkout_undelayed,hclkout_undelayed;     // before phase shift
wire lclkout_pre_latency,hclkout_pre_latency; // before latency

// begin dprio
// clkin0 selection
wire cram_rtx_cmu_sel;
wire dprio_divide_by_n_in;

// by n
wire [1:0] cram_m_sel;
wire cram_rpma_doublewidth_tx;
wire cram_rpmadwidth_tx;

wire nondprio_divide_by_n_out;
wire dprio_divide_by_n_out;
wire dprio_divide_by_n_out_by1;
wire dprio_divide_by_n_out_by2;
wire dprio_divide_by_n_out_by4;

// by m
wire nondprio_divide_by_m_out;
wire dprio_divide_by_m_out;
wire dprio_divide_by_m_out_by4;
wire dprio_divide_by_m_out_by5;

assign cram_rtx_cmu_sel = dprioin[4];

assign cram_m_sel = dprioin[1:0];
assign cram_rpmadwidth_tx = dprioin[3];
assign cram_rpma_doublewidth_tx = dprioin[2];

// by n
assign dprio_divide_by_n_out =(cram_m_sel === 2'b10) ? dprio_divide_by_n_out_by4 :
                              (cram_m_sel === 2'b01) ? dprio_divide_by_n_out_by2 :
                              dprio_divide_by_n_out_by1;
                              
assign divide_by_n_out = (dpriodisable !== 1'b0) ? nondprio_divide_by_n_out : dprio_divide_by_n_out;

// by m
assign dprio_divide_by_m_out = (cram_rpmadwidth_tx == 1'b1) ? dprio_divide_by_m_out_by5 : dprio_divide_by_m_out_by4;
assign divide_by_m_out= (dpriodisable !== 1'b0) ? nondprio_divide_by_m_out : dprio_divide_by_m_out;

// end dprio

// refclkin selection
assign dprio_divide_by_n_in = (cram_rtx_cmu_sel === 1'b0) ? clkin0 : clkin1;
assign divide_by_n_in = (allow_vco_bypass == "true") ? vcobypassin : 
                        (dpriodisable === 1'b0) ? dprio_divide_by_n_in :
                        ((clkin0_select == "true") ? clkin0 : clkin1);

// N divider
stratixiigx_hssi_aux_clock_div divide_by_n (
    .clk(divide_by_n_in),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(nondprio_divide_by_n_out)
);
defparam divide_by_n.clk_divide_by = clk_divide_by_n;
defparam divide_by_n.extra_latency = 0;
// N = 1
stratixiigx_hssi_aux_clock_div divide_by_n_by1 (
    .clk(divide_by_n_in),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(dprio_divide_by_n_out_by1)
);
defparam divide_by_n_by1.clk_divide_by = 1;
defparam divide_by_n_by1.extra_latency = 0;
// N = 2
stratixiigx_hssi_aux_clock_div divide_by_n_by2 (
    .clk(divide_by_n_in),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(dprio_divide_by_n_out_by2)
);
defparam divide_by_n_by2.clk_divide_by = 2;
defparam divide_by_n_by2.extra_latency = 0;
// N = 4
stratixiigx_hssi_aux_clock_div divide_by_n_by4 (
    .clk(divide_by_n_in),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(dprio_divide_by_n_out_by4)
);
defparam divide_by_n_by4.clk_divide_by = 4;
defparam divide_by_n_by4.extra_latency = 0;

// 4,5 divider
stratixiigx_hssi_aux_clock_div divide_by_m (
    .clk(divide_by_n_out),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(nondprio_divide_by_m_out)
);
defparam divide_by_m.clk_divide_by = clk_divide_by_m;
defparam divide_by_m.extra_latency = 0;
// m=4
stratixiigx_hssi_aux_clock_div divide_by_m_by4 (
    .clk(divide_by_n_out),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(dprio_divide_by_m_out_by4)
);
defparam divide_by_m_by4.clk_divide_by = 4;
defparam divide_by_m_by4.extra_latency = 0;
// m=5
stratixiigx_hssi_aux_clock_div divide_by_m_by5 (
    .clk(divide_by_n_out),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(dprio_divide_by_m_out_by5)
);
defparam divide_by_m_by5.clk_divide_by = 5;
defparam divide_by_m_by5.extra_latency = 0;

// 2 divider - moved to SERDES
stratixiigx_hssi_aux_clock_div divide_by_2 (
    .clk(divide_by_m_out),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(divide_by_2_out)
);
defparam divide_by_2.clk_divide_by = 2;
defparam divide_by_2.extra_latency = 0;

assign lclkout_undelayed = (clk_divide_by_2_select == "true") ? divide_by_2_out : divide_by_m_out;
assign hclkout_undelayed = divide_by_n_out;

// Low speed clock phase shift
stratixiigx_hssi_aux_clock_phaseshift lclk_phase_shift (
    .clk(lclkout_undelayed),
    .clkout(lclkout_pre_latency)
);
defparam lclk_phase_shift.clk_phase_shift_by = lclkout_phase_shift;

// High speed clock phase shift
stratixiigx_hssi_aux_clock_phaseshift hclk_phase_shift (
    .clk(hclkout_undelayed),
    .clkout(hclkout_pre_latency)
);
defparam hclk_phase_shift.clk_phase_shift_by = fclkout_phase_shift;

// Low speed clock latency
stratixiigx_hssi_aux_clock_div lclk_latency (
    .clk(lclkout_pre_latency),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(lclkout)
);
defparam lclk_latency.clk_divide_by = 1;
defparam lclk_latency.extra_latency = lclkout_latency;

// High speed clock latency
stratixiigx_hssi_aux_clock_div hclk_latency (
    .clk(hclkout_pre_latency),
    .reset(reset),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(fclkout)
);
defparam hclk_latency.clk_divide_by = 1;
defparam hclk_latency.extra_latency = fclkout_latency;

endmodule


`timescale 1 ps / 1 ps
module stratixiigx_hssi_refclk_divider (
    inclk,       // input from REFCLK pin
    dprioin,
    dpriodisable,
    clkout,      // clock output
    dprioout
);
input inclk,dprioin,dpriodisable;
output clkout,dprioout;

wire inclk_ipd;
wire dprioin_ipd;
wire dpriodisable_ipd;

buf buf_inclk (inclk_ipd,inclk);
buf buf_dprioin (dprioin_ipd,dprioin);
buf buf_dpriodisable (dpriodisable_ipd,dpriodisable);

specify
    (inclk => clkout) = (0,0);
endspecify

parameter enable_divider = "true"; // true -> use /2 divider, false -> bypass
parameter divider_number = 0;      // 0 or 1 for logical numbering
parameter refclk_coupling_termination = "dc_coupling_external_termination"; // new in 5.1 SP1
parameter dprio_config_mode        = 0;               // 6.1

wire divide_by_2_out;

stratixiigx_hssi_aux_clock_div divide_by_2 (
    .clk(inclk_ipd),
    .reset(1'b0),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .clkout(divide_by_2_out)
);
defparam divide_by_2.clk_divide_by = 2;
defparam divide_by_2.extra_latency = 0;

assign clkout = (enable_divider == "true") ? divide_by_2_out : inclk_ipd;
assign dprioout = (dpriodisable_ipd == 1'b1) ? 1'b0 : dprioin_ipd; // temporary, needs to be changed later

endmodule

`timescale 1 ps / 1 ps
module stratixiigx_hssi_cmu_clock_divider (
    clk,                 // CMU PLL clocks 0,1,2
    pclkin,              // pclk from adjacent QUAD
    dprioin,           
    dpriodisable,
    powerdn,
    quadreset,
    refclkdig,
    scanclk,
    scanin,
    vcobypassin,
    scanshift,
    scanmode,
    analogrefclkout,     // output of /4/5 divider
    analogfastrefclkout, // output of /N divider
    digitalrefclkout,    // refclk_pma
    pclkx8out,           // pclk output to adjacent QUAD
    coreclkout,          // coreclk output to PLD
    dprioout,
    scanout
);
input  [2:0] clk;
input  pclkin;
input  [29:0] dprioin;
input  dpriodisable;
input  powerdn,quadreset;
input  refclkdig,scanclk,scanshift,scanmode;
input  [22:0] scanin;
input  vcobypassin;
output analogrefclkout,analogfastrefclkout,digitalrefclkout,coreclkout;
output pclkx8out;
output [29:0] dprioout;
output [22:0] scanout;

wire pclkin_ipd;
wire  [2:0] clk_ipd;
wire [29:0] dprioin_ipd;
wire dpriodisable_ipd;
wire powerdn_ipd;
wire quadreset_ipd;
wire refclkdig_ipd;
wire scanclk_ipd;
wire scanshift_ipd;
wire scanmode_ipd;
wire [22:0] scanin_ipd;

buf buf_pclkin (pclkin_ipd,pclkin);
buf buf_clk  [2:0] (clk_ipd,clk);
buf buf_dprioin [29:0] (dprioin_ipd,dprioin);
buf buf_dpriodisable (dpriodisable_ipd,dpriodisable);
buf buf_powerdn (powerdn_ipd,powerdn);
buf buf_quadreset (quadreset_ipd,quadreset);
buf buf_refclkdig (refclkdig_ipd,refclkdig);
buf buf_scanclk (scanclk_ipd,scanclk);
buf buf_scanshift (scanshift_ipd,scanshift);
buf buf_scanmode (scanmode_ipd,scanmode);
buf buf_scanin [22:0] (scanin_ipd,scanin);

specify
    (clk => coreclkout)    = (0,0);
    (clk => pclkx8out)     = (0,0);
    (pclkin => coreclkout) = (0,0);
endspecify

parameter inclk_select   = 0;   // 0-2 logical index for clk
parameter use_vco_bypass = "false"; 
parameter use_digital_refclk_post_divider = "false"; // true -> /2 div, false -> bypass
parameter use_coreclk_out_post_divider = "false";    // true -> /2 div, false -> bypass
parameter divide_by = 4; // /4 or /5 div
parameter enable_refclk_out = "true";
parameter enable_pclk_x8_out = "false";
parameter select_neighbor_pclk = "false";
parameter coreclk_out_gated_by_quad_reset = "false";
parameter select_refclk_dig = "false";
parameter dprio_config_mode        = 0;               // 6.1

// Simulation only
parameter sim_analogrefclkout_phase_shift = 0;
parameter sim_analogfastrefclkout_phase_shift = 0;
parameter sim_digitalrefclkout_phase_shift = 0;
parameter sim_pclkx8out_phase_shift = 0;
parameter sim_coreclkout_phase_shift = 0;

wire divide_by_n_out,divide_by_m_out,divide_by_2_dig_out,divide_by_2_core_out; // divider i/o
wire mux_pclk,mux_digrefclk,mux_coreclk;
wire reset_divs,reset_coreclk_only;
wire vco_bypass_mux;

wire analogrefclkout_undelayed,analogfastrefclkout_undelayed,digitalrefclkout_undelayed,
     coreclkout_undelayed,pclkx8out_undelayed;

assign reset_divs = powerdn_ipd | quadreset_ipd;
assign reset_coreclk_only = (coreclk_out_gated_by_quad_reset == "false") ? 1'b0 : quadreset_ipd;

// /N=1 divider

stratixiigx_hssi_aux_clock_div divide_by_n (
    .clk(clk_ipd[inclk_select]),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .reset(reset_divs),
    .clkout(divide_by_n_out)
);
defparam divide_by_n.clk_divide_by = 1;
defparam divide_by_n.extra_latency = 0;

// 4,5 divider
stratixiigx_hssi_aux_clock_div divide_by_m (
    .clk(divide_by_n_out),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .reset(reset_divs),
    .clkout(divide_by_m_out)
);
defparam divide_by_m.clk_divide_by = divide_by;
defparam divide_by_m.extra_latency = 0;

assign vco_bypass_mux = (use_vco_bypass == "true") ? vcobypassin : divide_by_m_out;

// 2 divider for refclk_pma
stratixiigx_hssi_aux_clock_div divide_by_2_dig (
    .clk(vco_bypass_mux),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .reset(reset_divs),
    .clkout(divide_by_2_dig_out)
);
defparam divide_by_2_dig.clk_divide_by = 2;
defparam divide_by_2_dig.extra_latency = 0;

// 2 divider for coreclk
stratixiigx_hssi_aux_clock_div divide_by_2_core (
    .clk(mux_digrefclk),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .reset(reset_coreclk_only),
    .clkout(divide_by_2_core_out)
);
defparam divide_by_2_core.clk_divide_by = 2;
defparam divide_by_2_core.extra_latency = 0;

assign analogfastrefclkout_undelayed = divide_by_n_out;
assign analogrefclkout_undelayed = (enable_refclk_out == "false") ? 1'bz : divide_by_m_out;
assign mux_pclk = (use_digital_refclk_post_divider == "true") ? divide_by_2_dig_out : vco_bypass_mux;
assign mux_digrefclk = (select_neighbor_pclk == "true") ? pclkin_ipd : mux_pclk;
assign pclkx8out_undelayed = (enable_pclk_x8_out == "false") ? 1'bz : mux_pclk;
assign digitalrefclkout_undelayed = (select_refclk_dig == "true") ? refclkdig_ipd : mux_digrefclk;
assign mux_coreclk = (use_coreclk_out_post_divider == "false") ? mux_digrefclk : divide_by_2_core_out;
assign coreclkout_undelayed = mux_coreclk;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_afrc (
    .clk(analogfastrefclkout_undelayed),
    .clkout(analogfastrefclkout)
);
defparam extra_ps_afrc.clk_phase_shift_by = sim_analogfastrefclkout_phase_shift;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_arc (
    .clk(analogrefclkout_undelayed),
    .clkout(analogrefclkout)
);
defparam extra_ps_arc.clk_phase_shift_by = sim_analogrefclkout_phase_shift;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_drc (
    .clk(digitalrefclkout_undelayed),
    .clkout(digitalrefclkout)
);
defparam extra_ps_drc.clk_phase_shift_by = sim_digitalrefclkout_phase_shift;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_cc (
    .clk(coreclkout_undelayed),
    .clkout(coreclkout)
);
defparam extra_ps_cc.clk_phase_shift_by = sim_coreclkout_phase_shift;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_p8c (
    .clk(pclkx8out_undelayed),
    .clkout(pclkx8out)
);
defparam extra_ps_p8c.clk_phase_shift_by = sim_pclkx8out_phase_shift;


endmodule


`timescale 1 ps/1 ps
module stratixiigx_hssi_cmu_pll (
   clk,dprioin,dpriodisable,
   pllreset,pllpowerdn,
   clkout,locked,
   dprioout,
   fbclkout,
   vcobypassout
);
input [7:0] clk;
input [39:0] dprioin;
input dpriodisable;
input pllreset,pllpowerdn;
output clkout,locked;
output [39:0] dprioout;
output fbclkout;
output vcobypassout;

wire dpriodisable_ipd;
wire [7:0] clk_ipd;
wire [39:0] dprioin_ipd;
wire pllreset_ipd;
wire pllpowerdn_ipd;

// DPRIO
wire dprioenable;
reg  dprioen_reg;
wire [7:0] m;
wire [7:0] cru_m_chn;
wire [7:0] cru_l_chn;


buf buf_dpriodisable (dpriodisable_ipd,dpriodisable);
buf buf_clk [7:0] (clk_ipd,clk);
buf buf_dprioin [39:0] (dprioin_ipd,dprioin);
buf buf_pllreset (pllreset_ipd,pllreset);
buf buf_pllpowerdn (pllpowerdn_ipd,pllpowerdn);

specify
    (clk => clkout) = (0,0);
endspecify
parameter inclk0_period = 0;  // time period in ps
parameter inclk1_period = 0;
parameter inclk2_period = 0;
parameter inclk3_period = 0;
parameter inclk4_period = 0;
parameter inclk5_period = 0;
parameter inclk6_period = 0;
parameter inclk7_period = 0;

parameter pfd_clk_select = 0; // logical clock select 0-7
parameter multiply_by = 1;    // feedback loop divider 1,4,5,8,10,16,20,25
parameter divide_by = 1;      // post divider 1,2,4
parameter low_speed_test_sel = 4'b0000;
parameter pll_type = "normal"; // normal,fast,auto
parameter charge_pump_current_test_enable = 2'b00;
parameter vco_range = "low";   // CMU_CTL[0]
parameter loop_filter_resistor_control = 2'b00; // CMU_CTL[2:1]
parameter loop_filter_ripple_capacitor_control = 2'b00; // CMU_CTL[4:3].
parameter use_default_charge_pump_current_selection = "false"; // CMU_CTL[5]
parameter use_default_charge_pump_supply_vccm_vod_control  = "false"; // CMU_CTL[6]
parameter pll_number = 0; // PLL 0-2 
parameter charge_pump_current_control = 2'b00;
parameter up_down_control_percent = 4'b0000;
parameter charge_pump_tristate_enable = "false";
parameter enable_pll_cascade = "false";             // 6.1
parameter dprio_config_mode = 0;                    // 6.1
parameter protocol_hint = "basic";                  // 6.1

parameter remapped_to_new_loop_filter_charge_pump_settings = "false"; // 7.2 sp1

// Simulation only
parameter sim_clkout_phase_shift = 0;
parameter sim_clkout_latency = 0;

`define S2GX_CMU_PLL_INITIAL 2'b01
`define S2GX_CMU_PLL_ACTIVE  2'b11
`define S2GX_CMU_PLL_INACTIVE  2'b00

wire pll_clkin_pre_latency;
wire pll_clkin,clk_pll,clk_div,clk_div_delayed,clk_vco;
reg  charge_pump; // re-adjust VCO frequency
reg  adjust_without_lol;
wire charge_pump_delayed;
wire [1:0] busy;  // VCO state

real last_fb_clk_edge;
wire check_phase;
real expected_clk_period,clk_tolerance,real_clk_period,last_pll_clkin_edge,last_real_clk_period;
reg  first_pll_clkin_edge_detect;
reg  display_msgs,freq_viol_msg_sem;
wire reset;
reg locked_real;

wire         dprio_reset; // reset through DPRIO CRAM in 7.1
wire [2:0]   dprio_pfd_clk_select;

function real select_clock_period;
input clk_select;
integer clk_select;
real period;
begin
    case (clk_select)
        0 : period = inclk0_period;
        1 : period = inclk1_period;
        2 : period = inclk2_period;
        3 : period = inclk3_period;
        4 : period = inclk4_period;
        5 : period = inclk5_period;
        6 : period = inclk6_period;
        7 : period = inclk7_period;
        default : $display("Invalid logical clock select");
    endcase
    select_clock_period = period;
end
endfunction

    // get the absolute value
    function integer abs;
    input value;
    integer value;
    begin
        if (value < 0)
            abs = value * -1;
        else abs = value;
    end
    endfunction

initial
begin
    charge_pump = 1'b1;
    first_pll_clkin_edge_detect = 1'b0;
    expected_clk_period = select_clock_period(pfd_clk_select);
    clk_tolerance = 0.1 * expected_clk_period; // same as Stratix
    display_msgs = 1'b1;
    freq_viol_msg_sem = 1'b1;
    locked_real = 1'b0;
    adjust_without_lol = 1'b0;
end

assign pll_clkin_pre_latency = (dprioenable === 1'b1) ? clk_ipd[dprio_pfd_clk_select] : clk_ipd[pfd_clk_select];
assign reset = pllreset_ipd | pllpowerdn_ipd | dprio_reset;

// DPRIO
assign dprioenable = ((dprio_config_mode & 6'b010000) != 0) ? ~dpriodisable_ipd : 1'b0;
assign cru_m_chn = dprioin_ipd[7:0];
assign cru_l_chn = dprioin_ipd[15:8];
assign dprio_reset = ((dprioenable === 1'b1) &&
                     (dprioin_ipd[16] === 1'b1 || dprioin_ipd[17] === 1'b1)) ? 1'b1 : 1'b0;
assign dprio_pfd_clk_select = dprioin_ipd[20:18];

assign dprioout[7:0]  = multiply_by;
assign dprioout[15:8] = divide_by;
assign dprioout[20:18] = pfd_clk_select;


assign m = cru_m_chn;

// Clock latency

stratixiigx_hssi_aux_clock_div clock_latency (
    .clk(pll_clkin_pre_latency),
    .enable_d (1'b0),     // enable dprio
    .d        (8'h00),    // dprio
    .reset(reset),
    .clkout(pll_clkin)
);
defparam clock_latency.clk_divide_by = 1;
defparam clock_latency.extra_latency = sim_clkout_latency;

// DPRIO : Register the dprioenable signal to avoid asynchronous reconfiguration
always @(posedge pll_clkin)
begin
    dprioen_reg <= dprioenable;
end

// Input frequency checks

always @(posedge pll_clkin)
begin
    if (first_pll_clkin_edge_detect == 1'b0)
        first_pll_clkin_edge_detect = 1'b1; 
    else 
    begin
        real_clk_period = $realtime - last_pll_clkin_edge;
        if ((real_clk_period < expected_clk_period - clk_tolerance) ||
            (real_clk_period > expected_clk_period + clk_tolerance))
        begin
            if (freq_viol_msg_sem == 1'b1)
            begin
                $display("Warning : CMU PLL input frequency mismatch between parameter-specified period and real clock period");
                $display("Time: %0t  Instance: %m", $time);
                $display("Clock period specified in parameter is %0t but real clock period is %0t",expected_clk_period,real_clk_period);
                freq_viol_msg_sem = 1'b0;
            end
        end
        if ((real_clk_period != last_real_clk_period) && (last_real_clk_period > 0)) 
        begin
            charge_pump = 1'b1;
            if ( abs(real_clk_period - last_real_clk_period) <= 2 )
                adjust_without_lol = 1'b1;
        end
        last_real_clk_period = real_clk_period;
    end
    last_pll_clkin_edge = $realtime;
end

// PFD

always @(posedge clk_pll)   last_fb_clk_edge = $realtime;

always @(negedge pll_clkin) 
begin
    if (($realtime > 0) && (busy != `S2GX_CMU_PLL_ACTIVE) && (busy != `S2GX_CMU_PLL_INITIAL))
    begin
        if (last_pll_clkin_edge != last_fb_clk_edge)
        begin
            charge_pump = 1'b1;
            if (locked == 1'b1)
                adjust_without_lol = 1'b1;
        end
        else charge_pump = 1'b0;
    end
end

always @(negedge reset)
begin
    charge_pump = 1'b1;
    adjust_without_lol = 1'b0;
//    display_msgs = 1'b0;
end

always @(posedge reset)
begin
    if (reset == 1'b1) 
    begin
        $display ("Note : CMU PLL is reset");
        $display ("Time: %0t  Instance: %m", $time);
        display_msgs = 1'b0;
    end
end
always @(charge_pump)
begin
    if (charge_pump == 1'b1 && adjust_without_lol == 1'b0) 
    begin
        if (display_msgs == 1'b0)
        begin
            $display ("Note : CMU PLL lost lock due to reset or change in frequency of input clock");
            $display ("Time: %0t  Instance: %m", $time);
            display_msgs = 1'b1;
        end
    end
    else
    begin
        if (display_msgs == 1'b1)
        begin
            $display ("Note : CMU PLL locked to incoming clock");
            $display ("Time: %0t  Instance: %m", $time);
            display_msgs = 1'b0;
        end
    end
end

// VCO
always @(busy)
begin
    if (busy == `S2GX_CMU_PLL_INACTIVE)
    begin
        charge_pump = 1'b0;
        adjust_without_lol = 1'b0;
    end
end

stratixiigx_hssi_aux_clock_mult vco (
    .clk(pll_clkin),
    .adjust(charge_pump),
    .adjust_without_lol(adjust_without_lol),
    .reset(reset),
    .enable_m(dprioenable),
    .m(m),
    .clkout(clk_vco), // VCO output
    .busy(busy)
);
defparam vco.clk_multiply_by = multiply_by;

// Feedback

stratixiigx_hssi_aux_clock_div divide_by_M (
    .clk(clk_vco),
    .reset(reset),
    .enable_d(dprioen_reg),
    .d(m),
    .clkout(clk_pll)
);
defparam divide_by_M.clk_divide_by = multiply_by;
defparam divide_by_M.extra_latency = 0;

// Extra phase shift on output

stratixiigx_hssi_aux_clock_phaseshift extra_ps_clkout (
    .clk(clk_vco),
    .clkout(clk_div_delayed)
);
defparam extra_ps_clkout.clk_phase_shift_by = sim_clkout_phase_shift;
        
// Extra phase shift on lock

stratixiigx_hssi_aux_clock_phaseshift extra_ps_lock (
    .clk(charge_pump),
    .clkout(charge_pump_delayed)
);
defparam extra_ps_lock.clk_phase_shift_by = sim_clkout_phase_shift;

always @(busy or reset)
begin
    if (reset  ===  1'b1)
        locked_real <= 1'b0;
    else if (busy == `S2GX_CMU_PLL_INACTIVE || adjust_without_lol == 1'b1) 
        locked_real <= 1'b1;
    else
        locked_real <= 1'b0;
end

assign clkout = clk_div_delayed && locked; 
assign locked = locked_real;
assign fbclkout = clk_pll;
assign vcobypassout = pll_clkin;

endmodule
module stratixiigx_hssi_tx_rx_det_DIV_BY_2 (CLK, RESET_N, CLKOUT); // synthesis syn_black_box

   input         CLK, RESET_N;
   output        CLKOUT;
   reg           CLKOUT;
   wire 	 NEXT_VAL;
   
   // state definition
   always @ (posedge CLK or negedge RESET_N)
     if (!RESET_N)
	  CLKOUT <= 1'b0;
     else
          CLKOUT <= NEXT_VAL;
   
    assign   NEXT_VAL = ~CLKOUT;

endmodule // div_by_2
// synchronizer to synchronize the receiver

module stratixiigx_hssi_tx_rx_det_CLK_GEN (CLK, RESET_N, CLKOUT);

   input         CLK, RESET_N;
   output	 CLKOUT;
   wire 	 CLKOUT;

   wire 	 CLK8M, CLK4M, CLK2M;
 	 
   stratixiigx_hssi_tx_rx_det_DIV_BY_2         DIV_1(.CLK(CLK), .RESET_N(RESET_N), .CLKOUT(CLK8M));
   stratixiigx_hssi_tx_rx_det_DIV_BY_2         DIV_2(.CLK(CLK8M), .RESET_N(RESET_N), .CLKOUT(CLK4M));
   stratixiigx_hssi_tx_rx_det_DIV_BY_2         DIV_3(.CLK(CLK4M), .RESET_N(RESET_N), .CLKOUT(CLK2M));
   stratixiigx_hssi_tx_rx_det_DIV_BY_2         DIV_4(.CLK(CLK2M), .RESET_N(RESET_N), .CLKOUT(CLKOUT));

endmodule // clk_gen
module stratixiigx_hssi_tx_rx_det_RCV_DET_SYNC (CLK, RESET_N, RCV_DET, RCV_DET_OUT); // synthesis syn_black_box

   input         CLK, RESET_N, RCV_DET;
   output        RCV_DET_OUT;
   reg           RCV_DET_OUT;
   reg 		 RCV_DET_MID; 	 

   always @ (posedge CLK or negedge RESET_N)
     if (!RESET_N)
       begin
	  RCV_DET_OUT <= 1'b0;
	  RCV_DET_MID <= 1'b0;
       end
     else
       begin
          RCV_DET_OUT <= RCV_DET_MID;
	  RCV_DET_MID <= RCV_DET;
       end

endmodule // rcv_det_sync
// receiver detect finite state machine
module stratixiigx_hssi_tx_rx_det_RCV_DET_FSM (CLK, RESET_N, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND); // synthesis syn_black_box

   input         CLK, RESET_N, COM_PASS, PROBE_PASS;
   
   output 	 RCV_FOUND, DET_ON, DETECT_VALID;
   reg [2:0] 	 STATE;
   reg [2:0] 	 NEXTSTATE;
   reg 		 RCV_FOUND, DET_ON, NEXT_RCV_FOUND, DETECT_VALID;
   
   reg		FAKE_RCV_PRESENT;
   
 // state definition
   parameter RESET   = 3'b000;
   parameter WAKE    = 3'b001;
   parameter STATE_1 = 3'b011;
   parameter STATE_2 = 3'b101;
   parameter HOLD    = 3'b100;
   
 
   initial
   begin
   	FAKE_RCV_PRESENT = 1'b1;
   end

// State logic and FSM
   always @ (posedge CLK or negedge RESET_N)
     if(!RESET_N)
       STATE <= RESET;
     else
       STATE <= NEXTSTATE;

   always @ (STATE or COM_PASS)
     begin
	case (STATE)
	  RESET: NEXTSTATE = WAKE;
	  WAKE: begin
	     if (COM_PASS) 
	     	NEXTSTATE = STATE_1;
	     else NEXTSTATE = WAKE;
	  end
	  STATE_1: NEXTSTATE = STATE_2;
	  STATE_2: NEXTSTATE = HOLD;
	  HOLD: NEXTSTATE = HOLD;
	  default: NEXTSTATE = RESET;
	endcase // case(state)
     end // always @ (state or com_pass)

// Output logic
   always @ (posedge CLK or negedge RESET_N)
     if(!RESET_N)
	  RCV_FOUND <= 1'b0;
     else
          RCV_FOUND <= NEXT_RCV_FOUND;

    always @ (NEXTSTATE or PROBE_PASS or FAKE_RCV_PRESENT)
      begin
	 if ((NEXTSTATE == STATE_2) && (!PROBE_PASS) && FAKE_RCV_PRESENT)  // probe pass goes up slow -> there is rx 
	   NEXT_RCV_FOUND = 1'b1;
	 else if ((NEXTSTATE == HOLD) && FAKE_RCV_PRESENT)
	   NEXT_RCV_FOUND = RCV_FOUND;
	 else    // probe pass goes up fast -> no rx
	   NEXT_RCV_FOUND = 1'b0;
      end
      
// there is no rcv_det_syn
   always @ (STATE)
     if (STATE == RESET)
       DET_ON = 1'b0;
     else
       DET_ON = 1'b1;
   	
   always @ (STATE)
     if (STATE == HOLD)
       DETECT_VALID = 1'b1;
     else
       DETECT_VALID = 1'b0;
   
endmodule // rcv_det_fsm
module stratixiigx_hssi_tx_rx_det_RCV_DET_CONTROL (CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND);
   input         CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS;
   output 	 DET_ON, DETECT_VALID, RCV_FOUND;
   wire 	 RCV_DET_SYN;
   
   stratixiigx_hssi_tx_rx_det_RCV_DET_SYNC  XRCV_DET_SYNC (CLK, RCV_DET_PDB, RCV_DET_EN, RCV_DET_SYN);
   stratixiigx_hssi_tx_rx_det_RCV_DET_FSM   XRCV_DET_FSM (CLK, RCV_DET_SYN, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND);
endmodule // rcv_det_control
// Digital part of the receiver detection
module stratixiigx_hssi_tx_rx_det_RCV_DET_DIGITAL (OSCCLK, RCV_DET_PDB, RCV_DET_EN, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND);

   input  OSCCLK, RCV_DET_PDB, RCV_DET_EN, COM_PASS, PROBE_PASS;
   output DET_ON, RCV_FOUND, DETECT_VALID;
   wire   CLK;

   stratixiigx_hssi_tx_rx_det_CLK_GEN         XCLK_GEN (OSCCLK, RCV_DET_PDB, CLK);
   stratixiigx_hssi_tx_rx_det_RCV_DET_CONTROL XRCV_DET_CTRL(CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND);
   
endmodule // rcv_det_digital
// This module is the behavior model for rx_det block
// If there is rx -  set parameter RX_EXIST to 1, set to 0 otherwise

`timescale 1ps / 1ps

module stratixiigx_hssi_tx_rx_det (RX_DET_PDB, CLK15M, TX_DET_RX, RX_FOUND, RX_DET_VALID);

input           RX_DET_PDB, CLK15M, TX_DET_RX;
output 	        RX_FOUND, RX_DET_VALID;
wire            RX_FOUND, RX_DET_VALID;
wire 	        COM_PASS, PROBE_PASS, DET_ON;
   
   parameter 	RX_EXIST = 1'b1;

   assign #100000	COM_PASS = DET_ON;
   assign #100000 	PROBE_PASS = ~RX_EXIST;
   
   
    
stratixiigx_hssi_tx_rx_det_RCV_DET_DIGITAL XRCV_DET_DIGITAL (.OSCCLK (CLK15M), 
				  .RCV_DET_PDB (RX_DET_PDB), 
				  .RCV_DET_EN (TX_DET_RX), 
				  .COM_PASS (COM_PASS), 
				  .PROBE_PASS (PROBE_PASS), 
				  .DET_ON (DET_ON),
				  .DETECT_VALID (RX_DET_VALID),
				  .RCV_FOUND (RX_FOUND));

endmodule // RX_DET

`timescale 1 ps / 1 ps
module stratixiigx_hssi_tx_ser (
    serialclk,
    parallelclk,
    datain,
    reset,
    elecreset,
    rseriallpbkdatain,
    rseriallpbkctrl,
    rdwidth,
    rdoublewidth,
    serialdataout,
    seriallpbkdataout,
    clkout
);

input serialclk;
input parallelclk;
input [19:0] datain;
input reset;
input elecreset;           // Z dataout buf
input rseriallpbkdatain;
input rseriallpbkctrl;
input rdwidth;             // 0 => 8-bit, 1 => 10-bit
input rdoublewidth;        // 0 => 8/10,  1 => 16/20

output serialdataout;
output seriallpbkdataout;
output clkout;             // = parallelclk/2 when doublewidth 

wire         dataout_tmp;
reg          VOP_int;      // serial data from serializer
wire   [9:0] PUDR;         // parallel data from Byte Deserializer

reg    [9:0] PUDR_int;     // one latency
reg    [9:0] PUDR_sync_1;  // second latency
reg    [9:0] PUDR_sync;    // may be 1 fastclk latency: loaded with cmuclk0

reg          CMUCLKL_sync_1;
reg          CMUCLKL_sync; // parallel clock synch'd to cmuclk0 - 2/3rd fastclk latency

reg    [3:0] cnt;
reg    [3:0] index;
reg    [3:0] cnt1;
wire         load_cnt;
wire         CMUCLK0;
wire         CMUCLK0_dly;
wire         CMUCLK0_dly2;

reg          elecreset1, elecreset2;
reg          elecreset_dly;   // delay electric idle

// Byte Deserializer
wire       mux_clkin;
wire [9:0] mux_a_in;
wire [9:0] mux_b_in;
reg        mux_clk_by2;
reg  [9:0] mux_a_in_sync;
reg  [9:0] mux_b_in_sync;
wire [9:0] mux_d;
wire       mux_select;
reg  [9:0] mux_dataout;
wire       mux_clkout;

assign mux_clkin = parallelclk;
assign mux_a_in = {datain[9],datain[8],datain[7],datain[6],datain[5],
                   datain[4],datain[3],datain[2],datain[1],datain[0]};
assign mux_b_in = {datain[19],datain[18],datain[17],datain[16],datain[15],
                   datain[14],datain[13],datain[12],datain[11],datain[10]};
assign PUDR = mux_dataout;
assign mux_clkout = (rdoublewidth === 1'b1) ? mux_clk_by2 : mux_clkin;

initial 
begin
    mux_clk_by2 = 1'b0;
end

always @(posedge reset or posedge mux_clkin)
begin
    if (reset === 1'b1)
        mux_clk_by2 <= 1'b0;
    else if (mux_clkin)
        mux_clk_by2 <= ~mux_clk_by2;
end 

always @(posedge reset or posedge mux_clkout)
begin
    if (reset === 1'b1)
        begin
            mux_a_in_sync <= 10'd0;
            mux_b_in_sync <= 10'd0;
        end
    else if (mux_clkout)
        begin
            mux_a_in_sync <= mux_a_in;
            mux_b_in_sync <= mux_b_in;
        end
end 

assign mux_select = (rdoublewidth === 1'b1 && mux_clk_by2 === 1'b1) ? 1'b1 : 1'b0;
assign mux_d = (rdoublewidth !== 1'b1) ? mux_a_in_sync : (mux_select === 1'b1) ? mux_a_in_sync : mux_b_in_sync;

always @(posedge reset or posedge mux_clkin)
begin
    if (reset === 1'b1)
        mux_dataout <= 10'd0;
    else if (mux_clkin)
        mux_dataout <= mux_d;
end 


initial
begin
    CMUCLKL_sync_1 = 1'b0;
    CMUCLKL_sync   = 1'b0;
    cnt            = 4'd8;
    cnt1           = 4'd9;
    PUDR_sync_1    = 10'd0;
    PUDR_int       = 10'd0;
    PUDR_sync      = 10'd0;
end

always @ (posedge parallelclk)
begin
    elecreset1 <= elecreset;
    elecreset2 <= elecreset1;
    elecreset_dly <= elecreset2;
end

assign seriallpbkdataout = VOP_int;

assign dataout_tmp = (rseriallpbkctrl === 1'b1) ? rseriallpbkdatain : VOP_int;
assign serialdataout = (elecreset_dly === 1'b1) ? 1'bz : dataout_tmp;
assign clkout = mux_clkout;

assign CMUCLK0 = serialclk;
assign #100 CMUCLK0_dly = serialclk;
assign #10  CMUCLK0_dly2 = CMUCLK0_dly;

// 110 ps phase offset on serial bit
always @ (CMUCLK0_dly2)
      VOP_int <= PUDR_sync[index];

// LFCLKP is synchronized by 2 flops
always @ (posedge reset or posedge CMUCLK0)
begin
   if (reset)
      begin
         CMUCLKL_sync_1   <= 1'b0;
         CMUCLKL_sync     <= 1'b0;
      end
   else
      begin
         CMUCLKL_sync_1   <= parallelclk;
         CMUCLKL_sync     <= CMUCLKL_sync_1;
      end
end

// Load counter with 0   at rising edge of syncd slow clock
assign load_cnt = CMUCLKL_sync_1 & ~CMUCLKL_sync;

// counter to div by 5
always @ (posedge reset or posedge CMUCLK0)
begin
   if (reset === 1'b1)
      begin
         cnt <= 4'd8;
         cnt1 <= 4'd9;
      end
   else if (load_cnt === 1'b1 || ((cnt>=4'd8) && rdwidth) || ((cnt>=4'd6) && ~rdwidth))
      begin
         cnt <= 4'd0;
         cnt1 <= 4'd1;
      end
   else
      begin
         cnt <= cnt + 2;
         cnt1 <= cnt1 + 2;
      end
end

// Latch PUDR_int using parallelclk
always @ (posedge reset or posedge parallelclk)
begin
   if (reset === 1'b1)
      begin
         PUDR_sync_1 <= 10'd0;
         PUDR_int <= 10'd0;
      end
   else
      begin
         PUDR_int <= PUDR;
         PUDR_sync_1 <= PUDR_int;
      end
end

// Latch PUDR_sync using CMUCLK0
always @ (posedge reset or posedge CMUCLK0)
begin
   if (reset === 1'b1)
      PUDR_sync <= 10'd0;
   else if (load_cnt === 1'b1)
      PUDR_sync <= {PUDR_sync_1[9], PUDR_sync_1[8], PUDR_sync_1[7], PUDR_sync_1[6],
                    PUDR_sync_1[5], PUDR_sync_1[4], PUDR_sync_1[3], PUDR_sync_1[2],
                    PUDR_sync_1[1], PUDR_sync_1[0]};
end

       
// index will change from 0 to 9 incrementally at 2x speed as CMUCLK0
always @ (CMUCLK0_dly or cnt or cnt1)
   if (CMUCLK0_dly)
      index <= cnt;  
   else
      index <= cnt1;

endmodule


// 
// no digital behavior to simulate
//

`timescale 1 ps / 1 ps
module stratixiigx_hssi_calibration_block (
    clk,
    powerdn,
    enabletestbus,
    calibrationstatus
);

input  clk;
input  powerdn;
input  enabletestbus;
output [4:0] calibrationstatus;

parameter use_continuous_calibration_mode = "false";
parameter rx_calibration_write_test_value = 0;
parameter tx_calibration_write_test_value = 0;
parameter enable_rx_calibration_test_write = "false";
parameter enable_tx_calibration_test_write = "false";
parameter send_rx_calibration_status = "true";

endmodule

//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 65 mux21 7 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_phystatus_generator
	( 
	clk,
	latched_p0,
	latched_p0s,
	latched_p1,
	latched_p2,
	phystat_ena,
	phystatus,
	power_state_transition_done,
	power_state_transition_done_ena,
	powerdown,
	reset_n,
	rphystatus_rst_toggle,
	rx_detect_valid) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   latched_p0;
	input   latched_p0s;
	input   latched_p1;
	input   latched_p2;
	input   phystat_ena;
	output   phystatus;
	input   power_state_transition_done;
	input   power_state_transition_done_ena;
	input   [1:0]  powerdown;
	input   reset_n;
	input   rphystatus_rst_toggle;
	input   rx_detect_valid;

	reg	nli0O27;
	reg	nli0O28;
	reg	nliil25;
	reg	nliil26;
	reg	nlili23;
	reg	nlili24;
	reg	nlilO21;
	reg	nlilO22;
	reg	nliOO19;
	reg	nliOO20;
	reg	nll0i15;
	reg	nll0i16;
	reg	nll0O13;
	reg	nll0O14;
	reg	nll1l17;
	reg	nll1l18;
	reg	nllil11;
	reg	nllil12;
	reg	nllli10;
	reg	nllli9;
	reg	nllll7;
	reg	nllll8;
	reg	nllOi5;
	reg	nllOi6;
	reg	nllOO3;
	reg	nllOO4;
	reg	nlO1l1;
	reg	nlO1l2;
	reg	n01i;
	reg	n1lO;
	reg	n1Oi;
	reg	n1Ol;
	reg	nl0l;
	reg	nl1O;
	reg	nl0i_clk_prev;
	wire	wire_nl0i_CLRN;
	wire	wire_nl0i_PRN;
	reg	n00i;
	reg	n00l;
	reg	n00O;
	reg	n01l;
	reg	n01O;
	reg	n0ii;
	reg	n0il;
	reg	n0iO;
	reg	n0li;
	reg	n10i;
	reg	n10l;
	reg	n10O;
	reg	n11i;
	reg	n11l;
	reg	n11O;
	reg	n1il;
	reg	n1iO;
	reg	n1li;
	reg	n1ll;
	reg	ni1i;
	reg	ni1l;
	reg	ni1O;
	reg	niii;
	reg	niil;
	reg	niiO;
	reg	nili;
	reg	niOi;
	reg	niOl;
	reg	niOO;
	reg	nl1l;
	reg	nlOOO;
	wire	wire_nl1i_CLRN;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nlll_dataout;
	wire  nliOl;
	wire  nlliO;
	wire  nlllO;

	initial
		nli0O27 = 0;
	always @ ( posedge clk)
		  nli0O27 <= nli0O28;
	event nli0O27_event;
	initial
		#1 ->nli0O27_event;
	always @(nli0O27_event)
		nli0O27 <= {1{1'b1}};
	initial
		nli0O28 = 0;
	always @ ( posedge clk)
		  nli0O28 <= nli0O27;
	initial
		nliil25 = 0;
	always @ ( posedge clk)
		  nliil25 <= nliil26;
	event nliil25_event;
	initial
		#1 ->nliil25_event;
	always @(nliil25_event)
		nliil25 <= {1{1'b1}};
	initial
		nliil26 = 0;
	always @ ( posedge clk)
		  nliil26 <= nliil25;
	initial
		nlili23 = 0;
	always @ ( posedge clk)
		  nlili23 <= nlili24;
	event nlili23_event;
	initial
		#1 ->nlili23_event;
	always @(nlili23_event)
		nlili23 <= {1{1'b1}};
	initial
		nlili24 = 0;
	always @ ( posedge clk)
		  nlili24 <= nlili23;
	initial
		nlilO21 = 0;
	always @ ( posedge clk)
		  nlilO21 <= nlilO22;
	event nlilO21_event;
	initial
		#1 ->nlilO21_event;
	always @(nlilO21_event)
		nlilO21 <= {1{1'b1}};
	initial
		nlilO22 = 0;
	always @ ( posedge clk)
		  nlilO22 <= nlilO21;
	initial
		nliOO19 = 0;
	always @ ( posedge clk)
		  nliOO19 <= nliOO20;
	event nliOO19_event;
	initial
		#1 ->nliOO19_event;
	always @(nliOO19_event)
		nliOO19 <= {1{1'b1}};
	initial
		nliOO20 = 0;
	always @ ( posedge clk)
		  nliOO20 <= nliOO19;
	initial
		nll0i15 = 0;
	always @ ( posedge clk)
		  nll0i15 <= nll0i16;
	event nll0i15_event;
	initial
		#1 ->nll0i15_event;
	always @(nll0i15_event)
		nll0i15 <= {1{1'b1}};
	initial
		nll0i16 = 0;
	always @ ( posedge clk)
		  nll0i16 <= nll0i15;
	initial
		nll0O13 = 0;
	always @ ( posedge clk)
		  nll0O13 <= nll0O14;
	event nll0O13_event;
	initial
		#1 ->nll0O13_event;
	always @(nll0O13_event)
		nll0O13 <= {1{1'b1}};
	initial
		nll0O14 = 0;
	always @ ( posedge clk)
		  nll0O14 <= nll0O13;
	initial
		nll1l17 = 0;
	always @ ( posedge clk)
		  nll1l17 <= nll1l18;
	event nll1l17_event;
	initial
		#1 ->nll1l17_event;
	always @(nll1l17_event)
		nll1l17 <= {1{1'b1}};
	initial
		nll1l18 = 0;
	always @ ( posedge clk)
		  nll1l18 <= nll1l17;
	initial
		nllil11 = 0;
	always @ ( posedge clk)
		  nllil11 <= nllil12;
	event nllil11_event;
	initial
		#1 ->nllil11_event;
	always @(nllil11_event)
		nllil11 <= {1{1'b1}};
	initial
		nllil12 = 0;
	always @ ( posedge clk)
		  nllil12 <= nllil11;
	initial
		nllli10 = 0;
	always @ ( posedge clk)
		  nllli10 <= nllli9;
	initial
		nllli9 = 0;
	always @ ( posedge clk)
		  nllli9 <= nllli10;
	event nllli9_event;
	initial
		#1 ->nllli9_event;
	always @(nllli9_event)
		nllli9 <= {1{1'b1}};
	initial
		nllll7 = 0;
	always @ ( posedge clk)
		  nllll7 <= nllll8;
	event nllll7_event;
	initial
		#1 ->nllll7_event;
	always @(nllll7_event)
		nllll7 <= {1{1'b1}};
	initial
		nllll8 = 0;
	always @ ( posedge clk)
		  nllll8 <= nllll7;
	initial
		nllOi5 = 0;
	always @ ( posedge clk)
		  nllOi5 <= nllOi6;
	event nllOi5_event;
	initial
		#1 ->nllOi5_event;
	always @(nllOi5_event)
		nllOi5 <= {1{1'b1}};
	initial
		nllOi6 = 0;
	always @ ( posedge clk)
		  nllOi6 <= nllOi5;
	initial
		nllOO3 = 0;
	always @ ( posedge clk)
		  nllOO3 <= nllOO4;
	event nllOO3_event;
	initial
		#1 ->nllOO3_event;
	always @(nllOO3_event)
		nllOO3 <= {1{1'b1}};
	initial
		nllOO4 = 0;
	always @ ( posedge clk)
		  nllOO4 <= nllOO3;
	initial
		nlO1l1 = 0;
	always @ ( posedge clk)
		  nlO1l1 <= nlO1l2;
	event nlO1l1_event;
	initial
		#1 ->nlO1l1_event;
	always @(nlO1l1_event)
		nlO1l1 <= {1{1'b1}};
	initial
		nlO1l2 = 0;
	always @ ( posedge clk)
		  nlO1l2 <= nlO1l1;
	initial
	begin
		n01i = 0;
		n1lO = 0;
		n1Oi = 0;
		n1Ol = 0;
	end
	always @ ( posedge clk or  negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			n01i <= 0;
			n1lO <= 0;
			n1Oi <= 0;
			n1Ol <= 0;
		end
		else if  (nliOl == 1'b1) 
		begin
			n01i <= n00l;
			n1lO <= n01l;
			n1Oi <= n01O;
			n1Ol <= n00i;
		end
	end
	initial
	begin
		nl0l = 0;
		nl1O = 0;
	end
	always @ (clk or wire_nl0i_PRN or wire_nl0i_CLRN)
	begin
		if (wire_nl0i_PRN == 1'b0) 
		begin
			nl0l <= 1;
			nl1O <= 1;
		end
		else if  (wire_nl0i_CLRN == 1'b0) 
		begin
			nl0l <= 0;
			nl1O <= 0;
		end
		else 
		if (clk != nl0i_clk_prev && clk == 1'b1) 
		begin
			nl0l <= nlllO;
			nl1O <= wire_nl0O_dataout;
		end
		nl0i_clk_prev <= clk;
	end
	assign
		wire_nl0i_CLRN = (nllll8 ^ nllll7),
		wire_nl0i_PRN = ((nllli10 ^ nllli9) & reset_n);
	initial
	begin
		n00i = 0;
		n00l = 0;
		n00O = 0;
		n01l = 0;
		n01O = 0;
		n0ii = 0;
		n0il = 0;
		n0iO = 0;
		n0li = 0;
		n10i = 0;
		n10l = 0;
		n10O = 0;
		n11i = 0;
		n11l = 0;
		n11O = 0;
		n1il = 0;
		n1iO = 0;
		n1li = 0;
		n1ll = 0;
		ni1i = 0;
		ni1l = 0;
		ni1O = 0;
		niii = 0;
		niil = 0;
		niiO = 0;
		nili = 0;
		niOi = 0;
		niOl = 0;
		niOO = 0;
		nl1l = 0;
		nlOOO = 0;
	end
	always @ ( posedge clk or  negedge wire_nl1i_CLRN)
	begin
		if (wire_nl1i_CLRN == 1'b0) 
		begin
			n00i <= 0;
			n00l <= 0;
			n00O <= 0;
			n01l <= 0;
			n01O <= 0;
			n0ii <= 0;
			n0il <= 0;
			n0iO <= 0;
			n0li <= 0;
			n10i <= 0;
			n10l <= 0;
			n10O <= 0;
			n11i <= 0;
			n11l <= 0;
			n11O <= 0;
			n1il <= 0;
			n1iO <= 0;
			n1li <= 0;
			n1ll <= 0;
			ni1i <= 0;
			ni1l <= 0;
			ni1O <= 0;
			niii <= 0;
			niil <= 0;
			niiO <= 0;
			nili <= 0;
			niOi <= 0;
			niOl <= 0;
			niOO <= 0;
			nl1l <= 0;
			nlOOO <= 0;
		end
		else 
		begin
			n00i <= n0il;
			n00l <= n0iO;
			n00O <= latched_p0;
			n01l <= n00O;
			n01O <= n0ii;
			n0ii <= latched_p0s;
			n0il <= latched_p1;
			n0iO <= latched_p2;
			n0li <= nlOOO;
			n10i <= n10l;
			n10l <= (((phystat_ena & (~ power_state_transition_done_ena)) & n10O) & (nli0O28 ^ nli0O27));
			n10O <= (~ (((((~ ((n1lO ^ n1il) ^ (~ (nlilO22 ^ nlilO21)))) & (~ ((n1Oi ^ n1iO) ^ (~ (nlili24 ^ nlili23))))) & (~ (n1Ol ^ n1li))) & (~ (n01i ^ n1ll))) & (nliil26 ^ nliil25)));
			n11i <= n11l;
			n11l <= n11O;
			n11O <= n10i;
			n1il <= n1lO;
			n1iO <= n1Oi;
			n1li <= n1Ol;
			n1ll <= n01i;
			ni1i <= ni1l;
			ni1l <= wire_nlil_dataout;
			ni1O <= ((rx_detect_valid & niil) & (~ niii));
			niii <= rx_detect_valid;
			niil <= niiO;
			niiO <= latched_p1;
			nili <= wire_nliO_dataout;
			niOi <= wire_ni0i_dataout;
			niOl <= niOO;
			niOO <= nl1l;
			nl1l <= power_state_transition_done;
			nlOOO <= n11i;
		end
	end
	assign
		wire_nl1i_CLRN = ((nllil12 ^ nllil11) & reset_n);
	or(wire_ni0i_dataout, wire_ni0l_dataout, (((~ wire_nlil_dataout) & ni1l) & (nll0O14 ^ nll0O13)));
	and(wire_ni0l_dataout, niOi, ~(wire_nliO_dataout));
	and(wire_nl0O_dataout, wire_nlii_dataout, ~(rphystatus_rst_toggle));
	and(wire_nlii_dataout, nl1O, ~(wire_nliO_dataout));
	and(wire_nlil_dataout, phystat_ena, (powerdown[0] & powerdown[1]));
	assign		wire_nliO_dataout = (power_state_transition_done_ena === 1'b1) ? (niOO & (~ niOl)) : n0li;
	or(wire_nlll_dataout, (((((nl0l | nili) | (~ (nlO1l2 ^ nlO1l1))) | ni1O) | nl1O) | (~ (nllOO4 ^ nllOO3))), ((((~ wire_nlil_dataout) & ni1i) | niOi) | (~ (nllOi6 ^ nllOi5))));
	assign
		nliOl = ((((((((~ n00l) & (~ n00i)) & (~ n01O)) & n01l) | (((((~ n00l) & (~ n00i)) & n01O) & (~ n01l)) & (nll0i16 ^ nll0i15))) | ((((~ n00l) & n00i) & (~ n01O)) & (~ n01l))) | (~ (nll1l18 ^ nll1l17))) | ((((n00l & (~ n00i)) & (~ n01O)) & (~ n01l)) & (nliOO20 ^ nliOO19))),
		nlliO = 1'b1,
		nlllO = 1'b0,
		phystatus = wire_nlll_dataout;
endmodule //stratixiigx_hssi_phystatus_generator
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 125 mux21 128 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_rx_pipe_interface
	( 
	clk,
	latched_p0,
	latched_p0s,
	latched_p1,
	latched_p2,
	polinv_rx,
	polinv_rx_int,
	rclkcmpinsertpad,
	reset_n,
	rrdwidth_rx,
	rrx_pipe_enable,
	rx_detect_valid,
	rx_detect_valid_sync,
	rx_found,
	rxbeacon,
	rxd,
	rxd_ch,
	rxelecidle,
	rxelectricalidle,
	rxpolarity,
	rxstatus,
	rxvalid) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   latched_p0;
	input   latched_p0s;
	input   latched_p1;
	input   latched_p2;
	input   polinv_rx;
	output   polinv_rx_int;
	input   rclkcmpinsertpad;
	input   reset_n;
	input   rrdwidth_rx;
	input   rrx_pipe_enable;
	input   rx_detect_valid;
	input   rx_detect_valid_sync;
	input   rx_found;
	input   rxbeacon;
	input   [63:0]  rxd;
	output   [63:0]  rxd_ch;
	output   rxelecidle;
	input   rxelectricalidle;
	input   rxpolarity;
	output   [2:0]  rxstatus;
	output   rxvalid;

	reg	nlllli41;
	reg	nlllli42;
	reg	nllllO39;
	reg	nllllO40;
	reg	nlllOl37;
	reg	nlllOl38;
	reg	nllO0i35;
	reg	nllO0i36;
	reg	nllOii33;
	reg	nllOii34;
	reg	nllOll31;
	reg	nllOll32;
	reg	nllOOl29;
	reg	nllOOl30;
	reg	nlO00O15;
	reg	nlO00O16;
	reg	nlO01l17;
	reg	nlO01l18;
	reg	nlO0ll13;
	reg	nlO0ll14;
	reg	nlO0Ol11;
	reg	nlO0Ol12;
	reg	nlO10l25;
	reg	nlO10l26;
	reg	nlO11i27;
	reg	nlO11i28;
	reg	nlO1ii23;
	reg	nlO1ii24;
	reg	nlO1iO21;
	reg	nlO1iO22;
	reg	nlO1Ol19;
	reg	nlO1Ol20;
	reg	nlOi0l7;
	reg	nlOi0l8;
	reg	nlOi1l10;
	reg	nlOi1l9;
	reg	nlOili5;
	reg	nlOili6;
	reg	nlOiOi3;
	reg	nlOiOi4;
	reg	nlOiOl1;
	reg	nlOiOl2;
	reg	n100l;
	reg	n100O;
	reg	n10i;
	reg	n10ii;
	reg	n10il;
	reg	n10iO;
	reg	n11il;
	reg	n11iO;
	reg	n11li;
	reg	n1lil;
	reg	n1lli;
	reg	n1llO;
	reg	niO0i;
	reg	niO0l;
	reg	niO0O;
	reg	niO1l;
	reg	niO1O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOli;
	reg	niOll;
	reg	niOlO;
	reg	niOOi;
	reg	niOOl;
	reg	niOOO;
	reg	nl00i;
	reg	nl00l;
	reg	nl00O;
	reg	nl01i;
	reg	nl01l;
	reg	nl01O;
	reg	nl0ii;
	reg	nl0il;
	reg	nl0iO;
	reg	nl0li;
	reg	nl0ll;
	reg	nl0lO;
	reg	nl0Oi;
	reg	nl0Ol;
	reg	nl0OO;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	nl1OO;
	reg	nli0i;
	reg	nli0l;
	reg	nli0O;
	reg	nli1i;
	reg	nli1l;
	reg	nli1O;
	reg	nliii;
	reg	nliil;
	reg	nliiO;
	reg	nlili;
	reg	nlill;
	reg	nlilO;
	reg	nliOi;
	reg	nliOl;
	reg	nliOO;
	reg	nll0i;
	reg	nll0l;
	reg	nll0O;
	reg	nll1i;
	reg	nll1l;
	reg	nll1O;
	reg	nlOli;
	reg	nlOliO;
	reg	nlOlli;
	reg	nlOlll;
	reg	nlOllO;
	reg	nlOlOi;
	wire	wire_n11O_CLRN;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n11ll_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO0i_dataout;
	wire	wire_nlOO0l_dataout;
	wire	wire_nlOO0O_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOO1l_dataout;
	wire	wire_nlOO1O_dataout;
	wire	wire_nlOOii_dataout;
	wire	wire_nlOOil_dataout;
	wire	wire_nlOOiO_dataout;
	wire	wire_nlOOli_dataout;
	wire	wire_nlOOll_dataout;
	wire	wire_nlOOlO_dataout;
	wire	wire_nlOOOi_dataout;
	wire	wire_nlOOOl_dataout;
	wire	wire_nO_dataout;
	wire  nllO0O;
	wire  nllO1i;
	wire  nllO1l;
	wire  nllO1O;
	wire  nllOiO;
	wire  nllOli;
	wire  nllOOi;
	wire  nlO00i;
	wire  nlO00l;
	wire  nlO01i;
	wire  nlO0il;
	wire  nlO0iO;
	wire  nlO0li;
	wire  nlO0Oi;
	wire  nlO10i;
	wire  nlO11O;
	wire  nlO1ll;
	wire  nlO1lO;
	wire  nlO1Oi;
	wire  nlOi0i;
	wire  nlOi1i;
	wire  nlOiii;
	wire  nlOiil;
	wire  nlOiiO;
	wire  nlOilO;

	initial
		nlllli41 = 0;
	always @ ( posedge clk)
		  nlllli41 <= nlllli42;
	event nlllli41_event;
	initial
		#1 ->nlllli41_event;
	always @(nlllli41_event)
		nlllli41 <= {1{1'b1}};
	initial
		nlllli42 = 0;
	always @ ( posedge clk)
		  nlllli42 <= nlllli41;
	initial
		nllllO39 = 0;
	always @ ( posedge clk)
		  nllllO39 <= nllllO40;
	event nllllO39_event;
	initial
		#1 ->nllllO39_event;
	always @(nllllO39_event)
		nllllO39 <= {1{1'b1}};
	initial
		nllllO40 = 0;
	always @ ( posedge clk)
		  nllllO40 <= nllllO39;
	initial
		nlllOl37 = 0;
	always @ ( posedge clk)
		  nlllOl37 <= nlllOl38;
	event nlllOl37_event;
	initial
		#1 ->nlllOl37_event;
	always @(nlllOl37_event)
		nlllOl37 <= {1{1'b1}};
	initial
		nlllOl38 = 0;
	always @ ( posedge clk)
		  nlllOl38 <= nlllOl37;
	initial
		nllO0i35 = 0;
	always @ ( posedge clk)
		  nllO0i35 <= nllO0i36;
	event nllO0i35_event;
	initial
		#1 ->nllO0i35_event;
	always @(nllO0i35_event)
		nllO0i35 <= {1{1'b1}};
	initial
		nllO0i36 = 0;
	always @ ( posedge clk)
		  nllO0i36 <= nllO0i35;
	initial
		nllOii33 = 0;
	always @ ( posedge clk)
		  nllOii33 <= nllOii34;
	event nllOii33_event;
	initial
		#1 ->nllOii33_event;
	always @(nllOii33_event)
		nllOii33 <= {1{1'b1}};
	initial
		nllOii34 = 0;
	always @ ( posedge clk)
		  nllOii34 <= nllOii33;
	initial
		nllOll31 = 0;
	always @ ( posedge clk)
		  nllOll31 <= nllOll32;
	event nllOll31_event;
	initial
		#1 ->nllOll31_event;
	always @(nllOll31_event)
		nllOll31 <= {1{1'b1}};
	initial
		nllOll32 = 0;
	always @ ( posedge clk)
		  nllOll32 <= nllOll31;
	initial
		nllOOl29 = 0;
	always @ ( posedge clk)
		  nllOOl29 <= nllOOl30;
	event nllOOl29_event;
	initial
		#1 ->nllOOl29_event;
	always @(nllOOl29_event)
		nllOOl29 <= {1{1'b1}};
	initial
		nllOOl30 = 0;
	always @ ( posedge clk)
		  nllOOl30 <= nllOOl29;
	initial
		nlO00O15 = 0;
	always @ ( posedge clk)
		  nlO00O15 <= nlO00O16;
	event nlO00O15_event;
	initial
		#1 ->nlO00O15_event;
	always @(nlO00O15_event)
		nlO00O15 <= {1{1'b1}};
	initial
		nlO00O16 = 0;
	always @ ( posedge clk)
		  nlO00O16 <= nlO00O15;
	initial
		nlO01l17 = 0;
	always @ ( posedge clk)
		  nlO01l17 <= nlO01l18;
	event nlO01l17_event;
	initial
		#1 ->nlO01l17_event;
	always @(nlO01l17_event)
		nlO01l17 <= {1{1'b1}};
	initial
		nlO01l18 = 0;
	always @ ( posedge clk)
		  nlO01l18 <= nlO01l17;
	initial
		nlO0ll13 = 0;
	always @ ( posedge clk)
		  nlO0ll13 <= nlO0ll14;
	event nlO0ll13_event;
	initial
		#1 ->nlO0ll13_event;
	always @(nlO0ll13_event)
		nlO0ll13 <= {1{1'b1}};
	initial
		nlO0ll14 = 0;
	always @ ( posedge clk)
		  nlO0ll14 <= nlO0ll13;
	initial
		nlO0Ol11 = 0;
	always @ ( posedge clk)
		  nlO0Ol11 <= nlO0Ol12;
	event nlO0Ol11_event;
	initial
		#1 ->nlO0Ol11_event;
	always @(nlO0Ol11_event)
		nlO0Ol11 <= {1{1'b1}};
	initial
		nlO0Ol12 = 0;
	always @ ( posedge clk)
		  nlO0Ol12 <= nlO0Ol11;
	initial
		nlO10l25 = 0;
	always @ ( posedge clk)
		  nlO10l25 <= nlO10l26;
	event nlO10l25_event;
	initial
		#1 ->nlO10l25_event;
	always @(nlO10l25_event)
		nlO10l25 <= {1{1'b1}};
	initial
		nlO10l26 = 0;
	always @ ( posedge clk)
		  nlO10l26 <= nlO10l25;
	initial
		nlO11i27 = 0;
	always @ ( posedge clk)
		  nlO11i27 <= nlO11i28;
	event nlO11i27_event;
	initial
		#1 ->nlO11i27_event;
	always @(nlO11i27_event)
		nlO11i27 <= {1{1'b1}};
	initial
		nlO11i28 = 0;
	always @ ( posedge clk)
		  nlO11i28 <= nlO11i27;
	initial
		nlO1ii23 = 0;
	always @ ( posedge clk)
		  nlO1ii23 <= nlO1ii24;
	event nlO1ii23_event;
	initial
		#1 ->nlO1ii23_event;
	always @(nlO1ii23_event)
		nlO1ii23 <= {1{1'b1}};
	initial
		nlO1ii24 = 0;
	always @ ( posedge clk)
		  nlO1ii24 <= nlO1ii23;
	initial
		nlO1iO21 = 0;
	always @ ( posedge clk)
		  nlO1iO21 <= nlO1iO22;
	event nlO1iO21_event;
	initial
		#1 ->nlO1iO21_event;
	always @(nlO1iO21_event)
		nlO1iO21 <= {1{1'b1}};
	initial
		nlO1iO22 = 0;
	always @ ( posedge clk)
		  nlO1iO22 <= nlO1iO21;
	initial
		nlO1Ol19 = 0;
	always @ ( posedge clk)
		  nlO1Ol19 <= nlO1Ol20;
	event nlO1Ol19_event;
	initial
		#1 ->nlO1Ol19_event;
	always @(nlO1Ol19_event)
		nlO1Ol19 <= {1{1'b1}};
	initial
		nlO1Ol20 = 0;
	always @ ( posedge clk)
		  nlO1Ol20 <= nlO1Ol19;
	initial
		nlOi0l7 = 0;
	always @ ( posedge clk)
		  nlOi0l7 <= nlOi0l8;
	event nlOi0l7_event;
	initial
		#1 ->nlOi0l7_event;
	always @(nlOi0l7_event)
		nlOi0l7 <= {1{1'b1}};
	initial
		nlOi0l8 = 0;
	always @ ( posedge clk)
		  nlOi0l8 <= nlOi0l7;
	initial
		nlOi1l10 = 0;
	always @ ( posedge clk)
		  nlOi1l10 <= nlOi1l9;
	initial
		nlOi1l9 = 0;
	always @ ( posedge clk)
		  nlOi1l9 <= nlOi1l10;
	event nlOi1l9_event;
	initial
		#1 ->nlOi1l9_event;
	always @(nlOi1l9_event)
		nlOi1l9 <= {1{1'b1}};
	initial
		nlOili5 = 0;
	always @ ( posedge clk)
		  nlOili5 <= nlOili6;
	event nlOili5_event;
	initial
		#1 ->nlOili5_event;
	always @(nlOili5_event)
		nlOili5 <= {1{1'b1}};
	initial
		nlOili6 = 0;
	always @ ( posedge clk)
		  nlOili6 <= nlOili5;
	initial
		nlOiOi3 = 0;
	always @ ( posedge clk)
		  nlOiOi3 <= nlOiOi4;
	event nlOiOi3_event;
	initial
		#1 ->nlOiOi3_event;
	always @(nlOiOi3_event)
		nlOiOi3 <= {1{1'b1}};
	initial
		nlOiOi4 = 0;
	always @ ( posedge clk)
		  nlOiOi4 <= nlOiOi3;
	initial
		nlOiOl1 = 0;
	always @ ( posedge clk)
		  nlOiOl1 <= nlOiOl2;
	event nlOiOl1_event;
	initial
		#1 ->nlOiOl1_event;
	always @(nlOiOl1_event)
		nlOiOl1 <= {1{1'b1}};
	initial
		nlOiOl2 = 0;
	always @ ( posedge clk)
		  nlOiOl2 <= nlOiOl1;
	initial
	begin
		n100l = 0;
		n100O = 0;
		n10i = 0;
		n10ii = 0;
		n10il = 0;
		n10iO = 0;
		n11il = 0;
		n11iO = 0;
		n11li = 0;
		n1lil = 0;
		n1lli = 0;
		n1llO = 0;
		niO0i = 0;
		niO0l = 0;
		niO0O = 0;
		niO1l = 0;
		niO1O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOli = 0;
		niOll = 0;
		niOlO = 0;
		niOOi = 0;
		niOOl = 0;
		niOOO = 0;
		nl00i = 0;
		nl00l = 0;
		nl00O = 0;
		nl01i = 0;
		nl01l = 0;
		nl01O = 0;
		nl0ii = 0;
		nl0il = 0;
		nl0iO = 0;
		nl0li = 0;
		nl0ll = 0;
		nl0lO = 0;
		nl0Oi = 0;
		nl0Ol = 0;
		nl0OO = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
		nl1OO = 0;
		nli0i = 0;
		nli0l = 0;
		nli0O = 0;
		nli1i = 0;
		nli1l = 0;
		nli1O = 0;
		nliii = 0;
		nliil = 0;
		nliiO = 0;
		nlili = 0;
		nlill = 0;
		nlilO = 0;
		nliOi = 0;
		nliOl = 0;
		nliOO = 0;
		nll0i = 0;
		nll0l = 0;
		nll0O = 0;
		nll1i = 0;
		nll1l = 0;
		nll1O = 0;
		nlOli = 0;
		nlOliO = 0;
		nlOlli = 0;
		nlOlll = 0;
		nlOllO = 0;
		nlOlOi = 0;
	end
	always @ ( posedge clk or  negedge wire_n11O_CLRN)
	begin
		if (wire_n11O_CLRN == 1'b0) 
		begin
			n100l <= 0;
			n100O <= 0;
			n10i <= 0;
			n10ii <= 0;
			n10il <= 0;
			n10iO <= 0;
			n11il <= 0;
			n11iO <= 0;
			n11li <= 0;
			n1lil <= 0;
			n1lli <= 0;
			n1llO <= 0;
			niO0i <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niO1l <= 0;
			niO1O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOli <= 0;
			niOll <= 0;
			niOlO <= 0;
			niOOi <= 0;
			niOOl <= 0;
			niOOO <= 0;
			nl00i <= 0;
			nl00l <= 0;
			nl00O <= 0;
			nl01i <= 0;
			nl01l <= 0;
			nl01O <= 0;
			nl0ii <= 0;
			nl0il <= 0;
			nl0iO <= 0;
			nl0li <= 0;
			nl0ll <= 0;
			nl0lO <= 0;
			nl0Oi <= 0;
			nl0Ol <= 0;
			nl0OO <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
			nl1OO <= 0;
			nli0i <= 0;
			nli0l <= 0;
			nli0O <= 0;
			nli1i <= 0;
			nli1l <= 0;
			nli1O <= 0;
			nliii <= 0;
			nliil <= 0;
			nliiO <= 0;
			nlili <= 0;
			nlill <= 0;
			nlilO <= 0;
			nliOi <= 0;
			nliOl <= 0;
			nliOO <= 0;
			nll0i <= 0;
			nll0l <= 0;
			nll0O <= 0;
			nll1i <= 0;
			nll1l <= 0;
			nll1O <= 0;
			nlOli <= 0;
			nlOliO <= 0;
			nlOlli <= 0;
			nlOlll <= 0;
			nlOllO <= 0;
			nlOlOi <= 0;
		end
		else 
		begin
			n100l <= wire_n10li_dataout;
			n100O <= wire_n10ll_dataout;
			n10i <= wire_n1ii_dataout;
			n10ii <= wire_n10lO_dataout;
			n10il <= wire_n10Oi_dataout;
			n10iO <= wire_n1liO_dataout;
			n11il <= rxd[9];
			n11iO <= wire_n11ll_dataout;
			n11li <= rx_detect_valid_sync;
			n1lil <= wire_n1lll_dataout;
			n1lli <= wire_n1lOi_dataout;
			n1llO <= rx_detect_valid_sync;
			niO0i <= rxd[3];
			niO0l <= rxd[4];
			niO0O <= rxd[5];
			niO1l <= rxd[1];
			niO1O <= rxd[2];
			niOii <= rxd[6];
			niOil <= rxd[7];
			niOiO <= rxd[8];
			niOli <= rxd[9];
			niOll <= rxd[10];
			niOlO <= rxd[11];
			niOOi <= rxd[12];
			niOOl <= rxd[13];
			niOOO <= rxd[14];
			nl00i <= rxd[33];
			nl00l <= rxd[34];
			nl00O <= rxd[35];
			nl01i <= rxd[30];
			nl01l <= rxd[31];
			nl01O <= rxd[32];
			nl0ii <= rxd[36];
			nl0il <= rxd[37];
			nl0iO <= rxd[38];
			nl0li <= rxd[39];
			nl0ll <= rxd[40];
			nl0lO <= rxd[41];
			nl0Oi <= rxd[42];
			nl0Ol <= rxd[43];
			nl0OO <= rxd[44];
			nl10i <= rxd[18];
			nl10l <= rxd[19];
			nl10O <= rxd[20];
			nl11i <= rxd[15];
			nl11l <= rxd[16];
			nl11O <= rxd[17];
			nl1ii <= rxd[21];
			nl1il <= rxd[22];
			nl1iO <= rxd[23];
			nl1li <= rxd[24];
			nl1ll <= rxd[25];
			nl1lO <= rxd[26];
			nl1Oi <= rxd[27];
			nl1Ol <= rxd[28];
			nl1OO <= rxd[29];
			nli0i <= rxd[48];
			nli0l <= rxd[49];
			nli0O <= rxd[50];
			nli1i <= rxd[45];
			nli1l <= rxd[46];
			nli1O <= rxd[47];
			nliii <= rxd[51];
			nliil <= rxd[52];
			nliiO <= rxd[53];
			nlili <= rxd[54];
			nlill <= rxd[55];
			nlilO <= rxd[56];
			nliOi <= rxd[57];
			nliOl <= rxd[58];
			nliOO <= rxd[59];
			nll0i <= rxd[63];
			nll0l <= rxpolarity;
			nll0O <= wire_n10l_dataout;
			nll1i <= rxd[60];
			nll1l <= rxd[61];
			nll1O <= rxd[62];
			nlOli <= rxd[0];
			nlOliO <= wire_nlOlOl_dataout;
			nlOlli <= wire_nlOlOO_dataout;
			nlOlll <= wire_nlOO1i_dataout;
			nlOllO <= wire_nlOO1l_dataout;
			nlOlOi <= rxd[11];
		end
	end
	assign
		wire_n11O_CLRN = ((nlOiOi4 ^ nlOiOi3) & reset_n);
	assign		wire_n00i_dataout = (rrx_pipe_enable === 1'b1) ? niOil : rxd[7];
	assign		wire_n00l_dataout = (rrx_pipe_enable === 1'b1) ? niOiO : rxd[8];
	assign		wire_n00O_dataout = (rrx_pipe_enable === 1'b1) ? niOli : rxd[9];
	assign		wire_n01i_dataout = (rrx_pipe_enable === 1'b1) ? niO0l : rxd[4];
	assign		wire_n01l_dataout = (rrx_pipe_enable === 1'b1) ? niO0O : rxd[5];
	assign		wire_n01O_dataout = (rrx_pipe_enable === 1'b1) ? niOii : rxd[6];
	assign		wire_n0i_dataout = (rrx_pipe_enable === 1'b1) ? nliil : rxd[52];
	assign		wire_n0ii_dataout = (rrx_pipe_enable === 1'b1) ? niOll : rxd[10];
	assign		wire_n0il_dataout = (rrx_pipe_enable === 1'b1) ? niOlO : rxd[11];
	assign		wire_n0iO_dataout = (rrx_pipe_enable === 1'b1) ? niOOi : rxd[12];
	assign		wire_n0l_dataout = (rrx_pipe_enable === 1'b1) ? nliiO : rxd[53];
	assign		wire_n0li_dataout = (rrx_pipe_enable === 1'b1) ? niOOl : rxd[13];
	assign		wire_n0ll_dataout = (rrx_pipe_enable === 1'b1) ? niOOO : rxd[14];
	assign		wire_n0lO_dataout = (rrx_pipe_enable === 1'b1) ? nl11i : rxd[15];
	assign		wire_n0O_dataout = (rrx_pipe_enable === 1'b1) ? nlili : rxd[54];
	assign		wire_n0Oi_dataout = (rrx_pipe_enable === 1'b1) ? nl11l : rxd[16];
	assign		wire_n0Ol_dataout = (rrx_pipe_enable === 1'b1) ? nl11O : rxd[17];
	assign		wire_n0OO_dataout = (rrx_pipe_enable === 1'b1) ? nl10i : rxd[18];
	and(wire_n10l_dataout, rxelectricalidle, ~((latched_p2 & rxbeacon)));
	and(wire_n10li_dataout, wire_n10Ol_dataout, ~((~ rrdwidth_rx)));
	and(wire_n10ll_dataout, wire_n10OO_dataout, ~((~ rrdwidth_rx)));
	and(wire_n10lO_dataout, wire_n1i1i_dataout, ~((~ rrdwidth_rx)));
	and(wire_n10Oi_dataout, wire_n1i1l_dataout, ~((~ rrdwidth_rx)));
	and(wire_n10Ol_dataout, wire_n1i1O_dataout, ~(nlO1ll));
	and(wire_n10OO_dataout, nlO1lO, ~(nlO1ll));
	and(wire_n11ll_dataout, (((rx_found & rx_detect_valid_sync) & (nlO10l26 ^ nlO10l25)) & (~ n11li)), latched_p1);
	assign		wire_n1i_dataout = (rrx_pipe_enable === 1'b1) ? nli0l : rxd[49];
	and(wire_n1i0i_dataout, wire_n1iii_dataout, ~(nlO1lO));
	and(wire_n1i0l_dataout, wire_n1iil_dataout, ~(nlO1lO));
	and(wire_n1i0O_dataout, wire_n1iiO_dataout, ~(nlO0il));
	and(wire_n1i1i_dataout, wire_n1i0i_dataout, ~(nlO1ll));
	and(wire_n1i1l_dataout, wire_n1i0l_dataout, ~(nlO1ll));
	and(wire_n1i1O_dataout, wire_n1i0O_dataout, ~(nlO1lO));
	assign		wire_n1ii_dataout = (rrdwidth_rx === 1'b1) ? ((rxd[10] & rxd[42]) & (nlOiOl2 ^ nlOiOl1)) : rxd[10];
	or(wire_n1iii_dataout, wire_n1ili_dataout, nlO0il);
	and(wire_n1iil_dataout, wire_n1ill_dataout, ~(nlO0il));
	or(wire_n1iiO_dataout, wire_n1ilO_dataout, nlO00l);
	and(wire_n1ili_dataout, nlO01i, ~(nlO00l));
	and(wire_n1ill_dataout, wire_n1iOi_dataout, ~(nlO00l));
	and(wire_n1ilO_dataout, nlO1Oi, ~(nlO01i));
	assign		wire_n1iO_dataout = (rrx_pipe_enable === 1'b1) ? nll0O : rxelectricalidle;
	and(wire_n1iOi_dataout, wire_n1iOl_dataout, ~(nlO01i));
	and(wire_n1iOl_dataout, (rxd[45] & rxd[46]), ~(nlO1Oi));
	assign		wire_n1l_dataout = (rrx_pipe_enable === 1'b1) ? nli0O : rxd[50];
	and(wire_n1li_dataout, n10i, rrx_pipe_enable);
	and(wire_n1liO_dataout, rxd[43], rrdwidth_rx);
	assign		wire_n1ll_dataout = (rrx_pipe_enable === 1'b1) ? nll0l : polinv_rx;
	and(wire_n1lll_dataout, rxd[41], rrdwidth_rx);
	assign		wire_n1lO_dataout = (rrx_pipe_enable === 1'b1) ? nlOli : rxd[0];
	and(wire_n1lOi_dataout, wire_n1lOl_dataout, rrdwidth_rx);
	and(wire_n1lOl_dataout, (((rx_found & rx_detect_valid_sync) & (nlO0ll14 ^ nlO0ll13)) & (~ n1llO)), latched_p1);
	assign		wire_n1O_dataout = (rrx_pipe_enable === 1'b1) ? nliii : rxd[51];
	assign		wire_n1Oi_dataout = (rrx_pipe_enable === 1'b1) ? niO1l : rxd[1];
	assign		wire_n1Ol_dataout = (rrx_pipe_enable === 1'b1) ? niO1O : rxd[2];
	assign		wire_n1OO_dataout = (rrx_pipe_enable === 1'b1) ? niO0i : rxd[3];
	assign		wire_ni_dataout = (rrx_pipe_enable === 1'b1) ? nll1l : rxd[61];
	assign		wire_ni0i_dataout = (rrx_pipe_enable === 1'b1) ? nl1il : rxd[22];
	assign		wire_ni0l_dataout = (rrx_pipe_enable === 1'b1) ? nl1iO : rxd[23];
	assign		wire_ni0O_dataout = (rrx_pipe_enable === 1'b1) ? nl1li : rxd[24];
	assign		wire_ni1i_dataout = (rrx_pipe_enable === 1'b1) ? nl10l : rxd[19];
	assign		wire_ni1l_dataout = (rrx_pipe_enable === 1'b1) ? nl10O : rxd[20];
	assign		wire_ni1O_dataout = (rrx_pipe_enable === 1'b1) ? nl1ii : rxd[21];
	assign		wire_nii_dataout = (rrx_pipe_enable === 1'b1) ? nlill : rxd[55];
	assign		wire_niii_dataout = (rrx_pipe_enable === 1'b1) ? nl1ll : rxd[25];
	assign		wire_niil_dataout = (rrx_pipe_enable === 1'b1) ? nl1lO : rxd[26];
	assign		wire_niiO_dataout = (rrx_pipe_enable === 1'b1) ? nl1Oi : rxd[27];
	assign		wire_nil_dataout = (rrx_pipe_enable === 1'b1) ? nlilO : rxd[56];
	assign		wire_nili_dataout = (rrx_pipe_enable === 1'b1) ? nl1Ol : rxd[28];
	assign		wire_nill_dataout = (rrx_pipe_enable === 1'b1) ? nl1OO : rxd[29];
	assign		wire_nilO_dataout = (rrx_pipe_enable === 1'b1) ? nl01i : rxd[30];
	assign		wire_niO_dataout = (rrx_pipe_enable === 1'b1) ? nliOi : rxd[57];
	assign		wire_niOi_dataout = (rrx_pipe_enable === 1'b1) ? nl01l : rxd[31];
	assign		wire_niOl_dataout = (rrx_pipe_enable === 1'b1) ? nl01O : rxd[32];
	assign		wire_niOO_dataout = (rrx_pipe_enable === 1'b1) ? nl00i : rxd[33];
	assign		wire_nl_dataout = (rrx_pipe_enable === 1'b1) ? nll1O : rxd[62];
	assign		wire_nl0i_dataout = (rrx_pipe_enable === 1'b1) ? nl0il : rxd[37];
	assign		wire_nl0l_dataout = (rrx_pipe_enable === 1'b1) ? nl0iO : rxd[38];
	assign		wire_nl0O_dataout = (rrx_pipe_enable === 1'b1) ? nl0li : rxd[39];
	assign		wire_nl1i_dataout = (rrx_pipe_enable === 1'b1) ? nl00l : rxd[34];
	assign		wire_nl1l_dataout = (rrx_pipe_enable === 1'b1) ? nl00O : rxd[35];
	assign		wire_nl1O_dataout = (rrx_pipe_enable === 1'b1) ? nl0ii : rxd[36];
	assign		wire_nli_dataout = (rrx_pipe_enable === 1'b1) ? nliOl : rxd[58];
	assign		wire_nlii_dataout = (rrx_pipe_enable === 1'b1) ? nl0ll : rxd[40];
	assign		wire_nlil_dataout = (rrx_pipe_enable === 1'b1) ? nl0lO : rxd[41];
	assign		wire_nliO_dataout = (rrx_pipe_enable === 1'b1) ? nl0Oi : rxd[42];
	assign		wire_nll_dataout = (rrx_pipe_enable === 1'b1) ? nliOO : rxd[59];
	assign		wire_nlli_dataout = (rrx_pipe_enable === 1'b1) ? nl0Ol : rxd[43];
	assign		wire_nllii_dataout = ((~ rrx_pipe_enable) === 1'b1) ? rx_found : wire_nllli_dataout;
	assign		wire_nllil_dataout = ((~ rrx_pipe_enable) === 1'b1) ? rx_detect_valid : wire_nllll_dataout;
	assign		wire_nlliO_dataout = ((~ rrx_pipe_enable) === 1'b1) ? rxbeacon : wire_nlllO_dataout;
	assign		wire_nlll_dataout = (rrx_pipe_enable === 1'b1) ? nl0OO : rxd[44];
	or(wire_nllli_dataout, wire_nllOi_dataout, nlOiiO);
	or(wire_nllll_dataout, wire_nllOl_dataout, nlOiiO);
	and(wire_nlllO_dataout, wire_nllOO_dataout, ~(nlOiiO));
	assign		wire_nllO_dataout = (rrx_pipe_enable === 1'b1) ? nli1i : rxd[45];
	and(wire_nllOi_dataout, wire_nlO1i_dataout, ~(nlOiil));
	and(wire_nllOl_dataout, wire_nlO1l_dataout, ~(nlOiil));
	or(wire_nllOO_dataout, wire_nlO1O_dataout, nlOiil);
	assign		wire_nlO_dataout = (rrx_pipe_enable === 1'b1) ? nll1i : rxd[60];
	and(wire_nlO0i_dataout, wire_nlOii_dataout, ~(nlOi0i));
	or(wire_nlO0l_dataout, wire_nlOil_dataout, nlOi0i);
	or(wire_nlO0O_dataout, nlOi1i, nlOi0i);
	or(wire_nlO1i_dataout, wire_nlO0i_dataout, nlOiii);
	and(wire_nlO1l_dataout, wire_nlO0l_dataout, ~(nlOiii));
	or(wire_nlO1O_dataout, wire_nlO0O_dataout, nlOiii);
	assign		wire_nlOi_dataout = (rrx_pipe_enable === 1'b1) ? nli1l : rxd[46];
	or(wire_nlOii_dataout, wire_nlOiO_dataout, nlOi1i);
	or(wire_nlOil_dataout, nlO0Oi, nlOi1i);
	and(wire_nlOiO_dataout, (nlOliO | n100l), ~(nlO0Oi));
	assign		wire_nlOl_dataout = (rrx_pipe_enable === 1'b1) ? nli1O : rxd[47];
	and(wire_nlOlOl_dataout, wire_nlOO1O_dataout, ~(nllO1i));
	and(wire_nlOlOO_dataout, nllO1l, ~(nllO1i));
	assign		wire_nlOO_dataout = (rrx_pipe_enable === 1'b1) ? nli0i : rxd[48];
	and(wire_nlOO0i_dataout, wire_nlOOii_dataout, ~(nllO1l));
	and(wire_nlOO0l_dataout, wire_nlOOil_dataout, ~(nllO1l));
	and(wire_nlOO0O_dataout, wire_nlOOiO_dataout, ~(nllOOi));
	and(wire_nlOO1i_dataout, wire_nlOO0i_dataout, ~(nllO1i));
	and(wire_nlOO1l_dataout, wire_nlOO0l_dataout, ~(nllO1i));
	and(wire_nlOO1O_dataout, wire_nlOO0O_dataout, ~(nllO1l));
	or(wire_nlOOii_dataout, wire_nlOOli_dataout, nllOOi);
	and(wire_nlOOil_dataout, wire_nlOOll_dataout, ~(nllOOi));
	or(wire_nlOOiO_dataout, wire_nlOOlO_dataout, nllOli);
	and(wire_nlOOli_dataout, nllO0O, ~(nllOli));
	and(wire_nlOOll_dataout, wire_nlOOOi_dataout, ~(nllOli));
	and(wire_nlOOlO_dataout, nllO1O, ~(nllO0O));
	and(wire_nlOOOi_dataout, wire_nlOOOl_dataout, ~(nllO0O));
	and(wire_nlOOOl_dataout, (rxd[13] & rxd[14]), ~(nllO1O));
	assign		wire_nO_dataout = (rrx_pipe_enable === 1'b1) ? nll0i : rxd[63];
	assign
		nllO0O = (rclkcmpinsertpad & ((nlO11O & nllOiO) & (nllOii34 ^ nllOii33))),
		nllO1i = (((~ rxd[13]) & (~ rxd[14])) & (nlllOl38 ^ nlllOl37)),
		nllO1l = (rxd[13] & (~ rxd[14])),
		nllO1O = (rclkcmpinsertpad & ((nlO11O & (~ nllOiO)) & (nllO0i36 ^ nllO0i35))),
		nllOiO = ((((((((rxd[0] & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (nlllli42 ^ nlllli41)),
		nllOli = ((~ rclkcmpinsertpad) & (((~ nlO10i) & nlO11O) & (nllOll32 ^ nllOll31))),
		nllOOi = (((~ rclkcmpinsertpad) & ((nlO10i & nlO11O) & (nlO11i28 ^ nlO11i27))) & (nllOOl30 ^ nllOOl29)),
		nlO00i = (((((((rxd[32] & rxd[33]) & rxd[34]) & (~ rxd[35])) & rxd[36]) & rxd[37]) & rxd[38]) & rxd[39]),
		nlO00l = ((~ rclkcmpinsertpad) & (((~ nlO0li) & nlO0iO) & (nlO00O16 ^ nlO00O15))),
		nlO01i = ((rclkcmpinsertpad & (nlO0iO & nlO00i)) & (nlO01l18 ^ nlO01l17)),
		nlO0il = ((~ rclkcmpinsertpad) & (nlO0li & nlO0iO)),
		nlO0iO = ((~ rxd[45]) & rxd[46]),
		nlO0li = (((((((((~ rxd[32]) & rxd[33]) & rxd[34]) & rxd[35]) & rxd[36]) & rxd[37]) & rxd[38]) & rxd[39]) & (nlO1ii24 ^ nlO1ii23)),
		nlO0Oi = ((nlOlli | n100O) | (~ (nlO0Ol12 ^ nlO0Ol11))),
		nlO10i = ((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		nlO11O = (((~ rxd[13]) & rxd[14]) & (nllllO40 ^ nllllO39)),
		nlO1ll = ((~ rxd[45]) & (~ rxd[46])),
		nlO1lO = ((rxd[45] & (~ rxd[46])) & (nlO1iO22 ^ nlO1iO21)),
		nlO1Oi = (rclkcmpinsertpad & ((nlO0iO & (~ nlO00i)) & (nlO1Ol20 ^ nlO1Ol19))),
		nlOi0i = ((nlOlll | n10ii) | (~ (nlOi0l8 ^ nlOi0l7))),
		nlOi1i = ((nlOlOi | n10iO) | (~ (nlOi1l10 ^ nlOi1l9))),
		nlOiii = (nlOllO | n10il),
		nlOiil = (n11il | n1lil),
		nlOiiO = ((n11iO | n1lli) | (~ (nlOili6 ^ nlOili5))),
		nlOilO = 1'b1,
		polinv_rx_int = wire_n1ll_dataout,
		rxd_ch = {wire_nO_dataout, wire_nl_dataout, wire_ni_dataout, wire_nlO_dataout, wire_nll_dataout, wire_nli_dataout, wire_niO_dataout, wire_nil_dataout, wire_nii_dataout, wire_n0O_dataout, wire_n0l_dataout, wire_n0i_dataout, wire_n1O_dataout, wire_n1l_dataout, wire_n1i_dataout, wire_nlOO_dataout, wire_nlOl_dataout, wire_nlOi_dataout, wire_nllO_dataout, wire_nlll_dataout, wire_nlli_dataout, wire_nliO_dataout, wire_nlil_dataout, wire_nlii_dataout, wire_nl0O_dataout, wire_nl0l_dataout, wire_nl0i_dataout, wire_nl1O_dataout, wire_nl1l_dataout, wire_nl1i_dataout, wire_niOO_dataout, wire_niOl_dataout, wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout},
		rxelecidle = wire_n1iO_dataout,
		rxstatus = {wire_nlliO_dataout, wire_nllil_dataout, wire_nllii_dataout},
		rxvalid = wire_n1li_dataout;
endmodule //stratixiigx_hssi_rx_pipe_interface
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 86 mux21 56 oper_mux 1 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_pipe_interface
	( 
	clk,
	powerdown,
	powerstate,
	refclk_b,
	refclk_b_reset_n,
	reset_n,
	rev_loopbk,
	revloopback,
	rtx_elec_idle_delay,
	rtx_pipe_enable,
	tx_elec_idle,
	tx_elec_idle_comp,
	txbeacon,
	txcompliance,
	txd,
	txd_ch,
	txdetectrx,
	txdetectrxloopback,
	txelecidle) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   [1:0]  powerdown;
	output   [3:0]  powerstate;
	input   refclk_b;
	input   refclk_b_reset_n;
	input   reset_n;
	output   rev_loopbk;
	input   revloopback;
	input   [1:0]  rtx_elec_idle_delay;
	input   rtx_pipe_enable;
	output   tx_elec_idle;
	input   tx_elec_idle_comp;
	output   txbeacon;
	input   txcompliance;
	output   [43:0]  txd;
	input   [43:0]  txd_ch;
	output   txdetectrx;
	input   txdetectrxloopback;
	input   txelecidle;

	reg	n00li27;
	reg	n00li28;
	reg	n00lO25;
	reg	n00lO26;
	reg	n00Ol23;
	reg	n00Ol24;
	reg	n0i0O17;
	reg	n0i0O18;
	reg	n0i1i21;
	reg	n0i1i22;
	reg	n0i1O19;
	reg	n0i1O20;
	reg	n0iii15;
	reg	n0iii16;
	reg	n0ili13;
	reg	n0ili14;
	reg	n0ilO11;
	reg	n0ilO12;
	reg	n0iOl10;
	reg	n0iOl9;
	reg	n0l0l3;
	reg	n0l0l4;
	reg	n0l1i7;
	reg	n0l1i8;
	reg	n0l1O5;
	reg	n0l1O6;
	reg	n0lii1;
	reg	n0lii2;
	reg	n0OOl;
	reg	ni11i;
	reg	ni0lO;
	reg	ni0ll_clk_prev;
	wire	wire_ni0ll_CLRN;
	reg	n0Oli;
	reg	n0Oll;
	reg	n0OlO;
	reg	n0OOi;
	reg	ni1ii;
	wire	wire_ni10O_PRN;
	reg	ni11O;
	wire	wire_ni11l_ENA;
	reg	n0lOl;
	reg	n0lOO;
	reg	n0O0i;
	reg	n0O1i;
	reg	ni00O;
	reg	ni01i;
	reg	ni0Oi;
	reg	ni0Ol;
	reg	ni0OO;
	reg	nii0i;
	reg	nii0l;
	reg	nii0O;
	reg	nii1i;
	reg	nii1l;
	reg	nii1O;
	reg	niiii;
	reg	niiil;
	reg	niiiO;
	reg	niili;
	reg	niill;
	reg	niilO;
	reg	niiOi;
	reg	niiOl;
	reg	niiOO;
	reg	nil0i;
	reg	nil0l;
	reg	nil0O;
	reg	nil1i;
	reg	nil1l;
	reg	nil1O;
	reg	nilii;
	reg	nilil;
	reg	niliO;
	reg	nilli;
	reg	nilll;
	reg	nillO;
	reg	nilOi;
	reg	nilOl;
	reg	nilOO;
	reg	niO0i;
	reg	niO0l;
	reg	niO0O;
	reg	niO1i;
	reg	niO1l;
	reg	niO1O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOll;
	wire	wire_niOli_CLRN;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni00l_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni0ii_dataout;
	wire	wire_ni0il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1ll_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl01l_dataout;
	wire	wire_nl01O_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1iO_dataout;
	wire	wire_nl1li_dataout;
	wire	wire_nl1ll_dataout;
	wire	wire_nl1lO_dataout;
	wire	wire_nl1Oi_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nl1OO_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nlili_dataout;
	wire  wire_n0OiO_o;
	wire  n0i0l;
	wire  n0iiO;
	wire  n0ill;
	wire  n0l0O;

	initial
		n00li27 = 0;
	always @ ( posedge clk)
		  n00li27 <= n00li28;
	event n00li27_event;
	initial
		#1 ->n00li27_event;
	always @(n00li27_event)
		n00li27 <= {1{1'b1}};
	initial
		n00li28 = 0;
	always @ ( posedge clk)
		  n00li28 <= n00li27;
	initial
		n00lO25 = 0;
	always @ ( posedge clk)
		  n00lO25 <= n00lO26;
	event n00lO25_event;
	initial
		#1 ->n00lO25_event;
	always @(n00lO25_event)
		n00lO25 <= {1{1'b1}};
	initial
		n00lO26 = 0;
	always @ ( posedge clk)
		  n00lO26 <= n00lO25;
	initial
		n00Ol23 = 0;
	always @ ( posedge clk)
		  n00Ol23 <= n00Ol24;
	event n00Ol23_event;
	initial
		#1 ->n00Ol23_event;
	always @(n00Ol23_event)
		n00Ol23 <= {1{1'b1}};
	initial
		n00Ol24 = 0;
	always @ ( posedge clk)
		  n00Ol24 <= n00Ol23;
	initial
		n0i0O17 = 0;
	always @ ( posedge clk)
		  n0i0O17 <= n0i0O18;
	event n0i0O17_event;
	initial
		#1 ->n0i0O17_event;
	always @(n0i0O17_event)
		n0i0O17 <= {1{1'b1}};
	initial
		n0i0O18 = 0;
	always @ ( posedge clk)
		  n0i0O18 <= n0i0O17;
	initial
		n0i1i21 = 0;
	always @ ( posedge clk)
		  n0i1i21 <= n0i1i22;
	event n0i1i21_event;
	initial
		#1 ->n0i1i21_event;
	always @(n0i1i21_event)
		n0i1i21 <= {1{1'b1}};
	initial
		n0i1i22 = 0;
	always @ ( posedge clk)
		  n0i1i22 <= n0i1i21;
	initial
		n0i1O19 = 0;
	always @ ( posedge clk)
		  n0i1O19 <= n0i1O20;
	event n0i1O19_event;
	initial
		#1 ->n0i1O19_event;
	always @(n0i1O19_event)
		n0i1O19 <= {1{1'b1}};
	initial
		n0i1O20 = 0;
	always @ ( posedge clk)
		  n0i1O20 <= n0i1O19;
	initial
		n0iii15 = 0;
	always @ ( posedge clk)
		  n0iii15 <= n0iii16;
	event n0iii15_event;
	initial
		#1 ->n0iii15_event;
	always @(n0iii15_event)
		n0iii15 <= {1{1'b1}};
	initial
		n0iii16 = 0;
	always @ ( posedge clk)
		  n0iii16 <= n0iii15;
	initial
		n0ili13 = 0;
	always @ ( posedge clk)
		  n0ili13 <= n0ili14;
	event n0ili13_event;
	initial
		#1 ->n0ili13_event;
	always @(n0ili13_event)
		n0ili13 <= {1{1'b1}};
	initial
		n0ili14 = 0;
	always @ ( posedge clk)
		  n0ili14 <= n0ili13;
	initial
		n0ilO11 = 0;
	always @ ( posedge clk)
		  n0ilO11 <= n0ilO12;
	event n0ilO11_event;
	initial
		#1 ->n0ilO11_event;
	always @(n0ilO11_event)
		n0ilO11 <= {1{1'b1}};
	initial
		n0ilO12 = 0;
	always @ ( posedge clk)
		  n0ilO12 <= n0ilO11;
	initial
		n0iOl10 = 0;
	always @ ( posedge clk)
		  n0iOl10 <= n0iOl9;
	initial
		n0iOl9 = 0;
	always @ ( posedge clk)
		  n0iOl9 <= n0iOl10;
	event n0iOl9_event;
	initial
		#1 ->n0iOl9_event;
	always @(n0iOl9_event)
		n0iOl9 <= {1{1'b1}};
	initial
		n0l0l3 = 0;
	always @ ( posedge clk)
		  n0l0l3 <= n0l0l4;
	event n0l0l3_event;
	initial
		#1 ->n0l0l3_event;
	always @(n0l0l3_event)
		n0l0l3 <= {1{1'b1}};
	initial
		n0l0l4 = 0;
	always @ ( posedge clk)
		  n0l0l4 <= n0l0l3;
	initial
		n0l1i7 = 0;
	always @ ( posedge clk)
		  n0l1i7 <= n0l1i8;
	event n0l1i7_event;
	initial
		#1 ->n0l1i7_event;
	always @(n0l1i7_event)
		n0l1i7 <= {1{1'b1}};
	initial
		n0l1i8 = 0;
	always @ ( posedge clk)
		  n0l1i8 <= n0l1i7;
	initial
		n0l1O5 = 0;
	always @ ( posedge clk)
		  n0l1O5 <= n0l1O6;
	event n0l1O5_event;
	initial
		#1 ->n0l1O5_event;
	always @(n0l1O5_event)
		n0l1O5 <= {1{1'b1}};
	initial
		n0l1O6 = 0;
	always @ ( posedge clk)
		  n0l1O6 <= n0l1O5;
	initial
		n0lii1 = 0;
	always @ ( posedge clk)
		  n0lii1 <= n0lii2;
	event n0lii1_event;
	initial
		#1 ->n0lii1_event;
	always @(n0lii1_event)
		n0lii1 <= {1{1'b1}};
	initial
		n0lii2 = 0;
	always @ ( posedge clk)
		  n0lii2 <= n0lii1;
	initial
	begin
		n0OOl = 0;
		ni11i = 0;
	end
	always @ ( posedge refclk_b or  negedge refclk_b_reset_n)
	begin
		if (refclk_b_reset_n == 1'b0) 
		begin
			n0OOl <= 0;
			ni11i <= 0;
		end
		else 
		begin
			n0OOl <= ni11i;
			ni11i <= tx_elec_idle_comp;
		end
	end
	initial
	begin
		ni0lO = 0;
	end
	always @ (clk or reset_n or wire_ni0ll_CLRN)
	begin
		if (reset_n == 1'b0) 
		begin
			ni0lO <= 1;
		end
		else if  (wire_ni0ll_CLRN == 1'b0) 
		begin
			ni0lO <= 0;
		end
		else 
		if (clk != ni0ll_clk_prev && clk == 1'b1) 
		begin
			ni0lO <= txelecidle;
		end
		ni0ll_clk_prev <= clk;
	end
	assign
		wire_ni0ll_CLRN = (n0l0l4 ^ n0l0l3);
	initial
	begin
		n0Oli = 0;
		n0Oll = 0;
		n0OlO = 0;
		n0OOi = 0;
		ni1ii = 0;
	end
	always @ ( posedge refclk_b or  negedge wire_ni10O_PRN)
	begin
		if (wire_ni10O_PRN == 1'b0) 
		begin
			n0Oli <= 1;
			n0Oll <= 1;
			n0OlO <= 1;
			n0OOi <= 1;
			ni1ii <= 1;
		end
		else 
		begin
			n0Oli <= n0Oll;
			n0Oll <= n0OlO;
			n0OlO <= n0OOi;
			n0OOi <= n0ill;
			ni1ii <= n0Oli;
		end
	end
	assign
		wire_ni10O_PRN = ((n0ili14 ^ n0ili13) & refclk_b_reset_n);
	initial
	begin
		ni11O = 0;
	end
	always @ ( posedge refclk_b or  negedge refclk_b_reset_n)
	begin
		if (refclk_b_reset_n == 1'b0) 
		begin
			ni11O <= 1;
		end
		else if  (wire_ni11l_ENA == 1'b1) 
		begin
			ni11O <= n0iiO;
		end
	end
	assign
		wire_ni11l_ENA = (((ni11O & ni11i) & (~ n0OOl)) & (n0iii16 ^ n0iii15));
	initial
	begin
		n0lOl = 0;
		n0lOO = 0;
		n0O0i = 0;
		n0O1i = 0;
		ni00O = 0;
		ni01i = 0;
		ni0Oi = 0;
		ni0Ol = 0;
		ni0OO = 0;
		nii0i = 0;
		nii0l = 0;
		nii0O = 0;
		nii1i = 0;
		nii1l = 0;
		nii1O = 0;
		niiii = 0;
		niiil = 0;
		niiiO = 0;
		niili = 0;
		niill = 0;
		niilO = 0;
		niiOi = 0;
		niiOl = 0;
		niiOO = 0;
		nil0i = 0;
		nil0l = 0;
		nil0O = 0;
		nil1i = 0;
		nil1l = 0;
		nil1O = 0;
		nilii = 0;
		nilil = 0;
		niliO = 0;
		nilli = 0;
		nilll = 0;
		nillO = 0;
		nilOi = 0;
		nilOl = 0;
		nilOO = 0;
		niO0i = 0;
		niO0l = 0;
		niO0O = 0;
		niO1i = 0;
		niO1l = 0;
		niO1O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOll = 0;
	end
	always @ ( posedge clk or  negedge wire_niOli_CLRN)
	begin
		if (wire_niOli_CLRN == 1'b0) 
		begin
			n0lOl <= 0;
			n0lOO <= 0;
			n0O0i <= 0;
			n0O1i <= 0;
			ni00O <= 0;
			ni01i <= 0;
			ni0Oi <= 0;
			ni0Ol <= 0;
			ni0OO <= 0;
			nii0i <= 0;
			nii0l <= 0;
			nii0O <= 0;
			nii1i <= 0;
			nii1l <= 0;
			nii1O <= 0;
			niiii <= 0;
			niiil <= 0;
			niiiO <= 0;
			niili <= 0;
			niill <= 0;
			niilO <= 0;
			niiOi <= 0;
			niiOl <= 0;
			niiOO <= 0;
			nil0i <= 0;
			nil0l <= 0;
			nil0O <= 0;
			nil1i <= 0;
			nil1l <= 0;
			nil1O <= 0;
			nilii <= 0;
			nilil <= 0;
			niliO <= 0;
			nilli <= 0;
			nilll <= 0;
			nillO <= 0;
			nilOi <= 0;
			nilOl <= 0;
			nilOO <= 0;
			niO0i <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niO1i <= 0;
			niO1l <= 0;
			niO1O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOll <= 0;
		end
		else 
		begin
			n0lOl <= ((rtx_pipe_enable & (((~ powerdown[0]) & powerdown[1]) & (n00Ol24 ^ n00Ol23))) & (n00lO26 ^ n00lO25));
			n0lOO <= (rtx_pipe_enable & ((powerdown[0] & (~ powerdown[1])) & (n0i1i22 ^ n0i1i21)));
			n0O0i <= (rtx_pipe_enable & ((powerdown[0] & powerdown[1]) & (n0i1O20 ^ n0i1O19)));
			n0O1i <= (rtx_pipe_enable & n0i0l);
			ni00O <= txelecidle;
			ni01i <= txdetectrxloopback;
			ni0Oi <= txcompliance;
			ni0Ol <= txd_ch[0];
			ni0OO <= txd_ch[1];
			nii0i <= txd_ch[5];
			nii0l <= txd_ch[6];
			nii0O <= txd_ch[7];
			nii1i <= txd_ch[2];
			nii1l <= txd_ch[3];
			nii1O <= txd_ch[4];
			niiii <= txd_ch[8];
			niiil <= txd_ch[9];
			niiiO <= txd_ch[11];
			niili <= txd_ch[12];
			niill <= txd_ch[13];
			niilO <= txd_ch[14];
			niiOi <= txd_ch[15];
			niiOl <= txd_ch[16];
			niiOO <= txd_ch[17];
			nil0i <= txd_ch[21];
			nil0l <= txd_ch[22];
			nil0O <= txd_ch[23];
			nil1i <= txd_ch[18];
			nil1l <= txd_ch[19];
			nil1O <= txd_ch[20];
			nilii <= txd_ch[24];
			nilil <= txd_ch[25];
			niliO <= txd_ch[26];
			nilli <= txd_ch[27];
			nilll <= txd_ch[28];
			nillO <= txd_ch[29];
			nilOi <= txd_ch[30];
			nilOl <= txd_ch[33];
			nilOO <= wire_n0Oii_dataout;
			niO0i <= txd_ch[37];
			niO0l <= txd_ch[38];
			niO0O <= txd_ch[39];
			niO1i <= txd_ch[34];
			niO1l <= txd_ch[35];
			niO1O <= txd_ch[36];
			niOii <= txd_ch[40];
			niOil <= txd_ch[41];
			niOiO <= txd_ch[42];
			niOll <= txd_ch[43];
		end
	end
	assign
		wire_niOli_CLRN = ((n0lii2 ^ n0lii1) & reset_n);
	and(wire_n0Oii_dataout, rtx_pipe_enable, n0i0l);
	assign		wire_n0Oil_dataout = ((~ n0ill) === 1'b1) ? n0OOi : wire_n0OiO_o;
	and(wire_ni00i_dataout, n0lOl, rtx_pipe_enable);
	and(wire_ni00l_dataout, n0O0i, rtx_pipe_enable);
	and(wire_ni01l_dataout, n0O1i, rtx_pipe_enable);
	and(wire_ni01O_dataout, n0lOO, rtx_pipe_enable);
	or(wire_ni0ii_dataout, wire_ni0il_dataout, (nilOO & ni0Oi));
	and(wire_ni0il_dataout, niiil, ~(((nilOO & (~ ni0Oi)) & (n0l1O6 ^ n0l1O5))));
	and(wire_ni1iO_dataout, (((~ ni00O) & n0O0i) & (n0iOl10 ^ n0iOl9)), ~((~ rtx_pipe_enable)));
	assign		wire_ni1ll_dataout = ((~ rtx_pipe_enable) === 1'b1) ? txdetectrxloopback : ((ni01i & n0lOl) & (n0l1i8 ^ n0l1i7));
	assign		wire_ni1Oi_dataout = ((~ rtx_pipe_enable) === 1'b1) ? txelecidle : wire_n0Oil_dataout;
	assign		wire_ni1Ol_dataout = ((~ rtx_pipe_enable) === 1'b1) ? revloopback : (ni01i & n0O1i);
	assign		wire_niOlO_dataout = (rtx_pipe_enable === 1'b1) ? ni0Ol : txd_ch[0];
	assign		wire_niOOi_dataout = (rtx_pipe_enable === 1'b1) ? ni0OO : txd_ch[1];
	assign		wire_niOOl_dataout = (rtx_pipe_enable === 1'b1) ? nii1i : txd_ch[2];
	assign		wire_niOOO_dataout = (rtx_pipe_enable === 1'b1) ? nii1l : txd_ch[3];
	assign		wire_nl00i_dataout = (rtx_pipe_enable === 1'b1) ? nil0l : txd_ch[22];
	assign		wire_nl00l_dataout = (rtx_pipe_enable === 1'b1) ? nil0O : txd_ch[23];
	assign		wire_nl00O_dataout = (rtx_pipe_enable === 1'b1) ? nilii : txd_ch[24];
	assign		wire_nl01i_dataout = (rtx_pipe_enable === 1'b1) ? nil1l : txd_ch[19];
	assign		wire_nl01l_dataout = (rtx_pipe_enable === 1'b1) ? nil1O : txd_ch[20];
	assign		wire_nl01O_dataout = (rtx_pipe_enable === 1'b1) ? nil0i : txd_ch[21];
	assign		wire_nl0ii_dataout = (rtx_pipe_enable === 1'b1) ? nilil : txd_ch[25];
	assign		wire_nl0il_dataout = (rtx_pipe_enable === 1'b1) ? niliO : txd_ch[26];
	assign		wire_nl0iO_dataout = (rtx_pipe_enable === 1'b1) ? nilli : txd_ch[27];
	assign		wire_nl0li_dataout = (rtx_pipe_enable === 1'b1) ? nilll : txd_ch[28];
	assign		wire_nl0ll_dataout = (rtx_pipe_enable === 1'b1) ? nillO : txd_ch[29];
	assign		wire_nl0lO_dataout = (rtx_pipe_enable === 1'b1) ? nilOi : txd_ch[30];
	and(wire_nl0Oi_dataout, txd_ch[31], ~(rtx_pipe_enable));
	assign		wire_nl0Ol_dataout = (rtx_pipe_enable === 1'b1) ? ni0lO : txd_ch[32];
	assign		wire_nl0OO_dataout = (rtx_pipe_enable === 1'b1) ? nilOl : txd_ch[33];
	assign		wire_nl10i_dataout = (rtx_pipe_enable === 1'b1) ? nii0O : txd_ch[7];
	assign		wire_nl10l_dataout = (rtx_pipe_enable === 1'b1) ? niiii : txd_ch[8];
	assign		wire_nl10O_dataout = (rtx_pipe_enable === 1'b1) ? wire_ni0ii_dataout : txd_ch[9];
	assign		wire_nl11i_dataout = (rtx_pipe_enable === 1'b1) ? nii1O : txd_ch[4];
	assign		wire_nl11l_dataout = (rtx_pipe_enable === 1'b1) ? nii0i : txd_ch[5];
	assign		wire_nl11O_dataout = (rtx_pipe_enable === 1'b1) ? nii0l : txd_ch[6];
	assign		wire_nl1ii_dataout = (rtx_pipe_enable === 1'b1) ? ni0lO : txd_ch[10];
	assign		wire_nl1il_dataout = (rtx_pipe_enable === 1'b1) ? niiiO : txd_ch[11];
	assign		wire_nl1iO_dataout = (rtx_pipe_enable === 1'b1) ? niili : txd_ch[12];
	assign		wire_nl1li_dataout = (rtx_pipe_enable === 1'b1) ? niill : txd_ch[13];
	assign		wire_nl1ll_dataout = (rtx_pipe_enable === 1'b1) ? niilO : txd_ch[14];
	assign		wire_nl1lO_dataout = (rtx_pipe_enable === 1'b1) ? niiOi : txd_ch[15];
	assign		wire_nl1Oi_dataout = (rtx_pipe_enable === 1'b1) ? niiOl : txd_ch[16];
	assign		wire_nl1Ol_dataout = (rtx_pipe_enable === 1'b1) ? niiOO : txd_ch[17];
	assign		wire_nl1OO_dataout = (rtx_pipe_enable === 1'b1) ? nil1i : txd_ch[18];
	assign		wire_nli0i_dataout = (rtx_pipe_enable === 1'b1) ? niO0i : txd_ch[37];
	assign		wire_nli0l_dataout = (rtx_pipe_enable === 1'b1) ? niO0l : txd_ch[38];
	assign		wire_nli0O_dataout = (rtx_pipe_enable === 1'b1) ? niO0O : txd_ch[39];
	assign		wire_nli1i_dataout = (rtx_pipe_enable === 1'b1) ? niO1i : txd_ch[34];
	assign		wire_nli1l_dataout = (rtx_pipe_enable === 1'b1) ? niO1l : txd_ch[35];
	assign		wire_nli1O_dataout = (rtx_pipe_enable === 1'b1) ? niO1O : txd_ch[36];
	assign		wire_nliii_dataout = (rtx_pipe_enable === 1'b1) ? niOii : txd_ch[40];
	assign		wire_nliil_dataout = (rtx_pipe_enable === 1'b1) ? niOil : txd_ch[41];
	assign		wire_nliiO_dataout = (rtx_pipe_enable === 1'b1) ? niOiO : txd_ch[42];
	assign		wire_nlili_dataout = (rtx_pipe_enable === 1'b1) ? niOll : txd_ch[43];
	oper_mux   n0OiO
	( 
	.data({ni1ii, n0Oli, ((n0i0O18 ^ n0i0O17) & n0Oll), n0OlO}),
	.o(wire_n0OiO_o),
	.sel({rtx_elec_idle_delay[1:0]}));
	defparam
		n0OiO.width_data = 4,
		n0OiO.width_sel = 2;
	assign
		n0i0l = (((~ powerdown[0]) & (~ powerdown[1])) & (n00li28 ^ n00li27)),
		n0iiO = 1'b0,
		n0ill = ((tx_elec_idle_comp | ni11O) | (~ (n0ilO12 ^ n0ilO11))),
		n0l0O = 1'b1,
		powerstate = {wire_ni00l_dataout, wire_ni00i_dataout, wire_ni01O_dataout, wire_ni01l_dataout},
		rev_loopbk = wire_ni1Ol_dataout,
		tx_elec_idle = wire_ni1Oi_dataout,
		txbeacon = wire_ni1iO_dataout,
		txd = {wire_nlili_dataout, wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout, wire_nli0l_dataout, wire_nli0i_dataout, wire_nli1O_dataout, wire_nli1l_dataout, wire_nli1i_dataout, wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout, wire_nl0ll_dataout, wire_nl0li_dataout, wire_nl0iO_dataout, wire_nl0il_dataout, wire_nl0ii_dataout, wire_nl00O_dataout, wire_nl00l_dataout, wire_nl00i_dataout, wire_nl01O_dataout, wire_nl01l_dataout, wire_nl01i_dataout, wire_nl1OO_dataout, wire_nl1Ol_dataout, wire_nl1Oi_dataout, wire_nl1lO_dataout, wire_nl1ll_dataout, wire_nl1li_dataout, wire_nl1iO_dataout, wire_nl1il_dataout, wire_nl1ii_dataout, wire_nl10O_dataout, wire_nl10l_dataout, wire_nl10i_dataout, wire_nl11O_dataout, wire_nl11l_dataout, wire_nl11i_dataout, wire_niOOO_dataout, wire_niOOl_dataout, wire_niOOi_dataout, wire_niOlO_dataout},
		txdetectrx = wire_ni1ll_dataout;
endmodule //stratixiigx_hssi_tx_pipe_interface
//synopsys translate_on
//VALID FILE

//************************************************************
// Description:
// pipe_interface_top
//
// This is the top module for the PIPE Interface.
// 
//************************************************************


`timescale 1 ns / 1 ps

module stratixiigx_hssi_q_pipe_interface_top (

	// General signals
	pipe_tx_clk,
	pipe_rx_clk,
	refclk_b,
	tx_pipe_reset,
	rx_pipe_reset,
	refclk_b_reset,
	
	// CRAM 
	rtx_pipe_enable,
	rrx_pipe_enable,
	rrdwidth_rx,
	rtx_elec_idle_delay,
	rrx_detect_bypass,
	rclkcmpinsertpad,
	rphystatus_rst_toggle,
	

	// PLD - PIPE Interface
	// TX PIPE Interface: Command 
	txdetectrxloopback,
	txelecidle,
	txcompliance,
	powerdown,
	
	// TX PIPE Interface: Data
	txd_ch,
	
	// RX PIPE Interface: Command/Status
	rxpolarity,
	
	rxvalid,
	rxelecidle,
	rxstatus,
	
	// RX PIPE Interface: Data
	rxd_ch,
	
	// PHYStatus Generator
	phystatus,
	
	// Commands
	revloopback,
	polinv_rx,
	
	// PIPE - PCS Inteface
	// TX PIPE Interface
	txd,
	rev_loopbk,
	tx_elec_idle_comp,

	// RX PIPE Interface
	rxd,
	polinv_rx_int,
	
	// PIPE - PMA Interface
	// TX PIPE Interface
	tx_elec_idle,
	txdetectrx,
	powerstate,
	txbeacon,
	
	// RX PIPE Interface
	rx_found,
	rx_detect_valid,
	rxelectricalidle,
	rxbeacon,

	txdetectrxin, //shawn
	powerstatein, //shawn
	use_powerstatein, //shawn

	
	// PHYStatus Generator
	power_state_transition_done,
	power_state_transition_done_ena
);

//********************************************************************************
// INCLUDE STATEMENTS
//********************************************************************************

//********************************************************************************
// I/O SIGNALS
//********************************************************************************
	// General signals
input           txdetectrxin; //shawn
input [3:0]		powerstatein; //shawn
input           use_powerstatein; //shawn

input			pipe_tx_clk;
input			pipe_rx_clk;
input			refclk_b;
input			tx_pipe_reset;
input			rx_pipe_reset;
input			refclk_b_reset;
	
	// CRAM 
input			rtx_pipe_enable;
input			rrx_pipe_enable;
input			rrdwidth_rx;
input	[1:0]	rtx_elec_idle_delay;
input			rrx_detect_bypass;
input			rclkcmpinsertpad;
input			rphystatus_rst_toggle;

	// PLD - PIPE Interface
	// TX PIPE Interface: Command 
input			txdetectrxloopback;
input			txelecidle;
input			txcompliance;
input	[1:0]	powerdown;
	
	// TX PIPE Interface: Data
input	[43:0]	txd_ch;
	
	// RX PIPE Interface: Command/Status
input			rxpolarity;
	
output			rxvalid;
output			rxelecidle;
output	[2:0]	rxstatus;
	
	// RX PIPE Interface: Data
output	[63:0]	rxd_ch;
	
	// PHYStatus Generator
output			phystatus;
	
	// Commands
input			revloopback;
input			polinv_rx;
	
	// PIPE - PCS Inteface
	// TX PIPE Interface
output	[43:0]	txd;
output			rev_loopbk;
input			tx_elec_idle_comp;

	// RX PIPE Interface
input	[63:0]	rxd;
output			polinv_rx_int;
	
	// PIPE - PMA Interface
	// TX PIPE Interface
output			tx_elec_idle;
output			txdetectrx;
output	[3:0]	powerstate;
output			txbeacon;
	
	// RX PIPE Interface
input			rx_found;
input			rx_detect_valid;
input			rxelectricalidle;
input			rxbeacon;
	
	// PHYStatus Generator
input			power_state_transition_done;
input			power_state_transition_done_ena;

//********************************************************************************
// PARAMETERS
//********************************************************************************

//********************************************************************************
// DECLARATIONS
//********************************************************************************

wire			phystat_ena;


reg			rx_detect_valid_reg_0;
reg			rx_detect_valid_reg_1;

wire			tx_pipe_reset_n;
wire			rx_pipe_reset_n;
wire			refclk_b_reset_n;	// reset for txelecidle_d_generator

reg			txdetectrx_reg_0;
reg			txdetectrx_reg_1;
reg			txdetectrx_reg_2;
reg			txdetectrx_reg_3;
reg			txdetectrx_reg_4;
reg			txdetectrx_reg_5;
reg			txdetectrx_reg_6;

reg			bypass_rx_found;
reg			bypass_rx_detect_valid;

wire			rx_found_int;
wire			rx_detect_valid_int;

wire			latched_p0;
wire			latched_p0s;
wire			latched_p1;
wire			latched_p2;

wire            tmp_txdetectrxin;   //shawn

//********************************************************************************
// ASSIGN STATEMENTS
//********************************************************************************
assign phystat_ena = rtx_pipe_enable || rrx_pipe_enable;

assign tx_pipe_reset_n = ~tx_pipe_reset;
assign rx_pipe_reset_n = ~rx_pipe_reset;
assign refclk_b_reset_n = ~refclk_b_reset;

assign rx_found_int = rrx_detect_bypass? bypass_rx_found: rx_found;
assign rx_detect_valid_int = rrx_detect_bypass? bypass_rx_detect_valid: rx_detect_valid_reg_1;

assign tmp_txdetectrxin = (use_powerstatein == 1'b1) ? txdetectrxin : txdetectrx;  //shawn

assign latched_p0 = (use_powerstatein == 1'b1) ? powerstatein[0] : powerstate [0]; //shawn
assign latched_p0s = (use_powerstatein == 1'b1) ? powerstatein[1] : powerstate [1]; //shawn;
assign latched_p1 = (use_powerstatein == 1'b1) ? powerstatein[2] : powerstate [2]; //shawn;
assign latched_p2 = (use_powerstatein == 1'b1) ? powerstatein[3] : powerstate [3]; //shawn;
//********************************************************************************
// SUBMODULE INSTANTIATIONS
//********************************************************************************

stratixiigx_hssi_tx_pipe_interface tx_pipe_interface_inst (

	// General signals
	.clk							(pipe_tx_clk),
	.refclk_b						(refclk_b),
	.reset_n						(tx_pipe_reset_n),
	.refclk_b_reset_n				(refclk_b_reset_n),
	
	// CRAM 
	.rtx_pipe_enable				(rtx_pipe_enable),
	.rtx_elec_idle_delay			(rtx_elec_idle_delay),
	
	// PLD - PIPE Interface
	// TX PIPE Interface: Command
	.txdetectrxloopback				(txdetectrxloopback),
	.txelecidle					(txelecidle),
	.txcompliance					(txcompliance),
	.powerdown					(powerdown),
	
	// TX PIPE Interface: Data
	.txd_ch						(txd_ch),
	
	// Commands
	.revloopback					(revloopback),
	
	// PIPE - PCS Inteface
	// TX PIPE Interface
	.txd							(txd),
	.rev_loopbk					(rev_loopbk),
	.tx_elec_idle_comp				(tx_elec_idle_comp),
	
	
	// PIPE - PMA Interface
	.tx_elec_idle					(tx_elec_idle),
	.txdetectrx					(txdetectrx),
	.txbeacon						(txbeacon),

	// Central PCS
	.powerstate					(powerstate)
	
);


stratixiigx_hssi_rx_pipe_interface rx_pipe_interface_inst (

	// General signals
	.clk							(pipe_rx_clk),
	.reset_n						(rx_pipe_reset_n),
	
	// CRAM 
	.rrx_pipe_enable				(rrx_pipe_enable),
	.rrdwidth_rx					(rrdwidth_rx),
	.rclkcmpinsertpad				(rclkcmpinsertpad),
	
	// PLD - PIPE Interface
	// RX PIPE Interface: Command/Status
	.rxpolarity					(rxpolarity),
	
	.rxvalid						(rxvalid),
	.rxelecidle					(rxelecidle),
	.rxstatus						(rxstatus),
	
	// RX PIPE Interface: Data
	.rxd_ch						(rxd_ch),
	
	// Commands
	.polinv_rx					(polinv_rx),
	
	// PIPE - PCS Inteface
	// RX PIPE Interface
	.rxd							(rxd),
	.polinv_rx_int					(polinv_rx_int),

	// Latched Power State Signals
	.latched_p0					(latched_p0),
	.latched_p0s					(latched_p0s),
	.latched_p1					(latched_p1),
	.latched_p2					(latched_p2),
	
	// PIPE - PMA Interface
	// TX PIPE Interface
	.rx_found						(rx_found_int),
	.rx_detect_valid				(rx_detect_valid),
	.rx_detect_valid_sync			(rx_detect_valid_int),	
	
	// RX PIPE Interface
	.rxelectricalidle				(rxelectricalidle),
	.rxbeacon						(rxbeacon)
	
);

stratixiigx_hssi_phystatus_generator phystatus_generator_inst (

	// General signals
	.clk							(pipe_rx_clk),
	.reset_n						(rx_pipe_reset_n),
	
	//CRAM
	.phystat_ena					(phystat_ena),
	.rphystatus_rst_toggle			(rphystatus_rst_toggle),

	// PLD Interface
	.powerdown					(powerdown),
	.phystatus					(phystatus),
	
	// Latched Power State Signals
	.latched_p0					(latched_p0),
	.latched_p0s					(latched_p0s),
	.latched_p1					(latched_p1),
	.latched_p2					(latched_p2),

	// PMA interface
	// TX PMA Interface
	.rx_detect_valid				(rx_detect_valid_int),

	// RX PMA Interface
	.power_state_transition_done		(power_state_transition_done),
	.power_state_transition_done_ena	(power_state_transition_done_ena)
	
);

//********************************************************************************
// MAIN CODE 
//********************************************************************************

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		rx_detect_valid_reg_0	<= 1'b0;
	end
	else
	begin
		rx_detect_valid_reg_0	<= rx_detect_valid;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		rx_detect_valid_reg_1	<= 1'b0;
	end
	else
	begin
		rx_detect_valid_reg_1	<= rx_detect_valid_reg_0;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_0	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_0	<= tmp_txdetectrxin;      // txdetectrx; shawn
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_1	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_1	<= txdetectrx_reg_0;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_2	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_2	<= txdetectrx_reg_1;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_3	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_3	<= txdetectrx_reg_2;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_4	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_4	<= txdetectrx_reg_3;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_5	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_5	<= txdetectrx_reg_4;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_6	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_6	<= txdetectrx_reg_5;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		bypass_rx_found		<= 1'b0;
		bypass_rx_detect_valid	<= 1'b0;
	end
	else
	begin
		bypass_rx_found		<= txdetectrx_reg_6;
		bypass_rx_detect_valid	<= txdetectrx_reg_6;
	end
end

	// Synchronize powerstate to rx clk domain
/*
always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		powerstate_0	<= 1'b0;
		powerstate_1	<= 1'b0;
		powerstate_2	<= 1'b0;
		powerstate_3	<= 1'b0;
	end
	else
	begin
		powerstate_0	<= powerstate[0];
		powerstate_1	<= powerstate[1];
		powerstate_2	<= powerstate[2];
		powerstate_3	<= powerstate[3];
	end
end
always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		latched_p0	<= 1'b0;
		latched_p0s	<= 1'b0;
		latched_p1	<= 1'b0;
		latched_p2	<= 1'b0;
	end
	else
	begin
		latched_p0	<= powerstate_0;
		latched_p0s	<= powerstate_1;
		latched_p1	<= powerstate_2;
		latched_p2	<= powerstate_3;
	end
end*/
endmodule

`timescale 1 ns / 1 ps

module stratixiigx_hssi_pcs_reset (hard_reset, clk_2_b, refclk_b_in, scan_mode, rxpcs_rst, txpcs_rst,
                  rxrst_int, txrst_int);

input   hard_reset;
input   clk_2_b;
input   refclk_b_in;
input   scan_mode;
input   rxpcs_rst;
input   txpcs_rst;

output  rxrst_int;
output  txrst_int;

reg 	txrst_sync1, txrst_sync2;
reg     rxrst_sync1, rxrst_sync2;
wire    txrst_int, rxrst_int;


always @(posedge hard_reset or posedge clk_2_b)
begin
	if (hard_reset)
		begin
		 rxrst_sync2	<= 1'b1;
		 rxrst_sync1 	<= 1'b1;
		end
	else
		begin
		 rxrst_sync2	<= #1 rxrst_sync1;
		 rxrst_sync1	<= rxpcs_rst;
		end
end

always @(posedge hard_reset or posedge refclk_b_in)
begin
	if (hard_reset)
		begin
		 txrst_sync2	<= 1'b1;
		 txrst_sync1 	<= 1'b1;
		end
	else
		begin
		 txrst_sync2	<= #1 txrst_sync1;
		 txrst_sync1	<= txpcs_rst;
		end
end

// 06-14-02 BT Changed SCAN_SHIFT signal to SCAN_MODE
//assign rxrst_int = !SCAN_SHIFT & rxrst_sync2;
//assign txrst_int = !SCAN_SHIFT & txrst_sync2;
assign rxrst_int = !scan_mode & rxrst_sync2;
assign txrst_int = !scan_mode & txrst_sync2;

endmodule

`timescale 1 ps / 1 ps

module stratixiigx_hssi_tx_txclk_ctl (txrst, pld_tx_clk, refclk_pma, txpma_local_clk, 
                  tx_div2_sync_in_ch0, tx_div2_sync_in_q0_ch0,
                  rindv_tx, rtxwrclksel, rtxrdclksel, rdwidth_tx,            
                  rfreerun_tx, rphfifo_master_sel_tx, scan_mode,             
                  tx_clk_out, tx_div2_sync_out, wr_clk_pos,            
                  fifo_rd_clk, refclk_b
                 );

input        txrst;                  // reset for the tx_pcs
input        pld_tx_clk;             // The transmit clock from XGMII.
input        refclk_pma;             // from the root clock tree
input        txpma_local_clk;        // Local channel TX PMA clock.
input        tx_div2_sync_in_ch0;    // from the channel zero tx_div2_sync_out
input        tx_div2_sync_in_q0_ch0; // From channel0 of Master Quad
input	     rindv_tx;               // Selects between indiv chan. mode and bundled mode
input        rtxwrclksel;            // Selects which clock writes into FIFO
input        rtxrdclksel;            // Selects which clock reads from FIFO and also clocks reest of TX logic
input  	     rdwidth_tx;             // divide by 1 or 2 before feeding to FIFO read clock
input        rfreerun_tx;            // Select whether divider is permamently enabled (free -running) or
			             // divider should be enabled / reset by TX PCS reset  
input        rphfifo_master_sel_tx;  // TX Phase comp. FIFO tx_div2_sync selection CRAM
input        scan_mode;              // Scan mode enable signal for selecting scan_clk from refclk_pma

output       tx_clk_out;             // Drives to the PLD clock tree -- unconnected
output       tx_div2_sync_out;       // Synchronizes the divided by two clock
output       wr_clk_pos;             // Drives tx phase comp fifo write side
output       fifo_rd_clk;            // Drives tx phase comp fifo read side
output       refclk_b;               // Drives the tx channel clock

wire tx_rst_n,tx_div2_sync;
reg fifo_rd_clk_by2;
wire rd_clk_before_div;  //Same as refclk_b. Different name for clarity.

// initial begin ------
initial begin
    fifo_rd_clk_by2 = 1'b0;
end             
// initial end   ------

// Select between the local synchronization signal or the global synchronization signal (either from Channel0 or 
// Channel0 of Master Quad
//assign tx_div2_sync = rindv_tx ? tx_div2_sync_out : tx_div2_sync_in;
assign tx_div2_sync = (rphfifo_master_sel_tx == 1'b0) ? tx_div2_sync_in_q0_ch0 :
                      (rindv_tx == 1'b0) ? tx_div2_sync_in_ch0 : tx_div2_sync_out;

assign tx_div2_sync_out = ~fifo_rd_clk_by2;

// Divide-by-2 FF
always @(negedge tx_rst_n or posedge rd_clk_before_div)
begin
	if (~tx_rst_n)
		fifo_rd_clk_by2 <= 1'b0;
	else if (rd_clk_before_div)
		fifo_rd_clk_by2 <= tx_div2_sync; // local divided clock
end

// Reset for Divide-by-2 FF
assign tx_rst_n = (rfreerun_tx) ? 1'b1 : ~txrst;

// Full speed clock for TX PCS
assign refclk_b = rd_clk_before_div;	// Internal

// Output clock for PLD
assign tx_clk_out = fifo_rd_clk;	// to PLD

// TX FIFO read clock: could be fast or divided by 2
assign fifo_rd_clk = ((rdwidth_tx == 1'b0) || scan_mode) ? rd_clk_before_div : fifo_rd_clk_by2;
assign rd_clk_before_div = (rtxrdclksel || scan_mode) ? refclk_pma : txpma_local_clk; //Same as refclk_b. Different name for clarity.

// TX FIFO write clock: used internal clock when in BIST 
assign wr_clk_pos = (rtxwrclksel || scan_mode) ? fifo_rd_clk : pld_tx_clk;


endmodule

`timescale 1ps / 1ps

module stratixiigx_hssi_tx_ram8x44_syn (
    data_in,
    clk,
    fifo_wr,
    rst_l, 
    fifo_re,
    data_out
    );

input 		clk;
input 		rst_l;
input 	[7:0]	fifo_wr;
input 	[7:0] 	fifo_re;
input 	[43:0] 	data_in;
output 	[43:0] 	data_out;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 44;

reg [ram_width-1:0] data_out_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7;

wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7;

assign  data_out = re_l ? 44'b0 : data_out_i;

always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    fifo_re		
    )
begin
    case ( fifo_re )  // synopsys parallel_case full_case
    8'b00000001 : data_out_i = ram_array_q_0;
    8'b00000010 : data_out_i = ram_array_q_1;
    8'b00000100 : data_out_i = ram_array_q_2;
    8'b00001000 : data_out_i = ram_array_q_3;
    8'b00010000 : data_out_i = ram_array_q_4;
    8'b00100000 : data_out_i = ram_array_q_5;
    8'b01000000 : data_out_i = ram_array_q_6;
    8'b10000000 : data_out_i = ram_array_q_7;
    default     : data_out_i = ram_array_q_0;
    endcase
end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	
       )
begin
    if(we) begin
	ram_array_d_0 <=  data_reg_0;
	ram_array_d_1 <=  data_reg_1;
	ram_array_d_2 <=  data_reg_2;
	ram_array_d_3 <=  data_reg_3;
        ram_array_d_4 <=  data_reg_4;
        ram_array_d_5 <=  data_reg_5;
        ram_array_d_6 <=  data_reg_6;
        ram_array_d_7 <=  data_reg_7; 
    end
    else begin
	ram_array_d_0 <=  ram_array_q_0;
	ram_array_d_1 <=  ram_array_q_1;
	ram_array_d_2 <=  ram_array_q_2;
	ram_array_d_3 <=  ram_array_q_3;
        ram_array_d_4 <=  ram_array_q_4;
        ram_array_d_5 <=  ram_array_q_5;
        ram_array_d_6 <=  ram_array_q_6;
        ram_array_d_7 <=  ram_array_q_7;
    end
end

endmodule

`timescale 1 ps / 1 ps

module stratixiigx_hssi_tx_ph_fifo (
// inputs
	rst_wclk,
	rst_rclk,
	wr_clk,
	rd_clk,
	bypass_en,
	//en,
	lowlatency_en,
	we,
	re,
	din,
// outputs
	data_out,
	ph_fifo_full,
	ph_fifo_empty,
	wptr_bin,
	rptr_bin
);

// =======
// inputs
// =======
input         rst_wclk;		// wr clk rst
input         rst_rclk;		// rd clk rst
input         wr_clk;		// Write Clock
input         rd_clk;		// Read Clock
input         bypass_en;	// FIFO bypass enable - only for Altera internal debug
//input         en;		// Disable FIFO, reset wptr and rptr 
				// only for Altera internal debug
input         lowlatency_en;	// Enable low latency option 
input         we;		// PLD dynamic write pointer enable  
input         re;		// PLD dynamic read pointer enable  
input  [43:0] din;		// 10-bit code-group bus from deskew module.

// =======
// outputs
// =======
output        ph_fifo_full;	// Indicates overflow (rd_clk)
output        ph_fifo_empty;	// FIFO empty (rd_clk)
output [43:0] data_out;		// output data (rd_clk synchronous if not FIFO bypass)
output  [2:0] wptr_bin;		// wptr test bus
output  [2:0] rptr_bin;		// rptr test bus

// ===================
// signal declaration
// ===================
reg  [ 7:0] wptr, rptr;
reg  [ 7:0] wptr0;
reg  [ 7:0] wptr1;
reg  [ 3:0] rptr_gray;
reg  [ 2:0] rptr0;
reg  [ 2:0] rptr1;
reg  [ 7:0] rptr1_onehot;
reg  [ 2:0] wptr_bin;		// wptr test bus
reg  [ 2:0] rptr_bin;		// rptr test bus
reg         first_rd;		// first read after reset
reg  [43:0] ram_data_out;
wire [43:0] ram_data_out_pre;

reg  ph_fifo_full, ph_fifo_empty;

// Invert rst for new FIFO     
wire rst_n;

// =============
// functionality
// =============
assign rst_n = ~rst_wclk;

assign data_out[43:0] = (bypass_en)? din : ram_data_out;

always @ (posedge rst_wclk or posedge wr_clk)
begin
   if (rst_wclk == 1'b1)
   begin
      wptr  <= 8'h01;
      wptr0 <= 8'h01;
      wptr1 <= 8'h01;
      rptr0 <= 3'h0;
      rptr1 <= 3'h0;
      ph_fifo_full <= 1'b0;
      ph_fifo_empty <= 1'b0;
   end
   else
   begin

      wptr0 <= wptr;
      wptr1 <= wptr0;

      rptr0 <= rptr_gray;
      rptr1 <= rptr0;

      // wptr operation
      if (we == 1'b1)
         wptr <= {wptr[6:0],wptr[7]};

      // full condition
      if ({wptr1[6:0],wptr1[7]} == rptr1_onehot)
         ph_fifo_full <= 1'b1;
      else if (ph_fifo_full == 1'b1 & ({wptr1[6:0],wptr1[7]} != rptr1_onehot) & (wptr1 != rptr1_onehot))
         ph_fifo_full <= 1'b0;

      // empty condition
      if ({rptr1_onehot[6:0],rptr1_onehot[7]} == wptr1)
         ph_fifo_empty <= 1'b1;
      else if (ph_fifo_empty == 1'b1 & ({rptr1_onehot[6:0],rptr1_onehot[7]} != wptr1) & (wptr1 != rptr1_onehot))
         ph_fifo_empty <= 1'b0;
   end
end


always @ (posedge rst_rclk or posedge rd_clk)
begin
   if (rst_rclk == 1'b1)
   begin
      first_rd <= 1'b1;
      rptr  <= 8'h20;
   end
   else
   begin

      if (first_rd == 1'b1 && re == 1'b1)
          first_rd <= 1'b0;

      // read pointer operation
      if (re == 1'b1)
         // low latency option, advance 2 on the first read 
         if (first_rd == 1'b1 && lowlatency_en == 1'b1)
            rptr <= {rptr[5:0],rptr[7:6]};	
         else
            rptr <= {rptr[6:0],rptr[7]};
   end

end

// Instantiate FIFO CORE Module. Fifo 8 words deep, 44 bits wide
stratixiigx_hssi_tx_ram8x44_syn   ram8x44_syn_1 (
                                  .rst_l (rst_n),
                                  .clk (wr_clk),
                                  .fifo_wr (wptr),
                                  .data_in (din),
                                  .fifo_re (rptr),
                                  .data_out (ram_data_out_pre)
		        	);

always @ (posedge rst_rclk or posedge rd_clk)
begin
   if (rst_rclk)
   begin
	ram_data_out <= 44'h00000000000;
   end
   else  
        ram_data_out <= ram_data_out_pre;
end

always@(wptr)
begin
  case(wptr)
  8'h01: wptr_bin = 3'h0;
  8'h02: wptr_bin = 3'h1;
  8'h04: wptr_bin = 3'h2;
  8'h08: wptr_bin = 3'h3;
  8'h10: wptr_bin = 3'h4;
  8'h20: wptr_bin = 3'h5;
  8'h40: wptr_bin = 3'h6;
  8'h80: wptr_bin = 3'h7;
  default: wptr_bin = 3'h7;
  endcase
end

always@(rptr)
begin
  case(rptr)
  8'h01: rptr_bin = 3'h0;
  8'h02: rptr_bin = 3'h1;
  8'h04: rptr_bin = 3'h2;
  8'h08: rptr_bin = 3'h3;
  8'h10: rptr_bin = 3'h4;
  8'h20: rptr_bin = 3'h5;
  8'h40: rptr_bin = 3'h6;
  8'h80: rptr_bin = 3'h7;
  default: rptr_bin = 3'h7;
  endcase
end

always@(rptr)
begin
  case(rptr)
  8'h01: rptr_gray = 3'h0;
  8'h02: rptr_gray = 3'h1;
  8'h04: rptr_gray = 3'h3;
  8'h08: rptr_gray = 3'h2;
  8'h10: rptr_gray = 3'h6;
  8'h20: rptr_gray = 3'h7;
  8'h40: rptr_gray = 3'h5;
  8'h80: rptr_gray = 3'h4;
  default: rptr_gray = 3'h0;
  endcase
end

always@(rptr1)
begin
  case(rptr1)
  3'h0: rptr1_onehot = 8'h01;
  3'h1: rptr1_onehot = 8'h02;
  3'h3: rptr1_onehot = 8'h04;
  3'h2: rptr1_onehot = 8'h08;
  3'h6: rptr1_onehot = 8'h10;
  3'h7: rptr1_onehot = 8'h20;
  3'h5: rptr1_onehot = 8'h40;
  3'h4: rptr1_onehot = 8'h80;
  default: rptr1_onehot = 8'h01;
  endcase
end

endmodule
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 120 mux21 250 stratixiigx_hssi_tx_ph_fifo 1 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_ctrl
	( 
	d21_5_eq_n,
	d2_2_eq_n,
	dwidth,
	fifo_rd_clk,
	fifo_select_in_ch0,
	fifo_select_in_q0_ch0,
	fifo_select_out,
	fifo_wr_clk,
	indv,
	k_det,
	p_rlpbk,
	ph_fifo_empty,
	ph_fifo_full,
	pipe_electric_idle,
	pld_rd_dis,
	pld_we,
	rd_enable2,
	rd_enable_ch0,
	rd_enable_out,
	rd_enable_q0_ch0,
	rd_enable_sync,
	redund_ctl,
	refclk_b_in,
	rforce_disp,
	rforce_echar,
	rforce_kchar,
	rphfifo_master_sel_tx,
	rptr_bin,
	rtx_pipe_enable,
	rtxfifo_lowlatency_en,
	rtxfifo_urst_en,
	rtxphfifopldctl_en,
	rxd_lpbk,
	scan_mode,
	selftest_en,
	soft_reset,
	soft_reset_wclk1,
	tx_control_sg,
	tx_ctl_tc,
	tx_data_9_tc,
	tx_data_sg,
	tx_data_tc,
	txd,
	txd_extend,
	txd_extend_tc,
	txd_redun,
	txfifo_dis,
	txfifo_urst,
	wptr_bin,
	wr_enable2,
	wr_enable_ch0,
	wr_enable_out,
	wr_enable_q0_ch0) /* synthesis synthesis_clearbox=1 */;
	output   [1:0]  d21_5_eq_n;
	output   [1:0]  d2_2_eq_n;
	input   dwidth;
	input   fifo_rd_clk;
	input   fifo_select_in_ch0;
	input   fifo_select_in_q0_ch0;
	output   fifo_select_out;
	input   fifo_wr_clk;
	input   indv;
	output   [1:0]  k_det;
	input   p_rlpbk;
	output   ph_fifo_empty;
	output   ph_fifo_full;
	output   pipe_electric_idle;
	input   pld_rd_dis;
	input   pld_we;
	output   rd_enable2;
	input   rd_enable_ch0;
	output   rd_enable_out;
	input   rd_enable_q0_ch0;
	output   rd_enable_sync;
	input   [3:0]  redund_ctl;
	input   refclk_b_in;
	input   rforce_disp;
	input   rforce_echar;
	input   rforce_kchar;
	input   rphfifo_master_sel_tx;
	output   [2:0]  rptr_bin;
	input   rtx_pipe_enable;
	input   rtxfifo_lowlatency_en;
	input   rtxfifo_urst_en;
	input   rtxphfifopldctl_en;
	input   [39:0]  rxd_lpbk;
	input   scan_mode;
	input   selftest_en;
	input   soft_reset;
	output   soft_reset_wclk1;
	input   [3:0]  tx_control_sg;
	output   [1:0]  tx_ctl_tc;
	output   [1:0]  tx_data_9_tc;
	input   [31:0]  tx_data_sg;
	output   [15:0]  tx_data_tc;
	input   [39:0]  txd;
	input   [3:0]  txd_extend;
	output   [1:0]  txd_extend_tc;
	input   [39:0]  txd_redun;
	input   txfifo_dis;
	input   txfifo_urst;
	output   [2:0]  wptr_bin;
	output   wr_enable2;
	input   wr_enable_ch0;
	output   wr_enable_out;
	input   wr_enable_q0_ch0;

	reg	nl000i43;
	reg	nl000i44;
	reg	nl001l45;
	reg	nl001l46;
	reg	nl00ll41;
	reg	nl00ll42;
	reg	nl00Oi39;
	reg	nl00Oi40;
	reg	nl00Ol37;
	reg	nl00Ol38;
	reg	nl0i0i31;
	reg	nl0i0i32;
	reg	nl0i0O29;
	reg	nl0i0O30;
	reg	nl0i1i35;
	reg	nl0i1i36;
	reg	nl0i1l33;
	reg	nl0i1l34;
	reg	nl0iil27;
	reg	nl0iil28;
	reg	nl0ili25;
	reg	nl0ili26;
	reg	nl0ilO23;
	reg	nl0ilO24;
	reg	nl0iOl21;
	reg	nl0iOl22;
	reg	nl0l0i17;
	reg	nl0l0i18;
	reg	nl0l1i19;
	reg	nl0l1i20;
	reg	nl0llO15;
	reg	nl0llO16;
	reg	nl0lOi13;
	reg	nl0lOi14;
	reg	nl0lOO11;
	reg	nl0lOO12;
	reg	nl0O0O5;
	reg	nl0O0O6;
	reg	nl0O1i10;
	reg	nl0O1i9;
	reg	nl0O1O7;
	reg	nl0O1O8;
	reg	nl0OiO3;
	reg	nl0OiO4;
	reg	nl0OlO1;
	reg	nl0OlO2;
	reg	n000i;
	reg	n001i;
	reg	n001l;
	reg	n010l;
	reg	n01iO;
	reg	n01li;
	reg	n01ll;
	reg	n01lO;
	reg	n01Oi;
	reg	n01Ol;
	reg	n01OO;
	wire	wire_n001O_CLRN;
	reg	n010i;
	reg	n011i;
	reg	n011l;
	reg	n011O;
	reg	n01ii;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n10ii;
	reg	n10Oi;
	reg	n10Ol;
	reg	n10OO;
	reg	n1i1i;
	reg	n1lOi;
	reg	n1lOl;
	reg	n1lOO;
	reg	n1O0i;
	reg	n1O0l;
	reg	n1O0O;
	reg	n1O1i;
	reg	n1O1l;
	reg	n1O1O;
	reg	n1Oii;
	reg	n1Oil;
	reg	n1OiO;
	reg	n1Oli;
	reg	n1Oll;
	reg	n1OlO;
	reg	n1OOi;
	reg	n1OOl;
	reg	n1OOO;
	reg	n1i0i;
	reg	n1i0O;
	reg	n1i1l;
	reg	n1i1O;
	wire	wire_n1i0l_PRN;
	reg	n1iii;
	reg	n1iil;
	reg	n1iiO;
	reg	n1ili;
	reg	n1ill;
	reg	n1ilO;
	reg	n1iOi;
	reg	n1iOl;
	reg	n1iOO;
	reg	n1l0i;
	reg	n1l0l;
	reg	n1l0O;
	reg	n1l1i;
	reg	n1l1l;
	reg	n1l1O;
	reg	n1lii;
	reg	n1lil;
	reg	n1liO;
	reg	n1lli;
	reg	n1llO;
	wire	wire_n1lll_CLRN;
	reg	nl00i;
	reg	nl0ii;
	reg	nl00O_clk_prev;
	wire	wire_nl00O_CLRN;
	reg	nl01O;
	reg	nl1ll;
	reg	nl01l_clk_prev;
	wire	wire_nl01l_CLRN;
	wire	wire_nl01l_PRN;
	reg	n000l;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1li;
	reg	nl1iO_clk_prev;
	wire	wire_nl1iO_PRN;
	wire	wire_n000O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00Ol_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni00l_dataout;
	wire	wire_ni00O_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0ii_dataout;
	wire	wire_ni0il_dataout;
	wire	wire_ni0iO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0li_dataout;
	wire	wire_ni0ll_dataout;
	wire	wire_ni0lO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0Oi_dataout;
	wire	wire_ni0Ol_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1li_dataout;
	wire	wire_ni1ll_dataout;
	wire	wire_ni1lO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO0i_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1lO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1Oi_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nO_dataout;
	wire  [43:0]   wire_nli11i_data_out;
	wire  wire_nli11i_ph_fifo_empty;
	wire  wire_nli11i_ph_fifo_full;
	wire  [2:0]   wire_nli11i_rptr_bin;
	wire  [2:0]   wire_nli11i_wptr_bin;
	wire  nl000O;
	wire  nl00ii;
	wire  nl00il;
	wire  nl00iO;
	wire  nl00li;
	wire  nl00lO;
	wire  nl0l0O;
	wire  nl0l1O;
	wire  nl0lii;
	wire  nl0lil;
	wire  nl0liO;
	wire  nl0lli;
	wire  nl0lll;
	wire  nl0O0i;
	wire  nl0O0l;
	wire  nl0O1l;
	wire  nl0Oil;
	wire  nl0Oll;

	initial
		nl000i43 = 0;
	always @ ( posedge refclk_b_in)
		  nl000i43 <= nl000i44;
	event nl000i43_event;
	initial
		#1 ->nl000i43_event;
	always @(nl000i43_event)
		nl000i43 <= {1{1'b1}};
	initial
		nl000i44 = 0;
	always @ ( posedge refclk_b_in)
		  nl000i44 <= nl000i43;
	initial
		nl001l45 = 0;
	always @ ( posedge refclk_b_in)
		  nl001l45 <= nl001l46;
	event nl001l45_event;
	initial
		#1 ->nl001l45_event;
	always @(nl001l45_event)
		nl001l45 <= {1{1'b1}};
	initial
		nl001l46 = 0;
	always @ ( posedge refclk_b_in)
		  nl001l46 <= nl001l45;
	initial
		nl00ll41 = 0;
	always @ ( posedge refclk_b_in)
		  nl00ll41 <= nl00ll42;
	event nl00ll41_event;
	initial
		#1 ->nl00ll41_event;
	always @(nl00ll41_event)
		nl00ll41 <= {1{1'b1}};
	initial
		nl00ll42 = 0;
	always @ ( posedge refclk_b_in)
		  nl00ll42 <= nl00ll41;
	initial
		nl00Oi39 = 0;
	always @ ( posedge refclk_b_in)
		  nl00Oi39 <= nl00Oi40;
	event nl00Oi39_event;
	initial
		#1 ->nl00Oi39_event;
	always @(nl00Oi39_event)
		nl00Oi39 <= {1{1'b1}};
	initial
		nl00Oi40 = 0;
	always @ ( posedge refclk_b_in)
		  nl00Oi40 <= nl00Oi39;
	initial
		nl00Ol37 = 0;
	always @ ( posedge refclk_b_in)
		  nl00Ol37 <= nl00Ol38;
	event nl00Ol37_event;
	initial
		#1 ->nl00Ol37_event;
	always @(nl00Ol37_event)
		nl00Ol37 <= {1{1'b1}};
	initial
		nl00Ol38 = 0;
	always @ ( posedge refclk_b_in)
		  nl00Ol38 <= nl00Ol37;
	initial
		nl0i0i31 = 0;
	always @ ( posedge refclk_b_in)
		  nl0i0i31 <= nl0i0i32;
	event nl0i0i31_event;
	initial
		#1 ->nl0i0i31_event;
	always @(nl0i0i31_event)
		nl0i0i31 <= {1{1'b1}};
	initial
		nl0i0i32 = 0;
	always @ ( posedge refclk_b_in)
		  nl0i0i32 <= nl0i0i31;
	initial
		nl0i0O29 = 0;
	always @ ( posedge refclk_b_in)
		  nl0i0O29 <= nl0i0O30;
	event nl0i0O29_event;
	initial
		#1 ->nl0i0O29_event;
	always @(nl0i0O29_event)
		nl0i0O29 <= {1{1'b1}};
	initial
		nl0i0O30 = 0;
	always @ ( posedge refclk_b_in)
		  nl0i0O30 <= nl0i0O29;
	initial
		nl0i1i35 = 0;
	always @ ( posedge refclk_b_in)
		  nl0i1i35 <= nl0i1i36;
	event nl0i1i35_event;
	initial
		#1 ->nl0i1i35_event;
	always @(nl0i1i35_event)
		nl0i1i35 <= {1{1'b1}};
	initial
		nl0i1i36 = 0;
	always @ ( posedge refclk_b_in)
		  nl0i1i36 <= nl0i1i35;
	initial
		nl0i1l33 = 0;
	always @ ( posedge refclk_b_in)
		  nl0i1l33 <= nl0i1l34;
	event nl0i1l33_event;
	initial
		#1 ->nl0i1l33_event;
	always @(nl0i1l33_event)
		nl0i1l33 <= {1{1'b1}};
	initial
		nl0i1l34 = 0;
	always @ ( posedge refclk_b_in)
		  nl0i1l34 <= nl0i1l33;
	initial
		nl0iil27 = 0;
	always @ ( posedge refclk_b_in)
		  nl0iil27 <= nl0iil28;
	event nl0iil27_event;
	initial
		#1 ->nl0iil27_event;
	always @(nl0iil27_event)
		nl0iil27 <= {1{1'b1}};
	initial
		nl0iil28 = 0;
	always @ ( posedge refclk_b_in)
		  nl0iil28 <= nl0iil27;
	initial
		nl0ili25 = 0;
	always @ ( posedge refclk_b_in)
		  nl0ili25 <= nl0ili26;
	event nl0ili25_event;
	initial
		#1 ->nl0ili25_event;
	always @(nl0ili25_event)
		nl0ili25 <= {1{1'b1}};
	initial
		nl0ili26 = 0;
	always @ ( posedge refclk_b_in)
		  nl0ili26 <= nl0ili25;
	initial
		nl0ilO23 = 0;
	always @ ( posedge refclk_b_in)
		  nl0ilO23 <= nl0ilO24;
	event nl0ilO23_event;
	initial
		#1 ->nl0ilO23_event;
	always @(nl0ilO23_event)
		nl0ilO23 <= {1{1'b1}};
	initial
		nl0ilO24 = 0;
	always @ ( posedge refclk_b_in)
		  nl0ilO24 <= nl0ilO23;
	initial
		nl0iOl21 = 0;
	always @ ( posedge refclk_b_in)
		  nl0iOl21 <= nl0iOl22;
	event nl0iOl21_event;
	initial
		#1 ->nl0iOl21_event;
	always @(nl0iOl21_event)
		nl0iOl21 <= {1{1'b1}};
	initial
		nl0iOl22 = 0;
	always @ ( posedge refclk_b_in)
		  nl0iOl22 <= nl0iOl21;
	initial
		nl0l0i17 = 0;
	always @ ( posedge refclk_b_in)
		  nl0l0i17 <= nl0l0i18;
	event nl0l0i17_event;
	initial
		#1 ->nl0l0i17_event;
	always @(nl0l0i17_event)
		nl0l0i17 <= {1{1'b1}};
	initial
		nl0l0i18 = 0;
	always @ ( posedge refclk_b_in)
		  nl0l0i18 <= nl0l0i17;
	initial
		nl0l1i19 = 0;
	always @ ( posedge refclk_b_in)
		  nl0l1i19 <= nl0l1i20;
	event nl0l1i19_event;
	initial
		#1 ->nl0l1i19_event;
	always @(nl0l1i19_event)
		nl0l1i19 <= {1{1'b1}};
	initial
		nl0l1i20 = 0;
	always @ ( posedge refclk_b_in)
		  nl0l1i20 <= nl0l1i19;
	initial
		nl0llO15 = 0;
	always @ ( posedge refclk_b_in)
		  nl0llO15 <= nl0llO16;
	event nl0llO15_event;
	initial
		#1 ->nl0llO15_event;
	always @(nl0llO15_event)
		nl0llO15 <= {1{1'b1}};
	initial
		nl0llO16 = 0;
	always @ ( posedge refclk_b_in)
		  nl0llO16 <= nl0llO15;
	initial
		nl0lOi13 = 0;
	always @ ( posedge refclk_b_in)
		  nl0lOi13 <= nl0lOi14;
	event nl0lOi13_event;
	initial
		#1 ->nl0lOi13_event;
	always @(nl0lOi13_event)
		nl0lOi13 <= {1{1'b1}};
	initial
		nl0lOi14 = 0;
	always @ ( posedge refclk_b_in)
		  nl0lOi14 <= nl0lOi13;
	initial
		nl0lOO11 = 0;
	always @ ( posedge refclk_b_in)
		  nl0lOO11 <= nl0lOO12;
	event nl0lOO11_event;
	initial
		#1 ->nl0lOO11_event;
	always @(nl0lOO11_event)
		nl0lOO11 <= {1{1'b1}};
	initial
		nl0lOO12 = 0;
	always @ ( posedge refclk_b_in)
		  nl0lOO12 <= nl0lOO11;
	initial
		nl0O0O5 = 0;
	always @ ( posedge refclk_b_in)
		  nl0O0O5 <= nl0O0O6;
	event nl0O0O5_event;
	initial
		#1 ->nl0O0O5_event;
	always @(nl0O0O5_event)
		nl0O0O5 <= {1{1'b1}};
	initial
		nl0O0O6 = 0;
	always @ ( posedge refclk_b_in)
		  nl0O0O6 <= nl0O0O5;
	initial
		nl0O1i10 = 0;
	always @ ( posedge refclk_b_in)
		  nl0O1i10 <= nl0O1i9;
	initial
		nl0O1i9 = 0;
	always @ ( posedge refclk_b_in)
		  nl0O1i9 <= nl0O1i10;
	event nl0O1i9_event;
	initial
		#1 ->nl0O1i9_event;
	always @(nl0O1i9_event)
		nl0O1i9 <= {1{1'b1}};
	initial
		nl0O1O7 = 0;
	always @ ( posedge refclk_b_in)
		  nl0O1O7 <= nl0O1O8;
	event nl0O1O7_event;
	initial
		#1 ->nl0O1O7_event;
	always @(nl0O1O7_event)
		nl0O1O7 <= {1{1'b1}};
	initial
		nl0O1O8 = 0;
	always @ ( posedge refclk_b_in)
		  nl0O1O8 <= nl0O1O7;
	initial
		nl0OiO3 = 0;
	always @ ( posedge refclk_b_in)
		  nl0OiO3 <= nl0OiO4;
	event nl0OiO3_event;
	initial
		#1 ->nl0OiO3_event;
	always @(nl0OiO3_event)
		nl0OiO3 <= {1{1'b1}};
	initial
		nl0OiO4 = 0;
	always @ ( posedge refclk_b_in)
		  nl0OiO4 <= nl0OiO3;
	initial
		nl0OlO1 = 0;
	always @ ( posedge refclk_b_in)
		  nl0OlO1 <= nl0OlO2;
	event nl0OlO1_event;
	initial
		#1 ->nl0OlO1_event;
	always @(nl0OlO1_event)
		nl0OlO1 <= {1{1'b1}};
	initial
		nl0OlO2 = 0;
	always @ ( posedge refclk_b_in)
		  nl0OlO2 <= nl0OlO1;
	initial
	begin
		n000i = 0;
		n001i = 0;
		n001l = 0;
		n010l = 0;
		n01iO = 0;
		n01li = 0;
		n01ll = 0;
		n01lO = 0;
		n01Oi = 0;
		n01Ol = 0;
		n01OO = 0;
	end
	always @ ( posedge fifo_rd_clk or  negedge wire_n001O_CLRN)
	begin
		if (wire_n001O_CLRN == 1'b0) 
		begin
			n000i <= 0;
			n001i <= 0;
			n001l <= 0;
			n010l <= 0;
			n01iO <= 0;
			n01li <= 0;
			n01ll <= 0;
			n01lO <= 0;
			n01Oi <= 0;
			n01Ol <= 0;
			n01OO <= 0;
		end
		else 
		begin
			n000i <= pld_rd_dis;
			n001i <= n001l;
			n001l <= n000i;
			n010l <= wire_n000O_dataout;
			n01iO <= n01li;
			n01li <= nl0O1l;
			n01ll <= wire_n00il_dataout;
			n01lO <= wire_n00ll_dataout;
			n01Oi <= n01Ol;
			n01Ol <= nl0O1l;
			n01OO <= ((n001l ^ n001i) ^ (~ (nl00Ol38 ^ nl00Ol37)));
		end
	end
	assign
		wire_n001O_CLRN = ((nl0i1i36 ^ nl0i1i35) & (~ wire_nl01i_dataout));
	initial
	begin
		n010i = 0;
		n011i = 0;
		n011l = 0;
		n011O = 0;
		n01ii = 0;
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n10ii = 0;
		n10Oi = 0;
		n10Ol = 0;
		n10OO = 0;
		n1i1i = 0;
		n1lOi = 0;
		n1lOl = 0;
		n1lOO = 0;
		n1O0i = 0;
		n1O0l = 0;
		n1O0O = 0;
		n1O1i = 0;
		n1O1l = 0;
		n1O1O = 0;
		n1Oii = 0;
		n1Oil = 0;
		n1OiO = 0;
		n1Oli = 0;
		n1Oll = 0;
		n1OlO = 0;
		n1OOi = 0;
		n1OOl = 0;
		n1OOO = 0;
	end
	always @ ( posedge refclk_b_in or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n010i <= 0;
			n011i <= 0;
			n011l <= 0;
			n011O <= 0;
			n01ii <= 0;
			n100i <= 0;
			n100l <= 0;
			n100O <= 0;
			n10ii <= 0;
			n10Oi <= 0;
			n10Ol <= 0;
			n10OO <= 0;
			n1i1i <= 0;
			n1lOi <= 0;
			n1lOl <= 0;
			n1lOO <= 0;
			n1O0i <= 0;
			n1O0l <= 0;
			n1O0O <= 0;
			n1O1i <= 0;
			n1O1l <= 0;
			n1O1O <= 0;
			n1Oii <= 0;
			n1Oil <= 0;
			n1OiO <= 0;
			n1Oli <= 0;
			n1Oll <= 0;
			n1OlO <= 0;
			n1OOi <= 0;
			n1OOl <= 0;
			n1OOO <= 0;
		end
		else 
		begin
			n010i <= wire_nl11l_dataout;
			n011i <= wire_niO0O_dataout;
			n011l <= wire_niOii_dataout;
			n011O <= wire_nl11i_dataout;
			n01ii <= wire_n10il_dataout;
			n100i <= n100l;
			n100l <= nl0O1l;
			n100O <= wire_n10ll_dataout;
			n10ii <= wire_ni1ll_dataout;
			n10Oi <= n10OO;
			n10Ol <= n1i1i;
			n10OO <= nl000O;
			n1i1i <= nl00ii;
			n1lOi <= wire_n01il_dataout;
			n1lOl <= wire_ni1lO_dataout;
			n1lOO <= wire_n0Oli_dataout;
			n1O0i <= wire_n0OOl_dataout;
			n1O0l <= wire_n0OOO_dataout;
			n1O0O <= wire_ni11i_dataout;
			n1O1i <= wire_n0Oll_dataout;
			n1O1l <= wire_n0OlO_dataout;
			n1O1O <= wire_n0OOi_dataout;
			n1Oii <= wire_ni11l_dataout;
			n1Oil <= wire_ni11O_dataout;
			n1OiO <= wire_ni10i_dataout;
			n1Oli <= wire_ni10l_dataout;
			n1Oll <= wire_ni10O_dataout;
			n1OlO <= wire_ni1ii_dataout;
			n1OOi <= wire_ni1il_dataout;
			n1OOl <= wire_ni1iO_dataout;
			n1OOO <= wire_ni1li_dataout;
		end
	end
	initial
	begin
		n1i0i = 0;
		n1i0O = 0;
		n1i1l = 0;
		n1i1O = 0;
	end
	always @ ( posedge refclk_b_in or  negedge wire_n1i0l_PRN)
	begin
		if (wire_n1i0l_PRN == 1'b0) 
		begin
			n1i0i <= 1;
			n1i0O <= 1;
			n1i1l <= 1;
			n1i1O <= 1;
		end
		else 
		begin
			n1i0i <= (~ nl00li);
			n1i0O <= (~ nl00lO);
			n1i1l <= (~ nl00il);
			n1i1O <= (~ nl00iO);
		end
	end
	assign
		wire_n1i0l_PRN = ((nl00ll42 ^ nl00ll41) & (~ soft_reset));
	initial
	begin
		n1iii = 0;
		n1iil = 0;
		n1iiO = 0;
		n1ili = 0;
		n1ill = 0;
		n1ilO = 0;
		n1iOi = 0;
		n1iOl = 0;
		n1iOO = 0;
		n1l0i = 0;
		n1l0l = 0;
		n1l0O = 0;
		n1l1i = 0;
		n1l1l = 0;
		n1l1O = 0;
		n1lii = 0;
		n1lil = 0;
		n1liO = 0;
		n1lli = 0;
		n1llO = 0;
	end
	always @ ( posedge refclk_b_in or  negedge wire_n1lll_CLRN)
	begin
		if (wire_n1lll_CLRN == 1'b0) 
		begin
			n1iii <= 0;
			n1iil <= 0;
			n1iiO <= 0;
			n1ili <= 0;
			n1ill <= 0;
			n1ilO <= 0;
			n1iOi <= 0;
			n1iOl <= 0;
			n1iOO <= 0;
			n1l0i <= 0;
			n1l0l <= 0;
			n1l0O <= 0;
			n1l1i <= 0;
			n1l1l <= 0;
			n1l1O <= 0;
			n1lii <= 0;
			n1lil <= 0;
			n1liO <= 0;
			n1lli <= 0;
			n1llO <= 0;
		end
		else if  (nl0l1O == 1'b1) 
		begin
			n1iii <= wire_nl0li_dataout;
			n1iil <= wire_nl0ll_dataout;
			n1iiO <= wire_nl0lO_dataout;
			n1ili <= wire_nl0Oi_dataout;
			n1ill <= wire_nl0Ol_dataout;
			n1ilO <= wire_nl0OO_dataout;
			n1iOi <= wire_nli1i_dataout;
			n1iOl <= wire_nli1l_dataout;
			n1iOO <= wire_nli1O_dataout;
			n1l0i <= wire_nliii_dataout;
			n1l0l <= wire_nliil_dataout;
			n1l0O <= wire_nliiO_dataout;
			n1l1i <= wire_nli0i_dataout;
			n1l1l <= wire_nli0l_dataout;
			n1l1O <= wire_nli0O_dataout;
			n1lii <= wire_nlili_dataout;
			n1lil <= wire_nlill_dataout;
			n1liO <= wire_nlilO_dataout;
			n1lli <= wire_nliOi_dataout;
			n1llO <= wire_nliOl_dataout;
		end
	end
	assign
		wire_n1lll_CLRN = ((nl00Oi40 ^ nl00Oi39) & (~ soft_reset));
	initial
	begin
		nl00i = 0;
		nl0ii = 0;
	end
	always @ (fifo_wr_clk or nl0O0l or wire_nl00O_CLRN)
	begin
		if (nl0O0l == 1'b1) 
		begin
			nl00i <= 1;
			nl0ii <= 1;
		end
		else if  (wire_nl00O_CLRN == 1'b0) 
		begin
			nl00i <= 0;
			nl0ii <= 0;
		end
		else 
		if (fifo_wr_clk != nl00O_clk_prev && fifo_wr_clk == 1'b1) 
		begin
			nl00i <= nl0ii;
			nl0ii <= nl0O0i;
		end
		nl00O_clk_prev <= fifo_wr_clk;
	end
	assign
		wire_nl00O_CLRN = (nl0O1O8 ^ nl0O1O7);
	initial
	begin
		nl01O = 0;
		nl1ll = 0;
	end
	always @ (fifo_rd_clk or wire_nl01l_PRN or wire_nl01l_CLRN)
	begin
		if (wire_nl01l_PRN == 1'b0) 
		begin
			nl01O <= 1;
			nl1ll <= 1;
		end
		else if  (wire_nl01l_CLRN == 1'b0) 
		begin
			nl01O <= 0;
			nl1ll <= 0;
		end
		else 
		if (fifo_rd_clk != nl01l_clk_prev && fifo_rd_clk == 1'b1) 
		begin
			nl01O <= nl0O0i;
			nl1ll <= nl01O;
		end
		nl01l_clk_prev <= fifo_rd_clk;
	end
	assign
		wire_nl01l_CLRN = (nl0O1i10 ^ nl0O1i9),
		wire_nl01l_PRN = ((nl0lOO12 ^ nl0lOO11) & (~ nl0O0l));
	initial
	begin
		n000l = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1li = 0;
	end
	always @ (fifo_wr_clk or wire_nl1iO_PRN or wire_nl00l_dataout)
	begin
		if (wire_nl1iO_PRN == 1'b0) 
		begin
			n000l <= 1;
			nl1ii <= 1;
			nl1il <= 1;
			nl1li <= 1;
		end
		else if  (wire_nl00l_dataout == 1'b1) 
		begin
			n000l <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1li <= 0;
		end
		else 
		if (fifo_wr_clk != nl1iO_clk_prev && fifo_wr_clk == 1'b1) 
		begin
			n000l <= wire_nl1lO_dataout;
			nl1ii <= wire_nl1Ol_dataout;
			nl1il <= nl1li;
			nl1li <= nl0O1l;
		end
		nl1iO_clk_prev <= fifo_wr_clk;
	end
	assign
		wire_nl1iO_PRN = (nl0llO16 ^ nl0llO15);
	assign		wire_n000O_dataout = (((~ n010l) & ((((~ wire_nli11i_rptr_bin[0]) & (~ wire_nli11i_rptr_bin[1])) & (~ wire_nli11i_rptr_bin[2])) & (nl0i1l34 ^ nl0i1l33))) === 1'b1) ? wire_n00il_dataout : wire_n00ii_dataout;
	assign		wire_n00i_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[8] : wire_niiO_dataout;
	and(wire_n00ii_dataout, n010l, n01iO);
	assign		wire_n00il_dataout = (rphfifo_master_sel_tx === 1'b1) ? wire_n00iO_dataout : rd_enable_q0_ch0;
	assign		wire_n00iO_dataout = (indv === 1'b1) ? n01lO : rd_enable_ch0;
	assign		wire_n00l_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[9] : wire_nili_dataout;
	assign		wire_n00ll_dataout = (rtxphfifopldctl_en === 1'b1) ? (((~ n01OO) & n01Oi) & (nl0i0i32 ^ nl0i0i31)) : n01Oi;
	assign		wire_n00O_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[10] : wire_nill_dataout;
	and(wire_n00Ol_dataout, wire_n0l1l_dataout, ~(nl0lii));
	or(wire_n00OO_dataout, wire_n0l1O_dataout, nl0lii);
	assign		wire_n01i_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[5] : wire_ni0O_dataout;
	assign		wire_n01il_dataout = (rtx_pipe_enable === 1'b1) ? wire_nl11i_dataout : wire_ni1ll_dataout;
	assign		wire_n01l_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[6] : wire_niii_dataout;
	assign		wire_n01O_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[7] : wire_niil_dataout;
	assign		wire_n0i_dataout = (nl0Oll === 1'b1) ? txd_redun[13] : txd[13];
	or(wire_n0i0i_dataout, wire_n0lii_dataout, nl0lii);
	or(wire_n0i0l_dataout, wire_n0lil_dataout, nl0lii);
	or(wire_n0i0O_dataout, wire_n0liO_dataout, nl0lii);
	or(wire_n0i1i_dataout, wire_n0l0i_dataout, nl0lii);
	or(wire_n0i1l_dataout, wire_n0l0l_dataout, nl0lii);
	or(wire_n0i1O_dataout, wire_n0l0O_dataout, nl0lii);
	assign		wire_n0ii_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[11] : wire_nilO_dataout;
	and(wire_n0iii_dataout, wire_n0lli_dataout, ~(nl0lii));
	or(wire_n0iil_dataout, wire_n0lll_dataout, nl0lii);
	or(wire_n0iiO_dataout, wire_n0llO_dataout, nl0lii);
	assign		wire_n0il_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[12] : wire_niOi_dataout;
	or(wire_n0ili_dataout, wire_n0lOi_dataout, nl0lii);
	or(wire_n0ill_dataout, wire_n0lOl_dataout, nl0lii);
	or(wire_n0ilO_dataout, wire_n0lOO_dataout, nl0lii);
	assign		wire_n0iO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[13] : wire_niOl_dataout;
	or(wire_n0iOi_dataout, wire_n0O1i_dataout, nl0lii);
	or(wire_n0iOl_dataout, wire_n0O1l_dataout, nl0lii);
	and(wire_n0iOO_dataout, wire_n0O1O_dataout, ~(nl0lii));
	assign		wire_n0l_dataout = (nl0Oll === 1'b1) ? txd_redun[14] : txd[14];
	or(wire_n0l0i_dataout, n1iiO, ~(nl0lil));
	assign		wire_n0l0l_dataout = (nl0lil === 1'b1) ? n1ili : indv;
	assign		wire_n0l0O_dataout = (nl0lil === 1'b1) ? n1ill : indv;
	and(wire_n0l1i_dataout, wire_n0O0i_dataout, ~(nl0lii));
	assign		wire_n0l1l_dataout = (nl0lil === 1'b1) ? n1iii : (~ indv);
	assign		wire_n0l1O_dataout = (nl0lil === 1'b1) ? n1iil : (~ indv);
	assign		wire_n0li_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[14] : wire_niOO_dataout;
	assign		wire_n0lii_dataout = (nl0lil === 1'b1) ? n1ilO : indv;
	and(wire_n0lil_dataout, n1iOi, nl0lil);
	assign		wire_n0liO_dataout = (nl0lil === 1'b1) ? n1iOl : indv;
	assign		wire_n0ll_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[15] : wire_nl1i_dataout;
	assign		wire_n0lli_dataout = (nl0lil === 1'b1) ? n1l1l : (~ indv);
	assign		wire_n0lll_dataout = (nl0lil === 1'b1) ? n1l1O : (~ indv);
	or(wire_n0llO_dataout, n1l0i, ~(nl0lil));
	assign		wire_n0lO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[16] : wire_nl1l_dataout;
	assign		wire_n0lOi_dataout = (nl0lil === 1'b1) ? n1l0l : indv;
	assign		wire_n0lOl_dataout = (nl0lil === 1'b1) ? n1l0O : indv;
	assign		wire_n0lOO_dataout = (nl0lil === 1'b1) ? n1lii : indv;
	assign		wire_n0O_dataout = (nl0Oll === 1'b1) ? txd_redun[15] : txd[15];
	and(wire_n0O0i_dataout, wire_nO_dataout, nl0lil);
	and(wire_n0O1i_dataout, n1lil, nl0lil);
	assign		wire_n0O1l_dataout = (nl0lil === 1'b1) ? n1liO : indv;
	and(wire_n0O1O_dataout, wire_nl_dataout, nl0lil);
	assign		wire_n0Oi_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[17] : wire_nl1O_dataout;
	assign		wire_n0Ol_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[18] : wire_nl0i_dataout;
	assign		wire_n0Oli_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[0] : wire_ni1Oi_dataout;
	assign		wire_n0Oll_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[1] : wire_ni1Ol_dataout;
	assign		wire_n0OlO_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[2] : wire_ni1OO_dataout;
	assign		wire_n0OO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[19] : wire_nl0l_dataout;
	assign		wire_n0OOi_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[3] : wire_ni01i_dataout;
	assign		wire_n0OOl_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[4] : wire_ni01l_dataout;
	assign		wire_n0OOO_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[5] : wire_ni01O_dataout;
	assign		wire_n10i_dataout = (nl0Oil === 1'b1) ? txd_redun[34] : txd[34];
	and(wire_n10il_dataout, wire_n10iO_dataout, n100O);
	assign		wire_n10iO_dataout = (rphfifo_master_sel_tx === 1'b1) ? wire_n10li_dataout : (~ fifo_select_in_q0_ch0);
	assign		wire_n10l_dataout = (nl0Oil === 1'b1) ? txd_redun[35] : txd[35];
	assign		wire_n10li_dataout = (indv === 1'b1) ? (~ n01ii) : (~ fifo_select_in_ch0);
	and(wire_n10ll_dataout, wire_n10lO_dataout, n100i);
	or(wire_n10lO_dataout, n01ll, n100O);
	assign		wire_n10O_dataout = (nl0Oil === 1'b1) ? txd_redun[36] : txd[36];
	assign		wire_n11i_dataout = (nl0Oil === 1'b1) ? txd_redun[31] : txd[31];
	assign		wire_n11l_dataout = (nl0Oil === 1'b1) ? txd_redun[32] : txd[32];
	assign		wire_n11O_dataout = (nl0Oil === 1'b1) ? txd_redun[33] : txd[33];
	assign		wire_n1i_dataout = (nl0Oll === 1'b1) ? txd_redun[10] : txd[10];
	assign		wire_n1ii_dataout = (nl0Oil === 1'b1) ? txd_redun[37] : txd[37];
	assign		wire_n1il_dataout = (nl0Oil === 1'b1) ? txd_redun[38] : txd[38];
	assign		wire_n1iO_dataout = (nl0Oil === 1'b1) ? txd_redun[39] : txd[39];
	assign		wire_n1l_dataout = (nl0Oll === 1'b1) ? txd_redun[11] : txd[11];
	assign		wire_n1ll_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[0] : wire_ni1i_dataout;
	assign		wire_n1lO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[1] : wire_ni1l_dataout;
	assign		wire_n1O_dataout = (nl0Oll === 1'b1) ? txd_redun[12] : txd[12];
	assign		wire_n1Oi_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[2] : wire_ni1O_dataout;
	assign		wire_n1Ol_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[3] : wire_ni0i_dataout;
	assign		wire_n1OO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[4] : wire_ni0l_dataout;
	and(wire_ni_dataout, txd_extend[1], rforce_disp);
	assign		wire_ni00i_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[28] : wire_niiii_dataout;
	assign		wire_ni00l_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[29] : wire_niiil_dataout;
	assign		wire_ni00O_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[32] : wire_niiiO_dataout;
	assign		wire_ni01i_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[25] : wire_nii0i_dataout;
	assign		wire_ni01l_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[26] : wire_nii0l_dataout;
	assign		wire_ni01O_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[27] : wire_nii0O_dataout;
	assign		wire_ni0i_dataout = (selftest_en === 1'b1) ? tx_data_sg[3] : wire_nliO_dataout;
	assign		wire_ni0ii_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[33] : wire_niili_dataout;
	assign		wire_ni0il_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[34] : wire_niill_dataout;
	assign		wire_ni0iO_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[35] : wire_niilO_dataout;
	assign		wire_ni0l_dataout = (selftest_en === 1'b1) ? tx_data_sg[4] : wire_nlli_dataout;
	assign		wire_ni0li_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[36] : wire_niiOi_dataout;
	assign		wire_ni0ll_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[37] : wire_niiOl_dataout;
	assign		wire_ni0lO_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[38] : wire_niiOO_dataout;
	assign		wire_ni0O_dataout = (selftest_en === 1'b1) ? tx_data_sg[5] : wire_nlll_dataout;
	assign		wire_ni0Oi_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[39] : wire_nil1i_dataout;
	assign		wire_ni0Ol_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[42] : wire_nil1l_dataout;
	assign		wire_ni0OO_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[43] : wire_nil1O_dataout;
	assign		wire_ni10i_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[11] : wire_ni0ii_dataout;
	assign		wire_ni10l_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[12] : wire_ni0il_dataout;
	assign		wire_ni10O_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[13] : wire_ni0iO_dataout;
	assign		wire_ni11i_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[6] : wire_ni00i_dataout;
	assign		wire_ni11l_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[7] : wire_ni00l_dataout;
	assign		wire_ni11O_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[10] : wire_ni00O_dataout;
	assign		wire_ni1i_dataout = (selftest_en === 1'b1) ? tx_data_sg[0] : wire_nl0O_dataout;
	assign		wire_ni1ii_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[14] : wire_ni0li_dataout;
	assign		wire_ni1il_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[15] : wire_ni0ll_dataout;
	assign		wire_ni1iO_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[16] : wire_ni0lO_dataout;
	assign		wire_ni1l_dataout = (selftest_en === 1'b1) ? tx_data_sg[1] : wire_nlii_dataout;
	assign		wire_ni1li_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[17] : wire_ni0Oi_dataout;
	assign		wire_ni1ll_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[20] : wire_ni0Ol_dataout;
	assign		wire_ni1lO_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[21] : wire_ni0OO_dataout;
	assign		wire_ni1O_dataout = (selftest_en === 1'b1) ? tx_data_sg[2] : wire_nlil_dataout;
	assign		wire_ni1Oi_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[22] : wire_nii1i_dataout;
	assign		wire_ni1Ol_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[23] : wire_nii1l_dataout;
	assign		wire_ni1OO_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[24] : wire_nii1O_dataout;
	assign		wire_nii_dataout = (nl0Oll === 1'b1) ? txd_redun[16] : txd[16];
	assign		wire_nii0i_dataout = (nl0lll === 1'b1) ? wire_n1Ol_dataout : wire_n0i1l_dataout;
	assign		wire_nii0l_dataout = (nl0lll === 1'b1) ? wire_n1OO_dataout : wire_n0i1O_dataout;
	assign		wire_nii0O_dataout = (nl0lll === 1'b1) ? wire_n01i_dataout : wire_n0i0i_dataout;
	assign		wire_nii1i_dataout = (nl0lll === 1'b1) ? wire_n1ll_dataout : wire_n00Ol_dataout;
	assign		wire_nii1l_dataout = (nl0lll === 1'b1) ? wire_n1lO_dataout : wire_n00OO_dataout;
	assign		wire_nii1O_dataout = (nl0lll === 1'b1) ? wire_n1Oi_dataout : wire_n0i1i_dataout;
	assign		wire_niii_dataout = (selftest_en === 1'b1) ? tx_data_sg[6] : wire_nllO_dataout;
	assign		wire_niiii_dataout = (nl0lll === 1'b1) ? wire_n01l_dataout : wire_n0i0l_dataout;
	assign		wire_niiil_dataout = (nl0lll === 1'b1) ? wire_n01O_dataout : wire_n0i0O_dataout;
	assign		wire_niiiO_dataout = (nl0lll === 1'b1) ? wire_n00O_dataout : wire_n0iii_dataout;
	assign		wire_niil_dataout = (selftest_en === 1'b1) ? tx_data_sg[7] : wire_nlOi_dataout;
	assign		wire_niili_dataout = (nl0lll === 1'b1) ? wire_n0ii_dataout : wire_n0iil_dataout;
	assign		wire_niill_dataout = (nl0lll === 1'b1) ? wire_n0il_dataout : wire_n0iiO_dataout;
	assign		wire_niilO_dataout = (nl0lll === 1'b1) ? wire_n0iO_dataout : wire_n0ili_dataout;
	assign		wire_niiO_dataout = (selftest_en === 1'b1) ? tx_control_sg[0] : wire_nlOl_dataout;
	assign		wire_niiOi_dataout = (nl0lll === 1'b1) ? wire_n0li_dataout : wire_n0ill_dataout;
	assign		wire_niiOl_dataout = (nl0lll === 1'b1) ? wire_n0ll_dataout : wire_n0ilO_dataout;
	assign		wire_niiOO_dataout = (nl0lll === 1'b1) ? wire_n0lO_dataout : wire_n0iOi_dataout;
	assign		wire_nil_dataout = (nl0Oll === 1'b1) ? txd_redun[17] : txd[17];
	assign		wire_nil1i_dataout = (nl0lll === 1'b1) ? wire_n0Oi_dataout : wire_n0iOl_dataout;
	assign		wire_nil1l_dataout = (nl0lll === 1'b1) ? wire_nlO_dataout : wire_n0iOO_dataout;
	assign		wire_nil1O_dataout = (nl0lll === 1'b1) ? wire_ni_dataout : wire_n0l1i_dataout;
	and(wire_nili_dataout, wire_nlOO_dataout, ~(selftest_en));
	assign		wire_nill_dataout = (selftest_en === 1'b1) ? tx_data_sg[8] : wire_n1i_dataout;
	assign		wire_nilO_dataout = (selftest_en === 1'b1) ? tx_data_sg[9] : wire_n1l_dataout;
	assign		wire_niO_dataout = (nl0Oll === 1'b1) ? txd_redun[18] : txd[18];
	or(wire_niO0i_dataout, n1iOO, ~(nl0lil));
	or(wire_niO0l_dataout, n1lli, ~(nl0lil));
	assign		wire_niO0O_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[8] : wire_niOil_dataout;
	or(wire_niO1l_dataout, wire_niO0i_dataout, nl0lii);
	or(wire_niO1O_dataout, wire_niO0l_dataout, nl0lii);
	assign		wire_niOi_dataout = (selftest_en === 1'b1) ? tx_data_sg[10] : wire_n1O_dataout;
	assign		wire_niOii_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[18] : wire_niOiO_dataout;
	assign		wire_niOil_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[30] : wire_niOli_dataout;
	assign		wire_niOiO_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[40] : wire_niOll_dataout;
	assign		wire_niOl_dataout = (selftest_en === 1'b1) ? tx_data_sg[11] : wire_n0i_dataout;
	assign		wire_niOli_dataout = (nl0lll === 1'b1) ? wire_n00i_dataout : wire_niO1l_dataout;
	assign		wire_niOll_dataout = (nl0lll === 1'b1) ? wire_n0Ol_dataout : wire_niO1O_dataout;
	and(wire_niOlO_dataout, wire_niOOl_dataout, ~(nl0lii));
	assign		wire_niOO_dataout = (selftest_en === 1'b1) ? tx_data_sg[12] : wire_n0l_dataout;
	and(wire_niOOi_dataout, wire_niOOO_dataout, ~(nl0lii));
	and(wire_niOOl_dataout, n1l1i, nl0lil);
	and(wire_niOOO_dataout, n1llO, nl0lil);
	and(wire_nl_dataout, txd_extend[2], rforce_disp);
	and(wire_nl00l_dataout, nl00i, ~(scan_mode));
	and(wire_nl01i_dataout, nl1ll, ~(scan_mode));
	assign		wire_nl0i_dataout = (selftest_en === 1'b1) ? tx_control_sg[1] : wire_niO_dataout;
	and(wire_nl0l_dataout, wire_nli_dataout, ~(selftest_en));
	assign		wire_nl0li_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[20] : wire_nliOO_dataout;
	assign		wire_nl0ll_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[21] : wire_nll1i_dataout;
	assign		wire_nl0lO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[22] : wire_nll1l_dataout;
	assign		wire_nl0O_dataout = (nl0Oll === 1'b1) ? txd_redun[0] : txd[0];
	assign		wire_nl0Oi_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[23] : wire_nll1O_dataout;
	assign		wire_nl0Ol_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[24] : wire_nll0i_dataout;
	assign		wire_nl0OO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[25] : wire_nll0l_dataout;
	assign		wire_nl10i_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[41] : wire_nl10O_dataout;
	assign		wire_nl10l_dataout = (nl0lll === 1'b1) ? wire_n00l_dataout : wire_niOlO_dataout;
	assign		wire_nl10O_dataout = (nl0lll === 1'b1) ? wire_n0OO_dataout : wire_niOOi_dataout;
	assign		wire_nl11i_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[9] : wire_nl11O_dataout;
	assign		wire_nl11l_dataout = (nl0liO === 1'b1) ? wire_nli11i_data_out[19] : wire_nl10i_dataout;
	assign		wire_nl11O_dataout = (nl0lli === 1'b1) ? wire_nli11i_data_out[31] : wire_nl10l_dataout;
	assign		wire_nl1i_dataout = (selftest_en === 1'b1) ? tx_data_sg[13] : wire_n0O_dataout;
	assign		wire_nl1l_dataout = (selftest_en === 1'b1) ? tx_data_sg[14] : wire_nii_dataout;
	assign		wire_nl1lO_dataout = (rphfifo_master_sel_tx === 1'b1) ? wire_nl1Oi_dataout : wr_enable_q0_ch0;
	assign		wire_nl1O_dataout = (selftest_en === 1'b1) ? tx_data_sg[15] : wire_nil_dataout;
	assign		wire_nl1Oi_dataout = (indv === 1'b1) ? nl1ii : wr_enable_ch0;
	assign		wire_nl1Ol_dataout = (rtxphfifopldctl_en === 1'b1) ? ((nl1il & pld_we) & (nl0lOi14 ^ nl0lOi13)) : nl1il;
	assign		wire_nli_dataout = (nl0Oll === 1'b1) ? txd_redun[19] : txd[19];
	assign		wire_nli0i_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[29] : wire_nlliO_dataout;
	assign		wire_nli0l_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[30] : wire_nllli_dataout;
	assign		wire_nli0O_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[31] : wire_nllll_dataout;
	assign		wire_nli1i_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[26] : wire_nll0O_dataout;
	assign		wire_nli1l_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[27] : wire_nllii_dataout;
	assign		wire_nli1O_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[28] : wire_nllil_dataout;
	assign		wire_nlii_dataout = (nl0Oll === 1'b1) ? txd_redun[1] : txd[1];
	assign		wire_nliii_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[32] : wire_nlllO_dataout;
	assign		wire_nliil_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[33] : wire_nllOi_dataout;
	assign		wire_nliiO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[34] : wire_nllOl_dataout;
	assign		wire_nlil_dataout = (nl0Oll === 1'b1) ? txd_redun[2] : txd[2];
	assign		wire_nlili_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[35] : wire_nllOO_dataout;
	assign		wire_nlill_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[36] : wire_nlO1i_dataout;
	assign		wire_nlilO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[37] : wire_nlO1l_dataout;
	assign		wire_nliO_dataout = (nl0Oll === 1'b1) ? txd_redun[3] : txd[3];
	assign		wire_nliOi_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[38] : wire_nlO1O_dataout;
	assign		wire_nliOl_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[39] : wire_nlO0i_dataout;
	assign		wire_nliOO_dataout = (selftest_en === 1'b1) ? tx_data_sg[8] : wire_nlO0l_dataout;
	assign		wire_nll0i_dataout = (selftest_en === 1'b1) ? tx_data_sg[12] : wire_nlOiO_dataout;
	assign		wire_nll0l_dataout = (selftest_en === 1'b1) ? tx_data_sg[13] : wire_nlOli_dataout;
	assign		wire_nll0O_dataout = (selftest_en === 1'b1) ? tx_data_sg[14] : wire_nlOll_dataout;
	assign		wire_nll1i_dataout = (selftest_en === 1'b1) ? tx_data_sg[9] : wire_nlO0O_dataout;
	assign		wire_nll1l_dataout = (selftest_en === 1'b1) ? tx_data_sg[10] : wire_nlOii_dataout;
	assign		wire_nll1O_dataout = (selftest_en === 1'b1) ? tx_data_sg[11] : wire_nlOil_dataout;
	assign		wire_nlli_dataout = (nl0Oll === 1'b1) ? txd_redun[4] : txd[4];
	assign		wire_nllii_dataout = (selftest_en === 1'b1) ? tx_data_sg[15] : wire_nlOlO_dataout;
	assign		wire_nllil_dataout = (selftest_en === 1'b1) ? tx_control_sg[1] : wire_nlOOi_dataout;
	and(wire_nlliO_dataout, wire_nlOOl_dataout, ~(selftest_en));
	assign		wire_nlll_dataout = (nl0Oll === 1'b1) ? txd_redun[5] : txd[5];
	assign		wire_nllli_dataout = (selftest_en === 1'b1) ? tx_data_sg[24] : wire_nlOOO_dataout;
	assign		wire_nllll_dataout = (selftest_en === 1'b1) ? tx_data_sg[25] : wire_n11i_dataout;
	assign		wire_nlllO_dataout = (selftest_en === 1'b1) ? tx_data_sg[26] : wire_n11l_dataout;
	assign		wire_nllO_dataout = (nl0Oll === 1'b1) ? txd_redun[6] : txd[6];
	assign		wire_nllOi_dataout = (selftest_en === 1'b1) ? tx_data_sg[27] : wire_n11O_dataout;
	assign		wire_nllOl_dataout = (selftest_en === 1'b1) ? tx_data_sg[28] : wire_n10i_dataout;
	assign		wire_nllOO_dataout = (selftest_en === 1'b1) ? tx_data_sg[29] : wire_n10l_dataout;
	and(wire_nlO_dataout, txd_extend[0], rforce_disp);
	and(wire_nlO0i_dataout, wire_n1iO_dataout, ~(selftest_en));
	assign		wire_nlO0l_dataout = (nl0Oil === 1'b1) ? txd_redun[20] : txd[20];
	assign		wire_nlO0O_dataout = (nl0Oil === 1'b1) ? txd_redun[21] : txd[21];
	assign		wire_nlO1i_dataout = (selftest_en === 1'b1) ? tx_data_sg[30] : wire_n10O_dataout;
	assign		wire_nlO1l_dataout = (selftest_en === 1'b1) ? tx_data_sg[31] : wire_n1ii_dataout;
	assign		wire_nlO1O_dataout = (selftest_en === 1'b1) ? tx_control_sg[3] : wire_n1il_dataout;
	assign		wire_nlOi_dataout = (nl0Oll === 1'b1) ? txd_redun[7] : txd[7];
	assign		wire_nlOii_dataout = (nl0Oil === 1'b1) ? txd_redun[22] : txd[22];
	assign		wire_nlOil_dataout = (nl0Oil === 1'b1) ? txd_redun[23] : txd[23];
	assign		wire_nlOiO_dataout = (nl0Oil === 1'b1) ? txd_redun[24] : txd[24];
	assign		wire_nlOl_dataout = (nl0Oll === 1'b1) ? txd_redun[8] : txd[8];
	assign		wire_nlOli_dataout = (nl0Oil === 1'b1) ? txd_redun[25] : txd[25];
	assign		wire_nlOll_dataout = (nl0Oil === 1'b1) ? txd_redun[26] : txd[26];
	assign		wire_nlOlO_dataout = (nl0Oil === 1'b1) ? txd_redun[27] : txd[27];
	assign		wire_nlOO_dataout = (nl0Oll === 1'b1) ? txd_redun[9] : txd[9];
	assign		wire_nlOOi_dataout = (nl0Oil === 1'b1) ? txd_redun[28] : txd[28];
	assign		wire_nlOOl_dataout = (nl0Oil === 1'b1) ? txd_redun[29] : txd[29];
	assign		wire_nlOOO_dataout = (nl0Oil === 1'b1) ? txd_redun[30] : txd[30];
	and(wire_nO_dataout, txd_extend[3], rforce_disp);
	stratixiigx_hssi_tx_ph_fifo   nli11i
	( 
	.bypass_en(txfifo_dis),
	.data_out(wire_nli11i_data_out),
	.din({wire_nO_dataout, wire_nl_dataout, wire_nliOl_dataout, wire_nliOi_dataout, wire_nlilO_dataout, wire_nlill_dataout, wire_nlili_dataout, wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout, wire_nli0l_dataout, wire_nli0i_dataout, wire_nli1O_dataout, wire_nli1l_dataout, wire_nli1i_dataout, wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout, wire_nl0ll_dataout, wire_nl0li_dataout, wire_ni_dataout, wire_nlO_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout}),
	.lowlatency_en(rtxfifo_lowlatency_en),
	.ph_fifo_empty(wire_nli11i_ph_fifo_empty),
	.ph_fifo_full(wire_nli11i_ph_fifo_full),
	.rd_clk(fifo_rd_clk),
	.re(n01ll),
	.rptr_bin(wire_nli11i_rptr_bin),
	.rst_rclk(wire_nl01i_dataout),
	.rst_wclk(wire_nl00l_dataout),
	.we(n000l),
	.wptr_bin(wire_nli11i_wptr_bin),
	.wr_clk(fifo_wr_clk));
	assign
		d21_5_eq_n = {n1i0O, n1i0i},
		d2_2_eq_n = {n1i1O, n1i1l},
		fifo_select_out = n01ii,
		k_det = {n10Ol, n10Oi},
		nl000O = ((((((((wire_niO0O_dataout & wire_ni11l_dataout) & (~ wire_ni11i_dataout)) & wire_n0OOO_dataout) & wire_n0OOl_dataout) & wire_n0OOi_dataout) & wire_n0OlO_dataout) & (~ wire_n0Oll_dataout)) & (~ wire_n0Oli_dataout)),
		nl00ii = (((((((((wire_niOii_dataout & wire_ni1li_dataout) & (~ wire_ni1iO_dataout)) & wire_ni1il_dataout) & wire_ni1ii_dataout) & wire_ni10O_dataout) & wire_ni10l_dataout) & (~ wire_ni10i_dataout)) & (~ wire_ni11O_dataout)) & (nl001l46 ^ nl001l45)),
		nl00il = (((((((((~ wire_niO0O_dataout) & (~ wire_ni11l_dataout)) & wire_ni11i_dataout) & (~ wire_n0OOO_dataout)) & (~ wire_n0OOl_dataout)) & (~ wire_n0OOi_dataout)) & (~ wire_n0OlO_dataout)) & wire_n0Oll_dataout) & (~ wire_n0Oli_dataout)),
		nl00iO = (((((((((~ wire_niOii_dataout) & (~ wire_ni1li_dataout)) & wire_ni1iO_dataout) & (~ wire_ni1il_dataout)) & (~ wire_ni1ii_dataout)) & (~ wire_ni10O_dataout)) & (~ wire_ni10l_dataout)) & wire_ni10i_dataout) & (~ wire_ni11O_dataout)),
		nl00li = ((((((((((~ wire_niO0O_dataout) & wire_ni11l_dataout) & (~ wire_ni11i_dataout)) & wire_n0OOO_dataout) & wire_n0OOl_dataout) & (~ wire_n0OOi_dataout)) & wire_n0OlO_dataout) & (~ wire_n0Oll_dataout)) & wire_n0Oli_dataout) & (nl000i44 ^ nl000i43)),
		nl00lO = (((((((((~ wire_niOii_dataout) & wire_ni1li_dataout) & (~ wire_ni1iO_dataout)) & wire_ni1il_dataout) & wire_ni1ii_dataout) & (~ wire_ni10O_dataout)) & wire_ni10l_dataout) & (~ wire_ni10i_dataout)) & wire_ni11O_dataout),
		nl0l0O = (n010l & (~ txfifo_dis)),
		nl0l1O = ((~ n01ii) & dwidth),
		nl0lii = ((~ rforce_kchar) & rforce_echar),
		nl0lil = ((((((dwidth & txfifo_dis) & n01ii) & (nl0iil28 ^ nl0iil27)) & (~ rforce_kchar)) & (~ rforce_echar)) & (nl0i0O30 ^ nl0i0O29)),
		nl0liO = (((((n01ii | (~ dwidth)) & nl0l0O) & (~ rforce_kchar)) & (~ rforce_echar)) & (nl0l0i18 ^ nl0l0i17)),
		nl0lli = (((((nl0l0O & nl0l1O) & (nl0l1i20 ^ nl0l1i19)) & (~ rforce_kchar)) & (nl0iOl22 ^ nl0iOl21)) & (~ rforce_echar)),
		nl0lll = (((((((~ n01ii) | (~ dwidth)) & txfifo_dis) & (~ rforce_kchar)) & (nl0ilO24 ^ nl0ilO23)) & (~ rforce_echar)) & (nl0ili26 ^ nl0ili25)),
		nl0O0i = 1'b0,
		nl0O0l = (((rtxfifo_urst_en & txfifo_urst) | soft_reset) | (~ (nl0O0O6 ^ nl0O0O5))),
		nl0O1l = 1'b1,
		nl0Oil = ((((redund_ctl[0] | redund_ctl[1]) | redund_ctl[2]) | redund_ctl[3]) | (~ (nl0OiO4 ^ nl0OiO3))),
		nl0Oll = ((((redund_ctl[0] | redund_ctl[1]) | redund_ctl[2]) | redund_ctl[3]) | (~ (nl0OlO2 ^ nl0OlO1))),
		ph_fifo_empty = wire_nli11i_ph_fifo_empty,
		ph_fifo_full = wire_nli11i_ph_fifo_full,
		pipe_electric_idle = n10ii,
		rd_enable2 = n01ll,
		rd_enable_out = n01lO,
		rd_enable_sync = n010l,
		rptr_bin = {wire_nli11i_rptr_bin[2:0]},
		soft_reset_wclk1 = wire_nl00l_dataout,
		tx_ctl_tc = {n011l, n011i},
		tx_data_9_tc = {n010i, n011O},
		tx_data_tc = {n1OOO, n1OOl, n1OOi, n1OlO, n1Oll, n1Oli, n1OiO, n1Oil, n1Oii, n1O0O, n1O0l, n1O0i, n1O1O, n1O1l, n1O1i, n1lOO},
		txd_extend_tc = {n1lOl, n1lOi},
		wptr_bin = {wire_nli11i_wptr_bin[2:0]},
		wr_enable2 = n000l,
		wr_enable_out = nl1ii;
endmodule //stratixiigx_hssi_tx_ctrl
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 211 mux21 446 oper_add 10 oper_selector 88 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_bist_gen
	( 
	bist_ctl_sg,
	bist_data_sg,
	rbist_sel,
	rbisten_tx,
	rcxpat_chnl_sel,
	rdwidth_tx,
	rpma_doublewidth_tx,
	rpmadwidth_tx,
	soft_reset,
	tx_clk) /* synthesis synthesis_clearbox=1 */;
	output   [1:0]  bist_ctl_sg;
	output   [15:0]  bist_data_sg;
	input   [1:0]  rbist_sel;
	input   rbisten_tx;
	input   [1:0]  rcxpat_chnl_sel;
	input   rdwidth_tx;
	input   rpma_doublewidth_tx;
	input   rpmadwidth_tx;
	input   soft_reset;
	input   tx_clk;

	reg	ni001l45;
	reg	ni001l46;
	reg	nii00O39;
	reg	nii00O40;
	reg	nii01O41;
	reg	nii01O42;
	reg	nii0il37;
	reg	nii0il38;
	reg	nii0li35;
	reg	nii0li36;
	reg	nii0lO33;
	reg	nii0lO34;
	reg	nii0OO31;
	reg	nii0OO32;
	reg	nii1OO43;
	reg	nii1OO44;
	reg	niii0i23;
	reg	niii0i24;
	reg	niii0O21;
	reg	niii0O22;
	reg	niii1i29;
	reg	niii1i30;
	reg	niii1l27;
	reg	niii1l28;
	reg	niii1O25;
	reg	niii1O26;
	reg	niillO19;
	reg	niillO20;
	reg	niilOi17;
	reg	niilOi18;
	reg	niilOO15;
	reg	niilOO16;
	reg	niiO0i10;
	reg	niiO0i9;
	reg	niiO0O7;
	reg	niiO0O8;
	reg	niiO1i13;
	reg	niiO1i14;
	reg	niiO1l11;
	reg	niiO1l12;
	reg	niiOll5;
	reg	niiOll6;
	reg	niiOOl3;
	reg	niiOOl4;
	reg	nil11i1;
	reg	nil11i2;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n101i;
	reg	n101l;
	reg	n101O;
	reg	n10ii;
	reg	n10il;
	reg	n10iO;
	reg	n10li;
	reg	n10ll;
	reg	n10lO;
	reg	n10Oi;
	reg	n10Ol;
	reg	n10OO;
	reg	n110i;
	reg	n110l;
	reg	n110O;
	reg	n111i;
	reg	n111l;
	reg	n111O;
	reg	n11ii;
	reg	n11il;
	reg	n11iO;
	reg	n11li;
	reg	n11ll;
	reg	n11lO;
	reg	n11Oi;
	reg	n11Ol;
	reg	n11OO;
	reg	n1i0i;
	reg	n1i0l;
	reg	n1i0O;
	reg	n1i1i;
	reg	n1i1l;
	reg	n1i1O;
	reg	n1iii;
	reg	n1iil;
	reg	n1iiO;
	reg	n1ili;
	reg	n1ill;
	reg	n1ilO;
	reg	n1iOi;
	reg	n1iOl;
	reg	n1iOO;
	reg	n1l0i;
	reg	n1l0l;
	reg	n1l1i;
	reg	n1l1l;
	reg	n1l1O;
	reg	n1lii;
	reg	nliliO;
	reg	nlOOil;
	reg	nlOOiO;
	reg	nlOOli;
	reg	nlOOll;
	reg	nlOOlO;
	reg	nlOOOi;
	reg	nlOOOl;
	reg	nlOOOO;
	reg	n1liO;
	reg	nl00il;
	reg	nl00iO;
	reg	nl00li;
	reg	nl00ll;
	reg	nl00lO;
	reg	nl00Oi;
	reg	nl00Ol;
	reg	nl00OO;
	reg	nl0i0i;
	reg	nl0i0l;
	reg	nl0i0O;
	reg	nl0i1i;
	reg	nl0i1l;
	reg	nl0i1O;
	reg	nl0iii;
	reg	nl0iil;
	reg	nl0iiO;
	reg	nl0ili;
	reg	nl0ill;
	reg	nl0ilO;
	reg	nl0iOi;
	reg	nl0iOl;
	reg	nl0iOO;
	reg	nl0l0i;
	reg	nl0l0l;
	reg	nl0l0O;
	reg	nl0l1i;
	reg	nl0l1l;
	reg	nl0l1O;
	reg	nl0lii;
	reg	nl0lil;
	reg	nl0liO;
	reg	nl0lli;
	reg	nl0lll;
	reg	nl0llO;
	reg	nl0lOi;
	reg	nl0lOl;
	reg	nl0lOO;
	reg	nl0O0i;
	reg	nl0O0l;
	reg	nl0O0O;
	reg	nl0O1i;
	reg	nl0O1l;
	reg	nl0O1O;
	reg	nl0Oii;
	reg	nl0Oil;
	reg	nl0OiO;
	reg	nl0Oli;
	reg	nl0Oll;
	reg	nl0OlO;
	reg	nl0OOi;
	reg	nl0OOl;
	reg	nli11i;
	reg	nl0OOO_clk_prev;
	wire	wire_nl0OOO_PRN;
	reg	nli11O;
	reg	n0lOi;
	reg	niO0l;
	reg	niO0O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOli;
	reg	niOll;
	reg	niOlO;
	reg	niOOi;
	reg	niOOl;
	reg	niOOO;
	reg	nl00i;
	reg	nl00l;
	reg	nl00O;
	reg	nl01i;
	reg	nl01l;
	reg	nl01O;
	reg	nl0ii;
	reg	nl0il;
	reg	nl0iO;
	reg	nl0li;
	reg	nl0ll;
	reg	nl0lO;
	reg	nl0Oi;
	reg	nl0Ol;
	reg	nl0OO;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	nl1OO;
	reg	nli0i;
	reg	nli0l;
	reg	nli0O;
	reg	nli1i;
	reg	nli1l;
	reg	nli1O;
	reg	nliil;
	reg	nlili;
	reg	nliiO_clk_prev;
	wire	wire_nliiO_CLRN;
	wire	wire_nliiO_PRN;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nili_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilil_dataout;
	wire	wire_niliO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO0Ol_dataout;
	wire	wire_niO0OO_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1i_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl0i_dataout;
	wire	wire_niOl0l_dataout;
	wire	wire_niOl0O_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOl1O_dataout;
	wire	wire_niOlii_dataout;
	wire	wire_niOlil_dataout;
	wire	wire_niOliO_dataout;
	wire	wire_niOlli_dataout;
	wire	wire_niOlll_dataout;
	wire	wire_niOllO_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOlOl_dataout;
	wire	wire_niOlOO_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOO0i_dataout;
	wire	wire_niOO0l_dataout;
	wire	wire_niOO0O_dataout;
	wire	wire_niOO1i_dataout;
	wire	wire_niOO1l_dataout;
	wire	wire_niOO1O_dataout;
	wire	wire_niOOii_dataout;
	wire	wire_niOOil_dataout;
	wire	wire_niOOiO_dataout;
	wire	wire_niOOli_dataout;
	wire	wire_niOOll_dataout;
	wire	wire_niOOlO_dataout;
	wire	wire_niOOOi_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_niOOOO_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl000O_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl011i_dataout;
	wire	wire_nl011l_dataout;
	wire	wire_nl011O_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl100i_dataout;
	wire	wire_nl100l_dataout;
	wire	wire_nl100O_dataout;
	wire	wire_nl101i_dataout;
	wire	wire_nl101l_dataout;
	wire	wire_nl101O_dataout;
	wire	wire_nl10ii_dataout;
	wire	wire_nl10il_dataout;
	wire	wire_nl10iO_dataout;
	wire	wire_nl10li_dataout;
	wire	wire_nl10ll_dataout;
	wire	wire_nl10lO_dataout;
	wire	wire_nl10Oi_dataout;
	wire	wire_nl10Ol_dataout;
	wire	wire_nl10OO_dataout;
	wire	wire_nl110i_dataout;
	wire	wire_nl110l_dataout;
	wire	wire_nl110O_dataout;
	wire	wire_nl111i_dataout;
	wire	wire_nl111l_dataout;
	wire	wire_nl111O_dataout;
	wire	wire_nl11ii_dataout;
	wire	wire_nl11il_dataout;
	wire	wire_nl11iO_dataout;
	wire	wire_nl11li_dataout;
	wire	wire_nl11ll_dataout;
	wire	wire_nl11lO_dataout;
	wire	wire_nl11Oi_dataout;
	wire	wire_nl11Ol_dataout;
	wire	wire_nl11OO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0i_dataout;
	wire	wire_nl1i0l_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1i1i_dataout;
	wire	wire_nl1i1l_dataout;
	wire	wire_nl1i1O_dataout;
	wire	wire_nl1iii_dataout;
	wire	wire_nl1iil_dataout;
	wire	wire_nl1iiO_dataout;
	wire	wire_nl1ili_dataout;
	wire	wire_nl1ill_dataout;
	wire	wire_nl1ilO_dataout;
	wire	wire_nl1iOi_dataout;
	wire	wire_nl1iOl_dataout;
	wire	wire_nl1iOO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l0i_dataout;
	wire	wire_nl1l0l_dataout;
	wire	wire_nl1l0O_dataout;
	wire	wire_nl1l1i_dataout;
	wire	wire_nl1l1l_dataout;
	wire	wire_nl1l1O_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O0i_dataout;
	wire	wire_nl1O0l_dataout;
	wire	wire_nl1O0O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1OiO_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1Oll_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli10i_dataout;
	wire	wire_nli10l_dataout;
	wire	wire_nli10O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlillO_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll11i_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0i_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOil_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO00l_dataout;
	wire	wire_nlO00O_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO0ii_dataout;
	wire	wire_nlO0il_dataout;
	wire	wire_nlO0iO_dataout;
	wire	wire_nlO0li_dataout;
	wire	wire_nlO0ll_dataout;
	wire	wire_nlO0lO_dataout;
	wire	wire_nlO0Oi_dataout;
	wire	wire_nlO0Ol_dataout;
	wire	wire_nlO0OO_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11l_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOi0i_dataout;
	wire	wire_nlOi0O_dataout;
	wire	wire_nlOi1i_dataout;
	wire	wire_nlOi1l_dataout;
	wire	wire_nlOi1O_dataout;
	wire	wire_nlOiii_dataout;
	wire	wire_nlOiil_dataout;
	wire	wire_nlOiiO_dataout;
	wire	wire_nlOili_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOliO_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllO_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO0i_dataout;
	wire	wire_nlOO0l_dataout;
	wire	wire_nlOO0O_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOO1l_dataout;
	wire	wire_nlOO1O_dataout;
	wire  [8:0]   wire_n00Oi_o;
	wire  [3:0]   wire_n01iO_o;
	wire  [2:0]   wire_n1lOi_o;
	wire  [5:0]   wire_n1Oll_o;
	wire  [2:0]   wire_n1OOO_o;
	wire  [6:0]   wire_nli0ll_o;
	wire  [6:0]   wire_nli0lO_o;
	wire  [7:0]   wire_nli0Oi_o;
	wire  [2:0]   wire_nliOl_o;
	wire  [4:0]   wire_nllli_o;
	wire  wire_n0iii_o;
	wire  wire_n0iil_o;
	wire  wire_n0iiO_o;
	wire  wire_n0ilO_o;
	wire  wire_n0iOl_o;
	wire  wire_n0l1i_o;
	wire  wire_n0l1O_o;
	wire  wire_n0lii_o;
	wire  wire_n0lil_o;
	wire  wire_n0liO_o;
	wire  wire_n0lli_o;
	wire  wire_n0lOl_o;
	wire  wire_n0O0l_o;
	wire  wire_n0O1l_o;
	wire  wire_n0Oil_o;
	wire  wire_n0Oll_o;
	wire  wire_n0OOl_o;
	wire  wire_ni00l_o;
	wire  wire_ni01i_o;
	wire  wire_ni01O_o;
	wire  wire_ni0ii_o;
	wire  wire_ni0iO_o;
	wire  wire_ni0ll_o;
	wire  wire_ni0Oi_o;
	wire  wire_ni10i_o;
	wire  wire_ni11l_o;
	wire  wire_ni1Ol_o;
	wire  wire_nil00l_o;
	wire  wire_nil01O_o;
	wire  wire_nil0il_o;
	wire  wire_nil0li_o;
	wire  wire_nil0Oi_o;
	wire  wire_nil1li_o;
	wire  wire_nil1lO_o;
	wire  wire_nil1OO_o;
	wire  wire_nili0i_o;
	wire  wire_nili0O_o;
	wire  wire_nili1i_o;
	wire  wire_niliil_o;
	wire  wire_nilili_o;
	wire  wire_nililO_o;
	wire  wire_niliOl_o;
	wire  wire_nill0O_o;
	wire  wire_nill1i_o;
	wire  wire_nill1O_o;
	wire  wire_nillil_o;
	wire  wire_nillli_o;
	wire  wire_nilllO_o;
	wire  wire_nillOl_o;
	wire  wire_nilO0l_o;
	wire  wire_nilO1i_o;
	wire  wire_nilO1O_o;
	wire  wire_nilOii_o;
	wire  wire_nilOiO_o;
	wire  wire_nilOli_o;
	wire  wire_nilOlO_o;
	wire  wire_nilOOl_o;
	wire  wire_niO11i_o;
	wire  wire_nlilOi_o;
	wire  wire_nliO0l_o;
	wire  wire_nliO1i_o;
	wire  wire_nliO1O_o;
	wire  wire_nliOii_o;
	wire  wire_nliOli_o;
	wire  wire_nliOlO_o;
	wire  wire_nliOOi_o;
	wire  wire_nliOOl_o;
	wire  wire_nll00O_o;
	wire  wire_nll01i_o;
	wire  wire_nll01O_o;
	wire  wire_nll0iO_o;
	wire  wire_nll0lO_o;
	wire  wire_nll0OO_o;
	wire  wire_nll10i_o;
	wire  wire_nll10O_o;
	wire  wire_nll11l_o;
	wire  wire_nll1il_o;
	wire  wire_nll1ll_o;
	wire  wire_nll1Ol_o;
	wire  wire_nlli0i_o;
	wire  wire_nlliil_o;
	wire  wire_nllili_o;
	wire  wire_nllilO_o;
	wire  wire_nlliOi_o;
	wire  wire_nlliOO_o;
	wire  wire_nlll0i_o;
	wire  wire_nlll0O_o;
	wire  wire_nlll1l_o;
	wire  ni000i;
	wire  ni000l;
	wire  ni000O;
	wire  ni001i;
	wire  ni001O;
	wire  ni00ii;
	wire  ni00il;
	wire  ni00iO;
	wire  ni00li;
	wire  ni00ll;
	wire  ni00lO;
	wire  ni00Oi;
	wire  ni00Ol;
	wire  ni00OO;
	wire  ni010i;
	wire  ni010l;
	wire  ni010O;
	wire  ni011i;
	wire  ni011l;
	wire  ni011O;
	wire  ni01ii;
	wire  ni01il;
	wire  ni01iO;
	wire  ni01li;
	wire  ni01ll;
	wire  ni01lO;
	wire  ni01Oi;
	wire  ni01Ol;
	wire  ni01OO;
	wire  ni0i0i;
	wire  ni0i0l;
	wire  ni0i0O;
	wire  ni0i1i;
	wire  ni0i1l;
	wire  ni0i1O;
	wire  ni0iii;
	wire  ni0iil;
	wire  ni0iiO;
	wire  ni0ili;
	wire  ni0ill;
	wire  ni0ilO;
	wire  ni0iOi;
	wire  ni0iOl;
	wire  ni0iOO;
	wire  ni0l0i;
	wire  ni0l0l;
	wire  ni0l0O;
	wire  ni0l1i;
	wire  ni0l1l;
	wire  ni0l1O;
	wire  ni0lii;
	wire  ni0lil;
	wire  ni0liO;
	wire  ni0lli;
	wire  ni0lll;
	wire  ni0llO;
	wire  ni0lOi;
	wire  ni0lOl;
	wire  ni0lOO;
	wire  ni0O0i;
	wire  ni0O0l;
	wire  ni0O0O;
	wire  ni0O1i;
	wire  ni0O1l;
	wire  ni0O1O;
	wire  ni0Oii;
	wire  ni0Oil;
	wire  ni0OiO;
	wire  ni0Oli;
	wire  ni0Oll;
	wire  ni0OlO;
	wire  ni0OOi;
	wire  ni0OOl;
	wire  ni0OOO;
	wire  ni1lll;
	wire  ni1llO;
	wire  ni1lOi;
	wire  ni1lOl;
	wire  ni1lOO;
	wire  ni1O0i;
	wire  ni1O0l;
	wire  ni1O0O;
	wire  ni1O1i;
	wire  ni1O1l;
	wire  ni1O1O;
	wire  ni1Oii;
	wire  ni1Oil;
	wire  ni1OiO;
	wire  ni1Oli;
	wire  ni1Oll;
	wire  ni1OlO;
	wire  ni1OOi;
	wire  ni1OOl;
	wire  ni1OOO;
	wire  nii00l;
	wire  nii01i;
	wire  nii01l;
	wire  nii0ii;
	wire  nii0ll;
	wire  nii0Ol;
	wire  nii10i;
	wire  nii10l;
	wire  nii10O;
	wire  nii11i;
	wire  nii11l;
	wire  nii11O;
	wire  nii1ii;
	wire  nii1il;
	wire  nii1iO;
	wire  nii1li;
	wire  nii1ll;
	wire  nii1lO;
	wire  nii1Oi;
	wire  nii1Ol;
	wire  niii0l;
	wire  niiiil;
	wire  niiiiO;
	wire  niiili;
	wire  niiill;
	wire  niiilO;
	wire  niiiOi;
	wire  niiiOl;
	wire  niiiOO;
	wire  niil0i;
	wire  niil0l;
	wire  niil0O;
	wire  niil1i;
	wire  niil1l;
	wire  niil1O;
	wire  niilii;
	wire  niilil;
	wire  niiliO;
	wire  niilli;
	wire  niilll;
	wire  niilOl;
	wire  niiOil;
	wire  niiOiO;
	wire  niiOli;
	wire  niiOOi;

	initial
		ni001l45 = 0;
	always @ ( posedge tx_clk)
		  ni001l45 <= ni001l46;
	event ni001l45_event;
	initial
		#1 ->ni001l45_event;
	always @(ni001l45_event)
		ni001l45 <= {1{1'b1}};
	initial
		ni001l46 = 0;
	always @ ( posedge tx_clk)
		  ni001l46 <= ni001l45;
	initial
		nii00O39 = 0;
	always @ ( posedge tx_clk)
		  nii00O39 <= nii00O40;
	event nii00O39_event;
	initial
		#1 ->nii00O39_event;
	always @(nii00O39_event)
		nii00O39 <= {1{1'b1}};
	initial
		nii00O40 = 0;
	always @ ( posedge tx_clk)
		  nii00O40 <= nii00O39;
	initial
		nii01O41 = 0;
	always @ ( posedge tx_clk)
		  nii01O41 <= nii01O42;
	event nii01O41_event;
	initial
		#1 ->nii01O41_event;
	always @(nii01O41_event)
		nii01O41 <= {1{1'b1}};
	initial
		nii01O42 = 0;
	always @ ( posedge tx_clk)
		  nii01O42 <= nii01O41;
	initial
		nii0il37 = 0;
	always @ ( posedge tx_clk)
		  nii0il37 <= nii0il38;
	event nii0il37_event;
	initial
		#1 ->nii0il37_event;
	always @(nii0il37_event)
		nii0il37 <= {1{1'b1}};
	initial
		nii0il38 = 0;
	always @ ( posedge tx_clk)
		  nii0il38 <= nii0il37;
	initial
		nii0li35 = 0;
	always @ ( posedge tx_clk)
		  nii0li35 <= nii0li36;
	event nii0li35_event;
	initial
		#1 ->nii0li35_event;
	always @(nii0li35_event)
		nii0li35 <= {1{1'b1}};
	initial
		nii0li36 = 0;
	always @ ( posedge tx_clk)
		  nii0li36 <= nii0li35;
	initial
		nii0lO33 = 0;
	always @ ( posedge tx_clk)
		  nii0lO33 <= nii0lO34;
	event nii0lO33_event;
	initial
		#1 ->nii0lO33_event;
	always @(nii0lO33_event)
		nii0lO33 <= {1{1'b1}};
	initial
		nii0lO34 = 0;
	always @ ( posedge tx_clk)
		  nii0lO34 <= nii0lO33;
	initial
		nii0OO31 = 0;
	always @ ( posedge tx_clk)
		  nii0OO31 <= nii0OO32;
	event nii0OO31_event;
	initial
		#1 ->nii0OO31_event;
	always @(nii0OO31_event)
		nii0OO31 <= {1{1'b1}};
	initial
		nii0OO32 = 0;
	always @ ( posedge tx_clk)
		  nii0OO32 <= nii0OO31;
	initial
		nii1OO43 = 0;
	always @ ( posedge tx_clk)
		  nii1OO43 <= nii1OO44;
	event nii1OO43_event;
	initial
		#1 ->nii1OO43_event;
	always @(nii1OO43_event)
		nii1OO43 <= {1{1'b1}};
	initial
		nii1OO44 = 0;
	always @ ( posedge tx_clk)
		  nii1OO44 <= nii1OO43;
	initial
		niii0i23 = 0;
	always @ ( posedge tx_clk)
		  niii0i23 <= niii0i24;
	event niii0i23_event;
	initial
		#1 ->niii0i23_event;
	always @(niii0i23_event)
		niii0i23 <= {1{1'b1}};
	initial
		niii0i24 = 0;
	always @ ( posedge tx_clk)
		  niii0i24 <= niii0i23;
	initial
		niii0O21 = 0;
	always @ ( posedge tx_clk)
		  niii0O21 <= niii0O22;
	event niii0O21_event;
	initial
		#1 ->niii0O21_event;
	always @(niii0O21_event)
		niii0O21 <= {1{1'b1}};
	initial
		niii0O22 = 0;
	always @ ( posedge tx_clk)
		  niii0O22 <= niii0O21;
	initial
		niii1i29 = 0;
	always @ ( posedge tx_clk)
		  niii1i29 <= niii1i30;
	event niii1i29_event;
	initial
		#1 ->niii1i29_event;
	always @(niii1i29_event)
		niii1i29 <= {1{1'b1}};
	initial
		niii1i30 = 0;
	always @ ( posedge tx_clk)
		  niii1i30 <= niii1i29;
	initial
		niii1l27 = 0;
	always @ ( posedge tx_clk)
		  niii1l27 <= niii1l28;
	event niii1l27_event;
	initial
		#1 ->niii1l27_event;
	always @(niii1l27_event)
		niii1l27 <= {1{1'b1}};
	initial
		niii1l28 = 0;
	always @ ( posedge tx_clk)
		  niii1l28 <= niii1l27;
	initial
		niii1O25 = 0;
	always @ ( posedge tx_clk)
		  niii1O25 <= niii1O26;
	event niii1O25_event;
	initial
		#1 ->niii1O25_event;
	always @(niii1O25_event)
		niii1O25 <= {1{1'b1}};
	initial
		niii1O26 = 0;
	always @ ( posedge tx_clk)
		  niii1O26 <= niii1O25;
	initial
		niillO19 = 0;
	always @ ( posedge tx_clk)
		  niillO19 <= niillO20;
	event niillO19_event;
	initial
		#1 ->niillO19_event;
	always @(niillO19_event)
		niillO19 <= {1{1'b1}};
	initial
		niillO20 = 0;
	always @ ( posedge tx_clk)
		  niillO20 <= niillO19;
	initial
		niilOi17 = 0;
	always @ ( posedge tx_clk)
		  niilOi17 <= niilOi18;
	event niilOi17_event;
	initial
		#1 ->niilOi17_event;
	always @(niilOi17_event)
		niilOi17 <= {1{1'b1}};
	initial
		niilOi18 = 0;
	always @ ( posedge tx_clk)
		  niilOi18 <= niilOi17;
	initial
		niilOO15 = 0;
	always @ ( posedge tx_clk)
		  niilOO15 <= niilOO16;
	event niilOO15_event;
	initial
		#1 ->niilOO15_event;
	always @(niilOO15_event)
		niilOO15 <= {1{1'b1}};
	initial
		niilOO16 = 0;
	always @ ( posedge tx_clk)
		  niilOO16 <= niilOO15;
	initial
		niiO0i10 = 0;
	always @ ( posedge tx_clk)
		  niiO0i10 <= niiO0i9;
	initial
		niiO0i9 = 0;
	always @ ( posedge tx_clk)
		  niiO0i9 <= niiO0i10;
	event niiO0i9_event;
	initial
		#1 ->niiO0i9_event;
	always @(niiO0i9_event)
		niiO0i9 <= {1{1'b1}};
	initial
		niiO0O7 = 0;
	always @ ( posedge tx_clk)
		  niiO0O7 <= niiO0O8;
	event niiO0O7_event;
	initial
		#1 ->niiO0O7_event;
	always @(niiO0O7_event)
		niiO0O7 <= {1{1'b1}};
	initial
		niiO0O8 = 0;
	always @ ( posedge tx_clk)
		  niiO0O8 <= niiO0O7;
	initial
		niiO1i13 = 0;
	always @ ( posedge tx_clk)
		  niiO1i13 <= niiO1i14;
	event niiO1i13_event;
	initial
		#1 ->niiO1i13_event;
	always @(niiO1i13_event)
		niiO1i13 <= {1{1'b1}};
	initial
		niiO1i14 = 0;
	always @ ( posedge tx_clk)
		  niiO1i14 <= niiO1i13;
	initial
		niiO1l11 = 0;
	always @ ( posedge tx_clk)
		  niiO1l11 <= niiO1l12;
	event niiO1l11_event;
	initial
		#1 ->niiO1l11_event;
	always @(niiO1l11_event)
		niiO1l11 <= {1{1'b1}};
	initial
		niiO1l12 = 0;
	always @ ( posedge tx_clk)
		  niiO1l12 <= niiO1l11;
	initial
		niiOll5 = 0;
	always @ ( posedge tx_clk)
		  niiOll5 <= niiOll6;
	event niiOll5_event;
	initial
		#1 ->niiOll5_event;
	always @(niiOll5_event)
		niiOll5 <= {1{1'b1}};
	initial
		niiOll6 = 0;
	always @ ( posedge tx_clk)
		  niiOll6 <= niiOll5;
	initial
		niiOOl3 = 0;
	always @ ( posedge tx_clk)
		  niiOOl3 <= niiOOl4;
	event niiOOl3_event;
	initial
		#1 ->niiOOl3_event;
	always @(niiOOl3_event)
		niiOOl3 <= {1{1'b1}};
	initial
		niiOOl4 = 0;
	always @ ( posedge tx_clk)
		  niiOOl4 <= niiOOl3;
	initial
		nil11i1 = 0;
	always @ ( posedge tx_clk)
		  nil11i1 <= nil11i2;
	event nil11i1_event;
	initial
		#1 ->nil11i1_event;
	always @(nil11i1_event)
		nil11i1 <= {1{1'b1}};
	initial
		nil11i2 = 0;
	always @ ( posedge tx_clk)
		  nil11i2 <= nil11i1;
	initial
	begin
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n101i = 0;
		n101l = 0;
		n101O = 0;
		n10ii = 0;
		n10il = 0;
		n10iO = 0;
		n10li = 0;
		n10ll = 0;
		n10lO = 0;
		n10Oi = 0;
		n10Ol = 0;
		n10OO = 0;
		n110i = 0;
		n110l = 0;
		n110O = 0;
		n111i = 0;
		n111l = 0;
		n111O = 0;
		n11ii = 0;
		n11il = 0;
		n11iO = 0;
		n11li = 0;
		n11ll = 0;
		n11lO = 0;
		n11Oi = 0;
		n11Ol = 0;
		n11OO = 0;
		n1i0i = 0;
		n1i0l = 0;
		n1i0O = 0;
		n1i1i = 0;
		n1i1l = 0;
		n1i1O = 0;
		n1iii = 0;
		n1iil = 0;
		n1iiO = 0;
		n1ili = 0;
		n1ill = 0;
		n1ilO = 0;
		n1iOi = 0;
		n1iOl = 0;
		n1iOO = 0;
		n1l0i = 0;
		n1l0l = 0;
		n1l1i = 0;
		n1l1l = 0;
		n1l1O = 0;
		n1lii = 0;
		nliliO = 0;
		nlOOil = 0;
		nlOOiO = 0;
		nlOOli = 0;
		nlOOll = 0;
		nlOOlO = 0;
		nlOOOi = 0;
		nlOOOl = 0;
		nlOOOO = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n100i <= 0;
			n100l <= 0;
			n100O <= 0;
			n101i <= 0;
			n101l <= 0;
			n101O <= 0;
			n10ii <= 0;
			n10il <= 0;
			n10iO <= 0;
			n10li <= 0;
			n10ll <= 0;
			n10lO <= 0;
			n10Oi <= 0;
			n10Ol <= 0;
			n10OO <= 0;
			n110i <= 0;
			n110l <= 0;
			n110O <= 0;
			n111i <= 0;
			n111l <= 0;
			n111O <= 0;
			n11ii <= 0;
			n11il <= 0;
			n11iO <= 0;
			n11li <= 0;
			n11ll <= 0;
			n11lO <= 0;
			n11Oi <= 0;
			n11Ol <= 0;
			n11OO <= 0;
			n1i0i <= 0;
			n1i0l <= 0;
			n1i0O <= 0;
			n1i1i <= 0;
			n1i1l <= 0;
			n1i1O <= 0;
			n1iii <= 0;
			n1iil <= 0;
			n1iiO <= 0;
			n1ili <= 0;
			n1ill <= 0;
			n1ilO <= 0;
			n1iOi <= 0;
			n1iOl <= 0;
			n1iOO <= 0;
			n1l0i <= 0;
			n1l0l <= 0;
			n1l1i <= 0;
			n1l1l <= 0;
			n1l1O <= 0;
			n1lii <= 0;
			nliliO <= 0;
			nlOOil <= 0;
			nlOOiO <= 0;
			nlOOli <= 0;
			nlOOll <= 0;
			nlOOlO <= 0;
			nlOOOi <= 0;
			nlOOOl <= 0;
			nlOOOO <= 0;
		end
		else if  (wire_nll_dataout == 1'b1) 
		begin
			n100i <= wire_nll01O_o;
			n100l <= wire_nll00O_o;
			n100O <= wire_nll0iO_o;
			n101i <= wire_n001O_dataout;
			n101l <= ni0OlO;
			n101O <= wire_nliO1i_o;
			n10ii <= wire_nll0lO_o;
			n10il <= wire_nll0OO_o;
			n10iO <= (~ ni0OOi);
			n10li <= wire_nlli0i_o;
			n10ll <= (~ ni0OOl);
			n10lO <= wire_nlliil_o;
			n10Oi <= wire_nllili_o;
			n10Ol <= wire_nllilO_o;
			n10OO <= wire_nlliOi_o;
			n110i <= wire_n011i_dataout;
			n110l <= wire_n011l_dataout;
			n110O <= wire_n011O_dataout;
			n111i <= wire_n1OlO_dataout;
			n111l <= wire_n1OOi_dataout;
			n111O <= wire_n1OOl_dataout;
			n11ii <= wire_n010i_dataout;
			n11il <= wire_n01li_dataout;
			n11iO <= wire_n01ll_dataout;
			n11li <= wire_n01lO_dataout;
			n11ll <= wire_n01Oi_dataout;
			n11lO <= wire_n01Ol_dataout;
			n11Oi <= wire_n01OO_dataout;
			n11Ol <= wire_n001i_dataout;
			n11OO <= wire_n001l_dataout;
			n1i0i <= wire_nlll0O_o;
			n1i0l <= wire_nliO1O_o;
			n1i0O <= wire_nliO0l_o;
			n1i1i <= wire_nlliOO_o;
			n1i1l <= wire_nlll1l_o;
			n1i1O <= wire_nlll0i_o;
			n1iii <= wire_nliOii_o;
			n1iil <= wire_nliOli_o;
			n1iiO <= wire_nliOll_dataout;
			n1ili <= wire_nliOlO_o;
			n1ill <= wire_nliOOi_o;
			n1ilO <= wire_nliOOl_o;
			n1iOi <= wire_nll11i_dataout;
			n1iOl <= wire_nll11l_o;
			n1iOO <= wire_nll10i_o;
			n1l0i <= wire_nll1Oi_dataout;
			n1l0l <= wire_nll1Ol_o;
			n1l1i <= wire_nll10O_o;
			n1l1l <= wire_nll1il_o;
			n1l1O <= wire_nll1ll_o;
			n1lii <= wire_nll01i_o;
			nliliO <= wire_n1lli_dataout;
			nlOOil <= wire_n1lll_dataout;
			nlOOiO <= wire_n1llO_dataout;
			nlOOli <= wire_n1lOl_dataout;
			nlOOll <= wire_n1lOO_dataout;
			nlOOlO <= wire_n1O1i_dataout;
			nlOOOi <= wire_n1O1l_dataout;
			nlOOOl <= wire_n1O1O_dataout;
			nlOOOO <= wire_n1O0i_dataout;
		end
	end
	initial
	begin
		n1liO = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1liO <= 1;
		end
		else if  (wire_nll_dataout == 1'b1) 
		begin
			n1liO <= niilOl;
		end
	end
	initial
	begin
		nl00il = 0;
		nl00iO = 0;
		nl00li = 0;
		nl00ll = 0;
		nl00lO = 0;
		nl00Oi = 0;
		nl00Ol = 0;
		nl00OO = 0;
		nl0i0i = 0;
		nl0i0l = 0;
		nl0i0O = 0;
		nl0i1i = 0;
		nl0i1l = 0;
		nl0i1O = 0;
		nl0iii = 0;
		nl0iil = 0;
		nl0iiO = 0;
		nl0ili = 0;
		nl0ill = 0;
		nl0ilO = 0;
		nl0iOi = 0;
		nl0iOl = 0;
		nl0iOO = 0;
		nl0l0i = 0;
		nl0l0l = 0;
		nl0l0O = 0;
		nl0l1i = 0;
		nl0l1l = 0;
		nl0l1O = 0;
		nl0lii = 0;
		nl0lil = 0;
		nl0liO = 0;
		nl0lli = 0;
		nl0lll = 0;
		nl0llO = 0;
		nl0lOi = 0;
		nl0lOl = 0;
		nl0lOO = 0;
		nl0O0i = 0;
		nl0O0l = 0;
		nl0O0O = 0;
		nl0O1i = 0;
		nl0O1l = 0;
		nl0O1O = 0;
		nl0Oii = 0;
		nl0Oil = 0;
		nl0OiO = 0;
		nl0Oli = 0;
		nl0Oll = 0;
		nl0OlO = 0;
		nl0OOi = 0;
		nl0OOl = 0;
		nli11i = 0;
	end
	always @ (tx_clk or wire_nl0OOO_PRN or soft_reset)
	begin
		if (wire_nl0OOO_PRN == 1'b0) 
		begin
			nl00il <= 1;
			nl00iO <= 1;
			nl00li <= 1;
			nl00ll <= 1;
			nl00lO <= 1;
			nl00Oi <= 1;
			nl00Ol <= 1;
			nl00OO <= 1;
			nl0i0i <= 1;
			nl0i0l <= 1;
			nl0i0O <= 1;
			nl0i1i <= 1;
			nl0i1l <= 1;
			nl0i1O <= 1;
			nl0iii <= 1;
			nl0iil <= 1;
			nl0iiO <= 1;
			nl0ili <= 1;
			nl0ill <= 1;
			nl0ilO <= 1;
			nl0iOi <= 1;
			nl0iOl <= 1;
			nl0iOO <= 1;
			nl0l0i <= 1;
			nl0l0l <= 1;
			nl0l0O <= 1;
			nl0l1i <= 1;
			nl0l1l <= 1;
			nl0l1O <= 1;
			nl0lii <= 1;
			nl0lil <= 1;
			nl0liO <= 1;
			nl0lli <= 1;
			nl0lll <= 1;
			nl0llO <= 1;
			nl0lOi <= 1;
			nl0lOl <= 1;
			nl0lOO <= 1;
			nl0O0i <= 1;
			nl0O0l <= 1;
			nl0O0O <= 1;
			nl0O1i <= 1;
			nl0O1l <= 1;
			nl0O1O <= 1;
			nl0Oii <= 1;
			nl0Oil <= 1;
			nl0OiO <= 1;
			nl0Oli <= 1;
			nl0Oll <= 1;
			nl0OlO <= 1;
			nl0OOi <= 1;
			nl0OOl <= 1;
			nli11i <= 1;
		end
		else if  (soft_reset == 1'b1) 
		begin
			nl00il <= 0;
			nl00iO <= 0;
			nl00li <= 0;
			nl00ll <= 0;
			nl00lO <= 0;
			nl00Oi <= 0;
			nl00Ol <= 0;
			nl00OO <= 0;
			nl0i0i <= 0;
			nl0i0l <= 0;
			nl0i0O <= 0;
			nl0i1i <= 0;
			nl0i1l <= 0;
			nl0i1O <= 0;
			nl0iii <= 0;
			nl0iil <= 0;
			nl0iiO <= 0;
			nl0ili <= 0;
			nl0ill <= 0;
			nl0ilO <= 0;
			nl0iOi <= 0;
			nl0iOl <= 0;
			nl0iOO <= 0;
			nl0l0i <= 0;
			nl0l0l <= 0;
			nl0l0O <= 0;
			nl0l1i <= 0;
			nl0l1l <= 0;
			nl0l1O <= 0;
			nl0lii <= 0;
			nl0lil <= 0;
			nl0liO <= 0;
			nl0lli <= 0;
			nl0lll <= 0;
			nl0llO <= 0;
			nl0lOi <= 0;
			nl0lOl <= 0;
			nl0lOO <= 0;
			nl0O0i <= 0;
			nl0O0l <= 0;
			nl0O0O <= 0;
			nl0O1i <= 0;
			nl0O1l <= 0;
			nl0O1O <= 0;
			nl0Oii <= 0;
			nl0Oil <= 0;
			nl0OiO <= 0;
			nl0Oli <= 0;
			nl0Oll <= 0;
			nl0OlO <= 0;
			nl0OOi <= 0;
			nl0OOl <= 0;
			nli11i <= 0;
		end
		else 
		if (tx_clk != nl0OOO_clk_prev && tx_clk == 1'b1) 
		begin
			nl00il <= wire_nli10i_dataout;
			nl00iO <= wire_nli10l_dataout;
			nl00li <= wire_nli10O_dataout;
			nl00ll <= wire_nli1ii_dataout;
			nl00lO <= wire_nli1il_dataout;
			nl00Oi <= wire_nli1iO_dataout;
			nl00Ol <= wire_nli1li_dataout;
			nl00OO <= wire_nli1ll_dataout;
			nl0i0i <= wire_nli1OO_dataout;
			nl0i0l <= wire_nli01i_dataout;
			nl0i0O <= wire_nli01l_dataout;
			nl0i1i <= wire_nli1lO_dataout;
			nl0i1l <= wire_nli1Oi_dataout;
			nl0i1O <= wire_nli1Ol_dataout;
			nl0iii <= wire_nli01O_dataout;
			nl0iil <= wire_nli00i_dataout;
			nl0iiO <= wire_nli00l_dataout;
			nl0ili <= wire_nli00O_dataout;
			nl0ill <= wire_nli0ii_dataout;
			nl0ilO <= wire_nli0il_dataout;
			nl0iOi <= wire_nli0iO_dataout;
			nl0iOl <= wire_nli0li_dataout;
			nl0iOO <= (~ (nli11O | nl0OOi));
			nl0l0i <= wire_nil01O_o;
			nl0l0l <= wire_nil00l_o;
			nl0l0O <= wire_nil0il_o;
			nl0l1i <= wire_nil1li_o;
			nl0l1l <= wire_nil1lO_o;
			nl0l1O <= wire_nil1OO_o;
			nl0lii <= wire_nil0li_o;
			nl0lil <= wire_nil0Oi_o;
			nl0liO <= wire_nili1i_o;
			nl0lli <= wire_nili0i_o;
			nl0lll <= wire_nili0O_o;
			nl0llO <= wire_niliil_o;
			nl0lOi <= wire_nilili_o;
			nl0lOl <= wire_nililO_o;
			nl0lOO <= wire_niliOl_o;
			nl0O0i <= wire_nillil_o;
			nl0O0l <= wire_nillli_o;
			nl0O0O <= wire_nilllO_o;
			nl0O1i <= wire_nill1i_o;
			nl0O1l <= wire_nill1O_o;
			nl0O1O <= wire_nill0O_o;
			nl0Oii <= wire_nillOl_o;
			nl0Oil <= wire_nilO1i_o;
			nl0OiO <= wire_nilO1O_o;
			nl0Oli <= wire_nilO0l_o;
			nl0Oll <= wire_nilOii_o;
			nl0OlO <= wire_nilOiO_o;
			nl0OOi <= wire_nilOli_o;
			nl0OOl <= wire_nilOlO_o;
			nli11i <= wire_nilOOl_o;
		end
		nl0OOO_clk_prev <= tx_clk;
	end
	assign
		wire_nl0OOO_PRN = (ni001l46 ^ ni001l45);
	initial
	begin
		nli11O = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nli11O <= 1;
		end
		else 
		begin
			nli11O <= wire_niO11i_o;
		end
	end
	initial
	begin
		n0lOi = 0;
		niO0l = 0;
		niO0O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOli = 0;
		niOll = 0;
		niOlO = 0;
		niOOi = 0;
		niOOl = 0;
		niOOO = 0;
		nl00i = 0;
		nl00l = 0;
		nl00O = 0;
		nl01i = 0;
		nl01l = 0;
		nl01O = 0;
		nl0ii = 0;
		nl0il = 0;
		nl0iO = 0;
		nl0li = 0;
		nl0ll = 0;
		nl0lO = 0;
		nl0Oi = 0;
		nl0Ol = 0;
		nl0OO = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
		nl1OO = 0;
		nli0i = 0;
		nli0l = 0;
		nli0O = 0;
		nli1i = 0;
		nli1l = 0;
		nli1O = 0;
		nliil = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n0lOi <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOli <= 0;
			niOll <= 0;
			niOlO <= 0;
			niOOi <= 0;
			niOOl <= 0;
			niOOO <= 0;
			nl00i <= 0;
			nl00l <= 0;
			nl00O <= 0;
			nl01i <= 0;
			nl01l <= 0;
			nl01O <= 0;
			nl0ii <= 0;
			nl0il <= 0;
			nl0iO <= 0;
			nl0li <= 0;
			nl0ll <= 0;
			nl0lO <= 0;
			nl0Oi <= 0;
			nl0Ol <= 0;
			nl0OO <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
			nl1OO <= 0;
			nli0i <= 0;
			nli0l <= 0;
			nli0O <= 0;
			nli1i <= 0;
			nli1l <= 0;
			nli1O <= 0;
			nliil <= 0;
		end
		else if  (wire_nli_dataout == 1'b1) 
		begin
			n0lOi <= wire_nlill_dataout;
			niO0l <= wire_nlilO_dataout;
			niO0O <= wire_nliOi_dataout;
			niOii <= wire_nliOO_dataout;
			niOil <= wire_nll1i_dataout;
			niOiO <= wire_nll1l_dataout;
			niOli <= wire_nll1O_dataout;
			niOll <= wire_nll0i_dataout;
			niOlO <= niil1l;
			niOOi <= wire_n0ilO_o;
			niOOl <= (~ niil1O);
			niOOO <= niil0i;
			nl00i <= wire_n0lii_o;
			nl00l <= wire_n0lil_o;
			nl00O <= wire_n0liO_o;
			nl01i <= wire_n0l1i_o;
			nl01l <= wire_n0l1O_o;
			nl01O <= wire_n0l0O_dataout;
			nl0ii <= wire_n0lli_o;
			nl0il <= wire_n0llO_dataout;
			nl0iO <= wire_n0lOl_o;
			nl0li <= wire_n0O1i_dataout;
			nl0ll <= wire_n0O1l_o;
			nl0lO <= wire_n0O0i_dataout;
			nl0Oi <= wire_n0O0l_o;
			nl0Ol <= wire_n0Oii_dataout;
			nl0OO <= wire_n0Oil_o;
			nl10i <= (~ niilil);
			nl10l <= (~ niiliO);
			nl10O <= niilli;
			nl11i <= (~ niil0l);
			nl11l <= (~ niil0O);
			nl11O <= (~ niilii);
			nl1ii <= wire_ni1Ol_o;
			nl1il <= wire_ni01i_o;
			nl1iO <= wire_ni01O_o;
			nl1li <= wire_ni00l_o;
			nl1ll <= wire_ni0ii_o;
			nl1lO <= wire_ni0iO_o;
			nl1Oi <= wire_ni0ll_o;
			nl1Ol <= wire_ni0Oi_o;
			nl1OO <= wire_n0iOl_o;
			nli0i <= wire_n0OOl_o;
			nli0l <= wire_ni11i_dataout;
			nli0O <= wire_ni11l_o;
			nli1i <= wire_n0Oli_dataout;
			nli1l <= wire_n0Oll_o;
			nli1O <= wire_n0OOi_dataout;
			nliil <= wire_ni10i_o;
		end
	end
	initial
	begin
		nlili = 0;
	end
	always @ (tx_clk or wire_nliiO_PRN or wire_nliiO_CLRN)
	begin
		if (wire_nliiO_PRN == 1'b0) 
		begin
			nlili <= 1;
		end
		else if  (wire_nliiO_CLRN == 1'b0) 
		begin
			nlili <= 0;
		end
		else if  (wire_nli_dataout == 1'b1) 
		if (tx_clk != nliiO_clk_prev && tx_clk == 1'b1) 
		begin
			nlili <= niilOl;
		end
		nliiO_clk_prev <= tx_clk;
	end
	assign
		wire_nliiO_CLRN = (niilOi18 ^ niilOi17),
		wire_nliiO_PRN = ((niillO20 ^ niillO19) & (~ soft_reset));
	assign		wire_n000i_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[0] : n11il;
	assign		wire_n000l_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[1] : n11iO;
	assign		wire_n000O_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[2] : n11li;
	and(wire_n001i_dataout, wire_n00li_dataout, ~(wire_nlillO_dataout));
	and(wire_n001l_dataout, wire_n00ll_dataout, ~(wire_nlillO_dataout));
	and(wire_n001O_dataout, wire_n00lO_dataout, ~(wire_nlillO_dataout));
	assign		wire_n00i_dataout = (niiOil === 1'b1) ? nl0l0l : wire_niii_dataout;
	assign		wire_n00ii_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[3] : n11ll;
	assign		wire_n00il_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[4] : n11lO;
	assign		wire_n00iO_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[5] : n11Oi;
	assign		wire_n00l_dataout = (niiOil === 1'b1) ? nl0l0O : wire_niil_dataout;
	assign		wire_n00li_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[6] : n11Ol;
	assign		wire_n00ll_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[7] : n11OO;
	assign		wire_n00lO_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[8] : n101i;
	assign		wire_n00O_dataout = (niiOil === 1'b1) ? nl0lii : wire_niiO_dataout;
	and(wire_n010i_dataout, wire_n01il_dataout, ~(wire_nlilll_dataout));
	assign		wire_n010l_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[0] : n110i;
	assign		wire_n010O_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[1] : n110l;
	and(wire_n011i_dataout, wire_n010l_dataout, ~(wire_nlilll_dataout));
	and(wire_n011l_dataout, wire_n010O_dataout, ~(wire_nlilll_dataout));
	and(wire_n011O_dataout, wire_n01ii_dataout, ~(wire_nlilll_dataout));
	assign		wire_n01i_dataout = (niiOil === 1'b1) ? nl0l1l : wire_ni0i_dataout;
	assign		wire_n01ii_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[2] : n110O;
	assign		wire_n01il_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[3] : n11ii;
	assign		wire_n01l_dataout = (niiOil === 1'b1) ? nl0l1O : wire_ni0l_dataout;
	and(wire_n01li_dataout, wire_n000i_dataout, ~(wire_nlillO_dataout));
	and(wire_n01ll_dataout, wire_n000l_dataout, ~(wire_nlillO_dataout));
	and(wire_n01lO_dataout, wire_n000O_dataout, ~(wire_nlillO_dataout));
	assign		wire_n01O_dataout = (niiOil === 1'b1) ? nl0l0i : wire_ni0O_dataout;
	and(wire_n01Oi_dataout, wire_n00ii_dataout, ~(wire_nlillO_dataout));
	and(wire_n01Ol_dataout, wire_n00il_dataout, ~(wire_nlillO_dataout));
	and(wire_n01OO_dataout, wire_n00iO_dataout, ~(wire_nlillO_dataout));
	and(wire_n0i_dataout, nl1ll, niiOli);
	assign		wire_n0ii_dataout = (niiOil === 1'b1) ? nl0lil : wire_nili_dataout;
	assign		wire_n0il_dataout = (niiOil === 1'b1) ? nl0liO : wire_nill_dataout;
	assign		wire_n0iO_dataout = (niiOil === 1'b1) ? nl0lli : wire_nilO_dataout;
	and(wire_n0l_dataout, nl1lO, niiOli);
	and(wire_n0l0O_dataout, (~ niiOOi), nl0ii);
	assign		wire_n0li_dataout = (niiOil === 1'b1) ? nl0lll : wire_niOi_dataout;
	assign		wire_n0ll_dataout = (niiOil === 1'b1) ? nl0llO : wire_niOl_dataout;
	and(wire_n0llO_dataout, (~ niiOOi), nl0iO);
	assign		wire_n0lO_dataout = (niiOil === 1'b1) ? nl0lOi : wire_niOO_dataout;
	and(wire_n0O_dataout, nl1Oi, niiOli);
	and(wire_n0O0i_dataout, (~ niiOOi), nl0Oi);
	and(wire_n0O1i_dataout, (~ niiOOi), nl0ll);
	assign		wire_n0Oi_dataout = (niiOil === 1'b1) ? nl0lOl : wire_nl1i_dataout;
	and(wire_n0Oii_dataout, (~ niiOOi), nl0OO);
	assign		wire_n0Ol_dataout = (niiOil === 1'b1) ? nl0lOO : wire_nl1l_dataout;
	and(wire_n0Oli_dataout, (~ niiOOi), nli1l);
	assign		wire_n0OO_dataout = (niiOil === 1'b1) ? nl0O1i : wire_nl1O_dataout;
	and(wire_n0OOi_dataout, (~ niiOOi), nli0i);
	and(wire_n1i_dataout, nl1il, niiOli);
	and(wire_n1l_dataout, nl1iO, niiOli);
	and(wire_n1lli_dataout, wire_n1lOi_o[0], wire_nlilOi_o);
	and(wire_n1lll_dataout, wire_n1lOi_o[1], wire_nlilOi_o);
	and(wire_n1llO_dataout, wire_n1lOi_o[2], wire_nlilOi_o);
	assign		wire_n1lOl_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[0] : wire_n1O0l_dataout;
	assign		wire_n1lOO_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[1] : wire_n1O0O_dataout;
	and(wire_n1O_dataout, nl1li, niiOli);
	assign		wire_n1O0i_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[5] : wire_n1Oli_dataout;
	and(wire_n1O0l_dataout, nlOOli, ~(wire_nlilii_dataout));
	and(wire_n1O0O_dataout, nlOOll, ~(wire_nlilii_dataout));
	assign		wire_n1O1i_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[2] : wire_n1Oii_dataout;
	assign		wire_n1O1l_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[3] : wire_n1Oil_dataout;
	assign		wire_n1O1O_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[4] : wire_n1OiO_dataout;
	and(wire_n1Oii_dataout, nlOOlO, ~(wire_nlilii_dataout));
	and(wire_n1Oil_dataout, nlOOOi, ~(wire_nlilii_dataout));
	and(wire_n1OiO_dataout, nlOOOl, ~(wire_nlilii_dataout));
	and(wire_n1Oli_dataout, nlOOOO, ~(wire_nlilii_dataout));
	assign		wire_n1OlO_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[0] : n111i;
	assign		wire_n1OOi_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[1] : n111l;
	assign		wire_n1OOl_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[2] : n111O;
	assign		wire_ni0i_dataout = (niiOiO === 1'b1) ? n100i : wire_nlii_dataout;
	assign		wire_ni0l_dataout = (niiOiO === 1'b1) ? n100l : wire_nlil_dataout;
	assign		wire_ni0O_dataout = (niiOiO === 1'b1) ? n100O : wire_nliO_dataout;
	and(wire_ni0OO_dataout, niiiil, ~(niiilO));
	and(wire_ni11i_dataout, wire_nillO_dataout, nli0O);
	assign		wire_ni1i_dataout = (niiOil === 1'b1) ? nl0O1l : wire_nl0i_dataout;
	assign		wire_ni1l_dataout = (niiOil === 1'b1) ? nl0iOO : wire_nl0l_dataout;
	assign		wire_ni1O_dataout = (niiOil === 1'b1) ? nl0l1i : wire_nl0O_dataout;
	and(wire_nii_dataout, nl1Ol, niiOli);
	and(wire_nii0i_dataout, wire_niiil_dataout, niiOOi);
	and(wire_nii0l_dataout, wire_niiiO_dataout, niiOOi);
	assign		wire_nii0O_dataout = (niiilO === 1'b1) ? niiiil : niiiiO;
	and(wire_nii1i_dataout, niiiil, niiilO);
	and(wire_nii1l_dataout, wire_nii0O_dataout, ~(niiOOi));
	assign		wire_nii1O_dataout = (niiOOi === 1'b1) ? (~ niiili) : wire_niiii_dataout;
	assign		wire_niii_dataout = (niiOiO === 1'b1) ? n10ii : wire_nlli_dataout;
	assign		wire_niiii_dataout = (niiilO === 1'b1) ? (~ niiiil) : (~ niiiiO);
	and(wire_niiil_dataout, niiili, ~(niiilO));
	and(wire_niiiO_dataout, niiili, niiilO);
	assign		wire_niil_dataout = (niiOiO === 1'b1) ? n10il : wire_nlll_dataout;
	and(wire_niili_dataout, wire_nil1i_dataout, niiOOi);
	and(wire_niill_dataout, wire_nil1l_dataout, niiOOi);
	and(wire_niilO_dataout, wire_nil1O_dataout, niiOOi);
	assign		wire_niiO_dataout = (niiOiO === 1'b1) ? n10iO : wire_nllO_dataout;
	and(wire_niiOi_dataout, wire_nil0i_dataout, niiOOi);
	and(wire_niiOl_dataout, (~ niiill), niiOOi);
	and(wire_niiOO_dataout, niiill, niiOOi);
	and(wire_nil_dataout, niOlO, niiOli);
	and(wire_nil0i_dataout, niiilO, niiill);
	and(wire_nil0l_dataout, wire_nilil_dataout, ~(niiilO));
	and(wire_nil0O_dataout, wire_niliO_dataout, ~(niiilO));
	and(wire_nil1i_dataout, wire_nil0l_dataout, niiill);
	and(wire_nil1l_dataout, wire_nil0O_dataout, niiill);
	and(wire_nil1O_dataout, wire_nilii_dataout, niiill);
	assign		wire_nili_dataout = (niiOiO === 1'b1) ? n10li : wire_nlOi_dataout;
	and(wire_nilii_dataout, niil1i, ~(niiilO));
	and(wire_nilil_dataout, (~ niiiOO), ~(niil1i));
	and(wire_niliO_dataout, niiiOO, ~(niil1i));
	assign		wire_nill_dataout = (niiOiO === 1'b1) ? n10ll : wire_nlOl_dataout;
	and(wire_nilli_dataout, (~ niiiOl), niiOOi);
	or(wire_nilll_dataout, wire_nilOl_dataout, niiOOi);
	and(wire_nillO_dataout, wire_nilOO_dataout, ~(niiOOi));
	assign		wire_nilO_dataout = (niiOiO === 1'b1) ? n10lO : wire_nlOO_dataout;
	and(wire_nilOi_dataout, wire_niO1i_dataout, ~(niiOOi));
	or(wire_nilOl_dataout, wire_niO1l_dataout, niiilO);
	and(wire_nilOO_dataout, (~ niiiOl), ~(niiilO));
	and(wire_niO_dataout, niOOi, niiOli);
	assign		wire_niO00i_dataout = (niiOOi === 1'b1) ? nl00OO : nl0iil;
	assign		wire_niO00l_dataout = (niiOOi === 1'b1) ? nl0i1i : nl0iiO;
	assign		wire_niO00O_dataout = (niiOOi === 1'b1) ? nl0i1l : nl0ili;
	assign		wire_niO01i_dataout = (niiOOi === 1'b1) ? wire_niOOOi_dataout : wire_niOiOO_dataout;
	assign		wire_niO01l_dataout = (niiOOi === 1'b1) ? wire_niOOOl_dataout : wire_niOl1i_dataout;
	and(wire_niO01O_dataout, nl0iii, ~(niiOOi));
	assign		wire_niO0ii_dataout = (niiOOi === 1'b1) ? nl0i1O : nl0ill;
	assign		wire_niO0il_dataout = (niiOOi === 1'b1) ? nl0i0i : nl0ilO;
	assign		wire_niO0iO_dataout = (niiOOi === 1'b1) ? nl0i0l : nl0iOi;
	assign		wire_niO0li_dataout = (niiOOi === 1'b1) ? nl0i0O : nl0iOl;
	and(wire_niO0ll_dataout, nl00il, niiOOi);
	and(wire_niO0lO_dataout, nl00iO, niiOOi);
	and(wire_niO0Oi_dataout, nl00li, niiOOi);
	and(wire_niO0Ol_dataout, nl00ll, niiOOi);
	and(wire_niO0OO_dataout, nl00lO, niiOOi);
	assign		wire_niO10i_dataout = (niiOOi === 1'b1) ? wire_niOO1i_dataout : wire_niOi1O_dataout;
	assign		wire_niO10l_dataout = (niiOOi === 1'b1) ? wire_niOO1l_dataout : wire_niOi0i_dataout;
	assign		wire_niO10O_dataout = (niiOOi === 1'b1) ? wire_niOO1O_dataout : wire_niOi0l_dataout;
	and(wire_niO11l_dataout, wire_nlO_dataout, niiOOi);
	and(wire_niO11O_dataout, wire_nlO_dataout, ~(niiOOi));
	and(wire_niO1i_dataout, wire_niO1O_dataout, ~(niiilO));
	assign		wire_niO1ii_dataout = (niiOOi === 1'b1) ? wire_niOO0i_dataout : wire_niOi0O_dataout;
	assign		wire_niO1il_dataout = (niiOOi === 1'b1) ? wire_niOO0l_dataout : wire_niOiii_dataout;
	assign		wire_niO1iO_dataout = (niiOOi === 1'b1) ? wire_niOO0O_dataout : wire_niOiil_dataout;
	and(wire_niO1l_dataout, niiiOi, niiiOl);
	assign		wire_niO1li_dataout = (niiOOi === 1'b1) ? wire_niOOii_dataout : wire_niOiiO_dataout;
	assign		wire_niO1ll_dataout = (niiOOi === 1'b1) ? wire_niOOil_dataout : wire_niOili_dataout;
	assign		wire_niO1lO_dataout = (niiOOi === 1'b1) ? wire_niOOiO_dataout : wire_niOill_dataout;
	and(wire_niO1O_dataout, (~ niiiOi), niiiOl);
	assign		wire_niO1Oi_dataout = (niiOOi === 1'b1) ? wire_niOOli_dataout : wire_niOilO_dataout;
	assign		wire_niO1Ol_dataout = (niiOOi === 1'b1) ? wire_niOOll_dataout : wire_niOiOi_dataout;
	assign		wire_niO1OO_dataout = (niiOOi === 1'b1) ? wire_niOOlO_dataout : wire_niOiOl_dataout;
	assign		wire_niOi_dataout = (niiOiO === 1'b1) ? n10Oi : wire_n1i_dataout;
	and(wire_niOi0i_dataout, wire_niOl1O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi0l_dataout, wire_niOl0i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi0O_dataout, wire_niOl0l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi1i_dataout, nl00Oi, niiOOi);
	and(wire_niOi1l_dataout, nl00Ol, niiOOi);
	and(wire_niOi1O_dataout, wire_niOl1l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiii_dataout, wire_niOl0O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiil_dataout, wire_niOlii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiiO_dataout, wire_niOlil_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOili_dataout, wire_niOliO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOill_dataout, wire_niOlli_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOilO_dataout, wire_niOlll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOi_dataout, wire_niOllO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOl_dataout, wire_niOlOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOO_dataout, wire_niOlOl_dataout, ~((~ wire_nlO_dataout)));
	assign		wire_niOl_dataout = (niiOiO === 1'b1) ? n10Ol : wire_n1l_dataout;
	and(wire_niOl0i_dataout, nl0O0l, ~(ni01Oi));
	and(wire_niOl0l_dataout, nl0O0O, ~(ni01Oi));
	and(wire_niOl0O_dataout, nl0Oii, ~(ni01Oi));
	or(wire_niOl1i_dataout, wire_niOlOO_dataout, (~ wire_nlO_dataout));
	and(wire_niOl1l_dataout, nl0O1O, ~(ni01Oi));
	and(wire_niOl1O_dataout, nl0O0i, ~(ni01Oi));
	and(wire_niOlii_dataout, nl0Oil, ~(ni01Oi));
	and(wire_niOlil_dataout, nl0OiO, ~(ni01Oi));
	and(wire_niOliO_dataout, nl0Oli, ~(ni01Oi));
	and(wire_niOlli_dataout, nl0Oll, ~(ni01Oi));
	or(wire_niOlll_dataout, nl0OlO, ni01Oi);
	and(wire_niOllO_dataout, nl0OOi, ~(ni01Oi));
	and(wire_niOlOi_dataout, nl0OOl, ~(ni01Oi));
	and(wire_niOlOl_dataout, nli11i, ~(ni01Oi));
	and(wire_niOlOO_dataout, nli11O, ~(ni01Oi));
	assign		wire_niOO_dataout = (niiOiO === 1'b1) ? n10OO : wire_n1O_dataout;
	and(wire_niOO0i_dataout, wire_nl111O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO0l_dataout, wire_nl110i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO0O_dataout, wire_nl110l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1i_dataout, wire_niOOOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1l_dataout, wire_nl111i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1O_dataout, wire_nl111l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOii_dataout, wire_nl110O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOil_dataout, wire_nl11ii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOiO_dataout, wire_nl11il_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOli_dataout, wire_nl11iO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOll_dataout, wire_nl11li_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOlO_dataout, wire_nl11ll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOOi_dataout, wire_nl11lO_dataout, ~((~ wire_nlO_dataout)));
	or(wire_niOOOl_dataout, wire_nl11Oi_dataout, (~ wire_nlO_dataout));
	and(wire_niOOOO_dataout, nl0O1O, ~(ni01Ol));
	and(wire_nl000i_dataout, nl0OOi, ~(wire_nlO_dataout));
	and(wire_nl000l_dataout, nl0OOl, ~(wire_nlO_dataout));
	or(wire_nl000O_dataout, nli11i, wire_nlO_dataout);
	and(wire_nl001i_dataout, nl0Oli, ~(wire_nlO_dataout));
	and(wire_nl001l_dataout, nl0Oll, ~(wire_nlO_dataout));
	and(wire_nl001O_dataout, nl0OlO, ~(wire_nlO_dataout));
	and(wire_nl00ii_dataout, nli11O, ~(wire_nlO_dataout));
	and(wire_nl010i_dataout, nl0OlO, ~(ni001i));
	and(wire_nl010l_dataout, nl0OOi, ~(ni001i));
	or(wire_nl010O_dataout, nl0OOl, ni001i);
	and(wire_nl011i_dataout, nl0OiO, ~(ni001i));
	and(wire_nl011l_dataout, nl0Oli, ~(ni001i));
	and(wire_nl011O_dataout, nl0Oll, ~(ni001i));
	and(wire_nl01ii_dataout, nli11i, ~(ni001i));
	and(wire_nl01il_dataout, nli11O, ~(ni001i));
	and(wire_nl01iO_dataout, nl0O1O, ~(wire_nlO_dataout));
	and(wire_nl01li_dataout, nl0O0i, ~(wire_nlO_dataout));
	and(wire_nl01ll_dataout, nl0O0l, ~(wire_nlO_dataout));
	and(wire_nl01lO_dataout, nl0O0O, ~(wire_nlO_dataout));
	and(wire_nl01Oi_dataout, nl0Oii, ~(wire_nlO_dataout));
	and(wire_nl01Ol_dataout, nl0Oil, ~(wire_nlO_dataout));
	and(wire_nl01OO_dataout, nl0OiO, ~(wire_nlO_dataout));
	assign		wire_nl0i_dataout = (niiOiO === 1'b1) ? n1i0i : wire_nii_dataout;
	assign		wire_nl0l_dataout = (niiOiO === 1'b1) ? n101l : wire_nil_dataout;
	assign		wire_nl0O_dataout = (niiOiO === 1'b1) ? n101O : wire_niO_dataout;
	assign		wire_nl100i_dataout = (niiOOi === 1'b1) ? wire_nl1O1i_dataout : wire_nl1i1O_dataout;
	assign		wire_nl100l_dataout = (niiOOi === 1'b1) ? wire_nl1O1l_dataout : wire_nl1i0i_dataout;
	assign		wire_nl100O_dataout = (niiOOi === 1'b1) ? wire_nl1O1O_dataout : wire_nl1i0l_dataout;
	assign		wire_nl101i_dataout = (niiOOi === 1'b1) ? wire_nl1lOi_dataout : wire_nl10OO_dataout;
	assign		wire_nl101l_dataout = (niiOOi === 1'b1) ? wire_nl1lOl_dataout : wire_nl1i1i_dataout;
	assign		wire_nl101O_dataout = (niiOOi === 1'b1) ? wire_nl1lOO_dataout : wire_nl1i1l_dataout;
	assign		wire_nl10ii_dataout = (niiOOi === 1'b1) ? wire_nl1O0i_dataout : wire_nl1i0O_dataout;
	assign		wire_nl10il_dataout = (niiOOi === 1'b1) ? wire_nl1O0l_dataout : wire_nl1iii_dataout;
	assign		wire_nl10iO_dataout = (niiOOi === 1'b1) ? wire_nl1O0O_dataout : wire_nl1iil_dataout;
	assign		wire_nl10li_dataout = (niiOOi === 1'b1) ? wire_nl1Oii_dataout : wire_nl1iiO_dataout;
	assign		wire_nl10ll_dataout = (niiOOi === 1'b1) ? wire_nl1Oil_dataout : wire_nl1ili_dataout;
	assign		wire_nl10lO_dataout = (niiOOi === 1'b1) ? wire_nl1OiO_dataout : wire_nl1ill_dataout;
	and(wire_nl10Oi_dataout, wire_nl1ilO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl10Ol_dataout, wire_nl1iOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl10OO_dataout, wire_nl1iOl_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl110i_dataout, nl0Oii, ~(ni01Ol));
	and(wire_nl110l_dataout, nl0Oil, ~(ni01Ol));
	and(wire_nl110O_dataout, nl0OiO, ~(ni01Ol));
	and(wire_nl111i_dataout, nl0O0i, ~(ni01Ol));
	and(wire_nl111l_dataout, nl0O0l, ~(ni01Ol));
	and(wire_nl111O_dataout, nl0O0O, ~(ni01Ol));
	and(wire_nl11ii_dataout, nl0Oli, ~(ni01Ol));
	and(wire_nl11il_dataout, nl0Oll, ~(ni01Ol));
	or(wire_nl11iO_dataout, nl0OlO, ni01Ol);
	and(wire_nl11li_dataout, nl0OOi, ~(ni01Ol));
	and(wire_nl11ll_dataout, nl0OOl, ~(ni01Ol));
	and(wire_nl11lO_dataout, nli11i, ~(ni01Ol));
	and(wire_nl11Oi_dataout, nli11O, ~(ni01Ol));
	assign		wire_nl11Ol_dataout = (niiOOi === 1'b1) ? wire_nl1lll_dataout : wire_nl10Oi_dataout;
	assign		wire_nl11OO_dataout = (niiOOi === 1'b1) ? wire_nl1llO_dataout : wire_nl10Ol_dataout;
	assign		wire_nl1i_dataout = (niiOiO === 1'b1) ? n1i1i : wire_n0i_dataout;
	and(wire_nl1i0i_dataout, wire_nl1l1O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i0l_dataout, wire_nl1l0i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i0O_dataout, wire_nl1l0l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1i_dataout, wire_nl1iOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1l_dataout, wire_nl1l1i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1O_dataout, wire_nl1l1l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iii_dataout, wire_nl1l0O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iil_dataout, wire_nl1lii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iiO_dataout, wire_nl1lil_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1ili_dataout, wire_nl1liO_dataout, ~((~ wire_nlO_dataout)));
	or(wire_nl1ill_dataout, wire_nl1lli_dataout, (~ wire_nlO_dataout));
	and(wire_nl1ilO_dataout, nl0O1O, ~(ni01OO));
	and(wire_nl1iOi_dataout, nl0O0i, ~(ni01OO));
	and(wire_nl1iOl_dataout, nl0O0l, ~(ni01OO));
	and(wire_nl1iOO_dataout, nl0O0O, ~(ni01OO));
	assign		wire_nl1l_dataout = (niiOiO === 1'b1) ? n1i1l : wire_n0l_dataout;
	and(wire_nl1l0i_dataout, nl0Oli, ~(ni01OO));
	and(wire_nl1l0l_dataout, nl0Oll, ~(ni01OO));
	and(wire_nl1l0O_dataout, nl0OlO, ~(ni01OO));
	and(wire_nl1l1i_dataout, nl0Oii, ~(ni01OO));
	and(wire_nl1l1l_dataout, nl0Oil, ~(ni01OO));
	and(wire_nl1l1O_dataout, nl0OiO, ~(ni01OO));
	and(wire_nl1lii_dataout, nl0OOi, ~(ni01OO));
	or(wire_nl1lil_dataout, nl0OOl, ni01OO);
	and(wire_nl1liO_dataout, nli11i, ~(ni01OO));
	and(wire_nl1lli_dataout, nli11O, ~(ni01OO));
	and(wire_nl1lll_dataout, wire_nl1Oli_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1llO_dataout, wire_nl1Oll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOi_dataout, wire_nl1OlO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOl_dataout, wire_nl1OOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOO_dataout, wire_nl1OOl_dataout, ~((~ wire_nlO_dataout)));
	assign		wire_nl1O_dataout = (niiOiO === 1'b1) ? n1i1O : wire_n0O_dataout;
	and(wire_nl1O0i_dataout, wire_nl011O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O0l_dataout, wire_nl010i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O0O_dataout, wire_nl010l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1i_dataout, wire_nl1OOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1l_dataout, wire_nl011i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1O_dataout, wire_nl011l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1Oii_dataout, wire_nl010O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1Oil_dataout, wire_nl01ii_dataout, ~((~ wire_nlO_dataout)));
	or(wire_nl1OiO_dataout, wire_nl01il_dataout, (~ wire_nlO_dataout));
	and(wire_nl1Oli_dataout, nl0O1O, ~(ni001i));
	and(wire_nl1Oll_dataout, nl0O0i, ~(ni001i));
	and(wire_nl1OlO_dataout, nl0O0l, ~(ni001i));
	and(wire_nl1OOi_dataout, nl0O0O, ~(ni001i));
	and(wire_nl1OOl_dataout, nl0Oii, ~(ni001i));
	and(wire_nl1OOO_dataout, nl0Oil, ~(ni001i));
	and(wire_nli_dataout, rbisten_tx, ((~ rbist_sel[0]) & rbist_sel[1]));
	and(wire_nli00i_dataout, wire_nli0Oi_o[1], ni001O);
	and(wire_nli00l_dataout, wire_nli0Oi_o[2], ni001O);
	and(wire_nli00O_dataout, wire_nli0Oi_o[3], ni001O);
	and(wire_nli01i_dataout, wire_nli0lO_o[5], ni001O);
	and(wire_nli01l_dataout, wire_nli0lO_o[6], ni001O);
	and(wire_nli01O_dataout, wire_nli0Oi_o[0], ni001O);
	and(wire_nli0ii_dataout, wire_nli0Oi_o[4], ni001O);
	and(wire_nli0il_dataout, wire_nli0Oi_o[5], ni001O);
	and(wire_nli0iO_dataout, wire_nli0Oi_o[6], ni001O);
	and(wire_nli0li_dataout, wire_nli0Oi_o[7], ni001O);
	and(wire_nli10i_dataout, wire_nli0ll_o[0], ni001O);
	and(wire_nli10l_dataout, wire_nli0ll_o[1], ni001O);
	and(wire_nli10O_dataout, wire_nli0ll_o[2], ni001O);
	and(wire_nli1ii_dataout, wire_nli0ll_o[3], ni001O);
	and(wire_nli1il_dataout, wire_nli0ll_o[4], ni001O);
	and(wire_nli1iO_dataout, wire_nli0ll_o[5], ni001O);
	and(wire_nli1li_dataout, wire_nli0ll_o[6], ni001O);
	and(wire_nli1ll_dataout, wire_nli0lO_o[0], ni001O);
	and(wire_nli1lO_dataout, wire_nli0lO_o[1], ni001O);
	and(wire_nli1Oi_dataout, wire_nli0lO_o[2], ni001O);
	and(wire_nli1Ol_dataout, wire_nli0lO_o[3], ni001O);
	and(wire_nli1OO_dataout, wire_nli0lO_o[4], ni001O);
	and(wire_nlii_dataout, niOOl, niiOli);
	and(wire_nlil_dataout, niOOO, niiOli);
	and(wire_nlil0O_dataout, wire_nllO1O_dataout, n1iOl);
	and(wire_nlilii_dataout, wire_nllO0i_dataout, n1iOl);
	and(wire_nlilil_dataout, niiOOi, n1iOO);
	and(wire_nlill_dataout, wire_nliOl_o[0], wire_n0iiO_o);
	and(wire_nlilli_dataout, wire_nlO10l_dataout, n1l1i);
	and(wire_nlilll_dataout, wire_nlO10O_dataout, n1l1i);
	and(wire_nlillO_dataout, wire_nlOi0O_dataout, n1l1l);
	and(wire_nlilO_dataout, wire_nliOl_o[1], wire_n0iiO_o);
	and(wire_nliO_dataout, nl11i, niiOli);
	and(wire_nliOi_dataout, wire_nliOl_o[2], wire_n0iiO_o);
	and(wire_nliOll_dataout, (~ niiOOi), n1ilO);
	assign		wire_nliOO_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[0] : wire_nll0l_dataout;
	and(wire_nll_dataout, rbisten_tx, (rbist_sel[0] & (~ rbist_sel[1])));
	assign		wire_nll0i_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[4] : wire_nlliO_dataout;
	and(wire_nll0l_dataout, niOii, ~(wire_n0iil_o));
	and(wire_nll0O_dataout, niOil, ~(wire_n0iil_o));
	and(wire_nll11i_dataout, wire_nlO1ll_dataout, n1l1i);
	assign		wire_nll1i_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[1] : wire_nll0O_dataout;
	assign		wire_nll1l_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[2] : wire_nllii_dataout;
	assign		wire_nll1O_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[3] : wire_nllil_dataout;
	and(wire_nll1Oi_dataout, wire_nlOlOO_dataout, n1l0l);
	and(wire_nlli_dataout, nl11l, niiOli);
	and(wire_nllii_dataout, niOiO, ~(wire_n0iil_o));
	and(wire_nllil_dataout, niOli, ~(wire_n0iil_o));
	and(wire_nlliO_dataout, niOll, ~(wire_n0iil_o));
	and(wire_nlll_dataout, nl11O, niiOli);
	and(wire_nlllil_dataout, ni0l0l, ~(ni0Oii));
	and(wire_nllliO_dataout, ni0l0l, ni0Oii);
	and(wire_nlllli_dataout, wire_nlllOl_dataout, ~(niiOOi));
	assign		wire_nlllll_dataout = (niiOOi === 1'b1) ? (~ ni0lii) : wire_nlllOO_dataout;
	and(wire_nllllO_dataout, wire_nllO1i_dataout, niiOOi);
	and(wire_nlllOi_dataout, wire_nllO1l_dataout, niiOOi);
	assign		wire_nlllOl_dataout = (ni0Oii === 1'b1) ? ni0l0l : ni0l0O;
	assign		wire_nlllOO_dataout = (ni0Oii === 1'b1) ? (~ ni0l0l) : (~ ni0l0O);
	and(wire_nllO_dataout, nl10i, niiOli);
	assign		wire_nllO0i_dataout = (niiOOi === 1'b1) ? ni0lil : ni0liO;
	and(wire_nllO0l_dataout, wire_nllOll_dataout, niiOOi);
	and(wire_nllO0O_dataout, wire_nllOlO_dataout, niiOOi);
	and(wire_nllO1i_dataout, ni0lii, ~(ni0Oii));
	and(wire_nllO1l_dataout, ni0lii, ni0Oii);
	assign		wire_nllO1O_dataout = (niiOOi === 1'b1) ? (~ ni0lil) : (~ ni0liO);
	and(wire_nllOii_dataout, wire_nllOOi_dataout, niiOOi);
	and(wire_nllOil_dataout, wire_nllOOl_dataout, niiOOi);
	and(wire_nllOiO_dataout, wire_nllOOO_dataout, niiOOi);
	and(wire_nllOli_dataout, ni0lli, niiOOi);
	and(wire_nllOll_dataout, wire_nlO11i_dataout, ~(ni0lli));
	and(wire_nllOlO_dataout, wire_nlO11l_dataout, ~(ni0lli));
	and(wire_nllOOi_dataout, wire_nlO11O_dataout, ~(ni0lli));
	and(wire_nllOOl_dataout, wire_nlO10i_dataout, ~(ni0lli));
	and(wire_nllOOO_dataout, (~ ni0lll), ~(ni0lli));
	and(wire_nlO_dataout, rbisten_tx, (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (niiOll6 ^ niiOll5)));
	and(wire_nlO00i_dataout, wire_nlO0li_dataout, ~(ni0lOO));
	and(wire_nlO00l_dataout, ni0lOi, ~(ni0lOO));
	and(wire_nlO00O_dataout, wire_nlO0ll_dataout, ~(ni0lOi));
	and(wire_nlO01i_dataout, wire_nlO0ii_dataout, ~(ni0lOO));
	and(wire_nlO01l_dataout, wire_nlO0il_dataout, ~(ni0lOO));
	and(wire_nlO01O_dataout, wire_nlO0iO_dataout, ~(ni0lOO));
	and(wire_nlO0ii_dataout, wire_nlO0lO_dataout, ~(ni0lOi));
	and(wire_nlO0il_dataout, wire_nlO0Oi_dataout, ~(ni0lOi));
	and(wire_nlO0iO_dataout, wire_nlO0Ol_dataout, ~(ni0lOi));
	and(wire_nlO0li_dataout, (~ ni0lOl), ~(ni0lOi));
	and(wire_nlO0ll_dataout, wire_nlO0OO_dataout, ni0lOl);
	and(wire_nlO0lO_dataout, wire_nlOi1i_dataout, ni0lOl);
	and(wire_nlO0Oi_dataout, wire_nlOi1l_dataout, ni0lOl);
	and(wire_nlO0Ol_dataout, ni0Oii, ni0lOl);
	and(wire_nlO0OO_dataout, wire_nlOi1O_dataout, ~(ni0Oii));
	and(wire_nlO10i_dataout, ni0Oii, ni0lll);
	or(wire_nlO10l_dataout, (~ ni0llO), ~(niiOOi));
	and(wire_nlO10O_dataout, ni0llO, niiOOi);
	and(wire_nlO11i_dataout, wire_nlO0OO_dataout, ni0lll);
	and(wire_nlO11l_dataout, wire_nlOi1i_dataout, ni0lll);
	and(wire_nlO11O_dataout, wire_nlOi1l_dataout, ni0lll);
	and(wire_nlO1ii_dataout, wire_nlO1OO_dataout, ~(niiOOi));
	and(wire_nlO1il_dataout, wire_nlO01i_dataout, ~(niiOOi));
	and(wire_nlO1iO_dataout, wire_nlO01l_dataout, ~(niiOOi));
	and(wire_nlO1li_dataout, wire_nlO01O_dataout, ~(niiOOi));
	assign		wire_nlO1ll_dataout = (niiOOi === 1'b1) ? ni0llO : ni0lOO;
	and(wire_nlO1lO_dataout, wire_nlO00i_dataout, ~(niiOOi));
	and(wire_nlO1Oi_dataout, (~ ni0llO), niiOOi);
	and(wire_nlO1Ol_dataout, wire_nlO00l_dataout, ~(niiOOi));
	and(wire_nlO1OO_dataout, wire_nlO00O_dataout, ~(ni0lOO));
	and(wire_nlOi_dataout, nl10l, niiOli);
	and(wire_nlOi0i_dataout, ni0Oli, ~(ni0Oll));
	assign		wire_nlOi0O_dataout = (niiOOi === 1'b1) ? wire_nlOl1O_dataout : wire_nlOiiO_dataout;
	and(wire_nlOi1i_dataout, wire_nlOi0i_dataout, ~(ni0Oii));
	and(wire_nlOi1l_dataout, ni0Oll, ~(ni0Oii));
	and(wire_nlOi1O_dataout, (~ ni0Oli), ~(ni0Oll));
	assign		wire_nlOiii_dataout = (niiOOi === 1'b1) ? wire_nlOl0i_dataout : wire_nlOili_dataout;
	assign		wire_nlOiil_dataout = (niiOOi === 1'b1) ? wire_nlOl0l_dataout : wire_nlOill_dataout;
	assign		wire_nlOiiO_dataout = (ni0Oii === 1'b1) ? wire_nlOiOO_dataout : wire_nlOilO_dataout;
	assign		wire_nlOili_dataout = (ni0Oii === 1'b1) ? wire_nlOl1i_dataout : wire_nlOiOi_dataout;
	assign		wire_nlOill_dataout = (ni0Oii === 1'b1) ? wire_nlOl1l_dataout : wire_nlOiOl_dataout;
	and(wire_nlOilO_dataout, ni0O1i, ~(ni0O0i));
	or(wire_nlOiOi_dataout, ni0O1i, ni0O0i);
	and(wire_nlOiOl_dataout, (~ ni0O1i), ~(ni0O0i));
	and(wire_nlOiOO_dataout, ni0O1l, ~(ni0O0O));
	and(wire_nlOl_dataout, nl10O, niiOli);
	assign		wire_nlOl0i_dataout = (ni0Oii === 1'b1) ? wire_nlOlli_dataout : wire_nlOlii_dataout;
	assign		wire_nlOl0l_dataout = (ni0Oii === 1'b1) ? wire_nlOlll_dataout : wire_nlOlil_dataout;
	and(wire_nlOl0O_dataout, ni0O0i, ~(ni0O1O));
	or(wire_nlOl1i_dataout, ni0O1l, ni0O0O);
	and(wire_nlOl1l_dataout, (~ ni0O1l), ~(ni0O0O));
	assign		wire_nlOl1O_dataout = (ni0Oii === 1'b1) ? wire_nlOliO_dataout : wire_nlOl0O_dataout;
	or(wire_nlOlii_dataout, ni0O0i, ni0O1O);
	and(wire_nlOlil_dataout, (~ ni0O0i), ~(ni0O1O));
	and(wire_nlOliO_dataout, ni0O0O, ~(ni0O0l));
	or(wire_nlOlli_dataout, ni0O0O, ni0O0l);
	and(wire_nlOlll_dataout, (~ ni0O0O), ~(ni0O0l));
	and(wire_nlOllO_dataout, (~ ni0OiO), niiOOi);
	or(wire_nlOlOi_dataout, wire_nlOO1l_dataout, niiOOi);
	and(wire_nlOlOl_dataout, ni0Oii, ~(niiOOi));
	and(wire_nlOlOO_dataout, wire_nlOO1O_dataout, ~(niiOOi));
	and(wire_nlOO_dataout, nl1ii, niiOli);
	and(wire_nlOO0i_dataout, wire_nlOO0O_dataout, ~(ni0Oii));
	and(wire_nlOO0l_dataout, ni0Oil, ni0OiO);
	and(wire_nlOO0O_dataout, (~ ni0Oil), ni0OiO);
	and(wire_nlOO1i_dataout, wire_nlOO0i_dataout, ~(niiOOi));
	and(wire_nlOO1l_dataout, wire_nlOO0l_dataout, ~(ni0Oii));
	and(wire_nlOO1O_dataout, (~ ni0OiO), ~(ni0Oii));
	oper_add   n00Oi
	( 
	.a({n101i, n11OO, n11Ol, n11Oi, n11lO, n11ll, n11li, n11iO, n11il}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n00Oi_o));
	defparam
		n00Oi.sgate_representation = 0,
		n00Oi.width_a = 9,
		n00Oi.width_b = 9,
		n00Oi.width_o = 9;
	oper_add   n01iO
	( 
	.a({n11ii, n110O, n110l, n110i}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n01iO_o));
	defparam
		n01iO.sgate_representation = 0,
		n01iO.width_a = 4,
		n01iO.width_b = 4,
		n01iO.width_o = 4;
	oper_add   n1lOi
	( 
	.a({nlOOiO, nlOOil, nliliO}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1lOi_o));
	defparam
		n1lOi.sgate_representation = 0,
		n1lOi.width_a = 3,
		n1lOi.width_b = 3,
		n1lOi.width_o = 3;
	oper_add   n1Oll
	( 
	.a({nlOOOO, nlOOOl, nlOOOi, nlOOlO, nlOOll, nlOOli}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1Oll_o));
	defparam
		n1Oll.sgate_representation = 0,
		n1Oll.width_a = 6,
		n1Oll.width_b = 6,
		n1Oll.width_o = 6;
	oper_add   n1OOO
	( 
	.a({n111O, n111l, n111i}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1OOO_o));
	defparam
		n1OOO.sgate_representation = 0,
		n1OOO.width_a = 3,
		n1OOO.width_b = 3,
		n1OOO.width_o = 3;
	oper_add   nli0ll
	( 
	.a({nl00Ol, nl00Oi, nl00lO, nl00ll, nl00li, nl00iO, nl00il}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0ll_o));
	defparam
		nli0ll.sgate_representation = 0,
		nli0ll.width_a = 7,
		nli0ll.width_b = 7,
		nli0ll.width_o = 7;
	oper_add   nli0lO
	( 
	.a({nl0i0O, nl0i0l, nl0i0i, nl0i1O, nl0i1l, nl0i1i, nl00OO}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0lO_o));
	defparam
		nli0lO.sgate_representation = 0,
		nli0lO.width_a = 7,
		nli0lO.width_b = 7,
		nli0lO.width_o = 7;
	oper_add   nli0Oi
	( 
	.a({nl0iOl, nl0iOi, nl0ilO, nl0ill, nl0ili, nl0iiO, nl0iil, nl0iii}),
	.b({{7{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0Oi_o));
	defparam
		nli0Oi.sgate_representation = 0,
		nli0Oi.width_a = 8,
		nli0Oi.width_b = 8,
		nli0Oi.width_o = 8;
	oper_add   nliOl
	( 
	.a({((niilOO16 ^ niilOO15) & niO0O), niO0l, n0lOi}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nliOl_o));
	defparam
		nliOl.sgate_representation = 0,
		nliOl.width_a = 3,
		nliOl.width_b = 3,
		nliOl.width_o = 3;
	oper_add   nllli
	( 
	.a({niOll, niOli, niOiO, ((niiO1i14 ^ niiO1i13) & niOil), niOii}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllli_o));
	defparam
		nllli.sgate_representation = 0,
		nllli.width_a = 5,
		nllli.width_b = 5,
		nllli.width_o = 5;
	oper_selector   n0iii
	( 
	.data({1'b0, wire_niiOl_dataout, (~ niiill)}),
	.o(wire_n0iii_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0iii.width_data = 3,
		n0iii.width_sel = 3;
	oper_selector   n0iil
	( 
	.data({1'b0, wire_niiOO_dataout, niiill}),
	.o(wire_n0iil_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0iil.width_data = 3,
		n0iil.width_sel = 3;
	oper_selector   n0iiO
	( 
	.data({1'b0, wire_nilOi_dataout, wire_nii1O_dataout, {2{(~ niiiil)}}}),
	.o(wire_n0iiO_o),
	.sel({ni0OOO, nli0O, nl01l, nl01i, nl1OO}));
	defparam
		n0iiO.width_data = 5,
		n0iiO.width_sel = 5;
	oper_selector   n0ilO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_n0ilO_o),
	.sel({nii11i, (~ nii11i)}));
	defparam
		n0ilO.width_data = 2,
		n0ilO.width_sel = 2;
	oper_selector   n0iOl
	( 
	.data({1'b0, niiiil, (~ niiiil)}),
	.o(wire_n0iOl_o),
	.sel({nii11l, nl01i, nl1OO}));
	defparam
		n0iOl.width_data = 3,
		n0iOl.width_sel = 3;
	oper_selector   n0l1i
	( 
	.data({1'b0, wire_nii1l_dataout, (~ niiiil)}),
	.o(wire_n0l1i_o),
	.sel({nii11O, nl01l, nl01i}));
	defparam
		n0l1i.width_data = 3,
		n0l1i.width_sel = 3;
	oper_selector   n0l1O
	( 
	.data({1'b0, niiOOi, 1'b1, wire_nii1O_dataout}),
	.o(wire_n0l1O_o),
	.sel({nii10i, nl0ii, (((nl00O | nl00l) | nl00i) | nl01O), nl01l}));
	defparam
		n0l1O.width_data = 4,
		n0l1O.width_sel = 4;
	oper_selector   n0lii
	( 
	.data({1'b0, wire_niili_dataout, wire_nil1i_dataout}),
	.o(wire_n0lii_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lii.width_data = 3,
		n0lii.width_sel = 3;
	oper_selector   n0lil
	( 
	.data({1'b0, wire_niill_dataout, wire_nil1l_dataout}),
	.o(wire_n0lil_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lil.width_data = 3,
		n0lil.width_sel = 3;
	oper_selector   n0liO
	( 
	.data({1'b0, wire_niilO_dataout, wire_nil1O_dataout}),
	.o(wire_n0liO_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0liO.width_data = 3,
		n0liO.width_sel = 3;
	oper_selector   n0lli
	( 
	.data({1'b0, wire_niiOi_dataout, wire_nil0i_dataout}),
	.o(wire_n0lli_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lli.width_data = 3,
		n0lli.width_sel = 3;
	oper_selector   n0lOl
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0lOl_o),
	.sel({nii10O, nl0ll, nl0li}));
	defparam
		n0lOl.width_data = 3,
		n0lOl.width_sel = 3;
	oper_selector   n0O0l
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0O0l_o),
	.sel({nii1il, nl0OO, nl0Ol}));
	defparam
		n0O0l.width_data = 3,
		n0O0l.width_sel = 3;
	oper_selector   n0O1l
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0O1l_o),
	.sel({nii1ii, nl0Oi, nl0lO}));
	defparam
		n0O1l.width_data = 3,
		n0O1l.width_sel = 3;
	oper_selector   n0Oil
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0Oil_o),
	.sel({nii1iO, nli1l, nli1i}));
	defparam
		n0Oil.width_data = 3,
		n0Oil.width_sel = 3;
	oper_selector   n0Oll
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0Oll_o),
	.sel({nii1li, nli0i, nli1O}));
	defparam
		n0Oll.width_data = 3,
		n0Oll.width_sel = 3;
	oper_selector   n0OOl
	( 
	.data({1'b0, niiOOi, wire_nilll_dataout, 1'b1, wire_niiOl_dataout, (~ niiill)}),
	.o(wire_n0OOl_o),
	.sel({nii1ll, nliil, nli0O, nli0l, nl0iO, nl0il}));
	defparam
		n0OOl.width_data = 6,
		n0OOl.width_sel = 6;
	oper_selector   ni00l
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni00l_o),
	.sel({nii00l, (~ nii00l)}));
	defparam
		ni00l.width_data = 2,
		ni00l.width_sel = 2;
	oper_selector   ni01i
	( 
	.data({1'b0, ((nii1OO44 ^ nii1OO43) & niiOOi)}),
	.o(wire_ni01i_o),
	.sel({nii01i, (~ nii01i)}));
	defparam
		ni01i.width_data = 2,
		ni01i.width_sel = 2;
	oper_selector   ni01O
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni01O_o),
	.sel({nii01l, (~ nii01l)}));
	defparam
		ni01O.width_data = 2,
		ni01O.width_sel = 2;
	oper_selector   ni0ii
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0ii_o),
	.sel({nii0ii, ((nii00O40 ^ nii00O39) & (~ nii0ii))}));
	defparam
		ni0ii.width_data = 2,
		ni0ii.width_sel = 2;
	oper_selector   ni0iO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0iO_o),
	.sel({((nii0li36 ^ nii0li35) & nii0ll), (~ nii0ll)}));
	defparam
		ni0iO.width_data = 2,
		ni0iO.width_sel = 2;
	oper_selector   ni0ll
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0ll_o),
	.sel({nii0Ol, (~ nii0Ol)}));
	defparam
		ni0ll.width_data = 2,
		ni0ll.width_sel = 2;
	oper_selector   ni0Oi
	( 
	.data({1'b0, ((nii0OO32 ^ nii0OO31) & wire_nilli_dataout), ((niii1i30 ^ niii1i29) & niiOOi), {7{niiOOi}}}),
	.o(wire_ni0Oi_o),
	.sel({((niii1l28 ^ niii1l27) & niii0l), nli0O, nli0i, nl0OO, nl0ll, nl0ii, nl00O, ((niii1O26 ^ niii1O25) & nl00l), ((niii0i24 ^ niii0i23) & nl00i), nl01l}));
	defparam
		ni0Oi.width_data = 10,
		ni0Oi.width_sel = 10;
	oper_selector   ni10i
	( 
	.data({niiilO, 1'b0, wire_nii0l_dataout, wire_nii1i_dataout}),
	.o(wire_ni10i_o),
	.sel({nlili, nii1Oi, nl01l, nl1OO}));
	defparam
		ni10i.width_data = 4,
		ni10i.width_sel = 4;
	oper_selector   ni11l
	( 
	.data({(~ niiilO), (~ niiOOi), wire_nilOi_dataout, 1'b0, wire_nii0i_dataout, wire_ni0OO_dataout}),
	.o(wire_ni11l_o),
	.sel({nlili, nliil, nli0O, nii1lO, nl01l, nl1OO}));
	defparam
		ni11l.width_data = 6,
		ni11l.width_sel = 6;
	oper_selector   ni1Ol
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni1Ol_o),
	.sel({nii1Ol, (~ nii1Ol)}));
	defparam
		ni1Ol.width_data = 2,
		ni1Ol.width_sel = 2;
	oper_selector   nil00l
	( 
	.data({1'b0, 1'b1, wire_niO00O_dataout}),
	.o(wire_nil00l_o),
	.sel({(nli11O | nl0O0l), ni1lOO, nl0OOi}));
	defparam
		nil00l.width_data = 3,
		nil00l.width_sel = 3;
	oper_selector   nil01O
	( 
	.data({1'b0, 1'b1, niiOOi, wire_niO00l_dataout}),
	.o(wire_nil01O_o),
	.sel({nli11O, ni1lOl, nl0OOl, nl0OOi}));
	defparam
		nil01O.width_data = 4,
		nil01O.width_sel = 4;
	oper_selector   nil0il
	( 
	.data({1'b0, 1'b1, wire_niO0ii_dataout}),
	.o(wire_nil0il_o),
	.sel({nli11O, ni1O1i, nl0OOi}));
	defparam
		nil0il.width_data = 3,
		nil0il.width_sel = 3;
	oper_selector   nil0li
	( 
	.data({1'b0, 1'b1, wire_niO0il_dataout}),
	.o(wire_nil0li_o),
	.sel({ni1O1O, ni1O1l, nl0OOi}));
	defparam
		nil0li.width_data = 3,
		nil0li.width_sel = 3;
	oper_selector   nil0Oi
	( 
	.data({1'b0, (~ niiOOi), wire_niO0iO_dataout, 1'b1}),
	.o(wire_nil0Oi_o),
	.sel({ni1O0l, nl0OOl, nl0OOi, ni1O0i}));
	defparam
		nil0Oi.width_data = 4,
		nil0Oi.width_sel = 4;
	oper_selector   nil1li
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nil1li_o),
	.sel({ni1lll, (~ ni1lll)}));
	defparam
		nil1li.width_data = 2,
		nil1li.width_sel = 2;
	oper_selector   nil1lO
	( 
	.data({1'b0, (~ niiOOi), wire_niO01O_dataout, 1'b1}),
	.o(wire_nil1lO_o),
	.sel({ni1llO, nl0OOl, nl0OOi, (nl0O0l | nl0O1O)}));
	defparam
		nil1lO.width_data = 4,
		nil1lO.width_sel = 4;
	oper_selector   nil1OO
	( 
	.data({1'b0, (~ niiOOi), wire_niO00i_dataout, 1'b1}),
	.o(wire_nil1OO_o),
	.sel({ni1lOi, nl0OOl, nl0OOi, (nl0O0l | nl0O0i)}));
	defparam
		nil1OO.width_data = 4,
		nil1OO.width_sel = 4;
	oper_selector   nili0i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nili0i_o),
	.sel({ni1Oil, (~ ni1Oil)}));
	defparam
		nili0i.width_data = 2,
		nili0i.width_sel = 2;
	oper_selector   nili0O
	( 
	.data({1'b0, niiOOi, wire_niO0ll_dataout, niiOOi}),
	.o(wire_nili0O_o),
	.sel({ni1OiO, nl0OOl, nl0OOi, nl0O0O}));
	defparam
		nili0O.width_data = 4,
		nili0O.width_sel = 4;
	oper_selector   nili1i
	( 
	.data({1'b0, 1'b1, wire_niO0li_dataout}),
	.o(wire_nili1i_o),
	.sel({ni1Oii, ni1O0O, nl0OOi}));
	defparam
		nili1i.width_data = 3,
		nili1i.width_sel = 3;
	oper_selector   niliil
	( 
	.data({1'b0, niiOOi, wire_niO0lO_dataout, {5{niiOOi}}}),
	.o(wire_niliil_o),
	.sel({ni1Oli, nli11i, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		niliil.width_data = 8,
		niliil.width_sel = 8;
	oper_selector   nilili
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0Oi_dataout, {4{niiOOi}}}),
	.o(wire_nilili_o),
	.sel({ni1Oll, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0i}));
	defparam
		nilili.width_data = 8,
		nilili.width_sel = 8;
	oper_selector   nililO
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0Ol_dataout, {5{niiOOi}}}),
	.o(wire_nililO_o),
	.sel({ni1OlO, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nililO.width_data = 9,
		nililO.width_sel = 9;
	oper_selector   niliOl
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0OO_dataout, {4{niiOOi}}}),
	.o(wire_niliOl_o),
	.sel({ni1OOi, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0O0O, nl0O0i}));
	defparam
		niliOl.width_data = 8,
		niliOl.width_sel = 8;
	oper_selector   nill0O
	( 
	.data({wire_nl01iO_dataout, wire_nl11Ol_dataout, 1'b0, wire_niO10i_dataout, wire_niO11O_dataout}),
	.o(wire_nill0O_o),
	.sel({nli11O, nli11i, ni011i, nl0OOi, nl0O0i}));
	defparam
		nill0O.width_data = 5,
		nill0O.width_sel = 5;
	oper_selector   nill1i
	( 
	.data({1'b0, niiOOi, wire_niOi1i_dataout, {4{niiOOi}}}),
	.o(wire_nill1i_o),
	.sel({ni1OOl, nl0OOl, nl0OOi, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nill1i.width_data = 7,
		nill1i.width_sel = 7;
	oper_selector   nill1O
	( 
	.data({1'b0, {2{niiOOi}}, wire_niOi1l_dataout, {3{niiOOi}}}),
	.o(wire_nill1O_o),
	.sel({ni1OOO, nli11i, nl0OOl, nl0OOi, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nill1O.width_data = 7,
		nill1O.width_sel = 7;
	oper_selector   nillil
	( 
	.data({wire_nl01li_dataout, wire_nl11OO_dataout, 1'b0, wire_niO10l_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nillil_o),
	.sel({nli11O, nli11i, ni011l, nl0OOi, nl0O0O, nl0O0l}));
	defparam
		nillil.width_data = 6,
		nillil.width_sel = 6;
	oper_selector   nillli
	( 
	.data({wire_nl01ll_dataout, wire_nl101i_dataout, 1'b0, wire_niO10O_dataout, wire_niO11O_dataout}),
	.o(wire_nillli_o),
	.sel({nli11O, nli11i, ni011O, nl0OOi, nl0O0O}));
	defparam
		nillli.width_data = 5,
		nillli.width_sel = 5;
	oper_selector   nilllO
	( 
	.data({wire_nl01lO_dataout, wire_nl101l_dataout, 1'b0, wire_niO1ii_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilllO_o),
	.sel({nli11O, nli11i, ni010i, nl0OOi, nl0Oil, nl0Oii}));
	defparam
		nilllO.width_data = 6,
		nilllO.width_sel = 6;
	oper_selector   nillOl
	( 
	.data({wire_nl01Oi_dataout, wire_nl101O_dataout, 1'b0, wire_niO1il_dataout, wire_niO11O_dataout}),
	.o(wire_nillOl_o),
	.sel({nli11O, nli11i, ni010l, nl0OOi, nl0Oil}));
	defparam
		nillOl.width_data = 5,
		nillOl.width_sel = 5;
	oper_selector   nilO0l
	( 
	.data({wire_nl001i_dataout, wire_nl100O_dataout, 1'b0, wire_niO1ll_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilO0l_o),
	.sel({nli11O, nli11i, ni01il, nl0OOi, nl0OlO, nl0Oll}));
	defparam
		nilO0l.width_data = 6,
		nilO0l.width_sel = 6;
	oper_selector   nilO1i
	( 
	.data({wire_nl01Ol_dataout, wire_nl100i_dataout, 1'b0, wire_niO1iO_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilO1i_o),
	.sel({nli11O, nli11i, ni010O, nl0OOi, nl0Oli, nl0OiO}));
	defparam
		nilO1i.width_data = 6,
		nilO1i.width_sel = 6;
	oper_selector   nilO1O
	( 
	.data({wire_nl01OO_dataout, wire_nl100l_dataout, 1'b0, wire_niO1li_dataout, wire_niO11O_dataout}),
	.o(wire_nilO1O_o),
	.sel({nli11O, nli11i, ni01ii, nl0OOi, nl0Oli}));
	defparam
		nilO1O.width_data = 5,
		nilO1O.width_sel = 5;
	oper_selector   nilOii
	( 
	.data({wire_nl001l_dataout, wire_nl10ii_dataout, 1'b0, wire_niO1lO_dataout, wire_niO11O_dataout}),
	.o(wire_nilOii_o),
	.sel({nli11O, nli11i, ni01iO, nl0OOi, nl0OlO}));
	defparam
		nilOii.width_data = 5,
		nilOii.width_sel = 5;
	oper_selector   nilOiO
	( 
	.data({wire_nl001O_dataout, wire_nl10il_dataout, 1'b0, wire_niO1Oi_dataout}),
	.o(wire_nilOiO_o),
	.sel({nli11O, nli11i, ni01ll, nl0OOi}));
	defparam
		nilOiO.width_data = 4,
		nilOiO.width_sel = 4;
	oper_selector   nilOli
	( 
	.data({wire_nl000i_dataout, wire_nl10iO_dataout, wire_nlO_dataout, wire_niO1Ol_dataout, 1'b0}),
	.o(wire_nilOli_o),
	.sel({nli11O, nli11i, nl0OOl, nl0OOi, ni01li}));
	defparam
		nilOli.width_data = 5,
		nilOli.width_sel = 5;
	oper_selector   nilOlO
	( 
	.data({wire_nl000l_dataout, wire_nl10li_dataout, 1'b0, wire_niO1OO_dataout}),
	.o(wire_nilOlO_o),
	.sel({nli11O, nli11i, ni01ll, nl0OOi}));
	defparam
		nilOlO.width_data = 4,
		nilOlO.width_sel = 4;
	oper_selector   nilOOl
	( 
	.data({wire_nl000O_dataout, wire_nl10ll_dataout, 1'b0, wire_niO01i_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilOOl_o),
	.sel({nli11O, nli11i, ni01lO, nl0OOi, nl0O0i, nl0O1O}));
	defparam
		nilOOl.width_data = 6,
		nilOOl.width_sel = 6;
	oper_selector   niO11i
	( 
	.data({wire_nl00ii_dataout, wire_nl10lO_dataout, (~ wire_nlO_dataout), wire_niO01l_dataout, {10{(~ wire_nlO_dataout)}}}),
	.o(wire_niO11i_o),
	.sel({nli11O, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oll, nl0Oli, nl0OiO, nl0Oil, nl0Oii, nl0O0O, nl0O0l, nl0O0i, nl0O1O}));
	defparam
		niO11i.width_data = 14,
		niO11i.width_sel = 14;
	oper_selector   nlilOi
	( 
	.data({1'b0, wire_nlOO1i_dataout, wire_nlllll_dataout, {2{(~ ni0l0l)}}}),
	.o(wire_nlilOi_o),
	.sel({ni000i, n1l0l, n1iii, n1i0O, n1i0l}));
	defparam
		nlilOi.width_data = 5,
		nlilOi.width_sel = 5;
	oper_selector   nliO0l
	( 
	.data({1'b0, wire_nlllli_dataout, (~ ni0l0l)}),
	.o(wire_nliO0l_o),
	.sel({ni00ii, n1iii, n1i0O}));
	defparam
		nliO0l.width_data = 3,
		nliO0l.width_sel = 3;
	oper_selector   nliO1i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nliO1i_o),
	.sel({ni000l, (~ ni000l)}));
	defparam
		nliO1i.width_data = 2,
		nliO1i.width_sel = 2;
	oper_selector   nliO1O
	( 
	.data({1'b0, ni0l0l, (~ ni0l0l)}),
	.o(wire_nliO1O_o),
	.sel({ni000O, n1i0O, n1i0l}));
	defparam
		nliO1O.width_data = 3,
		nliO1O.width_sel = 3;
	oper_selector   nliOii
	( 
	.data({1'b0, niiOOi, 1'b1, wire_nlllll_dataout}),
	.o(wire_nliOii_o),
	.sel({ni00il, n1ilO, (((n1ill | n1ili) | n1iiO) | n1iil), n1iii}));
	defparam
		nliOii.width_data = 4,
		nliOii.width_sel = 4;
	oper_selector   nliOli
	( 
	.data({1'b0, wire_nlO1ii_dataout, wire_nllO0l_dataout}),
	.o(wire_nliOli_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOli.width_data = 3,
		nliOli.width_sel = 3;
	oper_selector   nliOlO
	( 
	.data({1'b0, wire_nlO1il_dataout, wire_nllO0O_dataout}),
	.o(wire_nliOlO_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOlO.width_data = 3,
		nliOlO.width_sel = 3;
	oper_selector   nliOOi
	( 
	.data({1'b0, wire_nlO1iO_dataout, wire_nllOii_dataout}),
	.o(wire_nliOOi_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOOi.width_data = 3,
		nliOOi.width_sel = 3;
	oper_selector   nliOOl
	( 
	.data({1'b0, wire_nlO1li_dataout, wire_nllOil_dataout}),
	.o(wire_nliOOl_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOOl.width_data = 3,
		nliOOl.width_sel = 3;
	oper_selector   nll00O
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll00O_o),
	.sel({ni0i0l, ni0i0i, n1iOi}));
	defparam
		nll00O.width_data = 3,
		nll00O.width_sel = 3;
	oper_selector   nll01i
	( 
	.data({ni0Oii, 1'b0, wire_nlllOi_dataout, wire_nllliO_dataout}),
	.o(wire_nll01i_o),
	.sel({n1liO, ni0i1i, n1iii, n1i0l}));
	defparam
		nll01i.width_data = 4,
		nll01i.width_sel = 4;
	oper_selector   nll01O
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll01O_o),
	.sel({ni0i1O, ni0i1l, n1iOi}));
	defparam
		nll01O.width_data = 3,
		nll01O.width_sel = 3;
	oper_selector   nll0iO
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nll0iO_o),
	.sel({ni0iii, ni0i0O, n1iOi}));
	defparam
		nll0iO.width_data = 3,
		nll0iO.width_sel = 3;
	oper_selector   nll0lO
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll0lO_o),
	.sel({ni0iiO, ni0iil, n1iOi}));
	defparam
		nll0lO.width_data = 3,
		nll0lO.width_sel = 3;
	oper_selector   nll0OO
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nll0OO_o),
	.sel({(((n1liO | n1l1O) | n1iOO) | n1iil), ni0ili, n1iOi}));
	defparam
		nll0OO.width_data = 3,
		nll0OO.width_sel = 3;
	oper_selector   nll10i
	( 
	.data({1'b0, wire_nlO1lO_dataout, wire_nllOiO_dataout, wire_nllO0i_dataout}),
	.o(wire_nll10i_o),
	.sel({ni00ll, n1l1i, n1iOO, n1iOl}));
	defparam
		nll10i.width_data = 4,
		nll10i.width_sel = 4;
	oper_selector   nll10O
	( 
	.data({1'b0, wire_nlOiii_dataout, wire_nlO1Oi_dataout, (~ niiOOi)}),
	.o(wire_nll10O_o),
	.sel({ni00lO, n1l1l, n1l1i, n1iOO}));
	defparam
		nll10O.width_data = 4,
		nll10O.width_sel = 4;
	oper_selector   nll11l
	( 
	.data({1'b0, 1'b1, wire_nllO1O_dataout}),
	.o(wire_nll11l_o),
	.sel({ni00li, n1iOi, n1iOl}));
	defparam
		nll11l.width_data = 3,
		nll11l.width_sel = 3;
	oper_selector   nll1il
	( 
	.data({1'b0, wire_nlOlOi_dataout, 1'b1, wire_nlOiil_dataout, wire_nlO1Ol_dataout, wire_nllOli_dataout}),
	.o(wire_nll1il_o),
	.sel({ni00Oi, n1l0l, (n1l0i | n1l1O), n1l1l, n1l1i, n1iOO}));
	defparam
		nll1il.width_data = 6,
		nll1il.width_sel = 6;
	oper_selector   nll1ll
	( 
	.data({1'b0, niiOOi, wire_nlOlOl_dataout}),
	.o(wire_nll1ll_o),
	.sel({ni00Ol, n1lii, n1l0l}));
	defparam
		nll1ll.width_data = 3,
		nll1ll.width_sel = 3;
	oper_selector   nll1Ol
	( 
	.data({(~ ni0Oii), (~ niiOOi), wire_nlOO1i_dataout, 1'b0, wire_nllllO_dataout, wire_nlllil_dataout}),
	.o(wire_nll1Ol_o),
	.sel({n1liO, n1lii, n1l0l, ni00OO, n1iii, n1i0l}));
	defparam
		nll1Ol.width_data = 6,
		nll1Ol.width_sel = 6;
	oper_selector   nlli0i
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nlli0i_o),
	.sel({ni0ilO, ni0ill, n1iOi}));
	defparam
		nlli0i.width_data = 3,
		nlli0i.width_sel = 3;
	oper_selector   nlliil
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliil_o),
	.sel({ni0iOi, (~ ni0iOi)}));
	defparam
		nlliil.width_data = 2,
		nlliil.width_sel = 2;
	oper_selector   nllili
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nllili_o),
	.sel({ni0iOl, (~ ni0iOl)}));
	defparam
		nllili.width_data = 2,
		nllili.width_sel = 2;
	oper_selector   nllilO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nllilO_o),
	.sel({ni0l1i, (~ ni0l1i)}));
	defparam
		nllilO.width_data = 2,
		nllilO.width_sel = 2;
	oper_selector   nlliOi
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliOi_o),
	.sel({ni0iOO, (~ ni0iOO)}));
	defparam
		nlliOi.width_data = 2,
		nlliOi.width_sel = 2;
	oper_selector   nlliOO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliOO_o),
	.sel({ni0l1i, (~ ni0l1i)}));
	defparam
		nlliOO.width_data = 2,
		nlliOO.width_sel = 2;
	oper_selector   nlll0i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlll0i_o),
	.sel({ni0l1O, (~ ni0l1O)}));
	defparam
		nlll0i.width_data = 2,
		nlll0i.width_sel = 2;
	oper_selector   nlll0O
	( 
	.data({1'b0, wire_nlOllO_dataout, {9{niiOOi}}}),
	.o(wire_nlll0O_o),
	.sel({ni0l0i, n1l0l, n1l1i, n1iOO, n1iOi, n1iOl, n1ilO, n1ill, n1ili, n1iil, n1iii}));
	defparam
		nlll0O.width_data = 11,
		nlll0O.width_sel = 11;
	oper_selector   nlll1l
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlll1l_o),
	.sel({ni0l1l, (~ ni0l1l)}));
	defparam
		nlll1l.width_data = 2,
		nlll1l.width_sel = 2;
	assign
		bist_ctl_sg = {wire_ni1O_dataout, wire_ni1l_dataout},
		bist_data_sg = {wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout},
		ni000i = (((((((((((((n1liO | n1lii) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil),
		ni000l = ((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1iiO) | n1i0O) | n1i0l),
		ni000O = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii),
		ni001i = ((((((((~ nl0iOl) & (~ nl0iOi)) & (~ nl0ilO)) & (~ nl0ill)) & (~ nl0ili)) & nl0iiO) & nl0iil) & nl0iii),
		ni001O = (nli11i | nl0OOi),
		ni00ii = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0l),
		ni00il = (((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1i0O) | n1i0l),
		ni00iO = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00li = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00ll = ((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00lO = ((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00Oi = (((((((((((n1liO | n1lii) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00Ol = (((((((((((((((n1liO | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00OO = ((((((((((((n1l0i | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0O),
		ni010i = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni010l = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni010O = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni011i = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O1O),
		ni011l = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0i) | nl0O1O),
		ni011O = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01ii = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01il = ((((((((nl0OOl | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01iO = (((((((((nl0OOl | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01li = (((((((((nl0OlO | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01ll = ((((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01lO = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l),
		ni01Oi = (((((((nl0iOl & nl0iOi) & nl0ilO) & nl0ill) & nl0ili) & nl0iiO) & nl0iil) & nl0iii),
		ni01Ol = ((((((nl00Ol & nl00Oi) & nl00lO) & nl00ll) & nl00li) & nl00iO) & nl00il),
		ni01OO = ((((((((~ nl0iOl) & (~ nl0iOi)) & (~ nl0ilO)) & nl0ill) & (~ nl0ili)) & (~ nl0iiO)) & (~ nl0iil)) & (~ nl0iii)),
		ni0i0i = ((((((n1lii | n1l1O) | n1l1l) | n1iOO) | n1ill) | n1ili) | n1iil),
		ni0i0l = (((((((((n1liO | n1l0l) | n1l0i) | n1l1i) | n1iOl) | n1ilO) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0i0O = (((((((((((n1l0l | n1l0i) | n1l1l) | n1l1i) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0i1i = ((((((((((((((n1lii | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0O),
		ni0i1l = (((((((((n1lii | n1l0l) | n1l0i) | n1l1O) | n1iOO) | n1iOl) | n1ilO) | n1ill) | n1iiO) | n1iil),
		ni0i1O = ((((((n1liO | n1l1l) | n1l1i) | n1ili) | n1iii) | n1i0O) | n1i0l),
		ni0iii = ((((n1liO | n1lii) | n1l1O) | n1iOO) | n1iil),
		ni0iil = (((((((((((n1lii | n1l1O) | n1l1l) | n1iOO) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iiO = ((((n1liO | n1l0l) | n1l0i) | n1l1i) | n1iOl),
		ni0ili = ((((((((((((n1lii | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0ill = (((((((n1lii | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOO) | n1iiO) | n1i0O),
		ni0ilO = ((((((((n1liO | n1l1O) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iil) | n1iii) | n1i0l),
		ni0iOi = (((((((((((n1liO | n1l0i) | n1l1O) | n1l1l) | n1iOO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iOl = (((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iOO) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iOO = ((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iOO) | n1iOl) | n1iiO) | n1i0O) | n1i0l),
		ni0l0i = (((((((n1liO | n1lii) | n1l0i) | n1l1O) | n1l1l) | n1iiO) | n1i0O) | n1i0l),
		ni0l0l = ((nlOOiO & (~ nlOOil)) & nliliO),
		ni0l0O = ((nlOOiO & nlOOil) & (~ nliliO)),
		ni0l1i = ((((((n1liO | n1l0i) | n1l1i) | n1iOi) | n1iiO) | n1i0O) | n1i0l),
		ni0l1l = ((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iiO) | n1i0O) | n1i0l),
		ni0l1O = ((((((((((n1liO | n1l0i) | n1iOl) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0lii = (((~ nlOOiO) & nlOOil) & (~ nliliO)),
		ni0lil = ((((((~ nlOOOO) & nlOOOl) & (~ nlOOOi)) & (~ nlOOlO)) & nlOOll) & nlOOli),
		ni0liO = (((((nlOOOO & (~ nlOOOl)) & (~ nlOOOi)) & nlOOlO) & nlOOll) & nlOOli),
		ni0lli = (((~ n111O) & n111l) & n111i),
		ni0lll = ((n111O & n111l) & n111i),
		ni0llO = ((((~ n11ii) & (~ n110O)) & n110l) & (~ n110i)),
		ni0lOi = ((((~ n11ii) & n110O) & n110l) & n110i),
		ni0lOl = (((n11ii & n110O) & n110l) & n110i),
		ni0lOO = (((((~ n11ii) & (~ n110O)) & n110l) & n110i) | (((n11ii & (~ n110O)) & n110l) & n110i)),
		ni0O0i = (((((((((~ n101i) & n11OO) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & n11iO) & n11il),
		ni0O0l = (((((((((~ n101i) & (~ n11OO)) & n11Ol) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & (~ n11iO)) & (~ n11il)),
		ni0O0O = (((((((((~ n101i) & n11OO) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & n11iO) & (~ n11il)),
		ni0O1i = ((((((((n101i & (~ n11OO)) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & n11li) & n11iO) & n11il),
		ni0O1l = ((((((((n101i & (~ n11OO)) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & n11li) & n11iO) & (~ n11il)),
		ni0O1O = (((((((((~ n101i) & (~ n11OO)) & n11Ol) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & (~ n11iO)) & n11il),
		ni0Oii = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		ni0Oil = (((~ nlOOiO) & (~ nlOOil)) & nliliO),
		ni0OiO = (ni0Oll | ni0Oli),
		ni0Oli = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		ni0Oll = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		ni0OlO = ((((n1lii | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0OOi = ((((((n1liO | n1l0l) | n1l0i) | n1l1O) | n1ill) | n1ili) | n1i0l),
		ni0OOl = ((((((n1liO | n1l0l) | n1l1O) | n1l1l) | n1ili) | n1i0O) | n1i0l),
		ni0OOO = (((((((((((((((((((nlili | nliil) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O),
		ni1lll = ((((((nli11O | nl0OOi) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1llO = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0i),
		ni1lOi = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O1O),
		ni1lOl = ((((((((((nli11i | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1lOO = ((((((((((nli11i | nl0OOl) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0i) | nl0O1O),
		ni1O0i = ((((((nl0Oli | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O0l = ((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oil),
		ni1O0O = (((((((nli11i | nl0OOl) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1i = (((((((((((nli11i | nl0OOl) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1l = (((((((nli11i | nl0OOl) | nl0Oll) | nl0OiO) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1O = ((((nli11O | nl0OlO) | nl0Oli) | nl0Oil) | nl0Oii),
		ni1Oii = ((((nli11O | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO),
		ni1Oil = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OiO = ((((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1Oli = ((((((nli11O | nl0OOl) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1Oll = ((((((nli11O | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O1O),
		ni1OlO = (((((nli11O | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOi = ((((((nli11O | nl0Oll) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOl = (((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOO = (((((((nli11O | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		nii00l = (((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl01O) | nl01i) | nl1OO),
		nii01i = (((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii01l = (((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii01O42 ^ nii01O41))),
		nii0ii = (((((((((((((nlili | nli0l) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0lO) | nl0li) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii0il38 ^ nii0il37))),
		nii0ll = ((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii0lO34 ^ nii0lO33))),
		nii0Ol = ((((((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii10i = (((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01i) | nl1OO),
		nii10l = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii10O = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii11i = ((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO),
		nii11l = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l),
		nii11O = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl1OO),
		nii1ii = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1il = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1iO = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1li = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1ll = ((((((((((((((((((nlili | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1lO = ((((((((((((((((((nli0l | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01i),
		nii1Oi = ((((((((((((((((((((nliil | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01i),
		nii1Ol = (((((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		niii0l = (((((((((((((((nlili | nliil) | nli0l) | nli1O) | nli1l) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (niii0O22 ^ niii0O21))),
		niiiil = ((niO0O & (~ niO0l)) & n0lOi),
		niiiiO = ((niO0O & niO0l) & (~ n0lOi)),
		niiili = (((~ niO0O) & niO0l) & (~ n0lOi)),
		niiill = ((((niOll & niOli) & niOiO) & niOil) & (~ niOii)),
		niiilO = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		niiiOi = (((~ niO0O) & (~ niO0l)) & n0lOi),
		niiiOl = (niil1i | niiiOO),
		niiiOO = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		niil0i = (((((((((nliil | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0ll) | nl0li),
		niil0l = (((((((((nlili | nliil) | nli1l) | nl0OO) | nl0Oi) | nl0li) | nl0il) | nl0ii) | nl00O) | nl00i),
		niil0O = (((((((((nlili | nli0O) | nli0l) | nli1O) | nli1l) | nli1i) | nl0Oi) | nl0lO) | nl0iO) | nl00l),
		niil1i = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		niil1l = ((((nliil | nl01O) | nl01l) | nl01i) | nl1OO),
		niil1O = (((((((nlili | nli0i) | nl0lO) | nl0ll) | nl0ii) | nl01l) | nl01i) | nl1OO),
		niilii = (((((nlili | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl00l),
		niilil = (((((((((((nlili | nli0O) | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0lO) | nl0ll) | nl0il) | nl00l) | nl00i) | nl1OO),
		niiliO = (((((((((nlili | nli0i) | nli1l) | nl0Ol) | nl0Oi) | nl0lO) | nl0iO) | nl00l) | nl01l) | nl1OO),
		niilli = (((((((((nliil | nli0l) | nli0i) | nli1O) | nl0Ol) | nl0Oi) | nl0li) | nl0ii) | nl01O) | nl01l),
		niilll = 1'b1,
		niilOl = 1'b0,
		niiOil = (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (niiO0O8 ^ niiO0O7)),
		niiOiO = ((rbist_sel[0] & (~ rbist_sel[1])) & (niiO0i10 ^ niiO0i9)),
		niiOli = (((~ rbist_sel[0]) & rbist_sel[1]) & (niiO1l12 ^ niiO1l11)),
		niiOOi = ((((rpmadwidth_tx & (~ rpma_doublewidth_tx)) & (nil11i2 ^ nil11i1)) & rdwidth_tx) | ((rpmadwidth_tx & rpma_doublewidth_tx) & (niiOOl4 ^ niiOOl3)));
endmodule //stratixiigx_hssi_tx_bist_gen
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 91 mux21 114 oper_decoder 1 oper_mux 23 oper_selector 20 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_prbs_gen
	( 
	prbs_out,
	rpma_doublewidth_tx,
	rpmadwidth_tx,
	rprbs_en_tx,
	rprbs_sel,
	soft_reset,
	tx_clk) /* synthesis synthesis_clearbox=1 */;
	output   [19:0]  prbs_out;
	input   rpma_doublewidth_tx;
	input   rpmadwidth_tx;
	input   rprbs_en_tx;
	input   [2:0]  rprbs_sel;
	input   soft_reset;
	input   tx_clk;

	reg	n101l5;
	reg	n101l6;
	reg	n10ii3;
	reg	n10ii4;
	reg	n10lO1;
	reg	n10lO2;
	reg	n110i13;
	reg	n110i14;
	reg	n11il11;
	reg	n11il12;
	reg	n11ll10;
	reg	n11ll9;
	reg	n11Ol7;
	reg	n11Ol8;
	reg	nlO0lO43;
	reg	nlO0lO44;
	reg	nlO0Oi41;
	reg	nlO0Oi42;
	reg	nlO0Ol39;
	reg	nlO0Ol40;
	reg	nlO0OO37;
	reg	nlO0OO38;
	reg	nlOi1O35;
	reg	nlOi1O36;
	reg	nlOiii33;
	reg	nlOiii34;
	reg	nlOill31;
	reg	nlOill32;
	reg	nlOiOl29;
	reg	nlOiOl30;
	reg	nlOl0O25;
	reg	nlOl0O26;
	reg	nlOl1l27;
	reg	nlOl1l28;
	reg	nlOlll23;
	reg	nlOlll24;
	reg	nlOlOl21;
	reg	nlOlOl22;
	reg	nlOO0l19;
	reg	nlOO0l20;
	reg	nlOOil17;
	reg	nlOOil18;
	reg	nlOOOi15;
	reg	nlOOOi16;
	reg	n011i;
	reg	n011l;
	reg	n1lOi;
	reg	n1lOl;
	reg	n1lOO;
	reg	n1O0i;
	reg	n1O0l;
	reg	n1O0O;
	reg	n1O1i;
	reg	n1O1l;
	reg	n1O1O;
	reg	n1Oii;
	reg	n1Oil;
	reg	n1OiO;
	reg	n1Oli;
	reg	n1Oll;
	reg	n1OlO;
	reg	n1OOi;
	reg	n1OOl;
	reg	n1OOO;
	reg	nli;
	wire	wire_niO_CLRN;
	reg	n000i;
	reg	n000l;
	reg	n000O;
	reg	n001i;
	reg	n001l;
	reg	n001O;
	reg	n00ii;
	reg	n00il;
	reg	n00iO;
	reg	n00li;
	reg	n00ll;
	reg	n010i;
	reg	n010l;
	reg	n010O;
	reg	n011O;
	reg	n01ii;
	reg	n01il;
	reg	n01iO;
	reg	n01li;
	reg	n01ll;
	reg	n01lO;
	reg	n01Oi;
	reg	n01Ol;
	reg	n01OO;
	reg	ni;
	reg	nO;
	wire	wire_nl_CLRN;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n00Ol_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1li_dataout;
	wire	wire_ni1ll_dataout;
	wire	wire_ni1lO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire  [31:0]   wire_nil0l_o;
	wire  wire_nil0O_o;
	wire  wire_nilii_o;
	wire  wire_nilil_o;
	wire  wire_niliO_o;
	wire  wire_nilli_o;
	wire  wire_nilll_o;
	wire  wire_nillO_o;
	wire  wire_nilOi_o;
	wire  wire_nilOl_o;
	wire  wire_nilOO_o;
	wire  wire_niO0i_o;
	wire  wire_niO0l_o;
	wire  wire_niO0O_o;
	wire  wire_niO1i_o;
	wire  wire_niO1l_o;
	wire  wire_niO1O_o;
	wire  wire_niOii_o;
	wire  wire_niOil_o;
	wire  wire_niOiO_o;
	wire  wire_niOli_o;
	wire  wire_niOll_o;
	wire  wire_niOlO_o;
	wire  wire_niOOi_o;
	wire  wire_ni00l_o;
	wire  wire_ni00O_o;
	wire  wire_ni0ii_o;
	wire  wire_ni0il_o;
	wire  wire_ni0iO_o;
	wire  wire_ni0li_o;
	wire  wire_ni0ll_o;
	wire  wire_ni0lO_o;
	wire  wire_ni0Ol_o;
	wire  wire_ni0OO_o;
	wire  wire_nii0i_o;
	wire  wire_nii1i_o;
	wire  wire_nii1l_o;
	wire  wire_niiii_o;
	wire  wire_niiiO_o;
	wire  wire_niili_o;
	wire  wire_niill_o;
	wire  wire_niilO_o;
	wire  wire_nil1i_o;
	wire  wire_nil1l_o;
	wire  n100i;
	wire  n100l;
	wire  n100O;
	wire  n101i;
	wire  n101O;
	wire  n10li;
	wire  n110O;
	wire  n111i;
	wire  n111l;
	wire  n111O;
	wire  n11ii;
	wire  n11li;
	wire  n11Oi;
	wire  nlO00i;
	wire  nlO00l;
	wire  nlO00O;
	wire  nlO0ii;
	wire  nlO0il;
	wire  nlO0iO;
	wire  nlO0li;
	wire  nlO0ll;
	wire  nlOi0l;
	wire  nlOi0O;
	wire  nlOi1i;
	wire  nlOi1l;
	wire  nlOiiO;
	wire  nlOili;
	wire  nlOiOi;
	wire  nlOl0i;
	wire  nlOl0l;
	wire  nlOl1i;
	wire  nlOlil;
	wire  nlOliO;
	wire  nlOlli;
	wire  nlOlOi;
	wire  nlOO0i;
	wire  nlOO1i;
	wire  nlOO1l;
	wire  nlOO1O;
	wire  nlOOii;
	wire  nlOOli;
	wire  nlOOll;
	wire  nlOOlO;
	wire  nlOOOO;

	initial
		n101l5 = 0;
	always @ ( posedge tx_clk)
		  n101l5 <= n101l6;
	event n101l5_event;
	initial
		#1 ->n101l5_event;
	always @(n101l5_event)
		n101l5 <= {1{1'b1}};
	initial
		n101l6 = 0;
	always @ ( posedge tx_clk)
		  n101l6 <= n101l5;
	initial
		n10ii3 = 0;
	always @ ( posedge tx_clk)
		  n10ii3 <= n10ii4;
	event n10ii3_event;
	initial
		#1 ->n10ii3_event;
	always @(n10ii3_event)
		n10ii3 <= {1{1'b1}};
	initial
		n10ii4 = 0;
	always @ ( posedge tx_clk)
		  n10ii4 <= n10ii3;
	initial
		n10lO1 = 0;
	always @ ( posedge tx_clk)
		  n10lO1 <= n10lO2;
	event n10lO1_event;
	initial
		#1 ->n10lO1_event;
	always @(n10lO1_event)
		n10lO1 <= {1{1'b1}};
	initial
		n10lO2 = 0;
	always @ ( posedge tx_clk)
		  n10lO2 <= n10lO1;
	initial
		n110i13 = 0;
	always @ ( posedge tx_clk)
		  n110i13 <= n110i14;
	event n110i13_event;
	initial
		#1 ->n110i13_event;
	always @(n110i13_event)
		n110i13 <= {1{1'b1}};
	initial
		n110i14 = 0;
	always @ ( posedge tx_clk)
		  n110i14 <= n110i13;
	initial
		n11il11 = 0;
	always @ ( posedge tx_clk)
		  n11il11 <= n11il12;
	event n11il11_event;
	initial
		#1 ->n11il11_event;
	always @(n11il11_event)
		n11il11 <= {1{1'b1}};
	initial
		n11il12 = 0;
	always @ ( posedge tx_clk)
		  n11il12 <= n11il11;
	initial
		n11ll10 = 0;
	always @ ( posedge tx_clk)
		  n11ll10 <= n11ll9;
	initial
		n11ll9 = 0;
	always @ ( posedge tx_clk)
		  n11ll9 <= n11ll10;
	event n11ll9_event;
	initial
		#1 ->n11ll9_event;
	always @(n11ll9_event)
		n11ll9 <= {1{1'b1}};
	initial
		n11Ol7 = 0;
	always @ ( posedge tx_clk)
		  n11Ol7 <= n11Ol8;
	event n11Ol7_event;
	initial
		#1 ->n11Ol7_event;
	always @(n11Ol7_event)
		n11Ol7 <= {1{1'b1}};
	initial
		n11Ol8 = 0;
	always @ ( posedge tx_clk)
		  n11Ol8 <= n11Ol7;
	initial
		nlO0lO43 = 0;
	always @ ( posedge tx_clk)
		  nlO0lO43 <= nlO0lO44;
	event nlO0lO43_event;
	initial
		#1 ->nlO0lO43_event;
	always @(nlO0lO43_event)
		nlO0lO43 <= {1{1'b1}};
	initial
		nlO0lO44 = 0;
	always @ ( posedge tx_clk)
		  nlO0lO44 <= nlO0lO43;
	initial
		nlO0Oi41 = 0;
	always @ ( posedge tx_clk)
		  nlO0Oi41 <= nlO0Oi42;
	event nlO0Oi41_event;
	initial
		#1 ->nlO0Oi41_event;
	always @(nlO0Oi41_event)
		nlO0Oi41 <= {1{1'b1}};
	initial
		nlO0Oi42 = 0;
	always @ ( posedge tx_clk)
		  nlO0Oi42 <= nlO0Oi41;
	initial
		nlO0Ol39 = 0;
	always @ ( posedge tx_clk)
		  nlO0Ol39 <= nlO0Ol40;
	event nlO0Ol39_event;
	initial
		#1 ->nlO0Ol39_event;
	always @(nlO0Ol39_event)
		nlO0Ol39 <= {1{1'b1}};
	initial
		nlO0Ol40 = 0;
	always @ ( posedge tx_clk)
		  nlO0Ol40 <= nlO0Ol39;
	initial
		nlO0OO37 = 0;
	always @ ( posedge tx_clk)
		  nlO0OO37 <= nlO0OO38;
	event nlO0OO37_event;
	initial
		#1 ->nlO0OO37_event;
	always @(nlO0OO37_event)
		nlO0OO37 <= {1{1'b1}};
	initial
		nlO0OO38 = 0;
	always @ ( posedge tx_clk)
		  nlO0OO38 <= nlO0OO37;
	initial
		nlOi1O35 = 0;
	always @ ( posedge tx_clk)
		  nlOi1O35 <= nlOi1O36;
	event nlOi1O35_event;
	initial
		#1 ->nlOi1O35_event;
	always @(nlOi1O35_event)
		nlOi1O35 <= {1{1'b1}};
	initial
		nlOi1O36 = 0;
	always @ ( posedge tx_clk)
		  nlOi1O36 <= nlOi1O35;
	initial
		nlOiii33 = 0;
	always @ ( posedge tx_clk)
		  nlOiii33 <= nlOiii34;
	event nlOiii33_event;
	initial
		#1 ->nlOiii33_event;
	always @(nlOiii33_event)
		nlOiii33 <= {1{1'b1}};
	initial
		nlOiii34 = 0;
	always @ ( posedge tx_clk)
		  nlOiii34 <= nlOiii33;
	initial
		nlOill31 = 0;
	always @ ( posedge tx_clk)
		  nlOill31 <= nlOill32;
	event nlOill31_event;
	initial
		#1 ->nlOill31_event;
	always @(nlOill31_event)
		nlOill31 <= {1{1'b1}};
	initial
		nlOill32 = 0;
	always @ ( posedge tx_clk)
		  nlOill32 <= nlOill31;
	initial
		nlOiOl29 = 0;
	always @ ( posedge tx_clk)
		  nlOiOl29 <= nlOiOl30;
	event nlOiOl29_event;
	initial
		#1 ->nlOiOl29_event;
	always @(nlOiOl29_event)
		nlOiOl29 <= {1{1'b1}};
	initial
		nlOiOl30 = 0;
	always @ ( posedge tx_clk)
		  nlOiOl30 <= nlOiOl29;
	initial
		nlOl0O25 = 0;
	always @ ( posedge tx_clk)
		  nlOl0O25 <= nlOl0O26;
	event nlOl0O25_event;
	initial
		#1 ->nlOl0O25_event;
	always @(nlOl0O25_event)
		nlOl0O25 <= {1{1'b1}};
	initial
		nlOl0O26 = 0;
	always @ ( posedge tx_clk)
		  nlOl0O26 <= nlOl0O25;
	initial
		nlOl1l27 = 0;
	always @ ( posedge tx_clk)
		  nlOl1l27 <= nlOl1l28;
	event nlOl1l27_event;
	initial
		#1 ->nlOl1l27_event;
	always @(nlOl1l27_event)
		nlOl1l27 <= {1{1'b1}};
	initial
		nlOl1l28 = 0;
	always @ ( posedge tx_clk)
		  nlOl1l28 <= nlOl1l27;
	initial
		nlOlll23 = 0;
	always @ ( posedge tx_clk)
		  nlOlll23 <= nlOlll24;
	event nlOlll23_event;
	initial
		#1 ->nlOlll23_event;
	always @(nlOlll23_event)
		nlOlll23 <= {1{1'b1}};
	initial
		nlOlll24 = 0;
	always @ ( posedge tx_clk)
		  nlOlll24 <= nlOlll23;
	initial
		nlOlOl21 = 0;
	always @ ( posedge tx_clk)
		  nlOlOl21 <= nlOlOl22;
	event nlOlOl21_event;
	initial
		#1 ->nlOlOl21_event;
	always @(nlOlOl21_event)
		nlOlOl21 <= {1{1'b1}};
	initial
		nlOlOl22 = 0;
	always @ ( posedge tx_clk)
		  nlOlOl22 <= nlOlOl21;
	initial
		nlOO0l19 = 0;
	always @ ( posedge tx_clk)
		  nlOO0l19 <= nlOO0l20;
	event nlOO0l19_event;
	initial
		#1 ->nlOO0l19_event;
	always @(nlOO0l19_event)
		nlOO0l19 <= {1{1'b1}};
	initial
		nlOO0l20 = 0;
	always @ ( posedge tx_clk)
		  nlOO0l20 <= nlOO0l19;
	initial
		nlOOil17 = 0;
	always @ ( posedge tx_clk)
		  nlOOil17 <= nlOOil18;
	event nlOOil17_event;
	initial
		#1 ->nlOOil17_event;
	always @(nlOOil17_event)
		nlOOil17 <= {1{1'b1}};
	initial
		nlOOil18 = 0;
	always @ ( posedge tx_clk)
		  nlOOil18 <= nlOOil17;
	initial
		nlOOOi15 = 0;
	always @ ( posedge tx_clk)
		  nlOOOi15 <= nlOOOi16;
	event nlOOOi15_event;
	initial
		#1 ->nlOOOi15_event;
	always @(nlOOOi15_event)
		nlOOOi15 <= {1{1'b1}};
	initial
		nlOOOi16 = 0;
	always @ ( posedge tx_clk)
		  nlOOOi16 <= nlOOOi15;
	initial
	begin
		n011i = 0;
		n011l = 0;
		n1lOi = 0;
		n1lOl = 0;
		n1lOO = 0;
		n1O0i = 0;
		n1O0l = 0;
		n1O0O = 0;
		n1O1i = 0;
		n1O1l = 0;
		n1O1O = 0;
		n1Oii = 0;
		n1Oil = 0;
		n1OiO = 0;
		n1Oli = 0;
		n1Oll = 0;
		n1OlO = 0;
		n1OOi = 0;
		n1OOl = 0;
		n1OOO = 0;
		nli = 0;
	end
	always @ ( posedge tx_clk or  negedge wire_niO_CLRN)
	begin
		if (wire_niO_CLRN == 1'b0) 
		begin
			n011i <= 0;
			n011l <= 0;
			n1lOi <= 0;
			n1lOl <= 0;
			n1lOO <= 0;
			n1O0i <= 0;
			n1O0l <= 0;
			n1O0O <= 0;
			n1O1i <= 0;
			n1O1l <= 0;
			n1O1O <= 0;
			n1Oii <= 0;
			n1Oil <= 0;
			n1OiO <= 0;
			n1Oli <= 0;
			n1Oll <= 0;
			n1OlO <= 0;
			n1OOi <= 0;
			n1OOl <= 0;
			n1OOO <= 0;
			nli <= 0;
		end
		else if  (n100O == 1'b0) 
		begin
			n011i <= wire_n0OiO_dataout;
			n011l <= wire_n0Oli_dataout;
			n1lOi <= wire_n0l0O_dataout;
			n1lOl <= wire_n0lii_dataout;
			n1lOO <= wire_n0lil_dataout;
			n1O0i <= wire_n0llO_dataout;
			n1O0l <= wire_n0lOi_dataout;
			n1O0O <= wire_n0lOl_dataout;
			n1O1i <= wire_n0liO_dataout;
			n1O1l <= wire_n0lli_dataout;
			n1O1O <= wire_n0lll_dataout;
			n1Oii <= wire_n0lOO_dataout;
			n1Oil <= wire_n0O1i_dataout;
			n1OiO <= wire_n0O1l_dataout;
			n1Oli <= wire_n0O1O_dataout;
			n1Oll <= wire_n0O0i_dataout;
			n1OlO <= wire_n0O0l_dataout;
			n1OOi <= wire_n0O0O_dataout;
			n1OOl <= wire_n0Oii_dataout;
			n1OOO <= wire_n0Oil_dataout;
			nli <= wire_n0l0l_dataout;
		end
	end
	assign
		wire_niO_CLRN = ((n101l6 ^ n101l5) & (~ soft_reset));
	initial
	begin
		n000i = 0;
		n000l = 0;
		n000O = 0;
		n001i = 0;
		n001l = 0;
		n001O = 0;
		n00ii = 0;
		n00il = 0;
		n00iO = 0;
		n00li = 0;
		n00ll = 0;
		n010i = 0;
		n010l = 0;
		n010O = 0;
		n011O = 0;
		n01ii = 0;
		n01il = 0;
		n01iO = 0;
		n01li = 0;
		n01ll = 0;
		n01lO = 0;
		n01Oi = 0;
		n01Ol = 0;
		n01OO = 0;
		ni = 0;
		nO = 0;
	end
	always @ ( posedge tx_clk or  negedge wire_nl_CLRN)
	begin
		if (wire_nl_CLRN == 1'b0) 
		begin
			n000i <= 0;
			n000l <= 0;
			n000O <= 0;
			n001i <= 0;
			n001l <= 0;
			n001O <= 0;
			n00ii <= 0;
			n00il <= 0;
			n00iO <= 0;
			n00li <= 0;
			n00ll <= 0;
			n010i <= 0;
			n010l <= 0;
			n010O <= 0;
			n011O <= 0;
			n01ii <= 0;
			n01il <= 0;
			n01iO <= 0;
			n01li <= 0;
			n01ll <= 0;
			n01lO <= 0;
			n01Oi <= 0;
			n01Ol <= 0;
			n01OO <= 0;
			ni <= 0;
			nO <= 0;
		end
		else 
		begin
			n000i <= wire_n0iOi_dataout;
			n000l <= wire_n0iOl_dataout;
			n000O <= wire_n0iOO_dataout;
			n001i <= wire_n0ili_dataout;
			n001l <= wire_n0ill_dataout;
			n001O <= wire_n0ilO_dataout;
			n00ii <= wire_n0l1i_dataout;
			n00il <= wire_n0l1l_dataout;
			n00iO <= wire_n0l1O_dataout;
			n00li <= wire_n0l0i_dataout;
			n00ll <= ni;
			n010i <= wire_n00Oi_dataout;
			n010l <= wire_n00Ol_dataout;
			n010O <= wire_n00OO_dataout;
			n011O <= wire_n00lO_dataout;
			n01ii <= wire_n0i1i_dataout;
			n01il <= wire_n0i1l_dataout;
			n01iO <= wire_n0i1O_dataout;
			n01li <= wire_n0i0i_dataout;
			n01ll <= wire_n0i0l_dataout;
			n01lO <= wire_n0i0O_dataout;
			n01Oi <= wire_n0iii_dataout;
			n01Ol <= wire_n0iil_dataout;
			n01OO <= wire_n0iiO_dataout;
			ni <= nO;
			nO <= rprbs_en_tx;
		end
	end
	assign
		wire_nl_CLRN = ((n10lO2 ^ n10lO1) & (~ soft_reset));
	or(wire_n00i_dataout, n01il, nli);
	and(wire_n00l_dataout, n01iO, ~(nli));
	assign		wire_n00lO_dataout = (n100O === 1'b1) ? (~ n101O) : wire_n0Oll_dataout;
	or(wire_n00O_dataout, n01li, nli);
	assign		wire_n00Oi_dataout = (n100O === 1'b1) ? (~ n101O) : wire_n0OlO_dataout;
	assign		wire_n00Ol_dataout = (n100O === 1'b1) ? (~ n101O) : wire_n0OOi_dataout;
	assign		wire_n00OO_dataout = (n100O === 1'b1) ? (~ n101O) : wire_n0OOl_dataout;
	and(wire_n01i_dataout, n010l, ~(nli));
	and(wire_n01l_dataout, n010O, ~(nli));
	and(wire_n01O_dataout, n01ii, ~(nli));
	assign		wire_n0i0i_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni11O_dataout;
	assign		wire_n0i0l_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni10i_dataout;
	assign		wire_n0i0O_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni10l_dataout;
	assign		wire_n0i1i_dataout = (n100O === 1'b1) ? (~ n101O) : wire_n0OOO_dataout;
	assign		wire_n0i1l_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni11i_dataout;
	or(wire_n0i1O_dataout, wire_ni11l_dataout, n100O);
	and(wire_n0ii_dataout, n01ll, ~(nli));
	assign		wire_n0iii_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni10O_dataout;
	assign		wire_n0iil_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni1ii_dataout;
	or(wire_n0iiO_dataout, wire_ni1il_dataout, n100O);
	and(wire_n0il_dataout, n01lO, ~(nli));
	or(wire_n0ili_dataout, wire_ni1iO_dataout, n100O);
	assign		wire_n0ill_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni1li_dataout;
	assign		wire_n0ilO_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni1ll_dataout;
	and(wire_n0iO_dataout, n01Oi, ~(nli));
	assign		wire_n0iOi_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni1lO_dataout;
	assign		wire_n0iOl_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni1Oi_dataout;
	assign		wire_n0iOO_dataout = (n100O === 1'b1) ? (~ n100l) : wire_ni1Ol_dataout;
	assign		wire_n0l0i_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni01O_dataout;
	assign		wire_n0l0l_dataout = (n00ll === 1'b1) ? wire_ni00i_dataout : nli;
	assign		wire_n0l0O_dataout = (n00ll === 1'b1) ? wire_ni00l_o : n1lOi;
	assign		wire_n0l1i_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni1OO_dataout;
	assign		wire_n0l1l_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni01i_dataout;
	assign		wire_n0l1O_dataout = (n100O === 1'b1) ? (~ n101O) : wire_ni01l_dataout;
	and(wire_n0li_dataout, n01Ol, ~(nli));
	assign		wire_n0lii_dataout = (n00ll === 1'b1) ? wire_ni00O_o : n1lOl;
	assign		wire_n0lil_dataout = (n00ll === 1'b1) ? wire_ni0ii_o : n1lOO;
	assign		wire_n0liO_dataout = (n00ll === 1'b1) ? wire_ni0il_o : n1O1i;
	and(wire_n0ll_dataout, n01OO, ~(nli));
	assign		wire_n0lli_dataout = (n00ll === 1'b1) ? wire_ni0iO_o : n1O1l;
	assign		wire_n0lll_dataout = (n00ll === 1'b1) ? wire_ni0li_o : n1O1O;
	assign		wire_n0llO_dataout = (n00ll === 1'b1) ? wire_ni0ll_o : n1O0i;
	and(wire_n0lO_dataout, n001i, ~(nli));
	assign		wire_n0lOi_dataout = (n00ll === 1'b1) ? wire_ni0lO_o : n1O0l;
	assign		wire_n0lOl_dataout = (n00ll === 1'b1) ? wire_ni0Ol_o : n1O0O;
	assign		wire_n0lOO_dataout = (n00ll === 1'b1) ? wire_ni0OO_o : n1Oii;
	assign		wire_n0O0i_dataout = (n00ll === 1'b1) ? wire_niiii_o : n1Oll;
	assign		wire_n0O0l_dataout = (n00ll === 1'b1) ? wire_niiiO_o : n1OlO;
	assign		wire_n0O0O_dataout = (n00ll === 1'b1) ? wire_niili_o : n1OOi;
	assign		wire_n0O1i_dataout = (n00ll === 1'b1) ? wire_nii1i_o : n1Oil;
	assign		wire_n0O1l_dataout = (n00ll === 1'b1) ? wire_nii1l_o : n1OiO;
	assign		wire_n0O1O_dataout = (n00ll === 1'b1) ? wire_nii0i_o : n1Oli;
	and(wire_n0Oi_dataout, n001l, ~(nli));
	assign		wire_n0Oii_dataout = (n00ll === 1'b1) ? wire_niill_o : n1OOl;
	assign		wire_n0Oil_dataout = (n00ll === 1'b1) ? wire_niilO_o : n1OOO;
	assign		wire_n0OiO_dataout = (n00ll === 1'b1) ? wire_nil1i_o : n011i;
	and(wire_n0Ol_dataout, n001O, ~(nli));
	assign		wire_n0Oli_dataout = (n00ll === 1'b1) ? wire_nil1l_o : n011l;
	assign		wire_n0Oll_dataout = (n00ll === 1'b1) ? wire_nil0O_o : n011O;
	assign		wire_n0OlO_dataout = (n00ll === 1'b1) ? wire_nilii_o : n010i;
	and(wire_n0OO_dataout, n000i, ~(nli));
	assign		wire_n0OOi_dataout = (n00ll === 1'b1) ? wire_nilil_o : n010l;
	assign		wire_n0OOl_dataout = (n00ll === 1'b1) ? wire_niliO_o : n010O;
	assign		wire_n0OOO_dataout = (n00ll === 1'b1) ? wire_nilli_o : n01ii;
	and(wire_n10i_dataout, wire_n0lO_dataout, ~((~ nli)));
	and(wire_n10l_dataout, wire_n0Oi_dataout, ~((~ nli)));
	and(wire_n10O_dataout, wire_n0Ol_dataout, ~((~ nli)));
	and(wire_n11i_dataout, wire_n0iO_dataout, ~((~ nli)));
	and(wire_n11l_dataout, wire_n0li_dataout, ~((~ nli)));
	and(wire_n11O_dataout, wire_n0ll_dataout, ~((~ nli)));
	and(wire_n1ii_dataout, wire_n0OO_dataout, ~((~ nli)));
	and(wire_n1il_dataout, wire_ni1i_dataout, ~((~ nli)));
	and(wire_n1iO_dataout, wire_ni1l_dataout, ~((~ nli)));
	and(wire_n1li_dataout, wire_ni1O_dataout, ~((~ nli)));
	and(wire_n1ll_dataout, wire_ni0i_dataout, ~((~ nli)));
	and(wire_n1lO_dataout, wire_ni0l_dataout, ~((~ nli)));
	and(wire_n1Oi_dataout, wire_ni0O_dataout, ~((~ nli)));
	and(wire_n1Ol_dataout, n011O, ~(nli));
	and(wire_n1OO_dataout, n010i, ~(nli));
	assign		wire_ni00i_dataout = (wire_nil0l_o[11] === 1'b1) ? (~ nli) : nli;
	assign		wire_ni01i_dataout = (n00ll === 1'b1) ? wire_niOll_o : n00il;
	assign		wire_ni01l_dataout = (n00ll === 1'b1) ? wire_niOlO_o : n00iO;
	assign		wire_ni01O_dataout = (n00ll === 1'b1) ? wire_niOOi_o : n00li;
	and(wire_ni0i_dataout, n00il, ~(nli));
	and(wire_ni0l_dataout, n00iO, ~(nli));
	and(wire_ni0O_dataout, n00li, ~(nli));
	assign		wire_ni10i_dataout = (n00ll === 1'b1) ? wire_nilOl_o : n01ll;
	assign		wire_ni10l_dataout = (n00ll === 1'b1) ? wire_nilOO_o : n01lO;
	assign		wire_ni10O_dataout = (n00ll === 1'b1) ? wire_niO1i_o : n01Oi;
	assign		wire_ni11i_dataout = (n00ll === 1'b1) ? wire_nilll_o : n01il;
	assign		wire_ni11l_dataout = (n00ll === 1'b1) ? wire_nillO_o : n01iO;
	assign		wire_ni11O_dataout = (n00ll === 1'b1) ? wire_nilOi_o : n01li;
	and(wire_ni1i_dataout, n000l, ~(nli));
	assign		wire_ni1ii_dataout = (n00ll === 1'b1) ? wire_niO1l_o : n01Ol;
	assign		wire_ni1il_dataout = (n00ll === 1'b1) ? wire_niO1O_o : n01OO;
	assign		wire_ni1iO_dataout = (n00ll === 1'b1) ? wire_niO0i_o : n001i;
	and(wire_ni1l_dataout, n000O, ~(nli));
	assign		wire_ni1li_dataout = (n00ll === 1'b1) ? wire_niO0l_o : n001l;
	assign		wire_ni1ll_dataout = (n00ll === 1'b1) ? wire_niO0O_o : n001O;
	assign		wire_ni1lO_dataout = (n00ll === 1'b1) ? wire_niOii_o : n000i;
	and(wire_ni1O_dataout, n00ii, ~(nli));
	assign		wire_ni1Oi_dataout = (n00ll === 1'b1) ? wire_niOil_o : n000l;
	assign		wire_ni1Ol_dataout = (n00ll === 1'b1) ? wire_niOiO_o : n000O;
	assign		wire_ni1OO_dataout = (n00ll === 1'b1) ? wire_niOli_o : n00ii;
	or(wire_nlO0O_dataout, wire_n1Ol_dataout, (~ nli));
	or(wire_nlOii_dataout, wire_n1OO_dataout, (~ nli));
	or(wire_nlOil_dataout, wire_n01i_dataout, (~ nli));
	or(wire_nlOiO_dataout, wire_n01l_dataout, (~ nli));
	or(wire_nlOli_dataout, wire_n01O_dataout, (~ nli));
	and(wire_nlOll_dataout, wire_n00i_dataout, ~((~ nli)));
	or(wire_nlOlO_dataout, wire_n00l_dataout, (~ nli));
	and(wire_nlOOi_dataout, wire_n00O_dataout, ~((~ nli)));
	or(wire_nlOOl_dataout, wire_n0ii_dataout, (~ nli));
	or(wire_nlOOO_dataout, wire_n0il_dataout, (~ nli));
	oper_decoder   nil0l
	( 
	.i({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}),
	.o(wire_nil0l_o));
	defparam
		nil0l.width_i = 5,
		nil0l.width_o = 32;
	oper_mux   nil0O
	( 
	.data({{3{1'b0}}, {3{1'b1}}, ((n000i ^ n010O) ^ n00iO), nlOOlO, {5{1'b0}}, 1'b1, nlOi1i, (n01Oi ^ n01lO), {4{1'b0}}, wire_nlO0O_dataout, {2{1'b1}}, n11li, {6{1'b0}}, 1'b1, ((n11Oi ^ n010i) ^ n011O)}),
	.o(wire_nil0O_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nil0O.width_data = 32,
		nil0O.width_sel = 5;
	oper_mux   nilii
	( 
	.data({{3{1'b0}}, {2{1'b1}}, 1'b0, ((n000l ^ n01ii) ^ n00li), nlOOOO, {6{1'b0}}, nlOi1l, (n01Ol ^ n01Oi), {4{1'b0}}, wire_nlOii_dataout, 1'b1, 1'b0, n11ii, {7{1'b0}}, ((n101i ^ n010l) ^ n010i)}),
	.o(wire_nilii_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nilii.width_data = 32,
		nilii.width_sel = 5;
	oper_mux   nilil
	( 
	.data({{3{1'b0}}, {3{1'b1}}, (n01il ^ n011O), nlOO1O, {5{1'b0}}, 1'b1, nlOi0l, n111l, {4{1'b0}}, wire_nlOil_dataout, {2{1'b1}}, n110O, {6{1'b0}}, 1'b1, (((((n101i ^ n01il) ^ n010O) ^ n010l) ^ n010i) ^ n011O)}),
	.o(wire_nilil_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nilil.width_data = 32,
		nilil.width_sel = 5;
	oper_mux   niliO
	( 
	.data({{3{1'b0}}, {2{1'b1}}, 1'b0, (n01iO ^ n010i), nlOO0i, {6{1'b0}}, nlOi0O, n111O, {4{1'b0}}, wire_nlOiO_dataout, 1'b1, 1'b0, (n01iO ^ n010O), {7{1'b0}}, (((((n01li ^ n01il) ^ n01ii) ^ n010O) ^ n010l) ^ n011O)}),
	.o(wire_niliO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niliO.width_data = 32,
		niliO.width_sel = 5;
	oper_mux   nilli
	( 
	.data({{3{1'b0}}, {3{1'b1}}, nlOi1i, nlOOii, {5{1'b0}}, 1'b1, nlOiiO, nlOOlO, {4{1'b0}}, wire_nlOli_dataout, {2{1'b1}}, (n01li ^ n01ii), {6{1'b0}}, 1'b1, ((n01ii ^ n010O) ^ n011O)}),
	.o(wire_nilli_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nilli.width_data = 32,
		nilli.width_sel = 5;
	oper_mux   nilll
	( 
	.data({{6{1'b0}}, nlOi1l, nlOOll, {6{1'b0}}, nlOili, nlOOOO, {4{1'b0}}, wire_nlOll_dataout, {2{1'b0}}, (n01ll ^ n01il), {7{1'b0}}, ((n01il ^ n01ii) ^ n010i)}),
	.o(wire_nilll_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nilll.width_data = 32,
		nilll.width_sel = 5;
	oper_mux   nillO
	( 
	.data({{3{1'b0}}, 1'b1, 1'b0, 1'b1, nlOi0l, (nlOlli ^ n001i), {5{1'b0}}, 1'b1, nlOiOi, (nlOl0i ^ n01lO), {4{1'b0}}, wire_nlOlO_dataout, 1'b0, 1'b1, (n01lO ^ n01iO), {6{1'b0}}, 1'b1, (n11Oi ^ n010l)}),
	.o(wire_nillO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nillO.width_data = 32,
		nillO.width_sel = 5;
	oper_mux   nilOi
	( 
	.data({{6{1'b0}}, nlOi0O, n111i, {6{1'b0}}, nlOl1i, (n01Ol ^ n01lO), {4{1'b0}}, wire_nlOOi_dataout, {2{1'b0}}, (n11li ^ n01li), {7{1'b0}}, (n101i ^ n010O)}),
	.o(wire_nilOi_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nilOi.width_data = 32,
		nilOi.width_sel = 5;
	oper_mux   nilOl
	( 
	.data({{3{1'b0}}, 1'b1, 1'b0, 1'b1, nlOiiO, (n000i ^ n001l), {5{1'b0}}, 1'b1, nlOl0i, (n01OO ^ n01Oi), {4{1'b0}}, wire_nlOOl_dataout, 1'b0, 1'b1, (n11ii ^ n01ll), {8{1'b0}}}),
	.o(wire_nilOl_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nilOl.width_data = 32,
		nilOl.width_sel = 5;
	oper_mux   nilOO
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nlOili, (n000l ^ n001O), {6{1'b0}}, nlOl0l, (n001i ^ n01Ol), {4{1'b0}}, wire_nlOOO_dataout, {2{1'b0}}, (n110O ^ n01lO), {8{1'b0}}}),
	.o(wire_nilOO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		nilOO.width_data = 32,
		nilOO.width_sel = 5;
	oper_mux   niO0i
	( 
	.data({{4{1'b0}}, 1'b1, 1'b0, nlOl0l, ((n00ii ^ n001O) ^ n001l), {6{1'b0}}, nlOlOi, ((n001O ^ n01Ol) ^ n01Oi), {4{1'b0}}, wire_n10i_dataout, {11{1'b0}}}),
	.o(wire_niO0i_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niO0i.width_data = 32,
		niO0i.width_sel = 5;
	oper_mux   niO0l
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nlOlil, ((nlOO1O ^ n001l) ^ n001i), {5{1'b0}}, 1'b1, nlOO1i, ((n111l ^ n01Oi) ^ n01lO), {4{1'b0}}, wire_n10l_dataout, {11{1'b0}}}),
	.o(wire_niO0l_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niO0l.width_data = 32,
		niO0l.width_sel = 5;
	oper_mux   niO0O
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nlOliO, ((nlOO0i ^ n001O) ^ n001l), {6{1'b0}}, nlOO1l, ((n111O ^ n01Ol) ^ n01Oi), {4{1'b0}}, wire_n10O_dataout, {11{1'b0}}}),
	.o(wire_niO0O_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niO0O.width_data = 32,
		niO0O.width_sel = 5;
	oper_mux   niO1i
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nlOiOi, (n000O ^ n000i), {5{1'b0}}, 1'b1, nlOlil, (n001l ^ n01OO), {4{1'b0}}, wire_n11i_dataout, {11{1'b0}}}),
	.o(wire_niO1i_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niO1i.width_data = 32,
		niO1i.width_sel = 5;
	oper_mux   niO1l
	( 
	.data({{4{1'b0}}, 1'b1, 1'b0, nlOl1i, (n00ii ^ n000l), {6{1'b0}}, nlOliO, n111i, {4{1'b0}}, wire_n11l_dataout, {11{1'b0}}}),
	.o(wire_niO1l_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niO1l.width_data = 32,
		niO1l.width_sel = 5;
	oper_mux   niO1O
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nlOl0i, ((n000O ^ n001l) ^ n001i), {5{1'b0}}, 1'b1, nlOlli, ((n001l ^ n01Oi) ^ n01lO), {4{1'b0}}, wire_n11O_dataout, {11{1'b0}}}),
	.o(wire_niO1O_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niO1O.width_data = 32,
		niO1O.width_sel = 5;
	oper_mux   niOii
	( 
	.data({{5{1'b0}}, 1'b1, nlOlli, ((nlOOii ^ n000i) ^ n001O), {6{1'b0}}, n011O, {5{1'b0}}, wire_n1ii_dataout, {11{1'b0}}}),
	.o(wire_niOii_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niOii.width_data = 32,
		niOii.width_sel = 5;
	oper_mux   niOil
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nlOlOi, (nlOOli ^ n000i), {6{1'b0}}, n010i, {5{1'b0}}, wire_n1il_dataout, {11{1'b0}}}),
	.o(wire_niOil_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niOil.width_data = 32,
		niOil.width_sel = 5;
	oper_mux   niOiO
	( 
	.data({{5{1'b0}}, 1'b1, nlOO1i, ((nlOOli ^ n001l) ^ n001i), {6{1'b0}}, n010l, {5{1'b0}}, wire_n1iO_dataout, {11{1'b0}}}),
	.o(wire_niOiO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niOiO.width_data = 32,
		niOiO.width_sel = 5;
	oper_mux   niOli
	( 
	.data({{6{1'b0}}, nlOO1l, ((nlOOll ^ n001O) ^ n001i), {6{1'b0}}, n010O, {5{1'b0}}, wire_n1li_dataout, {11{1'b0}}}),
	.o(wire_niOli_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niOli.width_data = 32,
		niOli.width_sel = 5;
	oper_mux   niOll
	( 
	.data({{6{1'b0}}, n011O, {7{1'b0}}, n01ii, {5{1'b0}}, wire_n1ll_dataout, {11{1'b0}}}),
	.o(wire_niOll_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niOll.width_data = 32,
		niOll.width_sel = 5;
	oper_mux   niOlO
	( 
	.data({{6{1'b0}}, ((nlO0lO44 ^ nlO0lO43) & n010i), {7{1'b0}}, n01il, {5{1'b0}}, wire_n1lO_dataout, {11{1'b0}}}),
	.o(wire_niOlO_o),
	.sel({((nlO0Oi42 ^ nlO0Oi41) & rpma_doublewidth_tx), rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niOlO.width_data = 32,
		niOlO.width_sel = 5;
	oper_mux   niOOi
	( 
	.data({{6{1'b0}}, n010l, {7{1'b0}}, n01iO, {5{1'b0}}, ((nlO0Ol40 ^ nlO0Ol39) & wire_n1Oi_dataout), {11{1'b0}}}),
	.o(wire_niOOi_o),
	.sel({((nlO0OO38 ^ nlO0OO37) & rpma_doublewidth_tx), rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		niOOi.width_data = 32,
		niOOi.width_sel = 5;
	oper_selector   ni00l
	( 
	.data({1'b0, n011O, n00li}),
	.o(wire_ni00l_o),
	.sel({nlO0iO, nlO0li, nlO00i}));
	defparam
		ni00l.width_data = 3,
		ni00l.width_sel = 3;
	oper_selector   ni00O
	( 
	.data({1'b0, n010i, n00iO}),
	.o(wire_ni00O_o),
	.sel({nlO0iO, nlO0li, nlO00i}));
	defparam
		ni00O.width_data = 3,
		ni00O.width_sel = 3;
	oper_selector   ni0ii
	( 
	.data({1'b0, n010l, n00il}),
	.o(wire_ni0ii_o),
	.sel({nlO0iO, nlO0li, nlO00i}));
	defparam
		ni0ii.width_data = 3,
		ni0ii.width_sel = 3;
	oper_selector   ni0il
	( 
	.data({1'b0, n010O, n00ii}),
	.o(wire_ni0il_o),
	.sel({nlO0iO, nlO0li, nlO00i}));
	defparam
		ni0il.width_data = 3,
		ni0il.width_sel = 3;
	oper_selector   ni0iO
	( 
	.data({1'b0, n01ii, n000O}),
	.o(wire_ni0iO_o),
	.sel({nlO0iO, nlO0li, nlO00i}));
	defparam
		ni0iO.width_data = 3,
		ni0iO.width_sel = 3;
	oper_selector   ni0li
	( 
	.data({1'b0, n01il, n000l}),
	.o(wire_ni0li_o),
	.sel({nlO0iO, nlO0li, nlO00i}));
	defparam
		ni0li.width_data = 3,
		ni0li.width_sel = 3;
	oper_selector   ni0ll
	( 
	.data({1'b0, n01iO, n000i}),
	.o(wire_ni0ll_o),
	.sel({nlO0iO, nlO0li, nlO00i}));
	defparam
		ni0ll.width_data = 3,
		ni0ll.width_sel = 3;
	oper_selector   ni0lO
	( 
	.data({1'b0, n01li, n001O}),
	.o(wire_ni0lO_o),
	.sel({nlO0iO, nlO0li, nlO00i}));
	defparam
		ni0lO.width_data = 3,
		ni0lO.width_sel = 3;
	oper_selector   ni0Ol
	( 
	.data({1'b0, n01ll, n001l, n000i}),
	.o(wire_ni0Ol_o),
	.sel({nlO0ll, nlO0il, wire_nil0l_o[25], nlO0ii}));
	defparam
		ni0Ol.width_data = 4,
		ni0Ol.width_sel = 4;
	oper_selector   ni0OO
	( 
	.data({1'b0, n01lO, n001i, n000l}),
	.o(wire_ni0OO_o),
	.sel({nlO0ll, nlO0il, wire_nil0l_o[25], nlO0ii}));
	defparam
		ni0OO.width_data = 4,
		ni0OO.width_sel = 4;
	oper_selector   nii0i
	( 
	.data({1'b0, n01OO, n01Oi}),
	.o(wire_nii0i_o),
	.sel({nlO0iO, nlO00O, ((wire_nil0l_o[25] | wire_nil0l_o[18]) | wire_nil0l_o[16])}));
	defparam
		nii0i.width_data = 3,
		nii0i.width_sel = 3;
	oper_selector   nii1i
	( 
	.data({1'b0, n01Oi, n01OO, n01ll, n001l}),
	.o(wire_nii1i_o),
	.sel({nlO0iO, nlO0il, wire_nil0l_o[25], nlO0ii, wire_nil0l_o[17]}));
	defparam
		nii1i.width_data = 5,
		nii1i.width_sel = 5;
	oper_selector   nii1l
	( 
	.data({1'b0, n01Ol, n01lO, n001i}),
	.o(wire_nii1l_o),
	.sel({nlO0iO, nlO00l, nlO0ii, wire_nil0l_o[17]}));
	defparam
		nii1l.width_data = 4,
		nii1l.width_sel = 4;
	oper_selector   niiii
	( 
	.data({1'b0, n001i, n01lO, n01Ol}),
	.o(wire_niiii_o),
	.sel({nlO0iO, nlO0il, wire_nil0l_o[25], ((wire_nil0l_o[18] | wire_nil0l_o[17]) | wire_nil0l_o[16])}));
	defparam
		niiii.width_data = 4,
		niiii.width_sel = 4;
	oper_selector   niiiO
	( 
	.data({1'b0, n001l, n01ll, n01OO, n01Oi}),
	.o(wire_niiiO_o),
	.sel({nlO0iO, nlO0il, wire_nil0l_o[25], nlO0ii, wire_nil0l_o[17]}));
	defparam
		niiiO.width_data = 5,
		niiiO.width_sel = 5;
	oper_selector   niili
	( 
	.data({1'b0, n001O, n01li, n001i, n01lO}),
	.o(wire_niili_o),
	.sel({nlO0iO, nlO0il, wire_nil0l_o[25], nlO0ii, wire_nil0l_o[17]}));
	defparam
		niili.width_data = 5,
		niili.width_sel = 5;
	oper_selector   niill
	( 
	.data({1'b0, n000i, n01iO, n001l, n01ll}),
	.o(wire_niill_o),
	.sel({nlO0iO, nlO0il, wire_nil0l_o[25], nlO0ii, wire_nil0l_o[17]}));
	defparam
		niill.width_data = 5,
		niill.width_sel = 5;
	oper_selector   niilO
	( 
	.data({1'b0, n000l, n01il, n001O, n01li}),
	.o(wire_niilO_o),
	.sel({nlO0iO, nlO0il, wire_nil0l_o[25], nlO0ii, wire_nil0l_o[17]}));
	defparam
		niilO.width_data = 5,
		niilO.width_sel = 5;
	oper_selector   nil1i
	( 
	.data({1'b0, n000O, n01ii}),
	.o(wire_nil1i_o),
	.sel({nlO0ll, nlO0li, wire_nil0l_o[25]}));
	defparam
		nil1i.width_data = 3,
		nil1i.width_sel = 3;
	oper_selector   nil1l
	( 
	.data({1'b0, n00ii, n010O}),
	.o(wire_nil1l_o),
	.sel({nlO0ll, nlO0li, wire_nil0l_o[25]}));
	defparam
		nil1l.width_data = 3,
		nil1l.width_sel = 3;
	assign
		n100i = ((((rpmadwidth_tx & rpma_doublewidth_tx) & (~ rprbs_sel[0])) & (~ rprbs_sel[1])) & (~ rprbs_sel[2])),
		n100l = (((((~ rpmadwidth_tx) & rpma_doublewidth_tx) & (~ rprbs_sel[0])) & (~ rprbs_sel[1])) & (~ rprbs_sel[2])),
		n100O = ((ni & (~ n00ll)) & (n10ii4 ^ n10ii3)),
		n101i = (n01li ^ n01iO),
		n101O = (n100l | n100i),
		n10li = 1'b1,
		n110O = (n01il ^ n010l),
		n111i = (n001O ^ n001i),
		n111l = (n01OO ^ n01Ol),
		n111O = ((n001i ^ n01OO) ^ (~ (n110i14 ^ n110i13))),
		n11ii = ((n01ii ^ n010i) ^ (~ (n11il12 ^ n11il11))),
		n11li = ((n010O ^ n011O) ^ (~ (n11ll10 ^ n11ll9))),
		n11Oi = ((n01iO ^ n01il) ^ (~ (n11Ol8 ^ n11Ol7))),
		nlO00i = (wire_nil0l_o[25] | wire_nil0l_o[17]),
		nlO00l = ((((((((((wire_nil0l_o[28] | wire_nil0l_o[27]) | wire_nil0l_o[26]) | wire_nil0l_o[25]) | wire_nil0l_o[24]) | wire_nil0l_o[11]) | wire_nil0l_o[10]) | wire_nil0l_o[9]) | wire_nil0l_o[8]) | wire_nil0l_o[1]) | wire_nil0l_o[0]),
		nlO00O = ((((((((((wire_nil0l_o[28] | wire_nil0l_o[27]) | wire_nil0l_o[26]) | wire_nil0l_o[24]) | wire_nil0l_o[17]) | wire_nil0l_o[11]) | wire_nil0l_o[10]) | wire_nil0l_o[9]) | wire_nil0l_o[8]) | wire_nil0l_o[1]) | wire_nil0l_o[0]),
		nlO0ii = (wire_nil0l_o[18] | wire_nil0l_o[16]),
		nlO0il = (((((((((wire_nil0l_o[28] | wire_nil0l_o[27]) | wire_nil0l_o[26]) | wire_nil0l_o[24]) | wire_nil0l_o[11]) | wire_nil0l_o[10]) | wire_nil0l_o[9]) | wire_nil0l_o[8]) | wire_nil0l_o[1]) | wire_nil0l_o[0]),
		nlO0iO = (((((((((((((((((wire_nil0l_o[31] | wire_nil0l_o[30]) | wire_nil0l_o[29]) | wire_nil0l_o[23]) | wire_nil0l_o[22]) | wire_nil0l_o[21]) | wire_nil0l_o[20]) | wire_nil0l_o[19]) | wire_nil0l_o[15]) | wire_nil0l_o[14]) | wire_nil0l_o[13]) | wire_nil0l_o[12]) | wire_nil0l_o[7]) | wire_nil0l_o[6]) | wire_nil0l_o[5]) | wire_nil0l_o[4]) | wire_nil0l_o[3]) | wire_nil0l_o[2]),
		nlO0li = (((((((((((wire_nil0l_o[28] | wire_nil0l_o[27]) | wire_nil0l_o[26]) | wire_nil0l_o[24]) | wire_nil0l_o[18]) | wire_nil0l_o[16]) | wire_nil0l_o[11]) | wire_nil0l_o[10]) | wire_nil0l_o[9]) | wire_nil0l_o[8]) | wire_nil0l_o[1]) | wire_nil0l_o[0]),
		nlO0ll = ((((((((((((((((((wire_nil0l_o[31] | wire_nil0l_o[30]) | wire_nil0l_o[29]) | wire_nil0l_o[23]) | wire_nil0l_o[22]) | wire_nil0l_o[21]) | wire_nil0l_o[20]) | wire_nil0l_o[19]) | wire_nil0l_o[17]) | wire_nil0l_o[15]) | wire_nil0l_o[14]) | wire_nil0l_o[13]) | wire_nil0l_o[12]) | wire_nil0l_o[7]) | wire_nil0l_o[6]) | wire_nil0l_o[5]) | wire_nil0l_o[4]) | wire_nil0l_o[3]) | wire_nil0l_o[2]),
		nlOi0l = (n01lO ^ n01ii),
		nlOi0O = ((n01Oi ^ n01il) ^ (~ (nlOiii34 ^ nlOiii33))),
		nlOi1i = (n01li ^ n010l),
		nlOi1l = ((n01ll ^ n010O) ^ (~ (nlOi1O36 ^ nlOi1O35))),
		nlOiiO = (n01Ol ^ n01iO),
		nlOili = ((n01OO ^ n01li) ^ (~ (nlOill32 ^ nlOill31))),
		nlOiOi = ((n001i ^ n01ll) ^ (~ (nlOiOl30 ^ nlOiOl29))),
		nlOl0i = (n001O ^ n01Oi),
		nlOl0l = ((n000i ^ n01Ol) ^ (~ (nlOl0O26 ^ nlOl0O25))),
		nlOl1i = ((n001l ^ n01lO) ^ (~ (nlOl1l28 ^ nlOl1l27))),
		nlOlil = (n000l ^ n01OO),
		nlOliO = (n000O ^ n001i),
		nlOlli = ((n00ii ^ n001l) ^ (~ (nlOlll24 ^ nlOlll23))),
		nlOlOi = ((n00il ^ n001O) ^ (~ (nlOlOl22 ^ nlOlOl21))),
		nlOO0i = ((n000l ^ n000i) ^ (~ (nlOO0l20 ^ nlOO0l19))),
		nlOO1i = (n00iO ^ n000i),
		nlOO1l = (n00li ^ n000l),
		nlOO1O = (n000i ^ n001O),
		nlOOii = ((n000O ^ n000l) ^ (~ (nlOOil18 ^ nlOOil17))),
		nlOOli = (nlOOll ^ n000l),
		nlOOll = (n00ii ^ n000O),
		nlOOlO = ((n001l ^ n001i) ^ (~ (nlOOOi16 ^ nlOOOi15))),
		nlOOOO = (n001O ^ n001l),
		prbs_out = {n011l, n011i, n1OOO, n1OOl, n1OOi, n1OlO, n1Oll, n1Oli, n1OiO, n1Oil, n1Oii, n1O0O, n1O0l, n1O0i, n1O1O, n1O1l, n1O1i, n1lOO, n1lOl, n1lOi};
endmodule //stratixiigx_hssi_tx_prbs_gen
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 120 mux21 122 oper_mux 110 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_enc_chnl_top
	( 
	cascaded_8b10b_en,
	clk,
	d21_5_eq_n,
	d2_2_eq_n,
	disp_out_3b,
	doublewidth,
	dwidth,
	endec,
	enpolinv_tx,
	ge_xaui_sel,
	ib_force_disparity,
	k_det,
	prbs_en,
	pudr,
	r8b10b_enc_ibm_en,
	renbitrev_tx,
	rendec_data_sel_tx,
	renpolinv_tx,
	rensymswap_tx,
	rev_loop_data,
	rev_loopbk,
	rforce_disp,
	rrev_loopbk,
	rst,
	tx_ctl_pre_en,
	tx_ctl_tc,
	tx_ctl_ts,
	tx_data_9_pre_en,
	tx_data_9_tc,
	tx_data_pg,
	tx_data_pre_en,
	tx_data_tc,
	tx_data_ts,
	txd_extend_tc,
	txlp20b) /* synthesis synthesis_clearbox=1 */;
	input   cascaded_8b10b_en;
	input   clk;
	input   d21_5_eq_n;
	input   d2_2_eq_n;
	output   [1:0]  disp_out_3b;
	input   doublewidth;
	input   dwidth;
	input   endec;
	input   enpolinv_tx;
	input   ge_xaui_sel;
	input   ib_force_disparity;
	input   k_det;
	input   prbs_en;
	output   [19:0]  pudr;
	input   r8b10b_enc_ibm_en;
	input   renbitrev_tx;
	input   rendec_data_sel_tx;
	input   renpolinv_tx;
	input   rensymswap_tx;
	input   [19:0]  rev_loop_data;
	input   rev_loopbk;
	input   rforce_disp;
	input   rrev_loopbk;
	input   rst;
	output   [1:0]  tx_ctl_pre_en;
	input   [1:0]  tx_ctl_tc;
	input   tx_ctl_ts;
	output   [1:0]  tx_data_9_pre_en;
	input   [1:0]  tx_data_9_tc;
	input   [19:0]  tx_data_pg;
	output   [15:0]  tx_data_pre_en;
	input   [15:0]  tx_data_tc;
	input   [7:0]  tx_data_ts;
	input   [1:0]  txd_extend_tc;
	output   [19:0]  txlp20b;

	reg	nilO0l49;
	reg	nilO0l50;
	reg	nilO0O47;
	reg	nilO0O48;
	reg	nilOii45;
	reg	nilOii46;
	reg	nilOiO43;
	reg	nilOiO44;
	reg	nilOli41;
	reg	nilOli42;
	reg	nilOll39;
	reg	nilOll40;
	reg	nilOlO37;
	reg	nilOlO38;
	reg	nilOOi35;
	reg	nilOOi36;
	reg	nilOOl33;
	reg	nilOOl34;
	reg	nilOOO31;
	reg	nilOOO32;
	reg	niO00i5;
	reg	niO00i6;
	reg	niO01l7;
	reg	niO01l8;
	reg	niO0ii3;
	reg	niO0ii4;
	reg	niO0iO1;
	reg	niO0iO2;
	reg	niO10i23;
	reg	niO10i24;
	reg	niO10l21;
	reg	niO10l22;
	reg	niO10O19;
	reg	niO10O20;
	reg	niO11i29;
	reg	niO11i30;
	reg	niO11l27;
	reg	niO11l28;
	reg	niO11O25;
	reg	niO11O26;
	reg	niO1ii17;
	reg	niO1ii18;
	reg	niO1il15;
	reg	niO1il16;
	reg	niO1li13;
	reg	niO1li14;
	reg	niO1lO11;
	reg	niO1lO12;
	reg	niO1OO10;
	reg	niO1OO9;
	reg	n00OO;
	reg	n00Ol_clk_prev;
	wire	wire_n00Ol_PRN;
	wire	wire_n00Ol_ENA;
	reg	n0liO;
	reg	n0lli;
	reg	n0lll;
	reg	n0llO;
	reg	n0lOi;
	reg	n0lOO;
	reg	n0O1l;
	reg	n0O1O;
	reg	n0OiO;
	reg	n0Oll;
	reg	nii0i;
	reg	nii0l;
	reg	nii0O;
	reg	nii1l;
	reg	nii1O;
	reg	niiil;
	reg	niili;
	reg	niill;
	reg	nil0O;
	reg	nil1l;
	reg	nil0l_clk_prev;
	wire	wire_nil0l_CLRN;
	wire	wire_nil0l_PRN;
	reg	n00lO;
	reg	n00Oi;
	reg	n0i0i;
	reg	n0i0l;
	reg	n0i0O;
	reg	n0i1l;
	reg	n0i1O;
	reg	n0iii;
	reg	n0iil;
	reg	n0iiO;
	reg	n0ili;
	reg	n0ill;
	reg	n0ilO;
	reg	n0iOi;
	reg	n0iOl;
	reg	n0iOO;
	reg	n0l0i;
	reg	n0l0l;
	reg	n0l0O;
	reg	n0l1i;
	reg	n0l1l;
	reg	n0l1O;
	reg	n0lii;
	reg	n0lil;
	reg	n0lOl;
	reg	n0O0i;
	reg	n0O0l;
	reg	n0O0O;
	reg	n0O1i;
	reg	n0Oii;
	reg	n0Oil;
	reg	n0Oli;
	reg	n0OlO;
	reg	n0OOi;
	reg	n0OOl;
	reg	n0OOO;
	reg	ni0OO;
	reg	ni11i;
	reg	ni11l;
	reg	ni11O;
	reg	nii1i;
	reg	niiii;
	reg	niiiO;
	reg	niilO;
	reg	niiOi;
	reg	niiOl;
	reg	niiOO;
	reg	nil0i;
	reg	nil1i;
	reg	nil1O_clk_prev;
	wire	wire_nil1O_CLRN;
	wire	wire_nil1O_PRN;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0iO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0li_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1li_dataout;
	wire	wire_ni1ll_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1l_dataout;
	wire	wire_nl0ili_dataout;
	wire	wire_nl0ilO_dataout;
	wire	wire_nl0iOi_dataout;
	wire	wire_nl0iOl_dataout;
	wire	wire_nl0iOO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l1i_dataout;
	wire	wire_nl0lii_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl10iO_dataout;
	wire	wire_nl10li_dataout;
	wire	wire_nl10ll_dataout;
	wire	wire_nl10lO_dataout;
	wire	wire_nl10Oi_dataout;
	wire	wire_nl10Ol_dataout;
	wire	wire_nl11iO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlii0i_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0i_dataout;
	wire	wire_nlil0l_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll10l_dataout;
	wire	wire_nll10O_dataout;
	wire	wire_nll1lO_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOil_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nlO11l_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire  wire_n000i_o;
	wire  wire_n000l_o;
	wire  wire_n000O_o;
	wire  wire_n001i_o;
	wire  wire_n001l_o;
	wire  wire_n001O_o;
	wire  wire_n00ii_o;
	wire  wire_n00il_o;
	wire  wire_n00iO_o;
	wire  wire_n00li_o;
	wire  wire_n00ll_o;
	wire  wire_n01ii_o;
	wire  wire_n01il_o;
	wire  wire_n01iO_o;
	wire  wire_n01li_o;
	wire  wire_n01ll_o;
	wire  wire_n01lO_o;
	wire  wire_n01Oi_o;
	wire  wire_n01Ol_o;
	wire  wire_n01OO_o;
	wire  wire_nilii_o;
	wire  wire_nilil_o;
	wire  wire_niliO_o;
	wire  wire_nilli_o;
	wire  wire_nilll_o;
	wire  wire_nillO_o;
	wire  wire_nilOi_o;
	wire  wire_nilOl_o;
	wire  wire_nilOO_o;
	wire  wire_niO0i_o;
	wire  wire_niO0l_o;
	wire  wire_niO0O_o;
	wire  wire_niO1i_o;
	wire  wire_niO1l_o;
	wire  wire_niO1O_o;
	wire  wire_niOii_o;
	wire  wire_niOil_o;
	wire  wire_niOiO_o;
	wire  wire_niOli_o;
	wire  wire_niOll_o;
	wire  wire_niOlO_o;
	wire  wire_niOOi_o;
	wire  wire_niOOl_o;
	wire  wire_niOOO_o;
	wire  wire_nl00i_o;
	wire  wire_nl00l_o;
	wire  wire_nl00O_o;
	wire  wire_nl01i_o;
	wire  wire_nl01l_o;
	wire  wire_nl01O_o;
	wire  wire_nl0ii_o;
	wire  wire_nl0il_o;
	wire  wire_nl0iO_o;
	wire  wire_nl0li_o;
	wire  wire_nl0ll_o;
	wire  wire_nl0lO_o;
	wire  wire_nl0Oi_o;
	wire  wire_nl0Ol_o;
	wire  wire_nl0OO_o;
	wire  wire_nl10i_o;
	wire  wire_nl10l_o;
	wire  wire_nl10O_o;
	wire  wire_nl11i_o;
	wire  wire_nl11l_o;
	wire  wire_nl11O_o;
	wire  wire_nl1ii_o;
	wire  wire_nl1il_o;
	wire  wire_nl1iO_o;
	wire  wire_nl1li_o;
	wire  wire_nl1ll_o;
	wire  wire_nl1lO_o;
	wire  wire_nl1Oi_o;
	wire  wire_nl1Ol_o;
	wire  wire_nl1OO_o;
	wire  wire_nli0i_o;
	wire  wire_nli0l_o;
	wire  wire_nli0O_o;
	wire  wire_nli1i_o;
	wire  wire_nli1l_o;
	wire  wire_nli1O_o;
	wire  wire_nliii_o;
	wire  wire_nliil_o;
	wire  wire_nliiO_o;
	wire  wire_nlili_o;
	wire  wire_nlill_o;
	wire  wire_nlilO_o;
	wire  wire_nliOi_o;
	wire  wire_nliOl_o;
	wire  wire_nliOO_o;
	wire  wire_nll0i_o;
	wire  wire_nll0l_o;
	wire  wire_nll0O_o;
	wire  wire_nll1i_o;
	wire  wire_nll1l_o;
	wire  wire_nll1O_o;
	wire  wire_nllii_o;
	wire  wire_nllil_o;
	wire  wire_nlliO_o;
	wire  wire_nllli_o;
	wire  wire_nllll_o;
	wire  wire_nlllO_o;
	wire  wire_nllOi_o;
	wire  wire_nllOl_o;
	wire  wire_nllOO_o;
	wire  wire_nlO0i_o;
	wire  wire_nlO0l_o;
	wire  wire_nlO0O_o;
	wire  wire_nlO1i_o;
	wire  wire_nlO1l_o;
	wire  wire_nlO1O_o;
	wire  nil00i;
	wire  nil00l;
	wire  nil00O;
	wire  nil01i;
	wire  nil01l;
	wire  nil01O;
	wire  nil0ii;
	wire  nil0il;
	wire  nil0iO;
	wire  nil0li;
	wire  nil0ll;
	wire  nil0lO;
	wire  nil0Oi;
	wire  nil0Ol;
	wire  nil0OO;
	wire  nil1ll;
	wire  nil1lO;
	wire  nil1Oi;
	wire  nil1Ol;
	wire  nil1OO;
	wire  nili0i;
	wire  nili0l;
	wire  nili0O;
	wire  nili1i;
	wire  nili1l;
	wire  nili1O;
	wire  niliii;
	wire  niliil;
	wire  niliiO;
	wire  nilili;
	wire  nilill;
	wire  nililO;
	wire  niliOi;
	wire  niliOl;
	wire  niliOO;
	wire  nill0i;
	wire  nill0l;
	wire  nill0O;
	wire  nill1i;
	wire  nill1l;
	wire  nill1O;
	wire  nillii;
	wire  nillil;
	wire  nilliO;
	wire  nillli;
	wire  nillll;
	wire  nilllO;
	wire  nillOi;
	wire  nillOl;
	wire  nillOO;
	wire  nilO0i;
	wire  nilO1i;
	wire  nilO1l;
	wire  nilO1O;
	wire  nilOil;
	wire  niO00O;
	wire  niO1iO;
	wire  niO1Ol;

	initial
		nilO0l49 = 0;
	always @ ( posedge clk)
		  nilO0l49 <= nilO0l50;
	event nilO0l49_event;
	initial
		#1 ->nilO0l49_event;
	always @(nilO0l49_event)
		nilO0l49 <= {1{1'b1}};
	initial
		nilO0l50 = 0;
	always @ ( posedge clk)
		  nilO0l50 <= nilO0l49;
	initial
		nilO0O47 = 0;
	always @ ( posedge clk)
		  nilO0O47 <= nilO0O48;
	event nilO0O47_event;
	initial
		#1 ->nilO0O47_event;
	always @(nilO0O47_event)
		nilO0O47 <= {1{1'b1}};
	initial
		nilO0O48 = 0;
	always @ ( posedge clk)
		  nilO0O48 <= nilO0O47;
	initial
		nilOii45 = 0;
	always @ ( posedge clk)
		  nilOii45 <= nilOii46;
	event nilOii45_event;
	initial
		#1 ->nilOii45_event;
	always @(nilOii45_event)
		nilOii45 <= {1{1'b1}};
	initial
		nilOii46 = 0;
	always @ ( posedge clk)
		  nilOii46 <= nilOii45;
	initial
		nilOiO43 = 0;
	always @ ( posedge clk)
		  nilOiO43 <= nilOiO44;
	event nilOiO43_event;
	initial
		#1 ->nilOiO43_event;
	always @(nilOiO43_event)
		nilOiO43 <= {1{1'b1}};
	initial
		nilOiO44 = 0;
	always @ ( posedge clk)
		  nilOiO44 <= nilOiO43;
	initial
		nilOli41 = 0;
	always @ ( posedge clk)
		  nilOli41 <= nilOli42;
	event nilOli41_event;
	initial
		#1 ->nilOli41_event;
	always @(nilOli41_event)
		nilOli41 <= {1{1'b1}};
	initial
		nilOli42 = 0;
	always @ ( posedge clk)
		  nilOli42 <= nilOli41;
	initial
		nilOll39 = 0;
	always @ ( posedge clk)
		  nilOll39 <= nilOll40;
	event nilOll39_event;
	initial
		#1 ->nilOll39_event;
	always @(nilOll39_event)
		nilOll39 <= {1{1'b1}};
	initial
		nilOll40 = 0;
	always @ ( posedge clk)
		  nilOll40 <= nilOll39;
	initial
		nilOlO37 = 0;
	always @ ( posedge clk)
		  nilOlO37 <= nilOlO38;
	event nilOlO37_event;
	initial
		#1 ->nilOlO37_event;
	always @(nilOlO37_event)
		nilOlO37 <= {1{1'b1}};
	initial
		nilOlO38 = 0;
	always @ ( posedge clk)
		  nilOlO38 <= nilOlO37;
	initial
		nilOOi35 = 0;
	always @ ( posedge clk)
		  nilOOi35 <= nilOOi36;
	event nilOOi35_event;
	initial
		#1 ->nilOOi35_event;
	always @(nilOOi35_event)
		nilOOi35 <= {1{1'b1}};
	initial
		nilOOi36 = 0;
	always @ ( posedge clk)
		  nilOOi36 <= nilOOi35;
	initial
		nilOOl33 = 0;
	always @ ( posedge clk)
		  nilOOl33 <= nilOOl34;
	event nilOOl33_event;
	initial
		#1 ->nilOOl33_event;
	always @(nilOOl33_event)
		nilOOl33 <= {1{1'b1}};
	initial
		nilOOl34 = 0;
	always @ ( posedge clk)
		  nilOOl34 <= nilOOl33;
	initial
		nilOOO31 = 0;
	always @ ( posedge clk)
		  nilOOO31 <= nilOOO32;
	event nilOOO31_event;
	initial
		#1 ->nilOOO31_event;
	always @(nilOOO31_event)
		nilOOO31 <= {1{1'b1}};
	initial
		nilOOO32 = 0;
	always @ ( posedge clk)
		  nilOOO32 <= nilOOO31;
	initial
		niO00i5 = 0;
	always @ ( posedge clk)
		  niO00i5 <= niO00i6;
	event niO00i5_event;
	initial
		#1 ->niO00i5_event;
	always @(niO00i5_event)
		niO00i5 <= {1{1'b1}};
	initial
		niO00i6 = 0;
	always @ ( posedge clk)
		  niO00i6 <= niO00i5;
	initial
		niO01l7 = 0;
	always @ ( posedge clk)
		  niO01l7 <= niO01l8;
	event niO01l7_event;
	initial
		#1 ->niO01l7_event;
	always @(niO01l7_event)
		niO01l7 <= {1{1'b1}};
	initial
		niO01l8 = 0;
	always @ ( posedge clk)
		  niO01l8 <= niO01l7;
	initial
		niO0ii3 = 0;
	always @ ( posedge clk)
		  niO0ii3 <= niO0ii4;
	event niO0ii3_event;
	initial
		#1 ->niO0ii3_event;
	always @(niO0ii3_event)
		niO0ii3 <= {1{1'b1}};
	initial
		niO0ii4 = 0;
	always @ ( posedge clk)
		  niO0ii4 <= niO0ii3;
	initial
		niO0iO1 = 0;
	always @ ( posedge clk)
		  niO0iO1 <= niO0iO2;
	event niO0iO1_event;
	initial
		#1 ->niO0iO1_event;
	always @(niO0iO1_event)
		niO0iO1 <= {1{1'b1}};
	initial
		niO0iO2 = 0;
	always @ ( posedge clk)
		  niO0iO2 <= niO0iO1;
	initial
		niO10i23 = 0;
	always @ ( posedge clk)
		  niO10i23 <= niO10i24;
	event niO10i23_event;
	initial
		#1 ->niO10i23_event;
	always @(niO10i23_event)
		niO10i23 <= {1{1'b1}};
	initial
		niO10i24 = 0;
	always @ ( posedge clk)
		  niO10i24 <= niO10i23;
	initial
		niO10l21 = 0;
	always @ ( posedge clk)
		  niO10l21 <= niO10l22;
	event niO10l21_event;
	initial
		#1 ->niO10l21_event;
	always @(niO10l21_event)
		niO10l21 <= {1{1'b1}};
	initial
		niO10l22 = 0;
	always @ ( posedge clk)
		  niO10l22 <= niO10l21;
	initial
		niO10O19 = 0;
	always @ ( posedge clk)
		  niO10O19 <= niO10O20;
	event niO10O19_event;
	initial
		#1 ->niO10O19_event;
	always @(niO10O19_event)
		niO10O19 <= {1{1'b1}};
	initial
		niO10O20 = 0;
	always @ ( posedge clk)
		  niO10O20 <= niO10O19;
	initial
		niO11i29 = 0;
	always @ ( posedge clk)
		  niO11i29 <= niO11i30;
	event niO11i29_event;
	initial
		#1 ->niO11i29_event;
	always @(niO11i29_event)
		niO11i29 <= {1{1'b1}};
	initial
		niO11i30 = 0;
	always @ ( posedge clk)
		  niO11i30 <= niO11i29;
	initial
		niO11l27 = 0;
	always @ ( posedge clk)
		  niO11l27 <= niO11l28;
	event niO11l27_event;
	initial
		#1 ->niO11l27_event;
	always @(niO11l27_event)
		niO11l27 <= {1{1'b1}};
	initial
		niO11l28 = 0;
	always @ ( posedge clk)
		  niO11l28 <= niO11l27;
	initial
		niO11O25 = 0;
	always @ ( posedge clk)
		  niO11O25 <= niO11O26;
	event niO11O25_event;
	initial
		#1 ->niO11O25_event;
	always @(niO11O25_event)
		niO11O25 <= {1{1'b1}};
	initial
		niO11O26 = 0;
	always @ ( posedge clk)
		  niO11O26 <= niO11O25;
	initial
		niO1ii17 = 0;
	always @ ( posedge clk)
		  niO1ii17 <= niO1ii18;
	event niO1ii17_event;
	initial
		#1 ->niO1ii17_event;
	always @(niO1ii17_event)
		niO1ii17 <= {1{1'b1}};
	initial
		niO1ii18 = 0;
	always @ ( posedge clk)
		  niO1ii18 <= niO1ii17;
	initial
		niO1il15 = 0;
	always @ ( posedge clk)
		  niO1il15 <= niO1il16;
	event niO1il15_event;
	initial
		#1 ->niO1il15_event;
	always @(niO1il15_event)
		niO1il15 <= {1{1'b1}};
	initial
		niO1il16 = 0;
	always @ ( posedge clk)
		  niO1il16 <= niO1il15;
	initial
		niO1li13 = 0;
	always @ ( posedge clk)
		  niO1li13 <= niO1li14;
	event niO1li13_event;
	initial
		#1 ->niO1li13_event;
	always @(niO1li13_event)
		niO1li13 <= {1{1'b1}};
	initial
		niO1li14 = 0;
	always @ ( posedge clk)
		  niO1li14 <= niO1li13;
	initial
		niO1lO11 = 0;
	always @ ( posedge clk)
		  niO1lO11 <= niO1lO12;
	event niO1lO11_event;
	initial
		#1 ->niO1lO11_event;
	always @(niO1lO11_event)
		niO1lO11 <= {1{1'b1}};
	initial
		niO1lO12 = 0;
	always @ ( posedge clk)
		  niO1lO12 <= niO1lO11;
	initial
		niO1OO10 = 0;
	always @ ( posedge clk)
		  niO1OO10 <= niO1OO9;
	initial
		niO1OO9 = 0;
	always @ ( posedge clk)
		  niO1OO9 <= niO1OO10;
	event niO1OO9_event;
	initial
		#1 ->niO1OO9_event;
	always @(niO1OO9_event)
		niO1OO9 <= {1{1'b1}};
	initial
	begin
		n00OO = 0;
	end
	always @ (clk or wire_n00Ol_PRN or rst)
	begin
		if (wire_n00Ol_PRN == 1'b0) 
		begin
			n00OO <= 1;
		end
		else if  (rst == 1'b1) 
		begin
			n00OO <= 0;
		end
		else if  (wire_n00Ol_ENA == 1'b1) 
		if (clk != n00Ol_clk_prev && clk == 1'b1) 
		begin
			n00OO <= nilOil;
		end
		n00Ol_clk_prev <= clk;
	end
	assign
		wire_n00Ol_ENA = ((ib_force_disparity & tx_data_9_tc[0]) & (~ n00OO)),
		wire_n00Ol_PRN = (nilO0l50 ^ nilO0l49);
	initial
	begin
		n0liO = 0;
		n0lli = 0;
		n0lll = 0;
		n0llO = 0;
		n0lOi = 0;
		n0lOO = 0;
		n0O1l = 0;
		n0O1O = 0;
		n0OiO = 0;
		n0Oll = 0;
		nii0i = 0;
		nii0l = 0;
		nii0O = 0;
		nii1l = 0;
		nii1O = 0;
		niiil = 0;
		niili = 0;
		niill = 0;
		nil0O = 0;
		nil1l = 0;
	end
	always @ (clk or wire_nil0l_PRN or wire_nil0l_CLRN)
	begin
		if (wire_nil0l_PRN == 1'b0) 
		begin
			n0liO <= 1;
			n0lli <= 1;
			n0lll <= 1;
			n0llO <= 1;
			n0lOi <= 1;
			n0lOO <= 1;
			n0O1l <= 1;
			n0O1O <= 1;
			n0OiO <= 1;
			n0Oll <= 1;
			nii0i <= 1;
			nii0l <= 1;
			nii0O <= 1;
			nii1l <= 1;
			nii1O <= 1;
			niiil <= 1;
			niili <= 1;
			niill <= 1;
			nil0O <= 1;
			nil1l <= 1;
		end
		else if  (wire_nil0l_CLRN == 1'b0) 
		begin
			n0liO <= 0;
			n0lli <= 0;
			n0lll <= 0;
			n0llO <= 0;
			n0lOi <= 0;
			n0lOO <= 0;
			n0O1l <= 0;
			n0O1O <= 0;
			n0OiO <= 0;
			n0Oll <= 0;
			nii0i <= 0;
			nii0l <= 0;
			nii0O <= 0;
			nii1l <= 0;
			nii1O <= 0;
			niiil <= 0;
			niili <= 0;
			niill <= 0;
			nil0O <= 0;
			nil1l <= 0;
		end
		else 
		if (clk != nil0l_clk_prev && clk == 1'b1) 
		begin
			n0liO <= nii1l;
			n0lli <= nii1O;
			n0lll <= nii0i;
			n0llO <= nii0l;
			n0lOi <= nii0O;
			n0lOO <= niiil;
			n0O1l <= niili;
			n0O1O <= niill;
			n0OiO <= nil1l;
			n0Oll <= nil0O;
			nii0i <= wire_nilll_o;
			nii0l <= wire_nillO_o;
			nii0O <= wire_nilOi_o;
			nii1l <= wire_niliO_o;
			nii1O <= wire_nilli_o;
			niiil <= wire_nilOO_o;
			niili <= wire_niO1l_o;
			niill <= wire_niO1O_o;
			nil0O <= wire_niOll_o;
			nil1l <= wire_niOiO_o;
		end
		nil0l_clk_prev <= clk;
	end
	assign
		wire_nil0l_CLRN = (nilOli42 ^ nilOli41),
		wire_nil0l_PRN = ((nilOiO44 ^ nilOiO43) & (~ rst));
	initial
	begin
		n00lO = 0;
		n00Oi = 0;
		n0i0i = 0;
		n0i0l = 0;
		n0i0O = 0;
		n0i1l = 0;
		n0i1O = 0;
		n0iii = 0;
		n0iil = 0;
		n0iiO = 0;
		n0ili = 0;
		n0ill = 0;
		n0ilO = 0;
		n0iOi = 0;
		n0iOl = 0;
		n0iOO = 0;
		n0l0i = 0;
		n0l0l = 0;
		n0l0O = 0;
		n0l1i = 0;
		n0l1l = 0;
		n0l1O = 0;
		n0lii = 0;
		n0lil = 0;
		n0lOl = 0;
		n0O0i = 0;
		n0O0l = 0;
		n0O0O = 0;
		n0O1i = 0;
		n0Oii = 0;
		n0Oil = 0;
		n0Oli = 0;
		n0OlO = 0;
		n0OOi = 0;
		n0OOl = 0;
		n0OOO = 0;
		ni0OO = 0;
		ni11i = 0;
		ni11l = 0;
		ni11O = 0;
		nii1i = 0;
		niiii = 0;
		niiiO = 0;
		niilO = 0;
		niiOi = 0;
		niiOl = 0;
		niiOO = 0;
		nil0i = 0;
		nil1i = 0;
	end
	always @ (clk or wire_nil1O_PRN or wire_nil1O_CLRN)
	begin
		if (wire_nil1O_PRN == 1'b0) 
		begin
			n00lO <= 1;
			n00Oi <= 1;
			n0i0i <= 1;
			n0i0l <= 1;
			n0i0O <= 1;
			n0i1l <= 1;
			n0i1O <= 1;
			n0iii <= 1;
			n0iil <= 1;
			n0iiO <= 1;
			n0ili <= 1;
			n0ill <= 1;
			n0ilO <= 1;
			n0iOi <= 1;
			n0iOl <= 1;
			n0iOO <= 1;
			n0l0i <= 1;
			n0l0l <= 1;
			n0l0O <= 1;
			n0l1i <= 1;
			n0l1l <= 1;
			n0l1O <= 1;
			n0lii <= 1;
			n0lil <= 1;
			n0lOl <= 1;
			n0O0i <= 1;
			n0O0l <= 1;
			n0O0O <= 1;
			n0O1i <= 1;
			n0Oii <= 1;
			n0Oil <= 1;
			n0Oli <= 1;
			n0OlO <= 1;
			n0OOi <= 1;
			n0OOl <= 1;
			n0OOO <= 1;
			ni0OO <= 1;
			ni11i <= 1;
			ni11l <= 1;
			ni11O <= 1;
			nii1i <= 1;
			niiii <= 1;
			niiiO <= 1;
			niilO <= 1;
			niiOi <= 1;
			niiOl <= 1;
			niiOO <= 1;
			nil0i <= 1;
			nil1i <= 1;
		end
		else if  (wire_nil1O_CLRN == 1'b0) 
		begin
			n00lO <= 0;
			n00Oi <= 0;
			n0i0i <= 0;
			n0i0l <= 0;
			n0i0O <= 0;
			n0i1l <= 0;
			n0i1O <= 0;
			n0iii <= 0;
			n0iil <= 0;
			n0iiO <= 0;
			n0ili <= 0;
			n0ill <= 0;
			n0ilO <= 0;
			n0iOi <= 0;
			n0iOl <= 0;
			n0iOO <= 0;
			n0l0i <= 0;
			n0l0l <= 0;
			n0l0O <= 0;
			n0l1i <= 0;
			n0l1l <= 0;
			n0l1O <= 0;
			n0lii <= 0;
			n0lil <= 0;
			n0lOl <= 0;
			n0O0i <= 0;
			n0O0l <= 0;
			n0O0O <= 0;
			n0O1i <= 0;
			n0Oii <= 0;
			n0Oil <= 0;
			n0Oli <= 0;
			n0OlO <= 0;
			n0OOi <= 0;
			n0OOl <= 0;
			n0OOO <= 0;
			ni0OO <= 0;
			ni11i <= 0;
			ni11l <= 0;
			ni11O <= 0;
			nii1i <= 0;
			niiii <= 0;
			niiiO <= 0;
			niilO <= 0;
			niiOi <= 0;
			niiOl <= 0;
			niiOO <= 0;
			nil0i <= 0;
			nil1i <= 0;
		end
		else 
		if (clk != nil1O_clk_prev && clk == 1'b1) 
		begin
			n00lO <= rev_loopbk;
			n00Oi <= wire_n0i1i_dataout;
			n0i0i <= tx_ctl_tc[0];
			n0i0l <= tx_ctl_tc[1];
			n0i0O <= tx_data_tc[0];
			n0i1l <= tx_data_9_tc[0];
			n0i1O <= tx_data_9_tc[1];
			n0iii <= tx_data_tc[1];
			n0iil <= tx_data_tc[2];
			n0iiO <= tx_data_tc[3];
			n0ili <= tx_data_tc[4];
			n0ill <= tx_data_tc[5];
			n0ilO <= tx_data_tc[6];
			n0iOi <= tx_data_tc[7];
			n0iOl <= tx_data_tc[8];
			n0iOO <= tx_data_tc[9];
			n0l0i <= tx_data_tc[13];
			n0l0l <= tx_data_tc[14];
			n0l0O <= tx_data_tc[15];
			n0l1i <= tx_data_tc[10];
			n0l1l <= tx_data_tc[11];
			n0l1O <= tx_data_tc[12];
			n0lii <= ni11O;
			n0lil <= nii1i;
			n0lOl <= niiii;
			n0O0i <= niilO;
			n0O0l <= niiOi;
			n0O0O <= niiOl;
			n0O1i <= niiiO;
			n0Oii <= niiOO;
			n0Oil <= nil1i;
			n0Oli <= nil0i;
			n0OlO <= n0OOi;
			n0OOi <= rensymswap_tx;
			n0OOl <= n0OOO;
			n0OOO <= renbitrev_tx;
			ni0OO <= n00lO;
			ni11i <= ni11l;
			ni11l <= (renpolinv_tx & enpolinv_tx);
			ni11O <= wire_nilii_o;
			nii1i <= wire_nilil_o;
			niiii <= wire_nilOl_o;
			niiiO <= wire_niO1i_o;
			niilO <= wire_niO0i_o;
			niiOi <= wire_niO0l_o;
			niiOl <= wire_niO0O_o;
			niiOO <= wire_niOii_o;
			nil0i <= wire_niOli_o;
			nil1i <= wire_niOil_o;
		end
		nil1O_clk_prev <= clk;
	end
	assign
		wire_nil1O_CLRN = ((nilOii46 ^ nilOii45) & (~ rst)),
		wire_nil1O_PRN = (nilO0O48 ^ nilO0O47);
	assign		wire_n00i_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[11] : wire_ni0l_dataout;
	assign		wire_n00l_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[12] : wire_ni0O_dataout;
	assign		wire_n00O_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[13] : wire_niii_dataout;
	assign		wire_n01i_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[8] : wire_ni1l_dataout;
	assign		wire_n01l_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[9] : wire_ni1O_dataout;
	assign		wire_n01O_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[10] : wire_ni0i_dataout;
	assign		wire_n0i1i_dataout = (cascaded_8b10b_en === 1'b1) ? wire_nllllO_dataout : wire_nl0i1l_dataout;
	assign		wire_n0ii_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[14] : wire_niil_dataout;
	assign		wire_n0il_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[15] : wire_niiO_dataout;
	and(wire_n0iO_dataout, wire_nili_dataout, ~(niO1Ol));
	and(wire_n0li_dataout, wire_nill_dataout, ~(niO1Ol));
	and(wire_n0ll_dataout, wire_nilO_dataout, ~(niO1Ol));
	and(wire_n0lO_dataout, wire_niOi_dataout, ~(niO1Ol));
	assign		wire_n0O_dataout = (rendec_data_sel_tx === 1'b1) ? tx_ctl_tc[0] : tx_ctl_ts;
	or(wire_n0Oi_dataout, wire_niOl_dataout, niO1Ol);
	and(wire_n0Ol_dataout, wire_niOO_dataout, ~(niO1Ol));
	or(wire_n0OO_dataout, wire_nl1i_dataout, niO1Ol);
	and(wire_n10i_dataout, tx_data_tc[12], rendec_data_sel_tx);
	and(wire_n10l_dataout, tx_data_tc[13], rendec_data_sel_tx);
	and(wire_n10O_dataout, tx_data_tc[14], rendec_data_sel_tx);
	and(wire_n11i_dataout, tx_data_tc[9], rendec_data_sel_tx);
	and(wire_n11l_dataout, tx_data_tc[10], rendec_data_sel_tx);
	and(wire_n11O_dataout, tx_data_tc[11], rendec_data_sel_tx);
	and(wire_n1ii_dataout, tx_data_tc[15], rendec_data_sel_tx);
	assign		wire_n1il_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[0] : wire_n0iO_dataout;
	assign		wire_n1iO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[1] : wire_n0li_dataout;
	assign		wire_n1li_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[2] : wire_n0ll_dataout;
	assign		wire_n1ll_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[3] : wire_n0lO_dataout;
	assign		wire_n1lO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[4] : wire_n0Oi_dataout;
	assign		wire_n1Oi_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[5] : wire_n0Ol_dataout;
	assign		wire_n1Ol_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[6] : wire_n0OO_dataout;
	assign		wire_n1OO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[7] : wire_ni1i_dataout;
	and(wire_ni00i_dataout, wire_nl0i1l_dataout, ~(((rforce_disp & txd_extend_tc[1]) & tx_data_9_tc[1])));
	or(wire_ni01O_dataout, wire_ni00i_dataout, ((rforce_disp & (~ txd_extend_tc[1])) & tx_data_9_tc[1]));
	and(wire_ni0i_dataout, wire_nl0l_dataout, ~(niO1Ol));
	or(wire_ni0iO_dataout, wire_ni0li_dataout, ((rforce_disp & (~ txd_extend_tc[0])) & tx_data_9_tc[0]));
	and(wire_ni0l_dataout, wire_nl0O_dataout, ~(niO1Ol));
	and(wire_ni0li_dataout, n00Oi, ~(((rforce_disp & txd_extend_tc[0]) & tx_data_9_tc[0])));
	and(wire_ni0O_dataout, wire_nlii_dataout, ~(niO1Ol));
	and(wire_ni1i_dataout, wire_nl1l_dataout, ~(niO1Ol));
	assign		wire_ni1ii_dataout = (cascaded_8b10b_en === 1'b1) ? wire_ni0iO_dataout : wire_ni1iO_dataout;
	assign		wire_ni1il_dataout = (cascaded_8b10b_en === 1'b1) ? wire_ni01O_dataout : wire_nl0i1l_dataout;
	assign		wire_ni1iO_dataout = (ib_force_disparity === 1'b1) ? (((~ n00OO) & tx_data_9_tc[0]) | n00Oi) : wire_ni1li_dataout;
	and(wire_ni1l_dataout, wire_nl1O_dataout, ~(niO1Ol));
	or(wire_ni1li_dataout, wire_ni1ll_dataout, ((rforce_disp & (~ txd_extend_tc[0])) & tx_data_9_tc[0]));
	and(wire_ni1ll_dataout, n00Oi, ~(((rforce_disp & txd_extend_tc[0]) & tx_data_9_tc[0])));
	and(wire_ni1O_dataout, wire_nl0i_dataout, ~(niO1Ol));
	and(wire_nii_dataout, tx_ctl_tc[1], rendec_data_sel_tx);
	and(wire_niii_dataout, wire_nlil_dataout, ~(niO1Ol));
	and(wire_niil_dataout, wire_nliO_dataout, ~(niO1Ol));
	and(wire_niiO_dataout, wire_nlli_dataout, ~(niO1Ol));
	assign		wire_nil_dataout = (cascaded_8b10b_en === 1'b1) ? tx_ctl_tc[0] : wire_nli_dataout;
	or(wire_nili_dataout, wire_nlOii_dataout, niO1iO);
	and(wire_nill_dataout, wire_nlOil_dataout, ~(niO1iO));
	or(wire_nilO_dataout, wire_nlOiO_dataout, niO1iO);
	assign		wire_niO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_ctl_tc[1] : wire_nll_dataout;
	and(wire_niOi_dataout, wire_nlOli_dataout, ~(niO1iO));
	and(wire_niOl_dataout, wire_nlOll_dataout, ~(niO1iO));
	and(wire_niOO_dataout, wire_nlOlO_dataout, ~(niO1iO));
	and(wire_nl0i_dataout, wire_n11i_dataout, ~(niO1iO));
	or(wire_nl0i0l_dataout, wire_nl0i0O_dataout, nili1O);
	and(wire_nl0i0O_dataout, (~ nili0O), ~(wire_n1OO_dataout));
	assign		wire_nl0i1l_dataout = ((nili1i | (wire_n1OO_dataout & nili0O)) === 1'b1) ? (~ wire_nl11iO_dataout) : wire_nl11iO_dataout;
	assign		wire_nl0ili_dataout = (nili1i === 1'b1) ? (~ wire_n1Ol_dataout) : wire_n1Ol_dataout;
	and(wire_nl0ilO_dataout, wire_n1Oi_dataout, ~(nili1O));
	assign		wire_nl0iOi_dataout = (nili0i === 1'b1) ? (~ wire_nl0ilO_dataout) : wire_nl0ilO_dataout;
	assign		wire_nl0iOl_dataout = (nili0i === 1'b1) ? (~ wire_nl0ili_dataout) : wire_nl0ili_dataout;
	assign		wire_nl0iOO_dataout = (nili0i === 1'b1) ? (~ wire_n1OO_dataout) : wire_n1OO_dataout;
	and(wire_nl0l_dataout, wire_n11l_dataout, ~(niO1iO));
	assign		wire_nl0l1i_dataout = (nili0i === 1'b1) ? (~ wire_nl0i0l_dataout) : wire_nl0i0l_dataout;
	assign		wire_nl0lii_dataout = (r8b10b_enc_ibm_en === 1'b1) ? niliii : wire_nil_dataout;
	and(wire_nl0O_dataout, wire_n11O_dataout, ~(niO1iO));
	assign		wire_nl10iO_dataout = (nil1OO === 1'b1) ? (~ wire_n1il_dataout) : wire_n1il_dataout;
	assign		wire_nl10li_dataout = (nil1OO === 1'b1) ? (~ wire_nl1O1l_dataout) : wire_nl1O1l_dataout;
	assign		wire_nl10ll_dataout = (nil1OO === 1'b1) ? (~ wire_nl1lll_dataout) : wire_nl1lll_dataout;
	assign		wire_nl10lO_dataout = (nil1OO === 1'b1) ? (~ wire_nl1lli_dataout) : wire_nl1lli_dataout;
	assign		wire_nl10Oi_dataout = (nil1OO === 1'b1) ? (~ nil00O) : nil00O;
	assign		wire_nl10Ol_dataout = (nil1OO === 1'b1) ? (~ nil01O) : nil01O;
	assign		wire_nl11iO_dataout = (((nil0il | ((wire_nl1O1O_dataout | nil0ll) | nil0li)) | nil01i) === 1'b1) ? (~ wire_ni1ii_dataout) : wire_ni1ii_dataout;
	or(wire_nl1i_dataout, wire_nlOOi_dataout, niO1iO);
	or(wire_nl1l_dataout, wire_nlOOl_dataout, niO1iO);
	assign		wire_nl1lli_dataout = (nil0li === 1'b1) ? (~ wire_n1ll_dataout) : wire_n1ll_dataout;
	assign		wire_nl1lll_dataout = (((wire_n1lO_dataout & (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout))))) | nil0ll) === 1'b1) ? (~ wire_n1li_dataout) : wire_n1li_dataout;
	and(wire_nl1O_dataout, wire_nlOOO_dataout, ~(niO1iO));
	assign		wire_nl1O1l_dataout = (nil0lO === 1'b1) ? (~ wire_n1iO_dataout) : wire_n1iO_dataout;
	assign		wire_nl1O1O_dataout = (r8b10b_enc_ibm_en === 1'b1) ? niliii : wire_nil_dataout;
	and(wire_nli_dataout, wire_n0O_dataout, ~(niO00O));
	and(wire_nlii_dataout, wire_n10i_dataout, ~(niO1iO));
	assign		wire_nlii0i_dataout = (((nill0l | ((wire_nll1Oi_dataout | nillil) | nillii)) | niliOi) === 1'b1) ? (~ wire_ni1il_dataout) : wire_ni1il_dataout;
	and(wire_nlil_dataout, wire_n10l_dataout, ~(niO1iO));
	assign		wire_nlil0i_dataout = (nililO === 1'b1) ? (~ wire_n01i_dataout) : wire_n01i_dataout;
	assign		wire_nlil0l_dataout = (nililO === 1'b1) ? (~ wire_nll1lO_dataout) : wire_nll1lO_dataout;
	assign		wire_nlil0O_dataout = (nililO === 1'b1) ? (~ wire_nll10O_dataout) : wire_nll10O_dataout;
	assign		wire_nlilii_dataout = (nililO === 1'b1) ? (~ wire_nll10l_dataout) : wire_nll10l_dataout;
	assign		wire_nlilil_dataout = (nililO === 1'b1) ? (~ nill1O) : nill1O;
	assign		wire_nliliO_dataout = (nililO === 1'b1) ? (~ niliOO) : niliOO;
	and(wire_nliO_dataout, wire_n10O_dataout, ~(niO1iO));
	and(wire_nll_dataout, wire_nii_dataout, ~(niO00O));
	assign		wire_nll10l_dataout = (nillii === 1'b1) ? (~ wire_n00i_dataout) : wire_n00i_dataout;
	assign		wire_nll10O_dataout = (((wire_n00l_dataout & (wire_n00i_dataout & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout))))) | nillil) === 1'b1) ? (~ wire_n01O_dataout) : wire_n01O_dataout;
	assign		wire_nll1lO_dataout = (nilliO === 1'b1) ? (~ wire_n01l_dataout) : wire_n01l_dataout;
	assign		wire_nll1Oi_dataout = (r8b10b_enc_ibm_en === 1'b1) ? nilO0i : wire_niO_dataout;
	and(wire_nlli_dataout, wire_n1ii_dataout, ~(niO1iO));
	assign		wire_nllllO_dataout = ((nillOi | (wire_n0il_dataout & nilO1O)) === 1'b1) ? (~ wire_nlii0i_dataout) : wire_nlii0i_dataout;
	or(wire_nlllOO_dataout, wire_nllO1i_dataout, nillOO);
	assign		wire_nllO0l_dataout = (nillOi === 1'b1) ? (~ wire_n0ii_dataout) : wire_n0ii_dataout;
	and(wire_nllO1i_dataout, (~ nilO1O), ~(wire_n0il_dataout));
	and(wire_nllOii_dataout, wire_n00O_dataout, ~(nillOO));
	assign		wire_nllOil_dataout = (nilO1i === 1'b1) ? (~ wire_nllOii_dataout) : wire_nllOii_dataout;
	assign		wire_nllOiO_dataout = (nilO1i === 1'b1) ? (~ wire_nllO0l_dataout) : wire_nllO0l_dataout;
	assign		wire_nllOli_dataout = (nilO1i === 1'b1) ? (~ wire_n0il_dataout) : wire_n0il_dataout;
	assign		wire_nllOll_dataout = (nilO1i === 1'b1) ? (~ wire_nlllOO_dataout) : wire_nlllOO_dataout;
	assign		wire_nlO11l_dataout = (r8b10b_enc_ibm_en === 1'b1) ? nilO0i : wire_niO_dataout;
	assign		wire_nlOii_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[0] : tx_data_ts[0];
	assign		wire_nlOil_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[1] : tx_data_ts[1];
	assign		wire_nlOiO_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[2] : tx_data_ts[2];
	assign		wire_nlOli_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[3] : tx_data_ts[3];
	assign		wire_nlOll_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[4] : tx_data_ts[4];
	assign		wire_nlOlO_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[5] : tx_data_ts[5];
	assign		wire_nlOOi_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[6] : tx_data_ts[6];
	assign		wire_nlOOl_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[7] : tx_data_ts[7];
	and(wire_nlOOO_dataout, tx_data_tc[8], rendec_data_sel_tx);
	oper_mux   n000i
	( 
	.data({{4{tx_data_pg[12]}}, rev_loop_data[12], wire_nlil0O_dataout, tx_data_pg[12], wire_nlil0O_dataout, {4{tx_data_pg[12]}}, rev_loop_data[12], tx_data_tc[10], tx_data_pg[12], tx_data_tc[10]}),
	.o(wire_n000i_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n000i.width_data = 16,
		n000i.width_sel = 4;
	oper_mux   n000l
	( 
	.data({{4{tx_data_pg[13]}}, rev_loop_data[13], wire_nlilii_dataout, tx_data_pg[13], wire_nlilii_dataout, {4{tx_data_pg[13]}}, rev_loop_data[13], tx_data_tc[11], tx_data_pg[13], tx_data_tc[11]}),
	.o(wire_n000l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n000l.width_data = 16,
		n000l.width_sel = 4;
	oper_mux   n000O
	( 
	.data({{4{tx_data_pg[14]}}, rev_loop_data[14], wire_nlilil_dataout, tx_data_pg[14], wire_nlilil_dataout, {4{tx_data_pg[14]}}, rev_loop_data[14], tx_data_tc[12], tx_data_pg[14], tx_data_tc[12]}),
	.o(wire_n000O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n000O.width_data = 16,
		n000O.width_sel = 4;
	oper_mux   n001i
	( 
	.data({{4{tx_data_pg[9]}}, rev_loop_data[9], wire_nl0l1i_dataout, tx_data_pg[9], wire_nl0l1i_dataout, {4{tx_data_pg[9]}}, rev_loop_data[9], tx_data_9_tc[0], tx_data_pg[9], tx_data_9_tc[0]}),
	.o(wire_n001i_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n001i.width_data = 16,
		n001i.width_sel = 4;
	oper_mux   n001l
	( 
	.data({{4{tx_data_pg[10]}}, rev_loop_data[10], wire_nlil0i_dataout, tx_data_pg[10], wire_nlil0i_dataout, {4{tx_data_pg[10]}}, rev_loop_data[10], tx_data_tc[8], tx_data_pg[10], tx_data_tc[8]}),
	.o(wire_n001l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n001l.width_data = 16,
		n001l.width_sel = 4;
	oper_mux   n001O
	( 
	.data({{4{tx_data_pg[11]}}, rev_loop_data[11], wire_nlil0l_dataout, tx_data_pg[11], wire_nlil0l_dataout, {4{tx_data_pg[11]}}, rev_loop_data[11], tx_data_tc[9], tx_data_pg[11], tx_data_tc[9]}),
	.o(wire_n001O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n001O.width_data = 16,
		n001O.width_sel = 4;
	oper_mux   n00ii
	( 
	.data({{4{tx_data_pg[15]}}, rev_loop_data[15], wire_nliliO_dataout, tx_data_pg[15], wire_nliliO_dataout, {4{tx_data_pg[15]}}, rev_loop_data[15], tx_data_tc[13], tx_data_pg[15], tx_data_tc[13]}),
	.o(wire_n00ii_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n00ii.width_data = 16,
		n00ii.width_sel = 4;
	oper_mux   n00il
	( 
	.data({{4{tx_data_pg[16]}}, rev_loop_data[16], wire_nllOil_dataout, tx_data_pg[16], wire_nllOil_dataout, {4{tx_data_pg[16]}}, rev_loop_data[16], tx_data_tc[14], tx_data_pg[16], tx_data_tc[14]}),
	.o(wire_n00il_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n00il.width_data = 16,
		n00il.width_sel = 4;
	oper_mux   n00iO
	( 
	.data({{4{tx_data_pg[17]}}, rev_loop_data[17], wire_nllOiO_dataout, tx_data_pg[17], wire_nllOiO_dataout, {4{tx_data_pg[17]}}, rev_loop_data[17], tx_data_tc[15], tx_data_pg[17], tx_data_tc[15]}),
	.o(wire_n00iO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n00iO.width_data = 16,
		n00iO.width_sel = 4;
	oper_mux   n00li
	( 
	.data({{4{tx_data_pg[18]}}, rev_loop_data[18], wire_nllOli_dataout, tx_data_pg[18], wire_nllOli_dataout, {4{tx_data_pg[18]}}, rev_loop_data[18], tx_ctl_tc[1], tx_data_pg[18], tx_ctl_tc[1]}),
	.o(wire_n00li_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n00li.width_data = 16,
		n00li.width_sel = 4;
	oper_mux   n00ll
	( 
	.data({{4{tx_data_pg[19]}}, rev_loop_data[19], wire_nllOll_dataout, tx_data_pg[19], wire_nllOll_dataout, {4{tx_data_pg[19]}}, rev_loop_data[19], tx_data_9_tc[1], tx_data_pg[19], tx_data_9_tc[1]}),
	.o(wire_n00ll_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n00ll.width_data = 16,
		n00ll.width_sel = 4;
	oper_mux   n01ii
	( 
	.data({{4{tx_data_pg[0]}}, rev_loop_data[0], wire_nl10iO_dataout, tx_data_pg[0], wire_nl10iO_dataout, {4{tx_data_pg[0]}}, rev_loop_data[0], tx_data_tc[0], tx_data_pg[0], tx_data_tc[0]}),
	.o(wire_n01ii_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01ii.width_data = 16,
		n01ii.width_sel = 4;
	oper_mux   n01il
	( 
	.data({{4{tx_data_pg[1]}}, rev_loop_data[1], wire_nl10li_dataout, tx_data_pg[1], wire_nl10li_dataout, {4{tx_data_pg[1]}}, rev_loop_data[1], tx_data_tc[1], tx_data_pg[1], tx_data_tc[1]}),
	.o(wire_n01il_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01il.width_data = 16,
		n01il.width_sel = 4;
	oper_mux   n01iO
	( 
	.data({{4{tx_data_pg[2]}}, rev_loop_data[2], wire_nl10ll_dataout, tx_data_pg[2], wire_nl10ll_dataout, {4{tx_data_pg[2]}}, rev_loop_data[2], tx_data_tc[2], tx_data_pg[2], tx_data_tc[2]}),
	.o(wire_n01iO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01iO.width_data = 16,
		n01iO.width_sel = 4;
	oper_mux   n01li
	( 
	.data({{4{tx_data_pg[3]}}, rev_loop_data[3], wire_nl10lO_dataout, tx_data_pg[3], wire_nl10lO_dataout, {4{tx_data_pg[3]}}, rev_loop_data[3], tx_data_tc[3], tx_data_pg[3], tx_data_tc[3]}),
	.o(wire_n01li_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01li.width_data = 16,
		n01li.width_sel = 4;
	oper_mux   n01ll
	( 
	.data({{4{tx_data_pg[4]}}, rev_loop_data[4], wire_nl10Oi_dataout, tx_data_pg[4], wire_nl10Oi_dataout, {4{tx_data_pg[4]}}, rev_loop_data[4], tx_data_tc[4], tx_data_pg[4], tx_data_tc[4]}),
	.o(wire_n01ll_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01ll.width_data = 16,
		n01ll.width_sel = 4;
	oper_mux   n01lO
	( 
	.data({{4{tx_data_pg[5]}}, rev_loop_data[5], wire_nl10Ol_dataout, tx_data_pg[5], wire_nl10Ol_dataout, {4{tx_data_pg[5]}}, rev_loop_data[5], tx_data_tc[5], tx_data_pg[5], tx_data_tc[5]}),
	.o(wire_n01lO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01lO.width_data = 16,
		n01lO.width_sel = 4;
	oper_mux   n01Oi
	( 
	.data({{4{tx_data_pg[6]}}, rev_loop_data[6], wire_nl0iOi_dataout, tx_data_pg[6], wire_nl0iOi_dataout, {4{tx_data_pg[6]}}, rev_loop_data[6], tx_data_tc[6], tx_data_pg[6], tx_data_tc[6]}),
	.o(wire_n01Oi_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01Oi.width_data = 16,
		n01Oi.width_sel = 4;
	oper_mux   n01Ol
	( 
	.data({{4{tx_data_pg[7]}}, rev_loop_data[7], wire_nl0iOl_dataout, tx_data_pg[7], wire_nl0iOl_dataout, {4{tx_data_pg[7]}}, rev_loop_data[7], tx_data_tc[7], tx_data_pg[7], tx_data_tc[7]}),
	.o(wire_n01Ol_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01Ol.width_data = 16,
		n01Ol.width_sel = 4;
	oper_mux   n01OO
	( 
	.data({{4{tx_data_pg[8]}}, rev_loop_data[8], wire_nl0iOO_dataout, tx_data_pg[8], wire_nl0iOO_dataout, {4{tx_data_pg[8]}}, rev_loop_data[8], tx_ctl_tc[1], tx_data_pg[8], tx_ctl_tc[0]}),
	.o(wire_n01OO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni0OO}));
	defparam
		n01OO.width_data = 16,
		n01OO.width_sel = 4;
	oper_mux   nilii
	( 
	.data({wire_niOlO_o, wire_nl01l_o, wire_nliii_o, wire_nlllO_o}),
	.o(wire_nilii_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilii.width_data = 4,
		nilii.width_sel = 2;
	oper_mux   nilil
	( 
	.data({wire_niOOi_o, wire_nl01O_o, wire_nliil_o, wire_nllOi_o}),
	.o(wire_nilil_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilil.width_data = 4,
		nilil.width_sel = 2;
	oper_mux   niliO
	( 
	.data({wire_niOOl_o, wire_nl00i_o, wire_nliiO_o, wire_nllOl_o}),
	.o(wire_niliO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niliO.width_data = 4,
		niliO.width_sel = 2;
	oper_mux   nilli
	( 
	.data({wire_niOOO_o, wire_nl00l_o, wire_nlili_o, wire_nllOO_o}),
	.o(wire_nilli_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilli.width_data = 4,
		nilli.width_sel = 2;
	oper_mux   nilll
	( 
	.data({wire_nl11i_o, wire_nl00O_o, wire_nlill_o, wire_nlO1i_o}),
	.o(wire_nilll_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilll.width_data = 4,
		nilll.width_sel = 2;
	oper_mux   nillO
	( 
	.data({wire_nl11l_o, wire_nl0ii_o, wire_nlilO_o, wire_nlO1l_o}),
	.o(wire_nillO_o),
	.sel({doublewidth, dwidth}));
	defparam
		nillO.width_data = 4,
		nillO.width_sel = 2;
	oper_mux   nilOi
	( 
	.data({wire_nl11O_o, wire_nl0il_o, wire_nliOi_o, wire_nlO1O_o}),
	.o(wire_nilOi_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOi.width_data = 4,
		nilOi.width_sel = 2;
	oper_mux   nilOl
	( 
	.data({wire_nl10i_o, wire_nl0iO_o, wire_nliOl_o, wire_nlO0i_o}),
	.o(wire_nilOl_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOl.width_data = 4,
		nilOl.width_sel = 2;
	oper_mux   nilOO
	( 
	.data({wire_nl10l_o, wire_nl0li_o, wire_nliOO_o, wire_nlO0l_o}),
	.o(wire_nilOO_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOO.width_data = 4,
		nilOO.width_sel = 2;
	oper_mux   niO0i
	( 
	.data({wire_nl1iO_o, wire_nl0Ol_o, {2{wire_nll0i_o}}}),
	.o(wire_niO0i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0i.width_data = 4,
		niO0i.width_sel = 2;
	oper_mux   niO0l
	( 
	.data({wire_nl1li_o, wire_nl0OO_o, {2{wire_nll0l_o}}}),
	.o(wire_niO0l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0l.width_data = 4,
		niO0l.width_sel = 2;
	oper_mux   niO0O
	( 
	.data({wire_nl1ll_o, wire_nli1i_o, {2{wire_nll0O_o}}}),
	.o(wire_niO0O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0O.width_data = 4,
		niO0O.width_sel = 2;
	oper_mux   niO1i
	( 
	.data({wire_nl10O_o, wire_nl0ll_o, wire_nll1i_o, wire_nlO0O_o}),
	.o(wire_niO1i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1i.width_data = 4,
		niO1i.width_sel = 2;
	oper_mux   niO1l
	( 
	.data({wire_nl1ii_o, wire_nl0lO_o, {2{wire_nll1l_o}}}),
	.o(wire_niO1l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1l.width_data = 4,
		niO1l.width_sel = 2;
	oper_mux   niO1O
	( 
	.data({wire_nl1il_o, wire_nl0Oi_o, {2{wire_nll1O_o}}}),
	.o(wire_niO1O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1O.width_data = 4,
		niO1O.width_sel = 2;
	oper_mux   niOii
	( 
	.data({wire_nl1lO_o, wire_nli1l_o, {2{wire_nllii_o}}}),
	.o(wire_niOii_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOii.width_data = 4,
		niOii.width_sel = 2;
	oper_mux   niOil
	( 
	.data({wire_nl1Oi_o, wire_nli1O_o, {2{wire_nllil_o}}}),
	.o(wire_niOil_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOil.width_data = 4,
		niOil.width_sel = 2;
	oper_mux   niOiO
	( 
	.data({wire_nl1Ol_o, wire_nli0i_o, {2{wire_nlliO_o}}}),
	.o(wire_niOiO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOiO.width_data = 4,
		niOiO.width_sel = 2;
	oper_mux   niOli
	( 
	.data({wire_nl1OO_o, wire_nli0l_o, {2{wire_nllli_o}}}),
	.o(wire_niOli_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOli.width_data = 4,
		niOli.width_sel = 2;
	oper_mux   niOll
	( 
	.data({wire_nl01i_o, wire_nli0O_o, {2{wire_nllll_o}}}),
	.o(wire_niOll_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOll.width_data = 4,
		niOll.width_sel = 2;
	oper_mux   niOlO
	( 
	.data({(~ wire_n001i_o), (~ wire_n00ll_o), (~ wire_n001l_o), (~ wire_n01ii_o), wire_n001i_o, wire_n00ll_o, wire_n001l_o, wire_n01ii_o}),
	.o(wire_niOlO_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		niOlO.width_data = 8,
		niOlO.width_sel = 3;
	oper_mux   niOOi
	( 
	.data({(~ wire_n01OO_o), (~ wire_n00li_o), (~ wire_n001O_o), (~ wire_n01il_o), wire_n01OO_o, wire_n00li_o, wire_n001O_o, wire_n01il_o}),
	.o(wire_niOOi_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		niOOi.width_data = 8,
		niOOi.width_sel = 3;
	oper_mux   niOOl
	( 
	.data({(~ wire_n01Ol_o), (~ wire_n00iO_o), (~ wire_n000i_o), (~ wire_n01iO_o), wire_n01Ol_o, wire_n00iO_o, wire_n000i_o, wire_n01iO_o}),
	.o(wire_niOOl_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		niOOl.width_data = 8,
		niOOl.width_sel = 3;
	oper_mux   niOOO
	( 
	.data({(~ wire_n01Oi_o), (~ wire_n00il_o), (~ wire_n000l_o), (~ wire_n01li_o), wire_n01Oi_o, wire_n00il_o, wire_n000l_o, wire_n01li_o}),
	.o(wire_niOOO_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		niOOO.width_data = 8,
		niOOO.width_sel = 3;
	oper_mux   nl00i
	( 
	.data({(~ wire_n01lO_o), (~ wire_n00ii_o), (~ wire_n000i_o), (~ wire_n01iO_o), wire_n01lO_o, wire_n00ii_o, wire_n000i_o, wire_n01iO_o}),
	.o(wire_nl00i_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl00i.width_data = 8,
		nl00i.width_sel = 3;
	oper_mux   nl00l
	( 
	.data({(~ wire_n01ll_o), (~ wire_n000O_o), (~ wire_n000l_o), (~ wire_n01li_o), wire_n01ll_o, wire_n000O_o, wire_n000l_o, wire_n01li_o}),
	.o(wire_nl00l_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl00l.width_data = 8,
		nl00l.width_sel = 3;
	oper_mux   nl00O
	( 
	.data({(~ wire_n01li_o), (~ wire_n000l_o), (~ wire_n000O_o), (~ wire_n01ll_o), wire_n01li_o, wire_n000l_o, wire_n000O_o, wire_n01ll_o}),
	.o(wire_nl00O_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl00O.width_data = 8,
		nl00O.width_sel = 3;
	oper_mux   nl01i
	( 
	.data({(~ wire_n001l_o), (~ wire_n01ii_o), (~ wire_n001i_o), (~ wire_n00ll_o), wire_n001l_o, wire_n01ii_o, wire_n001i_o, wire_n00ll_o}),
	.o(wire_nl01i_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl01i.width_data = 8,
		nl01i.width_sel = 3;
	oper_mux   nl01l
	( 
	.data({(~ wire_n01Ol_o), (~ wire_n00iO_o), (~ wire_n001l_o), (~ wire_n01ii_o), wire_n01Ol_o, wire_n00iO_o, wire_n001l_o, wire_n01ii_o}),
	.o(wire_nl01l_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl01l.width_data = 8,
		nl01l.width_sel = 3;
	oper_mux   nl01O
	( 
	.data({(~ wire_n01Oi_o), (~ wire_n00il_o), (~ wire_n001O_o), (~ wire_n01il_o), wire_n01Oi_o, wire_n00il_o, wire_n001O_o, wire_n01il_o}),
	.o(wire_nl01O_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl01O.width_data = 8,
		nl01O.width_sel = 3;
	oper_mux   nl0ii
	( 
	.data({(~ wire_n01iO_o), (~ wire_n000i_o), (~ wire_n00ii_o), (~ wire_n01lO_o), wire_n01iO_o, wire_n000i_o, wire_n00ii_o, wire_n01lO_o}),
	.o(wire_nl0ii_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0ii.width_data = 8,
		nl0ii.width_sel = 3;
	oper_mux   nl0il
	( 
	.data({(~ wire_n01il_o), (~ wire_n001O_o), (~ wire_n00il_o), (~ wire_n01Oi_o), wire_n01il_o, wire_n001O_o, wire_n00il_o, wire_n01Oi_o}),
	.o(wire_nl0il_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0il.width_data = 8,
		nl0il.width_sel = 3;
	oper_mux   nl0iO
	( 
	.data({(~ wire_n01ii_o), (~ wire_n001l_o), (~ wire_n00iO_o), (~ wire_n01Ol_o), wire_n01ii_o, wire_n001l_o, wire_n00iO_o, wire_n01Ol_o}),
	.o(wire_nl0iO_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0iO.width_data = 8,
		nl0iO.width_sel = 3;
	oper_mux   nl0li
	( 
	.data({{4{(~ wire_n01OO_o)}}, {4{wire_n01OO_o}}}),
	.o(wire_nl0li_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0li.width_data = 8,
		nl0li.width_sel = 3;
	oper_mux   nl0ll
	( 
	.data({{4{(~ wire_n001i_o)}}, {4{wire_n001i_o}}}),
	.o(wire_nl0ll_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0ll.width_data = 8,
		nl0ll.width_sel = 3;
	oper_mux   nl0lO
	( 
	.data({(~ wire_n00iO_o), (~ wire_n01Ol_o), (~ wire_n01ii_o), (~ wire_n001l_o), wire_n00iO_o, wire_n01Ol_o, wire_n01ii_o, wire_n001l_o}),
	.o(wire_nl0lO_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0lO.width_data = 8,
		nl0lO.width_sel = 3;
	oper_mux   nl0Oi
	( 
	.data({(~ wire_n00il_o), (~ wire_n01Oi_o), (~ wire_n01il_o), (~ wire_n001O_o), wire_n00il_o, wire_n01Oi_o, wire_n01il_o, wire_n001O_o}),
	.o(wire_nl0Oi_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0Oi.width_data = 8,
		nl0Oi.width_sel = 3;
	oper_mux   nl0Ol
	( 
	.data({(~ wire_n00ii_o), (~ wire_n01lO_o), (~ wire_n01iO_o), (~ wire_n000i_o), wire_n00ii_o, wire_n01lO_o, wire_n01iO_o, wire_n000i_o}),
	.o(wire_nl0Ol_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0Ol.width_data = 8,
		nl0Ol.width_sel = 3;
	oper_mux   nl0OO
	( 
	.data({(~ wire_n000O_o), (~ wire_n01ll_o), (~ wire_n01li_o), (~ wire_n000l_o), wire_n000O_o, wire_n01ll_o, wire_n01li_o, wire_n000l_o}),
	.o(wire_nl0OO_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl0OO.width_data = 8,
		nl0OO.width_sel = 3;
	oper_mux   nl10i
	( 
	.data({(~ wire_n01iO_o), (~ wire_n000i_o), (~ wire_n00iO_o), (~ wire_n01Ol_o), wire_n01iO_o, wire_n000i_o, wire_n00iO_o, wire_n01Ol_o}),
	.o(wire_nl10i_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl10i.width_data = 8,
		nl10i.width_sel = 3;
	oper_mux   nl10l
	( 
	.data({(~ wire_n01il_o), (~ wire_n001O_o), (~ wire_n00li_o), (~ wire_n01OO_o), wire_n01il_o, wire_n001O_o, wire_n00li_o, wire_n01OO_o}),
	.o(wire_nl10l_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl10l.width_data = 8,
		nl10l.width_sel = 3;
	oper_mux   nl10O
	( 
	.data({(~ wire_n01ii_o), (~ wire_n001l_o), (~ wire_n00ll_o), (~ wire_n001i_o), wire_n01ii_o, wire_n001l_o, wire_n00ll_o, wire_n001i_o}),
	.o(wire_nl10O_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl10O.width_data = 8,
		nl10O.width_sel = 3;
	oper_mux   nl11i
	( 
	.data({(~ wire_n01lO_o), (~ wire_n00ii_o), (~ wire_n000O_o), (~ wire_n01ll_o), wire_n01lO_o, wire_n00ii_o, wire_n000O_o, wire_n01ll_o}),
	.o(wire_nl11i_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl11i.width_data = 8,
		nl11i.width_sel = 3;
	oper_mux   nl11l
	( 
	.data({(~ wire_n01ll_o), (~ wire_n000O_o), (~ wire_n00ii_o), (~ wire_n01lO_o), wire_n01ll_o, wire_n000O_o, wire_n00ii_o, wire_n01lO_o}),
	.o(wire_nl11l_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl11l.width_data = 8,
		nl11l.width_sel = 3;
	oper_mux   nl11O
	( 
	.data({(~ wire_n01li_o), (~ wire_n000l_o), (~ wire_n00il_o), (~ wire_n01Oi_o), wire_n01li_o, wire_n000l_o, wire_n00il_o, wire_n01Oi_o}),
	.o(wire_nl11O_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl11O.width_data = 8,
		nl11O.width_sel = 3;
	oper_mux   nl1ii
	( 
	.data({(~ wire_n00ll_o), (~ wire_n001i_o), (~ wire_n01ii_o), (~ wire_n001l_o), wire_n00ll_o, wire_n001i_o, wire_n01ii_o, wire_n001l_o}),
	.o(wire_nl1ii_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1ii.width_data = 8,
		nl1ii.width_sel = 3;
	oper_mux   nl1il
	( 
	.data({(~ wire_n00li_o), (~ wire_n01OO_o), (~ wire_n01il_o), (~ wire_n001O_o), wire_n00li_o, wire_n01OO_o, wire_n01il_o, wire_n001O_o}),
	.o(wire_nl1il_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1il.width_data = 8,
		nl1il.width_sel = 3;
	oper_mux   nl1iO
	( 
	.data({(~ wire_n00iO_o), (~ wire_n01Ol_o), (~ wire_n01iO_o), (~ wire_n000i_o), wire_n00iO_o, wire_n01Ol_o, wire_n01iO_o, wire_n000i_o}),
	.o(wire_nl1iO_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1iO.width_data = 8,
		nl1iO.width_sel = 3;
	oper_mux   nl1li
	( 
	.data({(~ wire_n00il_o), (~ wire_n01Oi_o), (~ wire_n01li_o), (~ wire_n000l_o), wire_n00il_o, wire_n01Oi_o, wire_n01li_o, wire_n000l_o}),
	.o(wire_nl1li_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1li.width_data = 8,
		nl1li.width_sel = 3;
	oper_mux   nl1ll
	( 
	.data({(~ wire_n00ii_o), (~ wire_n01lO_o), (~ wire_n01ll_o), (~ wire_n000O_o), wire_n00ii_o, wire_n01lO_o, wire_n01ll_o, wire_n000O_o}),
	.o(wire_nl1ll_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1ll.width_data = 8,
		nl1ll.width_sel = 3;
	oper_mux   nl1lO
	( 
	.data({(~ wire_n000O_o), (~ wire_n01ll_o), (~ wire_n01lO_o), (~ wire_n00ii_o), wire_n000O_o, wire_n01ll_o, wire_n01lO_o, wire_n00ii_o}),
	.o(wire_nl1lO_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1lO.width_data = 8,
		nl1lO.width_sel = 3;
	oper_mux   nl1Oi
	( 
	.data({(~ wire_n000l_o), (~ wire_n01li_o), (~ wire_n01Oi_o), (~ wire_n00il_o), wire_n000l_o, wire_n01li_o, wire_n01Oi_o, wire_n00il_o}),
	.o(wire_nl1Oi_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1Oi.width_data = 8,
		nl1Oi.width_sel = 3;
	oper_mux   nl1Ol
	( 
	.data({(~ wire_n000i_o), (~ wire_n01iO_o), (~ wire_n01Ol_o), (~ wire_n00iO_o), wire_n000i_o, wire_n01iO_o, wire_n01Ol_o, wire_n00iO_o}),
	.o(wire_nl1Ol_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1Ol.width_data = 8,
		nl1Ol.width_sel = 3;
	oper_mux   nl1OO
	( 
	.data({(~ wire_n001O_o), (~ wire_n01il_o), (~ wire_n01OO_o), (~ wire_n00li_o), wire_n001O_o, wire_n01il_o, wire_n01OO_o, wire_n00li_o}),
	.o(wire_nl1OO_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nl1OO.width_data = 8,
		nl1OO.width_sel = 3;
	oper_mux   nli0i
	( 
	.data({(~ wire_n001l_o), (~ wire_n01ii_o), (~ wire_n01Ol_o), (~ wire_n00iO_o), wire_n001l_o, wire_n01ii_o, wire_n01Ol_o, wire_n00iO_o}),
	.o(wire_nli0i_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nli0i.width_data = 8,
		nli0i.width_sel = 3;
	oper_mux   nli0l
	( 
	.data({{4{(~ wire_n00li_o)}}, {4{wire_n00li_o}}}),
	.o(wire_nli0l_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nli0l.width_data = 8,
		nli0l.width_sel = 3;
	oper_mux   nli0O
	( 
	.data({{4{(~ wire_n00ll_o)}}, {4{wire_n00ll_o}}}),
	.o(wire_nli0O_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nli0O.width_data = 8,
		nli0O.width_sel = 3;
	oper_mux   nli1i
	( 
	.data({(~ wire_n000l_o), (~ wire_n01li_o), (~ wire_n01ll_o), (~ wire_n000O_o), wire_n000l_o, wire_n01li_o, wire_n01ll_o, wire_n000O_o}),
	.o(wire_nli1i_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nli1i.width_data = 8,
		nli1i.width_sel = 3;
	oper_mux   nli1l
	( 
	.data({(~ wire_n000i_o), (~ wire_n01iO_o), (~ wire_n01lO_o), (~ wire_n00ii_o), wire_n000i_o, wire_n01iO_o, wire_n01lO_o, wire_n00ii_o}),
	.o(wire_nli1l_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nli1l.width_data = 8,
		nli1l.width_sel = 3;
	oper_mux   nli1O
	( 
	.data({(~ wire_n001O_o), (~ wire_n01il_o), (~ wire_n01Oi_o), (~ wire_n00il_o), wire_n001O_o, wire_n01il_o, wire_n01Oi_o, wire_n00il_o}),
	.o(wire_nli1O_o),
	.sel({ni11i, n0OOl, n0OlO}));
	defparam
		nli1O.width_data = 8,
		nli1O.width_sel = 3;
	oper_mux   nliii
	( 
	.data({(~ wire_n001i_o), (~ wire_n01ii_o), wire_n001i_o, wire_n01ii_o}),
	.o(wire_nliii_o),
	.sel({ni11i, n0OOl}));
	defparam
		nliii.width_data = 4,
		nliii.width_sel = 2;
	oper_mux   nliil
	( 
	.data({(~ wire_n01OO_o), (~ wire_n01il_o), wire_n01OO_o, wire_n01il_o}),
	.o(wire_nliil_o),
	.sel({ni11i, n0OOl}));
	defparam
		nliil.width_data = 4,
		nliil.width_sel = 2;
	oper_mux   nliiO
	( 
	.data({(~ wire_n01Ol_o), (~ wire_n01iO_o), wire_n01Ol_o, wire_n01iO_o}),
	.o(wire_nliiO_o),
	.sel({ni11i, n0OOl}));
	defparam
		nliiO.width_data = 4,
		nliiO.width_sel = 2;
	oper_mux   nlili
	( 
	.data({(~ wire_n01Oi_o), (~ wire_n01li_o), wire_n01Oi_o, wire_n01li_o}),
	.o(wire_nlili_o),
	.sel({ni11i, n0OOl}));
	defparam
		nlili.width_data = 4,
		nlili.width_sel = 2;
	oper_mux   nlill
	( 
	.data({(~ wire_n01lO_o), (~ wire_n01ll_o), wire_n01lO_o, wire_n01ll_o}),
	.o(wire_nlill_o),
	.sel({ni11i, n0OOl}));
	defparam
		nlill.width_data = 4,
		nlill.width_sel = 2;
	oper_mux   nlilO
	( 
	.data({(~ wire_n01ll_o), (~ wire_n01lO_o), wire_n01ll_o, wire_n01lO_o}),
	.o(wire_nlilO_o),
	.sel({ni11i, n0OOl}));
	defparam
		nlilO.width_data = 4,
		nlilO.width_sel = 2;
	oper_mux   nliOi
	( 
	.data({(~ wire_n01li_o), (~ wire_n01Oi_o), wire_n01li_o, wire_n01Oi_o}),
	.o(wire_nliOi_o),
	.sel({ni11i, n0OOl}));
	defparam
		nliOi.width_data = 4,
		nliOi.width_sel = 2;
	oper_mux   nliOl
	( 
	.data({(~ wire_n01iO_o), (~ wire_n01Ol_o), wire_n01iO_o, wire_n01Ol_o}),
	.o(wire_nliOl_o),
	.sel({ni11i, n0OOl}));
	defparam
		nliOl.width_data = 4,
		nliOl.width_sel = 2;
	oper_mux   nliOO
	( 
	.data({(~ wire_n01il_o), (~ wire_n01OO_o), wire_n01il_o, wire_n01OO_o}),
	.o(wire_nliOO_o),
	.sel({ni11i, n0OOl}));
	defparam
		nliOO.width_data = 4,
		nliOO.width_sel = 2;
	oper_mux   nll0i
	( 
	.data({{2{(~ wire_n000i_o)}}, {2{wire_n000i_o}}}),
	.o(wire_nll0i_o),
	.sel({ni11i, n0OOl}));
	defparam
		nll0i.width_data = 4,
		nll0i.width_sel = 2;
	oper_mux   nll0l
	( 
	.data({{2{(~ wire_n000l_o)}}, {2{wire_n000l_o}}}),
	.o(wire_nll0l_o),
	.sel({ni11i, n0OOl}));
	defparam
		nll0l.width_data = 4,
		nll0l.width_sel = 2;
	oper_mux   nll0O
	( 
	.data({{2{(~ wire_n000O_o)}}, {2{wire_n000O_o}}}),
	.o(wire_nll0O_o),
	.sel({ni11i, n0OOl}));
	defparam
		nll0O.width_data = 4,
		nll0O.width_sel = 2;
	oper_mux   nll1i
	( 
	.data({(~ wire_n01ii_o), (~ wire_n001i_o), wire_n01ii_o, wire_n001i_o}),
	.o(wire_nll1i_o),
	.sel({ni11i, n0OOl}));
	defparam
		nll1i.width_data = 4,
		nll1i.width_sel = 2;
	oper_mux   nll1l
	( 
	.data({{2{(~ wire_n001l_o)}}, {2{wire_n001l_o}}}),
	.o(wire_nll1l_o),
	.sel({ni11i, n0OOl}));
	defparam
		nll1l.width_data = 4,
		nll1l.width_sel = 2;
	oper_mux   nll1O
	( 
	.data({{2{(~ wire_n001O_o)}}, {2{wire_n001O_o}}}),
	.o(wire_nll1O_o),
	.sel({ni11i, n0OOl}));
	defparam
		nll1O.width_data = 4,
		nll1O.width_sel = 2;
	oper_mux   nllii
	( 
	.data({{2{(~ wire_n00ii_o)}}, {2{wire_n00ii_o}}}),
	.o(wire_nllii_o),
	.sel({ni11i, n0OOl}));
	defparam
		nllii.width_data = 4,
		nllii.width_sel = 2;
	oper_mux   nllil
	( 
	.data({{2{(~ wire_n00il_o)}}, {2{wire_n00il_o}}}),
	.o(wire_nllil_o),
	.sel({ni11i, n0OOl}));
	defparam
		nllil.width_data = 4,
		nllil.width_sel = 2;
	oper_mux   nlliO
	( 
	.data({((nilOll40 ^ nilOll39) & (~ wire_n00iO_o)), (~ wire_n00iO_o), wire_n00iO_o, ((nilOlO38 ^ nilOlO37) & wire_n00iO_o)}),
	.o(wire_nlliO_o),
	.sel({ni11i, n0OOl}));
	defparam
		nlliO.width_data = 4,
		nlliO.width_sel = 2;
	oper_mux   nllli
	( 
	.data({(~ wire_n00li_o), ((nilOOi36 ^ nilOOi35) & (~ wire_n00li_o)), {2{wire_n00li_o}}}),
	.o(wire_nllli_o),
	.sel({ni11i, n0OOl}));
	defparam
		nllli.width_data = 4,
		nllli.width_sel = 2;
	oper_mux   nllll
	( 
	.data({{2{(~ wire_n00ll_o)}}, {2{wire_n00ll_o}}}),
	.o(wire_nllll_o),
	.sel({ni11i, n0OOl}));
	defparam
		nllll.width_data = 4,
		nllll.width_sel = 2;
	oper_mux   nlllO
	( 
	.data({(~ wire_n01Ol_o), (~ wire_n01ii_o), wire_n01Ol_o, wire_n01ii_o}),
	.o(wire_nlllO_o),
	.sel({ni11i, n0OOl}));
	defparam
		nlllO.width_data = 4,
		nlllO.width_sel = 2;
	oper_mux   nllOi
	( 
	.data({(~ wire_n01Oi_o), ((nilOOl34 ^ nilOOl33) & (~ wire_n01il_o)), wire_n01Oi_o, wire_n01il_o}),
	.o(wire_nllOi_o),
	.sel({ni11i, n0OOl}));
	defparam
		nllOi.width_data = 4,
		nllOi.width_sel = 2;
	oper_mux   nllOl
	( 
	.data({(~ wire_n01lO_o), (~ wire_n01iO_o), wire_n01lO_o, wire_n01iO_o}),
	.o(wire_nllOl_o),
	.sel({ni11i, n0OOl}));
	defparam
		nllOl.width_data = 4,
		nllOl.width_sel = 2;
	oper_mux   nllOO
	( 
	.data({(~ wire_n01ll_o), (~ wire_n01li_o), wire_n01ll_o, ((nilOOO32 ^ nilOOO31) & wire_n01li_o)}),
	.o(wire_nllOO_o),
	.sel({ni11i, n0OOl}));
	defparam
		nllOO.width_data = 4,
		nllOO.width_sel = 2;
	oper_mux   nlO0i
	( 
	.data({(~ wire_n01ii_o), (~ wire_n01Ol_o), wire_n01ii_o, wire_n01Ol_o}),
	.o(wire_nlO0i_o),
	.sel({ni11i, ((niO10l22 ^ niO10l21) & n0OOl)}));
	defparam
		nlO0i.width_data = 4,
		nlO0i.width_sel = 2;
	oper_mux   nlO0l
	( 
	.data({((niO10O20 ^ niO10O19) & (~ wire_n01OO_o)), (~ wire_n01OO_o), {2{wire_n01OO_o}}}),
	.o(wire_nlO0l_o),
	.sel({((niO1ii18 ^ niO1ii17) & ni11i), n0OOl}));
	defparam
		nlO0l.width_data = 4,
		nlO0l.width_sel = 2;
	oper_mux   nlO0O
	( 
	.data({{2{(~ wire_n001i_o)}}, ((niO1il16 ^ niO1il15) & wire_n001i_o), wire_n001i_o}),
	.o(wire_nlO0O_o),
	.sel({ni11i, n0OOl}));
	defparam
		nlO0O.width_data = 4,
		nlO0O.width_sel = 2;
	oper_mux   nlO1i
	( 
	.data({((niO11i30 ^ niO11i29) & (~ wire_n01li_o)), (~ wire_n01ll_o), wire_n01li_o, wire_n01ll_o}),
	.o(wire_nlO1i_o),
	.sel({ni11i, n0OOl}));
	defparam
		nlO1i.width_data = 4,
		nlO1i.width_sel = 2;
	oper_mux   nlO1l
	( 
	.data({(~ wire_n01iO_o), ((niO11l28 ^ niO11l27) & (~ wire_n01lO_o)), ((niO11O26 ^ niO11O25) & wire_n01iO_o), wire_n01lO_o}),
	.o(wire_nlO1l_o),
	.sel({ni11i, n0OOl}));
	defparam
		nlO1l.width_data = 4,
		nlO1l.width_sel = 2;
	oper_mux   nlO1O
	( 
	.data({(~ wire_n01il_o), (~ wire_n01Oi_o), wire_n01il_o, wire_n01Oi_o}),
	.o(wire_nlO1O_o),
	.sel({((niO10i24 ^ niO10i23) & ni11i), n0OOl}));
	defparam
		nlO1O.width_data = 4,
		nlO1O.width_sel = 2;
	assign
		disp_out_3b = {wire_nllllO_dataout, wire_nl0i1l_dataout},
		nil00i = (((((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil1ll)) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil1ll))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & wire_n1il_dataout)))) | (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & (~ wire_n1il_dataout))))),
		nil00l = (((((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil1Ol))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil1Oi))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil1Ol))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil1Oi))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout))))),
		nil00O = (nil0il | (wire_n1lO_dataout & nil0ii)),
		nil01i = (wire_n1lO_dataout & ((wire_n1ll_dataout & nil0iO) | nil00i)),
		nil01l = (wire_nl1O1O_dataout & nil00l),
		nil01O = ((((~ wire_n1lO_dataout) | wire_nl1O1O_dataout) & nil00l) | (wire_n1lO_dataout & (((~ nil00i) & (~ nil00l)) & nil0ii))),
		nil0ii = ((~ wire_n1ll_dataout) | (wire_n1li_dataout | (wire_n1iO_dataout | wire_n1il_dataout))),
		nil0il = ((~ wire_n1lO_dataout) & nil0iO),
		nil0iO = (((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & (~ wire_n1il_dataout))))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil1lO))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil1lO))),
		nil0li = (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & wire_n1il_dataout))),
		nil0ll = ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)))),
		nil0lO = (nil0li | nil0ll),
		nil0Oi = ((((wire_n1lO_dataout & wire_n1ll_dataout) & wire_n1li_dataout) & (~ wire_n1iO_dataout)) & (~ wire_n1il_dataout)),
		nil0Ol = (wire_n1iO_dataout & wire_n1il_dataout),
		nil0OO = ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)),
		nil1ll = (wire_n1iO_dataout & wire_n1il_dataout),
		nil1lO = ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)),
		nil1Oi = (wire_n1iO_dataout & (~ wire_n1il_dataout)),
		nil1Ol = ((~ wire_n1iO_dataout) & wire_n1il_dataout),
		nil1OO = (((((((~ wire_n1ll_dataout) & (wire_n1li_dataout & (wire_n1iO_dataout & wire_n1il_dataout))) | (wire_n1lO_dataout & nil0ll)) | (wire_n1lO_dataout & nil0li)) | (wire_n1lO_dataout & nil00i)) | nil01l) ^ ((~ wire_ni1ii_dataout) & (nil01l | ((nil0lO | ((~ wire_n1lO_dataout) & (((~ wire_n1ll_dataout) & nil00i) | nil0iO))) | nil01i)))),
		nili0i = ((((~ wire_nl11iO_dataout) & (wire_nl0lii_dataout & (~ nili0O))) | nili0l) ^ ((~ wire_nl11iO_dataout) & nili0O)),
		nili0l = (wire_n1Ol_dataout & wire_n1Oi_dataout),
		nili0O = (nili0l | nili1l),
		nili1i = ((~ wire_n1OO_dataout) & nili1l),
		nili1l = ((~ wire_n1Ol_dataout) & (~ wire_n1Oi_dataout)),
		nili1O = (wire_n1OO_dataout & (wire_n1Ol_dataout & (wire_n1Oi_dataout & ((((~ wire_nl11iO_dataout) & ((wire_n1lO_dataout & (~ wire_n1ll_dataout)) & (((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & (~ wire_n1il_dataout))))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil0OO))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil0OO))))) | (wire_nl11iO_dataout & (((~ wire_n1lO_dataout) & wire_n1ll_dataout) & (((((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil0Ol)) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil0Ol))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & wire_n1il_dataout)))) | (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & (~ wire_n1il_dataout)))))))) | (wire_n1OO_dataout & (wire_n1Ol_dataout & (wire_nil_dataout & wire_n1Oi_dataout))))))),
		niliii = (wire_nil_dataout & nil0Oi),
		niliil = (wire_n01l_dataout & wire_n01i_dataout),
		niliiO = ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)),
		nilili = (wire_n01l_dataout & (~ wire_n01i_dataout)),
		nilill = ((~ wire_n01l_dataout) & wire_n01i_dataout),
		nililO = (((((((~ wire_n00i_dataout) & (wire_n01O_dataout & (wire_n01l_dataout & wire_n01i_dataout))) | (wire_n00l_dataout & nillil)) | (wire_n00l_dataout & nillii)) | (wire_n00l_dataout & nill1i)) | niliOl) ^ ((~ wire_ni1il_dataout) & (niliOl | ((nilliO | ((~ wire_n00l_dataout) & (((~ wire_n00i_dataout) & nill1i) | nill0O))) | niliOi)))),
		niliOi = (wire_n00l_dataout & ((wire_n00i_dataout & nill0O) | nill1i)),
		niliOl = (wire_nll1Oi_dataout & nill1l),
		niliOO = ((((~ wire_n00l_dataout) | wire_nll1Oi_dataout) & nill1l) | (wire_n00l_dataout & (((~ nill1i) & (~ nill1l)) & nill0i))),
		nill0i = ((~ wire_n00i_dataout) | (wire_n01O_dataout | (wire_n01l_dataout | wire_n01i_dataout))),
		nill0l = ((~ wire_n00l_dataout) & nill0O),
		nill0O = (((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & (~ wire_n01i_dataout))))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & niliiO))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & niliiO))),
		nill1i = (((((~ wire_n00i_dataout) & (wire_n01O_dataout & niliil)) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & niliil))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & wire_n01i_dataout)))) | (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & (~ wire_n01i_dataout))))),
		nill1l = (((((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & nilill))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & nilili))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & nilill))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & nilili))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout))))),
		nill1O = (nill0l | (wire_n00l_dataout & nill0i)),
		nillii = (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & wire_n01i_dataout))),
		nillil = ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)))),
		nilliO = (nillii | nillil),
		nillli = ((((wire_n00l_dataout & wire_n00i_dataout) & wire_n01O_dataout) & (~ wire_n01l_dataout)) & (~ wire_n01i_dataout)),
		nillll = (wire_n01l_dataout & wire_n01i_dataout),
		nilllO = ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)),
		nillOi = ((~ wire_n0il_dataout) & nillOl),
		nillOl = ((~ wire_n0ii_dataout) & (~ wire_n00O_dataout)),
		nillOO = (wire_n0il_dataout & (wire_n0ii_dataout & (wire_n00O_dataout & ((((~ wire_nlii0i_dataout) & ((wire_n00l_dataout & (~ wire_n00i_dataout)) & (((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & (~ wire_n01i_dataout))))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & nilllO))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & nilllO))))) | (wire_nlii0i_dataout & (((~ wire_n00l_dataout) & wire_n00i_dataout) & (((((~ wire_n00i_dataout) & (wire_n01O_dataout & nillll)) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & nillll))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & wire_n01i_dataout)))) | (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & (~ wire_n01i_dataout)))))))) | (wire_n0il_dataout & (wire_n0ii_dataout & (wire_niO_dataout & wire_n00O_dataout))))))),
		nilO0i = (wire_niO_dataout & nillli),
		nilO1i = ((((~ wire_nlii0i_dataout) & (wire_nlO11l_dataout & (~ nilO1O))) | nilO1l) ^ ((~ wire_nlii0i_dataout) & nilO1O)),
		nilO1l = (wire_n0ii_dataout & wire_n00O_dataout),
		nilO1O = (nilO1l | nillOl),
		nilOil = 1'b1,
		niO00O = ((((((d21_5_eq_n & d2_2_eq_n) & (niO0iO2 ^ niO0iO1)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & (niO0ii4 ^ niO0ii3)) & k_det),
		niO1iO = (((((((d21_5_eq_n & d2_2_eq_n) & (niO1lO12 ^ niO1lO11)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & (niO1li14 ^ niO1li13)) & k_det) & (~ n00Oi)),
		niO1Ol = ((((((((d21_5_eq_n & d2_2_eq_n) & (niO00i6 ^ niO00i5)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & k_det) & (niO01l8 ^ niO01l7)) & n00Oi) & (niO1OO10 ^ niO1OO9)),
		pudr = {nil0O, nil0i, nil1l, nil1i, niiOO, niiOl, niiOi, niilO, niill, niili, niiiO, niiil, niiii, nii0O, nii0l, nii0i, nii1O, nii1l, nii1i, ni11O},
		tx_ctl_pre_en = {n0i0l, n0i0i},
		tx_data_9_pre_en = {n0i1O, n0i1l},
		tx_data_pre_en = {n0l0O, n0l0l, n0l0i, n0l1O, n0l1l, n0l1i, n0iOO, n0iOl, n0iOi, n0ilO, n0ill, n0ili, n0iiO, n0iil, n0iii, n0i0O},
		txlp20b = {n0Oll, n0Oli, n0OiO, n0Oil, n0Oii, n0O0O, n0O0l, n0O0i, n0O1O, n0O1l, n0O1i, n0lOO, n0lOl, n0lOi, n0llO, n0lll, n0lli, n0liO, n0lil, n0lii};
endmodule //stratixiigx_hssi_tx_enc_chnl_top
//synopsys translate_on
//VALID FILE

`timescale 1 ps/1 ps

module stratixiigx_hssi_tx_digi (txpcs_rst, scan_mode, txd, 
		pld_tx_clk, polinv_tx, rev_loop_data, wrenable_tx, rddisable_tx, 
		phfifourst_tx, txfifo_shared_sig_in_ch0, txfifo_shared_sig_in_q0_ch0, 
		txfifo_shared_sig_out, full_tx, empty_tx,
                tx_data_ts, tx_ctl_ts, refclk_pma, txpma_local_clk,
                tx_clk_out, tx_data_tc, tx_ctl_tc, pudr, 
                rd_enable_sync, refclk_b, txlp20b, tx_pipe_clk, encoder_testbus, tx_ctrl_testbus,
                tx_pipe_soft_reset, tx_pipe_electidle, rrev_loopbk, rev_loopbk, rbisten_tx, 
                rforce_disp, rib_force_disp, rforce_echar, rforce_kchar, rendec_tx, 
                rge_xaui_tx, 
                rdwidth_tx, rtxfifo_dis, rcascaded_8b10b_en_tx, 
                rprbsen_tx, rprbs_sel, rbist_sel, rcxpat_chnl_en, 
                renpolinv_tx, rphfifopldentx, rphfifoursttx,
                rfreerun_tx, rtxwrclksel, rtxrdclksel, renbitrev_tx, rensymswap_tx,
                r8b10b_enc_ibm_en, rtxfifo_lowlatency_en,
                rpmadwidth_tx, rpma_doublewidth_tx, rtx_pipe_enable,
                rindv_tx, rendec_data_sel_tx, rphfifo_master_sel_tx
              );

// Reset inputs
input          txpcs_rst;             // TX PCS resets

// Scan inputs
input          scan_mode;             // 1'b1 = scan mode active; 
                                      // 1'b0 = normal mode
// TX PCS channel inputs/outputs
input   [43:0] txd;                   // TXD data bus from PLD
input          pld_tx_clk;            // XGMII tx clock for this lane from PLD
input          polinv_tx;             // TX polarity inversion dynamic control signal
input   [7:0]  tx_data_ts;            // 8-bit tx data from 10G ethernet 
                                      // tx state machine (tx_sm)
input          tx_ctl_ts;             // 1-bit tx control from 10G ethernet tx state machine (tx_sm)
input          refclk_pma;            // Global parallel clock from TX PLL
input          txpma_local_clk;       // Individual TX PMA clock from TX PMA Extension
input          rev_loopbk;	      // Dynamic signal causes reverse loopback
input   [19:0] rev_loop_data;	      // 10 bit data from RX rate matching FIFO, reverse loopback
input          wrenable_tx;           // TX phase comp. FIFO write enable control signal
input          rddisable_tx;          // TX phase comp. FIFO read disable control signal
input          phfifourst_tx;	      // TX phase comp. FIFO user reset
input   [3:0]  txfifo_shared_sig_in_ch0;    // TX FIFO shared signal from channel 0
input   [3:0]  txfifo_shared_sig_in_q0_ch0; // TX FIFO shared signal from channel 0 of Quad 0

output  [3:0]  txfifo_shared_sig_out; // TX FIFO shared signal output
output         full_tx;               // TX Phase comp. FIFO full flag
output         empty_tx;              // TX Phase comp. FIFO empty flag
output         tx_clk_out;
output  [7:0]  tx_data_tc;            // 8-bit tx data from tx_ctrl to XAUI TX SM
output         tx_ctl_tc;             // TX control/TX data bit 8 from tx_ctrl to XAUI TX SM
output  [19:0] pudr;                  // TX PCS 20-bit code group bus to TX PMA
output         rd_enable_sync;
output         refclk_b;              
output [19:0]  txlp20b;               // tx 20-bit code group bus to RX PCS for loopback
output         tx_pipe_clk;           // TX PIPE interface clock
output [9:0]   encoder_testbus;       // Test bus from 8B10B encoder
output [9:0]   tx_ctrl_testbus;       // Test bus from TX FIFO
output         tx_pipe_soft_reset;    // TX PIPE soft reset from TX FIFO
output         tx_pipe_electidle;     // TxElecIdle output from TX FIFO

// TX PCS CRAMs
input          rrev_loopbk;	      // CRAM - Enable dynamic Reverse, PIPE mode
input          rbisten_tx;            // ENBIST CRAM
input 	       rforce_disp;	      // Acting with TXD[9, 19] forces current disparity to 1 or 0
input          rib_force_disp;        // Disparity force CRAM in IB mode
input          rforce_echar;          // Force /E/ char CRAM
input          rforce_kchar;          // Force /K/ char CRAM
input          rendec_tx;             // Enable 8B/10B encoder CRAM
input          rge_xaui_tx;           // GIGE Idle test enable CRAM
input          rdwidth_tx;            // TX parallel interface data width CRAM
input          rtxfifo_dis;           // TX FIFO disable CRAM
input          rcascaded_8b10b_en_tx; // Caascaded 8b/10b encoder enable CRAM
input          rprbsen_tx;            // PRBS generator enable CRAM
input   [2:0]  rprbs_sel;             // PRBS selection CRAM
input   [1:0]  rbist_sel;             // BIST selection CRAM
input   [1:0]  rcxpat_chnl_en;        // CRPAT or CJPAT selection CRAM
input          renpolinv_tx;          // TX Polarity inversion enable CRAM
input          rphfifopldentx;        // TX phase comp. FIFO PLD read/write enable CRAM
input          rphfifoursttx;         // TX phase comp. FIFO user reset enable CRAM
input          rfreerun_tx;           // TX_CLK out free running during TX PCS reset enable CRAM
input          rtxwrclksel;           // TX FIFO write clock selection CRAM
input          rtxrdclksel;           // TX FIFO read clock selection CRAM
input          renbitrev_tx;          // TX bit reversal enable CRAM
input          rensymswap_tx;         // TX symbol swap enable CRAM
input          r8b10b_enc_ibm_en;     // 8B10B Encoder fix enable CRAM
input          rtxfifo_lowlatency_en; // TX FIFO low latency enable CRAM
input          rpmadwidth_tx;         // TX PCS to TX PMA data width selection CRAM
input          rpma_doublewidth_tx;   // PCS/PMA double width (16/20) selection CRAM
input          rtx_pipe_enable;       // TX PIPE enable CRAM

// Common PCS CRAMs
input          rindv_tx;              // TX SM bypassing CRAM
input          rendec_data_sel_tx;    // TX 8B10B encoder data in selection CRAM
input          rphfifo_master_sel_tx; // TX Phase comp. FIFO pointers selection CRAM

// Wiring section
wire	       refclk_b;
wire           wr_clk_pos;
wire           fifo_rd_clk;
wire    [7:0]  tx_data_tc_high;       // high 8-bit tx data from tx_ctrl
wire    [7:0]  tx_data_tc;            // low 8-bit tx data from tx_ctrl
wire           tx_ctl_tc_high;        // high tx control/tx data bit 8 from tx_ctrl
wire           tx_ctl_tc;             // low tx control/tx data bit 8 from tx_ctrl
wire	       rd_enable_sync;
wire	[1:0]  tx_ctl_pre_en;  
wire    [15:0] tx_data_pre_en;
wire    [1:0]  tx_data_9_pre_en;
wire    [15:0] tx_data_sg;            // 16-bit data sequence generated by bist_gen.
wire    [1:0]  tx_control_sg;         // 2-bit control sequence generated by selftest_gen.
wire    [1:0]  tx_data_9_tc;          // tx data bit 9 from tx_ctrl
wire    [19:0]  tx_data_pg;           // 20-bit tx code group generated by prbs_gen
wire           soft_reset_int;
wire    [1:0]  k_det, d21_5_eq_n, d2_2_eq_n;
wire 	[1:0]  txd_extend_tc;         // Extend txd by 2 bits. Used to force disparity. This will go to the encoder. 
				      // THis is input from the PLD Fabric
wire    [1:0]  disp_out_3b;           // Disparity output from encoder for testbus
wire 	       wr_enable2;
wire    [2:0]  wptr_bin;
wire 	       rd_enable2;
wire    [2:0]  rptr_bin;

// Gated soft reset by scan_mode signal
//assign soft_reset_int = (scan_mode) ? 1'b0 : txpcs_rst;
assign soft_reset_int =  txpcs_rst;

// TX PIPE interface clock
assign tx_pipe_clk = wr_clk_pos;

// Encoder testbus
assign encoder_testbus = {disp_out_3b, pudr[7:0]};

// TX FIFO testbus
assign tx_ctrl_testbus = {1'b0, txfifo_shared_sig_out[0], wr_enable2, wptr_bin, rd_enable2, rptr_bin};

// Clock selection module
stratixiigx_hssi_tx_txclk_ctl txclk_ctl_1 (
                       .txrst(txpcs_rst), 
                       .pld_tx_clk(pld_tx_clk), 
                       .refclk_pma(refclk_pma), 
                       .txpma_local_clk(txpma_local_clk),
                       .tx_div2_sync_in_ch0(txfifo_shared_sig_in_ch0[3]),
                       .tx_div2_sync_in_q0_ch0(txfifo_shared_sig_in_q0_ch0[3]),
		       .rindv_tx(rindv_tx), 
                       .rtxrdclksel(rtxrdclksel), 
                       .rtxwrclksel(rtxwrclksel),
                       .rdwidth_tx(rdwidth_tx), 
                       .rfreerun_tx(rfreerun_tx),
                       .rphfifo_master_sel_tx(rphfifo_master_sel_tx),
                       .scan_mode (scan_mode),
		       .tx_clk_out(tx_clk_out), 
                       .tx_div2_sync_out(txfifo_shared_sig_out[3]), 
                       .wr_clk_pos(wr_clk_pos), 
                       .fifo_rd_clk(fifo_rd_clk),
                       .refclk_b(refclk_b) 
		      );
		     

// TX Phase compensation FIFO module
stratixiigx_hssi_tx_ctrl           tx_ctrl_1 (
                             .soft_reset (soft_reset_int),
                             .fifo_wr_clk (wr_clk_pos),
                             .fifo_rd_clk (fifo_rd_clk),
			     .refclk_b_in (refclk_b),
			     .scan_mode(scan_mode),
                             .indv (rindv_tx),
                             .rphfifo_master_sel_tx (rphfifo_master_sel_tx),
                             .p_rlpbk (1'b0),
                             .selftest_en (rbisten_tx),
                             .dwidth (rdwidth_tx),
                             .txfifo_dis (rtxfifo_dis),
                             .rtxfifo_urst_en(rphfifoursttx),
                             .txfifo_urst(phfifourst_tx),
                             .rtxfifo_lowlatency_en(rtxfifo_lowlatency_en),
                             .rtxphfifopldctl_en(rphfifopldentx),
                             .rtx_pipe_enable(rtx_pipe_enable),
                             .pld_we(wrenable_tx),
                             .pld_rd_dis(rddisable_tx),
                             .txd ({txd[42:33],txd[31:22],txd[20:11],txd[9:0]}),
			     .txd_extend ({txd[43],txd[32],txd[21],txd[10]}),               
			     .rforce_disp (rforce_disp),
                             .tx_data_sg ({16'h0000,tx_data_sg}),      
                             .tx_control_sg ({2'b00,tx_control_sg}),   
                             .rxd_lpbk (40'h0000000000),
                             .redund_ctl (4'h0),
                             .txd_redun (40'h0000000000),
                             .wr_enable_ch0(txfifo_shared_sig_in_ch0[2]),
                             .rd_enable_ch0(txfifo_shared_sig_in_ch0[1]),
                             .fifo_select_in_ch0(txfifo_shared_sig_in_ch0[0]),
                             .wr_enable_q0_ch0(txfifo_shared_sig_in_q0_ch0[2]),
                             .rd_enable_q0_ch0(txfifo_shared_sig_in_q0_ch0[1]),
                             .fifo_select_in_q0_ch0 (txfifo_shared_sig_in_q0_ch0[0]),
                             .rforce_kchar (rforce_kchar),
                             .rforce_echar (rforce_echar),
			     .txd_extend_tc (txd_extend_tc),               
                             .tx_data_tc ({tx_data_tc_high,tx_data_tc}),             
                             .tx_ctl_tc ({tx_ctl_tc_high,tx_ctl_tc}),             
                             .tx_data_9_tc (tx_data_9_tc),
                             .rd_enable_sync (rd_enable_sync),
                             .k_det (k_det),
                             .d21_5_eq_n (d21_5_eq_n),
			     .d2_2_eq_n (d2_2_eq_n),
			     .wr_enable_out(txfifo_shared_sig_out[2]),
			     .rd_enable_out(txfifo_shared_sig_out[1]),
                             .fifo_select_out (txfifo_shared_sig_out[0]),
                             .ph_fifo_full(full_tx),
                             .ph_fifo_empty(empty_tx),
                             .soft_reset_wclk1(tx_pipe_soft_reset),
                             .pipe_electric_idle(tx_pipe_electidle),
                             .wr_enable2(wr_enable2),
                             .wptr_bin(wptr_bin),
                             .rd_enable2(rd_enable2),
                             .rptr_bin(rptr_bin)
                            );           

// BIST generator module
stratixiigx_hssi_tx_bist_gen selftest_gen_1  (
                          .tx_clk(wr_clk_pos),
                          .soft_reset(tx_pipe_soft_reset),
                          .rbisten_tx(rbisten_tx),
                          .rpmadwidth_tx(rpmadwidth_tx),
                          .rpma_doublewidth_tx(rpma_doublewidth_tx),
                          .rdwidth_tx(rdwidth_tx),
                          .rbist_sel(rbist_sel),
                          .rcxpat_chnl_sel(rcxpat_chnl_en),
                          .bist_data_sg(tx_data_sg),
                          .bist_ctl_sg(tx_control_sg)
                         );

// PRBS generator module
stratixiigx_hssi_tx_prbs_gen prbs_gen_1      (
                          .tx_clk(refclk_b), 
                          .soft_reset(soft_reset_int), 
                          .rprbs_en_tx(rprbsen_tx), 
                          .rpmadwidth_tx(rpmadwidth_tx),
                          .rpma_doublewidth_tx(rpma_doublewidth_tx), 
                          .rprbs_sel(rprbs_sel),
                          .prbs_out(tx_data_pg)
                         );

// 8B-10B Encoder module
stratixiigx_hssi_tx_enc_chnl_top enc_chnl_top_1 (
                             .rst(soft_reset_int), 
                             .clk(refclk_b), 
                             .cascaded_8b10b_en(rcascaded_8b10b_en_tx),
                             .rendec_data_sel_tx(rendec_data_sel_tx), 
                             .rrev_loopbk(rrev_loopbk), 
                             .rev_loopbk(rev_loopbk),
                             .dwidth(rpmadwidth_tx),
                             .doublewidth(rpma_doublewidth_tx),
                             .endec(rendec_tx), 
                             .ge_xaui_sel(rge_xaui_tx), 
                             .rforce_disp(rforce_disp), 
                             .ib_force_disparity(rib_force_disp), 
                             .prbs_en(rprbsen_tx), 
                             .r8b10b_enc_ibm_en(r8b10b_enc_ibm_en),
                             .rev_loop_data(rev_loop_data),
                             .tx_ctl_ts(tx_ctl_ts),
                             .tx_ctl_tc({tx_ctl_tc_high,tx_ctl_tc}),
                             .tx_data_ts(tx_data_ts),
                             .txd_extend_tc(txd_extend_tc),
                             .tx_data_tc({tx_data_tc_high,tx_data_tc}), 
                             .tx_data_9_tc(tx_data_9_tc),
                             .tx_data_pg(tx_data_pg),
                             .k_det(k_det[0]),
                             .d21_5_eq_n(d21_5_eq_n[0]),
                             .d2_2_eq_n(d2_2_eq_n[0]),
                             .renpolinv_tx(renpolinv_tx),
                             .enpolinv_tx(polinv_tx),
                             .renbitrev_tx(renbitrev_tx),
                             .rensymswap_tx(rensymswap_tx),
                             .pudr(pudr), 
                             .txlp20b(txlp20b),
                             .tx_data_pre_en(tx_data_pre_en),
                             .tx_data_9_pre_en(tx_data_9_pre_en), 
                             .tx_ctl_pre_en(tx_ctl_pre_en),
                             .disp_out_3b(disp_out_3b)
                             );

endmodule

//****************************************************************************
// Description:
//    This is a flip-flop based implementation
//    Bit 15,14 are the underflow/overflow/insertion/deletion status bits
//    Bit 13 is the running Disparity polarity bits 
//    Bit 12 is the Disparity Error bit
//    Bit 11 is the Resync/Sync_status bit
//    Bit 10 is the Invalid Code bit
//    Bit 9 to 0 -- Encoded 10-bit data
//****************************************************************************

`timescale 1ps / 1ps

module stratixiigx_hssi_ram20x16_syn (
    data_in,
    clk,
    fifo_wr,
    rst_l, 
    fifo_re1,
    fifo_re2,
    data_out1,
    data_out2
    );

input 		clk;
input 		rst_l;
input 	[19:0]	fifo_wr;
input 	[19:0] 	fifo_re1;
input 	[19:0] 	fifo_re2;
input 	[15:0] 	data_in;
output 	[15:0] 	data_out1;
output 	[15:0] 	data_out2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 16;

reg [ram_width-1:0] data_out1_i, data_out2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, ram_array_d_8, 
                    ram_array_d_9, ram_array_d_10, ram_array_d_11,
                    ram_array_d_12, ram_array_d_13, ram_array_d_14,
		    ram_array_d_15, ram_array_d_16, ram_array_d_17, 
		    ram_array_d_18, ram_array_d_19, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7, ram_array_q_8, 
                    ram_array_q_9, ram_array_q_10, ram_array_q_11,
                    ram_array_q_12, ram_array_q_13, ram_array_q_14,
		    ram_array_q_15, ram_array_q_16, ram_array_q_17, 
		    ram_array_q_18, ram_array_q_19; 
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7,
		     data_reg_8, data_reg_9, data_reg_10, data_reg_11, 
		     data_reg_12, data_reg_13, data_reg_14, data_reg_15, 
	             data_reg_16, data_reg_17, data_reg_18, data_reg_19;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7,
    data_reg_8 = ( fifo_wr[8] == 1'b1 ) ? data_in : ram_array_q_8,
    data_reg_9 = ( fifo_wr[9] == 1'b1 ) ? data_in : ram_array_q_9,
    data_reg_10 = ( fifo_wr[10] == 1'b1 ) ? data_in : ram_array_q_10,
    data_reg_11 = ( fifo_wr[11] == 1'b1 ) ? data_in : ram_array_q_11,
    data_reg_12 = ( fifo_wr[12] == 1'b1 ) ? data_in : ram_array_q_12,
    data_reg_13 = ( fifo_wr[13] == 1'b1 ) ? data_in : ram_array_q_13,
    data_reg_14 = ( fifo_wr[14] == 1'b1 ) ? data_in : ram_array_q_14,
    data_reg_15 = ( fifo_wr[15] == 1'b1 ) ? data_in : ram_array_q_15,
    data_reg_16 = ( fifo_wr[16] == 1'b1 ) ? data_in : ram_array_q_16,
    data_reg_17 = ( fifo_wr[17] == 1'b1 ) ? data_in : ram_array_q_17,
    data_reg_18 = ( fifo_wr[18] == 1'b1 ) ? data_in : ram_array_q_18,
    data_reg_19 = ( fifo_wr[19] == 1'b1 ) ? data_in : ram_array_q_19;


assign #read_access_time data_out1 = re_l ? 15'b0 : data_out1_i;
assign #read_access_time data_out2 = re_l ? 15'b0 : data_out2_i;


always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or 
    ram_array_q_13      or 
    ram_array_q_14      or 
    ram_array_q_15      or 
    ram_array_q_16      or 
    ram_array_q_17      or 
    ram_array_q_18      or 
    ram_array_q_19      or 
    fifo_re1		or
    fifo_re2		)
begin
    case ( fifo_re1 )  // synopsys parallel_case full_case
    20'b00000000000000000001 : data_out1_i = ram_array_q_0;
    20'b00000000000000000010 : data_out1_i = ram_array_q_1;
    20'b00000000000000000100 : data_out1_i = ram_array_q_2;
    20'b00000000000000001000 : data_out1_i = ram_array_q_3;
    20'b00000000000000010000 : data_out1_i = ram_array_q_4;
    20'b00000000000000100000 : data_out1_i = ram_array_q_5;
    20'b00000000000001000000 : data_out1_i = ram_array_q_6;
    20'b00000000000010000000 : data_out1_i = ram_array_q_7;
    20'b00000000000100000000 : data_out1_i = ram_array_q_8;
    20'b00000000001000000000 : data_out1_i = ram_array_q_9;
    20'b00000000010000000000 : data_out1_i = ram_array_q_10;
    20'b00000000100000000000 : data_out1_i = ram_array_q_11;
    20'b00000001000000000000 : data_out1_i = ram_array_q_12;
    20'b00000010000000000000 : data_out1_i = ram_array_q_13;
    20'b00000100000000000000 : data_out1_i = ram_array_q_14;
    20'b00001000000000000000 : data_out1_i = ram_array_q_15;
    20'b00010000000000000000 : data_out1_i = ram_array_q_16;
    20'b00100000000000000000 : data_out1_i = ram_array_q_17;
    20'b01000000000000000000 : data_out1_i = ram_array_q_18;
    20'b10000000000000000000 : data_out1_i = ram_array_q_19;
    endcase

    case ( fifo_re2 )  // synopsys parallel_case full_case
    20'b00000000000000000001 : data_out2_i = ram_array_q_0;
    20'b00000000000000000010 : data_out2_i = ram_array_q_1;
    20'b00000000000000000100 : data_out2_i = ram_array_q_2;
    20'b00000000000000001000 : data_out2_i = ram_array_q_3;
    20'b00000000000000010000 : data_out2_i = ram_array_q_4;
    20'b00000000000000100000 : data_out2_i = ram_array_q_5;
    20'b00000000000001000000 : data_out2_i = ram_array_q_6;
    20'b00000000000010000000 : data_out2_i = ram_array_q_7;
    20'b00000000000100000000 : data_out2_i = ram_array_q_8;
    20'b00000000001000000000 : data_out2_i = ram_array_q_9;
    20'b00000000010000000000 : data_out2_i = ram_array_q_10;
    20'b00000000100000000000 : data_out2_i = ram_array_q_11;
    20'b00000001000000000000 : data_out2_i = ram_array_q_12;
    20'b00000010000000000000 : data_out2_i = ram_array_q_13;
    20'b00000100000000000000 : data_out2_i = ram_array_q_14;
    20'b00001000000000000000 : data_out2_i = ram_array_q_15;
    20'b00010000000000000000 : data_out2_i = ram_array_q_16;
    20'b00100000000000000000 : data_out2_i = ram_array_q_17;
    20'b01000000000000000000 : data_out2_i = ram_array_q_18;
    20'b10000000000000000000 : data_out2_i = ram_array_q_19;
    endcase
end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
        ram_array_q_8 <= #write_access_time 0;
        ram_array_q_9 <= #write_access_time 0;
        ram_array_q_10 <= #write_access_time 0;
        ram_array_q_11 <= #write_access_time 0; 
        ram_array_q_12 <= #write_access_time 0; 
        ram_array_q_13 <= #write_access_time 0; 
        ram_array_q_14 <= #write_access_time 0; 
        ram_array_q_15 <= #write_access_time 0; 
        ram_array_q_16 <= #write_access_time 0; 
        ram_array_q_17 <= #write_access_time 0; 
        ram_array_q_18 <= #write_access_time 0; 
        ram_array_q_19 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
        ram_array_q_16 <= #write_access_time ram_array_d_16;
        ram_array_q_17 <= #write_access_time ram_array_d_17;
        ram_array_q_18 <= #write_access_time ram_array_d_18;
        ram_array_q_19 <= #write_access_time ram_array_d_19;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    data_reg_16         or
    data_reg_17         or
    data_reg_18         or
    data_reg_19         or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or
    ram_array_q_16      or
    ram_array_q_17      or
    ram_array_q_18      or
    ram_array_q_19	)
begin
    if(we) begin
	ram_array_d_0 <= #write_access_time data_reg_0;
	ram_array_d_1 <= #write_access_time data_reg_1;
	ram_array_d_2 <= #write_access_time data_reg_2;
	ram_array_d_3 <= #write_access_time data_reg_3;
        ram_array_d_4 <= #write_access_time data_reg_4;
        ram_array_d_5 <= #write_access_time data_reg_5;
        ram_array_d_6 <= #write_access_time data_reg_6;
        ram_array_d_7 <= #write_access_time data_reg_7; 
        ram_array_d_8 <= #write_access_time data_reg_8;
        ram_array_d_9 <= #write_access_time data_reg_9;
        ram_array_d_10 <= #write_access_time data_reg_10;
        ram_array_d_11 <= #write_access_time data_reg_11; 
        ram_array_d_12 <= #write_access_time data_reg_12; 
        ram_array_d_13 <= #write_access_time data_reg_13; 
        ram_array_d_14 <= #write_access_time data_reg_14; 
        ram_array_d_15 <= #write_access_time data_reg_15; 
        ram_array_d_16 <= #write_access_time data_reg_16; 
        ram_array_d_17 <= #write_access_time data_reg_17; 
        ram_array_d_18 <= #write_access_time data_reg_18; 
        ram_array_d_19 <= #write_access_time data_reg_19; 
    end
    else begin
	ram_array_d_0 <= #write_access_time ram_array_q_0;
	ram_array_d_1 <= #write_access_time ram_array_q_1;
	ram_array_d_2 <= #write_access_time ram_array_q_2;
	ram_array_d_3 <= #write_access_time ram_array_q_3;
        ram_array_d_4 <= #write_access_time ram_array_q_4;
        ram_array_d_5 <= #write_access_time ram_array_q_5;
        ram_array_d_6 <= #write_access_time ram_array_q_6;
        ram_array_d_7 <= #write_access_time ram_array_q_7;
        ram_array_d_8 <= #write_access_time ram_array_q_8;
        ram_array_d_9 <= #write_access_time ram_array_q_9;
        ram_array_d_10 <= #write_access_time ram_array_q_10;
        ram_array_d_11 <= #write_access_time ram_array_q_11;
        ram_array_d_12 <= #write_access_time ram_array_q_12;
        ram_array_d_13 <= #write_access_time ram_array_q_13;
        ram_array_d_14 <= #write_access_time ram_array_q_14;
        ram_array_d_15 <= #write_access_time ram_array_q_15;
        ram_array_d_16 <= #write_access_time ram_array_q_16;
        ram_array_d_17 <= #write_access_time ram_array_q_17;
        ram_array_d_18 <= #write_access_time ram_array_q_18;
        ram_array_d_19 <= #write_access_time ram_array_q_19;
    end
end

endmodule

//************************************************************
// Description:
//
//    Started from ram16x13_syn.v and modified to have 
//    width of 14
//
//    Bit 13 is the running Disparity polarity bits 
//    Bit 12 is the Disparity Error bit
//    Bit 11 is the Resync/Sync_status bit
//    Bit 10 is the Invalid Code bit
//    Bit 9 to 0 -- Encoded 10-bit data
// **********************************************************


`timescale 1ps / 1ps

module stratixiigx_hssi_ram16x14_syn (
    clk,
    rst_l, 
    addr_wr,
    addr_rd1,
    addr_rd2,
    data_in,
    we,
    re_l,
    data_out1,
    data_out2
    );

input 		clk;
input 		rst_l;
input 	[15:0]	addr_wr;
input 	[15:0] 	addr_rd1;
input 	[15:0] 	addr_rd2;
input 	[13:0] 	data_in;
input 		we, re_l;
output 	[13:0] 	data_out1;
output 	[13:0] 	data_out2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 14;

reg [ram_width-1:0] data_out1_i, data_out2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, ram_array_d_3,
		    ram_array_d_4, ram_array_d_5, ram_array_d_6, ram_array_d_7,
		    ram_array_d_8, ram_array_d_9, ram_array_d_10, 
                    ram_array_d_11,
		    ram_array_d_12, ram_array_d_13, ram_array_d_14, 
                    ram_array_d_15,
		    ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3,
		    ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7,
		    ram_array_q_8, ram_array_q_9, ram_array_q_10, 
                    ram_array_q_11,
		    ram_array_q_12, ram_array_q_13, ram_array_q_14, 
                    ram_array_q_15;
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7,
		     data_reg_8, data_reg_9, data_reg_10, data_reg_11,
		     data_reg_12, data_reg_13, data_reg_14, data_reg_15;

 /* Modelling the read port */
 /* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( addr_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( addr_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( addr_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( addr_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( addr_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( addr_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( addr_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( addr_wr[7] == 1'b1 ) ? data_in : ram_array_q_7,
    data_reg_8 = ( addr_wr[8] == 1'b1 ) ? data_in : ram_array_q_8,
    data_reg_9 = ( addr_wr[9] == 1'b1 ) ? data_in : ram_array_q_9,
    data_reg_10 = ( addr_wr[10] == 1'b1 ) ? data_in : ram_array_q_10,
    data_reg_11 = ( addr_wr[11] == 1'b1 ) ? data_in : ram_array_q_11,
    data_reg_12 = ( addr_wr[12] == 1'b1 ) ? data_in : ram_array_q_12,
    data_reg_13 = ( addr_wr[13] == 1'b1 ) ? data_in : ram_array_q_13,
    data_reg_14 = ( addr_wr[14] == 1'b1 ) ? data_in : ram_array_q_14,
    data_reg_15 = ( addr_wr[15] == 1'b1 ) ? data_in : ram_array_q_15;


assign #read_access_time data_out1 = re_l ? 13'b0000000000000 : data_out1_i;
assign #read_access_time data_out2 = re_l ? 13'b0000000000000 : data_out2_i;


always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or 
    addr_rd1		or
    addr_rd2		)
begin
    case ( addr_rd1 )  // synopsys parallel_case full_case
    16'b0000000000000001 : data_out1_i = ram_array_q_0;
    16'b0000000000000010 : data_out1_i = ram_array_q_1;
    16'b0000000000000100 : data_out1_i = ram_array_q_2;
    16'b0000000000001000 : data_out1_i = ram_array_q_3;
    16'b0000000000010000 : data_out1_i = ram_array_q_4;
    16'b0000000000100000 : data_out1_i = ram_array_q_5;
    16'b0000000001000000 : data_out1_i = ram_array_q_6;
    16'b0000000010000000 : data_out1_i = ram_array_q_7;
    16'b0000000100000000 : data_out1_i = ram_array_q_8;
    16'b0000001000000000 : data_out1_i = ram_array_q_9;
    16'b0000010000000000 : data_out1_i = ram_array_q_10;
    16'b0000100000000000 : data_out1_i = ram_array_q_11;
    16'b0001000000000000 : data_out1_i = ram_array_q_12;
    16'b0010000000000000 : data_out1_i = ram_array_q_13;
    16'b0100000000000000 : data_out1_i = ram_array_q_14;
    16'b1000000000000000 : data_out1_i = ram_array_q_15;
    endcase

    case ( addr_rd2 )  // synopsys parallel_case full_case
    16'b0000000000000001 : data_out2_i = ram_array_q_0;
    16'b0000000000000010 : data_out2_i = ram_array_q_1;
    16'b0000000000000100 : data_out2_i = ram_array_q_2;
    16'b0000000000001000 : data_out2_i = ram_array_q_3;
    16'b0000000000010000 : data_out2_i = ram_array_q_4;
    16'b0000000000100000 : data_out2_i = ram_array_q_5;
    16'b0000000001000000 : data_out2_i = ram_array_q_6;
    16'b0000000010000000 : data_out2_i = ram_array_q_7;
    16'b0000000100000000 : data_out2_i = ram_array_q_8;
    16'b0000001000000000 : data_out2_i = ram_array_q_9;
    16'b0000010000000000 : data_out2_i = ram_array_q_10;
    16'b0000100000000000 : data_out2_i = ram_array_q_11;
    16'b0001000000000000 : data_out2_i = ram_array_q_12;
    16'b0010000000000000 : data_out2_i = ram_array_q_13;
    16'b0100000000000000 : data_out2_i = ram_array_q_14;
    16'b1000000000000000 : data_out2_i = ram_array_q_15;
    endcase

end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
        ram_array_q_8 <= #write_access_time 0;
        ram_array_q_9 <= #write_access_time 0;
        ram_array_q_10 <= #write_access_time 0;
        ram_array_q_11 <= #write_access_time 0; 
        ram_array_q_12 <= #write_access_time 0;
        ram_array_q_13 <= #write_access_time 0;
        ram_array_q_14 <= #write_access_time 0;
        ram_array_q_15 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
    end
end
         

always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11	or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15	)
begin
    if(we) begin
	ram_array_d_0 <= #write_access_time data_reg_0;
	ram_array_d_1 <= #write_access_time data_reg_1;
	ram_array_d_2 <= #write_access_time data_reg_2;
	ram_array_d_3 <= #write_access_time data_reg_3;
        ram_array_d_4 <= #write_access_time data_reg_4;
        ram_array_d_5 <= #write_access_time data_reg_5;
        ram_array_d_6 <= #write_access_time data_reg_6;
        ram_array_d_7 <= #write_access_time data_reg_7; 
        ram_array_d_8 <= #write_access_time data_reg_8;
        ram_array_d_9 <= #write_access_time data_reg_9;
        ram_array_d_10 <= #write_access_time data_reg_10;
        ram_array_d_11 <= #write_access_time data_reg_11; 
        ram_array_d_12 <= #write_access_time data_reg_12;
        ram_array_d_13 <= #write_access_time data_reg_13;
        ram_array_d_14 <= #write_access_time data_reg_14;
        ram_array_d_15 <= #write_access_time data_reg_15; 
    end
    else begin
	ram_array_d_0 <= #write_access_time ram_array_q_0;
	ram_array_d_1 <= #write_access_time ram_array_q_1;
	ram_array_d_2 <= #write_access_time ram_array_q_2;
	ram_array_d_3 <= #write_access_time ram_array_q_3;
        ram_array_d_4 <= #write_access_time ram_array_q_4;
        ram_array_d_5 <= #write_access_time ram_array_q_5;
        ram_array_d_6 <= #write_access_time ram_array_q_6;
        ram_array_d_7 <= #write_access_time ram_array_q_7;
        ram_array_d_8 <= #write_access_time ram_array_q_8;
        ram_array_d_9 <= #write_access_time ram_array_q_9;
        ram_array_d_10 <= #write_access_time ram_array_q_10;
        ram_array_d_11 <= #write_access_time ram_array_q_11;
        ram_array_d_12 <= #write_access_time ram_array_q_12;
        ram_array_d_13 <= #write_access_time ram_array_q_13;
        ram_array_d_14 <= #write_access_time ram_array_q_14;
        ram_array_d_15 <= #write_access_time ram_array_q_15;

    end
end

endmodule

module stratixiigx_hssi_ram8x65_syn (
    rst_l, 
    clk,
    fifo_wr,
    data_in,
    fifo_re,
    data_out
    );

input 		rst_l;
input 		clk;
input 	[7:0]	fifo_wr;
input 	[64:0] 	data_in;
input 	[7:0] 	fifo_re;
output 	[64:0] 	data_out;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 65;

reg [ram_width-1:0] data_out_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7;

wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7;

assign  data_out = re_l ? 60'b0 : data_out_i;

always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    fifo_re		
    )
begin
    case ( fifo_re )  // synopsys parallel_case full_case
    8'b00000001 : data_out_i = ram_array_q_0;
    8'b00000010 : data_out_i = ram_array_q_1;
    8'b00000100 : data_out_i = ram_array_q_2;
    8'b00001000 : data_out_i = ram_array_q_3;
    8'b00010000 : data_out_i = ram_array_q_4;
    8'b00100000 : data_out_i = ram_array_q_5;
    8'b01000000 : data_out_i = ram_array_q_6;
    8'b10000000 : data_out_i = ram_array_q_7;
    default     : data_out_i = ram_array_q_0;
    endcase

end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	
       )
begin
    if(we) begin
	ram_array_d_0 <=  data_reg_0;
	ram_array_d_1 <=  data_reg_1;
	ram_array_d_2 <=  data_reg_2;
	ram_array_d_3 <=  data_reg_3;
        ram_array_d_4 <=  data_reg_4;
        ram_array_d_5 <=  data_reg_5;
        ram_array_d_6 <=  data_reg_6;
        ram_array_d_7 <=  data_reg_7; 
    end
    else begin
	ram_array_d_0 <=  ram_array_q_0;
	ram_array_d_1 <=  ram_array_q_1;
	ram_array_d_2 <=  ram_array_q_2;
	ram_array_d_3 <=  ram_array_q_3;
        ram_array_d_4 <=  ram_array_q_4;
        ram_array_d_5 <=  ram_array_q_5;
        ram_array_d_6 <=  ram_array_q_6;
        ram_array_d_7 <=  ram_array_q_7;
    end
end

endmodule
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 152 mux21 611 oper_add 8 oper_decoder 4 oper_mux 37 oper_selector 4 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_rx_bist_ver
	( 
	bistdone,
	bisterr,
	clk_2,
	cur_state,
	err_ctl,
	err_data,
	prbs_done,
	prbs_err,
	rbist_clr_rx,
	rbist_sel,
	rbisten_rx,
	rcxpat_chnl_sel,
	rdwidth_rx,
	rpma_doublewidth_rx,
	rpmadwidth_rx,
	rxc,
	rxd,
	selftest_done,
	selftest_err,
	soft_reset,
	sync_status) /* synthesis synthesis_clearbox=1 */;
	output   bistdone;
	output   bisterr;
	input   clk_2;
	output   [4:0]  cur_state;
	output   [1:0]  err_ctl;
	output   [15:0]  err_data;
	input   prbs_done;
	input   prbs_err;
	input   rbist_clr_rx;
	input   [1:0]  rbist_sel;
	input   rbisten_rx;
	input   [1:0]  rcxpat_chnl_sel;
	input   rdwidth_rx;
	input   rpma_doublewidth_rx;
	input   rpmadwidth_rx;
	input   [3:0]  rxc;
	input   [63:0]  rxd;
	output   selftest_done;
	output   selftest_err;
	input   soft_reset;
	input   sync_status;

	reg	n0liiO49;
	reg	n0liiO50;
	reg	n0lili47;
	reg	n0lili48;
	reg	n0O00O25;
	reg	n0O00O26;
	reg	n0O10l45;
	reg	n0O10l46;
	reg	n0O10O43;
	reg	n0O10O44;
	reg	n0O1ii41;
	reg	n0O1ii42;
	reg	n0O1il39;
	reg	n0O1il40;
	reg	n0O1iO37;
	reg	n0O1iO38;
	reg	n0O1li35;
	reg	n0O1li36;
	reg	n0O1ll33;
	reg	n0O1ll34;
	reg	n0O1lO31;
	reg	n0O1lO32;
	reg	n0O1Oi29;
	reg	n0O1Oi30;
	reg	n0O1Ol27;
	reg	n0O1Ol28;
	reg	n0Oili23;
	reg	n0Oili24;
	reg	n0OiOi21;
	reg	n0OiOi22;
	reg	n0Ol0l19;
	reg	n0Ol0l20;
	reg	n0Olii17;
	reg	n0Olii18;
	reg	n0Olil15;
	reg	n0Olil16;
	reg	n0OliO13;
	reg	n0OliO14;
	reg	n0Olll11;
	reg	n0Olll12;
	reg	n0OlOi10;
	reg	n0OlOi9;
	reg	n0OlOO7;
	reg	n0OlOO8;
	reg	n0OOii5;
	reg	n0OOii6;
	reg	n0OOiO3;
	reg	n0OOiO4;
	reg	n0OOll1;
	reg	n0OOll2;
	reg	ni00i;
	reg	ni01l;
	reg	ni1O1O;
	reg	niiilO;
	reg	niiiOi;
	reg	niiiOl;
	reg	niiiOO;
	reg	niil0i;
	reg	niil0l;
	reg	niil0O;
	reg	niil1i;
	reg	niil1l;
	reg	niil1O;
	reg	niilii;
	reg	niilil;
	reg	niiliO;
	reg	niilli;
	reg	niilll;
	reg	niillO;
	reg	niilOi;
	reg	niilOl;
	reg	niiO0i;
	reg	niiO1O;
	reg	nll00O;
	reg	nll0ii;
	wire	wire_ni01O_CLRN;
	reg	n11ii;
	reg	ni00l;
	reg	ni00O;
	reg	ni01i;
	reg	ni0ii;
	reg	ni0il;
	reg	ni0iO;
	reg	ni0li;
	reg	ni0ll;
	reg	ni0lO;
	reg	ni0Oi;
	reg	ni0Ol;
	reg	nii1i;
	reg	niilOO;
	reg	niiO1i;
	reg	niiO1l;
	reg	niiOii;
	reg	niiOil;
	reg	niiOiO;
	reg	niiOli;
	reg	niiOll;
	reg	niiOlO;
	reg	niiOOi;
	reg	niiOOl;
	reg	niiOOO;
	reg	nil00i;
	reg	nil00l;
	reg	nil00O;
	reg	nil01i;
	reg	nil01l;
	reg	nil01O;
	reg	nil0ii;
	reg	nil10i;
	reg	nil10l;
	reg	nil10O;
	reg	nil11i;
	reg	nil11l;
	reg	nil11O;
	reg	nil1ii;
	reg	nil1il;
	reg	nil1iO;
	reg	nil1li;
	reg	nil1ll;
	reg	nil1lO;
	reg	nil1Oi;
	reg	nil1Ol;
	reg	nil1OO;
	reg	nl1Oii;
	reg	nll00l;
	reg	nll0il;
	reg	nll0iO;
	reg	nll0li;
	reg	nll0ll;
	reg	nll0lO;
	reg	nll0Oi;
	reg	nll0Ol;
	reg	nll0OO;
	reg	nlli0i;
	reg	nlli0l;
	reg	nlli0O;
	reg	nlli1i;
	reg	nlli1l;
	reg	nlli1O;
	reg	nlliii;
	reg	nlliil;
	reg	nlliiO;
	reg	nllili;
	reg	nllill;
	reg	nllilO;
	reg	nlliOi;
	reg	nlliOl;
	reg	nlliOO;
	reg	nlll0i;
	reg	nlll1i;
	reg	nlll1l;
	reg	nlll1O;
	reg	ni0OO_clk_prev;
	wire	wire_ni0OO_CLRN;
	wire	wire_ni0OO_PRN;
	reg	niiO0O;
	reg	niiO0l_clk_prev;
	wire	wire_niiO0l_CLRN;
	wire	wire_niiO0l_PRN;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n00Ol_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1iOO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1l0i_dataout;
	wire	wire_n1l0l_dataout;
	wire	wire_n1l0O_dataout;
	wire	wire_n1l1i_dataout;
	wire	wire_n1l1l_dataout;
	wire	wire_n1l1O_dataout;
	wire	wire_n1lii_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni001O_dataout;
	wire	wire_ni00ii_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00iO_dataout;
	wire	wire_ni00li_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00Oi_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011i_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni01ii_dataout;
	wire	wire_ni01il_dataout;
	wire	wire_ni01iO_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01ll_dataout;
	wire	wire_ni01lO_dataout;
	wire	wire_ni01Ol_dataout;
	wire	wire_ni01OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0i0i_dataout;
	wire	wire_ni0i0l_dataout;
	wire	wire_ni0i0O_dataout;
	wire	wire_ni0i1i_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0iii_dataout;
	wire	wire_ni0iil_dataout;
	wire	wire_ni0iiO_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0ilO_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0l0i_dataout;
	wire	wire_ni0l0l_dataout;
	wire	wire_ni0l0O_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0lii_dataout;
	wire	wire_ni0liO_dataout;
	wire	wire_ni0lli_dataout;
	wire	wire_ni0llO_dataout;
	wire	wire_ni0lOi_dataout;
	wire	wire_ni0lOl_dataout;
	wire	wire_ni0lOO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0O0i_dataout;
	wire	wire_ni0O0l_dataout;
	wire	wire_ni0O0O_dataout;
	wire	wire_ni0O1i_dataout;
	wire	wire_ni0O1l_dataout;
	wire	wire_ni0O1O_dataout;
	wire	wire_ni0Oii_dataout;
	wire	wire_ni0Oil_dataout;
	wire	wire_ni0OiO_dataout;
	wire	wire_ni0Oli_dataout;
	wire	wire_ni0OOi_dataout;
	wire	wire_ni0OOl_dataout;
	wire	wire_ni0OOO_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1lii_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1lll_dataout;
	wire	wire_ni1llO_dataout;
	wire	wire_ni1lOi_dataout;
	wire	wire_ni1lOl_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1O0i_dataout;
	wire	wire_ni1O0l_dataout;
	wire	wire_ni1O0O_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1Oil_dataout;
	wire	wire_ni1OiO_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OOi_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii00i_dataout;
	wire	wire_nii00l_dataout;
	wire	wire_nii00O_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0ii_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0ll_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii0Oi_dataout;
	wire	wire_nii10i_dataout;
	wire	wire_nii10l_dataout;
	wire	wire_nii10O_dataout;
	wire	wire_nii11i_dataout;
	wire	wire_nii11l_dataout;
	wire	wire_nii11O_dataout;
	wire	wire_nii1ii_dataout;
	wire	wire_nii1il_dataout;
	wire	wire_nii1iO_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1li_dataout;
	wire	wire_nii1ll_dataout;
	wire	wire_nii1lO_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_nii1Oi_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0il_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0i_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili0O_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_niliii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilili_dataout;
	wire	wire_nilill_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliOi_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilliO_dataout;
	wire	wire_nillli_dataout;
	wire	wire_nillll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillOi_dataout;
	wire	wire_nillOl_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilO1l_dataout;
	wire	wire_nilO1O_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl000O_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl00il_dataout;
	wire	wire_nl00iO_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl00lO_dataout;
	wire	wire_nl00Oi_dataout;
	wire	wire_nl00Ol_dataout;
	wire	wire_nl00OO_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1i_dataout;
	wire	wire_nl0i1l_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0iii_dataout;
	wire	wire_nl0iil_dataout;
	wire	wire_nl0iiO_dataout;
	wire	wire_nl0ili_dataout;
	wire	wire_nl0ill_dataout;
	wire	wire_nl0ilO_dataout;
	wire	wire_nl0iOl_dataout;
	wire	wire_nl0iOO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l0i_dataout;
	wire	wire_nl0l0l_dataout;
	wire	wire_nl0l0O_dataout;
	wire	wire_nl0l1i_dataout;
	wire	wire_nl0l1l_dataout;
	wire	wire_nl0l1O_dataout;
	wire	wire_nl0lii_dataout;
	wire	wire_nl0lil_dataout;
	wire	wire_nl0liO_dataout;
	wire	wire_nl0lli_dataout;
	wire	wire_nl0lll_dataout;
	wire	wire_nl0llO_dataout;
	wire	wire_nl0lOi_dataout;
	wire	wire_nl0lOl_dataout;
	wire	wire_nl0lOO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0O0i_dataout;
	wire	wire_nl0O0l_dataout;
	wire	wire_nl0O0O_dataout;
	wire	wire_nl0O1i_dataout;
	wire	wire_nl0O1l_dataout;
	wire	wire_nl0O1O_dataout;
	wire	wire_nl0Oii_dataout;
	wire	wire_nl0Oil_dataout;
	wire	wire_nl0OiO_dataout;
	wire	wire_nl0Oli_dataout;
	wire	wire_nl0Oll_dataout;
	wire	wire_nl0OlO_dataout;
	wire	wire_nl0OOi_dataout;
	wire	wire_nl0OOl_dataout;
	wire	wire_nl0OOO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1OiO_dataout;
	wire	wire_nl1Oll_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0lO_dataout;
	wire	wire_nli0Oi_dataout;
	wire	wire_nli0Ol_dataout;
	wire	wire_nli0OO_dataout;
	wire	wire_nli10i_dataout;
	wire	wire_nli10l_dataout;
	wire	wire_nli10O_dataout;
	wire	wire_nli11i_dataout;
	wire	wire_nli11l_dataout;
	wire	wire_nli11O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlii0i_dataout;
	wire	wire_nlii0l_dataout;
	wire	wire_nlii0O_dataout;
	wire	wire_nlii1i_dataout;
	wire	wire_nlii1l_dataout;
	wire	wire_nlii1O_dataout;
	wire	wire_nliiii_dataout;
	wire	wire_nliiil_dataout;
	wire	wire_nliiiO_dataout;
	wire	wire_nliill_dataout;
	wire	wire_nliilO_dataout;
	wire	wire_nliiOi_dataout;
	wire	wire_nliiOl_dataout;
	wire	wire_nliiOO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0i_dataout;
	wire	wire_nlil0l_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlil1i_dataout;
	wire	wire_nlil1l_dataout;
	wire	wire_nlil1O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlillO_dataout;
	wire	wire_nlilOi_dataout;
	wire	wire_nlilOl_dataout;
	wire	wire_nlilOO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliO0i_dataout;
	wire	wire_nliO0l_dataout;
	wire	wire_nliO0O_dataout;
	wire	wire_nliO1i_dataout;
	wire	wire_nliO1l_dataout;
	wire	wire_nliO1O_dataout;
	wire	wire_nliOii_dataout;
	wire	wire_nliOil_dataout;
	wire	wire_nliOiO_dataout;
	wire	wire_nliOli_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOlO_dataout;
	wire	wire_nliOOi_dataout;
	wire	wire_nliOOl_dataout;
	wire	wire_nliOOO_dataout;
	wire	wire_nll10i_dataout;
	wire	wire_nll10l_dataout;
	wire	wire_nll10O_dataout;
	wire	wire_nll11i_dataout;
	wire	wire_nll11O_dataout;
	wire	wire_nll1ii_dataout;
	wire	wire_nll1il_dataout;
	wire	wire_nll1iO_dataout;
	wire	wire_nll1li_dataout;
	wire	wire_nll1ll_dataout;
	wire	wire_nll1lO_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nll1Ol_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlll0l_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlllii_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO00l_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nO_dataout;
	wire  [4:0]   wire_niiOl_o;
	wire  [6:0]   wire_niO0Ol_o;
	wire  [6:0]   wire_niO0OO_o;
	wire  [7:0]   wire_niOi1i_o;
	wire  [5:0]   wire_nllO0i_o;
	wire  [2:0]   wire_nllOil_o;
	wire  [8:0]   wire_nlO00O_o;
	wire  [3:0]   wire_nlO11l_o;
	wire  [31:0]   wire_n11ll_o;
	wire  [15:0]   wire_ni1ill_o;
	wire  [15:0]   wire_nii0Ol_o;
	wire  [15:0]   wire_nl1Oli_o;
	wire  wire_n100i_o;
	wire  wire_n100l_o;
	wire  wire_n101i_o;
	wire  wire_n101l_o;
	wire  wire_n101O_o;
	wire  wire_n11Ol_o;
	wire  wire_n11OO_o;
	wire  wire_ni1ilO_o;
	wire  wire_ni1iOi_o;
	wire  wire_ni1iOl_o;
	wire  wire_ni1iOO_o;
	wire  wire_ni1l0i_o;
	wire  wire_ni1l1i_o;
	wire  wire_ni1l1l_o;
	wire  wire_ni1l1O_o;
	wire  wire_nii0iO_o;
	wire  wire_nii0li_o;
	wire  wire_nii0lO_o;
	wire  wire_nii0OO_o;
	wire  wire_niii0i_o;
	wire  wire_niii0l_o;
	wire  wire_niii0O_o;
	wire  wire_niii1i_o;
	wire  wire_niii1l_o;
	wire  wire_niii1O_o;
	wire  wire_niiiii_o;
	wire  wire_niiiil_o;
	wire  wire_niiiiO_o;
	wire  wire_niiili_o;
	wire  wire_niiill_o;
	wire  wire_nl010i_o;
	wire  wire_nl010l_o;
	wire  wire_nl010O_o;
	wire  wire_nl011i_o;
	wire  wire_nl011l_o;
	wire  wire_nl011O_o;
	wire  wire_nl01ii_o;
	wire  wire_n11il_o;
	wire  wire_n11iO_o;
	wire  wire_n11lO_o;
	wire  wire_ni1iiO_o;
	wire  n0iOli;
	wire  n0iOll;
	wire  n0iOlO;
	wire  n0iOOi;
	wire  n0iOOl;
	wire  n0iOOO;
	wire  n0l00i;
	wire  n0l00l;
	wire  n0l00O;
	wire  n0l01i;
	wire  n0l01l;
	wire  n0l01O;
	wire  n0l0ii;
	wire  n0l0il;
	wire  n0l0iO;
	wire  n0l0li;
	wire  n0l0ll;
	wire  n0l0lO;
	wire  n0l0Oi;
	wire  n0l0Ol;
	wire  n0l0OO;
	wire  n0l10i;
	wire  n0l10l;
	wire  n0l10O;
	wire  n0l11i;
	wire  n0l11l;
	wire  n0l11O;
	wire  n0l1ii;
	wire  n0l1il;
	wire  n0l1iO;
	wire  n0l1li;
	wire  n0l1ll;
	wire  n0l1lO;
	wire  n0l1Oi;
	wire  n0l1Ol;
	wire  n0l1OO;
	wire  n0li0i;
	wire  n0li0l;
	wire  n0li0O;
	wire  n0li1i;
	wire  n0li1l;
	wire  n0li1O;
	wire  n0liii;
	wire  n0liil;
	wire  n0lill;
	wire  n0lilO;
	wire  n0liOi;
	wire  n0liOl;
	wire  n0liOO;
	wire  n0ll0i;
	wire  n0ll0l;
	wire  n0ll0O;
	wire  n0ll1i;
	wire  n0ll1l;
	wire  n0ll1O;
	wire  n0llii;
	wire  n0llil;
	wire  n0lliO;
	wire  n0llli;
	wire  n0llll;
	wire  n0lllO;
	wire  n0llOi;
	wire  n0llOl;
	wire  n0llOO;
	wire  n0lO0i;
	wire  n0lO0l;
	wire  n0lO0O;
	wire  n0lO1i;
	wire  n0lO1l;
	wire  n0lO1O;
	wire  n0lOii;
	wire  n0lOil;
	wire  n0lOiO;
	wire  n0lOli;
	wire  n0lOll;
	wire  n0lOlO;
	wire  n0lOOi;
	wire  n0lOOl;
	wire  n0lOOO;
	wire  n0O00i;
	wire  n0O00l;
	wire  n0O01i;
	wire  n0O01l;
	wire  n0O01O;
	wire  n0O0il;
	wire  n0O0iO;
	wire  n0O0li;
	wire  n0O0ll;
	wire  n0O0lO;
	wire  n0O0Oi;
	wire  n0O0Ol;
	wire  n0O0OO;
	wire  n0O10i;
	wire  n0O11i;
	wire  n0O11l;
	wire  n0O11O;
	wire  n0O1OO;
	wire  n0Oi0i;
	wire  n0Oi0l;
	wire  n0Oi0O;
	wire  n0Oi1i;
	wire  n0Oi1l;
	wire  n0Oi1O;
	wire  n0Oiii;
	wire  n0Oiil;
	wire  n0OiiO;
	wire  n0OilO;
	wire  n0OiOO;
	wire  n0Ol0i;
	wire  n0Ol0O;
	wire  n0Ol1i;
	wire  n0Ol1l;
	wire  n0Ol1O;
	wire  n0OO0i;
	wire  n0OO0l;
	wire  n0OO0O;
	wire  n0OO1l;
	wire  n0OO1O;

	initial
		n0liiO49 = 0;
	always @ ( posedge clk_2)
		  n0liiO49 <= n0liiO50;
	event n0liiO49_event;
	initial
		#1 ->n0liiO49_event;
	always @(n0liiO49_event)
		n0liiO49 <= {1{1'b1}};
	initial
		n0liiO50 = 0;
	always @ ( posedge clk_2)
		  n0liiO50 <= n0liiO49;
	initial
		n0lili47 = 0;
	always @ ( posedge clk_2)
		  n0lili47 <= n0lili48;
	event n0lili47_event;
	initial
		#1 ->n0lili47_event;
	always @(n0lili47_event)
		n0lili47 <= {1{1'b1}};
	initial
		n0lili48 = 0;
	always @ ( posedge clk_2)
		  n0lili48 <= n0lili47;
	initial
		n0O00O25 = 0;
	always @ ( posedge clk_2)
		  n0O00O25 <= n0O00O26;
	event n0O00O25_event;
	initial
		#1 ->n0O00O25_event;
	always @(n0O00O25_event)
		n0O00O25 <= {1{1'b1}};
	initial
		n0O00O26 = 0;
	always @ ( posedge clk_2)
		  n0O00O26 <= n0O00O25;
	initial
		n0O10l45 = 0;
	always @ ( posedge clk_2)
		  n0O10l45 <= n0O10l46;
	event n0O10l45_event;
	initial
		#1 ->n0O10l45_event;
	always @(n0O10l45_event)
		n0O10l45 <= {1{1'b1}};
	initial
		n0O10l46 = 0;
	always @ ( posedge clk_2)
		  n0O10l46 <= n0O10l45;
	initial
		n0O10O43 = 0;
	always @ ( posedge clk_2)
		  n0O10O43 <= n0O10O44;
	event n0O10O43_event;
	initial
		#1 ->n0O10O43_event;
	always @(n0O10O43_event)
		n0O10O43 <= {1{1'b1}};
	initial
		n0O10O44 = 0;
	always @ ( posedge clk_2)
		  n0O10O44 <= n0O10O43;
	initial
		n0O1ii41 = 0;
	always @ ( posedge clk_2)
		  n0O1ii41 <= n0O1ii42;
	event n0O1ii41_event;
	initial
		#1 ->n0O1ii41_event;
	always @(n0O1ii41_event)
		n0O1ii41 <= {1{1'b1}};
	initial
		n0O1ii42 = 0;
	always @ ( posedge clk_2)
		  n0O1ii42 <= n0O1ii41;
	initial
		n0O1il39 = 0;
	always @ ( posedge clk_2)
		  n0O1il39 <= n0O1il40;
	event n0O1il39_event;
	initial
		#1 ->n0O1il39_event;
	always @(n0O1il39_event)
		n0O1il39 <= {1{1'b1}};
	initial
		n0O1il40 = 0;
	always @ ( posedge clk_2)
		  n0O1il40 <= n0O1il39;
	initial
		n0O1iO37 = 0;
	always @ ( posedge clk_2)
		  n0O1iO37 <= n0O1iO38;
	event n0O1iO37_event;
	initial
		#1 ->n0O1iO37_event;
	always @(n0O1iO37_event)
		n0O1iO37 <= {1{1'b1}};
	initial
		n0O1iO38 = 0;
	always @ ( posedge clk_2)
		  n0O1iO38 <= n0O1iO37;
	initial
		n0O1li35 = 0;
	always @ ( posedge clk_2)
		  n0O1li35 <= n0O1li36;
	event n0O1li35_event;
	initial
		#1 ->n0O1li35_event;
	always @(n0O1li35_event)
		n0O1li35 <= {1{1'b1}};
	initial
		n0O1li36 = 0;
	always @ ( posedge clk_2)
		  n0O1li36 <= n0O1li35;
	initial
		n0O1ll33 = 0;
	always @ ( posedge clk_2)
		  n0O1ll33 <= n0O1ll34;
	event n0O1ll33_event;
	initial
		#1 ->n0O1ll33_event;
	always @(n0O1ll33_event)
		n0O1ll33 <= {1{1'b1}};
	initial
		n0O1ll34 = 0;
	always @ ( posedge clk_2)
		  n0O1ll34 <= n0O1ll33;
	initial
		n0O1lO31 = 0;
	always @ ( posedge clk_2)
		  n0O1lO31 <= n0O1lO32;
	event n0O1lO31_event;
	initial
		#1 ->n0O1lO31_event;
	always @(n0O1lO31_event)
		n0O1lO31 <= {1{1'b1}};
	initial
		n0O1lO32 = 0;
	always @ ( posedge clk_2)
		  n0O1lO32 <= n0O1lO31;
	initial
		n0O1Oi29 = 0;
	always @ ( posedge clk_2)
		  n0O1Oi29 <= n0O1Oi30;
	event n0O1Oi29_event;
	initial
		#1 ->n0O1Oi29_event;
	always @(n0O1Oi29_event)
		n0O1Oi29 <= {1{1'b1}};
	initial
		n0O1Oi30 = 0;
	always @ ( posedge clk_2)
		  n0O1Oi30 <= n0O1Oi29;
	initial
		n0O1Ol27 = 0;
	always @ ( posedge clk_2)
		  n0O1Ol27 <= n0O1Ol28;
	event n0O1Ol27_event;
	initial
		#1 ->n0O1Ol27_event;
	always @(n0O1Ol27_event)
		n0O1Ol27 <= {1{1'b1}};
	initial
		n0O1Ol28 = 0;
	always @ ( posedge clk_2)
		  n0O1Ol28 <= n0O1Ol27;
	initial
		n0Oili23 = 0;
	always @ ( posedge clk_2)
		  n0Oili23 <= n0Oili24;
	event n0Oili23_event;
	initial
		#1 ->n0Oili23_event;
	always @(n0Oili23_event)
		n0Oili23 <= {1{1'b1}};
	initial
		n0Oili24 = 0;
	always @ ( posedge clk_2)
		  n0Oili24 <= n0Oili23;
	initial
		n0OiOi21 = 0;
	always @ ( posedge clk_2)
		  n0OiOi21 <= n0OiOi22;
	event n0OiOi21_event;
	initial
		#1 ->n0OiOi21_event;
	always @(n0OiOi21_event)
		n0OiOi21 <= {1{1'b1}};
	initial
		n0OiOi22 = 0;
	always @ ( posedge clk_2)
		  n0OiOi22 <= n0OiOi21;
	initial
		n0Ol0l19 = 0;
	always @ ( posedge clk_2)
		  n0Ol0l19 <= n0Ol0l20;
	event n0Ol0l19_event;
	initial
		#1 ->n0Ol0l19_event;
	always @(n0Ol0l19_event)
		n0Ol0l19 <= {1{1'b1}};
	initial
		n0Ol0l20 = 0;
	always @ ( posedge clk_2)
		  n0Ol0l20 <= n0Ol0l19;
	initial
		n0Olii17 = 0;
	always @ ( posedge clk_2)
		  n0Olii17 <= n0Olii18;
	event n0Olii17_event;
	initial
		#1 ->n0Olii17_event;
	always @(n0Olii17_event)
		n0Olii17 <= {1{1'b1}};
	initial
		n0Olii18 = 0;
	always @ ( posedge clk_2)
		  n0Olii18 <= n0Olii17;
	initial
		n0Olil15 = 0;
	always @ ( posedge clk_2)
		  n0Olil15 <= n0Olil16;
	event n0Olil15_event;
	initial
		#1 ->n0Olil15_event;
	always @(n0Olil15_event)
		n0Olil15 <= {1{1'b1}};
	initial
		n0Olil16 = 0;
	always @ ( posedge clk_2)
		  n0Olil16 <= n0Olil15;
	initial
		n0OliO13 = 0;
	always @ ( posedge clk_2)
		  n0OliO13 <= n0OliO14;
	event n0OliO13_event;
	initial
		#1 ->n0OliO13_event;
	always @(n0OliO13_event)
		n0OliO13 <= {1{1'b1}};
	initial
		n0OliO14 = 0;
	always @ ( posedge clk_2)
		  n0OliO14 <= n0OliO13;
	initial
		n0Olll11 = 0;
	always @ ( posedge clk_2)
		  n0Olll11 <= n0Olll12;
	event n0Olll11_event;
	initial
		#1 ->n0Olll11_event;
	always @(n0Olll11_event)
		n0Olll11 <= {1{1'b1}};
	initial
		n0Olll12 = 0;
	always @ ( posedge clk_2)
		  n0Olll12 <= n0Olll11;
	initial
		n0OlOi10 = 0;
	always @ ( posedge clk_2)
		  n0OlOi10 <= n0OlOi9;
	initial
		n0OlOi9 = 0;
	always @ ( posedge clk_2)
		  n0OlOi9 <= n0OlOi10;
	event n0OlOi9_event;
	initial
		#1 ->n0OlOi9_event;
	always @(n0OlOi9_event)
		n0OlOi9 <= {1{1'b1}};
	initial
		n0OlOO7 = 0;
	always @ ( posedge clk_2)
		  n0OlOO7 <= n0OlOO8;
	event n0OlOO7_event;
	initial
		#1 ->n0OlOO7_event;
	always @(n0OlOO7_event)
		n0OlOO7 <= {1{1'b1}};
	initial
		n0OlOO8 = 0;
	always @ ( posedge clk_2)
		  n0OlOO8 <= n0OlOO7;
	initial
		n0OOii5 = 0;
	always @ ( posedge clk_2)
		  n0OOii5 <= n0OOii6;
	event n0OOii5_event;
	initial
		#1 ->n0OOii5_event;
	always @(n0OOii5_event)
		n0OOii5 <= {1{1'b1}};
	initial
		n0OOii6 = 0;
	always @ ( posedge clk_2)
		  n0OOii6 <= n0OOii5;
	initial
		n0OOiO3 = 0;
	always @ ( posedge clk_2)
		  n0OOiO3 <= n0OOiO4;
	event n0OOiO3_event;
	initial
		#1 ->n0OOiO3_event;
	always @(n0OOiO3_event)
		n0OOiO3 <= {1{1'b1}};
	initial
		n0OOiO4 = 0;
	always @ ( posedge clk_2)
		  n0OOiO4 <= n0OOiO3;
	initial
		n0OOll1 = 0;
	always @ ( posedge clk_2)
		  n0OOll1 <= n0OOll2;
	event n0OOll1_event;
	initial
		#1 ->n0OOll1_event;
	always @(n0OOll1_event)
		n0OOll1 <= {1{1'b1}};
	initial
		n0OOll2 = 0;
	always @ ( posedge clk_2)
		  n0OOll2 <= n0OOll1;
	initial
	begin
		ni00i = 0;
		ni01l = 0;
		ni1O1O = 0;
		niiilO = 0;
		niiiOi = 0;
		niiiOl = 0;
		niiiOO = 0;
		niil0i = 0;
		niil0l = 0;
		niil0O = 0;
		niil1i = 0;
		niil1l = 0;
		niil1O = 0;
		niilii = 0;
		niilil = 0;
		niiliO = 0;
		niilli = 0;
		niilll = 0;
		niillO = 0;
		niilOi = 0;
		niilOl = 0;
		niiO0i = 0;
		niiO1O = 0;
		nll00O = 0;
		nll0ii = 0;
	end
	always @ ( posedge clk_2 or  negedge wire_ni01O_CLRN)
	begin
		if (wire_ni01O_CLRN == 1'b0) 
		begin
			ni00i <= 0;
			ni01l <= 0;
			ni1O1O <= 0;
			niiilO <= 0;
			niiiOi <= 0;
			niiiOl <= 0;
			niiiOO <= 0;
			niil0i <= 0;
			niil0l <= 0;
			niil0O <= 0;
			niil1i <= 0;
			niil1l <= 0;
			niil1O <= 0;
			niilii <= 0;
			niilil <= 0;
			niiliO <= 0;
			niilli <= 0;
			niilll <= 0;
			niillO <= 0;
			niilOi <= 0;
			niilOl <= 0;
			niiO0i <= 0;
			niiO1O <= 0;
			nll00O <= 0;
			nll0ii <= 0;
		end
		else 
		begin
			ni00i <= wire_nii1O_dataout;
			ni01l <= wire_nii1l_dataout;
			ni1O1O <= wire_nil0il_dataout;
			niiilO <= wire_nil0iO_dataout;
			niiiOi <= wire_nil0li_dataout;
			niiiOl <= wire_nil0ll_dataout;
			niiiOO <= wire_nil0lO_dataout;
			niil0i <= wire_nili1i_dataout;
			niil0l <= wire_nili1l_dataout;
			niil0O <= wire_nili1O_dataout;
			niil1i <= wire_nil0Oi_dataout;
			niil1l <= wire_nil0Ol_dataout;
			niil1O <= wire_nil0OO_dataout;
			niilii <= wire_nili0i_dataout;
			niilil <= wire_nili0l_dataout;
			niiliO <= wire_nili0O_dataout;
			niilli <= wire_niliii_dataout;
			niilll <= wire_niliil_dataout;
			niillO <= wire_niliiO_dataout;
			niilOi <= wire_nilili_dataout;
			niilOl <= wire_nilill_dataout;
			niiO0i <= wire_niliOi_dataout;
			niiO1O <= wire_nililO_dataout;
			nll00O <= wire_nlll0l_dataout;
			nll0ii <= wire_nlll0O_dataout;
		end
	end
	assign
		wire_ni01O_CLRN = ((n0Ol0l20 ^ n0Ol0l19) & (~ soft_reset));
	initial
	begin
		n11ii = 0;
		ni00l = 0;
		ni00O = 0;
		ni01i = 0;
		ni0ii = 0;
		ni0il = 0;
		ni0iO = 0;
		ni0li = 0;
		ni0ll = 0;
		ni0lO = 0;
		ni0Oi = 0;
		ni0Ol = 0;
		nii1i = 0;
		niilOO = 0;
		niiO1i = 0;
		niiO1l = 0;
		niiOii = 0;
		niiOil = 0;
		niiOiO = 0;
		niiOli = 0;
		niiOll = 0;
		niiOlO = 0;
		niiOOi = 0;
		niiOOl = 0;
		niiOOO = 0;
		nil00i = 0;
		nil00l = 0;
		nil00O = 0;
		nil01i = 0;
		nil01l = 0;
		nil01O = 0;
		nil0ii = 0;
		nil10i = 0;
		nil10l = 0;
		nil10O = 0;
		nil11i = 0;
		nil11l = 0;
		nil11O = 0;
		nil1ii = 0;
		nil1il = 0;
		nil1iO = 0;
		nil1li = 0;
		nil1ll = 0;
		nil1lO = 0;
		nil1Oi = 0;
		nil1Ol = 0;
		nil1OO = 0;
		nl1Oii = 0;
		nll00l = 0;
		nll0il = 0;
		nll0iO = 0;
		nll0li = 0;
		nll0ll = 0;
		nll0lO = 0;
		nll0Oi = 0;
		nll0Ol = 0;
		nll0OO = 0;
		nlli0i = 0;
		nlli0l = 0;
		nlli0O = 0;
		nlli1i = 0;
		nlli1l = 0;
		nlli1O = 0;
		nlliii = 0;
		nlliil = 0;
		nlliiO = 0;
		nllili = 0;
		nllill = 0;
		nllilO = 0;
		nlliOi = 0;
		nlliOl = 0;
		nlliOO = 0;
		nlll0i = 0;
		nlll1i = 0;
		nlll1l = 0;
		nlll1O = 0;
	end
	always @ (clk_2 or wire_ni0OO_PRN or wire_ni0OO_CLRN)
	begin
		if (wire_ni0OO_PRN == 1'b0) 
		begin
			n11ii <= 1;
			ni00l <= 1;
			ni00O <= 1;
			ni01i <= 1;
			ni0ii <= 1;
			ni0il <= 1;
			ni0iO <= 1;
			ni0li <= 1;
			ni0ll <= 1;
			ni0lO <= 1;
			ni0Oi <= 1;
			ni0Ol <= 1;
			nii1i <= 1;
			niilOO <= 1;
			niiO1i <= 1;
			niiO1l <= 1;
			niiOii <= 1;
			niiOil <= 1;
			niiOiO <= 1;
			niiOli <= 1;
			niiOll <= 1;
			niiOlO <= 1;
			niiOOi <= 1;
			niiOOl <= 1;
			niiOOO <= 1;
			nil00i <= 1;
			nil00l <= 1;
			nil00O <= 1;
			nil01i <= 1;
			nil01l <= 1;
			nil01O <= 1;
			nil0ii <= 1;
			nil10i <= 1;
			nil10l <= 1;
			nil10O <= 1;
			nil11i <= 1;
			nil11l <= 1;
			nil11O <= 1;
			nil1ii <= 1;
			nil1il <= 1;
			nil1iO <= 1;
			nil1li <= 1;
			nil1ll <= 1;
			nil1lO <= 1;
			nil1Oi <= 1;
			nil1Ol <= 1;
			nil1OO <= 1;
			nl1Oii <= 1;
			nll00l <= 1;
			nll0il <= 1;
			nll0iO <= 1;
			nll0li <= 1;
			nll0ll <= 1;
			nll0lO <= 1;
			nll0Oi <= 1;
			nll0Ol <= 1;
			nll0OO <= 1;
			nlli0i <= 1;
			nlli0l <= 1;
			nlli0O <= 1;
			nlli1i <= 1;
			nlli1l <= 1;
			nlli1O <= 1;
			nlliii <= 1;
			nlliil <= 1;
			nlliiO <= 1;
			nllili <= 1;
			nllill <= 1;
			nllilO <= 1;
			nlliOi <= 1;
			nlliOl <= 1;
			nlliOO <= 1;
			nlll0i <= 1;
			nlll1i <= 1;
			nlll1l <= 1;
			nlll1O <= 1;
		end
		else if  (wire_ni0OO_CLRN == 1'b0) 
		begin
			n11ii <= 0;
			ni00l <= 0;
			ni00O <= 0;
			ni01i <= 0;
			ni0ii <= 0;
			ni0il <= 0;
			ni0iO <= 0;
			ni0li <= 0;
			ni0ll <= 0;
			ni0lO <= 0;
			ni0Oi <= 0;
			ni0Ol <= 0;
			nii1i <= 0;
			niilOO <= 0;
			niiO1i <= 0;
			niiO1l <= 0;
			niiOii <= 0;
			niiOil <= 0;
			niiOiO <= 0;
			niiOli <= 0;
			niiOll <= 0;
			niiOlO <= 0;
			niiOOi <= 0;
			niiOOl <= 0;
			niiOOO <= 0;
			nil00i <= 0;
			nil00l <= 0;
			nil00O <= 0;
			nil01i <= 0;
			nil01l <= 0;
			nil01O <= 0;
			nil0ii <= 0;
			nil10i <= 0;
			nil10l <= 0;
			nil10O <= 0;
			nil11i <= 0;
			nil11l <= 0;
			nil11O <= 0;
			nil1ii <= 0;
			nil1il <= 0;
			nil1iO <= 0;
			nil1li <= 0;
			nil1ll <= 0;
			nil1lO <= 0;
			nil1Oi <= 0;
			nil1Ol <= 0;
			nil1OO <= 0;
			nl1Oii <= 0;
			nll00l <= 0;
			nll0il <= 0;
			nll0iO <= 0;
			nll0li <= 0;
			nll0ll <= 0;
			nll0lO <= 0;
			nll0Oi <= 0;
			nll0Ol <= 0;
			nll0OO <= 0;
			nlli0i <= 0;
			nlli0l <= 0;
			nlli0O <= 0;
			nlli1i <= 0;
			nlli1l <= 0;
			nlli1O <= 0;
			nlliii <= 0;
			nlliil <= 0;
			nlliiO <= 0;
			nllili <= 0;
			nllill <= 0;
			nllilO <= 0;
			nlliOi <= 0;
			nlliOl <= 0;
			nlliOO <= 0;
			nlll0i <= 0;
			nlll1i <= 0;
			nlll1l <= 0;
			nlll1O <= 0;
		end
		else if  (rbist_clr_rx == 1'b0) 
		if (clk_2 != ni0OO_clk_prev && clk_2 == 1'b1) 
		begin
			n11ii <= ni01i;
			ni00l <= wire_n11lO_o;
			ni00O <= wire_nii0i_dataout;
			ni01i <= sync_status;
			ni0ii <= wire_nii0l_dataout;
			ni0il <= wire_nii0O_dataout;
			ni0iO <= wire_niiii_dataout;
			ni0li <= wire_niiil_dataout;
			ni0ll <= wire_n101i_o;
			ni0lO <= wire_n101l_o;
			ni0Oi <= wire_n101O_o;
			ni0Ol <= wire_n100i_o;
			nii1i <= wire_n100l_o;
			niilOO <= niiO1i;
			niiO1i <= sync_status;
			niiO1l <= wire_ni1iOi_o;
			niiOii <= wire_niO1Ol_dataout;
			niiOil <= wire_niO1OO_dataout;
			niiOiO <= wire_niO01i_dataout;
			niiOli <= wire_niO01l_dataout;
			niiOll <= wire_niO01O_dataout;
			niiOlO <= wire_niO00i_dataout;
			niiOOi <= wire_niO00l_dataout;
			niiOOl <= wire_niO10l_dataout;
			niiOOO <= wire_niO10O_dataout;
			nil00i <= wire_ni1l1i_o;
			nil00l <= wire_ni1l1l_o;
			nil00O <= wire_ni1l1O_o;
			nil01i <= nil00l;
			nil01l <= nil00O;
			nil01O <= nil0ii;
			nil0ii <= wire_ni1l0i_o;
			nil10i <= wire_niO1li_dataout;
			nil10l <= wire_niO1ll_dataout;
			nil10O <= wire_niO1lO_dataout;
			nil11i <= wire_niO1ii_dataout;
			nil11l <= wire_niO1il_dataout;
			nil11O <= wire_niO1iO_dataout;
			nil1ii <= wire_niO00O_dataout;
			nil1il <= wire_niO0ii_dataout;
			nil1iO <= wire_niO0il_dataout;
			nil1li <= wire_niO0iO_dataout;
			nil1ll <= wire_niO0li_dataout;
			nil1lO <= wire_niO0ll_dataout;
			nil1Oi <= wire_niO0lO_dataout;
			nil1Ol <= wire_niO0Oi_dataout;
			nil1OO <= nil00i;
			nl1Oii <= nll00l;
			nll00l <= sync_status;
			nll0il <= wire_nl011i_o;
			nll0iO <= wire_nlllii_dataout;
			nll0li <= wire_nlllil_dataout;
			nll0ll <= wire_nllliO_dataout;
			nll0lO <= wire_nlllli_dataout;
			nll0Oi <= wire_nlllll_dataout;
			nll0Ol <= wire_nllllO_dataout;
			nll0OO <= wire_nllO0l_dataout;
			nlli0i <= wire_nllOli_dataout;
			nlli0l <= wire_nllOll_dataout;
			nlli0O <= wire_nllOlO_dataout;
			nlli1i <= wire_nllO0O_dataout;
			nlli1l <= wire_nllOii_dataout;
			nlli1O <= wire_nllOiO_dataout;
			nlliii <= wire_nlO11O_dataout;
			nlliil <= wire_nlO10i_dataout;
			nlliiO <= wire_nlO10l_dataout;
			nllili <= wire_nlO10O_dataout;
			nllill <= wire_nlO1ii_dataout;
			nllilO <= wire_nlO1il_dataout;
			nlliOi <= wire_nlO1iO_dataout;
			nlliOl <= wire_nlO1li_dataout;
			nlliOO <= wire_nlO1ll_dataout;
			nlll0i <= wire_nl01ii_o;
			nlll1i <= wire_nl010i_o;
			nlll1l <= wire_nl010l_o;
			nlll1O <= wire_nl010O_o;
		end
		ni0OO_clk_prev <= clk_2;
	end
	assign
		wire_ni0OO_CLRN = ((n0Olil16 ^ n0Olil15) & (~ soft_reset)),
		wire_ni0OO_PRN = (n0Olii18 ^ n0Olii17);
	initial
	begin
		niiO0O = 0;
	end
	always @ (clk_2 or wire_niiO0l_PRN or wire_niiO0l_CLRN)
	begin
		if (wire_niiO0l_PRN == 1'b0) 
		begin
			niiO0O <= 1;
		end
		else if  (wire_niiO0l_CLRN == 1'b0) 
		begin
			niiO0O <= 0;
		end
		else if  (rbist_clr_rx == 1'b0) 
		if (clk_2 != niiO0l_clk_prev && clk_2 == 1'b1) 
		begin
			niiO0O <= wire_niO1Oi_dataout;
		end
		niiO0l_clk_prev <= clk_2;
	end
	assign
		wire_niiO0l_CLRN = (n0lili48 ^ n0lili47),
		wire_niiO0l_PRN = ((n0liiO50 ^ n0liiO49) & (~ soft_reset));
	or(wire_n000i_dataout, ni01l, (~ n0O0li));
	or(wire_n000l_dataout, ni00i, (~ n0O0li));
	or(wire_n000O_dataout, wire_n00lO_dataout, (~ n0O0li));
	or(wire_n001i_dataout, nii1i, n0Oiil);
	and(wire_n001l_dataout, wire_n00ll_dataout, ~((~ n0O0li)));
	and(wire_n001O_dataout, wire_n0i1l_dataout, ~((~ n0O0li)));
	assign		wire_n00i_dataout = (n0OO1O === 1'b1) ? nlll0i : wire_n0iO_dataout;
	and(wire_n00ii_dataout, wire_n00Oi_dataout, ~((~ n0O0li)));
	or(wire_n00il_dataout, wire_n00Ol_dataout, (~ n0O0li));
	and(wire_n00iO_dataout, wire_n00OO_dataout, ~((~ n0O0li)));
	and(wire_n00l_dataout, wire_n0li_dataout, ~(n0OO1O));
	or(wire_n00li_dataout, wire_n0i1i_dataout, (~ n0O0li));
	and(wire_n00ll_dataout, (~ n0O0ll), n0OO0l);
	or(wire_n00lO_dataout, wire_n1Oii_dataout, ~(n0OO0l));
	and(wire_n00O_dataout, ni0ll, n0OO0i);
	or(wire_n00Oi_dataout, wire_n1Oil_dataout, ~(n0OO0l));
	or(wire_n00Ol_dataout, wire_n1OiO_dataout, ~(n0OO0l));
	or(wire_n00OO_dataout, wire_n1Oli_dataout, ~(n0OO0l));
	and(wire_n010i_dataout, wire_n01iO_dataout, ~(n0Ol1i));
	and(wire_n010l_dataout, wire_n01li_dataout, ~(n0Ol1i));
	or(wire_n010O_dataout, wire_n01ll_dataout, n0Ol1i);
	or(wire_n011i_dataout, wire_n010O_dataout, n0Ol1O);
	or(wire_n011l_dataout, wire_n01ii_dataout, n0Ol1i);
	and(wire_n011O_dataout, wire_n01il_dataout, ~(n0Ol1i));
	assign		wire_n01i_dataout = (n0OO1O === 1'b1) ? nlll1i : wire_n00O_dataout;
	and(wire_n01ii_dataout, wire_n01lO_dataout, ~(n0OiOO));
	or(wire_n01il_dataout, wire_n01Oi_dataout, n0OiOO);
	and(wire_n01iO_dataout, wire_n01Ol_dataout, ~(n0OiOO));
	assign		wire_n01l_dataout = (n0OO1O === 1'b1) ? nlll1l : wire_n0ii_dataout;
	and(wire_n01li_dataout, wire_n01OO_dataout, ~(n0OiOO));
	or(wire_n01ll_dataout, wire_n001i_dataout, n0OiOO);
	or(wire_n01lO_dataout, ni0ll, n0Oiil);
	assign		wire_n01O_dataout = (n0OO1O === 1'b1) ? nlll1O : wire_n0il_dataout;
	or(wire_n01Oi_dataout, ni0lO, n0Oiil);
	and(wire_n01Ol_dataout, ni0Oi, ~(n0Oiil));
	and(wire_n01OO_dataout, ni0Ol, ~(n0Oiil));
	assign		wire_n0i_dataout = (n0OO0O === 1'b1) ? rxd[33] : rxd[17];
	or(wire_n0i0i_dataout, ni00i, (~ n0O0lO));
	or(wire_n0i0l_dataout, ni01l, (~ n0O0Oi));
	or(wire_n0i0O_dataout, ni00i, (~ n0O0Oi));
	and(wire_n0i1i_dataout, wire_n1Oll_dataout, n0OO0l);
	and(wire_n0i1l_dataout, n0O0ll, n0OO0l);
	or(wire_n0i1O_dataout, ni01l, (~ n0O0lO));
	and(wire_n0ii_dataout, ni0lO, n0OO0i);
	or(wire_n0iii_dataout, (~ n0OO0l), (~ n0O0Oi));
	and(wire_n0iil_dataout, n0OO0l, ~((~ n0O0Oi)));
	or(wire_n0iiO_dataout, ni01l, (~ n0O0Ol));
	and(wire_n0il_dataout, ni0Oi, n0OO0i);
	or(wire_n0ili_dataout, ni00i, (~ n0O0Ol));
	or(wire_n0ill_dataout, ni01l, (~ n0O0OO));
	or(wire_n0ilO_dataout, ni00i, (~ n0O0OO));
	and(wire_n0iO_dataout, ni0Ol, n0OO0i);
	or(wire_n0iOi_dataout, (~ n0OO0l), (~ n0O0OO));
	and(wire_n0iOl_dataout, (~ n0OO0l), ~((~ n0O0OO)));
	or(wire_n0iOO_dataout, n0OO0l, (~ n0O0OO));
	assign		wire_n0l_dataout = (n0OO0O === 1'b1) ? rxd[34] : rxd[18];
	or(wire_n0l0i_dataout, ni00i, (~ n0Oi1l));
	or(wire_n0l0l_dataout, (~ n0OO0l), (~ n0Oi1l));
	and(wire_n0l0O_dataout, n0OO0l, ~((~ n0Oi1l)));
	or(wire_n0l1i_dataout, ni01l, (~ n0Oi1i));
	or(wire_n0l1l_dataout, ni00i, (~ n0Oi1i));
	or(wire_n0l1O_dataout, ni01l, (~ n0Oi1l));
	and(wire_n0li_dataout, nii1i, n0OO0i);
	or(wire_n0lii_dataout, ni01l, (~ n0Oi1O));
	or(wire_n0lil_dataout, ni00i, (~ n0Oi1O));
	or(wire_n0liO_dataout, ni01l, (~ n0Oi0i));
	or(wire_n0lli_dataout, ni00i, (~ n0Oi0i));
	and(wire_n0lll_dataout, (~ n0OO0l), ~((~ n0Oi0i)));
	or(wire_n0llO_dataout, (~ n0OO0l), (~ n0Oi0i));
	and(wire_n0lOi_dataout, n0OO0l, ~((~ n0Oi0i)));
	or(wire_n0lOl_dataout, ni01l, (~ n0Oi0l));
	or(wire_n0lOO_dataout, ni00i, (~ n0Oi0l));
	assign		wire_n0O_dataout = (n0OO0O === 1'b1) ? rxd[35] : rxd[19];
	and(wire_n0O0i_dataout, n0OO0l, ~((~ n0Oi0O)));
	and(wire_n0O0l_dataout, ni0ll, ~((~ n0Oiil)));
	and(wire_n0O0O_dataout, ni0lO, ~((~ n0Oiil)));
	or(wire_n0O1i_dataout, ni01l, (~ n0Oi0O));
	or(wire_n0O1l_dataout, ni00i, (~ n0Oi0O));
	or(wire_n0O1O_dataout, (~ n0OO0l), (~ n0Oi0O));
	and(wire_n0Oi_dataout, ni1O1O, n0OO1l);
	or(wire_n0Oii_dataout, ni0Oi, (~ n0Oiil));
	and(wire_n0Oil_dataout, ni0Ol, ~((~ n0Oiil)));
	and(wire_n0OiO_dataout, nii1i, ~((~ n0Oiil)));
	and(wire_n0Ol_dataout, niiilO, n0OO1l);
	and(wire_n0Oli_dataout, wire_n0OOO_dataout, ~(n0Ol1l));
	assign		wire_n0Oll_dataout = (n0Ol1l === 1'b1) ? (~ n0OO0l) : wire_ni11i_dataout;
	assign		wire_n0OlO_dataout = (n0Ol1l === 1'b1) ? n0OO0l : wire_ni11l_dataout;
	and(wire_n0OO_dataout, niiiOi, n0OO1l);
	and(wire_n0OOi_dataout, wire_ni11O_dataout, ~(n0Ol1l));
	and(wire_n0OOl_dataout, wire_ni10i_dataout, ~(n0Ol1l));
	and(wire_n0OOO_dataout, wire_ni10l_dataout, ~(n0OiiO));
	and(wire_n100O_dataout, ni00i, ~((~ wire_ni_dataout)));
	and(wire_n10ii_dataout, ni01l, ~((~ wire_ni_dataout)));
	and(wire_n10il_dataout, ni0ll, ~((~ wire_ni_dataout)));
	and(wire_n10iO_dataout, ni0lO, ~((~ wire_ni_dataout)));
	and(wire_n10li_dataout, ni0Oi, ~((~ wire_ni_dataout)));
	and(wire_n10ll_dataout, ni0Ol, ~((~ wire_ni_dataout)));
	and(wire_n10lO_dataout, nii1i, ~((~ wire_ni_dataout)));
	or(wire_n10Oi_dataout, ni00l, ~(n0O1OO));
	or(wire_n10Ol_dataout, wire_n1i1l_dataout, n0O1OO);
	or(wire_n10OO_dataout, ni00i, n0O1OO);
	or(wire_n1i0i_dataout, ni00l, ~((~ n0O01l)));
	or(wire_n1i0l_dataout, wire_n1i1l_dataout, (~ n0O01l));
	or(wire_n1i0O_dataout, ni00i, (~ n0O01l));
	or(wire_n1i1i_dataout, ni00l, n0O1OO);
	or(wire_n1i1l_dataout, ni01l, ni00l);
	or(wire_n1iii_dataout, ni00l, (~ n0O01l));
	or(wire_n1iil_dataout, ni00l, ~((~ n0O01O)));
	or(wire_n1iiO_dataout, wire_n1i1l_dataout, (~ n0O01O));
	or(wire_n1ili_dataout, ni00i, (~ n0O01O));
	or(wire_n1ill_dataout, ni00l, (~ n0O01O));
	or(wire_n1ilO_dataout, ni00l, ~((~ n0O00i)));
	or(wire_n1iOi_dataout, wire_n1i1l_dataout, (~ n0O00i));
	or(wire_n1iOl_dataout, ni00i, (~ n0O00i));
	or(wire_n1iOO_dataout, ni00l, (~ n0O00i));
	assign		wire_n1l_dataout = (n0OO0O === 1'b1) ? rxc[2] : rxc[1];
	or(wire_n1l0i_dataout, (~ n0O0il), n0OO0l);
	or(wire_n1l0l_dataout, wire_n1lll_dataout, ~(n0OO0l));
	or(wire_n1l0O_dataout, ni01l, (~ n0O0il));
	assign		wire_n1l1i_dataout = (n0OO0l === 1'b1) ? wire_n1lil_dataout : ni00l;
	assign		wire_n1l1l_dataout = (n0OO0l === 1'b1) ? wire_n1liO_dataout : wire_n1l0O_dataout;
	assign		wire_n1l1O_dataout = (n0OO0l === 1'b1) ? wire_n1lli_dataout : wire_n1lii_dataout;
	or(wire_n1lii_dataout, ni00i, (~ n0O0il));
	or(wire_n1lil_dataout, ni00l, ~(n0O00l));
	or(wire_n1liO_dataout, wire_n1i1l_dataout, n0O00l);
	assign		wire_n1ll_dataout = (n0OO1l === 1'b1) ? nil00i : wire_n01i_dataout;
	or(wire_n1lli_dataout, ni00i, n0O00l);
	or(wire_n1lll_dataout, ni00l, n0O00l);
	assign		wire_n1lO_dataout = (n0OO1l === 1'b1) ? nil00l : wire_n01l_dataout;
	and(wire_n1lOi_dataout, (~ n0O0ll), ~((~ n0O0iO)));
	and(wire_n1lOl_dataout, n0O0ll, ~((~ n0O0iO)));
	or(wire_n1lOO_dataout, ni01l, (~ n0O0iO));
	assign		wire_n1O_dataout = (n0OO0O === 1'b1) ? rxd[32] : rxd[16];
	or(wire_n1O0i_dataout, wire_n1OiO_dataout, (~ n0O0iO));
	and(wire_n1O0l_dataout, wire_n1Oli_dataout, ~((~ n0O0iO)));
	or(wire_n1O0O_dataout, wire_n1Oll_dataout, (~ n0O0iO));
	or(wire_n1O1i_dataout, ni00i, (~ n0O0iO));
	or(wire_n1O1l_dataout, wire_n1Oii_dataout, (~ n0O0iO));
	and(wire_n1O1O_dataout, wire_n1Oil_dataout, ~((~ n0O0iO)));
	assign		wire_n1Oi_dataout = (n0OO1l === 1'b1) ? nil00O : wire_n01O_dataout;
	and(wire_n1Oii_dataout, wire_n1OlO_dataout, n0O0ll);
	and(wire_n1Oil_dataout, wire_n1OOi_dataout, n0O0ll);
	or(wire_n1OiO_dataout, wire_n1OOl_dataout, ~(n0O0ll));
	assign		wire_n1Ol_dataout = (n0OO1l === 1'b1) ? nil0ii : wire_n00i_dataout;
	and(wire_n1Oli_dataout, wire_n1OOO_dataout, n0O0ll);
	and(wire_n1Oll_dataout, wire_n011i_dataout, n0O0ll);
	and(wire_n1OlO_dataout, wire_n011l_dataout, ~(n0Ol1O));
	and(wire_n1OO_dataout, wire_n00l_dataout, ~(n0OO1l));
	and(wire_n1OOi_dataout, wire_n011O_dataout, ~(n0Ol1O));
	and(wire_n1OOl_dataout, wire_n010i_dataout, ~(n0Ol1O));
	and(wire_n1OOO_dataout, wire_n010l_dataout, ~(n0Ol1O));
	and(wire_ni_dataout, rbisten_rx, (((~ rbist_sel[0]) & rbist_sel[1]) & (n0OOiO4 ^ n0OOiO3)));
	assign		wire_ni000l_dataout = (n0OO0l === 1'b1) ? wire_ni00lO_dataout : wire_ni00iO_dataout;
	assign		wire_ni000O_dataout = (n0OO0l === 1'b1) ? wire_ni00Oi_dataout : wire_ni00li_dataout;
	or(wire_ni001l_dataout, niiO1O, n0l1il);
	or(wire_ni001O_dataout, niiO0i, n0l1il);
	or(wire_ni00ii_dataout, n0l1li, n0OO0l);
	assign		wire_ni00il_dataout = (n0OO0l === 1'b1) ? n0l1lO : n0l1li;
	or(wire_ni00iO_dataout, niiO1O, n0l1li);
	or(wire_ni00li_dataout, niiO0i, n0l1li);
	or(wire_ni00lO_dataout, niiO1O, n0l1lO);
	or(wire_ni00Oi_dataout, niiO0i, n0l1lO);
	or(wire_ni00OO_dataout, niiO1O, n0l1Ol);
	or(wire_ni010i_dataout, niiO0i, n0l11l);
	assign		wire_ni010O_dataout = (n0OO0l === 1'b1) ? wire_ni01Ol_dataout : wire_ni01ll_dataout;
	or(wire_ni011i_dataout, niiO1l, n0iOOO);
	or(wire_ni011O_dataout, niiO1O, n0l11l);
	assign		wire_ni01ii_dataout = (n0OO0l === 1'b1) ? wire_ni01OO_dataout : wire_ni01lO_dataout;
	or(wire_ni01il_dataout, n0l10i, n0OO0l);
	assign		wire_ni01iO_dataout = (n0OO0l === 1'b1) ? (~ n0l10O) : (~ n0l10i);
	assign		wire_ni01li_dataout = (n0OO0l === 1'b1) ? n0l10O : n0l10i;
	or(wire_ni01ll_dataout, niiO1O, n0l10i);
	or(wire_ni01lO_dataout, niiO0i, n0l10i);
	or(wire_ni01Ol_dataout, niiO1O, n0l10O);
	or(wire_ni01OO_dataout, niiO0i, n0l10O);
	and(wire_ni0i_dataout, niil1l, n0OO1l);
	assign		wire_ni0i0i_dataout = (n0OO0l === 1'b1) ? wire_ni0ilO_dataout : wire_ni0iiO_dataout;
	or(wire_ni0i0l_dataout, n0l01i, n0OO0l);
	assign		wire_ni0i0O_dataout = (n0OO0l === 1'b1) ? (~ n0l01O) : (~ n0l01i);
	or(wire_ni0i1i_dataout, niiO0i, n0l1Ol);
	assign		wire_ni0i1O_dataout = (n0OO0l === 1'b1) ? wire_ni0ill_dataout : wire_ni0iil_dataout;
	assign		wire_ni0iii_dataout = (n0OO0l === 1'b1) ? n0l01O : n0l01i;
	or(wire_ni0iil_dataout, niiO1O, n0l01i);
	or(wire_ni0iiO_dataout, niiO0i, n0l01i);
	or(wire_ni0ill_dataout, niiO1O, n0l01O);
	or(wire_ni0ilO_dataout, niiO0i, n0l01O);
	or(wire_ni0iOl_dataout, niiO1O, n0l00l);
	or(wire_ni0iOO_dataout, niiO0i, n0l00l);
	and(wire_ni0l_dataout, niil1O, n0OO1l);
	or(wire_ni0l0i_dataout, n0l0ii, n0OO0l);
	assign		wire_ni0l0l_dataout = (n0OO0l === 1'b1) ? n0l0li : n0l0ii;
	or(wire_ni0l0O_dataout, niiO1O, n0l0ii);
	assign		wire_ni0l1l_dataout = (n0OO0l === 1'b1) ? wire_ni0liO_dataout : wire_ni0l0O_dataout;
	assign		wire_ni0l1O_dataout = (n0OO0l === 1'b1) ? wire_ni0lli_dataout : wire_ni0lii_dataout;
	or(wire_ni0lii_dataout, niiO0i, n0l0ii);
	or(wire_ni0liO_dataout, niiO1O, n0l0li);
	or(wire_ni0lli_dataout, niiO0i, n0l0li);
	or(wire_ni0llO_dataout, niiO1O, n0li1i);
	or(wire_ni0lOi_dataout, niiO0i, n0li1i);
	or(wire_ni0lOl_dataout, wire_ni0O1O_dataout, n0li1i);
	and(wire_ni0lOO_dataout, wire_ni0O0i_dataout, ~(n0li1i));
	and(wire_ni0O_dataout, niil0i, n0OO1l);
	or(wire_ni0O0i_dataout, wire_ni0Oil_dataout, n0l0Ol);
	and(wire_ni0O0l_dataout, wire_ni0OiO_dataout, ~(n0l0Ol));
	and(wire_ni0O0O_dataout, wire_ni0Oli_dataout, ~(n0l0Ol));
	or(wire_ni0O1i_dataout, wire_ni0O0l_dataout, n0li1i);
	or(wire_ni0O1l_dataout, wire_ni0O0O_dataout, n0li1i);
	or(wire_ni0O1O_dataout, wire_ni0Oii_dataout, n0l0Ol);
	or(wire_ni0Oii_dataout, nil00i, n0l0Oi);
	or(wire_ni0Oil_dataout, nil00l, n0l0Oi);
	and(wire_ni0OiO_dataout, nil00O, ~(n0l0Oi));
	and(wire_ni0Oli_dataout, nil0ii, ~(n0l0Oi));
	or(wire_ni0OOi_dataout, wire_nii10l_dataout, n0liii);
	or(wire_ni0OOl_dataout, niiO1O, n0liii);
	or(wire_ni0OOO_dataout, niiO0i, n0liii);
	and(wire_ni10i_dataout, wire_ni1iO_dataout, ~(n0OiiO));
	assign		wire_ni10l_dataout = (n0Oiii === 1'b1) ? (~ n0OO0l) : ni0ll;
	assign		wire_ni10O_dataout = (n0Oiii === 1'b1) ? (~ n0OO0l) : ni0lO;
	assign		wire_ni11i_dataout = (n0OiiO === 1'b1) ? (~ n0OO0l) : wire_ni10O_dataout;
	assign		wire_ni11l_dataout = (n0OiiO === 1'b1) ? n0OO0l : wire_ni1ii_dataout;
	and(wire_ni11O_dataout, wire_ni1il_dataout, ~(n0OiiO));
	and(wire_ni1i_dataout, niiiOl, n0OO1l);
	assign		wire_ni1ii_dataout = (n0Oiii === 1'b1) ? n0OO0l : ni0Oi;
	and(wire_ni1il_dataout, ni0Ol, ~(n0Oiii));
	and(wire_ni1iO_dataout, nii1i, ~(n0Oiii));
	and(wire_ni1l_dataout, niiiOO, n0OO1l);
	and(wire_ni1l0l_dataout, niiO1l, ~((~ wire_nO_dataout)));
	and(wire_ni1l0O_dataout, niiO1O, ~((~ wire_nO_dataout)));
	and(wire_ni1lii_dataout, niiO0i, ~((~ wire_nO_dataout)));
	and(wire_ni1lil_dataout, nil00i, ~((~ wire_nO_dataout)));
	and(wire_ni1liO_dataout, nil00l, ~((~ wire_nO_dataout)));
	and(wire_ni1lli_dataout, nil00O, ~((~ wire_nO_dataout)));
	and(wire_ni1lll_dataout, nil0ii, ~((~ wire_nO_dataout)));
	or(wire_ni1llO_dataout, niiO1l, ~(n0iOll));
	or(wire_ni1lOi_dataout, niiO1O, n0iOll);
	or(wire_ni1lOl_dataout, wire_ni1O1i_dataout, n0iOll);
	or(wire_ni1lOO_dataout, niiO1l, n0iOll);
	and(wire_ni1O_dataout, niil1i, n0OO1l);
	assign		wire_ni1O0i_dataout = (n0OO0l === 1'b1) ? wire_ni1OOi_dataout : niiO1l;
	assign		wire_ni1O0l_dataout = (n0OO0l === 1'b1) ? n0iOOO : n0iOOi;
	assign		wire_ni1O0O_dataout = (n0OO0l === 1'b1) ? wire_ni1OOl_dataout : wire_ni1Oli_dataout;
	or(wire_ni1O1i_dataout, niiO0i, niiO1l);
	assign		wire_ni1Oii_dataout = (n0OO0l === 1'b1) ? wire_ni1OOO_dataout : wire_ni1Oll_dataout;
	or(wire_ni1Oil_dataout, n0iOOi, n0OO0l);
	or(wire_ni1OiO_dataout, wire_ni011i_dataout, ~(n0OO0l));
	or(wire_ni1Oli_dataout, niiO1O, n0iOOi);
	or(wire_ni1Oll_dataout, niiO0i, n0iOOi);
	or(wire_ni1OOi_dataout, niiO1l, ~(n0iOOO));
	or(wire_ni1OOl_dataout, niiO1O, n0iOOO);
	or(wire_ni1OOO_dataout, wire_ni1O1i_dataout, n0iOOO);
	assign		wire_nii_dataout = (n0OO0O === 1'b1) ? rxd[36] : rxd[20];
	or(wire_nii00i_dataout, nil00i, n0liil);
	and(wire_nii00l_dataout, nil00l, ~(n0liil));
	and(wire_nii00O_dataout, nil00O, ~(n0liil));
	assign		wire_nii0i_dataout = (wire_n11il_o === 1'b1) ? wire_niiOl_o[0] : wire_niiiO_dataout;
	and(wire_nii0ii_dataout, nil0ii, ~(n0liil));
	assign		wire_nii0l_dataout = (wire_n11il_o === 1'b1) ? wire_niiOl_o[1] : wire_niili_dataout;
	or(wire_nii0ll_dataout, wire_niOi0i_dataout, ~(wire_nii0Ol_o[2]));
	assign		wire_nii0O_dataout = (wire_n11il_o === 1'b1) ? wire_niiOl_o[2] : wire_niill_dataout;
	or(wire_nii0Oi_dataout, wire_niOi0O_dataout, ~(wire_nii0Ol_o[2]));
	or(wire_nii10i_dataout, wire_nii1iO_dataout, n0liii);
	and(wire_nii10l_dataout, (~ n0li1O), ~(n0li0l));
	and(wire_nii10O_dataout, wire_nii1li_dataout, ~(n0li0l));
	or(wire_nii11i_dataout, wire_nii10O_dataout, n0liii);
	and(wire_nii11l_dataout, wire_nii1ii_dataout, ~(n0liii));
	or(wire_nii11O_dataout, wire_nii1il_dataout, n0liii);
	or(wire_nii1ii_dataout, wire_nii1ll_dataout, n0li0l);
	and(wire_nii1il_dataout, wire_nii1lO_dataout, ~(n0li0l));
	and(wire_nii1iO_dataout, wire_nii1Oi_dataout, ~(n0li0l));
	and(wire_nii1l_dataout, wire_n11OO_o, ~(rbist_clr_rx));
	and(wire_nii1li_dataout, nil00i, ~(n0li1O));
	or(wire_nii1ll_dataout, nil00l, n0li1O);
	and(wire_nii1lO_dataout, nil00O, ~(n0li1O));
	and(wire_nii1O_dataout, wire_n11Ol_o, ~(rbist_clr_rx));
	and(wire_nii1Oi_dataout, nil0ii, ~(n0li1O));
	and(wire_niii_dataout, niil0l, n0OO1l);
	assign		wire_niiii_dataout = (wire_n11il_o === 1'b1) ? wire_niiOl_o[3] : wire_niilO_dataout;
	assign		wire_niiil_dataout = (wire_n11il_o === 1'b1) ? wire_niiOl_o[4] : wire_niiOi_dataout;
	and(wire_niiiO_dataout, ni00O, ~(wire_n11iO_o));
	and(wire_niil_dataout, niil0O, n0OO1l);
	and(wire_niili_dataout, ni0ii, ~(wire_n11iO_o));
	and(wire_niill_dataout, ni0il, ~(wire_n11iO_o));
	and(wire_niilO_dataout, ni0iO, ~(wire_n11iO_o));
	and(wire_niiO_dataout, niilii, n0OO1l);
	and(wire_niiOi_dataout, ni0li, ~(wire_n11iO_o));
	assign		wire_nil_dataout = (n0OO0O === 1'b1) ? rxd[37] : rxd[21];
	and(wire_nil0il_dataout, wire_niliOl_dataout, ~(rbist_clr_rx));
	and(wire_nil0iO_dataout, wire_niliOO_dataout, ~(rbist_clr_rx));
	and(wire_nil0li_dataout, wire_nill1i_dataout, ~(rbist_clr_rx));
	and(wire_nil0ll_dataout, wire_nill1l_dataout, ~(rbist_clr_rx));
	and(wire_nil0lO_dataout, wire_nill1O_dataout, ~(rbist_clr_rx));
	and(wire_nil0Oi_dataout, wire_nill0i_dataout, ~(rbist_clr_rx));
	and(wire_nil0Ol_dataout, wire_nill0l_dataout, ~(rbist_clr_rx));
	and(wire_nil0OO_dataout, wire_nill0O_dataout, ~(rbist_clr_rx));
	and(wire_nili_dataout, niilil, n0OO1l);
	and(wire_nili0i_dataout, wire_nillli_dataout, ~(rbist_clr_rx));
	and(wire_nili0l_dataout, wire_nillll_dataout, ~(rbist_clr_rx));
	and(wire_nili0O_dataout, wire_nilllO_dataout, ~(rbist_clr_rx));
	and(wire_nili1i_dataout, wire_nillii_dataout, ~(rbist_clr_rx));
	and(wire_nili1l_dataout, wire_nillil_dataout, ~(rbist_clr_rx));
	and(wire_nili1O_dataout, wire_nilliO_dataout, ~(rbist_clr_rx));
	and(wire_niliii_dataout, wire_nillOi_dataout, ~(rbist_clr_rx));
	and(wire_niliil_dataout, wire_nillOl_dataout, ~(rbist_clr_rx));
	and(wire_niliiO_dataout, wire_nillOO_dataout, ~(rbist_clr_rx));
	and(wire_nilili_dataout, wire_nilO1i_dataout, ~(rbist_clr_rx));
	and(wire_nilill_dataout, wire_ni1ilO_o, ~(rbist_clr_rx));
	and(wire_nililO_dataout, wire_ni1iOl_o, ~(rbist_clr_rx));
	and(wire_niliOi_dataout, wire_ni1iOO_o, ~(rbist_clr_rx));
	and(wire_niliOl_dataout, wire_nilO1l_dataout, ~((~ wire_nO_dataout)));
	and(wire_niliOO_dataout, wire_nilO1O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill_dataout, niiliO, n0OO1l);
	and(wire_nill0i_dataout, wire_nilOii_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill0l_dataout, wire_nilOil_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill0O_dataout, wire_nilOiO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1i_dataout, wire_nilO0i_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1l_dataout, wire_nilO0l_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1O_dataout, wire_nilO0O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillii_dataout, wire_nilOli_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillil_dataout, wire_nilOll_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilliO_dataout, wire_nilOlO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillli_dataout, wire_nilOOi_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillll_dataout, wire_nilOOl_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilllO_dataout, wire_nilOOO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOi_dataout, wire_niO11i_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOl_dataout, wire_niO11l_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOO_dataout, wire_niO11O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilO_dataout, niilli, n0OO1l);
	assign		wire_nilO0i_dataout = (niilOl === 1'b1) ? wire_nii0ll_dataout : niiiOi;
	assign		wire_nilO0l_dataout = (niilOl === 1'b1) ? wire_nii0lO_o : niiiOl;
	assign		wire_nilO0O_dataout = (niilOl === 1'b1) ? wire_nii0Oi_dataout : niiiOO;
	and(wire_nilO1i_dataout, wire_niO10i_dataout, ~((~ wire_nO_dataout)));
	assign		wire_nilO1l_dataout = (niilOl === 1'b1) ? wire_nii0iO_o : ni1O1O;
	assign		wire_nilO1O_dataout = (niilOl === 1'b1) ? wire_nii0li_o : niiilO;
	assign		wire_nilOii_dataout = (niilOl === 1'b1) ? wire_nii0OO_o : niil1i;
	assign		wire_nilOil_dataout = (niilOl === 1'b1) ? wire_niii1i_o : niil1l;
	assign		wire_nilOiO_dataout = (niilOl === 1'b1) ? wire_niii1l_o : niil1O;
	assign		wire_nilOli_dataout = (niilOl === 1'b1) ? wire_niii1O_o : niil0i;
	assign		wire_nilOll_dataout = (niilOl === 1'b1) ? wire_niii0i_o : niil0l;
	assign		wire_nilOlO_dataout = (niilOl === 1'b1) ? wire_niii0l_o : niil0O;
	assign		wire_nilOOi_dataout = (niilOl === 1'b1) ? wire_niii0O_o : niilii;
	assign		wire_nilOOl_dataout = (niilOl === 1'b1) ? wire_niiiii_o : niilil;
	assign		wire_nilOOO_dataout = (niilOl === 1'b1) ? wire_niiiil_o : niiliO;
	assign		wire_niO_dataout = (n0OO0O === 1'b1) ? rxd[38] : rxd[22];
	and(wire_niO00i_dataout, wire_niO0OO_o[5], wire_ni1iiO_o);
	and(wire_niO00l_dataout, wire_niO0OO_o[6], wire_ni1iiO_o);
	and(wire_niO00O_dataout, wire_niOi1i_o[0], wire_ni1iiO_o);
	and(wire_niO01i_dataout, wire_niO0OO_o[2], wire_ni1iiO_o);
	and(wire_niO01l_dataout, wire_niO0OO_o[3], wire_ni1iiO_o);
	and(wire_niO01O_dataout, wire_niO0OO_o[4], wire_ni1iiO_o);
	and(wire_niO0ii_dataout, wire_niOi1i_o[1], wire_ni1iiO_o);
	and(wire_niO0il_dataout, wire_niOi1i_o[2], wire_ni1iiO_o);
	and(wire_niO0iO_dataout, wire_niOi1i_o[3], wire_ni1iiO_o);
	and(wire_niO0li_dataout, wire_niOi1i_o[4], wire_ni1iiO_o);
	and(wire_niO0ll_dataout, wire_niOi1i_o[5], wire_ni1iiO_o);
	and(wire_niO0lO_dataout, wire_niOi1i_o[6], wire_ni1iiO_o);
	and(wire_niO0Oi_dataout, wire_niOi1i_o[7], wire_ni1iiO_o);
	assign		wire_niO10i_dataout = (niilOl === 1'b1) ? wire_niiill_o : niilOi;
	and(wire_niO10l_dataout, niiOOl, wire_ni1iiO_o);
	and(wire_niO10O_dataout, wire_niO0Ol_o[0], wire_ni1iiO_o);
	assign		wire_niO11i_dataout = (niilOl === 1'b1) ? wire_niiiiO_o : niilli;
	assign		wire_niO11l_dataout = (niilOl === 1'b1) ? wire_niiili_o : niilll;
	assign		wire_niO11O_dataout = (niilOl === 1'b1) ? (~ wire_nii0Ol_o[2]) : niillO;
	and(wire_niO1ii_dataout, wire_niO0Ol_o[1], wire_ni1iiO_o);
	and(wire_niO1il_dataout, wire_niO0Ol_o[2], wire_ni1iiO_o);
	and(wire_niO1iO_dataout, wire_niO0Ol_o[3], wire_ni1iiO_o);
	and(wire_niO1li_dataout, wire_niO0Ol_o[4], wire_ni1iiO_o);
	and(wire_niO1ll_dataout, wire_niO0Ol_o[5], wire_ni1iiO_o);
	and(wire_niO1lO_dataout, wire_niO0Ol_o[6], wire_ni1iiO_o);
	or(wire_niO1Oi_dataout, niiO0O, ~(wire_ni1iiO_o));
	and(wire_niO1Ol_dataout, wire_niO0OO_o[0], wire_ni1iiO_o);
	and(wire_niO1OO_dataout, wire_niO0OO_o[1], wire_ni1iiO_o);
	and(wire_niOi_dataout, niilll, n0OO1l);
	assign		wire_niOi0i_dataout = (n0OO0l === 1'b1) ? nil11i : nil1iO;
	assign		wire_niOi0l_dataout = (n0OO0l === 1'b1) ? nil11l : nil1li;
	assign		wire_niOi0O_dataout = (n0OO0l === 1'b1) ? nil11O : nil1ll;
	assign		wire_niOi1l_dataout = (n0OO0l === 1'b1) ? niiOOl : nil1ii;
	assign		wire_niOi1O_dataout = (n0OO0l === 1'b1) ? niiOOO : nil1il;
	assign		wire_niOiii_dataout = (n0OO0l === 1'b1) ? nil10i : nil1lO;
	assign		wire_niOiil_dataout = (n0OO0l === 1'b1) ? nil10l : nil1Oi;
	assign		wire_niOiiO_dataout = (n0OO0l === 1'b1) ? nil10O : nil1Ol;
	and(wire_niOili_dataout, niiO0O, n0OO0l);
	and(wire_niOill_dataout, niiOii, n0OO0l);
	and(wire_niOilO_dataout, niiOil, n0OO0l);
	and(wire_niOiOi_dataout, niiOiO, n0OO0l);
	and(wire_niOiOl_dataout, niiOli, n0OO0l);
	and(wire_niOiOO_dataout, niiOll, n0OO0l);
	and(wire_niOl_dataout, niillO, n0OO1l);
	and(wire_niOl1i_dataout, niiOlO, n0OO0l);
	and(wire_niOl1l_dataout, niiOOi, n0OO0l);
	and(wire_niOO_dataout, niilOi, n0OO1l);
	and(wire_nl_dataout, rbisten_rx, (rbist_sel[0] & (~ rbist_sel[1])));
	or(wire_nl000l_dataout, nll0il, ~((~ n0liOi)));
	or(wire_nl000O_dataout, wire_nl001O_dataout, (~ n0liOi));
	or(wire_nl001i_dataout, nll0ii, n0lill);
	or(wire_nl001l_dataout, nll0il, n0lill);
	or(wire_nl001O_dataout, nll00O, nll0il);
	or(wire_nl00ii_dataout, nll0ii, (~ n0liOi));
	or(wire_nl00il_dataout, nll0il, (~ n0liOi));
	or(wire_nl00iO_dataout, nll0il, ~((~ n0liOl)));
	or(wire_nl00li_dataout, wire_nl001O_dataout, (~ n0liOl));
	or(wire_nl00ll_dataout, nll0ii, (~ n0liOl));
	or(wire_nl00lO_dataout, nll0il, (~ n0liOl));
	or(wire_nl00Oi_dataout, nll0il, ~((~ n0liOO)));
	or(wire_nl00Ol_dataout, wire_nl001O_dataout, (~ n0liOO));
	or(wire_nl00OO_dataout, nll0ii, (~ n0liOO));
	and(wire_nl01il_dataout, nll0ii, ~((~ wire_nl_dataout)));
	and(wire_nl01iO_dataout, nll00O, ~((~ wire_nl_dataout)));
	and(wire_nl01li_dataout, nlll1i, ~((~ wire_nl_dataout)));
	and(wire_nl01ll_dataout, nlll1l, ~((~ wire_nl_dataout)));
	and(wire_nl01lO_dataout, nlll1O, ~((~ wire_nl_dataout)));
	and(wire_nl01Oi_dataout, nlll0i, ~((~ wire_nl_dataout)));
	or(wire_nl01Ol_dataout, nll0il, ~(n0lill));
	or(wire_nl01OO_dataout, wire_nl001O_dataout, n0lill);
	assign		wire_nl0i_dataout = (n0OO1O === 1'b1) ? nll00O : wire_nl0O_dataout;
	assign		wire_nl0i0i_dataout = (n0OO0l === 1'b1) ? wire_nl0ill_dataout : wire_nl0iil_dataout;
	or(wire_nl0i0l_dataout, (~ n0ll1l), n0OO0l);
	or(wire_nl0i0O_dataout, wire_nl0ilO_dataout, ~(n0OO0l));
	or(wire_nl0i1i_dataout, nll0il, (~ n0liOO));
	assign		wire_nl0i1l_dataout = (n0OO0l === 1'b1) ? wire_nl0iiO_dataout : nll0il;
	assign		wire_nl0i1O_dataout = (n0OO0l === 1'b1) ? wire_nl0ili_dataout : wire_nl0iii_dataout;
	or(wire_nl0iii_dataout, nll00O, (~ n0ll1l));
	or(wire_nl0iil_dataout, nll0ii, (~ n0ll1l));
	or(wire_nl0iiO_dataout, nll0il, ~(n0ll1i));
	or(wire_nl0ili_dataout, wire_nl001O_dataout, n0ll1i);
	or(wire_nl0ill_dataout, nll0ii, n0ll1i);
	or(wire_nl0ilO_dataout, nll0il, n0ll1i);
	and(wire_nl0iOl_dataout, wire_nl0l0O_dataout, ~((~ n0ll1O)));
	and(wire_nl0iOO_dataout, wire_nl0l0l_dataout, ~((~ n0ll1O)));
	and(wire_nl0l_dataout, ni00i, n0OO0i);
	or(wire_nl0l0i_dataout, wire_nl0l0O_dataout, (~ n0ll1O));
	assign		wire_nl0l0l_dataout = (n0OO0l === 1'b1) ? n0ll0i : n0ll0l;
	assign		wire_nl0l0O_dataout = (n0OO0l === 1'b1) ? (~ n0ll0i) : (~ n0ll0l);
	or(wire_nl0l1i_dataout, nll00O, (~ n0ll1O));
	or(wire_nl0l1l_dataout, nll0ii, (~ n0ll1O));
	or(wire_nl0l1O_dataout, wire_nl0l0l_dataout, (~ n0ll1O));
	or(wire_nl0lii_dataout, nll00O, (~ n0ll0O));
	or(wire_nl0lil_dataout, nll0ii, (~ n0ll0O));
	and(wire_nl0liO_dataout, n0OO0l, ~((~ n0llii)));
	or(wire_nl0lli_dataout, nll00O, (~ n0llii));
	or(wire_nl0lll_dataout, nll0ii, (~ n0llii));
	or(wire_nl0llO_dataout, wire_nl0O1i_dataout, (~ n0llii));
	or(wire_nl0lOi_dataout, wire_nl0O1l_dataout, (~ n0llii));
	or(wire_nl0lOl_dataout, wire_nl0O1O_dataout, (~ n0llii));
	or(wire_nl0lOO_dataout, wire_nl0O0i_dataout, (~ n0llii));
	and(wire_nl0O_dataout, ni01l, n0OO0i);
	and(wire_nl0O0i_dataout, wire_nl0Oil_dataout, n0OO0l);
	or(wire_nl0O0l_dataout, wire_nl0OiO_dataout, n0llil);
	and(wire_nl0O0O_dataout, wire_nl0Oli_dataout, ~(n0llil));
	and(wire_nl0O1i_dataout, wire_nl0O0l_dataout, n0OO0l);
	or(wire_nl0O1l_dataout, wire_nl0O0O_dataout, ~(n0OO0l));
	or(wire_nl0O1O_dataout, wire_nl0Oii_dataout, ~(n0OO0l));
	or(wire_nl0Oii_dataout, wire_nl0Oll_dataout, n0llil);
	and(wire_nl0Oil_dataout, wire_nl0OlO_dataout, ~(n0llil));
	or(wire_nl0OiO_dataout, wire_nl0OOi_dataout, ~(n0lliO));
	or(wire_nl0Oli_dataout, wire_nl0OOl_dataout, ~(n0lliO));
	or(wire_nl0Oll_dataout, wire_nl0OOO_dataout, ~(n0lliO));
	and(wire_nl0OlO_dataout, wire_nli11i_dataout, n0lliO);
	and(wire_nl0OOi_dataout, wire_nli11l_dataout, ~(n0O11i));
	or(wire_nl0OOl_dataout, wire_nli11O_dataout, n0O11i);
	and(wire_nl0OOO_dataout, wire_nli10i_dataout, ~(n0O11i));
	assign		wire_nl1i_dataout = (n0OO1l === 1'b1) ? niiO1O : wire_nl1O_dataout;
	assign		wire_nl1l_dataout = (n0OO1l === 1'b1) ? niiO0i : wire_nl0i_dataout;
	assign		wire_nl1O_dataout = (n0OO1O === 1'b1) ? nll0ii : wire_nl0l_dataout;
	and(wire_nl1Oil_dataout, wire_nliill_dataout, wire_nl1Oli_o[5]);
	and(wire_nl1OiO_dataout, n0llOO, wire_nl1Oli_o[5]);
	and(wire_nl1Oll_dataout, wire_nli1Ol_dataout, wire_nl1Oli_o[6]);
	and(wire_nl1OlO_dataout, wire_nli1OO_dataout, wire_nl1Oli_o[6]);
	and(wire_nl1OOi_dataout, wire_nl0liO_dataout, wire_nl1Oli_o[7]);
	and(wire_nl1OOl_dataout, wire_nl0iOl_dataout, wire_nl1Oli_o[8]);
	and(wire_nl1OOO_dataout, wire_nl0iOO_dataout, wire_nl1Oli_o[8]);
	assign		wire_nli_dataout = (n0OO0O === 1'b1) ? rxd[39] : rxd[23];
	or(wire_nli00i_dataout, wire_nli0li_dataout, (~ n0llli));
	or(wire_nli00l_dataout, wire_nli0ll_dataout, (~ n0llli));
	or(wire_nli00O_dataout, wire_nli0lO_dataout, (~ n0llli));
	or(wire_nli01i_dataout, nll00O, (~ n0llli));
	or(wire_nli01l_dataout, nll0ii, (~ n0llli));
	or(wire_nli01O_dataout, wire_nli0iO_dataout, (~ n0llli));
	or(wire_nli0ii_dataout, (~ n0llll), ~(n0OO0l));
	and(wire_nli0il_dataout, n0llll, n0OO0l);
	assign		wire_nli0iO_dataout = (n0OO0l === 1'b1) ? n0llll : wire_nli0Oi_dataout;
	assign		wire_nli0li_dataout = (n0OO0l === 1'b1) ? (~ n0llll) : wire_nli0Ol_dataout;
	assign		wire_nli0ll_dataout = (n0OO0l === 1'b1) ? (~ n0llll) : wire_nli0OO_dataout;
	assign		wire_nli0lO_dataout = (n0OO0l === 1'b1) ? n0llll : wire_nlii1i_dataout;
	or(wire_nli0Oi_dataout, wire_nlii1l_dataout, n0llOl);
	and(wire_nli0Ol_dataout, wire_nlii1O_dataout, ~(n0llOl));
	and(wire_nli0OO_dataout, wire_nlii0i_dataout, ~(n0llOl));
	and(wire_nli10i_dataout, wire_nli1il_dataout, ~(n0lOiO));
	or(wire_nli10l_dataout, wire_nli1iO_dataout, n0lOiO);
	and(wire_nli10O_dataout, wire_nli1li_dataout, ~(n0lOil));
	or(wire_nli11i_dataout, wire_nli10l_dataout, n0O11i);
	or(wire_nli11l_dataout, wire_nli10O_dataout, n0lOiO);
	or(wire_nli11O_dataout, wire_nli1ii_dataout, n0lOiO);
	and(wire_nli1ii_dataout, wire_nli1ll_dataout, ~(n0lOil));
	or(wire_nli1il_dataout, wire_nli1lO_dataout, n0lOil);
	or(wire_nli1iO_dataout, wire_nli1Oi_dataout, n0lOil);
	or(wire_nli1li_dataout, nlll1i, n0lOll);
	and(wire_nli1ll_dataout, nlll1l, ~(n0lOll));
	or(wire_nli1lO_dataout, nlll1O, n0lOll);
	or(wire_nli1Oi_dataout, nlll0i, n0lOll);
	and(wire_nli1Ol_dataout, wire_nli0ii_dataout, ~((~ n0llli)));
	and(wire_nli1OO_dataout, wire_nli0il_dataout, ~((~ n0llli)));
	and(wire_nlii_dataout, wire_n1l_dataout, n0OO0l);
	or(wire_nlii0i_dataout, wire_nliiil_dataout, n0lllO);
	and(wire_nlii0l_dataout, wire_nliiiO_dataout, ~(n0lllO));
	or(wire_nlii0O_dataout, wire_nl0OOi_dataout, ~(n0llOi));
	or(wire_nlii1i_dataout, wire_nlii0l_dataout, n0llOl);
	or(wire_nlii1l_dataout, wire_nlii0O_dataout, n0lllO);
	and(wire_nlii1O_dataout, wire_nliiii_dataout, ~(n0lllO));
	or(wire_nliiii_dataout, wire_nl0OOl_dataout, ~(n0llOi));
	or(wire_nliiil_dataout, wire_nl0OOO_dataout, ~(n0llOi));
	and(wire_nliiiO_dataout, wire_nli11i_dataout, n0llOi);
	and(wire_nliill_dataout, wire_nlil1i_dataout, ~((~ n0llOO)));
	or(wire_nliilO_dataout, nll00O, (~ n0llOO));
	or(wire_nliiOi_dataout, nll0ii, (~ n0llOO));
	or(wire_nliiOl_dataout, wire_nlil1l_dataout, (~ n0llOO));
	or(wire_nliiOO_dataout, wire_nlil1O_dataout, (~ n0llOO));
	and(wire_nlil_dataout, wire_n1O_dataout, n0OO0l);
	assign		wire_nlil0i_dataout = (n0OO0l === 1'b1) ? wire_nlilli_dataout : wire_nlilii_dataout;
	assign		wire_nlil0l_dataout = (n0OO0l === 1'b1) ? wire_nlilll_dataout : wire_nlilil_dataout;
	assign		wire_nlil0O_dataout = (n0OO0l === 1'b1) ? wire_nlillO_dataout : wire_nliliO_dataout;
	assign		wire_nlil1i_dataout = (n0O11i === 1'b1) ? wire_nlilOi_dataout : wire_nlil0i_dataout;
	assign		wire_nlil1l_dataout = (n0O11i === 1'b1) ? wire_nlilOl_dataout : wire_nlil0l_dataout;
	assign		wire_nlil1O_dataout = (n0O11i === 1'b1) ? wire_nlilOO_dataout : wire_nlil0O_dataout;
	and(wire_nlilii_dataout, n0lO1i, ~(n0lO1O));
	and(wire_nlilil_dataout, (~ n0lO1i), ~(n0lO1O));
	or(wire_nliliO_dataout, n0lO1i, n0lO1O);
	and(wire_nlilli_dataout, n0lO1O, ~(n0lO1l));
	and(wire_nlilll_dataout, (~ n0lO1O), ~(n0lO1l));
	or(wire_nlillO_dataout, n0lO1O, n0lO1l);
	assign		wire_nlilOi_dataout = (n0OO0l === 1'b1) ? wire_nliO0i_dataout : wire_nliO1i_dataout;
	assign		wire_nlilOl_dataout = (n0OO0l === 1'b1) ? wire_nliO0l_dataout : wire_nliO1l_dataout;
	assign		wire_nlilOO_dataout = (n0OO0l === 1'b1) ? wire_nliO0O_dataout : wire_nliO1O_dataout;
	and(wire_nliO_dataout, wire_n0i_dataout, n0OO0l);
	and(wire_nliO0i_dataout, n0lO0O, ~(n0lO0l));
	and(wire_nliO0l_dataout, (~ n0lO0O), ~(n0lO0l));
	or(wire_nliO0O_dataout, n0lO0O, n0lO0l);
	and(wire_nliO1i_dataout, n0lO0i, ~(n0lO0O));
	and(wire_nliO1l_dataout, (~ n0lO0i), ~(n0lO0O));
	or(wire_nliO1O_dataout, n0lO0i, n0lO0O);
	or(wire_nliOii_dataout, nll00O, (~ n0lOii));
	or(wire_nliOil_dataout, nll0ii, (~ n0lOii));
	and(wire_nliOiO_dataout, wire_nliOOi_dataout, ~(n0O11i));
	and(wire_nliOli_dataout, wire_nliOOl_dataout, ~(n0O11i));
	or(wire_nliOll_dataout, wire_nliOOO_dataout, n0O11i);
	and(wire_nliOlO_dataout, wire_nll11i_dataout, ~(n0O11i));
	or(wire_nliOOi_dataout, nlll1i, n0lOOl);
	and(wire_nliOOl_dataout, nlll1l, ~(n0lOOl));
	or(wire_nliOOO_dataout, nlll1O, n0lOOl);
	assign		wire_nll10i_dataout = (n0lOOO === 1'b1) ? (~ n0OO0l) : wire_nll1il_dataout;
	assign		wire_nll10l_dataout = (n0lOOO === 1'b1) ? n0OO0l : wire_nll1iO_dataout;
	and(wire_nll10O_dataout, wire_nll1li_dataout, ~(n0lOOO));
	and(wire_nll11i_dataout, nlll0i, ~(n0lOOl));
	and(wire_nll11O_dataout, wire_nll1ii_dataout, ~(n0lOOO));
	assign		wire_nll1ii_dataout = (n0lOlO === 1'b1) ? n0OO0l : wire_nll1ll_dataout;
	assign		wire_nll1il_dataout = (n0lOlO === 1'b1) ? (~ n0OO0l) : wire_nll1lO_dataout;
	assign		wire_nll1iO_dataout = (n0lOlO === 1'b1) ? n0OO0l : wire_nll1Oi_dataout;
	and(wire_nll1li_dataout, wire_nll1Ol_dataout, ~(n0lOlO));
	or(wire_nll1ll_dataout, nlll1i, n0lOli);
	assign		wire_nll1lO_dataout = (n0lOli === 1'b1) ? (~ n0OO0l) : nlll1l;
	assign		wire_nll1Oi_dataout = (n0lOli === 1'b1) ? n0OO0l : nlll1O;
	and(wire_nll1Ol_dataout, nlll0i, ~(n0lOli));
	and(wire_nlli_dataout, wire_n0l_dataout, n0OO0l);
	and(wire_nlll_dataout, wire_n0O_dataout, n0OO0l);
	and(wire_nlll0l_dataout, wire_nl011O_o, ~(rbist_clr_rx));
	and(wire_nlll0O_dataout, wire_nl011l_o, ~(rbist_clr_rx));
	assign		wire_nlllii_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[0] : wire_nlllOi_dataout;
	assign		wire_nlllil_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[1] : wire_nlllOl_dataout;
	assign		wire_nllliO_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[2] : wire_nlllOO_dataout;
	assign		wire_nlllli_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[3] : wire_nllO1i_dataout;
	assign		wire_nlllll_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[4] : wire_nllO1l_dataout;
	assign		wire_nllllO_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[5] : wire_nllO1O_dataout;
	and(wire_nlllOi_dataout, nll0iO, ~(wire_nl1OOO_dataout));
	and(wire_nlllOl_dataout, nll0li, ~(wire_nl1OOO_dataout));
	and(wire_nlllOO_dataout, nll0ll, ~(wire_nl1OOO_dataout));
	and(wire_nllO_dataout, wire_nii_dataout, n0OO0l);
	assign		wire_nllO0l_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[0] : nll0OO;
	assign		wire_nllO0O_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[1] : nlli1i;
	and(wire_nllO1i_dataout, nll0lO, ~(wire_nl1OOO_dataout));
	and(wire_nllO1l_dataout, nll0Oi, ~(wire_nl1OOO_dataout));
	and(wire_nllO1O_dataout, nll0Ol, ~(wire_nl1OOO_dataout));
	assign		wire_nllOii_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[2] : nlli1l;
	and(wire_nllOiO_dataout, wire_nllOOi_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOli_dataout, wire_nllOOl_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOll_dataout, wire_nllOOO_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOlO_dataout, wire_nlO11i_dataout, ~(wire_nl1OlO_dataout));
	assign		wire_nllOOi_dataout = (wire_nl1Oll_dataout === 1'b1) ? wire_nlO11l_o[0] : nlli1O;
	assign		wire_nllOOl_dataout = (wire_nl1Oll_dataout === 1'b1) ? wire_nlO11l_o[1] : nlli0i;
	assign		wire_nllOOO_dataout = (wire_nl1Oll_dataout === 1'b1) ? wire_nlO11l_o[2] : nlli0l;
	assign		wire_nlO00i_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[7] : nlliOl;
	assign		wire_nlO00l_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[8] : nlliOO;
	assign		wire_nlO01i_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[4] : nllill;
	assign		wire_nlO01l_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[5] : nllilO;
	assign		wire_nlO01O_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[6] : nlliOi;
	and(wire_nlO10i_dataout, wire_nlO1Oi_dataout, ~(wire_nl1Oil_dataout));
	and(wire_nlO10l_dataout, wire_nlO1Ol_dataout, ~(wire_nl1Oil_dataout));
	and(wire_nlO10O_dataout, wire_nlO1OO_dataout, ~(wire_nl1Oil_dataout));
	assign		wire_nlO11i_dataout = (wire_nl1Oll_dataout === 1'b1) ? wire_nlO11l_o[3] : nlli0O;
	and(wire_nlO11O_dataout, wire_nlO1lO_dataout, ~(wire_nl1Oil_dataout));
	and(wire_nlO1ii_dataout, wire_nlO01i_dataout, ~(wire_nl1Oil_dataout));
	and(wire_nlO1il_dataout, wire_nlO01l_dataout, ~(wire_nl1Oil_dataout));
	and(wire_nlO1iO_dataout, wire_nlO01O_dataout, ~(wire_nl1Oil_dataout));
	and(wire_nlO1li_dataout, wire_nlO00i_dataout, ~(wire_nl1Oil_dataout));
	and(wire_nlO1ll_dataout, wire_nlO00l_dataout, ~(wire_nl1Oil_dataout));
	assign		wire_nlO1lO_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[0] : nlliii;
	assign		wire_nlO1Oi_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[1] : nlliil;
	assign		wire_nlO1Ol_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[2] : nlliiO;
	assign		wire_nlO1OO_dataout = (wire_nl1OiO_dataout === 1'b1) ? wire_nlO00O_o[3] : nllili;
	and(wire_nlOi_dataout, wire_nil_dataout, n0OO0l);
	and(wire_nlOl_dataout, wire_niO_dataout, n0OO0l);
	and(wire_nlOO_dataout, wire_nli_dataout, n0OO0l);
	and(wire_nO_dataout, rbisten_rx, (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (n0OOll2 ^ n0OOll1)));
	oper_add   niiOl
	( 
	.a({ni0li, ni0iO, ni0il, ni0ii, ni00O}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niiOl_o));
	defparam
		niiOl.sgate_representation = 0,
		niiOl.width_a = 5,
		niiOl.width_b = 5,
		niiOl.width_o = 5;
	oper_add   niO0Ol
	( 
	.a({nil10O, nil10l, nil10i, nil11O, nil11l, nil11i, niiOOO}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO0Ol_o));
	defparam
		niO0Ol.sgate_representation = 0,
		niO0Ol.width_a = 7,
		niO0Ol.width_b = 7,
		niO0Ol.width_o = 7;
	oper_add   niO0OO
	( 
	.a({niiOOi, niiOlO, niiOll, niiOli, niiOiO, niiOil, niiOii}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO0OO_o));
	defparam
		niO0OO.sgate_representation = 0,
		niO0OO.width_a = 7,
		niO0OO.width_b = 7,
		niO0OO.width_o = 7;
	oper_add   niOi1i
	( 
	.a({nil1Ol, nil1Oi, nil1lO, nil1ll, nil1li, nil1iO, nil1il, nil1ii}),
	.b({{7{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niOi1i_o));
	defparam
		niOi1i.sgate_representation = 0,
		niOi1i.width_a = 8,
		niOi1i.width_b = 8,
		niOi1i.width_o = 8;
	oper_add   nllO0i
	( 
	.a({nll0Ol, nll0Oi, nll0lO, nll0ll, nll0li, nll0iO}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllO0i_o));
	defparam
		nllO0i.sgate_representation = 0,
		nllO0i.width_a = 6,
		nllO0i.width_b = 6,
		nllO0i.width_o = 6;
	oper_add   nllOil
	( 
	.a({nlli1l, nlli1i, nll0OO}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllOil_o));
	defparam
		nllOil.sgate_representation = 0,
		nllOil.width_a = 3,
		nllOil.width_b = 3,
		nllOil.width_o = 3;
	oper_add   nlO00O
	( 
	.a({nlliOO, nlliOl, nlliOi, nllilO, nllill, nllili, nlliiO, nlliil, nlliii}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO00O_o));
	defparam
		nlO00O.sgate_representation = 0,
		nlO00O.width_a = 9,
		nlO00O.width_b = 9,
		nlO00O.width_o = 9;
	oper_add   nlO11l
	( 
	.a({nlli0O, nlli0l, nlli0i, nlli1O}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO11l_o));
	defparam
		nlO11l.sgate_representation = 0,
		nlO11l.width_a = 4,
		nlO11l.width_b = 4,
		nlO11l.width_o = 4;
	oper_decoder   n11ll
	( 
	.i({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}),
	.o(wire_n11ll_o));
	defparam
		n11ll.width_i = 5,
		n11ll.width_o = 32;
	oper_decoder   ni1ill
	( 
	.i({nil0ii, nil00O, nil00l, nil00i}),
	.o(wire_ni1ill_o));
	defparam
		ni1ill.width_i = 4,
		ni1ill.width_o = 16;
	oper_decoder   nii0Ol
	( 
	.i({nil01O, nil01l, nil01i, nil1OO}),
	.o(wire_nii0Ol_o));
	defparam
		nii0Ol.width_i = 4,
		nii0Ol.width_o = 16;
	oper_decoder   nl1Oli
	( 
	.i({nlll0i, nlll1O, nlll1l, nlll1i}),
	.o(wire_nl1Oli_o));
	defparam
		nl1Oli.width_i = 4,
		nl1Oli.width_o = 16;
	oper_mux   n100i
	( 
	.data({{10{1'b0}}, wire_n10ll_dataout, {5{1'b0}}, wire_n1O0l_dataout, wire_n00iO_dataout, n0O0lO, n0O0Oi, ((n0O1iO38 ^ n0O1iO37) & n0O0Ol), n0O0OO, n0Oi1i, n0Oi1l, n0Oi1O, wire_n0lOi_dataout, {3{1'b0}}, wire_n0Oil_dataout, wire_n0OOi_dataout, 1'b0}),
	.o(wire_n100i_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n100i.width_data = 32,
		n100i.width_sel = 5;
	oper_mux   n100l
	( 
	.data({{10{1'b0}}, wire_n10lO_dataout, ((n0O1li36 ^ n0O1li35) & wire_n1i1i_dataout), wire_n1iii_dataout, wire_n1ill_dataout, ((n0O1ll34 ^ n0O1ll33) & wire_n1iOO_dataout), wire_n1l0l_dataout, wire_n1O0O_dataout, wire_n00li_dataout, (~ n0O0lO), (~ n0O0Oi), (~ n0O0Ol), ((n0O1lO32 ^ n0O1lO31) & (~ n0O0OO)), ((n0O1Oi30 ^ n0O1Oi29) & (~ n0Oi1i)), (~ n0Oi1l), (~ n0Oi1O), (~ n0Oi0i), (~ n0Oi0l), (~ n0Oi0O), 1'b0, wire_n0OiO_dataout, wire_n0OOl_dataout, 1'b0}),
	.o(wire_n100l_o),
	.sel({((n0O1Ol28 ^ n0O1Ol27) & nii1i), ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n100l.width_data = 32,
		n100l.width_sel = 5;
	oper_mux   n101i
	( 
	.data({{10{1'b0}}, wire_n10il_dataout, {4{1'b1}}, wire_n1l0i_dataout, wire_n1O1l_dataout, wire_n000O_dataout, (~ n0O0lO), wire_n0iii_dataout, (~ n0O0Ol), wire_n0iOi_dataout, (~ n0Oi1i), wire_n0l0l_dataout, (~ n0Oi1O), wire_n0llO_dataout, (~ n0Oi0l), wire_n0O1O_dataout, 1'b0, wire_n0O0l_dataout, wire_n0Oli_dataout, (wire_ni_dataout & n11ii)}),
	.o(wire_n101i_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n101i.width_data = 32,
		n101i.width_sel = 5;
	oper_mux   n101l
	( 
	.data({{10{1'b0}}, wire_n10iO_dataout, {5{1'b0}}, wire_n1O1O_dataout, wire_n00ii_dataout, n0O0lO, wire_n0iil_dataout, 1'b0, wire_n0iOl_dataout, n0Oi1i, wire_n0l0O_dataout, 1'b0, wire_n0lll_dataout, n0Oi0l, wire_n0O0i_dataout, 1'b0, wire_n0O0O_dataout, wire_n0Oll_dataout, 1'b0}),
	.o(wire_n101l_o),
	.sel({nii1i, ni0Ol, ni0Oi, ((n0O10l46 ^ n0O10l45) & ni0lO), ni0ll}));
	defparam
		n101l.width_data = 32,
		n101l.width_sel = 5;
	oper_mux   n101O
	( 
	.data({{10{1'b0}}, ((n0O10O44 ^ n0O10O43) & wire_n10li_dataout), wire_n1i1i_dataout, wire_n1iii_dataout, ((n0O1ii42 ^ n0O1ii41) & wire_n1ill_dataout), wire_n1iOO_dataout, wire_n1l0l_dataout, wire_n1O0i_dataout, ((n0O1il40 ^ n0O1il39) & wire_n00il_dataout), {3{1'b1}}, wire_n0iOO_dataout, (~ n0Oi1i), (~ n0Oi1l), (~ n0Oi1O), wire_n0llO_dataout, {3{1'b1}}, wire_n0Oii_dataout, wire_n0OlO_dataout, 1'b0}),
	.o(wire_n101O_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n101O.width_data = 32,
		n101O.width_sel = 5;
	oper_mux   n11Ol
	( 
	.data({{10{ni00i}}, wire_n100O_dataout, wire_n10OO_dataout, wire_n1i0O_dataout, wire_n1ili_dataout, wire_n1iOl_dataout, wire_n1l1O_dataout, wire_n1O1i_dataout, wire_n000l_dataout, wire_n0i0i_dataout, wire_n0i0O_dataout, wire_n0ili_dataout, wire_n0ilO_dataout, wire_n0l1l_dataout, wire_n0l0i_dataout, wire_n0lil_dataout, wire_n0lli_dataout, wire_n0lOO_dataout, wire_n0O1l_dataout, {4{ni00i}}}),
	.o(wire_n11Ol_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n11Ol.width_data = 32,
		n11Ol.width_sel = 5;
	oper_mux   n11OO
	( 
	.data({{10{ni01l}}, wire_n10ii_dataout, wire_n10Ol_dataout, wire_n1i0l_dataout, wire_n1iiO_dataout, wire_n1iOi_dataout, wire_n1l1l_dataout, wire_n1lOO_dataout, wire_n000i_dataout, wire_n0i1O_dataout, wire_n0i0l_dataout, wire_n0iiO_dataout, wire_n0ill_dataout, wire_n0l1i_dataout, wire_n0l1O_dataout, wire_n0lii_dataout, wire_n0liO_dataout, wire_n0lOl_dataout, wire_n0O1i_dataout, {4{ni01l}}}),
	.o(wire_n11OO_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n11OO.width_data = 32,
		n11OO.width_sel = 5;
	oper_mux   ni1ilO
	( 
	.data({{3{1'b0}}, n0iOll, wire_ni1O0l_dataout, n0l11l, wire_ni01li_dataout, n0l1il, wire_ni00il_dataout, 1'b0, wire_ni0iii_dataout, n0l00l, wire_ni0l0l_dataout, n0li1i, n0liii, 1'b0}),
	.o(wire_ni1ilO_o),
	.sel({nil0ii, nil00O, nil00l, nil00i}));
	defparam
		ni1ilO.width_data = 16,
		ni1ilO.width_sel = 4;
	oper_mux   ni1iOi
	( 
	.data({{2{niiO1l}}, wire_ni1l0l_dataout, wire_ni1llO_dataout, wire_ni1O0i_dataout, {11{niiO1l}}}),
	.o(wire_ni1iOi_o),
	.sel({nil0ii, nil00O, nil00l, nil00i}));
	defparam
		ni1iOi.width_data = 16,
		ni1iOi.width_sel = 4;
	oper_mux   ni1iOl
	( 
	.data({{2{niiO1O}}, wire_ni1l0O_dataout, wire_ni1lOi_dataout, wire_ni1O0O_dataout, wire_ni011O_dataout, wire_ni010O_dataout, wire_ni001l_dataout, wire_ni000l_dataout, wire_ni00OO_dataout, wire_ni0i1O_dataout, wire_ni0iOl_dataout, wire_ni0l1l_dataout, wire_ni0llO_dataout, wire_ni0OOl_dataout, niiO1O}),
	.o(wire_ni1iOl_o),
	.sel({nil0ii, nil00O, nil00l, nil00i}));
	defparam
		ni1iOl.width_data = 16,
		ni1iOl.width_sel = 4;
	oper_mux   ni1iOO
	( 
	.data({{2{niiO0i}}, wire_ni1lii_dataout, wire_ni1lOl_dataout, wire_ni1Oii_dataout, wire_ni010i_dataout, wire_ni01ii_dataout, wire_ni001O_dataout, wire_ni000O_dataout, wire_ni0i1i_dataout, wire_ni0i0i_dataout, wire_ni0iOO_dataout, wire_ni0l1O_dataout, wire_ni0lOi_dataout, wire_ni0OOO_dataout, niiO0i}),
	.o(wire_ni1iOO_o),
	.sel({nil0ii, nil00O, nil00l, nil00i}));
	defparam
		ni1iOO.width_data = 16,
		ni1iOO.width_sel = 4;
	oper_mux   ni1l0i
	( 
	.data({{2{1'b0}}, wire_ni1lll_dataout, wire_ni1lOO_dataout, wire_ni1OiO_dataout, {4{1'b1}}, n0l1Ol, wire_ni0iii_dataout, n0l00l, wire_ni0l0l_dataout, wire_ni0O1l_dataout, wire_nii10i_dataout, wire_nii0ii_dataout}),
	.o(wire_ni1l0i_o),
	.sel({nil0ii, nil00O, nil00l, nil00i}));
	defparam
		ni1l0i.width_data = 16,
		ni1l0i.width_sel = 4;
	oper_mux   ni1l1i
	( 
	.data({{2{1'b0}}, wire_ni1lil_dataout, 1'b1, wire_ni1Oil_dataout, 1'b1, wire_ni01il_dataout, 1'b1, wire_ni00ii_dataout, 1'b1, wire_ni0i0l_dataout, 1'b1, wire_ni0l0i_dataout, wire_ni0lOl_dataout, wire_nii11i_dataout, wire_nii00i_dataout}),
	.o(wire_ni1l1i_o),
	.sel({nil0ii, nil00O, nil00l, nil00i}));
	defparam
		ni1l1i.width_data = 16,
		ni1l1i.width_sel = 4;
	oper_mux   ni1l1l
	( 
	.data({{2{1'b0}}, wire_ni1liO_dataout, {2{1'b0}}, (~ n0l11l), wire_ni01iO_dataout, {2{1'b0}}, (~ n0l1Ol), wire_ni0i0O_dataout, {2{1'b0}}, wire_ni0lOO_dataout, wire_nii11l_dataout, wire_nii00l_dataout}),
	.o(wire_ni1l1l_o),
	.sel({nil0ii, nil00O, nil00l, nil00i}));
	defparam
		ni1l1l.width_data = 16,
		ni1l1l.width_sel = 4;
	oper_mux   ni1l1O
	( 
	.data({{2{1'b0}}, wire_ni1lli_dataout, wire_ni1lOO_dataout, wire_ni1OiO_dataout, n0l11l, wire_ni01li_dataout, n0l1il, wire_ni00il_dataout, {4{1'b1}}, wire_ni0O1i_dataout, wire_nii11O_dataout, wire_nii00O_dataout}),
	.o(wire_ni1l1O_o),
	.sel({nil0ii, nil00O, nil00l, nil00i}));
	defparam
		ni1l1O.width_data = 16,
		ni1l1O.width_sel = 4;
	oper_mux   nii0iO
	( 
	.data({{4{1'b1}}, 1'b0, 1'b1, {7{1'b0}}, wire_niOi1l_dataout, {2{1'b1}}}),
	.o(wire_nii0iO_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		nii0iO.width_data = 16,
		nii0iO.width_sel = 4;
	oper_mux   nii0li
	( 
	.data({{3{1'b1}}, 1'b0, {2{1'b1}}, {7{1'b0}}, wire_niOi1O_dataout, {2{1'b1}}}),
	.o(wire_nii0li_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		nii0li.width_data = 16,
		nii0li.width_sel = 4;
	oper_mux   nii0lO
	( 
	.data({{5{1'b1}}, 1'b0, {7{1'b1}}, wire_niOi0l_dataout, {2{1'b1}}}),
	.o(wire_nii0lO_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		nii0lO.width_data = 16,
		nii0lO.width_sel = 4;
	oper_mux   nii0OO
	( 
	.data({{7{1'b1}}, {2{1'b0}}, 1'b1, 1'b0, 1'b1, 1'b0, wire_niOiii_dataout, {2{1'b1}}}),
	.o(wire_nii0OO_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		nii0OO.width_data = 16,
		nii0OO.width_sel = 4;
	oper_mux   niii0i
	( 
	.data({{3{n0OO0l}}, {3{1'b0}}, n0OO0l, {6{1'b0}}, wire_niOill_dataout, {2{n0OO0l}}}),
	.o(wire_niii0i_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niii0i.width_data = 16,
		niii0i.width_sel = 4;
	oper_mux   niii0l
	( 
	.data({{3{n0OO0l}}, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, wire_niOilO_dataout, {2{n0OO0l}}}),
	.o(wire_niii0l_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niii0l.width_data = 16,
		niii0l.width_sel = 4;
	oper_mux   niii0O
	( 
	.data({{3{n0OO0l}}, 1'b0, n0OO0l, {3{1'b0}}, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, wire_niOiOi_dataout, {2{n0OO0l}}}),
	.o(wire_niii0O_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niii0O.width_data = 16,
		niii0O.width_sel = 4;
	oper_mux   niii1i
	( 
	.data({{8{1'b1}}, 1'b0, {2{1'b1}}, {2{1'b0}}, wire_niOiil_dataout, {2{1'b1}}}),
	.o(wire_niii1i_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niii1i.width_data = 16,
		niii1i.width_sel = 4;
	oper_mux   niii1l
	( 
	.data({{9{1'b1}}, {4{1'b0}}, wire_niOiiO_dataout, {2{1'b1}}}),
	.o(wire_niii1l_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niii1l.width_data = 16,
		niii1l.width_sel = 4;
	oper_mux   niii1O
	( 
	.data({{3{n0OO0l}}, 1'b0, n0OO0l, 1'b0, n0OO0l, {6{1'b0}}, wire_niOili_dataout, {2{n0OO0l}}}),
	.o(wire_niii1O_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niii1O.width_data = 16,
		niii1O.width_sel = 4;
	oper_mux   niiiii
	( 
	.data({{3{n0OO0l}}, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, wire_niOiOl_dataout, {2{n0OO0l}}}),
	.o(wire_niiiii_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niiiii.width_data = 16,
		niiiii.width_sel = 4;
	oper_mux   niiiil
	( 
	.data({{3{n0OO0l}}, 1'b0, n0OO0l, 1'b0, n0OO0l, {3{1'b0}}, n0OO0l, 1'b0, n0OO0l, wire_niOiOO_dataout, {2{n0OO0l}}}),
	.o(wire_niiiil_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niiiil.width_data = 16,
		niiiil.width_sel = 4;
	oper_mux   niiiiO
	( 
	.data({{3{n0OO0l}}, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, {2{1'b0}}, wire_niOl1i_dataout, {2{n0OO0l}}}),
	.o(wire_niiiiO_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niiiiO.width_data = 16,
		niiiiO.width_sel = 4;
	oper_mux   niiili
	( 
	.data({{3{n0OO0l}}, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, {4{1'b0}}, wire_niOl1l_dataout, {2{n0OO0l}}}),
	.o(wire_niiili_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niiili.width_data = 16,
		niiili.width_sel = 4;
	oper_mux   niiill
	( 
	.data({{3{n0OO0l}}, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, n0OO0l, 1'b0, {2{n0OO0l}}}),
	.o(wire_niiill_o),
	.sel({nil01O, nil01l, nil01i, nil1OO}));
	defparam
		niiill.width_data = 16,
		niiill.width_sel = 4;
	oper_mux   nl010i
	( 
	.data({wire_nl01li_dataout, {4{1'b1}}, wire_nl0i0l_dataout, (~ n0ll0O), wire_nl0l1O_dataout, wire_nl0llO_dataout, wire_nli01O_dataout, wire_nliiOl_dataout, {2{1'b1}}, wire_nliOiO_dataout, wire_nll11O_dataout, (wire_nl_dataout & nl1Oii)}),
	.o(wire_nl010i_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010i.width_data = 16,
		nl010i.width_sel = 4;
	oper_mux   nl010l
	( 
	.data({wire_nl01ll_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, (~ n0ll0O), wire_nl0l1O_dataout, wire_nl0lOi_dataout, wire_nli00i_dataout, wire_nliiOO_dataout, (~ n0lOii), 1'b0, wire_nliOli_dataout, wire_nll10i_dataout, 1'b0}),
	.o(wire_nl010l_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010l.width_data = 16,
		nl010l.width_sel = 4;
	oper_mux   nl010O
	( 
	.data({wire_nl01lO_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, (~ n0ll0O), wire_nl0l1O_dataout, wire_nl0lOl_dataout, wire_nli00l_dataout, {3{1'b1}}, wire_nliOll_dataout, wire_nll10l_dataout, 1'b0}),
	.o(wire_nl010O_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010O.width_data = 16,
		nl010O.width_sel = 4;
	oper_mux   nl011i
	( 
	.data({nll0il, wire_nl01Ol_dataout, wire_nl000l_dataout, wire_nl00iO_dataout, wire_nl00Oi_dataout, wire_nl0i1l_dataout, {10{nll0il}}}),
	.o(wire_nl011i_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011i.width_data = 16,
		nl011i.width_sel = 4;
	oper_mux   nl011l
	( 
	.data({wire_nl01il_dataout, wire_nl001i_dataout, wire_nl00ii_dataout, wire_nl00ll_dataout, wire_nl00OO_dataout, wire_nl0i0i_dataout, wire_nl0lil_dataout, wire_nl0l1l_dataout, wire_nl0lll_dataout, wire_nli01l_dataout, wire_nliiOi_dataout, wire_nliOil_dataout, {4{nll0ii}}}),
	.o(wire_nl011l_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011l.width_data = 16,
		nl011l.width_sel = 4;
	oper_mux   nl011O
	( 
	.data({wire_nl01iO_dataout, wire_nl01OO_dataout, wire_nl000O_dataout, wire_nl00li_dataout, wire_nl00Ol_dataout, wire_nl0i1O_dataout, wire_nl0lii_dataout, wire_nl0l1i_dataout, wire_nl0lli_dataout, wire_nli01i_dataout, wire_nliilO_dataout, wire_nliOii_dataout, {4{nll00O}}}),
	.o(wire_nl011O_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011O.width_data = 16,
		nl011O.width_sel = 4;
	oper_mux   nl01ii
	( 
	.data({wire_nl01Oi_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, 1'b1, wire_nl0l0i_dataout, wire_nl0lOO_dataout, wire_nli00O_dataout, (~ n0llOO), (~ n0lOii), 1'b0, wire_nliOlO_dataout, wire_nll10O_dataout, 1'b0}),
	.o(wire_nl01ii_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl01ii.width_data = 16,
		nl01ii.width_sel = 4;
	oper_selector   n11il
	( 
	.data({1'b0, wire_n1lOi_dataout, wire_n001l_dataout}),
	.o(wire_n11il_o),
	.sel({n0O11O, wire_n11ll_o[15:14]}));
	defparam
		n11il.width_data = 3,
		n11il.width_sel = 3;
	oper_selector   n11iO
	( 
	.data({1'b0, wire_n1lOl_dataout, wire_n001O_dataout}),
	.o(wire_n11iO_o),
	.sel({n0O11O, wire_n11ll_o[15:14]}));
	defparam
		n11iO.width_data = 3,
		n11iO.width_sel = 3;
	oper_selector   n11lO
	( 
	.data({ni00l, wire_n10Oi_dataout, wire_n1i0i_dataout, wire_n1iil_dataout, wire_n1ilO_dataout, wire_n1l1i_dataout}),
	.o(wire_n11lO_o),
	.sel({n0O10i, wire_n11ll_o[20:16]}));
	defparam
		n11lO.width_data = 6,
		n11lO.width_sel = 6;
	oper_selector   ni1iiO
	( 
	.data({1'b0, 1'b1, wire_ni0OOi_dataout}),
	.o(wire_ni1iiO_o),
	.sel({n0iOli, wire_ni1ill_o[2:1]}));
	defparam
		ni1iiO.width_data = 3,
		ni1iiO.width_sel = 3;
	assign
		bistdone = ((wire_nl1l_dataout | prbs_done) | (~ (n0OlOi10 ^ n0OlOi9))),
		bisterr = ((wire_nl1i_dataout | prbs_err) | (~ (n0OlOO8 ^ n0OlOO7))),
		cur_state = {wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout},
		err_ctl = {wire_niOO_dataout, wire_niOl_dataout},
		err_data = {wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout},
		n0iOli = (((((((((((((wire_ni1ill_o[15] | wire_ni1ill_o[14]) | wire_ni1ill_o[13]) | wire_ni1ill_o[12]) | wire_ni1ill_o[11]) | wire_ni1ill_o[10]) | wire_ni1ill_o[9]) | wire_ni1ill_o[8]) | wire_ni1ill_o[7]) | wire_ni1ill_o[6]) | wire_ni1ill_o[5]) | wire_ni1ill_o[4]) | wire_ni1ill_o[3]) | wire_ni1ill_o[0]),
		n0iOll = ((~ n0iOlO) | (~ n0l0il)),
		n0iOlO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOOi = ((~ n0iOOl) | (~ n0l0il)),
		n0iOOl = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOOO = ((~ n0l11i) | (~ n0l0ll)),
		n0l00i = ((((((((((((((((~ wire_nlOO_dataout) & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0l00l = ((~ n0l00O) | (~ n0l0il)),
		n0l00O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])),
		n0l01i = ((~ n0l01l) | (~ n0l0il)),
		n0l01l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0l01O = ((~ n0l00i) | (~ n0l0ll)),
		n0l0ii = ((~ n0l0iO) | (~ n0l0il)),
		n0l0il = ((~ wire_nlii_dataout) & rxc[0]),
		n0l0iO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0l0li = ((~ n0l0lO) | (~ n0l0ll)),
		n0l0ll = (wire_nlii_dataout & rxc[0]),
		n0l0lO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0l0Oi = (((((((nil1Ol & nil1Oi) & nil1lO) & nil1ll) & nil1li) & nil1iO) & nil1il) & nil1ii),
		n0l0Ol = (n0OO0l & n0l0OO),
		n0l0OO = (((((((niiOOi & niiOlO) & niiOll) & niiOli) & niiOiO) & niiOil) & niiOii) & niiO0O),
		n0l10i = ((~ n0l10l) | (~ n0l0il)),
		n0l10l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0l10O = ((~ n0l1ii) | (~ n0l0ll)),
		n0l11i = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & wire_nlil_dataout) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0l11l = ((~ n0l11O) | (~ n0l0il)),
		n0l11O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0l1ii = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & (~ wire_nlll_dataout)) & wire_nlli_dataout) & wire_nliO_dataout) & wire_nlil_dataout) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0l1il = ((~ n0l1iO) | (~ n0l0il)),
		n0l1iO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & rxd[7]),
		n0l1li = ((~ n0l1ll) | (~ n0l0il)),
		n0l1ll = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]),
		n0l1lO = ((~ n0l1Oi) | (~ n0l0ll)),
		n0l1Oi = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & (~ wire_nlOi_dataout)) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]),
		n0l1Ol = ((~ n0l1OO) | (~ n0l0il)),
		n0l1OO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])),
		n0li0i = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0li0l = (n0OO0l & (wire_nlii_dataout & n0li0O)),
		n0li0O = (((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & (~ wire_nlli_dataout)) & wire_nliO_dataout) & wire_nlil_dataout),
		n0li1i = ((~ n0li1l) | (~ ((~ wire_nlii_dataout) & (~ rxc[0])))),
		n0li1l = ((((((((((((((((~ (rxd[0] ^ wire_niOi1l_dataout)) & (~ (rxd[1] ^ wire_niOi1O_dataout))) & (~ (rxd[2] ^ wire_niOi0i_dataout))) & (~ (rxd[3] ^ wire_niOi0l_dataout))) & (~ (rxd[4] ^ wire_niOi0O_dataout))) & (~ (rxd[5] ^ wire_niOiii_dataout))) & (~ (rxd[6] ^ wire_niOiil_dataout))) & (~ (rxd[7] ^ wire_niOiiO_dataout))) & (~ (wire_nlil_dataout ^ wire_niOili_dataout))) & (~ (wire_nliO_dataout ^ wire_niOill_dataout))) & (~ (wire_nlli_dataout ^ wire_niOilO_dataout))) & (~ (wire_nlll_dataout ^ wire_niOiOi_dataout))) & (~ (wire_nllO_dataout ^ wire_niOiOl_dataout))) & (~ (wire_nlOi_dataout ^ wire_niOiOO_dataout))) & (~ (wire_nlOl_dataout ^ wire_niOl1i_dataout))) & (~ (wire_nlOO_dataout ^ wire_niOl1l_dataout))),
		n0li1O = ((~ n0OO0l) & (rxc[0] & n0li0i)),
		n0liii = (((((((nil1Ol & nil1Oi) & nil1lO) & nil1ll) & nil1li) & nil1iO) & nil1il) & nil1ii),
		n0liil = (wire_nO_dataout & niilOO),
		n0lill = ((~ rxc[0]) | (~ n0lilO)),
		n0lilO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0liOi = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0liOl = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0liOO = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0ll0i = ((((((~ nll0Ol) & nll0Oi) & (~ nll0lO)) & (~ nll0ll)) & nll0li) & nll0iO),
		n0ll0l = (((((nll0Ol & (~ nll0Oi)) & (~ nll0lO)) & nll0ll) & nll0li) & nll0iO),
		n0ll0O = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nllO_dataout)) & (~ wire_nlli_dataout)) & rxd[5]) & rxd[7]) & (~ ((~ n0OO0l) ^ rxd[0]))) & (~ ((~ n0OO0l) ^ rxd[1]))) & (~ (n0OO0l ^ rxd[2]))) & (~ ((~ n0OO0l) ^ rxd[3]))) & (~ (n0OO0l ^ rxd[4]))) & (~ (n0OO0l ^ rxd[6]))) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nliO_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0ll1i = ((~ n0ll1l) | (~ (wire_nlii_dataout & (~ rxc[0])))),
		n0ll1l = ((((((((((((((((~ wire_nliO_dataout) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0ll1O = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nlll_dataout)) & (~ wire_nliO_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0llii = ((((((((((((((((~ wire_nlll_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0llil = (((~ nlli1l) & nlli1i) & nll0OO),
		n0lliO = ((nlli1l & nlli1i) & nll0OO),
		n0llli = ((((((((((((((((~ wire_nllO_dataout) & (~ wire_nlli_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nliO_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0llll = ((((~ nlli0O) & (~ nlli0l)) & nlli0i) & (~ nlli1O)),
		n0lllO = ((((~ nlli0O) & nlli0l) & nlli0i) & nlli1O),
		n0llOi = (((nlli0O & nlli0l) & nlli0i) & nlli1O),
		n0llOl = (((((~ nlli0O) & (~ nlli0l)) & nlli0i) & nlli1O) | (((nlli0O & (~ nlli0l)) & nlli0i) & nlli1O)),
		n0llOO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])) & (~ (n0OO0l ^ wire_nliO_dataout))) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))),
		n0lO0i = ((((((((nlliOO & (~ nlliOl)) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & nlliiO) & nlliil) & (~ nlliii)),
		n0lO0l = (((((((((~ nlliOO) & (~ nlliOl)) & nlliOi) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & (~ nlliil)) & (~ nlliii)),
		n0lO0O = (((((((((~ nlliOO) & nlliOl) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & nlliil) & (~ nlliii)),
		n0lO1i = ((((((((nlliOO & (~ nlliOl)) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & nlliiO) & nlliil) & nlliii),
		n0lO1l = (((((((((~ nlliOO) & (~ nlliOl)) & nlliOi) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & (~ nlliil)) & nlliii),
		n0lO1O = (((((((((~ nlliOO) & nlliOl) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & nlliil) & nlliii),
		n0lOii = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OO0l ^ wire_nliO_dataout))) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))),
		n0lOil = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		n0lOiO = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		n0lOli = (n0lOOi & n0lOll),
		n0lOll = (rcxpat_chnl_sel[0] & rcxpat_chnl_sel[1]),
		n0lOlO = (n0lOOl & n0lOOi),
		n0lOOi = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0lOOl = (n0lOiO | n0lOil),
		n0lOOO = (rxc[0] & (n0O11l & n0O11i)),
		n0O00i = (((((((rxd[0] & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])),
		n0O00l = (((~ n0O0il) | (~ (wire_nlii_dataout & (~ rxc[0])))) | (~ (n0O00O26 ^ n0O00O25))),
		n0O01i = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0O01l = (((((((rxd[0] & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0O01O = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0O0il = ((((((((((((((((~ wire_nliO_dataout) & (~ rxd[0])) & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0O0iO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0O0li = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOi_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))),
		n0O0ll = ((((ni0li & ni0iO) & ni0il) & ni0ii) & (~ ni00O)),
		n0O0lO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0O0Oi = ((((((((((((((((~ wire_nlli_dataout) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nliO_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOi_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0O0Ol = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0O0OO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))),
		n0O10i = ((((((((((((((((((((((((((wire_n11ll_o[31] | wire_n11ll_o[30]) | wire_n11ll_o[29]) | wire_n11ll_o[28]) | wire_n11ll_o[27]) | wire_n11ll_o[26]) | wire_n11ll_o[25]) | wire_n11ll_o[24]) | wire_n11ll_o[23]) | wire_n11ll_o[22]) | wire_n11ll_o[21]) | wire_n11ll_o[15]) | wire_n11ll_o[14]) | wire_n11ll_o[13]) | wire_n11ll_o[12]) | wire_n11ll_o[11]) | wire_n11ll_o[10]) | wire_n11ll_o[9]) | wire_n11ll_o[8]) | wire_n11ll_o[7]) | wire_n11ll_o[6]) | wire_n11ll_o[5]) | wire_n11ll_o[4]) | wire_n11ll_o[3]) | wire_n11ll_o[2]) | wire_n11ll_o[1]) | wire_n11ll_o[0]),
		n0O11i = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		n0O11l = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0O11O = (((((((((((((((((((((((((((((wire_n11ll_o[31] | wire_n11ll_o[30]) | wire_n11ll_o[29]) | wire_n11ll_o[28]) | wire_n11ll_o[27]) | wire_n11ll_o[26]) | wire_n11ll_o[25]) | wire_n11ll_o[24]) | wire_n11ll_o[23]) | wire_n11ll_o[22]) | wire_n11ll_o[21]) | wire_n11ll_o[20]) | wire_n11ll_o[19]) | wire_n11ll_o[18]) | wire_n11ll_o[17]) | wire_n11ll_o[16]) | wire_n11ll_o[13]) | wire_n11ll_o[12]) | wire_n11ll_o[11]) | wire_n11ll_o[10]) | wire_n11ll_o[9]) | wire_n11ll_o[8]) | wire_n11ll_o[7]) | wire_n11ll_o[6]) | wire_n11ll_o[5]) | wire_n11ll_o[4]) | wire_n11ll_o[3]) | wire_n11ll_o[2]) | wire_n11ll_o[1]) | wire_n11ll_o[0]),
		n0O1OO = ((~ rxc[0]) | (~ n0O01i)),
		n0Oi0i = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & (~ rxd[3])) & (~ rxd[4])) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nliO_dataout))) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))),
		n0Oi0l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & rxd[7]),
		n0Oi0O = ((((((((((((((((~ wire_nlOi_dataout) & (~ wire_nlll_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nliO_dataout))) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nllO_dataout))) & (~ (n0OO0l ^ wire_nlOl_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0Oi1i = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]),
		n0Oi1l = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & rxd[6]) & (~ rxd[7])) & (~ (n0OO0l ^ wire_nlil_dataout))) & (~ (n0OO0l ^ wire_nliO_dataout))) & (~ (n0OO0l ^ wire_nlli_dataout))) & (~ (n0OO0l ^ wire_nlll_dataout))) & (~ (n0OO0l ^ wire_nlOO_dataout))),
		n0Oi1O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & (~ rxd[3])) & (~ rxd[4])) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0Oiii = (n0OilO & n0Oiil),
		n0Oiil = (rcxpat_chnl_sel[0] & rcxpat_chnl_sel[1]),
		n0OiiO = ((((n0Ol1i | n0OiOO) | (~ (n0OiOi22 ^ n0OiOi21))) & n0OilO) & (n0Oili24 ^ n0Oili23)),
		n0OilO = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0OiOO = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		n0Ol0i = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0Ol0O = 1'b1,
		n0Ol1i = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		n0Ol1l = (rxc[0] & (n0Ol0i & n0Ol1O)),
		n0Ol1O = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		n0OO0i = (((~ rbist_sel[0]) & rbist_sel[1]) & (n0OliO14 ^ n0OliO13)),
		n0OO0l = (n0OO0O | (rpmadwidth_rx & rpma_doublewidth_rx)),
		n0OO0O = (((rpmadwidth_rx & (~ rpma_doublewidth_rx)) & rdwidth_rx) & (n0OOii6 ^ n0OOii5)),
		n0OO1l = (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (n0Olll12 ^ n0Olll11)),
		n0OO1O = (rbist_sel[0] & (~ rbist_sel[1])),
		selftest_done = wire_nl1l_dataout,
		selftest_err = wire_nl1i_dataout;
endmodule //stratixiigx_hssi_rx_bist_ver
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 507 mux21 1111 oper_add 22 oper_decoder 14 oper_less_than 20 oper_mux 14 stratixiigx_hssi_ram20x16_syn 2 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_rx_comp_chnl_top
	( 
	align_status,
	align_status_sync,
	align_status_sync_0,
	align_status_sync_2,
	audi,
	audi_pre,
	clk_1,
	clk_2,
	cmpfifourst,
	comp_curr_st,
	cudi,
	cudi_valid,
	disable_fifo_rd,
	disable_fifo_rd_0,
	disable_fifo_rd_2,
	disable_fifo_wr,
	disable_fifo_wr_0,
	disable_fifo_wr_2,
	dskwclksel,
	fifo_cnt,
	fifo_rd_in_comp_0,
	fifo_rd_in_comp_2,
	fifo_rd_out_comp,
	hard_reset,
	is_lane0,
	ralempty,
	ralfull,
	rclkcmpinsertpad,
	rclkcmppos,
	rclkcmpsq1n,
	rclkcmpsq1p,
	rclkcmpsqmd,
	rcmpfifourst,
	rdenable,
	rdfifo_almost_empty,
	rdfifo_almost_full,
	rdfifo_empty,
	rdfifo_full,
	rdwidth_rx,
	rev_loop_data,
	rgenericfifo,
	rmatchen,
	rrx_pipe_enable,
	rskpsetbased,
	rtruebac2bac,
	rwa_6g_en,
	scan_mode,
	soft_reset,
	sudi,
	sudi_pre,
	sync_status,
	wrenable) /* synthesis synthesis_clearbox=1 */;
	input   align_status;
	output   align_status_sync;
	input   align_status_sync_0;
	input   align_status_sync_2;
	input   [13:0]  audi;
	input   [13:0]  audi_pre;
	input   clk_1;
	input   clk_2;
	input   cmpfifourst;
	output   [1:0]  comp_curr_st;
	output   [31:0]  cudi;
	output   cudi_valid;
	output   disable_fifo_rd;
	input   disable_fifo_rd_0;
	input   disable_fifo_rd_2;
	output   disable_fifo_wr;
	input   disable_fifo_wr_0;
	input   disable_fifo_wr_2;
	input   [1:0]  dskwclksel;
	output   [4:0]  fifo_cnt;
	input   fifo_rd_in_comp_0;
	input   fifo_rd_in_comp_2;
	output   fifo_rd_out_comp;
	input   hard_reset;
	input   is_lane0;
	input   [3:0]  ralempty;
	input   [3:0]  ralfull;
	input   rclkcmpinsertpad;
	input   rclkcmppos;
	input   [19:0]  rclkcmpsq1n;
	input   [19:0]  rclkcmpsq1p;
	input   rclkcmpsqmd;
	input   rcmpfifourst;
	input   rdenable;
	output   rdfifo_almost_empty;
	output   rdfifo_almost_full;
	output   rdfifo_empty;
	output   rdfifo_full;
	input   rdwidth_rx;
	output   [19:0]  rev_loop_data;
	input   rgenericfifo;
	input   rmatchen;
	input   rrx_pipe_enable;
	input   rskpsetbased;
	input   rtruebac2bac;
	input   rwa_6g_en;
	input   scan_mode;
	input   soft_reset;
	input   [27:0]  sudi;
	input   [13:0]  sudi_pre;
	input   sync_status;
	input   wrenable;

	reg	nlill0l55;
	reg	nlill0l56;
	reg	nliOliO53;
	reg	nliOliO54;
	reg	nliOlli51;
	reg	nliOlli52;
	reg	nll000l3;
	reg	nll000l4;
	reg	nll001O5;
	reg	nll001O6;
	reg	nll00li1;
	reg	nll00li2;
	reg	nll010l11;
	reg	nll010l12;
	reg	nll011l13;
	reg	nll011l14;
	reg	nll01ii10;
	reg	nll01ii9;
	reg	nll01li7;
	reg	nll01li8;
	reg	nll10il47;
	reg	nll10il48;
	reg	nll111O49;
	reg	nll111O50;
	reg	nll1i0O43;
	reg	nll1i0O44;
	reg	nll1i1l45;
	reg	nll1i1l46;
	reg	nll1ili41;
	reg	nll1ili42;
	reg	nll1ilO39;
	reg	nll1ilO40;
	reg	nll1iOl37;
	reg	nll1iOl38;
	reg	nll1l1l35;
	reg	nll1l1l36;
	reg	nll1liO33;
	reg	nll1liO34;
	reg	nll1lOi31;
	reg	nll1lOi32;
	reg	nll1lOl29;
	reg	nll1lOl30;
	reg	nll1lOO27;
	reg	nll1lOO28;
	reg	nll1O0O21;
	reg	nll1O0O22;
	reg	nll1O1i25;
	reg	nll1O1i26;
	reg	nll1O1O23;
	reg	nll1O1O24;
	reg	nll1Oil19;
	reg	nll1Oil20;
	reg	nll1Oli17;
	reg	nll1Oli18;
	reg	nll1OOi15;
	reg	nll1OOi16;
	reg	n0OiiO;
	reg	n0Oili;
	reg	n0Oill;
	reg	n0OilO;
	reg	n0OiOi;
	reg	n0OiOl;
	reg	n0OiOO;
	reg	n0Ol0i;
	reg	n0Ol0l;
	reg	n0Ol0O;
	reg	n0Ol1i;
	reg	n0Ol1l;
	reg	n0Ol1O;
	reg	n0Olii;
	reg	n0Olil;
	reg	n0OliO;
	reg	n0Olli;
	reg	n0Olll;
	reg	n0OllO;
	reg	n0OlOi;
	reg	ni11ll;
	reg	ni11Ol;
	reg	ni11Oi_clk_prev;
	wire	wire_ni11Oi_CLRN;
	wire	wire_ni11Oi_PRN;
	reg	n0i;
	reg	nil;
	reg	nii_clk_prev;
	wire	wire_nii_CLRN;
	reg	nii00O;
	reg	nii11i;
	reg	nlO0i1i;
	reg	nlO0l0l;
	reg	n1O;
	reg	nO;
	reg	nl_clk_prev;
	wire	wire_nl_CLRN;
	reg	n1i10l;
	reg	n1i10O;
	reg	n1i1ii;
	reg	niO0li;
	reg	nl0liO;
	reg	nl0lli;
	reg	nl0llO;
	reg	nlOllil;
	wire	wire_nl0lll_PRN;
	reg	n00lii;
	reg	n00lil;
	reg	n0OlOl;
	reg	n0OlOO;
	reg	n0OO0i;
	reg	n0OO0l;
	reg	n0OO0O;
	reg	n0OO1i;
	reg	n0OO1l;
	reg	n0OO1O;
	reg	n0OOii;
	reg	n0OOil;
	reg	n0OOiO;
	reg	n0OOli;
	reg	n0OOll;
	reg	n0OOlO;
	reg	n0OOOi;
	reg	n0OOOl;
	reg	n0OOOO;
	reg	n1000i;
	reg	n1000l;
	reg	n1000O;
	reg	n1001i;
	reg	n1001l;
	reg	n1001O;
	reg	n100ii;
	reg	n101Oi;
	reg	n101Ol;
	reg	n101OO;
	reg	n10i0i;
	reg	n10i0l;
	reg	n10i0O;
	reg	n10i1O;
	reg	n10iii;
	reg	n10iil;
	reg	n10ili;
	reg	n10ill;
	reg	n10ilO;
	reg	n10iOi;
	reg	n10liO;
	reg	n10O0i;
	reg	n10O0l;
	reg	n10O1O;
	reg	n11OiO;
	reg	n1ii0l;
	reg	n1l10i;
	reg	n1l10l;
	reg	n1l10O;
	reg	n1l11i;
	reg	n1l11l;
	reg	n1l11O;
	reg	n1l1ii;
	reg	n1O00O;
	reg	n1O0il;
	reg	n1O0iO;
	reg	n1O0li;
	reg	n1O0ll;
	reg	n1O0lO;
	reg	n1O0Oi;
	reg	n1O1Oi;
	reg	ni0O0O;
	reg	ni0Oii;
	reg	ni0Oil;
	reg	ni0OiO;
	reg	ni0Oli;
	reg	ni0Oll;
	reg	ni0OlO;
	reg	ni0OOi;
	reg	ni0OOl;
	reg	ni0OOO;
	reg	ni101i;
	reg	ni101l;
	reg	ni110i;
	reg	ni110l;
	reg	ni110O;
	reg	ni111i;
	reg	ni111l;
	reg	ni111O;
	reg	ni11ii;
	reg	ni11il;
	reg	ni11iO;
	reg	ni11li;
	reg	ni11lO;
	reg	ni11OO;
	reg	nii00i;
	reg	nii01i;
	reg	nii01l;
	reg	nii01O;
	reg	nii0ii;
	reg	nii0il;
	reg	nii0iO;
	reg	nii0li;
	reg	nii0ll;
	reg	nii0lO;
	reg	nii0Oi;
	reg	nii0Ol;
	reg	nii0OO;
	reg	nii10i;
	reg	nii10l;
	reg	nii10O;
	reg	nii11l;
	reg	nii11O;
	reg	nii1ii;
	reg	nii1il;
	reg	nii1iO;
	reg	nii1li;
	reg	nii1ll;
	reg	nii1lO;
	reg	nii1Oi;
	reg	nii1Ol;
	reg	nii1OO;
	reg	niii0i;
	reg	niii0l;
	reg	niii0O;
	reg	niii1i;
	reg	niii1l;
	reg	niii1O;
	reg	niiiii;
	reg	niiiil;
	reg	niiiiO;
	reg	niiili;
	reg	nl000i;
	reg	nl000l;
	reg	nl000O;
	reg	nl001i;
	reg	nl001l;
	reg	nl00ii;
	reg	nl011i;
	reg	nl011l;
	reg	nl011O;
	reg	nl01Ol;
	reg	nl01OO;
	reg	nl0i1l;
	reg	nl0iiO;
	reg	nl0ili;
	reg	nl0ill;
	reg	nl1l0l;
	reg	nl1OiO;
	reg	nl1Oli;
	reg	nl1Oll;
	reg	nl1OlO;
	reg	nl1OOi;
	reg	nl1OOl;
	reg	nl1OOO;
	reg	nliOlO;
	reg	nll00ll;
	reg	nll00lO;
	reg	nll10l;
	reg	nll11l;
	reg	nllO0OO;
	reg	nllOi0i;
	reg	nllOi0l;
	reg	nllOi0O;
	reg	nllOi1i;
	reg	nllOi1l;
	reg	nllOi1O;
	reg	nllOiii;
	reg	nllOiil;
	reg	nllOiiO;
	reg	nllOili;
	reg	nllOilO;
	reg	nllOiOO;
	reg	nllOl1i;
	reg	nllOl1l;
	reg	nlO000O;
	reg	nlO00ii;
	reg	nlO00il;
	reg	nlO00iO;
	reg	nlO00li;
	reg	nlO00ll;
	reg	nlO00lO;
	reg	nlO00Oi;
	reg	nlO00Ol;
	reg	nlO00OO;
	reg	nlO0i0i;
	reg	nlO0i0l;
	reg	nlO0i0O;
	reg	nlO0i1l;
	reg	nlO0i1O;
	reg	nlO0iii;
	reg	nlO0iil;
	reg	nlO0iiO;
	reg	nlO0ili;
	reg	nlO0ill;
	reg	nlO0ilO;
	reg	nlO0iOi;
	reg	nlO0iOl;
	reg	nlO0iOO;
	reg	nlO0l0i;
	reg	nlO0l0O;
	reg	nlO0l1i;
	reg	nlO0l1l;
	reg	nlO0l1O;
	reg	nlO0lii;
	reg	nlO0lil;
	reg	nlO0liO;
	reg	nlO0lli;
	reg	nlO0lll;
	reg	nlO0llO;
	reg	nlO0lOi;
	reg	nlO0lOl;
	reg	nlO0lOO;
	reg	nlO0O0i;
	reg	nlO0O0l;
	reg	nlO0O0O;
	reg	nlO0O1i;
	reg	nlO0O1l;
	reg	nlO0O1O;
	reg	nlO0Oii;
	reg	nlO0Oil;
	reg	nlO0OiO;
	wire	wire_nll10i_CLRN;
	reg	nlllOiO;
	reg	nlllOli;
	reg	nlllOll;
	reg	nlllOlO;
	reg	nlllOOi;
	reg	nlllOOl;
	reg	nlllOOO;
	reg	nllO00i;
	reg	nllO00l;
	reg	nllO00O;
	reg	nllO01i;
	reg	nllO01l;
	reg	nllO01O;
	reg	nllO0ii;
	reg	nllO0il;
	reg	nllO0iO;
	reg	nllO0li;
	reg	nllO0ll;
	reg	nllO0lO;
	reg	nllO0Oi;
	reg	nllO0Ol;
	reg	nllO10i;
	reg	nllO10l;
	reg	nllO10O;
	reg	nllO11i;
	reg	nllO11l;
	reg	nllO11O;
	reg	nllO1ii;
	reg	nllO1il;
	reg	nllO1iO;
	reg	nllO1li;
	reg	nllO1ll;
	reg	nllO1lO;
	reg	nllO1Oi;
	reg	nllO1Ol;
	reg	nllO1OO;
	reg	nllOill;
	reg	nllOiOl;
	reg	nllOiOi_clk_prev;
	wire	wire_nllOiOi_PRN;
	reg	n00liO;
	reg	n10iOl;
	reg	n10O0O;
	reg	n110il;
	reg	n110iO;
	reg	n11O0l;
	reg	n11O0O;
	reg	n11Oii;
	reg	n11Oil;
	reg	n1i11i;
	reg	n1i11l;
	reg	n1i1il;
	reg	n1i1iO;
	reg	n1i1li;
	reg	n1ii0i;
	reg	n1ii1i;
	reg	n1ii1l;
	reg	n1ii1O;
	reg	n1l0lO;
	reg	n1l0Oi;
	reg	n1l0Ol;
	reg	n1l0OO;
	reg	n1l1il;
	reg	n1li1i;
	reg	n1li1l;
	reg	n1O0Ol;
	reg	n1O1lO;
	reg	n1Olil;
	reg	n1Olll;
	reg	n1OllO;
	reg	n1OlOi;
	reg	n1OlOl;
	reg	n1OlOO;
	reg	niiill;
	reg	niO00i;
	reg	niO00l;
	reg	niO00O;
	reg	niO01i;
	reg	niO01l;
	reg	niO01O;
	reg	niO0ii;
	reg	niO0il;
	reg	niO0iO;
	reg	niO0ll;
	reg	niO0lO;
	reg	niO0Oi;
	reg	niO0Ol;
	reg	niO0OO;
	reg	niO1ll;
	reg	niO1lO;
	reg	niO1Oi;
	reg	niO1Ol;
	reg	niO1OO;
	reg	niOi0i;
	reg	niOi0l;
	reg	niOi0O;
	reg	niOi1i;
	reg	niOi1l;
	reg	niOi1O;
	reg	niOiii;
	reg	niOiil;
	reg	niOiiO;
	reg	niOili;
	reg	niOill;
	reg	niOilO;
	reg	niOiOi;
	reg	niOiOl;
	reg	niOiOO;
	reg	nl00il;
	reg	nl0ilO;
	reg	nl0l0l;
	reg	nl0l0O;
	reg	nl0lOi;
	reg	nl0lOl;
	reg	nl0lOO;
	reg	nl1iii;
	reg	nl1iil;
	reg	nl1l0i;
	reg	nl1l1i;
	reg	nl1l1l;
	reg	nl1l1O;
	reg	nli10O;
	reg	nli1ii;
	reg	nli1il;
	reg	nli1iO;
	reg	nli1li;
	reg	nliiiO;
	reg	nliili;
	reg	nliill;
	reg	nliilO;
	reg	nliiOi;
	reg	nliOll;
	reg	nll00i;
	reg	nll00l;
	reg	nll00Oi;
	reg	nll10O;
	reg	nll1Ol;
	reg	nll1OO;
	reg	nlO00i;
	reg	nlO00l;
	reg	nlO00O;
	reg	nlO01i;
	reg	nlO01l;
	reg	nlO01O;
	reg	nlO0ii;
	reg	nlO0il;
	reg	nlO0iO;
	reg	nlO0li;
	reg	nlO0ll;
	reg	nlO0lO;
	reg	nlO0Oi;
	reg	nlO0Ol;
	reg	nlO0Oli;
	reg	nlO0OO;
	reg	nlO1li;
	reg	nlO1ll;
	reg	nlO1lO;
	reg	nlO1Oi;
	reg	nlO1Ol;
	reg	nlO1OO;
	reg	nlOi0i;
	reg	nlOi0l;
	reg	nlOi0O;
	reg	nlOi1i;
	reg	nlOi1l;
	reg	nlOi1O;
	reg	nlOill;
	reg	nlOilO;
	reg	nlOliiO;
	reg	nlOlili;
	reg	nlOlill;
	reg	nlOlilO;
	reg	nlOliOi;
	reg	nlOliOl;
	reg	nlOliOO;
	reg	nlOll0i;
	reg	nlOll0l;
	reg	nlOll0O;
	reg	nlOll1i;
	reg	nlOll1l;
	reg	nlOll1O;
	reg	nlOllii;
	reg	nlOlliO;
	reg	nlOllli;
	reg	nlOllll;
	reg	nlOlllO;
	reg	nlOllOi;
	reg	nlOllOl;
	reg	nlOllOO;
	reg	nlOlO0i;
	reg	nlOlO0l;
	reg	nlOlO0O;
	reg	nlOlO1i;
	reg	nlOlO1l;
	reg	nlOlO1O;
	reg	nlOlOii;
	reg	nlOlOil;
	reg	nlOlOiO;
	reg	nlOlOli;
	reg	nlOlOll;
	reg	nlOlOlO;
	reg	nlOlOO;
	reg	nlOlOOi;
	reg	nlOO1l;
	wire	wire_nlOO1i_CLRN;
	wire	wire_n0000l_dataout;
	wire	wire_n0010i_dataout;
	wire	wire_n0010l_dataout;
	wire	wire_n0011i_dataout;
	wire	wire_n0011l_dataout;
	wire	wire_n0011O_dataout;
	wire	wire_n001lO_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00i0i_dataout;
	wire	wire_n00i0l_dataout;
	wire	wire_n00i0O_dataout;
	wire	wire_n00iii_dataout;
	wire	wire_n00iil_dataout;
	wire	wire_n00iiO_dataout;
	wire	wire_n00ili_dataout;
	wire	wire_n00ill_dataout;
	wire	wire_n00ilO_dataout;
	wire	wire_n00iOi_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00lli_dataout;
	wire	wire_n00lll_dataout;
	wire	wire_n00llO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n0100i_dataout;
	wire	wire_n0100l_dataout;
	wire	wire_n0100O_dataout;
	wire	wire_n0101i_dataout;
	wire	wire_n0101l_dataout;
	wire	wire_n0101O_dataout;
	wire	wire_n010ii_dataout;
	wire	wire_n010il_dataout;
	wire	wire_n010ll_dataout;
	wire	wire_n010lO_dataout;
	wire	wire_n010Oi_dataout;
	wire	wire_n010Ol_dataout;
	wire	wire_n0111O_dataout;
	wire	wire_n011li_dataout;
	wire	wire_n011ll_dataout;
	wire	wire_n011lO_dataout;
	wire	wire_n011Oi_dataout;
	wire	wire_n011Ol_dataout;
	wire	wire_n011OO_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01i0i_dataout;
	wire	wire_n01i0l_dataout;
	wire	wire_n01i0O_dataout;
	wire	wire_n01iii_dataout;
	wire	wire_n01iil_dataout;
	wire	wire_n01iiO_dataout;
	wire	wire_n01ili_dataout;
	wire	wire_n01ill_dataout;
	wire	wire_n01ilO_dataout;
	wire	wire_n01iOi_dataout;
	wire	wire_n01iOl_dataout;
	wire	wire_n01iOO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01l0i_dataout;
	wire	wire_n01l0l_dataout;
	wire	wire_n01l0O_dataout;
	wire	wire_n01l1i_dataout;
	wire	wire_n01l1l_dataout;
	wire	wire_n01l1O_dataout;
	wire	wire_n01lii_dataout;
	wire	wire_n01lil_dataout;
	wire	wire_n01liO_dataout;
	wire	wire_n01lli_dataout;
	wire	wire_n01lll_dataout;
	wire	wire_n01llO_dataout;
	wire	wire_n01lOi_dataout;
	wire	wire_n01lOl_dataout;
	wire	wire_n01lOO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01O0i_dataout;
	wire	wire_n01O0l_dataout;
	wire	wire_n01O0O_dataout;
	wire	wire_n01O1i_dataout;
	wire	wire_n01O1l_dataout;
	wire	wire_n01O1O_dataout;
	wire	wire_n01Oii_dataout;
	wire	wire_n01Oil_dataout;
	wire	wire_n01OiO_dataout;
	wire	wire_n01Oli_dataout;
	wire	wire_n01Oll_dataout;
	wire	wire_n01OlO_dataout;
	wire	wire_n01OOi_dataout;
	wire	wire_n01OOl_dataout;
	wire	wire_n01OOO_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n100il_dataout;
	wire	wire_n100iO_dataout;
	wire	wire_n100li_dataout;
	wire	wire_n100ll_dataout;
	wire	wire_n100lO_dataout;
	wire	wire_n100Oi_dataout;
	wire	wire_n100Ol_dataout;
	wire	wire_n100OO_dataout;
	wire	wire_n1010i_dataout;
	wire	wire_n1011i_dataout;
	wire	wire_n1011l_dataout;
	wire	wire_n1011O_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10i1i_dataout;
	wire	wire_n10i1l_dataout;
	wire	wire_n10iOO_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10l0i_dataout;
	wire	wire_n10l1i_dataout;
	wire	wire_n10l1l_dataout;
	wire	wire_n10l1O_dataout;
	wire	wire_n10lli_dataout;
	wire	wire_n10lll_dataout;
	wire	wire_n10lOi_dataout;
	wire	wire_n10lOl_dataout;
	wire	wire_n10lOO_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10Oii_dataout;
	wire	wire_n10Oil_dataout;
	wire	wire_n10OOi_dataout;
	wire	wire_n1100i_dataout;
	wire	wire_n1100l_dataout;
	wire	wire_n1100O_dataout;
	wire	wire_n1101i_dataout;
	wire	wire_n1101l_dataout;
	wire	wire_n1101O_dataout;
	wire	wire_n110ii_dataout;
	wire	wire_n110ll_dataout;
	wire	wire_n1111i_dataout;
	wire	wire_n1111l_dataout;
	wire	wire_n1111O_dataout;
	wire	wire_n111ii_dataout;
	wire	wire_n111il_dataout;
	wire	wire_n111iO_dataout;
	wire	wire_n111li_dataout;
	wire	wire_n111ll_dataout;
	wire	wire_n111Oi_dataout;
	wire	wire_n111Ol_dataout;
	wire	wire_n111OO_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n11Oli_dataout;
	wire	wire_n11Oll_dataout;
	wire	wire_n11OlO_dataout;
	wire	wire_n11OOi_dataout;
	wire	wire_n11OOl_dataout;
	wire	wire_n11OOO_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i00l_dataout;
	wire	wire_n1i01i_dataout;
	wire	wire_n1i01l_dataout;
	wire	wire_n1i0iO_dataout;
	wire	wire_n1i0lO_dataout;
	wire	wire_n1i1ll_dataout;
	wire	wire_n1i1lO_dataout;
	wire	wire_n1i1Oi_dataout;
	wire	wire_n1i1Ol_dataout;
	wire	wire_n1i1OO_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1ii0O_dataout;
	wire	wire_n1iiii_dataout;
	wire	wire_n1iiil_dataout;
	wire	wire_n1iiiO_dataout;
	wire	wire_n1iili_dataout;
	wire	wire_n1iill_dataout;
	wire	wire_n1iilO_dataout;
	wire	wire_n1iiOi_dataout;
	wire	wire_n1iiOl_dataout;
	wire	wire_n1iiOO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1il0i_dataout;
	wire	wire_n1il0l_dataout;
	wire	wire_n1il0O_dataout;
	wire	wire_n1il1l_dataout;
	wire	wire_n1il1O_dataout;
	wire	wire_n1illl_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1l00i_dataout;
	wire	wire_n1l00l_dataout;
	wire	wire_n1l00O_dataout;
	wire	wire_n1l01i_dataout;
	wire	wire_n1l01l_dataout;
	wire	wire_n1l01O_dataout;
	wire	wire_n1l0ii_dataout;
	wire	wire_n1l0il_dataout;
	wire	wire_n1l1iO_dataout;
	wire	wire_n1l1li_dataout;
	wire	wire_n1l1ll_dataout;
	wire	wire_n1l1lO_dataout;
	wire	wire_n1l1Oi_dataout;
	wire	wire_n1l1Ol_dataout;
	wire	wire_n1l1OO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1li0i_dataout;
	wire	wire_n1li0l_dataout;
	wire	wire_n1li0O_dataout;
	wire	wire_n1li1O_dataout;
	wire	wire_n1liii_dataout;
	wire	wire_n1liil_dataout;
	wire	wire_n1liiO_dataout;
	wire	wire_n1lili_dataout;
	wire	wire_n1lill_dataout;
	wire	wire_n1lilO_dataout;
	wire	wire_n1liOi_dataout;
	wire	wire_n1liOl_dataout;
	wire	wire_n1liOO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1ll0i_dataout;
	wire	wire_n1ll0l_dataout;
	wire	wire_n1ll0O_dataout;
	wire	wire_n1ll1i_dataout;
	wire	wire_n1ll1l_dataout;
	wire	wire_n1ll1O_dataout;
	wire	wire_n1llii_dataout;
	wire	wire_n1llil_dataout;
	wire	wire_n1lliO_dataout;
	wire	wire_n1llli_dataout;
	wire	wire_n1llll_dataout;
	wire	wire_n1lllO_dataout;
	wire	wire_n1llOi_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1O0ii_dataout;
	wire	wire_n1O0OO_dataout;
	wire	wire_n1O1Ol_dataout;
	wire	wire_n1O1OO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oi0i_dataout;
	wire	wire_n1Oi0l_dataout;
	wire	wire_n1Oi0O_dataout;
	wire	wire_n1Oi1i_dataout;
	wire	wire_n1Oi1l_dataout;
	wire	wire_n1Oi1O_dataout;
	wire	wire_n1Oiii_dataout;
	wire	wire_n1Oiil_dataout;
	wire	wire_n1OiiO_dataout;
	wire	wire_n1Oili_dataout;
	wire	wire_n1Oill_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Ol0i_dataout;
	wire	wire_n1Ol0l_dataout;
	wire	wire_n1Ol1l_dataout;
	wire	wire_n1Ol1O_dataout;
	wire	wire_n1OliO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OO0l_dataout;
	wire	wire_n1OO1i_dataout;
	wire	wire_n1OO1O_dataout;
	wire	wire_n1OOiO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni000i_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni001i_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni001O_dataout;
	wire	wire_ni00ii_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00iO_dataout;
	wire	wire_ni00li_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00Oi_dataout;
	wire	wire_ni00Ol_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010l_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011i_dataout;
	wire	wire_ni011l_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni01ii_dataout;
	wire	wire_ni01il_dataout;
	wire	wire_ni01iO_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01ll_dataout;
	wire	wire_ni01lO_dataout;
	wire	wire_ni01Oi_dataout;
	wire	wire_ni01Ol_dataout;
	wire	wire_ni01OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0i0i_dataout;
	wire	wire_ni0i0l_dataout;
	wire	wire_ni0i0O_dataout;
	wire	wire_ni0i1i_dataout;
	wire	wire_ni0i1l_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0iii_dataout;
	wire	wire_ni0iil_dataout;
	wire	wire_ni0iiO_dataout;
	wire	wire_ni0ili_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0ilO_dataout;
	wire	wire_ni0iOi_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0l0i_dataout;
	wire	wire_ni0l0l_dataout;
	wire	wire_ni0l0O_dataout;
	wire	wire_ni0l1i_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0lii_dataout;
	wire	wire_ni0lil_dataout;
	wire	wire_ni0liO_dataout;
	wire	wire_ni0lli_dataout;
	wire	wire_ni0lll_dataout;
	wire	wire_ni0llO_dataout;
	wire	wire_ni0lOi_dataout;
	wire	wire_ni0lOl_dataout;
	wire	wire_ni0lOO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0O0i_dataout;
	wire	wire_ni0O0l_dataout;
	wire	wire_ni100i_dataout;
	wire	wire_ni100l_dataout;
	wire	wire_ni100O_dataout;
	wire	wire_ni101O_dataout;
	wire	wire_ni10ii_dataout;
	wire	wire_ni10il_dataout;
	wire	wire_ni10iO_dataout;
	wire	wire_ni10li_dataout;
	wire	wire_ni10ll_dataout;
	wire	wire_ni10lO_dataout;
	wire	wire_ni10Oi_dataout;
	wire	wire_ni10Ol_dataout;
	wire	wire_ni10OO_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1i0i_dataout;
	wire	wire_ni1i0l_dataout;
	wire	wire_ni1i0O_dataout;
	wire	wire_ni1i1i_dataout;
	wire	wire_ni1i1l_dataout;
	wire	wire_ni1i1O_dataout;
	wire	wire_ni1iii_dataout;
	wire	wire_ni1iil_dataout;
	wire	wire_ni1iiO_dataout;
	wire	wire_ni1ili_dataout;
	wire	wire_ni1ill_dataout;
	wire	wire_ni1ilO_dataout;
	wire	wire_ni1iOi_dataout;
	wire	wire_ni1iOl_dataout;
	wire	wire_ni1iOO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0i_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1l1i_dataout;
	wire	wire_ni1l1l_dataout;
	wire	wire_ni1l1O_dataout;
	wire	wire_ni1lii_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1lll_dataout;
	wire	wire_ni1llO_dataout;
	wire	wire_ni1lOi_dataout;
	wire	wire_ni1lOl_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1O0i_dataout;
	wire	wire_ni1O0l_dataout;
	wire	wire_ni1O0O_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1O1l_dataout;
	wire	wire_ni1O1O_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1Oil_dataout;
	wire	wire_ni1OiO_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OlO_dataout;
	wire	wire_ni1OOi_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiilO_dataout;
	wire	wire_niiiOi_dataout;
	wire	wire_niiiOl_dataout;
	wire	wire_niiiOO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niil0i_dataout;
	wire	wire_niil0l_dataout;
	wire	wire_niil0O_dataout;
	wire	wire_niil1i_dataout;
	wire	wire_niil1l_dataout;
	wire	wire_niil1O_dataout;
	wire	wire_niilii_dataout;
	wire	wire_niilil_dataout;
	wire	wire_niiliO_dataout;
	wire	wire_niilli_dataout;
	wire	wire_niilll_dataout;
	wire	wire_niillO_dataout;
	wire	wire_niilOi_dataout;
	wire	wire_niilOl_dataout;
	wire	wire_niilOO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiO0i_dataout;
	wire	wire_niiO0l_dataout;
	wire	wire_niiO0O_dataout;
	wire	wire_niiO1i_dataout;
	wire	wire_niiO1l_dataout;
	wire	wire_niiO1O_dataout;
	wire	wire_niiOii_dataout;
	wire	wire_niiOil_dataout;
	wire	wire_niiOiO_dataout;
	wire	wire_niiOli_dataout;
	wire	wire_niiOll_dataout;
	wire	wire_niiOlO_dataout;
	wire	wire_niiOOi_dataout;
	wire	wire_niiOOl_dataout;
	wire	wire_niiOOO_dataout;
	wire	wire_nil00i_dataout;
	wire	wire_nil00l_dataout;
	wire	wire_nil00O_dataout;
	wire	wire_nil01i_dataout;
	wire	wire_nil01l_dataout;
	wire	wire_nil01O_dataout;
	wire	wire_nil0ii_dataout;
	wire	wire_nil0il_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nil10i_dataout;
	wire	wire_nil10l_dataout;
	wire	wire_nil10O_dataout;
	wire	wire_nil11i_dataout;
	wire	wire_nil11l_dataout;
	wire	wire_nil11O_dataout;
	wire	wire_nil1ii_dataout;
	wire	wire_nil1il_dataout;
	wire	wire_nil1iO_dataout;
	wire	wire_nil1li_dataout;
	wire	wire_nil1ll_dataout;
	wire	wire_nil1lO_dataout;
	wire	wire_nil1Oi_dataout;
	wire	wire_nil1Ol_dataout;
	wire	wire_nil1OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0i_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili0O_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_niliii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilili_dataout;
	wire	wire_nilill_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliOi_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilliO_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillli_dataout;
	wire	wire_nillll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nillOi_dataout;
	wire	wire_nillOl_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilO1l_dataout;
	wire	wire_nilO1O_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO0i_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl0i_dataout;
	wire	wire_niOl0l_dataout;
	wire	wire_niOl0O_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOl1O_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOlii_dataout;
	wire	wire_niOlil_dataout;
	wire	wire_niOliO_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlli_dataout;
	wire	wire_niOlll_dataout;
	wire	wire_niOllO_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOlOl_dataout;
	wire	wire_niOlOO_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOO0i_dataout;
	wire	wire_niOO0l_dataout;
	wire	wire_niOO0O_dataout;
	wire	wire_niOO1i_dataout;
	wire	wire_niOO1l_dataout;
	wire	wire_niOO1O_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOii_dataout;
	wire	wire_niOOil_dataout;
	wire	wire_niOOiO_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOli_dataout;
	wire	wire_niOOll_dataout;
	wire	wire_niOOlO_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_niOOOi_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_niOOOO_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl00iO_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl00lO_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl00Oi_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01l_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01O_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0i_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0iOi_dataout;
	wire	wire_nl0iOl_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l1l_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0O0i_dataout;
	wire	wire_nl0O0l_dataout;
	wire	wire_nl0O0O_dataout;
	wire	wire_nl0O1i_dataout;
	wire	wire_nl0O1l_dataout;
	wire	wire_nl0O1O_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Oii_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0Oli_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl0OOl_dataout;
	wire	wire_nl100i_dataout;
	wire	wire_nl100l_dataout;
	wire	wire_nl100O_dataout;
	wire	wire_nl101i_dataout;
	wire	wire_nl101l_dataout;
	wire	wire_nl101O_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10ii_dataout;
	wire	wire_nl10il_dataout;
	wire	wire_nl10iO_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10li_dataout;
	wire	wire_nl10lO_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl10Oi_dataout;
	wire	wire_nl10Ol_dataout;
	wire	wire_nl10OO_dataout;
	wire	wire_nl110i_dataout;
	wire	wire_nl110l_dataout;
	wire	wire_nl110O_dataout;
	wire	wire_nl111i_dataout;
	wire	wire_nl111l_dataout;
	wire	wire_nl111O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11ii_dataout;
	wire	wire_nl11il_dataout;
	wire	wire_nl11iO_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11li_dataout;
	wire	wire_nl11ll_dataout;
	wire	wire_nl11lO_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl11Oi_dataout;
	wire	wire_nl11Ol_dataout;
	wire	wire_nl11OO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0i_dataout;
	wire	wire_nl1i0l_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1i1i_dataout;
	wire	wire_nl1i1l_dataout;
	wire	wire_nl1i1O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1iO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l0O_dataout;
	wire	wire_nl1li_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1ll_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1Oi_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nl1OO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli11l_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nliiOl_dataout;
	wire	wire_nliiOO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0i_dataout;
	wire	wire_nlil0l_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlil1i_dataout;
	wire	wire_nlil1l_dataout;
	wire	wire_nlil1O_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlillO_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nlilOi_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nliOOi_dataout;
	wire	wire_nliOOl_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll00O_dataout;
	wire	wire_nll00Ol_dataout;
	wire	wire_nll00OO_dataout;
	wire	wire_nll01i_dataout;
	wire	wire_nll01l_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0i1i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll0Ol_dataout;
	wire	wire_nll0OO_dataout;
	wire	wire_nll11O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1ii_dataout;
	wire	wire_nll1il_dataout;
	wire	wire_nll1iO_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1li_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nlliiO_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nllili_dataout;
	wire	wire_nllilO_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlliOi_dataout;
	wire	wire_nlliOl_dataout;
	wire	wire_nlliOO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlll0i_dataout;
	wire	wire_nlll0l_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlll1i_dataout;
	wire	wire_nlll1l_dataout;
	wire	wire_nlll1O_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nlllii_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0i_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOil_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOl0i_dataout;
	wire	wire_nllOl0l_dataout;
	wire	wire_nllOl0O_dataout;
	wire	wire_nllOl1O_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOlii_dataout;
	wire	wire_nllOlil_dataout;
	wire	wire_nllOliO_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlli_dataout;
	wire	wire_nllOlll_dataout;
	wire	wire_nllOllO_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOlOi_dataout;
	wire	wire_nllOlOl_dataout;
	wire	wire_nllOlOO_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nllOO0i_dataout;
	wire	wire_nllOO0l_dataout;
	wire	wire_nllOO0O_dataout;
	wire	wire_nllOO1i_dataout;
	wire	wire_nllOO1l_dataout;
	wire	wire_nllOO1O_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOii_dataout;
	wire	wire_nllOOil_dataout;
	wire	wire_nllOOiO_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOli_dataout;
	wire	wire_nllOOll_dataout;
	wire	wire_nllOOlO_dataout;
	wire	wire_nllOOOi_dataout;
	wire	wire_nllOOOl_dataout;
	wire	wire_nllOOOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO000i_dataout;
	wire	wire_nlO000l_dataout;
	wire	wire_nlO001i_dataout;
	wire	wire_nlO010i_dataout;
	wire	wire_nlO010l_dataout;
	wire	wire_nlO010O_dataout;
	wire	wire_nlO011i_dataout;
	wire	wire_nlO011l_dataout;
	wire	wire_nlO011O_dataout;
	wire	wire_nlO01ii_dataout;
	wire	wire_nlO01il_dataout;
	wire	wire_nlO01iO_dataout;
	wire	wire_nlO01li_dataout;
	wire	wire_nlO01ll_dataout;
	wire	wire_nlO01lO_dataout;
	wire	wire_nlO01Oi_dataout;
	wire	wire_nlO01Ol_dataout;
	wire	wire_nlO01OO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO0Oll_dataout;
	wire	wire_nlO0OlO_dataout;
	wire	wire_nlO0OOi_dataout;
	wire	wire_nlO0OOl_dataout;
	wire	wire_nlO0OOO_dataout;
	wire	wire_nlO100i_dataout;
	wire	wire_nlO100l_dataout;
	wire	wire_nlO100O_dataout;
	wire	wire_nlO101i_dataout;
	wire	wire_nlO101l_dataout;
	wire	wire_nlO101O_dataout;
	wire	wire_nlO10ii_dataout;
	wire	wire_nlO10il_dataout;
	wire	wire_nlO10iO_dataout;
	wire	wire_nlO10li_dataout;
	wire	wire_nlO10ll_dataout;
	wire	wire_nlO10lO_dataout;
	wire	wire_nlO10Oi_dataout;
	wire	wire_nlO10Ol_dataout;
	wire	wire_nlO10OO_dataout;
	wire	wire_nlO110i_dataout;
	wire	wire_nlO110l_dataout;
	wire	wire_nlO110O_dataout;
	wire	wire_nlO111i_dataout;
	wire	wire_nlO111l_dataout;
	wire	wire_nlO111O_dataout;
	wire	wire_nlO11ii_dataout;
	wire	wire_nlO11il_dataout;
	wire	wire_nlO11iO_dataout;
	wire	wire_nlO11li_dataout;
	wire	wire_nlO11ll_dataout;
	wire	wire_nlO11lO_dataout;
	wire	wire_nlO11Oi_dataout;
	wire	wire_nlO11Ol_dataout;
	wire	wire_nlO11OO_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1i0i_dataout;
	wire	wire_nlO1i0l_dataout;
	wire	wire_nlO1i0O_dataout;
	wire	wire_nlO1i1i_dataout;
	wire	wire_nlO1i1l_dataout;
	wire	wire_nlO1i1O_dataout;
	wire	wire_nlO1iii_dataout;
	wire	wire_nlO1iil_dataout;
	wire	wire_nlO1iiO_dataout;
	wire	wire_nlO1ili_dataout;
	wire	wire_nlO1ill_dataout;
	wire	wire_nlO1ilO_dataout;
	wire	wire_nlO1iOi_dataout;
	wire	wire_nlO1iOl_dataout;
	wire	wire_nlO1iOO_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1l0i_dataout;
	wire	wire_nlO1l0l_dataout;
	wire	wire_nlO1l0O_dataout;
	wire	wire_nlO1l1i_dataout;
	wire	wire_nlO1l1l_dataout;
	wire	wire_nlO1l1O_dataout;
	wire	wire_nlO1lii_dataout;
	wire	wire_nlO1lil_dataout;
	wire	wire_nlO1liO_dataout;
	wire	wire_nlO1lli_dataout;
	wire	wire_nlO1lll_dataout;
	wire	wire_nlO1llO_dataout;
	wire	wire_nlO1lOi_dataout;
	wire	wire_nlO1lOO_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlO1O0i_dataout;
	wire	wire_nlO1O0l_dataout;
	wire	wire_nlO1O0O_dataout;
	wire	wire_nlO1O1i_dataout;
	wire	wire_nlO1O1l_dataout;
	wire	wire_nlO1O1O_dataout;
	wire	wire_nlO1Oii_dataout;
	wire	wire_nlO1Oil_dataout;
	wire	wire_nlO1OiO_dataout;
	wire	wire_nlO1Oli_dataout;
	wire	wire_nlO1Oll_dataout;
	wire	wire_nlO1OlO_dataout;
	wire	wire_nlO1OOi_dataout;
	wire	wire_nlO1OOl_dataout;
	wire	wire_nlO1OOO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOi00i_dataout;
	wire	wire_nlOi00l_dataout;
	wire	wire_nlOi00O_dataout;
	wire	wire_nlOi01i_dataout;
	wire	wire_nlOi01l_dataout;
	wire	wire_nlOi01O_dataout;
	wire	wire_nlOi0ii_dataout;
	wire	wire_nlOi0il_dataout;
	wire	wire_nlOi0iO_dataout;
	wire	wire_nlOi0li_dataout;
	wire	wire_nlOi0ll_dataout;
	wire	wire_nlOi0lO_dataout;
	wire	wire_nlOi0Oi_dataout;
	wire	wire_nlOi0Ol_dataout;
	wire	wire_nlOi0OO_dataout;
	wire	wire_nlOi10i_dataout;
	wire	wire_nlOi10l_dataout;
	wire	wire_nlOi10O_dataout;
	wire	wire_nlOi11i_dataout;
	wire	wire_nlOi11l_dataout;
	wire	wire_nlOi11O_dataout;
	wire	wire_nlOi1ii_dataout;
	wire	wire_nlOi1il_dataout;
	wire	wire_nlOi1iO_dataout;
	wire	wire_nlOi1li_dataout;
	wire	wire_nlOi1ll_dataout;
	wire	wire_nlOi1lO_dataout;
	wire	wire_nlOi1Oi_dataout;
	wire	wire_nlOi1Ol_dataout;
	wire	wire_nlOi1OO_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOii0i_dataout;
	wire	wire_nlOii0l_dataout;
	wire	wire_nlOii0O_dataout;
	wire	wire_nlOii1i_dataout;
	wire	wire_nlOii1l_dataout;
	wire	wire_nlOii1O_dataout;
	wire	wire_nlOiiii_dataout;
	wire	wire_nlOiiil_dataout;
	wire	wire_nlOiiiO_dataout;
	wire	wire_nlOiili_dataout;
	wire	wire_nlOiill_dataout;
	wire	wire_nlOiilO_dataout;
	wire	wire_nlOiiOi_dataout;
	wire	wire_nlOiiOl_dataout;
	wire	wire_nlOiiOO_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOil0i_dataout;
	wire	wire_nlOil0l_dataout;
	wire	wire_nlOil0O_dataout;
	wire	wire_nlOil1i_dataout;
	wire	wire_nlOil1l_dataout;
	wire	wire_nlOil1O_dataout;
	wire	wire_nlOilii_dataout;
	wire	wire_nlOilil_dataout;
	wire	wire_nlOiliO_dataout;
	wire	wire_nlOilli_dataout;
	wire	wire_nlOilll_dataout;
	wire	wire_nlOillO_dataout;
	wire	wire_nlOilOi_dataout;
	wire	wire_nlOilOl_dataout;
	wire	wire_nlOilOO_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOiO0i_dataout;
	wire	wire_nlOiO0l_dataout;
	wire	wire_nlOiO0O_dataout;
	wire	wire_nlOiO1i_dataout;
	wire	wire_nlOiO1l_dataout;
	wire	wire_nlOiO1O_dataout;
	wire	wire_nlOiOii_dataout;
	wire	wire_nlOiOil_dataout;
	wire	wire_nlOiOiO_dataout;
	wire	wire_nlOiOli_dataout;
	wire	wire_nlOiOll_dataout;
	wire	wire_nlOiOlO_dataout;
	wire	wire_nlOiOOi_dataout;
	wire	wire_nlOiOOl_dataout;
	wire	wire_nlOiOOO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOl00i_dataout;
	wire	wire_nlOl00l_dataout;
	wire	wire_nlOl01i_dataout;
	wire	wire_nlOl01l_dataout;
	wire	wire_nlOl01O_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl0Ol_dataout;
	wire	wire_nlOl0OO_dataout;
	wire	wire_nlOl10i_dataout;
	wire	wire_nlOl10l_dataout;
	wire	wire_nlOl10O_dataout;
	wire	wire_nlOl11i_dataout;
	wire	wire_nlOl11l_dataout;
	wire	wire_nlOl11O_dataout;
	wire	wire_nlOl1ii_dataout;
	wire	wire_nlOl1il_dataout;
	wire	wire_nlOl1iO_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1li_dataout;
	wire	wire_nlOl1ll_dataout;
	wire	wire_nlOl1lO_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOl1Oi_dataout;
	wire	wire_nlOl1Ol_dataout;
	wire	wire_nlOl1OO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOli1i_dataout;
	wire	wire_nlOli1l_dataout;
	wire	wire_nlOli1O_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOliO_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOOl_dataout;
	wire	wire_nlOlOOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO00i_dataout;
	wire	wire_nlOO00l_dataout;
	wire	wire_nlOO00O_dataout;
	wire	wire_nlOO01i_dataout;
	wire	wire_nlOO01l_dataout;
	wire	wire_nlOO01O_dataout;
	wire	wire_nlOO0ii_dataout;
	wire	wire_nlOO0il_dataout;
	wire	wire_nlOO0iO_dataout;
	wire	wire_nlOO0li_dataout;
	wire	wire_nlOO0ll_dataout;
	wire	wire_nlOO0lO_dataout;
	wire	wire_nlOO0Oi_dataout;
	wire	wire_nlOO0Ol_dataout;
	wire	wire_nlOO0OO_dataout;
	wire	wire_nlOO10i_dataout;
	wire	wire_nlOO10l_dataout;
	wire	wire_nlOO10O_dataout;
	wire	wire_nlOO11i_dataout;
	wire	wire_nlOO11l_dataout;
	wire	wire_nlOO11O_dataout;
	wire	wire_nlOO1ii_dataout;
	wire	wire_nlOO1il_dataout;
	wire	wire_nlOO1iO_dataout;
	wire	wire_nlOO1li_dataout;
	wire	wire_nlOO1ll_dataout;
	wire	wire_nlOO1lO_dataout;
	wire	wire_nlOO1Oi_dataout;
	wire	wire_nlOO1Ol_dataout;
	wire	wire_nlOO1OO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOi0i_dataout;
	wire	wire_nlOOi0l_dataout;
	wire	wire_nlOOi0O_dataout;
	wire	wire_nlOOi1i_dataout;
	wire	wire_nlOOi1l_dataout;
	wire	wire_nlOOi1O_dataout;
	wire	wire_nlOOiii_dataout;
	wire	wire_nlOOiil_dataout;
	wire	wire_nlOOiiO_dataout;
	wire	wire_nlOOili_dataout;
	wire	wire_nlOOill_dataout;
	wire	wire_nlOOilO_dataout;
	wire	wire_nlOOiOi_dataout;
	wire	wire_nlOOiOl_dataout;
	wire	wire_nlOOiOO_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOl0i_dataout;
	wire	wire_nlOOl0l_dataout;
	wire	wire_nlOOl0O_dataout;
	wire	wire_nlOOl1i_dataout;
	wire	wire_nlOOl1l_dataout;
	wire	wire_nlOOl1O_dataout;
	wire	wire_nlOOlii_dataout;
	wire	wire_nlOOlil_dataout;
	wire	wire_nlOOliO_dataout;
	wire	wire_nlOOlli_dataout;
	wire	wire_nlOOlll_dataout;
	wire	wire_nlOOllO_dataout;
	wire	wire_nlOOlOi_dataout;
	wire	wire_nlOOlOl_dataout;
	wire	wire_nlOOlOO_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nlOOO0i_dataout;
	wire	wire_nlOOO0l_dataout;
	wire	wire_nlOOO0O_dataout;
	wire	wire_nlOOO1i_dataout;
	wire	wire_nlOOO1l_dataout;
	wire	wire_nlOOO1O_dataout;
	wire	wire_nlOOOii_dataout;
	wire	wire_nlOOOil_dataout;
	wire	wire_nlOOOiO_dataout;
	wire	wire_nlOOOli_dataout;
	wire	wire_nlOOOll_dataout;
	wire	wire_nlOOOlO_dataout;
	wire	wire_nlOOOOi_dataout;
	wire	wire_nlOOOOl_dataout;
	wire	wire_nlOOOOO_dataout;
	wire  [5:0]   wire_n1110i_o;
	wire  [4:0]   wire_n111lO_o;
	wire  [5:0]   wire_n1i0ll_o;
	wire  [2:0]   wire_n1i0Ol_o;
	wire  [5:0]   wire_n1ilii_o;
	wire  [5:0]   wire_n1ilil_o;
	wire  [5:0]   wire_n1iliO_o;
	wire  [5:0]   wire_n1llOl_o;
	wire  [4:0]   wire_n1llOO_o;
	wire  [3:0]   wire_n1lO0O_o;
	wire  [4:0]   wire_n1lOil_o;
	wire  [2:0]   wire_n1OilO_o;
	wire  [4:0]   wire_niO10l_o;
	wire  [4:0]   wire_nl10ll_o;
	wire  [5:0]   wire_nli0lO_o;
	wire  [5:0]   wire_nli0Oi_o;
	wire  [5:0]   wire_nli0Ol_o;
	wire  [2:0]   wire_nli10i_o;
	wire  [5:0]   wire_nli11i_o;
	wire  [5:0]   wire_nlilOl_o;
	wire  [4:0]   wire_nlilOO_o;
	wire  [4:0]   wire_nlOli0i_o;
	wire  [31:0]   wire_n1010O_o;
	wire  [7:0]   wire_n101il_o;
	wire  [15:0]   wire_n101ll_o;
	wire  [7:0]   wire_n101lO_o;
	wire  [15:0]   wire_nilOil_o;
	wire  [15:0]   wire_nilOli_o;
	wire  [31:0]   wire_nilOOl_o;
	wire  [7:0]   wire_nl1O0i_o;
	wire  [31:0]   wire_nl1O1l_o;
	wire  [15:0]   wire_nl1Oii_o;
	wire  [7:0]   wire_nl1Oil_o;
	wire  [15:0]   wire_nlOl0ii_o;
	wire  [15:0]   wire_nlOl0iO_o;
	wire  [31:0]   wire_nlOl0Oi_o;
	wire  wire_n11l0l_o;
	wire  wire_n11lil_o;
	wire  wire_n11O0i_o;
	wire  wire_n1i0li_o;
	wire  wire_n1i0Oi_o;
	wire  wire_n1i0OO_o;
	wire  wire_n1illi_o;
	wire  wire_n1iOOO_o;
	wire  wire_n1l0ll_o;
	wire  wire_n1O00i_o;
	wire  wire_n1O00l_o;
	wire  wire_nl0OOO_o;
	wire  wire_nl1iOO_o;
	wire  wire_nli0OO_o;
	wire  wire_nli10l_o;
	wire  wire_nli11O_o;
	wire  wire_nlii0l_o;
	wire  wire_nliiil_o;
	wire  wire_nliOOO_o;
	wire  wire_nll11i_o;
	wire  wire_n000iO_o;
	wire  wire_n000li_o;
	wire  wire_n000ll_o;
	wire  wire_n000lO_o;
	wire  wire_n000Oi_o;
	wire  wire_n000Ol_o;
	wire  wire_n000OO_o;
	wire  wire_n00i1i_o;
	wire  wire_n00i1l_o;
	wire  wire_n00i1O_o;
	wire  wire_nlOiOi_o;
	wire  wire_nlOiOl_o;
	wire  wire_nlOiOO_o;
	wire  wire_nlOl1i_o;
	wire  [15:0]   wire_nlOiiO_data_out1;
	wire  [15:0]   wire_nlOiiO_data_out2;
	wire  [15:0]   wire_nlOili_data_out1;
	wire  [15:0]   wire_nlOili_data_out2;
	wire  nlill0i;
	wire  nlill0O;
	wire  nlill1O;
	wire  nlillii;
	wire  nlillil;
	wire  nlilliO;
	wire  nlillli;
	wire  nlillll;
	wire  nlilllO;
	wire  nlillOi;
	wire  nlillOl;
	wire  nlillOO;
	wire  nlilO0i;
	wire  nlilO0l;
	wire  nlilO0O;
	wire  nlilO1i;
	wire  nlilO1l;
	wire  nlilO1O;
	wire  nlilOii;
	wire  nlilOil;
	wire  nlilOiO;
	wire  nlilOli;
	wire  nlilOll;
	wire  nlilOlO;
	wire  nlilOOi;
	wire  nlilOOl;
	wire  nlilOOO;
	wire  nliO00i;
	wire  nliO00l;
	wire  nliO00O;
	wire  nliO01i;
	wire  nliO01l;
	wire  nliO01O;
	wire  nliO0ii;
	wire  nliO0il;
	wire  nliO0iO;
	wire  nliO0li;
	wire  nliO0ll;
	wire  nliO0lO;
	wire  nliO0Oi;
	wire  nliO0Ol;
	wire  nliO0OO;
	wire  nliO10i;
	wire  nliO10l;
	wire  nliO10O;
	wire  nliO11i;
	wire  nliO11l;
	wire  nliO11O;
	wire  nliO1ii;
	wire  nliO1il;
	wire  nliO1iO;
	wire  nliO1li;
	wire  nliO1ll;
	wire  nliO1lO;
	wire  nliO1Oi;
	wire  nliO1Ol;
	wire  nliO1OO;
	wire  nliOi0i;
	wire  nliOi0l;
	wire  nliOi0O;
	wire  nliOi1i;
	wire  nliOi1l;
	wire  nliOi1O;
	wire  nliOiii;
	wire  nliOiil;
	wire  nliOiiO;
	wire  nliOili;
	wire  nliOill;
	wire  nliOilO;
	wire  nliOiOi;
	wire  nliOiOl;
	wire  nliOiOO;
	wire  nliOl0i;
	wire  nliOl0l;
	wire  nliOl0O;
	wire  nliOl1i;
	wire  nliOl1l;
	wire  nliOl1O;
	wire  nliOlii;
	wire  nliOlil;
	wire  nliOlll;
	wire  nliOllO;
	wire  nliOlOi;
	wire  nliOlOl;
	wire  nliOlOO;
	wire  nliOO0i;
	wire  nliOO0l;
	wire  nliOO0O;
	wire  nliOO1i;
	wire  nliOO1l;
	wire  nliOO1O;
	wire  nliOOii;
	wire  nliOOil;
	wire  nliOOiO;
	wire  nliOOli;
	wire  nliOOll;
	wire  nliOOlO;
	wire  nliOOOi;
	wire  nliOOOl;
	wire  nliOOOO;
	wire  nll000O;
	wire  nll001i;
	wire  nll001l;
	wire  nll00iO;
	wire  nll010i;
	wire  nll011i;
	wire  nll01iO;
	wire  nll01lO;
	wire  nll01Oi;
	wire  nll01Ol;
	wire  nll01OO;
	wire  nll100i;
	wire  nll100l;
	wire  nll100O;
	wire  nll101i;
	wire  nll101l;
	wire  nll101O;
	wire  nll10ii;
	wire  nll10iO;
	wire  nll10li;
	wire  nll10ll;
	wire  nll10lO;
	wire  nll10Oi;
	wire  nll10Ol;
	wire  nll10OO;
	wire  nll110i;
	wire  nll110l;
	wire  nll110O;
	wire  nll111i;
	wire  nll111l;
	wire  nll11ii;
	wire  nll11il;
	wire  nll11iO;
	wire  nll11li;
	wire  nll11ll;
	wire  nll11lO;
	wire  nll11Oi;
	wire  nll11Ol;
	wire  nll11OO;
	wire  nll1i0i;
	wire  nll1i0l;
	wire  nll1i1i;
	wire  nll1iil;
	wire  nll1iiO;
	wire  nll1l0i;
	wire  nll1l0l;
	wire  nll1l0O;
	wire  nll1l1i;
	wire  nll1lii;
	wire  nll1lil;
	wire  nll1lll;
	wire  nll1llO;
	wire  nll1O0i;
	wire  nll1O0l;
	wire  nll1O1l;
	wire  nll1OlO;
	wire  nll1OOO;

	initial
		nlill0l55 = 0;
	always @ ( posedge clk_2)
		  nlill0l55 <= nlill0l56;
	event nlill0l55_event;
	initial
		#1 ->nlill0l55_event;
	always @(nlill0l55_event)
		nlill0l55 <= {1{1'b1}};
	initial
		nlill0l56 = 0;
	always @ ( posedge clk_2)
		  nlill0l56 <= nlill0l55;
	initial
		nliOliO53 = 0;
	always @ ( posedge clk_2)
		  nliOliO53 <= nliOliO54;
	event nliOliO53_event;
	initial
		#1 ->nliOliO53_event;
	always @(nliOliO53_event)
		nliOliO53 <= {1{1'b1}};
	initial
		nliOliO54 = 0;
	always @ ( posedge clk_2)
		  nliOliO54 <= nliOliO53;
	initial
		nliOlli51 = 0;
	always @ ( posedge clk_2)
		  nliOlli51 <= nliOlli52;
	event nliOlli51_event;
	initial
		#1 ->nliOlli51_event;
	always @(nliOlli51_event)
		nliOlli51 <= {1{1'b1}};
	initial
		nliOlli52 = 0;
	always @ ( posedge clk_2)
		  nliOlli52 <= nliOlli51;
	initial
		nll000l3 = 0;
	always @ ( posedge clk_2)
		  nll000l3 <= nll000l4;
	event nll000l3_event;
	initial
		#1 ->nll000l3_event;
	always @(nll000l3_event)
		nll000l3 <= {1{1'b1}};
	initial
		nll000l4 = 0;
	always @ ( posedge clk_2)
		  nll000l4 <= nll000l3;
	initial
		nll001O5 = 0;
	always @ ( posedge clk_2)
		  nll001O5 <= nll001O6;
	event nll001O5_event;
	initial
		#1 ->nll001O5_event;
	always @(nll001O5_event)
		nll001O5 <= {1{1'b1}};
	initial
		nll001O6 = 0;
	always @ ( posedge clk_2)
		  nll001O6 <= nll001O5;
	initial
		nll00li1 = 0;
	always @ ( posedge clk_2)
		  nll00li1 <= nll00li2;
	event nll00li1_event;
	initial
		#1 ->nll00li1_event;
	always @(nll00li1_event)
		nll00li1 <= {1{1'b1}};
	initial
		nll00li2 = 0;
	always @ ( posedge clk_2)
		  nll00li2 <= nll00li1;
	initial
		nll010l11 = 0;
	always @ ( posedge clk_2)
		  nll010l11 <= nll010l12;
	event nll010l11_event;
	initial
		#1 ->nll010l11_event;
	always @(nll010l11_event)
		nll010l11 <= {1{1'b1}};
	initial
		nll010l12 = 0;
	always @ ( posedge clk_2)
		  nll010l12 <= nll010l11;
	initial
		nll011l13 = 0;
	always @ ( posedge clk_2)
		  nll011l13 <= nll011l14;
	event nll011l13_event;
	initial
		#1 ->nll011l13_event;
	always @(nll011l13_event)
		nll011l13 <= {1{1'b1}};
	initial
		nll011l14 = 0;
	always @ ( posedge clk_2)
		  nll011l14 <= nll011l13;
	initial
		nll01ii10 = 0;
	always @ ( posedge clk_2)
		  nll01ii10 <= nll01ii9;
	initial
		nll01ii9 = 0;
	always @ ( posedge clk_2)
		  nll01ii9 <= nll01ii10;
	event nll01ii9_event;
	initial
		#1 ->nll01ii9_event;
	always @(nll01ii9_event)
		nll01ii9 <= {1{1'b1}};
	initial
		nll01li7 = 0;
	always @ ( posedge clk_2)
		  nll01li7 <= nll01li8;
	event nll01li7_event;
	initial
		#1 ->nll01li7_event;
	always @(nll01li7_event)
		nll01li7 <= {1{1'b1}};
	initial
		nll01li8 = 0;
	always @ ( posedge clk_2)
		  nll01li8 <= nll01li7;
	initial
		nll10il47 = 0;
	always @ ( posedge clk_2)
		  nll10il47 <= nll10il48;
	event nll10il47_event;
	initial
		#1 ->nll10il47_event;
	always @(nll10il47_event)
		nll10il47 <= {1{1'b1}};
	initial
		nll10il48 = 0;
	always @ ( posedge clk_2)
		  nll10il48 <= nll10il47;
	initial
		nll111O49 = 0;
	always @ ( posedge clk_2)
		  nll111O49 <= nll111O50;
	event nll111O49_event;
	initial
		#1 ->nll111O49_event;
	always @(nll111O49_event)
		nll111O49 <= {1{1'b1}};
	initial
		nll111O50 = 0;
	always @ ( posedge clk_2)
		  nll111O50 <= nll111O49;
	initial
		nll1i0O43 = 0;
	always @ ( posedge clk_2)
		  nll1i0O43 <= nll1i0O44;
	event nll1i0O43_event;
	initial
		#1 ->nll1i0O43_event;
	always @(nll1i0O43_event)
		nll1i0O43 <= {1{1'b1}};
	initial
		nll1i0O44 = 0;
	always @ ( posedge clk_2)
		  nll1i0O44 <= nll1i0O43;
	initial
		nll1i1l45 = 0;
	always @ ( posedge clk_2)
		  nll1i1l45 <= nll1i1l46;
	event nll1i1l45_event;
	initial
		#1 ->nll1i1l45_event;
	always @(nll1i1l45_event)
		nll1i1l45 <= {1{1'b1}};
	initial
		nll1i1l46 = 0;
	always @ ( posedge clk_2)
		  nll1i1l46 <= nll1i1l45;
	initial
		nll1ili41 = 0;
	always @ ( posedge clk_2)
		  nll1ili41 <= nll1ili42;
	event nll1ili41_event;
	initial
		#1 ->nll1ili41_event;
	always @(nll1ili41_event)
		nll1ili41 <= {1{1'b1}};
	initial
		nll1ili42 = 0;
	always @ ( posedge clk_2)
		  nll1ili42 <= nll1ili41;
	initial
		nll1ilO39 = 0;
	always @ ( posedge clk_2)
		  nll1ilO39 <= nll1ilO40;
	event nll1ilO39_event;
	initial
		#1 ->nll1ilO39_event;
	always @(nll1ilO39_event)
		nll1ilO39 <= {1{1'b1}};
	initial
		nll1ilO40 = 0;
	always @ ( posedge clk_2)
		  nll1ilO40 <= nll1ilO39;
	initial
		nll1iOl37 = 0;
	always @ ( posedge clk_2)
		  nll1iOl37 <= nll1iOl38;
	event nll1iOl37_event;
	initial
		#1 ->nll1iOl37_event;
	always @(nll1iOl37_event)
		nll1iOl37 <= {1{1'b1}};
	initial
		nll1iOl38 = 0;
	always @ ( posedge clk_2)
		  nll1iOl38 <= nll1iOl37;
	initial
		nll1l1l35 = 0;
	always @ ( posedge clk_2)
		  nll1l1l35 <= nll1l1l36;
	event nll1l1l35_event;
	initial
		#1 ->nll1l1l35_event;
	always @(nll1l1l35_event)
		nll1l1l35 <= {1{1'b1}};
	initial
		nll1l1l36 = 0;
	always @ ( posedge clk_2)
		  nll1l1l36 <= nll1l1l35;
	initial
		nll1liO33 = 0;
	always @ ( posedge clk_2)
		  nll1liO33 <= nll1liO34;
	event nll1liO33_event;
	initial
		#1 ->nll1liO33_event;
	always @(nll1liO33_event)
		nll1liO33 <= {1{1'b1}};
	initial
		nll1liO34 = 0;
	always @ ( posedge clk_2)
		  nll1liO34 <= nll1liO33;
	initial
		nll1lOi31 = 0;
	always @ ( posedge clk_2)
		  nll1lOi31 <= nll1lOi32;
	event nll1lOi31_event;
	initial
		#1 ->nll1lOi31_event;
	always @(nll1lOi31_event)
		nll1lOi31 <= {1{1'b1}};
	initial
		nll1lOi32 = 0;
	always @ ( posedge clk_2)
		  nll1lOi32 <= nll1lOi31;
	initial
		nll1lOl29 = 0;
	always @ ( posedge clk_2)
		  nll1lOl29 <= nll1lOl30;
	event nll1lOl29_event;
	initial
		#1 ->nll1lOl29_event;
	always @(nll1lOl29_event)
		nll1lOl29 <= {1{1'b1}};
	initial
		nll1lOl30 = 0;
	always @ ( posedge clk_2)
		  nll1lOl30 <= nll1lOl29;
	initial
		nll1lOO27 = 0;
	always @ ( posedge clk_2)
		  nll1lOO27 <= nll1lOO28;
	event nll1lOO27_event;
	initial
		#1 ->nll1lOO27_event;
	always @(nll1lOO27_event)
		nll1lOO27 <= {1{1'b1}};
	initial
		nll1lOO28 = 0;
	always @ ( posedge clk_2)
		  nll1lOO28 <= nll1lOO27;
	initial
		nll1O0O21 = 0;
	always @ ( posedge clk_2)
		  nll1O0O21 <= nll1O0O22;
	event nll1O0O21_event;
	initial
		#1 ->nll1O0O21_event;
	always @(nll1O0O21_event)
		nll1O0O21 <= {1{1'b1}};
	initial
		nll1O0O22 = 0;
	always @ ( posedge clk_2)
		  nll1O0O22 <= nll1O0O21;
	initial
		nll1O1i25 = 0;
	always @ ( posedge clk_2)
		  nll1O1i25 <= nll1O1i26;
	event nll1O1i25_event;
	initial
		#1 ->nll1O1i25_event;
	always @(nll1O1i25_event)
		nll1O1i25 <= {1{1'b1}};
	initial
		nll1O1i26 = 0;
	always @ ( posedge clk_2)
		  nll1O1i26 <= nll1O1i25;
	initial
		nll1O1O23 = 0;
	always @ ( posedge clk_2)
		  nll1O1O23 <= nll1O1O24;
	event nll1O1O23_event;
	initial
		#1 ->nll1O1O23_event;
	always @(nll1O1O23_event)
		nll1O1O23 <= {1{1'b1}};
	initial
		nll1O1O24 = 0;
	always @ ( posedge clk_2)
		  nll1O1O24 <= nll1O1O23;
	initial
		nll1Oil19 = 0;
	always @ ( posedge clk_2)
		  nll1Oil19 <= nll1Oil20;
	event nll1Oil19_event;
	initial
		#1 ->nll1Oil19_event;
	always @(nll1Oil19_event)
		nll1Oil19 <= {1{1'b1}};
	initial
		nll1Oil20 = 0;
	always @ ( posedge clk_2)
		  nll1Oil20 <= nll1Oil19;
	initial
		nll1Oli17 = 0;
	always @ ( posedge clk_2)
		  nll1Oli17 <= nll1Oli18;
	event nll1Oli17_event;
	initial
		#1 ->nll1Oli17_event;
	always @(nll1Oli17_event)
		nll1Oli17 <= {1{1'b1}};
	initial
		nll1Oli18 = 0;
	always @ ( posedge clk_2)
		  nll1Oli18 <= nll1Oli17;
	initial
		nll1OOi15 = 0;
	always @ ( posedge clk_2)
		  nll1OOi15 <= nll1OOi16;
	event nll1OOi15_event;
	initial
		#1 ->nll1OOi15_event;
	always @(nll1OOi15_event)
		nll1OOi15 <= {1{1'b1}};
	initial
		nll1OOi16 = 0;
	always @ ( posedge clk_2)
		  nll1OOi16 <= nll1OOi15;
	initial
	begin
		n0OiiO = 0;
		n0Oili = 0;
		n0Oill = 0;
		n0OilO = 0;
		n0OiOi = 0;
		n0OiOl = 0;
		n0OiOO = 0;
		n0Ol0i = 0;
		n0Ol0l = 0;
		n0Ol0O = 0;
		n0Ol1i = 0;
		n0Ol1l = 0;
		n0Ol1O = 0;
		n0Olii = 0;
		n0Olil = 0;
		n0OliO = 0;
		n0Olli = 0;
		n0Olll = 0;
		n0OllO = 0;
		n0OlOi = 0;
		ni11ll = 0;
		ni11Ol = 0;
	end
	always @ (clk_2 or wire_ni11Oi_PRN or wire_ni11Oi_CLRN)
	begin
		if (wire_ni11Oi_PRN == 1'b0) 
		begin
			n0OiiO <= 1;
			n0Oili <= 1;
			n0Oill <= 1;
			n0OilO <= 1;
			n0OiOi <= 1;
			n0OiOl <= 1;
			n0OiOO <= 1;
			n0Ol0i <= 1;
			n0Ol0l <= 1;
			n0Ol0O <= 1;
			n0Ol1i <= 1;
			n0Ol1l <= 1;
			n0Ol1O <= 1;
			n0Olii <= 1;
			n0Olil <= 1;
			n0OliO <= 1;
			n0Olli <= 1;
			n0Olll <= 1;
			n0OllO <= 1;
			n0OlOi <= 1;
			ni11ll <= 1;
			ni11Ol <= 1;
		end
		else if  (wire_ni11Oi_CLRN == 1'b0) 
		begin
			n0OiiO <= 0;
			n0Oili <= 0;
			n0Oill <= 0;
			n0OilO <= 0;
			n0OiOi <= 0;
			n0OiOl <= 0;
			n0OiOO <= 0;
			n0Ol0i <= 0;
			n0Ol0l <= 0;
			n0Ol0O <= 0;
			n0Ol1i <= 0;
			n0Ol1l <= 0;
			n0Ol1O <= 0;
			n0Olii <= 0;
			n0Olil <= 0;
			n0OliO <= 0;
			n0Olli <= 0;
			n0Olll <= 0;
			n0OllO <= 0;
			n0OlOi <= 0;
			ni11ll <= 0;
			ni11Ol <= 0;
		end
		else if  (nl0ill == 1'b0) 
		if (clk_2 != ni11Oi_clk_prev && clk_2 == 1'b1) 
		begin
			n0OiiO <= wire_ni1l0i_dataout;
			n0Oili <= wire_ni1l0l_dataout;
			n0Oill <= wire_ni1l0O_dataout;
			n0OilO <= wire_ni1lii_dataout;
			n0OiOi <= wire_ni1lil_dataout;
			n0OiOl <= wire_ni1liO_dataout;
			n0OiOO <= wire_ni1lli_dataout;
			n0Ol0i <= wire_ni1l1O_dataout;
			n0Ol0l <= wire_ni1lOl_dataout;
			n0Ol0O <= wire_ni1lOO_dataout;
			n0Ol1i <= wire_ni1lll_dataout;
			n0Ol1l <= wire_ni1llO_dataout;
			n0Ol1O <= wire_ni1lOi_dataout;
			n0Olii <= wire_ni1O1i_dataout;
			n0Olil <= wire_ni1O1l_dataout;
			n0OliO <= wire_ni1O1O_dataout;
			n0Olli <= wire_ni1O0i_dataout;
			n0Olll <= wire_ni1O0l_dataout;
			n0OllO <= wire_ni1O0O_dataout;
			n0OlOi <= wire_ni1Oii_dataout;
			ni11ll <= wire_ni000l_dataout;
			ni11Ol <= wire_ni00ii_dataout;
		end
		ni11Oi_clk_prev <= clk_2;
	end
	assign
		wire_ni11Oi_CLRN = ((nliOlli52 ^ nliOlli51) & (~ nll00iO)),
		wire_ni11Oi_PRN = (nliOliO54 ^ nliOliO53);
	initial
	begin
		n0i = 0;
		nil = 0;
	end
	always @ (clk_2 or hard_reset or wire_nii_CLRN)
	begin
		if (hard_reset == 1'b1) 
		begin
			n0i <= 1;
			nil <= 1;
		end
		else if  (wire_nii_CLRN == 1'b0) 
		begin
			n0i <= 0;
			nil <= 0;
		end
		else 
		if (clk_2 != nii_clk_prev && clk_2 == 1'b1) 
		begin
			n0i <= wire_niO_dataout;
			nil <= n0i;
		end
		nii_clk_prev <= clk_2;
	end
	assign
		wire_nii_CLRN = (nll000l4 ^ nll000l3);
	initial
	begin
		nii00O = 0;
		nii11i = 0;
		nlO0i1i = 0;
		nlO0l0l = 0;
	end
	always @ ( posedge clk_2 or  posedge nll00iO)
	begin
		if (nll00iO == 1'b1) 
		begin
			nii00O <= 1;
			nii11i <= 1;
			nlO0i1i <= 1;
			nlO0l0l <= 1;
		end
		else 
		begin
			nii00O <= wire_niiOlO_dataout;
			nii11i <= wire_niilil_dataout;
			nlO0i1i <= wire_nlOi1ii_dataout;
			nlO0l0l <= wire_nlOi0ll_dataout;
		end
	end
	initial
	begin
		n1O = 0;
		nO = 0;
	end
	always @ (clk_1 or nll00iO or wire_nl_CLRN)
	begin
		if (nll00iO == 1'b1) 
		begin
			n1O <= 1;
			nO <= 1;
		end
		else if  (wire_nl_CLRN == 1'b0) 
		begin
			n1O <= 0;
			nO <= 0;
		end
		else 
		if (clk_1 != nl_clk_prev && clk_1 == 1'b1) 
		begin
			n1O <= nll001l;
			nO <= n1O;
		end
		nl_clk_prev <= clk_1;
	end
	assign
		wire_nl_CLRN = (nll00li2 ^ nll00li1);
	initial
	begin
		n1i10l = 0;
		n1i10O = 0;
		n1i1ii = 0;
		niO0li = 0;
		nl0liO = 0;
		nl0lli = 0;
		nl0llO = 0;
		nlOllil = 0;
	end
	always @ ( posedge clk_1 or  negedge wire_nl0lll_PRN)
	begin
		if (wire_nl0lll_PRN == 1'b0) 
		begin
			n1i10l <= 1;
			n1i10O <= 1;
			n1i1ii <= 1;
			niO0li <= 1;
			nl0liO <= 1;
			nl0lli <= 1;
			nl0llO <= 1;
			nlOllil <= 1;
		end
		else 
		begin
			n1i10l <= wire_n1i1lO_dataout;
			n1i10O <= wire_n1i1Oi_dataout;
			n1i1ii <= wire_n1i1Ol_dataout;
			niO0li <= wire_niOl0O_dataout;
			nl0liO <= wire_nl0O1l_dataout;
			nl0lli <= wire_nl0O1O_dataout;
			nl0llO <= wire_nl0O0i_dataout;
			nlOllil <= wire_nlOO10i_dataout;
		end
	end
	assign
		wire_nl0lll_PRN = ((nll111O50 ^ nll111O49) & (~ wire_n1l_dataout));
	initial
	begin
		n00lii = 0;
		n00lil = 0;
		n0OlOl = 0;
		n0OlOO = 0;
		n0OO0i = 0;
		n0OO0l = 0;
		n0OO0O = 0;
		n0OO1i = 0;
		n0OO1l = 0;
		n0OO1O = 0;
		n0OOii = 0;
		n0OOil = 0;
		n0OOiO = 0;
		n0OOli = 0;
		n0OOll = 0;
		n0OOlO = 0;
		n0OOOi = 0;
		n0OOOl = 0;
		n0OOOO = 0;
		n1000i = 0;
		n1000l = 0;
		n1000O = 0;
		n1001i = 0;
		n1001l = 0;
		n1001O = 0;
		n100ii = 0;
		n101Oi = 0;
		n101Ol = 0;
		n101OO = 0;
		n10i0i = 0;
		n10i0l = 0;
		n10i0O = 0;
		n10i1O = 0;
		n10iii = 0;
		n10iil = 0;
		n10ili = 0;
		n10ill = 0;
		n10ilO = 0;
		n10iOi = 0;
		n10liO = 0;
		n10O0i = 0;
		n10O0l = 0;
		n10O1O = 0;
		n11OiO = 0;
		n1ii0l = 0;
		n1l10i = 0;
		n1l10l = 0;
		n1l10O = 0;
		n1l11i = 0;
		n1l11l = 0;
		n1l11O = 0;
		n1l1ii = 0;
		n1O00O = 0;
		n1O0il = 0;
		n1O0iO = 0;
		n1O0li = 0;
		n1O0ll = 0;
		n1O0lO = 0;
		n1O0Oi = 0;
		n1O1Oi = 0;
		ni0O0O = 0;
		ni0Oii = 0;
		ni0Oil = 0;
		ni0OiO = 0;
		ni0Oli = 0;
		ni0Oll = 0;
		ni0OlO = 0;
		ni0OOi = 0;
		ni0OOl = 0;
		ni0OOO = 0;
		ni101i = 0;
		ni101l = 0;
		ni110i = 0;
		ni110l = 0;
		ni110O = 0;
		ni111i = 0;
		ni111l = 0;
		ni111O = 0;
		ni11ii = 0;
		ni11il = 0;
		ni11iO = 0;
		ni11li = 0;
		ni11lO = 0;
		ni11OO = 0;
		nii00i = 0;
		nii01i = 0;
		nii01l = 0;
		nii01O = 0;
		nii0ii = 0;
		nii0il = 0;
		nii0iO = 0;
		nii0li = 0;
		nii0ll = 0;
		nii0lO = 0;
		nii0Oi = 0;
		nii0Ol = 0;
		nii0OO = 0;
		nii10i = 0;
		nii10l = 0;
		nii10O = 0;
		nii11l = 0;
		nii11O = 0;
		nii1ii = 0;
		nii1il = 0;
		nii1iO = 0;
		nii1li = 0;
		nii1ll = 0;
		nii1lO = 0;
		nii1Oi = 0;
		nii1Ol = 0;
		nii1OO = 0;
		niii0i = 0;
		niii0l = 0;
		niii0O = 0;
		niii1i = 0;
		niii1l = 0;
		niii1O = 0;
		niiiii = 0;
		niiiil = 0;
		niiiiO = 0;
		niiili = 0;
		nl000i = 0;
		nl000l = 0;
		nl000O = 0;
		nl001i = 0;
		nl001l = 0;
		nl00ii = 0;
		nl011i = 0;
		nl011l = 0;
		nl011O = 0;
		nl01Ol = 0;
		nl01OO = 0;
		nl0i1l = 0;
		nl0iiO = 0;
		nl0ili = 0;
		nl0ill = 0;
		nl1l0l = 0;
		nl1OiO = 0;
		nl1Oli = 0;
		nl1Oll = 0;
		nl1OlO = 0;
		nl1OOi = 0;
		nl1OOl = 0;
		nl1OOO = 0;
		nliOlO = 0;
		nll00ll = 0;
		nll00lO = 0;
		nll10l = 0;
		nll11l = 0;
		nllO0OO = 0;
		nllOi0i = 0;
		nllOi0l = 0;
		nllOi0O = 0;
		nllOi1i = 0;
		nllOi1l = 0;
		nllOi1O = 0;
		nllOiii = 0;
		nllOiil = 0;
		nllOiiO = 0;
		nllOili = 0;
		nllOilO = 0;
		nllOiOO = 0;
		nllOl1i = 0;
		nllOl1l = 0;
		nlO000O = 0;
		nlO00ii = 0;
		nlO00il = 0;
		nlO00iO = 0;
		nlO00li = 0;
		nlO00ll = 0;
		nlO00lO = 0;
		nlO00Oi = 0;
		nlO00Ol = 0;
		nlO00OO = 0;
		nlO0i0i = 0;
		nlO0i0l = 0;
		nlO0i0O = 0;
		nlO0i1l = 0;
		nlO0i1O = 0;
		nlO0iii = 0;
		nlO0iil = 0;
		nlO0iiO = 0;
		nlO0ili = 0;
		nlO0ill = 0;
		nlO0ilO = 0;
		nlO0iOi = 0;
		nlO0iOl = 0;
		nlO0iOO = 0;
		nlO0l0i = 0;
		nlO0l0O = 0;
		nlO0l1i = 0;
		nlO0l1l = 0;
		nlO0l1O = 0;
		nlO0lii = 0;
		nlO0lil = 0;
		nlO0liO = 0;
		nlO0lli = 0;
		nlO0lll = 0;
		nlO0llO = 0;
		nlO0lOi = 0;
		nlO0lOl = 0;
		nlO0lOO = 0;
		nlO0O0i = 0;
		nlO0O0l = 0;
		nlO0O0O = 0;
		nlO0O1i = 0;
		nlO0O1l = 0;
		nlO0O1O = 0;
		nlO0Oii = 0;
		nlO0Oil = 0;
		nlO0OiO = 0;
	end
	always @ ( posedge clk_2 or  negedge wire_nll10i_CLRN)
	begin
		if (wire_nll10i_CLRN == 1'b0) 
		begin
			n00lii <= 0;
			n00lil <= 0;
			n0OlOl <= 0;
			n0OlOO <= 0;
			n0OO0i <= 0;
			n0OO0l <= 0;
			n0OO0O <= 0;
			n0OO1i <= 0;
			n0OO1l <= 0;
			n0OO1O <= 0;
			n0OOii <= 0;
			n0OOil <= 0;
			n0OOiO <= 0;
			n0OOli <= 0;
			n0OOll <= 0;
			n0OOlO <= 0;
			n0OOOi <= 0;
			n0OOOl <= 0;
			n0OOOO <= 0;
			n1000i <= 0;
			n1000l <= 0;
			n1000O <= 0;
			n1001i <= 0;
			n1001l <= 0;
			n1001O <= 0;
			n100ii <= 0;
			n101Oi <= 0;
			n101Ol <= 0;
			n101OO <= 0;
			n10i0i <= 0;
			n10i0l <= 0;
			n10i0O <= 0;
			n10i1O <= 0;
			n10iii <= 0;
			n10iil <= 0;
			n10ili <= 0;
			n10ill <= 0;
			n10ilO <= 0;
			n10iOi <= 0;
			n10liO <= 0;
			n10O0i <= 0;
			n10O0l <= 0;
			n10O1O <= 0;
			n11OiO <= 0;
			n1ii0l <= 0;
			n1l10i <= 0;
			n1l10l <= 0;
			n1l10O <= 0;
			n1l11i <= 0;
			n1l11l <= 0;
			n1l11O <= 0;
			n1l1ii <= 0;
			n1O00O <= 0;
			n1O0il <= 0;
			n1O0iO <= 0;
			n1O0li <= 0;
			n1O0ll <= 0;
			n1O0lO <= 0;
			n1O0Oi <= 0;
			n1O1Oi <= 0;
			ni0O0O <= 0;
			ni0Oii <= 0;
			ni0Oil <= 0;
			ni0OiO <= 0;
			ni0Oli <= 0;
			ni0Oll <= 0;
			ni0OlO <= 0;
			ni0OOi <= 0;
			ni0OOl <= 0;
			ni0OOO <= 0;
			ni101i <= 0;
			ni101l <= 0;
			ni110i <= 0;
			ni110l <= 0;
			ni110O <= 0;
			ni111i <= 0;
			ni111l <= 0;
			ni111O <= 0;
			ni11ii <= 0;
			ni11il <= 0;
			ni11iO <= 0;
			ni11li <= 0;
			ni11lO <= 0;
			ni11OO <= 0;
			nii00i <= 0;
			nii01i <= 0;
			nii01l <= 0;
			nii01O <= 0;
			nii0ii <= 0;
			nii0il <= 0;
			nii0iO <= 0;
			nii0li <= 0;
			nii0ll <= 0;
			nii0lO <= 0;
			nii0Oi <= 0;
			nii0Ol <= 0;
			nii0OO <= 0;
			nii10i <= 0;
			nii10l <= 0;
			nii10O <= 0;
			nii11l <= 0;
			nii11O <= 0;
			nii1ii <= 0;
			nii1il <= 0;
			nii1iO <= 0;
			nii1li <= 0;
			nii1ll <= 0;
			nii1lO <= 0;
			nii1Oi <= 0;
			nii1Ol <= 0;
			nii1OO <= 0;
			niii0i <= 0;
			niii0l <= 0;
			niii0O <= 0;
			niii1i <= 0;
			niii1l <= 0;
			niii1O <= 0;
			niiiii <= 0;
			niiiil <= 0;
			niiiiO <= 0;
			niiili <= 0;
			nl000i <= 0;
			nl000l <= 0;
			nl000O <= 0;
			nl001i <= 0;
			nl001l <= 0;
			nl00ii <= 0;
			nl011i <= 0;
			nl011l <= 0;
			nl011O <= 0;
			nl01Ol <= 0;
			nl01OO <= 0;
			nl0i1l <= 0;
			nl0iiO <= 0;
			nl0ili <= 0;
			nl0ill <= 0;
			nl1l0l <= 0;
			nl1OiO <= 0;
			nl1Oli <= 0;
			nl1Oll <= 0;
			nl1OlO <= 0;
			nl1OOi <= 0;
			nl1OOl <= 0;
			nl1OOO <= 0;
			nliOlO <= 0;
			nll00ll <= 0;
			nll00lO <= 0;
			nll10l <= 0;
			nll11l <= 0;
			nllO0OO <= 0;
			nllOi0i <= 0;
			nllOi0l <= 0;
			nllOi0O <= 0;
			nllOi1i <= 0;
			nllOi1l <= 0;
			nllOi1O <= 0;
			nllOiii <= 0;
			nllOiil <= 0;
			nllOiiO <= 0;
			nllOili <= 0;
			nllOilO <= 0;
			nllOiOO <= 0;
			nllOl1i <= 0;
			nllOl1l <= 0;
			nlO000O <= 0;
			nlO00ii <= 0;
			nlO00il <= 0;
			nlO00iO <= 0;
			nlO00li <= 0;
			nlO00ll <= 0;
			nlO00lO <= 0;
			nlO00Oi <= 0;
			nlO00Ol <= 0;
			nlO00OO <= 0;
			nlO0i0i <= 0;
			nlO0i0l <= 0;
			nlO0i0O <= 0;
			nlO0i1l <= 0;
			nlO0i1O <= 0;
			nlO0iii <= 0;
			nlO0iil <= 0;
			nlO0iiO <= 0;
			nlO0ili <= 0;
			nlO0ill <= 0;
			nlO0ilO <= 0;
			nlO0iOi <= 0;
			nlO0iOl <= 0;
			nlO0iOO <= 0;
			nlO0l0i <= 0;
			nlO0l0O <= 0;
			nlO0l1i <= 0;
			nlO0l1l <= 0;
			nlO0l1O <= 0;
			nlO0lii <= 0;
			nlO0lil <= 0;
			nlO0liO <= 0;
			nlO0lli <= 0;
			nlO0lll <= 0;
			nlO0llO <= 0;
			nlO0lOi <= 0;
			nlO0lOl <= 0;
			nlO0lOO <= 0;
			nlO0O0i <= 0;
			nlO0O0l <= 0;
			nlO0O0O <= 0;
			nlO0O1i <= 0;
			nlO0O1l <= 0;
			nlO0O1O <= 0;
			nlO0Oii <= 0;
			nlO0Oil <= 0;
			nlO0OiO <= 0;
		end
		else 
		begin
			n00lii <= wire_n00lli_dataout;
			n00lil <= wire_n00lll_dataout;
			n0OlOl <= wire_ni101O_dataout;
			n0OlOO <= wire_ni100i_dataout;
			n0OO0i <= wire_ni10il_dataout;
			n0OO0l <= wire_ni10iO_dataout;
			n0OO0O <= wire_ni10li_dataout;
			n0OO1i <= wire_ni100l_dataout;
			n0OO1l <= wire_ni100O_dataout;
			n0OO1O <= wire_ni10ii_dataout;
			n0OOii <= wire_ni10ll_dataout;
			n0OOil <= wire_ni10lO_dataout;
			n0OOiO <= wire_ni10Oi_dataout;
			n0OOli <= wire_ni10Ol_dataout;
			n0OOll <= wire_ni10OO_dataout;
			n0OOlO <= wire_ni1i1i_dataout;
			n0OOOi <= wire_ni1i1l_dataout;
			n0OOOl <= wire_ni1i1O_dataout;
			n0OOOO <= wire_ni1i0i_dataout;
			n1000i <= wire_n100OO_dataout;
			n1000l <= wire_n10i1i_dataout;
			n1000O <= wire_n10i1l_dataout;
			n1001i <= wire_n100lO_dataout;
			n1001l <= wire_n100Oi_dataout;
			n1001O <= wire_n100Ol_dataout;
			n100ii <= n10i1O;
			n101Oi <= wire_n100iO_dataout;
			n101Ol <= wire_n100li_dataout;
			n101OO <= wire_n100ll_dataout;
			n10i0i <= n10i0l;
			n10i0l <= sync_status;
			n10i0O <= n10iii;
			n10i1O <= (rgenericfifo & rdenable);
			n10iii <= align_status;
			n10iil <= wire_n10iOO_dataout;
			n10ili <= wire_n10l1i_dataout;
			n10ill <= wire_n10l1l_dataout;
			n10ilO <= wire_n10l1O_dataout;
			n10iOi <= wire_n10l0i_dataout;
			n10liO <= n10O1O;
			n10O0i <= wire_n10Oii_dataout;
			n10O0l <= wire_n10Oil_dataout;
			n10O1O <= n10O0l;
			n11OiO <= wire_n100il_dataout;
			n1ii0l <= wire_n1l1iO_dataout;
			n1l10i <= wire_n1l1Oi_dataout;
			n1l10l <= wire_n1l1Ol_dataout;
			n1l10O <= wire_n1l1OO_dataout;
			n1l11i <= wire_n1l1li_dataout;
			n1l11l <= wire_n1l1ll_dataout;
			n1l11O <= wire_n1l1lO_dataout;
			n1l1ii <= wire_n1l01i_dataout;
			n1O00O <= wire_n1Ol1O_dataout;
			n1O0il <= wire_n1Ol0l_dataout;
			n1O0iO <= wire_n1Ol0i_dataout;
			n1O0li <= wire_n1O0OO_dataout;
			n1O0ll <= wire_n1Oi1i_dataout;
			n1O0lO <= wire_n1Oi1l_dataout;
			n1O0Oi <= wire_n1Ol1l_dataout;
			n1O1Oi <= wire_n1O0ii_dataout;
			ni0O0O <= wire_niiiOi_dataout;
			ni0Oii <= wire_niiiOl_dataout;
			ni0Oil <= wire_niiiOO_dataout;
			ni0OiO <= wire_niil1i_dataout;
			ni0Oli <= wire_niil1l_dataout;
			ni0Oll <= wire_niil1O_dataout;
			ni0OlO <= wire_niil0i_dataout;
			ni0OOi <= wire_niil0l_dataout;
			ni0OOl <= wire_niil0O_dataout;
			ni0OOO <= wire_niilii_dataout;
			ni101i <= wire_ni1l1l_dataout;
			ni101l <= wire_niiilO_dataout;
			ni110i <= wire_ni1iil_dataout;
			ni110l <= wire_ni1iiO_dataout;
			ni110O <= wire_ni1ili_dataout;
			ni111i <= wire_ni1i0l_dataout;
			ni111l <= wire_ni1i0O_dataout;
			ni111O <= wire_ni1iii_dataout;
			ni11ii <= wire_ni1ill_dataout;
			ni11il <= wire_ni1ilO_dataout;
			ni11iO <= wire_ni1iOi_dataout;
			ni11li <= wire_ni1iOl_dataout;
			ni11lO <= wire_ni1iOO_dataout;
			ni11OO <= wire_ni1l1i_dataout;
			nii00i <= wire_niiOll_dataout;
			nii01i <= wire_niiOil_dataout;
			nii01l <= wire_niiOiO_dataout;
			nii01O <= wire_niiOli_dataout;
			nii0ii <= wire_niiOOi_dataout;
			nii0il <= wire_niiOOl_dataout;
			nii0iO <= wire_niiOOO_dataout;
			nii0li <= wire_nil11i_dataout;
			nii0ll <= wire_nil11l_dataout;
			nii0lO <= wire_nil11O_dataout;
			nii0Oi <= wire_nil10i_dataout;
			nii0Ol <= wire_nil10l_dataout;
			nii0OO <= wire_nil10O_dataout;
			nii10i <= wire_niilll_dataout;
			nii10l <= wire_niillO_dataout;
			nii10O <= wire_niilOi_dataout;
			nii11l <= wire_niiliO_dataout;
			nii11O <= wire_niilli_dataout;
			nii1ii <= wire_niilOl_dataout;
			nii1il <= wire_niilOO_dataout;
			nii1iO <= wire_niiO1i_dataout;
			nii1li <= wire_niiO1l_dataout;
			nii1ll <= wire_niiO1O_dataout;
			nii1lO <= wire_niiO0i_dataout;
			nii1Oi <= wire_niiO0l_dataout;
			nii1Ol <= wire_niiO0O_dataout;
			nii1OO <= wire_niiOii_dataout;
			niii0i <= wire_nil1li_dataout;
			niii0l <= wire_nil1ll_dataout;
			niii0O <= wire_nil1lO_dataout;
			niii1i <= wire_nil1ii_dataout;
			niii1l <= wire_nil1il_dataout;
			niii1O <= wire_nil1iO_dataout;
			niiiii <= wire_nil1Oi_dataout;
			niiiil <= wire_nil1Ol_dataout;
			niiiiO <= wire_nil1OO_dataout;
			niiili <= wire_nil01i_dataout;
			nl000i <= wire_nl00li_dataout;
			nl000l <= wire_nl00ll_dataout;
			nl000O <= wire_nl00lO_dataout;
			nl001i <= sync_status;
			nl001l <= wire_nl00iO_dataout;
			nl00ii <= wire_nl00Oi_dataout;
			nl011i <= wire_nl01lO_dataout;
			nl011l <= wire_nl01Oi_dataout;
			nl011O <= nl01Ol;
			nl01Ol <= (rgenericfifo & rdenable);
			nl01OO <= nl001i;
			nl0i1l <= nl0iiO;
			nl0iiO <= nl0ill;
			nl0ili <= wire_nl0iOi_dataout;
			nl0ill <= wire_nl0iOl_dataout;
			nl1l0l <= wire_nl010i_dataout;
			nl1OiO <= wire_nl010l_dataout;
			nl1Oli <= wire_nl010O_dataout;
			nl1Oll <= wire_nl01ii_dataout;
			nl1OlO <= wire_nl01il_dataout;
			nl1OOi <= wire_nl01iO_dataout;
			nl1OOl <= wire_nl01li_dataout;
			nl1OOO <= wire_nl01ll_dataout;
			nliOlO <= wire_nll11O_dataout;
			nll00ll <= wire_nll00Ol_dataout;
			nll00lO <= wire_nll00OO_dataout;
			nll10l <= wire_nll1ii_dataout;
			nll11l <= wire_nll1il_dataout;
			nllO0OO <= wire_nllOl1O_dataout;
			nllOi0i <= wire_nllOlii_dataout;
			nllOi0l <= wire_nllOlil_dataout;
			nllOi0O <= wire_nllOliO_dataout;
			nllOi1i <= wire_nllOl0i_dataout;
			nllOi1l <= wire_nllOl0l_dataout;
			nllOi1O <= wire_nllOl0O_dataout;
			nllOiii <= wire_nllOlli_dataout;
			nllOiil <= wire_nllOlll_dataout;
			nllOiiO <= wire_nllOllO_dataout;
			nllOili <= wire_nllOlOi_dataout;
			nllOilO <= wire_nllOlOl_dataout;
			nllOiOO <= wire_nllOlOO_dataout;
			nllOl1i <= wire_nllOO1i_dataout;
			nllOl1l <= wire_nlO0Oll_dataout;
			nlO000O <= wire_nlO0OlO_dataout;
			nlO00ii <= wire_nlO0OOi_dataout;
			nlO00il <= wire_nlO0OOl_dataout;
			nlO00iO <= wire_nlO0OOO_dataout;
			nlO00li <= wire_nlOi11i_dataout;
			nlO00ll <= wire_nlOi11l_dataout;
			nlO00lO <= wire_nlOi11O_dataout;
			nlO00Oi <= wire_nlOi10i_dataout;
			nlO00Ol <= wire_nlOi10l_dataout;
			nlO00OO <= wire_nlOi10O_dataout;
			nlO0i0i <= wire_nlOi1li_dataout;
			nlO0i0l <= wire_nlOi1ll_dataout;
			nlO0i0O <= wire_nlOi1lO_dataout;
			nlO0i1l <= wire_nlOi1il_dataout;
			nlO0i1O <= wire_nlOi1iO_dataout;
			nlO0iii <= wire_nlOi1Oi_dataout;
			nlO0iil <= wire_nlOi1Ol_dataout;
			nlO0iiO <= wire_nlOi1OO_dataout;
			nlO0ili <= wire_nlOi01i_dataout;
			nlO0ill <= wire_nlOi01l_dataout;
			nlO0ilO <= wire_nlOi01O_dataout;
			nlO0iOi <= wire_nlOi00i_dataout;
			nlO0iOl <= wire_nlOi00l_dataout;
			nlO0iOO <= wire_nlOi00O_dataout;
			nlO0l0i <= wire_nlOi0li_dataout;
			nlO0l0O <= wire_nlOi0lO_dataout;
			nlO0l1i <= wire_nlOi0ii_dataout;
			nlO0l1l <= wire_nlOi0il_dataout;
			nlO0l1O <= wire_nlOi0iO_dataout;
			nlO0lii <= wire_nlOi0Oi_dataout;
			nlO0lil <= wire_nlOi0Ol_dataout;
			nlO0liO <= wire_nlOi0OO_dataout;
			nlO0lli <= wire_nlOii1i_dataout;
			nlO0lll <= wire_nlOii1l_dataout;
			nlO0llO <= wire_nlOii1O_dataout;
			nlO0lOi <= wire_nlOii0i_dataout;
			nlO0lOl <= wire_nlOii0l_dataout;
			nlO0lOO <= wire_nlOii0O_dataout;
			nlO0O0i <= wire_nlOiili_dataout;
			nlO0O0l <= wire_nlOiill_dataout;
			nlO0O0O <= wire_nlOiilO_dataout;
			nlO0O1i <= wire_nlOiiii_dataout;
			nlO0O1l <= wire_nlOiiil_dataout;
			nlO0O1O <= wire_nlOiiiO_dataout;
			nlO0Oii <= wire_nlOiiOi_dataout;
			nlO0Oil <= wire_nlOiiOl_dataout;
			nlO0OiO <= wire_nlOiiOO_dataout;
		end
	end
	assign
		wire_nll10i_CLRN = ((nll10il48 ^ nll10il47) & (~ nll00iO));
	initial
	begin
		nlllOiO = 0;
		nlllOli = 0;
		nlllOll = 0;
		nlllOlO = 0;
		nlllOOi = 0;
		nlllOOl = 0;
		nlllOOO = 0;
		nllO00i = 0;
		nllO00l = 0;
		nllO00O = 0;
		nllO01i = 0;
		nllO01l = 0;
		nllO01O = 0;
		nllO0ii = 0;
		nllO0il = 0;
		nllO0iO = 0;
		nllO0li = 0;
		nllO0ll = 0;
		nllO0lO = 0;
		nllO0Oi = 0;
		nllO0Ol = 0;
		nllO10i = 0;
		nllO10l = 0;
		nllO10O = 0;
		nllO11i = 0;
		nllO11l = 0;
		nllO11O = 0;
		nllO1ii = 0;
		nllO1il = 0;
		nllO1iO = 0;
		nllO1li = 0;
		nllO1ll = 0;
		nllO1lO = 0;
		nllO1Oi = 0;
		nllO1Ol = 0;
		nllO1OO = 0;
		nllOill = 0;
		nllOiOl = 0;
	end
	always @ (clk_2 or wire_nllOiOi_PRN or nll00iO)
	begin
		if (wire_nllOiOi_PRN == 1'b0) 
		begin
			nlllOiO <= 1;
			nlllOli <= 1;
			nlllOll <= 1;
			nlllOlO <= 1;
			nlllOOi <= 1;
			nlllOOl <= 1;
			nlllOOO <= 1;
			nllO00i <= 1;
			nllO00l <= 1;
			nllO00O <= 1;
			nllO01i <= 1;
			nllO01l <= 1;
			nllO01O <= 1;
			nllO0ii <= 1;
			nllO0il <= 1;
			nllO0iO <= 1;
			nllO0li <= 1;
			nllO0ll <= 1;
			nllO0lO <= 1;
			nllO0Oi <= 1;
			nllO0Ol <= 1;
			nllO10i <= 1;
			nllO10l <= 1;
			nllO10O <= 1;
			nllO11i <= 1;
			nllO11l <= 1;
			nllO11O <= 1;
			nllO1ii <= 1;
			nllO1il <= 1;
			nllO1iO <= 1;
			nllO1li <= 1;
			nllO1ll <= 1;
			nllO1lO <= 1;
			nllO1Oi <= 1;
			nllO1Ol <= 1;
			nllO1OO <= 1;
			nllOill <= 1;
			nllOiOl <= 1;
		end
		else if  (nll00iO == 1'b1) 
		begin
			nlllOiO <= 0;
			nlllOli <= 0;
			nlllOll <= 0;
			nlllOlO <= 0;
			nlllOOi <= 0;
			nlllOOl <= 0;
			nlllOOO <= 0;
			nllO00i <= 0;
			nllO00l <= 0;
			nllO00O <= 0;
			nllO01i <= 0;
			nllO01l <= 0;
			nllO01O <= 0;
			nllO0ii <= 0;
			nllO0il <= 0;
			nllO0iO <= 0;
			nllO0li <= 0;
			nllO0ll <= 0;
			nllO0lO <= 0;
			nllO0Oi <= 0;
			nllO0Ol <= 0;
			nllO10i <= 0;
			nllO10l <= 0;
			nllO10O <= 0;
			nllO11i <= 0;
			nllO11l <= 0;
			nllO11O <= 0;
			nllO1ii <= 0;
			nllO1il <= 0;
			nllO1iO <= 0;
			nllO1li <= 0;
			nllO1ll <= 0;
			nllO1lO <= 0;
			nllO1Oi <= 0;
			nllO1Ol <= 0;
			nllO1OO <= 0;
			nllOill <= 0;
			nllOiOl <= 0;
		end
		else if  (nlilO1O == 1'b0) 
		if (clk_2 != nllOiOi_clk_prev && clk_2 == 1'b1) 
		begin
			nlllOiO <= wire_nllOOOO_dataout;
			nlllOli <= wire_nlO111i_dataout;
			nlllOll <= wire_nlO111l_dataout;
			nlllOlO <= wire_nlO111O_dataout;
			nlllOOi <= wire_nlO110i_dataout;
			nlllOOl <= wire_nlO110l_dataout;
			nlllOOO <= wire_nlO110O_dataout;
			nllO00i <= wire_nllOO1O_dataout;
			nllO00l <= wire_nllOO0i_dataout;
			nllO00O <= wire_nllOO0l_dataout;
			nllO01i <= wire_nlO100O_dataout;
			nllO01l <= wire_nlO10ii_dataout;
			nllO01O <= wire_nllOO1l_dataout;
			nllO0ii <= wire_nllOO0O_dataout;
			nllO0il <= wire_nllOOii_dataout;
			nllO0iO <= wire_nllOOil_dataout;
			nllO0li <= wire_nllOOiO_dataout;
			nllO0ll <= wire_nllOOli_dataout;
			nllO0lO <= wire_nllOOll_dataout;
			nllO0Oi <= wire_nllOOlO_dataout;
			nllO0Ol <= wire_nllOOOi_dataout;
			nllO10i <= wire_nlO11li_dataout;
			nllO10l <= wire_nlO11ll_dataout;
			nllO10O <= wire_nllOOOl_dataout;
			nllO11i <= wire_nlO11ii_dataout;
			nllO11l <= wire_nlO11il_dataout;
			nllO11O <= wire_nlO11iO_dataout;
			nllO1ii <= wire_nlO11lO_dataout;
			nllO1il <= wire_nlO11Oi_dataout;
			nllO1iO <= wire_nlO11Ol_dataout;
			nllO1li <= wire_nlO11OO_dataout;
			nllO1ll <= wire_nlO101i_dataout;
			nllO1lO <= wire_nlO101l_dataout;
			nllO1Oi <= wire_nlO101O_dataout;
			nllO1Ol <= wire_nlO100i_dataout;
			nllO1OO <= wire_nlO100l_dataout;
			nllOill <= wire_nlO1i0i_dataout;
			nllOiOl <= wire_nlO1i0O_dataout;
		end
		nllOiOi_clk_prev <= clk_2;
	end
	assign
		wire_nllOiOi_PRN = (nlill0l56 ^ nlill0l55);
	initial
	begin
		n00liO = 0;
		n10iOl = 0;
		n10O0O = 0;
		n110il = 0;
		n110iO = 0;
		n11O0l = 0;
		n11O0O = 0;
		n11Oii = 0;
		n11Oil = 0;
		n1i11i = 0;
		n1i11l = 0;
		n1i1il = 0;
		n1i1iO = 0;
		n1i1li = 0;
		n1ii0i = 0;
		n1ii1i = 0;
		n1ii1l = 0;
		n1ii1O = 0;
		n1l0lO = 0;
		n1l0Oi = 0;
		n1l0Ol = 0;
		n1l0OO = 0;
		n1l1il = 0;
		n1li1i = 0;
		n1li1l = 0;
		n1O0Ol = 0;
		n1O1lO = 0;
		n1Olil = 0;
		n1Olll = 0;
		n1OllO = 0;
		n1OlOi = 0;
		n1OlOl = 0;
		n1OlOO = 0;
		niiill = 0;
		niO00i = 0;
		niO00l = 0;
		niO00O = 0;
		niO01i = 0;
		niO01l = 0;
		niO01O = 0;
		niO0ii = 0;
		niO0il = 0;
		niO0iO = 0;
		niO0ll = 0;
		niO0lO = 0;
		niO0Oi = 0;
		niO0Ol = 0;
		niO0OO = 0;
		niO1ll = 0;
		niO1lO = 0;
		niO1Oi = 0;
		niO1Ol = 0;
		niO1OO = 0;
		niOi0i = 0;
		niOi0l = 0;
		niOi0O = 0;
		niOi1i = 0;
		niOi1l = 0;
		niOi1O = 0;
		niOiii = 0;
		niOiil = 0;
		niOiiO = 0;
		niOili = 0;
		niOill = 0;
		niOilO = 0;
		niOiOi = 0;
		niOiOl = 0;
		niOiOO = 0;
		nl00il = 0;
		nl0ilO = 0;
		nl0l0l = 0;
		nl0l0O = 0;
		nl0lOi = 0;
		nl0lOl = 0;
		nl0lOO = 0;
		nl1iii = 0;
		nl1iil = 0;
		nl1l0i = 0;
		nl1l1i = 0;
		nl1l1l = 0;
		nl1l1O = 0;
		nli10O = 0;
		nli1ii = 0;
		nli1il = 0;
		nli1iO = 0;
		nli1li = 0;
		nliiiO = 0;
		nliili = 0;
		nliill = 0;
		nliilO = 0;
		nliiOi = 0;
		nliOll = 0;
		nll00i = 0;
		nll00l = 0;
		nll00Oi = 0;
		nll10O = 0;
		nll1Ol = 0;
		nll1OO = 0;
		nlO00i = 0;
		nlO00l = 0;
		nlO00O = 0;
		nlO01i = 0;
		nlO01l = 0;
		nlO01O = 0;
		nlO0ii = 0;
		nlO0il = 0;
		nlO0iO = 0;
		nlO0li = 0;
		nlO0ll = 0;
		nlO0lO = 0;
		nlO0Oi = 0;
		nlO0Ol = 0;
		nlO0Oli = 0;
		nlO0OO = 0;
		nlO1li = 0;
		nlO1ll = 0;
		nlO1lO = 0;
		nlO1Oi = 0;
		nlO1Ol = 0;
		nlO1OO = 0;
		nlOi0i = 0;
		nlOi0l = 0;
		nlOi0O = 0;
		nlOi1i = 0;
		nlOi1l = 0;
		nlOi1O = 0;
		nlOill = 0;
		nlOilO = 0;
		nlOliiO = 0;
		nlOlili = 0;
		nlOlill = 0;
		nlOlilO = 0;
		nlOliOi = 0;
		nlOliOl = 0;
		nlOliOO = 0;
		nlOll0i = 0;
		nlOll0l = 0;
		nlOll0O = 0;
		nlOll1i = 0;
		nlOll1l = 0;
		nlOll1O = 0;
		nlOllii = 0;
		nlOlliO = 0;
		nlOllli = 0;
		nlOllll = 0;
		nlOlllO = 0;
		nlOllOi = 0;
		nlOllOl = 0;
		nlOllOO = 0;
		nlOlO0i = 0;
		nlOlO0l = 0;
		nlOlO0O = 0;
		nlOlO1i = 0;
		nlOlO1l = 0;
		nlOlO1O = 0;
		nlOlOii = 0;
		nlOlOil = 0;
		nlOlOiO = 0;
		nlOlOli = 0;
		nlOlOll = 0;
		nlOlOlO = 0;
		nlOlOO = 0;
		nlOlOOi = 0;
		nlOO1l = 0;
	end
	always @ ( posedge clk_1 or  negedge wire_nlOO1i_CLRN)
	begin
		if (wire_nlOO1i_CLRN == 1'b0) 
		begin
			n00liO <= 0;
			n10iOl <= 0;
			n10O0O <= 0;
			n110il <= 0;
			n110iO <= 0;
			n11O0l <= 0;
			n11O0O <= 0;
			n11Oii <= 0;
			n11Oil <= 0;
			n1i11i <= 0;
			n1i11l <= 0;
			n1i1il <= 0;
			n1i1iO <= 0;
			n1i1li <= 0;
			n1ii0i <= 0;
			n1ii1i <= 0;
			n1ii1l <= 0;
			n1ii1O <= 0;
			n1l0lO <= 0;
			n1l0Oi <= 0;
			n1l0Ol <= 0;
			n1l0OO <= 0;
			n1l1il <= 0;
			n1li1i <= 0;
			n1li1l <= 0;
			n1O0Ol <= 0;
			n1O1lO <= 0;
			n1Olil <= 0;
			n1Olll <= 0;
			n1OllO <= 0;
			n1OlOi <= 0;
			n1OlOl <= 0;
			n1OlOO <= 0;
			niiill <= 0;
			niO00i <= 0;
			niO00l <= 0;
			niO00O <= 0;
			niO01i <= 0;
			niO01l <= 0;
			niO01O <= 0;
			niO0ii <= 0;
			niO0il <= 0;
			niO0iO <= 0;
			niO0ll <= 0;
			niO0lO <= 0;
			niO0Oi <= 0;
			niO0Ol <= 0;
			niO0OO <= 0;
			niO1ll <= 0;
			niO1lO <= 0;
			niO1Oi <= 0;
			niO1Ol <= 0;
			niO1OO <= 0;
			niOi0i <= 0;
			niOi0l <= 0;
			niOi0O <= 0;
			niOi1i <= 0;
			niOi1l <= 0;
			niOi1O <= 0;
			niOiii <= 0;
			niOiil <= 0;
			niOiiO <= 0;
			niOili <= 0;
			niOill <= 0;
			niOilO <= 0;
			niOiOi <= 0;
			niOiOl <= 0;
			niOiOO <= 0;
			nl00il <= 0;
			nl0ilO <= 0;
			nl0l0l <= 0;
			nl0l0O <= 0;
			nl0lOi <= 0;
			nl0lOl <= 0;
			nl0lOO <= 0;
			nl1iii <= 0;
			nl1iil <= 0;
			nl1l0i <= 0;
			nl1l1i <= 0;
			nl1l1l <= 0;
			nl1l1O <= 0;
			nli10O <= 0;
			nli1ii <= 0;
			nli1il <= 0;
			nli1iO <= 0;
			nli1li <= 0;
			nliiiO <= 0;
			nliili <= 0;
			nliill <= 0;
			nliilO <= 0;
			nliiOi <= 0;
			nliOll <= 0;
			nll00i <= 0;
			nll00l <= 0;
			nll00Oi <= 0;
			nll10O <= 0;
			nll1Ol <= 0;
			nll1OO <= 0;
			nlO00i <= 0;
			nlO00l <= 0;
			nlO00O <= 0;
			nlO01i <= 0;
			nlO01l <= 0;
			nlO01O <= 0;
			nlO0ii <= 0;
			nlO0il <= 0;
			nlO0iO <= 0;
			nlO0li <= 0;
			nlO0ll <= 0;
			nlO0lO <= 0;
			nlO0Oi <= 0;
			nlO0Ol <= 0;
			nlO0Oli <= 0;
			nlO0OO <= 0;
			nlO1li <= 0;
			nlO1ll <= 0;
			nlO1lO <= 0;
			nlO1Oi <= 0;
			nlO1Ol <= 0;
			nlO1OO <= 0;
			nlOi0i <= 0;
			nlOi0l <= 0;
			nlOi0O <= 0;
			nlOi1i <= 0;
			nlOi1l <= 0;
			nlOi1O <= 0;
			nlOill <= 0;
			nlOilO <= 0;
			nlOliiO <= 0;
			nlOlili <= 0;
			nlOlill <= 0;
			nlOlilO <= 0;
			nlOliOi <= 0;
			nlOliOl <= 0;
			nlOliOO <= 0;
			nlOll0i <= 0;
			nlOll0l <= 0;
			nlOll0O <= 0;
			nlOll1i <= 0;
			nlOll1l <= 0;
			nlOll1O <= 0;
			nlOllii <= 0;
			nlOlliO <= 0;
			nlOllli <= 0;
			nlOllll <= 0;
			nlOlllO <= 0;
			nlOllOi <= 0;
			nlOllOl <= 0;
			nlOllOO <= 0;
			nlOlO0i <= 0;
			nlOlO0l <= 0;
			nlOlO0O <= 0;
			nlOlO1i <= 0;
			nlOlO1l <= 0;
			nlOlO1O <= 0;
			nlOlOii <= 0;
			nlOlOil <= 0;
			nlOlOiO <= 0;
			nlOlOli <= 0;
			nlOlOll <= 0;
			nlOlOlO <= 0;
			nlOlOO <= 0;
			nlOlOOi <= 0;
			nlOO1l <= 0;
		end
		else 
		begin
			n00liO <= wire_n00llO_dataout;
			n10iOl <= wire_n10lli_dataout;
			n10O0O <= n1i11i;
			n110il <= (rgenericfifo & wrenable);
			n110iO <= wire_n11Oli_dataout;
			n11O0l <= wire_n11Oll_dataout;
			n11O0O <= wire_n11OlO_dataout;
			n11Oii <= wire_n11OOi_dataout;
			n11Oil <= wire_n11OOl_dataout;
			n1i11i <= nliO0li;
			n1i11l <= wire_n1i1ll_dataout;
			n1i1il <= wire_n1i1OO_dataout;
			n1i1iO <= wire_n1i01i_dataout;
			n1i1li <= wire_n1ii0O_dataout;
			n1ii0i <= wire_n1iili_dataout;
			n1ii1i <= wire_n1iiii_dataout;
			n1ii1l <= wire_n1iiil_dataout;
			n1ii1O <= wire_n1iiiO_dataout;
			n1l0lO <= wire_n1li0i_dataout;
			n1l0Oi <= wire_n1li0l_dataout;
			n1l0Ol <= wire_n1li0O_dataout;
			n1l0OO <= wire_n1liii_dataout;
			n1l1il <= wire_n1li1O_dataout;
			n1li1i <= wire_n1liil_dataout;
			n1li1l <= wire_n1O1Ol_dataout;
			n1O0Ol <= wire_n1OliO_dataout;
			n1O1lO <= wire_n1O1OO_dataout;
			n1Olil <= (rclkcmpsqmd & (wire_n01i0i_dataout & (((nliOi1O | n1OlOl) | n1OlOi) | n1OllO)));
			n1Olll <= wire_n1OO1i_dataout;
			n1OllO <= wire_n1OO1O_dataout;
			n1OlOi <= wire_n1OO0l_dataout;
			n1OlOl <= wire_n1OOiO_dataout;
			n1OlOO <= wire_n0111O_dataout;
			niiill <= wire_niOl1i_dataout;
			niO00i <= wire_nl1i1i_dataout;
			niO00l <= wire_nl1i1l_dataout;
			niO00O <= wire_nl1i1O_dataout;
			niO01i <= wire_nl10Oi_dataout;
			niO01l <= wire_nl10Ol_dataout;
			niO01O <= wire_nl10OO_dataout;
			niO0ii <= wire_nl1i0i_dataout;
			niO0il <= wire_nl1i0l_dataout;
			niO0iO <= wire_nl1i0O_dataout;
			niO0ll <= wire_niOlii_dataout;
			niO0lO <= wire_niOlil_dataout;
			niO0Oi <= wire_niOliO_dataout;
			niO0Ol <= wire_niOlli_dataout;
			niO0OO <= wire_niOlll_dataout;
			niO1ll <= wire_niOl1l_dataout;
			niO1lO <= wire_niOl1O_dataout;
			niO1Oi <= wire_niOl0i_dataout;
			niO1Ol <= wire_niOl0l_dataout;
			niO1OO <= wire_nl10lO_dataout;
			niOi0i <= wire_niOlOO_dataout;
			niOi0l <= wire_niOO1i_dataout;
			niOi0O <= wire_niOO1l_dataout;
			niOi1i <= wire_niOllO_dataout;
			niOi1l <= wire_niOlOi_dataout;
			niOi1O <= wire_niOlOl_dataout;
			niOiii <= wire_niOO1O_dataout;
			niOiil <= wire_niOO0i_dataout;
			niOiiO <= wire_niOO0l_dataout;
			niOili <= wire_niOO0O_dataout;
			niOill <= wire_niOOii_dataout;
			niOilO <= wire_niOOil_dataout;
			niOiOi <= wire_niOOiO_dataout;
			niOiOl <= wire_niOOli_dataout;
			niOiOO <= nl1iii;
			nl00il <= wire_nl0i1O_dataout;
			nl0ilO <= nl0l0l;
			nl0l0l <= nll100l;
			nl0l0O <= wire_nl0O1i_dataout;
			nl0lOi <= wire_nl0O0l_dataout;
			nl0lOl <= wire_nl0O0O_dataout;
			nl0lOO <= wire_nli1ll_dataout;
			nl1iii <= (rgenericfifo & wrenable);
			nl1iil <= wire_nl1l0O_dataout;
			nl1l0i <= wire_nl1lli_dataout;
			nl1l1i <= wire_nl1lii_dataout;
			nl1l1l <= wire_nl1lil_dataout;
			nl1l1O <= wire_nl1liO_dataout;
			nli10O <= wire_nli1lO_dataout;
			nli1ii <= wire_nli1Oi_dataout;
			nli1il <= wire_nli1Ol_dataout;
			nli1iO <= wire_nli1OO_dataout;
			nli1li <= wire_nliiOl_dataout;
			nliiiO <= wire_nliiOO_dataout;
			nliili <= wire_nlil1i_dataout;
			nliill <= wire_nlil1l_dataout;
			nliilO <= wire_nlil1O_dataout;
			nliiOi <= wire_nliOOi_dataout;
			nliOll <= wire_nliOOl_dataout;
			nll00i <= wire_nll0Ol_dataout;
			nll00l <= sudi[0];
			nll00Oi <= wire_nll0i1i_dataout;
			nll10O <= wire_nll01i_dataout;
			nll1Ol <= wire_nll01l_dataout;
			nll1OO <= wire_nll00O_dataout;
			nlO00i <= sudi[10];
			nlO00l <= sudi[11];
			nlO00O <= sudi[12];
			nlO01i <= sudi[7];
			nlO01l <= sudi[8];
			nlO01O <= sudi[9];
			nlO0ii <= sudi[13];
			nlO0il <= sudi[14];
			nlO0iO <= sudi[15];
			nlO0li <= sudi[16];
			nlO0ll <= sudi[17];
			nlO0lO <= sudi[18];
			nlO0Oi <= sudi[19];
			nlO0Ol <= sudi[20];
			nlO0Oli <= wire_nlOlOOl_dataout;
			nlO0OO <= sudi[21];
			nlO1li <= sudi[1];
			nlO1ll <= sudi[2];
			nlO1lO <= sudi[3];
			nlO1Oi <= sudi[4];
			nlO1Ol <= sudi[5];
			nlO1OO <= sudi[6];
			nlOi0i <= sudi[25];
			nlOi0l <= sudi[26];
			nlOi0O <= sudi[27];
			nlOi1i <= sudi[22];
			nlOi1l <= sudi[23];
			nlOi1O <= sudi[24];
			nlOill <= wire_nlOiOl_o;
			nlOilO <= wire_nlOiOO_o;
			nlOliiO <= wire_nlOlOOO_dataout;
			nlOlili <= wire_nlOO11i_dataout;
			nlOlill <= wire_nlOO11l_dataout;
			nlOlilO <= wire_nlOO11O_dataout;
			nlOliOi <= wire_n111Oi_dataout;
			nlOliOl <= wire_n111Ol_dataout;
			nlOliOO <= wire_n111OO_dataout;
			nlOll0i <= wire_n1100i_dataout;
			nlOll0l <= wire_n1100l_dataout;
			nlOll0O <= wire_n1100O_dataout;
			nlOll1i <= wire_n1101i_dataout;
			nlOll1l <= wire_n1101l_dataout;
			nlOll1O <= wire_n1101O_dataout;
			nlOllii <= wire_n110ii_dataout;
			nlOlliO <= wire_nlOO10l_dataout;
			nlOllli <= wire_nlOO10O_dataout;
			nlOllll <= wire_nlOO1ii_dataout;
			nlOlllO <= wire_nlOO1il_dataout;
			nlOllOi <= wire_nlOO1iO_dataout;
			nlOllOl <= wire_nlOO1li_dataout;
			nlOllOO <= wire_nlOO1ll_dataout;
			nlOlO0i <= wire_nlOO1OO_dataout;
			nlOlO0l <= wire_nlOO01i_dataout;
			nlOlO0O <= wire_nlOO01l_dataout;
			nlOlO1i <= wire_nlOO1lO_dataout;
			nlOlO1l <= wire_nlOO1Oi_dataout;
			nlOlO1O <= wire_nlOO1Ol_dataout;
			nlOlOii <= wire_nlOO01O_dataout;
			nlOlOil <= wire_nlOO00i_dataout;
			nlOlOiO <= wire_nlOO00l_dataout;
			nlOlOli <= wire_nlOO00O_dataout;
			nlOlOll <= wire_nlOO0ii_dataout;
			nlOlOlO <= wire_nlOO0il_dataout;
			nlOlOO <= wire_nlOl1i_o;
			nlOlOOi <= n110il;
			nlOO1l <= wire_nlOiOi_o;
		end
	end
	assign
		wire_nlOO1i_CLRN = ((nll1O1O24 ^ nll1O1O23) & (~ wire_n1l_dataout));
	assign		wire_n0000l_dataout = (rskpsetbased === 1'b1) ? (nliOl1i | nliOiOO) : (nliOl1O | nliOl1l);
	assign		wire_n0010i_dataout = (dskwclksel[1] === 1'b1) ? audi[11] : sudi[11];
	assign		wire_n0010l_dataout = (dskwclksel[1] === 1'b1) ? audi[13] : sudi[13];
	assign		wire_n0011i_dataout = (dskwclksel[1] === 1'b1) ? audi[7] : sudi[7];
	assign		wire_n0011l_dataout = (dskwclksel[1] === 1'b1) ? audi[8] : sudi[8];
	assign		wire_n0011O_dataout = (dskwclksel[1] === 1'b1) ? audi[9] : sudi[9];
	or(wire_n001lO_dataout, (rskpsetbased & (nliOiOl | nliOiOi)), ((~ rskpsetbased) & (((~ rclkcmppos) & nliOilO) | nliOill)));
	assign		wire_n00i_dataout = (rwa_6g_en === 1'b1) ? niiiiO : nlO0Oil;
	assign		wire_n00i0i_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[10] : rclkcmpsq1p[0];
	assign		wire_n00i0l_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[11] : rclkcmpsq1p[1];
	assign		wire_n00i0O_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[12] : rclkcmpsq1p[2];
	assign		wire_n00iii_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[13] : rclkcmpsq1p[3];
	assign		wire_n00iil_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[14] : rclkcmpsq1p[4];
	assign		wire_n00iiO_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[15] : rclkcmpsq1p[5];
	assign		wire_n00ili_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[16] : rclkcmpsq1p[6];
	assign		wire_n00ill_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[17] : rclkcmpsq1p[7];
	assign		wire_n00ilO_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[18] : rclkcmpsq1p[8];
	assign		wire_n00iOi_dataout = (nliOl0O === 1'b1) ? rclkcmpsq1p[19] : rclkcmpsq1p[9];
	assign		wire_n00l_dataout = (rwa_6g_en === 1'b1) ? niiili : nlO0OiO;
	and(wire_n00lli_dataout, n00lil, ~((~ nll11Oi)));
	and(wire_n00lll_dataout, n00liO, ~((~ nll11Oi)));
	and(wire_n00llO_dataout, wire_nliiil_o, (rgenericfifo | wire_nllili_dataout));
	assign		wire_n00O_dataout = (rwa_6g_en === 1'b1) ? wire_nli10l_o : wire_n1i0OO_o;
	assign		wire_n0100i_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[9] : sudi_pre[9];
	assign		wire_n0100l_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[10] : sudi_pre[10];
	assign		wire_n0100O_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[12] : sudi_pre[12];
	assign		wire_n0101i_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[6] : sudi_pre[6];
	assign		wire_n0101l_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[7] : sudi_pre[7];
	assign		wire_n0101O_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[8] : sudi_pre[8];
	assign		wire_n010ii_dataout = (dskwclksel[1] === 1'b1) ? audi[10] : sudi[10];
	assign		wire_n010il_dataout = (dskwclksel[1] === 1'b1) ? audi[12] : sudi[12];
	and(wire_n010ll_dataout, wire_n010lO_dataout, ~(nliOiii));
	assign		wire_n010lO_dataout = (nliOi0l === 1'b1) ? align_status_sync_0 : wire_n010Oi_dataout;
	assign		wire_n010Oi_dataout = (nliOi0i === 1'b1) ? align_status_sync_2 : wire_n010Ol_dataout;
	assign		wire_n010Ol_dataout = (dskwclksel[1] === 1'b1) ? n10i0O : n10i0i;
	and(wire_n0111O_dataout, nll1OlO, (wire_n01i0i_dataout & ((~ nliOl0O) | ((~ wire_n010il_dataout) & ((~ wire_n010ii_dataout) & n1O0Ol)))));
	assign		wire_n011li_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[0] : sudi_pre[0];
	assign		wire_n011ll_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[1] : sudi_pre[1];
	assign		wire_n011lO_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[2] : sudi_pre[2];
	assign		wire_n011Oi_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[3] : sudi_pre[3];
	assign		wire_n011Ol_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[4] : sudi_pre[4];
	assign		wire_n011OO_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[5] : sudi_pre[5];
	assign		wire_n01i_dataout = (rwa_6g_en === 1'b1) ? niii0O : nlO0O0l;
	and(wire_n01i0i_dataout, wire_n01i0l_dataout, ~(nliOiii));
	assign		wire_n01i0l_dataout = (dskwclksel[1] === 1'b1) ? align_status : sync_status;
	assign		wire_n01i0O_dataout = (nliOili === 1'b1) ? n10iil : wire_n01i0l_dataout;
	assign		wire_n01iii_dataout = (nliOiil === 1'b1) ? nllO0OO : wire_n01lil_dataout;
	assign		wire_n01iil_dataout = (nliOiil === 1'b1) ? nllOi1i : wire_n01liO_dataout;
	assign		wire_n01iiO_dataout = (nliOiil === 1'b1) ? nllOi1l : wire_n01lli_dataout;
	assign		wire_n01ili_dataout = (nliOiil === 1'b1) ? nllOi1O : wire_n01lll_dataout;
	assign		wire_n01ill_dataout = (nliOiil === 1'b1) ? nllOi0i : wire_n01llO_dataout;
	assign		wire_n01ilO_dataout = (nliOiil === 1'b1) ? nllOi0l : wire_n01lOi_dataout;
	assign		wire_n01iOi_dataout = (nliOiil === 1'b1) ? nllOi0O : wire_n01lOl_dataout;
	assign		wire_n01iOl_dataout = (nliOiil === 1'b1) ? nllOiii : wire_n01lOO_dataout;
	assign		wire_n01iOO_dataout = (nliOiil === 1'b1) ? nllOiil : wire_n01O1i_dataout;
	assign		wire_n01l_dataout = (rwa_6g_en === 1'b1) ? niiiii : nlO0O0O;
	assign		wire_n01l0i_dataout = (nliOiil === 1'b1) ? nllOilO : wire_n01O0l_dataout;
	assign		wire_n01l0l_dataout = (nliOiil === 1'b1) ? nllOiOl : wire_n01O0O_dataout;
	and(wire_n01l0O_dataout, wire_n01Oii_dataout, ~(nliOiil));
	assign		wire_n01l1i_dataout = (nliOiil === 1'b1) ? nllOiiO : wire_n01O1l_dataout;
	assign		wire_n01l1l_dataout = (nliOiil === 1'b1) ? nllOili : wire_n01O1O_dataout;
	assign		wire_n01l1O_dataout = (nliOiil === 1'b1) ? nllOill : wire_n01O0i_dataout;
	or(wire_n01lii_dataout, wire_n01Oil_dataout, nliOiil);
	assign		wire_n01lil_dataout = (nliOili === 1'b1) ? nllO0OO : wire_n01OiO_dataout;
	assign		wire_n01liO_dataout = (nliOili === 1'b1) ? nllOi1i : wire_n01Oli_dataout;
	assign		wire_n01lli_dataout = (nliOili === 1'b1) ? nllOi1l : wire_n01Oll_dataout;
	assign		wire_n01lll_dataout = (nliOili === 1'b1) ? nllOi1O : wire_n01OlO_dataout;
	assign		wire_n01llO_dataout = (nliOili === 1'b1) ? nllOi0i : wire_n01OOi_dataout;
	assign		wire_n01lOi_dataout = (nliOili === 1'b1) ? nllOi0l : wire_n01OOl_dataout;
	assign		wire_n01lOl_dataout = (nliOili === 1'b1) ? nllOi0O : wire_n01OOO_dataout;
	assign		wire_n01lOO_dataout = (nliOili === 1'b1) ? nllOiii : wire_n0011i_dataout;
	assign		wire_n01O_dataout = (rwa_6g_en === 1'b1) ? niiiil : nlO0Oii;
	assign		wire_n01O0i_dataout = (nliOili === 1'b1) ? nllOill : wire_n0010i_dataout;
	assign		wire_n01O0l_dataout = (nliOili === 1'b1) ? nllOilO : wire_n010il_dataout;
	assign		wire_n01O0O_dataout = (nliOili === 1'b1) ? nllOiOl : wire_n0010l_dataout;
	assign		wire_n01O1i_dataout = (nliOili === 1'b1) ? nllOiil : wire_n0011l_dataout;
	assign		wire_n01O1l_dataout = (nliOili === 1'b1) ? nllOiiO : wire_n0011O_dataout;
	assign		wire_n01O1O_dataout = (nliOili === 1'b1) ? nllOili : wire_n010ii_dataout;
	and(wire_n01Oii_dataout, nllOiOO, nliOili);
	and(wire_n01Oil_dataout, nllOl1i, nliOili);
	assign		wire_n01OiO_dataout = (dskwclksel[1] === 1'b1) ? audi[0] : sudi[0];
	assign		wire_n01Oli_dataout = (dskwclksel[1] === 1'b1) ? audi[1] : sudi[1];
	assign		wire_n01Oll_dataout = (dskwclksel[1] === 1'b1) ? audi[2] : sudi[2];
	assign		wire_n01OlO_dataout = (dskwclksel[1] === 1'b1) ? audi[3] : sudi[3];
	assign		wire_n01OOi_dataout = (dskwclksel[1] === 1'b1) ? audi[4] : sudi[4];
	assign		wire_n01OOl_dataout = (dskwclksel[1] === 1'b1) ? audi[5] : sudi[5];
	assign		wire_n01OOO_dataout = (dskwclksel[1] === 1'b1) ? audi[6] : sudi[6];
	assign		wire_n0ii_dataout = (rwa_6g_en === 1'b1) ? wire_nliOOO_o : wire_n1O00i_o;
	assign		wire_n0il_dataout = (rwa_6g_en === 1'b1) ? wire_nll11i_o : wire_n1O00l_o;
	assign		wire_n0iO_dataout = (rwa_6g_en === 1'b1) ? ((((nll01Oi | nll01lO) | (~ (nll01li8 ^ nll01li7))) | nll01iO) | (~ (nll01ii10 ^ nll01ii9))) : ((nll001i | nll01OO) | nll01Ol);
	assign		wire_n0li_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOi_dataout : wire_n01iii_dataout;
	assign		wire_n0ll_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOl_dataout : wire_n01iil_dataout;
	assign		wire_n0lO_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOO_dataout : wire_n01iiO_dataout;
	and(wire_n0O_dataout, nil, ~(scan_mode));
	assign		wire_n0Oi_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1i_dataout : wire_n01ili_dataout;
	assign		wire_n0Ol_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1l_dataout : wire_n01ill_dataout;
	assign		wire_n0OO_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1O_dataout : wire_n01ilO_dataout;
	and(wire_n100il_dataout, n1001l, ~(nliO1Oi));
	and(wire_n100iO_dataout, n1001O, ~(nliO1Oi));
	and(wire_n100li_dataout, n1000i, ~(nliO1Oi));
	and(wire_n100ll_dataout, n1000l, ~(nliO1Oi));
	and(wire_n100lO_dataout, n1000O, ~(nliO1Oi));
	and(wire_n100Oi_dataout, n110iO, ~(nliO1Oi));
	and(wire_n100Ol_dataout, n11O0l, ~(nliO1Oi));
	and(wire_n100OO_dataout, n11O0O, ~(nliO1Oi));
	assign		wire_n1010i_dataout = (nliO10O === 1'b1) ? n11Oil : wire_n101lO_o[4];
	assign		wire_n1011i_dataout = (nliO10O === 1'b1) ? n11O0l : (wire_n101il_o[2] | wire_n101il_o[1]);
	assign		wire_n1011l_dataout = (nliO10O === 1'b1) ? n11O0O : (wire_n101lO_o[2] | wire_n101lO_o[1]);
	assign		wire_n1011O_dataout = (nliO10O === 1'b1) ? n11Oii : nlilOll;
	assign		wire_n10i_dataout = (rwa_6g_en === 1'b1) ? nii0iO : nlO0lil;
	and(wire_n10i1i_dataout, n11Oii, ~(nliO1Oi));
	and(wire_n10i1l_dataout, n11Oil, ~(nliO1Oi));
	and(wire_n10iOO_dataout, (((~ rgenericfifo) & n10ilO) | nlilOlO), ~(nliO1Oi));
	assign		wire_n10l_dataout = (rwa_6g_en === 1'b1) ? nii0li : nlO0liO;
	and(wire_n10l0i_dataout, ((~ rgenericfifo) & n10iOl), ~(nliO1Oi));
	and(wire_n10l1i_dataout, n10ill, ~(nliO1Oi));
	and(wire_n10l1l_dataout, nlOill, ~(nliO1Oi));
	and(wire_n10l1O_dataout, n10iOi, ~(nliO1Oi));
	and(wire_n10lli_dataout, wire_n10lll_dataout, wire_n01i0i_dataout);
	or(wire_n10lll_dataout, n10iOl, ((~ n10iOl) & nlilOOi));
	assign		wire_n10lOi_dataout = (nliOi0l === 1'b1) ? fifo_rd_in_comp_0 : wire_n10lOl_dataout;
	assign		wire_n10lOl_dataout = (nliOi0i === 1'b1) ? fifo_rd_in_comp_2 : n10ilO;
	assign		wire_n10lOO_dataout = (rdwidth_rx === 1'b1) ? (nlilOOl | n10liO) : nlilOOl;
	assign		wire_n10O_dataout = (rwa_6g_en === 1'b1) ? nii0ll : nlO0lli;
	and(wire_n10Oii_dataout, nll00ll, ~(nliO1Oi));
	and(wire_n10Oil_dataout, (((n10ilO & nll00ll) & (~ n10O0i)) & (rskpsetbased | nlilOOO)), ~(nliO1Oi));
	assign		wire_n10OOi_dataout = (rdwidth_rx === 1'b1) ? (nliO11i | n10O0O) : nliO11i;
	and(wire_n1100i_dataout, nlO000O, ~(nliO0il));
	and(wire_n1100l_dataout, nlO00ii, ~(nliO0il));
	and(wire_n1100O_dataout, nlO00il, ~(nliO0il));
	and(wire_n1101i_dataout, nlOll0O, ~(nliO0il));
	and(wire_n1101l_dataout, nlOllii, ~(nliO0il));
	and(wire_n1101O_dataout, nllOl1l, ~(nliO0il));
	and(wire_n110ii_dataout, nlO00iO, ~(nliO0il));
	assign		wire_n110ll_dataout = (nll010i === 1'b1) ? disable_fifo_rd_0 : nll1O0l;
	and(wire_n1111i_dataout, wire_n1110i_o[3], ~(nlillOi));
	and(wire_n1111l_dataout, wire_n1110i_o[4], ~(nlillOi));
	or(wire_n1111O_dataout, wire_n1110i_o[5], nlillOi);
	and(wire_n111ii_dataout, wire_n111lO_o[0], ~(nlillOO));
	and(wire_n111il_dataout, wire_n111lO_o[1], ~(nlillOO));
	and(wire_n111iO_dataout, wire_n111lO_o[2], ~(nlillOO));
	and(wire_n111li_dataout, wire_n111lO_o[3], ~(nlillOO));
	and(wire_n111ll_dataout, wire_n111lO_o[4], ~(nlillOO));
	and(wire_n111Oi_dataout, nlOll1O, ~(nliO0il));
	and(wire_n111Ol_dataout, nlOll0i, ~(nliO0il));
	and(wire_n111OO_dataout, nlOll0l, ~(nliO0il));
	assign		wire_n11i_dataout = (rwa_6g_en === 1'b1) ? nii00O : nlO0l0l;
	assign		wire_n11l_dataout = (rwa_6g_en === 1'b1) ? nii0ii : nlO0l0O;
	assign		wire_n11O_dataout = (rwa_6g_en === 1'b1) ? nii0il : nlO0lii;
	and(wire_n11Oli_dataout, wire_n11OOO_dataout, ~(nliO0il));
	and(wire_n11Oll_dataout, wire_n1011i_dataout, ~(nliO0il));
	and(wire_n11OlO_dataout, wire_n1011l_dataout, ~(nliO0il));
	and(wire_n11OOi_dataout, wire_n1011O_dataout, ~(nliO0il));
	and(wire_n11OOl_dataout, wire_n1010i_dataout, ~(nliO0il));
	assign		wire_n11OOO_dataout = (nliO10O === 1'b1) ? n110iO : nlilOli;
	assign		wire_n1i_dataout = (rwa_6g_en === 1'b1) ? nli1iO : n1ii0i;
	assign		wire_n1i00l_dataout = (rdwidth_rx === 1'b1) ? (nliO10l | n1i11l) : nliO10l;
	and(wire_n1i01i_dataout, wire_n1i00l_dataout, ~(nliO0il));
	assign		wire_n1i01l_dataout = (rdwidth_rx === 1'b1) ? (nliO10i | n1i10l) : nliO10i;
	assign		wire_n1i0iO_dataout = (((((~ ralempty[0]) & (~ ralempty[1])) & (~ ralempty[2])) & (~ ralempty[3])) === 1'b1) ? wire_n1O00l_o : wire_n1i0li_o;
	assign		wire_n1i0lO_dataout = (((((~ ralfull[0]) & (~ ralfull[1])) & (~ ralfull[2])) & (~ ralfull[3])) === 1'b1) ? wire_n1O00i_o : wire_n1i0Oi_o;
	and(wire_n1i1ll_dataout, n1i1il, ~(nliO0il));
	or(wire_n1i1lO_dataout, n1i10O, nliO0il);
	or(wire_n1i1Oi_dataout, wire_n1i0iO_dataout, nliO0il);
	or(wire_n1i1Ol_dataout, wire_n1i01l_dataout, nliO0il);
	and(wire_n1i1OO_dataout, wire_n1i0lO_dataout, ~(nliO0il));
	assign		wire_n1ii_dataout = (rwa_6g_en === 1'b1) ? nii0lO : nlO0lll;
	and(wire_n1ii0O_dataout, wire_n1iill_dataout, ~(nliO0il));
	and(wire_n1iiii_dataout, wire_n1iilO_dataout, ~(nliO0il));
	and(wire_n1iiil_dataout, wire_n1iiOi_dataout, ~(nliO0il));
	and(wire_n1iiiO_dataout, wire_n1iiOl_dataout, ~(nliO0il));
	and(wire_n1iili_dataout, wire_n1iiOO_dataout, ~(nliO0il));
	assign		wire_n1iill_dataout = (nliO10O === 1'b1) ? n1i1li : wire_n1il1l_dataout;
	assign		wire_n1iilO_dataout = (nliO10O === 1'b1) ? n1ii1i : wire_n1il1O_dataout;
	assign		wire_n1iiOi_dataout = (nliO10O === 1'b1) ? n1ii1l : wire_n1il0i_dataout;
	assign		wire_n1iiOl_dataout = (nliO10O === 1'b1) ? n1ii1O : wire_n1il0l_dataout;
	assign		wire_n1iiOO_dataout = (nliO10O === 1'b1) ? n1ii0i : wire_n1il0O_dataout;
	assign		wire_n1il_dataout = (rwa_6g_en === 1'b1) ? nii0Oi : nlO0llO;
	assign		wire_n1il0i_dataout = (wire_n1illi_o === 1'b1) ? wire_n1iliO_o[3] : wire_n1ilii_o[3];
	assign		wire_n1il0l_dataout = (wire_n1illi_o === 1'b1) ? wire_n1iliO_o[4] : wire_n1ilii_o[4];
	assign		wire_n1il0O_dataout = (wire_n1illi_o === 1'b1) ? wire_n1iliO_o[5] : wire_n1ilii_o[5];
	assign		wire_n1il1l_dataout = (wire_n1illi_o === 1'b1) ? wire_n1iliO_o[1] : wire_n1ilii_o[1];
	assign		wire_n1il1O_dataout = (wire_n1illi_o === 1'b1) ? wire_n1iliO_o[2] : wire_n1ilii_o[2];
	assign		wire_n1illl_dataout = (nll010i === 1'b1) ? disable_fifo_wr_0 : nll1O0i;
	assign		wire_n1iO_dataout = (rwa_6g_en === 1'b1) ? nii0Ol : nlO0lOi;
	and(wire_n1l_dataout, nO, ~(scan_mode));
	and(wire_n1l00i_dataout, n1l11l, ~(wire_n110ll_dataout));
	and(wire_n1l00l_dataout, n1l11O, ~(wire_n110ll_dataout));
	and(wire_n1l00O_dataout, n1l10i, ~(wire_n110ll_dataout));
	and(wire_n1l01i_dataout, wire_n1l0il_dataout, ~(nliO1Oi));
	and(wire_n1l01l_dataout, n1ii0l, ~(wire_n110ll_dataout));
	and(wire_n1l01O_dataout, n1l11i, ~(wire_n110ll_dataout));
	and(wire_n1l0ii_dataout, n1l10l, ~(wire_n110ll_dataout));
	and(wire_n1l0il_dataout, n1l10O, ~(wire_n110ll_dataout));
	and(wire_n1l1iO_dataout, wire_n110ll_dataout, ~(nliO1Oi));
	and(wire_n1l1li_dataout, wire_n1l01l_dataout, ~(nliO1Oi));
	and(wire_n1l1ll_dataout, wire_n1l01O_dataout, ~(nliO1Oi));
	and(wire_n1l1lO_dataout, wire_n1l00i_dataout, ~(nliO1Oi));
	and(wire_n1l1Oi_dataout, wire_n1l00l_dataout, ~(nliO1Oi));
	and(wire_n1l1Ol_dataout, wire_n1l00O_dataout, ~(nliO1Oi));
	and(wire_n1l1OO_dataout, wire_n1l0ii_dataout, ~(nliO1Oi));
	assign		wire_n1li_dataout = (rwa_6g_en === 1'b1) ? nii0OO : nlO0lOl;
	and(wire_n1li0i_dataout, wire_n1liiO_dataout, ~(nliO0il));
	and(wire_n1li0l_dataout, wire_n1lili_dataout, ~(nliO0il));
	and(wire_n1li0O_dataout, wire_n1lill_dataout, ~(nliO0il));
	and(wire_n1li1O_dataout, nll1OOO, ~(nliO0il));
	and(wire_n1liii_dataout, wire_n1lilO_dataout, ~(nliO0il));
	and(wire_n1liil_dataout, wire_n1liOi_dataout, ~(nliO0il));
	assign		wire_n1liiO_dataout = (nliO00i === 1'b1) ? wire_n1lOil_o[0] : wire_n1liOl_dataout;
	assign		wire_n1lili_dataout = (nliO00i === 1'b1) ? wire_n1lOil_o[1] : wire_n1liOO_dataout;
	assign		wire_n1lill_dataout = (nliO00i === 1'b1) ? wire_n1lOil_o[2] : wire_n1ll1i_dataout;
	assign		wire_n1lilO_dataout = (nliO00i === 1'b1) ? wire_n1lOil_o[3] : wire_n1ll1l_dataout;
	assign		wire_n1liOi_dataout = (nliO00i === 1'b1) ? wire_n1lOil_o[4] : wire_n1ll1O_dataout;
	assign		wire_n1liOl_dataout = (nliO01l === 1'b1) ? n1l0lO : wire_n1ll0i_dataout;
	assign		wire_n1liOO_dataout = (nliO01l === 1'b1) ? wire_n1lO0O_o[0] : wire_n1ll0l_dataout;
	assign		wire_n1ll_dataout = (rwa_6g_en === 1'b1) ? niii1i : nlO0lOO;
	assign		wire_n1ll0i_dataout = (nliO01i === 1'b1) ? wire_n1llOO_o[0] : wire_n1lliO_dataout;
	assign		wire_n1ll0l_dataout = (nliO01i === 1'b1) ? wire_n1llOO_o[1] : wire_n1llli_dataout;
	assign		wire_n1ll0O_dataout = (nliO01i === 1'b1) ? wire_n1llOO_o[2] : wire_n1llll_dataout;
	assign		wire_n1ll1i_dataout = (nliO01l === 1'b1) ? wire_n1lO0O_o[1] : wire_n1ll0O_dataout;
	assign		wire_n1ll1l_dataout = (nliO01l === 1'b1) ? wire_n1lO0O_o[2] : wire_n1llii_dataout;
	assign		wire_n1ll1O_dataout = (nliO01l === 1'b1) ? wire_n1lO0O_o[3] : wire_n1llil_dataout;
	assign		wire_n1llii_dataout = (nliO01i === 1'b1) ? wire_n1llOO_o[3] : wire_n1lllO_dataout;
	assign		wire_n1llil_dataout = (nliO01i === 1'b1) ? wire_n1llOO_o[4] : wire_n1llOi_dataout;
	assign		wire_n1lliO_dataout = ((~ nliO1OO) === 1'b1) ? wire_n1llOl_o[1] : n1l0lO;
	assign		wire_n1llli_dataout = ((~ nliO1OO) === 1'b1) ? wire_n1llOl_o[2] : n1l0Oi;
	assign		wire_n1llll_dataout = ((~ nliO1OO) === 1'b1) ? wire_n1llOl_o[3] : n1l0Ol;
	assign		wire_n1lllO_dataout = ((~ nliO1OO) === 1'b1) ? wire_n1llOl_o[4] : n1l0OO;
	assign		wire_n1llOi_dataout = ((~ nliO1OO) === 1'b1) ? wire_n1llOl_o[5] : n1li1i;
	assign		wire_n1lO_dataout = (rwa_6g_en === 1'b1) ? niii1l : nlO0O1i;
	and(wire_n1O0ii_dataout, wire_n001lO_dataout, wire_n010ll_dataout);
	and(wire_n1O0OO_dataout, wire_n1Oi1O_dataout, wire_n010ll_dataout);
	and(wire_n1O1Ol_dataout, nliO0iO, ~(nliO0il));
	and(wire_n1O1OO_dataout, nliO0iO, ~(nliO0il));
	assign		wire_n1Oi_dataout = (rwa_6g_en === 1'b1) ? niii1O : nlO0O1l;
	and(wire_n1Oi0i_dataout, wire_n1Oiii_dataout, ~(nliO0Ol));
	and(wire_n1Oi0l_dataout, wire_n1Oiil_dataout, ~(nliO0Ol));
	assign		wire_n1Oi0O_dataout = (nliO0lO === 1'b1) ? wire_n1OilO_o[0] : wire_n1OiiO_dataout;
	and(wire_n1Oi1i_dataout, wire_n1Oi0i_dataout, wire_n010ll_dataout);
	and(wire_n1Oi1l_dataout, wire_n1Oi0l_dataout, wire_n010ll_dataout);
	or(wire_n1Oi1O_dataout, wire_n1Oi0O_dataout, nliO0Ol);
	assign		wire_n1Oiii_dataout = (nliO0lO === 1'b1) ? wire_n1OilO_o[1] : wire_n1Oili_dataout;
	assign		wire_n1Oiil_dataout = (nliO0lO === 1'b1) ? wire_n1OilO_o[2] : wire_n1Oill_dataout;
	and(wire_n1OiiO_dataout, wire_n1OilO_o[0], nliO0ll);
	and(wire_n1Oili_dataout, wire_n1OilO_o[1], nliO0ll);
	and(wire_n1Oill_dataout, wire_n1OilO_o[2], nliO0ll);
	assign		wire_n1Ol_dataout = (rwa_6g_en === 1'b1) ? niii0i : nlO0O1O;
	and(wire_n1Ol0i_dataout, (rclkcmpsqmd & ((~ n1O0iO) & wire_n110ll_dataout)), wire_n010ll_dataout);
	and(wire_n1Ol0l_dataout, wire_n110ll_dataout, wire_n010ll_dataout);
	and(wire_n1Ol1l_dataout, wire_n0000l_dataout, wire_n010ll_dataout);
	and(wire_n1Ol1O_dataout, n1O0iO, wire_n010ll_dataout);
	and(wire_n1OliO_dataout, (((~ rclkcmppos) & nliOi1i) | nliO0OO), (nliOl0O & wire_n01i0i_dataout));
	assign		wire_n1OO_dataout = (rwa_6g_en === 1'b1) ? niii0l : nlO0O0i;
	and(wire_n1OO0l_dataout, nliOi1l, (wire_n01i0i_dataout & n1OlOl));
	and(wire_n1OO1i_dataout, nliOi1l, (wire_n01i0i_dataout & n1OllO));
	and(wire_n1OO1O_dataout, nliOi1l, (wire_n01i0i_dataout & n1OlOi));
	and(wire_n1OOiO_dataout, nll1OlO, (wire_n01i0i_dataout & (((~ rclkcmpsqmd) & nliOi1O) | n1Olil)));
	assign		wire_ni_dataout = (rwa_6g_en === 1'b1) ? nl0lOl : n1i1iO;
	assign		wire_ni000i_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[10] : wire_ni0l0i_dataout;
	assign		wire_ni000l_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[11] : ni11ll;
	assign		wire_ni000O_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[12] : wire_ni0l0l_dataout;
	assign		wire_ni001i_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[7] : wire_ni0l1i_dataout;
	assign		wire_ni001l_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[8] : wire_ni0l1l_dataout;
	assign		wire_ni001O_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[9] : wire_ni0l1O_dataout;
	assign		wire_ni00ii_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[13] : ni11Ol;
	and(wire_ni00il_dataout, wire_nlOili_data_out1[14], nliOllO);
	or(wire_ni00iO_dataout, wire_nlOili_data_out1[15], ~(nliOllO));
	assign		wire_ni00li_dataout = (nliOlll === 1'b1) ? n0OlOl : wire_ni0l0O_dataout;
	assign		wire_ni00ll_dataout = (nliOlll === 1'b1) ? n0OlOO : wire_ni0lii_dataout;
	assign		wire_ni00lO_dataout = (nliOlll === 1'b1) ? n0OO1i : wire_ni0lil_dataout;
	assign		wire_ni00Oi_dataout = (nliOlll === 1'b1) ? n0OO1l : wire_ni0liO_dataout;
	assign		wire_ni00Ol_dataout = (nliOlll === 1'b1) ? n0OO1O : wire_ni0lli_dataout;
	assign		wire_ni00OO_dataout = (nliOlll === 1'b1) ? n0OO0i : wire_ni0lll_dataout;
	assign		wire_ni010i_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[11] : wire_ni0i0O_dataout;
	assign		wire_ni010l_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[12] : wire_ni0iii_dataout;
	assign		wire_ni010O_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[13] : wire_ni0iil_dataout;
	assign		wire_ni011i_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[8] : wire_ni0i1O_dataout;
	assign		wire_ni011l_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[9] : wire_ni0i0i_dataout;
	assign		wire_ni011O_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[10] : wire_ni0i0l_dataout;
	and(wire_ni01ii_dataout, wire_nlOiiO_data_out1[14], nliOllO);
	or(wire_ni01il_dataout, wire_nlOiiO_data_out1[15], ~(nliOllO));
	assign		wire_ni01iO_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[0] : wire_ni0iiO_dataout;
	assign		wire_ni01li_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[1] : wire_ni0ili_dataout;
	assign		wire_ni01ll_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[2] : wire_ni0ill_dataout;
	assign		wire_ni01lO_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[3] : wire_ni0ilO_dataout;
	assign		wire_ni01Oi_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[4] : wire_ni0iOi_dataout;
	assign		wire_ni01Ol_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[5] : wire_ni0iOl_dataout;
	assign		wire_ni01OO_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out1[6] : wire_ni0iOO_dataout;
	assign		wire_ni0i_dataout = (rwa_6g_en === 1'b1) ? wire_nlllii_dataout : wire_n01l1i_dataout;
	assign		wire_ni0i0i_dataout = (nliOlll === 1'b1) ? n0OOil : wire_ni0lOO_dataout;
	and(wire_ni0i0l_dataout, n0OOiO, nliOlll);
	assign		wire_ni0i0O_dataout = (nliOlll === 1'b1) ? n0OOli : ni11ll;
	assign		wire_ni0i1i_dataout = (nliOlll === 1'b1) ? n0OO0l : wire_ni0llO_dataout;
	assign		wire_ni0i1l_dataout = (nliOlll === 1'b1) ? n0OO0O : wire_ni0lOi_dataout;
	assign		wire_ni0i1O_dataout = (nliOlll === 1'b1) ? n0OOii : wire_ni0lOl_dataout;
	and(wire_ni0iii_dataout, n0OOll, nliOlll);
	assign		wire_ni0iil_dataout = (nliOlll === 1'b1) ? n0OOlO : ni11Ol;
	assign		wire_ni0iiO_dataout = (nliOlll === 1'b1) ? n0OOOO : wire_ni0l0O_dataout;
	assign		wire_ni0ili_dataout = (nliOlll === 1'b1) ? ni111i : wire_ni0lii_dataout;
	assign		wire_ni0ill_dataout = (nliOlll === 1'b1) ? ni111l : wire_ni0lil_dataout;
	assign		wire_ni0ilO_dataout = (nliOlll === 1'b1) ? ni111O : wire_ni0liO_dataout;
	assign		wire_ni0iOi_dataout = (nliOlll === 1'b1) ? ni110i : wire_ni0lli_dataout;
	assign		wire_ni0iOl_dataout = (nliOlll === 1'b1) ? ni110l : wire_ni0lll_dataout;
	assign		wire_ni0iOO_dataout = (nliOlll === 1'b1) ? ni110O : wire_ni0llO_dataout;
	assign		wire_ni0l_dataout = (rwa_6g_en === 1'b1) ? wire_nlllil_dataout : wire_n01l1l_dataout;
	and(wire_ni0l0i_dataout, ni11li, nliOlll);
	and(wire_ni0l0l_dataout, ni11lO, nliOlll);
	assign		wire_ni0l0O_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[10] : rclkcmpsq1n[10];
	assign		wire_ni0l1i_dataout = (nliOlll === 1'b1) ? ni11ii : wire_ni0lOi_dataout;
	assign		wire_ni0l1l_dataout = (nliOlll === 1'b1) ? ni11il : wire_ni0lOl_dataout;
	assign		wire_ni0l1O_dataout = (nliOlll === 1'b1) ? ni11iO : wire_ni0lOO_dataout;
	assign		wire_ni0lii_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[11] : rclkcmpsq1n[11];
	assign		wire_ni0lil_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[12] : rclkcmpsq1n[12];
	assign		wire_ni0liO_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[13] : rclkcmpsq1n[13];
	assign		wire_ni0lli_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[14] : rclkcmpsq1n[14];
	assign		wire_ni0lll_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[15] : rclkcmpsq1n[15];
	assign		wire_ni0llO_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[16] : rclkcmpsq1n[16];
	assign		wire_ni0lOi_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[17] : rclkcmpsq1n[17];
	assign		wire_ni0lOl_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[18] : rclkcmpsq1n[18];
	assign		wire_ni0lOO_dataout = (ni11Ol === 1'b1) ? rclkcmpsq1p[19] : rclkcmpsq1n[19];
	assign		wire_ni0O_dataout = (rwa_6g_en === 1'b1) ? wire_nllliO_dataout : wire_n01l1O_dataout;
	assign		wire_ni0O0i_dataout = (rclkcmpinsertpad === 1'b1) ? (~ ni11Ol) : ni11Ol;
	assign		wire_ni0O0l_dataout = (rclkcmpinsertpad === 1'b1) ? ni11Ol : (~ ni11Ol);
	assign		wire_ni100i_dataout = (nl0ill === 1'b1) ? (~ ni11Ol) : wire_ni1OiO_dataout;
	assign		wire_ni100l_dataout = (nl0ill === 1'b1) ? (~ ni11Ol) : wire_ni1Oli_dataout;
	assign		wire_ni100O_dataout = (nl0ill === 1'b1) ? wire_ni0O0l_dataout : wire_ni1Oll_dataout;
	assign		wire_ni101O_dataout = (nl0ill === 1'b1) ? wire_ni0O0i_dataout : wire_ni1Oil_dataout;
	assign		wire_ni10ii_dataout = (nl0ill === 1'b1) ? (~ ni11Ol) : wire_ni1OlO_dataout;
	assign		wire_ni10il_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni1OOi_dataout;
	assign		wire_ni10iO_dataout = (nl0ill === 1'b1) ? (~ ni11Ol) : wire_ni1OOl_dataout;
	assign		wire_ni10li_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni1OOO_dataout;
	assign		wire_ni10ll_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni011i_dataout;
	assign		wire_ni10lO_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni011l_dataout;
	and(wire_ni10Oi_dataout, wire_ni011O_dataout, ~(nl0ill));
	assign		wire_ni10Ol_dataout = (nl0ill === 1'b1) ? ni11ll : wire_ni010i_dataout;
	and(wire_ni10OO_dataout, wire_ni010l_dataout, ~(nl0ill));
	assign		wire_ni1i_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0i_dataout : wire_n01iOi_dataout;
	assign		wire_ni1i0i_dataout = (nl0ill === 1'b1) ? wire_ni0O0i_dataout : wire_ni01iO_dataout;
	assign		wire_ni1i0l_dataout = (nl0ill === 1'b1) ? (~ ni11Ol) : wire_ni01li_dataout;
	assign		wire_ni1i0O_dataout = (nl0ill === 1'b1) ? (~ ni11Ol) : wire_ni01ll_dataout;
	assign		wire_ni1i1i_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni010O_dataout;
	and(wire_ni1i1l_dataout, wire_ni01ii_dataout, ~(nl0ill));
	or(wire_ni1i1O_dataout, wire_ni01il_dataout, nl0ill);
	assign		wire_ni1iii_dataout = (nl0ill === 1'b1) ? wire_ni0O0l_dataout : wire_ni01lO_dataout;
	assign		wire_ni1iil_dataout = (nl0ill === 1'b1) ? (~ ni11Ol) : wire_ni01Oi_dataout;
	assign		wire_ni1iiO_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni01Ol_dataout;
	assign		wire_ni1ili_dataout = (nl0ill === 1'b1) ? (~ ni11Ol) : wire_ni01OO_dataout;
	assign		wire_ni1ill_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni001i_dataout;
	assign		wire_ni1ilO_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni001l_dataout;
	assign		wire_ni1iOi_dataout = (nl0ill === 1'b1) ? ni11Ol : wire_ni001O_dataout;
	and(wire_ni1iOl_dataout, wire_ni000i_dataout, ~(nl0ill));
	and(wire_ni1iOO_dataout, wire_ni000O_dataout, ~(nl0ill));
	assign		wire_ni1l_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0l_dataout : wire_n01iOl_dataout;
	assign		wire_ni1l0i_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[1] : n0OiiO;
	assign		wire_ni1l0l_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[2] : n0Oili;
	assign		wire_ni1l0O_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[3] : n0Oill;
	and(wire_ni1l1i_dataout, wire_ni00il_dataout, ~(nl0ill));
	or(wire_ni1l1l_dataout, wire_ni00iO_dataout, nl0ill);
	assign		wire_ni1l1O_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[0] : n0Ol0i;
	assign		wire_ni1lii_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[4] : n0OilO;
	assign		wire_ni1lil_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[5] : n0OiOi;
	assign		wire_ni1liO_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[6] : n0OiOl;
	assign		wire_ni1lli_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[7] : n0OiOO;
	assign		wire_ni1lll_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[8] : n0Ol1i;
	assign		wire_ni1llO_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out2[9] : n0Ol1l;
	assign		wire_ni1lOi_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[0] : n0Ol1O;
	assign		wire_ni1lOl_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[1] : n0Ol0l;
	assign		wire_ni1lOO_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[2] : n0Ol0O;
	assign		wire_ni1O_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0O_dataout : wire_n01iOO_dataout;
	assign		wire_ni1O0i_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[6] : n0Olli;
	assign		wire_ni1O0l_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[7] : n0Olll;
	assign		wire_ni1O0O_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[8] : n0OllO;
	assign		wire_ni1O1i_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[3] : n0Olii;
	assign		wire_ni1O1l_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[4] : n0Olil;
	assign		wire_ni1O1O_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[5] : n0OliO;
	assign		wire_ni1Oii_dataout = (nliOllO === 1'b1) ? wire_nlOili_data_out2[9] : n0OlOi;
	assign		wire_ni1Oil_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[0] : wire_ni00li_dataout;
	assign		wire_ni1OiO_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[1] : wire_ni00ll_dataout;
	assign		wire_ni1Oli_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[2] : wire_ni00lO_dataout;
	assign		wire_ni1Oll_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[3] : wire_ni00Oi_dataout;
	assign		wire_ni1OlO_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[4] : wire_ni00Ol_dataout;
	assign		wire_ni1OOi_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[5] : wire_ni00OO_dataout;
	assign		wire_ni1OOl_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[6] : wire_ni0i1i_dataout;
	assign		wire_ni1OOO_dataout = (nliOllO === 1'b1) ? wire_nlOiiO_data_out1[7] : wire_ni0i1l_dataout;
	assign		wire_niii_dataout = (rwa_6g_en === 1'b1) ? wire_nlllli_dataout : wire_n01l0i_dataout;
	and(wire_niiilO_dataout, wire_nil01l_dataout, ~(nliOOOl));
	and(wire_niiiOi_dataout, wire_nil01O_dataout, ~(nliOOOl));
	and(wire_niiiOl_dataout, wire_nil00i_dataout, ~(nliOOOl));
	and(wire_niiiOO_dataout, wire_nil00l_dataout, ~(nliOOOl));
	assign		wire_niil_dataout = (rwa_6g_en === 1'b1) ? wire_nlllll_dataout : wire_n01l0l_dataout;
	and(wire_niil0i_dataout, wire_nil0iO_dataout, ~(nliOOOl));
	and(wire_niil0l_dataout, wire_nil0li_dataout, ~(nliOOOl));
	and(wire_niil0O_dataout, wire_nil0ll_dataout, ~(nliOOOl));
	and(wire_niil1i_dataout, wire_nil00O_dataout, ~(nliOOOl));
	and(wire_niil1l_dataout, wire_nil0ii_dataout, ~(nliOOOl));
	and(wire_niil1O_dataout, wire_nil0il_dataout, ~(nliOOOl));
	and(wire_niilii_dataout, wire_nil0lO_dataout, ~(nliOOOl));
	or(wire_niilil_dataout, wire_nil0Oi_dataout, nliOOOl);
	and(wire_niiliO_dataout, wire_nil0Ol_dataout, ~(nliOOOl));
	and(wire_niilli_dataout, wire_nil0OO_dataout, ~(nliOOOl));
	and(wire_niilll_dataout, wire_nili1i_dataout, ~(nliOOOl));
	and(wire_niillO_dataout, wire_nili1l_dataout, ~(nliOOOl));
	and(wire_niilOi_dataout, wire_nili1O_dataout, ~(nliOOOl));
	and(wire_niilOl_dataout, wire_nili0i_dataout, ~(nliOOOl));
	and(wire_niilOO_dataout, wire_nili0l_dataout, ~(nliOOOl));
	assign		wire_niiO_dataout = (rwa_6g_en === 1'b1) ? wire_nllllO_dataout : wire_n01l0O_dataout;
	and(wire_niiO0i_dataout, wire_niliiO_dataout, ~(nliOOOl));
	and(wire_niiO0l_dataout, wire_nilili_dataout, ~(nliOOOl));
	and(wire_niiO0O_dataout, wire_nilill_dataout, ~(nliOOOl));
	and(wire_niiO1i_dataout, wire_nili0O_dataout, ~(nliOOOl));
	and(wire_niiO1l_dataout, wire_niliii_dataout, ~(nliOOOl));
	and(wire_niiO1O_dataout, wire_niliil_dataout, ~(nliOOOl));
	and(wire_niiOii_dataout, wire_nililO_dataout, ~(nliOOOl));
	and(wire_niiOil_dataout, wire_niliOi_dataout, ~(nliOOOl));
	and(wire_niiOiO_dataout, wire_niliOl_dataout, ~(nliOOOl));
	and(wire_niiOli_dataout, wire_niliOO_dataout, ~(nliOOOl));
	and(wire_niiOll_dataout, wire_nill1i_dataout, ~(nliOOOl));
	or(wire_niiOlO_dataout, wire_nill1l_dataout, nliOOOl);
	and(wire_niiOOi_dataout, wire_nill1O_dataout, ~(nliOOOl));
	and(wire_niiOOl_dataout, wire_nill0i_dataout, ~(nliOOOl));
	and(wire_niiOOO_dataout, wire_nill0l_dataout, ~(nliOOOl));
	assign		wire_nil00i_dataout = (nliOO1l === 1'b1) ? nliOlOl : ni0Oii;
	assign		wire_nil00l_dataout = (nliOO1l === 1'b1) ? nliOlOO : ni0Oil;
	assign		wire_nil00O_dataout = (nliOO1l === 1'b1) ? (((wire_nilOOl_o[18] | wire_nilOOl_o[17]) | wire_nilOOl_o[16]) | wire_nilOOl_o[15]) : ni0OiO;
	and(wire_nil01i_dataout, wire_nilO0O_dataout, ~(nliOOOl));
	assign		wire_nil01l_dataout = (nliOO1l === 1'b1) ? nliOlOi : ni101l;
	assign		wire_nil01O_dataout = (nliOO1l === 1'b1) ? (((wire_nilOli_o[4] | wire_nilOli_o[3]) | wire_nilOli_o[2]) | wire_nilOli_o[1]) : ni0O0O;
	assign		wire_nil0ii_dataout = (nliOO1l === 1'b1) ? wire_nilOOO_dataout : ni0Oli;
	assign		wire_nil0il_dataout = (nliOO1l === 1'b1) ? wire_niO11i_dataout : ni0Oll;
	assign		wire_nil0iO_dataout = (nliOO1l === 1'b1) ? wire_niO11l_dataout : ni0OlO;
	assign		wire_nil0li_dataout = (nliOO1l === 1'b1) ? wire_niO11O_dataout : ni0OOi;
	assign		wire_nil0ll_dataout = (nliOO1l === 1'b1) ? wire_niO10i_dataout : ni0OOl;
	assign		wire_nil0lO_dataout = (nliOO1l === 1'b1) ? nii00i : ni0OOO;
	assign		wire_nil0Oi_dataout = (nliOO1l === 1'b1) ? ni0OOO : nii11i;
	assign		wire_nil0Ol_dataout = (nliOO1l === 1'b1) ? nii11i : nii11l;
	assign		wire_nil0OO_dataout = (nliOO1l === 1'b1) ? nii11l : nii11O;
	and(wire_nil10i_dataout, wire_nilliO_dataout, ~(nliOOOl));
	and(wire_nil10l_dataout, wire_nillli_dataout, ~(nliOOOl));
	and(wire_nil10O_dataout, wire_nillll_dataout, ~(nliOOOl));
	and(wire_nil11i_dataout, wire_nill0O_dataout, ~(nliOOOl));
	and(wire_nil11l_dataout, wire_nillii_dataout, ~(nliOOOl));
	and(wire_nil11O_dataout, wire_nillil_dataout, ~(nliOOOl));
	and(wire_nil1ii_dataout, wire_nilllO_dataout, ~(nliOOOl));
	and(wire_nil1il_dataout, wire_nillOi_dataout, ~(nliOOOl));
	and(wire_nil1iO_dataout, wire_nillOl_dataout, ~(nliOOOl));
	and(wire_nil1li_dataout, wire_nillOO_dataout, ~(nliOOOl));
	and(wire_nil1ll_dataout, wire_nilO1i_dataout, ~(nliOOOl));
	and(wire_nil1lO_dataout, wire_nilO1l_dataout, ~(nliOOOl));
	and(wire_nil1Oi_dataout, wire_nilO1O_dataout, ~(nliOOOl));
	and(wire_nil1Ol_dataout, wire_nilO0i_dataout, ~(nliOOOl));
	and(wire_nil1OO_dataout, wire_nilO0l_dataout, ~(nliOOOl));
	assign		wire_nili_dataout = (rwa_6g_en === 1'b1) ? wire_nlllOi_dataout : wire_n01lii_dataout;
	assign		wire_nili0i_dataout = (nliOO1l === 1'b1) ? nii10O : nii1ii;
	assign		wire_nili0l_dataout = (nliOO1l === 1'b1) ? nii1ii : nii1il;
	assign		wire_nili0O_dataout = (nliOO1l === 1'b1) ? nii1il : nii1iO;
	assign		wire_nili1i_dataout = (nliOO1l === 1'b1) ? nii11O : nii10i;
	assign		wire_nili1l_dataout = (nliOO1l === 1'b1) ? nii10i : nii10l;
	assign		wire_nili1O_dataout = (nliOO1l === 1'b1) ? nii10l : nii10O;
	assign		wire_niliii_dataout = (nliOO1l === 1'b1) ? nii1iO : nii1li;
	assign		wire_niliil_dataout = (nliOO1l === 1'b1) ? nii1li : nii1ll;
	assign		wire_niliiO_dataout = (nliOO1l === 1'b1) ? nii1ll : nii1lO;
	assign		wire_nilili_dataout = (nliOO1l === 1'b1) ? nii1lO : nii1Oi;
	assign		wire_nilill_dataout = (nliOO1l === 1'b1) ? nii1Oi : nii1Ol;
	assign		wire_nililO_dataout = (nliOO1l === 1'b1) ? nii1Ol : nii1OO;
	assign		wire_niliOi_dataout = (nliOO1l === 1'b1) ? nii1OO : nii01i;
	assign		wire_niliOl_dataout = (nliOO1l === 1'b1) ? nii01i : nii01l;
	assign		wire_niliOO_dataout = (nliOO1l === 1'b1) ? nii01l : nii01O;
	and(wire_nill_dataout, wire_nlllOl_dataout, rwa_6g_en);
	assign		wire_nill0i_dataout = (nliOO1l === 1'b1) ? nii0ii : nii0il;
	assign		wire_nill0l_dataout = (nliOO1l === 1'b1) ? nii0il : nii0iO;
	assign		wire_nill0O_dataout = (nliOO1l === 1'b1) ? nii0iO : nii0li;
	assign		wire_nill1i_dataout = (nliOO1l === 1'b1) ? nii01O : nii00i;
	assign		wire_nill1l_dataout = (nliOO1l === 1'b1) ? niiili : nii00O;
	assign		wire_nill1O_dataout = (nliOO1l === 1'b1) ? nii00O : nii0ii;
	assign		wire_nillii_dataout = (nliOO1l === 1'b1) ? nii0li : nii0ll;
	assign		wire_nillil_dataout = (nliOO1l === 1'b1) ? nii0ll : nii0lO;
	assign		wire_nilliO_dataout = (nliOO1l === 1'b1) ? nii0lO : nii0Oi;
	assign		wire_nilll_dataout = (rwa_6g_en === 1'b1) ? wire_nllilO_dataout : wire_n01i0O_dataout;
	assign		wire_nillli_dataout = (nliOO1l === 1'b1) ? nii0Oi : nii0Ol;
	assign		wire_nillll_dataout = (nliOO1l === 1'b1) ? nii0Ol : nii0OO;
	assign		wire_nilllO_dataout = (nliOO1l === 1'b1) ? nii0OO : niii1i;
	assign		wire_nillO_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOi_dataout : wire_n01iii_dataout;
	assign		wire_nillOi_dataout = (nliOO1l === 1'b1) ? niii1i : niii1l;
	assign		wire_nillOl_dataout = (nliOO1l === 1'b1) ? niii1l : niii1O;
	assign		wire_nillOO_dataout = (nliOO1l === 1'b1) ? niii1O : niii0i;
	and(wire_nilO_dataout, wire_nlllOO_dataout, rwa_6g_en);
	assign		wire_nilO0i_dataout = (nliOO1l === 1'b1) ? niiiii : niiiil;
	assign		wire_nilO0l_dataout = (nliOO1l === 1'b1) ? niiiil : niiiiO;
	assign		wire_nilO0O_dataout = (nliOO1l === 1'b1) ? niiiiO : niiili;
	assign		wire_nilO1i_dataout = (nliOO1l === 1'b1) ? niii0i : niii0l;
	assign		wire_nilO1l_dataout = (nliOO1l === 1'b1) ? niii0l : niii0O;
	assign		wire_nilO1O_dataout = (nliOO1l === 1'b1) ? niii0O : niiiii;
	assign		wire_nilOi_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOl_dataout : wire_n01iil_dataout;
	assign		wire_nilOl_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOO_dataout : wire_n01iiO_dataout;
	assign		wire_nilOO_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1i_dataout : wire_n01ili_dataout;
	and(wire_nilOOO_dataout, wire_niO10l_o[0], ~(nliOO1i));
	and(wire_niO_dataout, cmpfifourst, rcmpfifourst);
	assign		wire_niO0i_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0l_dataout : wire_n01iOl_dataout;
	assign		wire_niO0l_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0O_dataout : wire_n01iOO_dataout;
	assign		wire_niO0O_dataout = (rwa_6g_en === 1'b1) ? wire_nlllii_dataout : wire_n01l1i_dataout;
	and(wire_niO10i_dataout, wire_niO10l_o[4], ~(nliOO1i));
	and(wire_niO11i_dataout, wire_niO10l_o[1], ~(nliOO1i));
	and(wire_niO11l_dataout, wire_niO10l_o[2], ~(nliOO1i));
	and(wire_niO11O_dataout, wire_niO10l_o[3], ~(nliOO1i));
	assign		wire_niO1i_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1l_dataout : wire_n01ill_dataout;
	assign		wire_niO1l_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1O_dataout : wire_n01ilO_dataout;
	assign		wire_niO1O_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0i_dataout : wire_n01iOi_dataout;
	and(wire_niOi_dataout, wire_nllO1i_dataout, rwa_6g_en);
	and(wire_niOii_dataout, wire_nlllOl_dataout, rwa_6g_en);
	and(wire_niOil_dataout, wire_nlllOO_dataout, rwa_6g_en);
	and(wire_niOiO_dataout, wire_nllO1i_dataout, rwa_6g_en);
	and(wire_niOl_dataout, wire_nllO1l_dataout, rwa_6g_en);
	and(wire_niOl0i_dataout, wire_niOOOl_dataout, ~(nll100i));
	and(wire_niOl0l_dataout, wire_niOOOO_dataout, ~(nll100i));
	or(wire_niOl0O_dataout, wire_nl111i_dataout, nll100i);
	and(wire_niOl1i_dataout, wire_niOOll_dataout, ~(nll100i));
	and(wire_niOl1l_dataout, wire_niOOlO_dataout, ~(nll100i));
	and(wire_niOl1O_dataout, wire_niOOOi_dataout, ~(nll100i));
	and(wire_niOli_dataout, wire_nllO1l_dataout, rwa_6g_en);
	and(wire_niOlii_dataout, wire_nl111l_dataout, ~(nll100i));
	and(wire_niOlil_dataout, wire_nl111O_dataout, ~(nll100i));
	and(wire_niOliO_dataout, wire_nl110i_dataout, ~(nll100i));
	and(wire_niOll_dataout, wire_nllO1O_dataout, rwa_6g_en);
	and(wire_niOlli_dataout, wire_nl110l_dataout, ~(nll100i));
	and(wire_niOlll_dataout, wire_nl110O_dataout, ~(nll100i));
	and(wire_niOllO_dataout, wire_nl11ii_dataout, ~(nll100i));
	and(wire_niOlO_dataout, wire_nllO0i_dataout, rwa_6g_en);
	and(wire_niOlOi_dataout, wire_nl11il_dataout, ~(nll100i));
	and(wire_niOlOl_dataout, wire_nl11iO_dataout, ~(nll100i));
	and(wire_niOlOO_dataout, wire_nl11li_dataout, ~(nll100i));
	and(wire_niOO_dataout, wire_nllO1O_dataout, rwa_6g_en);
	and(wire_niOO0i_dataout, wire_nl11Ol_dataout, ~(nll100i));
	and(wire_niOO0l_dataout, wire_nl11OO_dataout, ~(nll100i));
	and(wire_niOO0O_dataout, wire_nl101i_dataout, ~(nll100i));
	and(wire_niOO1i_dataout, wire_nl11ll_dataout, ~(nll100i));
	and(wire_niOO1l_dataout, wire_nl11lO_dataout, ~(nll100i));
	and(wire_niOO1O_dataout, wire_nl11Oi_dataout, ~(nll100i));
	and(wire_niOOi_dataout, wire_nllO0l_dataout, rwa_6g_en);
	and(wire_niOOii_dataout, wire_nl101l_dataout, ~(nll100i));
	and(wire_niOOil_dataout, wire_nl101O_dataout, ~(nll100i));
	and(wire_niOOiO_dataout, wire_nl100i_dataout, ~(nll100i));
	and(wire_niOOl_dataout, wire_nllO0O_dataout, rwa_6g_en);
	and(wire_niOOli_dataout, wire_nl100l_dataout, ~(nll100i));
	assign		wire_niOOll_dataout = (nll101l === 1'b1) ? wire_nl100O_dataout : niiill;
	assign		wire_niOOlO_dataout = (nll101l === 1'b1) ? wire_nl10ii_dataout : niO1ll;
	and(wire_niOOO_dataout, wire_nllOii_dataout, rwa_6g_en);
	assign		wire_niOOOi_dataout = (nll101l === 1'b1) ? wire_nl10il_dataout : niO1lO;
	assign		wire_niOOOl_dataout = (nll101l === 1'b1) ? wire_nl10iO_dataout : niO1Oi;
	assign		wire_niOOOO_dataout = (nll101l === 1'b1) ? wire_nl10li_dataout : niO1Ol;
	and(wire_nl00i_dataout, nlO0iO, rwa_6g_en);
	and(wire_nl00iO_dataout, (((~ rgenericfifo) & nl000O) | nliOOll), ~(nliOOOl));
	and(wire_nl00l_dataout, nlO0li, rwa_6g_en);
	and(wire_nl00li_dataout, nl000l, ~(nliOOOl));
	and(wire_nl00ll_dataout, nlOill, ~(nliOOOl));
	and(wire_nl00lO_dataout, nl00ii, ~(nliOOOl));
	and(wire_nl00O_dataout, nlO0ll, rwa_6g_en);
	and(wire_nl00Oi_dataout, ((~ rgenericfifo) & nl00il), ~(nliOOOl));
	and(wire_nl010i_dataout, nl1OOi, ~(nliOOOl));
	and(wire_nl010l_dataout, nl1OOl, ~(nliOOOl));
	and(wire_nl010O_dataout, nl1OOO, ~(nliOOOl));
	assign		wire_nl01i_dataout = (rwa_6g_en === 1'b1) ? ((nll011i | nliiOi) | (~ (nll1O0O22 ^ nll1O0O21))) : (((nll1OOO | n1li1l) | (~ (nll1OOi16 ^ nll1OOi15))) | ((n1O0Ol & (((((~ wire_n0100O_dataout) & ((~ wire_n0100l_dataout) & (rrx_pipe_enable & nll1OlO))) & (nll1Oli18 ^ nll1Oli17)) & nlOO1l) & (nll1Oil20 ^ nll1Oil19))) & wire_n1iOOO_o));
	and(wire_nl01ii_dataout, nl011i, ~(nliOOOl));
	and(wire_nl01il_dataout, nl011l, ~(nliOOOl));
	and(wire_nl01iO_dataout, nl1iil, ~(nliOOOl));
	assign		wire_nl01l_dataout = (rwa_6g_en === 1'b1) ? nliOll : n1O1lO;
	and(wire_nl01li_dataout, nl1l1i, ~(nliOOOl));
	and(wire_nl01ll_dataout, nl1l1l, ~(nliOOOl));
	and(wire_nl01lO_dataout, nl1l1O, ~(nliOOOl));
	and(wire_nl01O_dataout, nlO0il, rwa_6g_en);
	and(wire_nl01Oi_dataout, nl1l0i, ~(nliOOOl));
	and(wire_nl0i_dataout, wire_nllOii_dataout, rwa_6g_en);
	or(wire_nl0i0i_dataout, nl00il, ((~ nl00il) & nliOOlO));
	assign		wire_nl0i0O_dataout = (rdwidth_rx === 1'b1) ? (nliOOOi | nl0i1l) : nliOOOi;
	and(wire_nl0i1O_dataout, wire_nl0i0i_dataout, wire_nllili_dataout);
	and(wire_nl0ii_dataout, nlO0lO, rwa_6g_en);
	and(wire_nl0il_dataout, nlO0Oi, rwa_6g_en);
	and(wire_nl0iO_dataout, nlO0Ol, rwa_6g_en);
	and(wire_nl0iOi_dataout, n00lii, ~(nliOOOl));
	and(wire_nl0iOl_dataout, ((nl000O & n00lii) & (~ nl0ili)), ~(nliOOOl));
	and(wire_nl0l_dataout, wire_nllOil_dataout, rwa_6g_en);
	assign		wire_nl0l1l_dataout = (rdwidth_rx === 1'b1) ? (nliOOOO | nl0ilO) : nliOOOO;
	and(wire_nl0li_dataout, nlO0OO, rwa_6g_en);
	and(wire_nl0ll_dataout, nlOi1i, rwa_6g_en);
	and(wire_nl0lO_dataout, nlOi1l, rwa_6g_en);
	and(wire_nl0O_dataout, wire_nllOiO_dataout, rwa_6g_en);
	or(wire_nl0O0i_dataout, wire_nl0Oii_dataout, nll100i);
	and(wire_nl0O0l_dataout, wire_nli11l_dataout, ~(nll100i));
	and(wire_nl0O0O_dataout, wire_nl0Oli_dataout, ~(nll100i));
	and(wire_nl0O1i_dataout, nl0lOi, ~(nll100i));
	or(wire_nl0O1l_dataout, nl0lli, nll100i);
	or(wire_nl0O1O_dataout, wire_nl0OOl_dataout, nll100i);
	and(wire_nl0Oi_dataout, nlOi1O, rwa_6g_en);
	assign		wire_nl0Oii_dataout = (rdwidth_rx === 1'b1) ? (nll110i | nl0liO) : nll110i;
	and(wire_nl0Ol_dataout, nlOi0i, rwa_6g_en);
	assign		wire_nl0Oli_dataout = (rdwidth_rx === 1'b1) ? (nll110l | nl0l0O) : nll110l;
	and(wire_nl0OO_dataout, nlOi0l, rwa_6g_en);
	assign		wire_nl0OOl_dataout = (((((~ ralempty[0]) & (~ ralempty[1])) & (~ ralempty[2])) & (~ ralempty[3])) === 1'b1) ? wire_nll11i_o : wire_nl0OOO_o;
	assign		wire_nl100i_dataout = (nll101l === 1'b1) ? niOilO : niOiOi;
	assign		wire_nl100l_dataout = (nll101l === 1'b1) ? niOiOi : niOiOl;
	and(wire_nl100O_dataout, wire_nl10ll_o[0], ~(nliOO1O));
	assign		wire_nl101i_dataout = (nll101l === 1'b1) ? niOiiO : niOili;
	assign		wire_nl101l_dataout = (nll101l === 1'b1) ? niOili : niOill;
	assign		wire_nl101O_dataout = (nll101l === 1'b1) ? niOill : niOilO;
	assign		wire_nl10i_dataout = (rwa_6g_en === 1'b1) ? nlO1ll : wire_n01Oll_dataout;
	and(wire_nl10ii_dataout, wire_nl10ll_o[1], ~(nliOO1O));
	and(wire_nl10il_dataout, wire_nl10ll_o[2], ~(nliOO1O));
	and(wire_nl10iO_dataout, wire_nl10ll_o[3], ~(nliOO1O));
	assign		wire_nl10l_dataout = (rwa_6g_en === 1'b1) ? nlO1lO : wire_n01OlO_dataout;
	and(wire_nl10li_dataout, wire_nl10ll_o[4], ~(nliOO1O));
	and(wire_nl10lO_dataout, niO00l, ~(nll100i));
	assign		wire_nl10O_dataout = (rwa_6g_en === 1'b1) ? nlO1Oi : wire_n01OOi_dataout;
	and(wire_nl10Oi_dataout, niO00O, ~(nll100i));
	and(wire_nl10Ol_dataout, niO0ii, ~(nll100i));
	and(wire_nl10OO_dataout, niO0il, ~(nll100i));
	assign		wire_nl110i_dataout = (nll101l === 1'b1) ? niO0lO : niO0Oi;
	assign		wire_nl110l_dataout = (nll101l === 1'b1) ? niO0Oi : niO0Ol;
	assign		wire_nl110O_dataout = (nll101l === 1'b1) ? niO0Ol : niO0OO;
	assign		wire_nl111i_dataout = (nll101l === 1'b1) ? niOiOl : niO0li;
	assign		wire_nl111l_dataout = (nll101l === 1'b1) ? niO0li : niO0ll;
	assign		wire_nl111O_dataout = (nll101l === 1'b1) ? niO0ll : niO0lO;
	and(wire_nl11i_dataout, wire_nllOil_dataout, rwa_6g_en);
	assign		wire_nl11ii_dataout = (nll101l === 1'b1) ? niO0OO : niOi1i;
	assign		wire_nl11il_dataout = (nll101l === 1'b1) ? niOi1i : niOi1l;
	assign		wire_nl11iO_dataout = (nll101l === 1'b1) ? niOi1l : niOi1O;
	assign		wire_nl11l_dataout = (rwa_6g_en === 1'b1) ? nll00l : wire_n01OiO_dataout;
	assign		wire_nl11li_dataout = (nll101l === 1'b1) ? niOi1O : niOi0i;
	assign		wire_nl11ll_dataout = (nll101l === 1'b1) ? niOi0i : niOi0l;
	assign		wire_nl11lO_dataout = (nll101l === 1'b1) ? niOi0l : niOi0O;
	assign		wire_nl11O_dataout = (rwa_6g_en === 1'b1) ? nlO1li : wire_n01Oli_dataout;
	assign		wire_nl11Oi_dataout = (nll101l === 1'b1) ? niOi0O : niOiii;
	assign		wire_nl11Ol_dataout = (nll101l === 1'b1) ? niOiii : niOiil;
	assign		wire_nl11OO_dataout = (nll101l === 1'b1) ? niOiil : niOiiO;
	and(wire_nl1i_dataout, wire_nllO0i_dataout, rwa_6g_en);
	and(wire_nl1i0i_dataout, ni0Oii, ~(nll100i));
	and(wire_nl1i0l_dataout, ni0Oil, ~(nll100i));
	and(wire_nl1i0O_dataout, ni0OiO, ~(nll100i));
	and(wire_nl1i1i_dataout, niO0iO, ~(nll100i));
	and(wire_nl1i1l_dataout, ni101l, ~(nll100i));
	and(wire_nl1i1O_dataout, ni0O0O, ~(nll100i));
	assign		wire_nl1ii_dataout = (rwa_6g_en === 1'b1) ? nlO1Ol : wire_n01OOl_dataout;
	assign		wire_nl1il_dataout = (rwa_6g_en === 1'b1) ? nlO1OO : wire_n01OOO_dataout;
	assign		wire_nl1iO_dataout = (rwa_6g_en === 1'b1) ? nlO01i : wire_n0011i_dataout;
	and(wire_nl1l_dataout, wire_nllO0l_dataout, rwa_6g_en);
	and(wire_nl1l0O_dataout, wire_nl1lll_dataout, ~(nll100i));
	assign		wire_nl1li_dataout = (rwa_6g_en === 1'b1) ? nlO01l : wire_n0011l_dataout;
	and(wire_nl1lii_dataout, wire_nl1llO_dataout, ~(nll100i));
	and(wire_nl1lil_dataout, wire_nl1lOi_dataout, ~(nll100i));
	and(wire_nl1liO_dataout, wire_nl1lOl_dataout, ~(nll100i));
	assign		wire_nl1ll_dataout = (rwa_6g_en === 1'b1) ? nlO01O : wire_n0011O_dataout;
	and(wire_nl1lli_dataout, wire_nl1lOO_dataout, ~(nll100i));
	assign		wire_nl1lll_dataout = (nll110O === 1'b1) ? nl1iil : nliOOiO;
	assign		wire_nl1llO_dataout = (nll110O === 1'b1) ? nl1l1i : (wire_nl1O0i_o[2] | wire_nl1O0i_o[1]);
	assign		wire_nl1lO_dataout = (rwa_6g_en === 1'b1) ? nlO00i : wire_n010ii_dataout;
	assign		wire_nl1lOi_dataout = (nll110O === 1'b1) ? nl1l1l : (wire_nl1Oil_o[2] | wire_nl1Oil_o[1]);
	assign		wire_nl1lOl_dataout = (nll110O === 1'b1) ? nl1l1O : nliOOli;
	assign		wire_nl1lOO_dataout = (nll110O === 1'b1) ? nl1l0i : wire_nl1Oil_o[4];
	and(wire_nl1O_dataout, wire_nllO0O_dataout, rwa_6g_en);
	assign		wire_nl1Oi_dataout = (rwa_6g_en === 1'b1) ? nlO00l : wire_n0010i_dataout;
	assign		wire_nl1Ol_dataout = (rwa_6g_en === 1'b1) ? nlO00O : wire_n010il_dataout;
	assign		wire_nl1OO_dataout = (rwa_6g_en === 1'b1) ? nlO0ii : wire_n0010l_dataout;
	assign		wire_nli_dataout = (rwa_6g_en === 1'b1) ? wire_nl0i0O_dataout : wire_n10lOO_dataout;
	assign		wire_nli00i_dataout = (nll110O === 1'b1) ? nli1il : wire_nli0li_dataout;
	assign		wire_nli00l_dataout = (nll110O === 1'b1) ? nli1iO : wire_nli0ll_dataout;
	assign		wire_nli01i_dataout = (nll110O === 1'b1) ? nl0lOO : wire_nli0ii_dataout;
	assign		wire_nli01l_dataout = (nll110O === 1'b1) ? nli10O : wire_nli0il_dataout;
	assign		wire_nli01O_dataout = (nll110O === 1'b1) ? nli1ii : wire_nli0iO_dataout;
	assign		wire_nli0i_dataout = (rwa_6g_en === 1'b1) ? wire_nllili_dataout : wire_n01i0i_dataout;
	assign		wire_nli0ii_dataout = (wire_nli0OO_o === 1'b1) ? wire_nli0Ol_o[1] : wire_nli0lO_o[1];
	assign		wire_nli0il_dataout = (wire_nli0OO_o === 1'b1) ? wire_nli0Ol_o[2] : wire_nli0lO_o[2];
	assign		wire_nli0iO_dataout = (wire_nli0OO_o === 1'b1) ? wire_nli0Ol_o[3] : wire_nli0lO_o[3];
	assign		wire_nli0l_dataout = (rwa_6g_en === 1'b1) ? (rmatchen & (~ rgenericfifo)) : ((~ rgenericfifo) & (((((~ dskwclksel[1]) & rmatchen) & (nll010l12 ^ nll010l11)) | (is_lane0 & nll010i)) | (~ (nll011l14 ^ nll011l13))));
	assign		wire_nli0li_dataout = (wire_nli0OO_o === 1'b1) ? wire_nli0Ol_o[4] : wire_nli0lO_o[4];
	assign		wire_nli0ll_dataout = (wire_nli0OO_o === 1'b1) ? wire_nli0Ol_o[5] : wire_nli0lO_o[5];
	assign		wire_nli0O_dataout = (rwa_6g_en === 1'b1) ? niO0li : nlOllil;
	assign		wire_nli11l_dataout = (((((~ ralfull[0]) & (~ ralfull[1])) & (~ ralfull[2])) & (~ ralfull[3])) === 1'b1) ? wire_nliOOO_o : wire_nli11O_o;
	and(wire_nli1i_dataout, nlOi0O, rwa_6g_en);
	and(wire_nli1l_dataout, (nll011i | nliiOi), rwa_6g_en);
	and(wire_nli1ll_dataout, wire_nli01i_dataout, ~(nll100i));
	and(wire_nli1lO_dataout, wire_nli01l_dataout, ~(nll100i));
	and(wire_nli1O_dataout, nliOll, rwa_6g_en);
	and(wire_nli1Oi_dataout, wire_nli01O_dataout, ~(nll100i));
	and(wire_nli1Ol_dataout, wire_nli00i_dataout, ~(nll100i));
	and(wire_nli1OO_dataout, wire_nli00l_dataout, ~(nll100i));
	and(wire_nlii_dataout, wire_nllOli_dataout, rwa_6g_en);
	assign		wire_nliii_dataout = (rwa_6g_en === 1'b1) ? niO0ll : nlOlliO;
	assign		wire_nliil_dataout = (rwa_6g_en === 1'b1) ? niO0lO : nlOllli;
	assign		wire_nliiO_dataout = (rwa_6g_en === 1'b1) ? niO0Oi : nlOllll;
	and(wire_nliiOl_dataout, wire_nlil0i_dataout, ~(nll100i));
	and(wire_nliiOO_dataout, wire_nlil0l_dataout, ~(nll100i));
	and(wire_nlil_dataout, wire_nllOll_dataout, rwa_6g_en);
	assign		wire_nlil0i_dataout = (nll11OO === 1'b1) ? wire_nlilOO_o[0] : wire_nliliO_dataout;
	assign		wire_nlil0l_dataout = (nll11OO === 1'b1) ? wire_nlilOO_o[1] : wire_nlilli_dataout;
	assign		wire_nlil0O_dataout = (nll11OO === 1'b1) ? wire_nlilOO_o[2] : wire_nlilll_dataout;
	and(wire_nlil1i_dataout, wire_nlil0O_dataout, ~(nll100i));
	and(wire_nlil1l_dataout, wire_nlilii_dataout, ~(nll100i));
	and(wire_nlil1O_dataout, wire_nlilil_dataout, ~(nll100i));
	assign		wire_nlili_dataout = (rwa_6g_en === 1'b1) ? niO0Ol : nlOlllO;
	assign		wire_nlilii_dataout = (nll11OO === 1'b1) ? wire_nlilOO_o[3] : wire_nlillO_dataout;
	assign		wire_nlilil_dataout = (nll11OO === 1'b1) ? wire_nlilOO_o[4] : wire_nlilOi_dataout;
	assign		wire_nliliO_dataout = ((~ nll11Ol) === 1'b1) ? wire_nlilOl_o[1] : nli1li;
	assign		wire_nlill_dataout = (rwa_6g_en === 1'b1) ? niO0OO : nlOllOi;
	assign		wire_nlilli_dataout = ((~ nll11Ol) === 1'b1) ? wire_nlilOl_o[2] : nliiiO;
	assign		wire_nlilll_dataout = ((~ nll11Ol) === 1'b1) ? wire_nlilOl_o[3] : nliili;
	assign		wire_nlillO_dataout = ((~ nll11Ol) === 1'b1) ? wire_nlilOl_o[4] : nliill;
	assign		wire_nlilO_dataout = (rwa_6g_en === 1'b1) ? niOi1i : nlOllOl;
	assign		wire_nlilOi_dataout = ((~ nll11Ol) === 1'b1) ? wire_nlilOl_o[5] : nliilO;
	and(wire_nliO_dataout, wire_nllOlO_dataout, rwa_6g_en);
	assign		wire_nliOi_dataout = (rwa_6g_en === 1'b1) ? niOi1l : nlOllOO;
	assign		wire_nliOl_dataout = (rwa_6g_en === 1'b1) ? niOi1O : nlOlO1i;
	assign		wire_nliOO_dataout = (rwa_6g_en === 1'b1) ? niOi0i : nlOlO1l;
	and(wire_nliOOi_dataout, nll100l, ~(nll100i));
	and(wire_nliOOl_dataout, nll100l, ~(nll100i));
	assign		wire_nll_dataout = (rwa_6g_en === 1'b1) ? nl0llO : n1i1ii;
	or(wire_nll00O_dataout, (nll1lil & ((nll1l0l & (wire_nllili_dataout & nll10O)) & (nll1ili42 ^ nll1ili41))), (rtruebac2bac & (nll1lil & (nll1l0l & (wire_nllili_dataout & nll1OO)))));
	and(wire_nll00Ol_dataout, nll00lO, ~((~ nliO1Ol)));
	and(wire_nll00OO_dataout, nll00Oi, ~((~ nliO1Ol)));
	and(wire_nll01i_dataout, (nll1l0l & ((nll1i0l | nll1i0i) | (~ (nll1i1l46 ^ nll1i1l45)))), wire_nllili_dataout);
	and(wire_nll01l_dataout, ((nll1iiO | nll1iil) | (~ (nll1i0O44 ^ nll1i0O43))), wire_nllili_dataout);
	assign		wire_nll0i_dataout = (rwa_6g_en === 1'b1) ? niOiil : nlOlO0O;
	and(wire_nll0i1i_dataout, wire_n1l0ll_o, (rgenericfifo | wire_n01i0i_dataout));
	assign		wire_nll0l_dataout = (rwa_6g_en === 1'b1) ? niOiiO : nlOlOii;
	assign		wire_nll0O_dataout = (rwa_6g_en === 1'b1) ? niOili : nlOlOil;
	or(wire_nll0Ol_dataout, wire_nll0OO_dataout, ((rtruebac2bac & ((nll1l0l & (nll1lil & (wire_nllili_dataout & nll00i))) & (nll1iOl38 ^ nll1iOl37))) & (nll1ilO40 ^ nll1ilO39)));
	and(wire_nll0OO_dataout, (nll1lil & nll1l0l), (wire_nllili_dataout & nll1Ol));
	and(wire_nll11O_dataout, (nll10ii | nll100O), wire_nlliiO_dataout);
	assign		wire_nll1i_dataout = (rwa_6g_en === 1'b1) ? niOi0l : nlOlO1O;
	and(wire_nll1ii_dataout, wire_nll1iO_dataout, wire_nlliiO_dataout);
	and(wire_nll1il_dataout, nll10iO, wire_nlliiO_dataout);
	assign		wire_nll1iO_dataout = (nliOlO === 1'b1) ? (nll10ll | nll10li) : wire_nll1li_dataout;
	assign		wire_nll1l_dataout = (rwa_6g_en === 1'b1) ? niOi0O : nlOlO0i;
	or(wire_nll1li_dataout, (rtruebac2bac & (nll10l & (~ nll1i1i))), ((nll10OO | nll10Ol) & (nll10Oi | nll10lO)));
	assign		wire_nll1O_dataout = (rwa_6g_en === 1'b1) ? niOiii : nlOlO0l;
	and(wire_nlli_dataout, wire_nllOOi_dataout, rwa_6g_en);
	assign		wire_nllii_dataout = (rwa_6g_en === 1'b1) ? niOill : nlOlOiO;
	and(wire_nlliiO_dataout, nl01OO, ~(nll1l1i));
	assign		wire_nllil_dataout = (rwa_6g_en === 1'b1) ? niOilO : nlOlOli;
	and(wire_nllili_dataout, sync_status, ~(nll1l1i));
	assign		wire_nllilO_dataout = (nll1l0i === 1'b1) ? nl001l : sync_status;
	assign		wire_nlliO_dataout = (rwa_6g_en === 1'b1) ? niOiOi : nlOlOll;
	assign		wire_nlliOi_dataout = (nll1l0i === 1'b1) ? n0OlOl : sudi[0];
	assign		wire_nlliOl_dataout = (nll1l0i === 1'b1) ? n0OlOO : sudi[1];
	assign		wire_nlliOO_dataout = (nll1l0i === 1'b1) ? n0OO1i : sudi[2];
	and(wire_nlll_dataout, wire_nllOOl_dataout, rwa_6g_en);
	assign		wire_nlll0i_dataout = (nll1l0i === 1'b1) ? n0OO0l : sudi[6];
	assign		wire_nlll0l_dataout = (nll1l0i === 1'b1) ? n0OO0O : sudi[7];
	assign		wire_nlll0O_dataout = (nll1l0i === 1'b1) ? n0OOii : sudi[8];
	assign		wire_nlll1i_dataout = (nll1l0i === 1'b1) ? n0OO1l : sudi[3];
	assign		wire_nlll1l_dataout = (nll1l0i === 1'b1) ? n0OO1O : sudi[4];
	assign		wire_nlll1O_dataout = (nll1l0i === 1'b1) ? n0OO0i : sudi[5];
	assign		wire_nllli_dataout = (rwa_6g_en === 1'b1) ? niOiOl : nlOlOlO;
	assign		wire_nlllii_dataout = (nll1l0i === 1'b1) ? n0OOil : sudi[9];
	assign		wire_nlllil_dataout = (nll1l0i === 1'b1) ? n0OOiO : sudi[10];
	assign		wire_nllliO_dataout = (nll1l0i === 1'b1) ? n0OOli : sudi[11];
	assign		wire_nllll_dataout = (rwa_6g_en === 1'b1) ? ni0OOO : nlO00OO;
	assign		wire_nlllli_dataout = (nll1l0i === 1'b1) ? n0OOll : sudi[12];
	assign		wire_nlllll_dataout = (nll1l0i === 1'b1) ? n0OOlO : sudi[13];
	and(wire_nllllO_dataout, n0OOOi, nll1l0i);
	assign		wire_nlllO_dataout = (rwa_6g_en === 1'b1) ? nii11i : nlO0i1i;
	and(wire_nlllOi_dataout, n0OOOl, nll1l0i);
	assign		wire_nlllOl_dataout = (nll1l0i === 1'b1) ? n0OOOO : sudi[14];
	assign		wire_nlllOO_dataout = (nll1l0i === 1'b1) ? ni111i : sudi[15];
	assign		wire_nllO_dataout = (rwa_6g_en === 1'b1) ? nl0lOO : n1i1li;
	assign		wire_nllO0i_dataout = (nll1l0i === 1'b1) ? ni110l : sudi[19];
	assign		wire_nllO0l_dataout = (nll1l0i === 1'b1) ? ni110O : sudi[20];
	assign		wire_nllO0O_dataout = (nll1l0i === 1'b1) ? ni11ii : sudi[21];
	assign		wire_nllO1i_dataout = (nll1l0i === 1'b1) ? ni111l : sudi[16];
	assign		wire_nllO1l_dataout = (nll1l0i === 1'b1) ? ni111O : sudi[17];
	assign		wire_nllO1O_dataout = (nll1l0i === 1'b1) ? ni110i : sudi[18];
	assign		wire_nllOi_dataout = (rwa_6g_en === 1'b1) ? nii11l : nlO0i1l;
	assign		wire_nllOii_dataout = (nll1l0i === 1'b1) ? ni11il : sudi[22];
	assign		wire_nllOil_dataout = (nll1l0i === 1'b1) ? ni11iO : sudi[23];
	assign		wire_nllOiO_dataout = (nll1l0i === 1'b1) ? ni11li : sudi[24];
	assign		wire_nllOl_dataout = (rwa_6g_en === 1'b1) ? nii11O : nlO0i1O;
	assign		wire_nllOl0i_dataout = (nlilO1O === 1'b1) ? (~ nllOiOl) : wire_nlO10iO_dataout;
	assign		wire_nllOl0l_dataout = (nlilO1O === 1'b1) ? (~ nllOiOl) : wire_nlO10li_dataout;
	assign		wire_nllOl0O_dataout = (nlilO1O === 1'b1) ? wire_nlO000l_dataout : wire_nlO10ll_dataout;
	assign		wire_nllOl1O_dataout = (nlilO1O === 1'b1) ? wire_nlO000i_dataout : wire_nlO10il_dataout;
	assign		wire_nllOli_dataout = (nll1l0i === 1'b1) ? ni11ll : sudi[25];
	assign		wire_nllOlii_dataout = (nlilO1O === 1'b1) ? (~ nllOiOl) : wire_nlO10lO_dataout;
	assign		wire_nllOlil_dataout = (nlilO1O === 1'b1) ? nllOiOl : wire_nlO10Oi_dataout;
	assign		wire_nllOliO_dataout = (nlilO1O === 1'b1) ? (~ nllOiOl) : wire_nlO10Ol_dataout;
	assign		wire_nllOll_dataout = (nll1l0i === 1'b1) ? ni11lO : sudi[26];
	assign		wire_nllOlli_dataout = (nlilO1O === 1'b1) ? nllOiOl : wire_nlO10OO_dataout;
	assign		wire_nllOlll_dataout = (nlilO1O === 1'b1) ? nllOiOl : wire_nlO1i1i_dataout;
	assign		wire_nllOllO_dataout = (nlilO1O === 1'b1) ? nllOiOl : wire_nlO1i1l_dataout;
	assign		wire_nllOlO_dataout = (nll1l0i === 1'b1) ? ni11Ol : sudi[27];
	and(wire_nllOlOi_dataout, wire_nlO1i1O_dataout, ~(nlilO1O));
	and(wire_nllOlOl_dataout, wire_nlO1i0l_dataout, ~(nlilO1O));
	and(wire_nllOlOO_dataout, wire_nlO1iii_dataout, ~(nlilO1O));
	assign		wire_nllOO_dataout = (rwa_6g_en === 1'b1) ? nii10i : nlO0i0i;
	assign		wire_nllOO0i_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[2] : nllO00l;
	assign		wire_nllOO0l_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[3] : nllO00O;
	assign		wire_nllOO0O_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[4] : nllO0ii;
	or(wire_nllOO1i_dataout, wire_nlO1iil_dataout, nlilO1O);
	assign		wire_nllOO1l_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[0] : nllO01O;
	assign		wire_nllOO1O_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[1] : nllO00i;
	and(wire_nllOOi_dataout, ni11OO, nll1l0i);
	assign		wire_nllOOii_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[5] : nllO0il;
	assign		wire_nllOOil_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[6] : nllO0iO;
	assign		wire_nllOOiO_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[7] : nllO0li;
	and(wire_nllOOl_dataout, ni101i, nll1l0i);
	assign		wire_nllOOli_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[8] : nllO0ll;
	assign		wire_nllOOll_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[9] : nllO0lO;
	assign		wire_nllOOlO_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[11] : nllO0Oi;
	assign		wire_nllOOOi_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out2[13] : nllO0Ol;
	assign		wire_nllOOOl_dataout = (nlillii === 1'b1) ? nllO10l : nllO10O;
	assign		wire_nllOOOO_dataout = (nlillii === 1'b1) ? nllO1ii : nlllOiO;
	assign		wire_nlO_dataout = (rwa_6g_en === 1'b1) ? wire_nl0l1l_dataout : wire_n10OOi_dataout;
	assign		wire_nlO000i_dataout = (rclkcmpinsertpad === 1'b1) ? (~ nllOiOl) : nllOiOl;
	assign		wire_nlO000l_dataout = (rclkcmpinsertpad === 1'b1) ? nllOiOl : (~ nllOiOl);
	or(wire_nlO001i_dataout, nllOl1i, wire_n110ll_dataout);
	assign		wire_nlO010i_dataout = (wire_n110ll_dataout === 1'b1) ? nlllOll : nllOi1O;
	assign		wire_nlO010l_dataout = (wire_n110ll_dataout === 1'b1) ? nlllOlO : nllOi0i;
	assign		wire_nlO010O_dataout = (wire_n110ll_dataout === 1'b1) ? nlllOOi : nllOi0l;
	assign		wire_nlO011i_dataout = (wire_n110ll_dataout === 1'b1) ? nllO10O : nllO0OO;
	assign		wire_nlO011l_dataout = (wire_n110ll_dataout === 1'b1) ? nlllOiO : nllOi1i;
	assign		wire_nlO011O_dataout = (wire_n110ll_dataout === 1'b1) ? nlllOli : nllOi1l;
	assign		wire_nlO01ii_dataout = (wire_n110ll_dataout === 1'b1) ? nlllOOl : nllOi0O;
	assign		wire_nlO01il_dataout = (wire_n110ll_dataout === 1'b1) ? nlllOOO : nllOiii;
	assign		wire_nlO01iO_dataout = (wire_n110ll_dataout === 1'b1) ? nllO11i : nllOiil;
	assign		wire_nlO01li_dataout = (wire_n110ll_dataout === 1'b1) ? nllO11l : nllOiiO;
	and(wire_nlO01ll_dataout, nllOili, ~(wire_n110ll_dataout));
	assign		wire_nlO01lO_dataout = (wire_n110ll_dataout === 1'b1) ? nllO11O : nllOill;
	and(wire_nlO01Oi_dataout, nllOilO, ~(wire_n110ll_dataout));
	assign		wire_nlO01Ol_dataout = (wire_n110ll_dataout === 1'b1) ? nllO10i : nllOiOl;
	and(wire_nlO01OO_dataout, nllOiOO, ~(wire_n110ll_dataout));
	assign		wire_nlO0i_dataout = (rwa_6g_en === 1'b1) ? nii1il : nlO0iil;
	assign		wire_nlO0l_dataout = (rwa_6g_en === 1'b1) ? nii1iO : nlO0iiO;
	assign		wire_nlO0O_dataout = (rwa_6g_en === 1'b1) ? nii1li : nlO0ili;
	and(wire_nlO0Oll_dataout, wire_nlOil1i_dataout, ~(nliO1Oi));
	and(wire_nlO0OlO_dataout, wire_nlOil1l_dataout, ~(nliO1Oi));
	and(wire_nlO0OOi_dataout, wire_nlOil1O_dataout, ~(nliO1Oi));
	and(wire_nlO0OOl_dataout, wire_nlOil0i_dataout, ~(nliO1Oi));
	and(wire_nlO0OOO_dataout, wire_nlOil0l_dataout, ~(nliO1Oi));
	assign		wire_nlO100i_dataout = (nlillii === 1'b1) ? nllO0ll : nllO1Ol;
	assign		wire_nlO100l_dataout = (nlillii === 1'b1) ? nllO0lO : nllO1OO;
	assign		wire_nlO100O_dataout = (nlillii === 1'b1) ? nllO0Oi : nllO01i;
	assign		wire_nlO101i_dataout = (nlillii === 1'b1) ? nllO0il : nllO1ll;
	assign		wire_nlO101l_dataout = (nlillii === 1'b1) ? nllO0iO : nllO1lO;
	assign		wire_nlO101O_dataout = (nlillii === 1'b1) ? nllO0li : nllO1Oi;
	assign		wire_nlO10ii_dataout = (nlillii === 1'b1) ? nllO0Ol : nllO01l;
	assign		wire_nlO10il_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[0] : wire_nlO1iiO_dataout;
	assign		wire_nlO10iO_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[1] : wire_nlO1ili_dataout;
	assign		wire_nlO10li_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[2] : wire_nlO1ill_dataout;
	assign		wire_nlO10ll_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[3] : wire_nlO1ilO_dataout;
	assign		wire_nlO10lO_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[4] : wire_nlO1iOi_dataout;
	assign		wire_nlO10Oi_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[5] : wire_nlO1iOl_dataout;
	assign		wire_nlO10Ol_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[6] : wire_nlO1iOO_dataout;
	assign		wire_nlO10OO_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[7] : wire_nlO1l1i_dataout;
	assign		wire_nlO110i_dataout = (nlillii === 1'b1) ? nllO1ll : nlllOOi;
	assign		wire_nlO110l_dataout = (nlillii === 1'b1) ? nllO1lO : nlllOOl;
	assign		wire_nlO110O_dataout = (nlillii === 1'b1) ? nllO1Oi : nlllOOO;
	assign		wire_nlO111i_dataout = (nlillii === 1'b1) ? nllO1il : nlllOli;
	assign		wire_nlO111l_dataout = (nlillii === 1'b1) ? nllO1iO : nlllOll;
	assign		wire_nlO111O_dataout = (nlillii === 1'b1) ? nllO1li : nlllOlO;
	assign		wire_nlO11ii_dataout = (nlillii === 1'b1) ? nllO1Ol : nllO11i;
	assign		wire_nlO11il_dataout = (nlillii === 1'b1) ? nllO1OO : nllO11l;
	assign		wire_nlO11iO_dataout = (nlillii === 1'b1) ? nllO01i : nllO11O;
	assign		wire_nlO11li_dataout = (nlillii === 1'b1) ? nllO01l : nllO10i;
	assign		wire_nlO11ll_dataout = (nlillii === 1'b1) ? nllO01O : nllO10l;
	assign		wire_nlO11lO_dataout = (nlillii === 1'b1) ? nllO00i : nllO1ii;
	assign		wire_nlO11Oi_dataout = (nlillii === 1'b1) ? nllO00l : nllO1il;
	assign		wire_nlO11Ol_dataout = (nlillii === 1'b1) ? nllO00O : nllO1iO;
	assign		wire_nlO11OO_dataout = (nlillii === 1'b1) ? nllO0ii : nllO1li;
	assign		wire_nlO1i_dataout = (rwa_6g_en === 1'b1) ? nii10l : nlO0i0l;
	assign		wire_nlO1i0i_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[11] : wire_nlO1l0l_dataout;
	assign		wire_nlO1i0l_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[12] : wire_nlO1l0O_dataout;
	assign		wire_nlO1i0O_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[13] : wire_nlO1lii_dataout;
	assign		wire_nlO1i1i_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[8] : wire_nlO1l1l_dataout;
	assign		wire_nlO1i1l_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[9] : wire_nlO1l1O_dataout;
	assign		wire_nlO1i1O_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[10] : wire_nlO1l0i_dataout;
	assign		wire_nlO1iii_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[14] : wire_nlO1lil_dataout;
	assign		wire_nlO1iil_dataout = (nlillii === 1'b1) ? wire_nlOiiO_data_out1[15] : wire_nlO1liO_dataout;
	assign		wire_nlO1iiO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1lOO_dataout : nllO0OO;
	assign		wire_nlO1ili_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1O1i_dataout : nllOi1i;
	assign		wire_nlO1ill_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1O1l_dataout : nllOi1l;
	assign		wire_nlO1ilO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1O1O_dataout : nllOi1O;
	assign		wire_nlO1iOi_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1O0i_dataout : nllOi0i;
	assign		wire_nlO1iOl_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1O0l_dataout : nllOi0l;
	assign		wire_nlO1iOO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1O0O_dataout : nllOi0O;
	assign		wire_nlO1l_dataout = (rwa_6g_en === 1'b1) ? nii10O : nlO0i0O;
	assign		wire_nlO1l0i_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1Oli_dataout : wire_nlO1lli_dataout;
	assign		wire_nlO1l0l_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1Oll_dataout : nllOill;
	assign		wire_nlO1l0O_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1OlO_dataout : wire_nlO1lll_dataout;
	assign		wire_nlO1l1i_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1Oii_dataout : nllOiii;
	assign		wire_nlO1l1l_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1Oil_dataout : nllOiil;
	assign		wire_nlO1l1O_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1OiO_dataout : nllOiiO;
	assign		wire_nlO1lii_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1OOi_dataout : nllOiOl;
	and(wire_nlO1lil_dataout, wire_nlO1OOl_dataout, rclkcmpsqmd);
	assign		wire_nlO1liO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1OOO_dataout : (~ rrx_pipe_enable);
	and(wire_nlO1lli_dataout, wire_nlO1llO_dataout, ~(rrx_pipe_enable));
	and(wire_nlO1lll_dataout, wire_nlO1lOi_dataout, ~(rrx_pipe_enable));
	and(wire_nlO1llO_dataout, nllOili, nlill0O);
	and(wire_nlO1lOi_dataout, nllOilO, nlill0O);
	assign		wire_nlO1lOO_dataout = (n1O0iO === 1'b1) ? nllO10l : wire_nlO011i_dataout;
	assign		wire_nlO1O_dataout = (rwa_6g_en === 1'b1) ? nii1ii : nlO0iii;
	assign		wire_nlO1O0i_dataout = (n1O0iO === 1'b1) ? nllO1li : wire_nlO010l_dataout;
	assign		wire_nlO1O0l_dataout = (n1O0iO === 1'b1) ? nllO1ll : wire_nlO010O_dataout;
	assign		wire_nlO1O0O_dataout = (n1O0iO === 1'b1) ? nllO1lO : wire_nlO01ii_dataout;
	assign		wire_nlO1O1i_dataout = (n1O0iO === 1'b1) ? nllO1ii : wire_nlO011l_dataout;
	assign		wire_nlO1O1l_dataout = (n1O0iO === 1'b1) ? nllO1il : wire_nlO011O_dataout;
	assign		wire_nlO1O1O_dataout = (n1O0iO === 1'b1) ? nllO1iO : wire_nlO010i_dataout;
	assign		wire_nlO1Oii_dataout = (n1O0iO === 1'b1) ? nllO1Oi : wire_nlO01il_dataout;
	assign		wire_nlO1Oil_dataout = (n1O0iO === 1'b1) ? nllO1Ol : wire_nlO01iO_dataout;
	assign		wire_nlO1OiO_dataout = (n1O0iO === 1'b1) ? nllO1OO : wire_nlO01li_dataout;
	and(wire_nlO1Oli_dataout, wire_nlO01ll_dataout, ~(n1O0iO));
	assign		wire_nlO1Oll_dataout = (n1O0iO === 1'b1) ? nllO01i : wire_nlO01lO_dataout;
	and(wire_nlO1OlO_dataout, wire_nlO01Oi_dataout, ~(n1O0iO));
	assign		wire_nlO1OOi_dataout = (n1O0iO === 1'b1) ? nllO01l : wire_nlO01Ol_dataout;
	and(wire_nlO1OOl_dataout, wire_nlO01OO_dataout, ~(n1O0iO));
	or(wire_nlO1OOO_dataout, wire_nlO001i_dataout, n1O0iO);
	assign		wire_nlOi_dataout = (rwa_6g_en === 1'b1) ? nli10O : n1ii1i;
	and(wire_nlOi00i_dataout, wire_nlOiOiO_dataout, ~(nliO1Oi));
	and(wire_nlOi00l_dataout, wire_nlOiOli_dataout, ~(nliO1Oi));
	and(wire_nlOi00O_dataout, wire_nlOiOll_dataout, ~(nliO1Oi));
	and(wire_nlOi01i_dataout, wire_nlOiO0O_dataout, ~(nliO1Oi));
	and(wire_nlOi01l_dataout, wire_nlOiOii_dataout, ~(nliO1Oi));
	and(wire_nlOi01O_dataout, wire_nlOiOil_dataout, ~(nliO1Oi));
	and(wire_nlOi0ii_dataout, wire_nlOiOlO_dataout, ~(nliO1Oi));
	and(wire_nlOi0il_dataout, wire_nlOiOOi_dataout, ~(nliO1Oi));
	and(wire_nlOi0iO_dataout, wire_nlOiOOl_dataout, ~(nliO1Oi));
	and(wire_nlOi0li_dataout, wire_nlOiOOO_dataout, ~(nliO1Oi));
	or(wire_nlOi0ll_dataout, wire_nlOl11i_dataout, nliO1Oi);
	and(wire_nlOi0lO_dataout, wire_nlOl11l_dataout, ~(nliO1Oi));
	and(wire_nlOi0Oi_dataout, wire_nlOl11O_dataout, ~(nliO1Oi));
	and(wire_nlOi0Ol_dataout, wire_nlOl10i_dataout, ~(nliO1Oi));
	and(wire_nlOi0OO_dataout, wire_nlOl10l_dataout, ~(nliO1Oi));
	and(wire_nlOi10i_dataout, wire_nlOiliO_dataout, ~(nliO1Oi));
	and(wire_nlOi10l_dataout, wire_nlOilli_dataout, ~(nliO1Oi));
	and(wire_nlOi10O_dataout, wire_nlOilll_dataout, ~(nliO1Oi));
	and(wire_nlOi11i_dataout, wire_nlOil0O_dataout, ~(nliO1Oi));
	and(wire_nlOi11l_dataout, wire_nlOilii_dataout, ~(nliO1Oi));
	and(wire_nlOi11O_dataout, wire_nlOilil_dataout, ~(nliO1Oi));
	or(wire_nlOi1ii_dataout, wire_nlOillO_dataout, nliO1Oi);
	and(wire_nlOi1il_dataout, wire_nlOilOi_dataout, ~(nliO1Oi));
	and(wire_nlOi1iO_dataout, wire_nlOilOl_dataout, ~(nliO1Oi));
	and(wire_nlOi1li_dataout, wire_nlOilOO_dataout, ~(nliO1Oi));
	and(wire_nlOi1ll_dataout, wire_nlOiO1i_dataout, ~(nliO1Oi));
	and(wire_nlOi1lO_dataout, wire_nlOiO1l_dataout, ~(nliO1Oi));
	and(wire_nlOi1Oi_dataout, wire_nlOiO1O_dataout, ~(nliO1Oi));
	and(wire_nlOi1Ol_dataout, wire_nlOiO0i_dataout, ~(nliO1Oi));
	and(wire_nlOi1OO_dataout, wire_nlOiO0l_dataout, ~(nliO1Oi));
	assign		wire_nlOii_dataout = (rwa_6g_en === 1'b1) ? nii1ll : nlO0ill;
	and(wire_nlOii0i_dataout, wire_nlOl1iO_dataout, ~(nliO1Oi));
	and(wire_nlOii0l_dataout, wire_nlOl1li_dataout, ~(nliO1Oi));
	and(wire_nlOii0O_dataout, wire_nlOl1ll_dataout, ~(nliO1Oi));
	and(wire_nlOii1i_dataout, wire_nlOl10O_dataout, ~(nliO1Oi));
	and(wire_nlOii1l_dataout, wire_nlOl1ii_dataout, ~(nliO1Oi));
	and(wire_nlOii1O_dataout, wire_nlOl1il_dataout, ~(nliO1Oi));
	and(wire_nlOiiii_dataout, wire_nlOl1lO_dataout, ~(nliO1Oi));
	and(wire_nlOiiil_dataout, wire_nlOl1Oi_dataout, ~(nliO1Oi));
	and(wire_nlOiiiO_dataout, wire_nlOl1Ol_dataout, ~(nliO1Oi));
	and(wire_nlOiili_dataout, wire_nlOl1OO_dataout, ~(nliO1Oi));
	and(wire_nlOiill_dataout, wire_nlOl01i_dataout, ~(nliO1Oi));
	and(wire_nlOiilO_dataout, wire_nlOl01l_dataout, ~(nliO1Oi));
	and(wire_nlOiiOi_dataout, wire_nlOl01O_dataout, ~(nliO1Oi));
	and(wire_nlOiiOl_dataout, wire_nlOl00i_dataout, ~(nliO1Oi));
	and(wire_nlOiiOO_dataout, wire_nlOl00l_dataout, ~(nliO1Oi));
	assign		wire_nlOil_dataout = (rwa_6g_en === 1'b1) ? nii1lO : nlO0ilO;
	assign		wire_nlOil0i_dataout = (nlilllO === 1'b1) ? nlillli : nlO00il;
	assign		wire_nlOil0l_dataout = (nlilllO === 1'b1) ? (((wire_nlOl0Oi_o[18] | wire_nlOl0Oi_o[17]) | wire_nlOl0Oi_o[16]) | wire_nlOl0Oi_o[15]) : nlO00iO;
	assign		wire_nlOil0O_dataout = (nlilllO === 1'b1) ? wire_nlOl0Ol_dataout : nlO00li;
	assign		wire_nlOil1i_dataout = (nlilllO === 1'b1) ? nlillil : nllOl1l;
	assign		wire_nlOil1l_dataout = (nlilllO === 1'b1) ? (((wire_nlOl0iO_o[4] | wire_nlOl0iO_o[3]) | wire_nlOl0iO_o[2]) | wire_nlOl0iO_o[1]) : nlO000O;
	assign		wire_nlOil1O_dataout = (nlilllO === 1'b1) ? nlilliO : nlO00ii;
	assign		wire_nlOilii_dataout = (nlilllO === 1'b1) ? wire_nlOl0OO_dataout : nlO00ll;
	assign		wire_nlOilil_dataout = (nlilllO === 1'b1) ? wire_nlOli1i_dataout : nlO00lO;
	assign		wire_nlOiliO_dataout = (nlilllO === 1'b1) ? wire_nlOli1l_dataout : nlO00Oi;
	assign		wire_nlOilli_dataout = (nlilllO === 1'b1) ? wire_nlOli1O_dataout : nlO00Ol;
	assign		wire_nlOilll_dataout = (nlilllO === 1'b1) ? nlO0l0i : nlO00OO;
	assign		wire_nlOillO_dataout = (nlilllO === 1'b1) ? nlO00OO : nlO0i1i;
	assign		wire_nlOilOi_dataout = (nlilllO === 1'b1) ? nlO0i1i : nlO0i1l;
	assign		wire_nlOilOl_dataout = (nlilllO === 1'b1) ? nlO0i1l : nlO0i1O;
	assign		wire_nlOilOO_dataout = (nlilllO === 1'b1) ? nlO0i1O : nlO0i0i;
	assign		wire_nlOiO_dataout = (rwa_6g_en === 1'b1) ? nii1Oi : nlO0iOi;
	assign		wire_nlOiO0i_dataout = (nlilllO === 1'b1) ? nlO0iii : nlO0iil;
	assign		wire_nlOiO0l_dataout = (nlilllO === 1'b1) ? nlO0iil : nlO0iiO;
	assign		wire_nlOiO0O_dataout = (nlilllO === 1'b1) ? nlO0iiO : nlO0ili;
	assign		wire_nlOiO1i_dataout = (nlilllO === 1'b1) ? nlO0i0i : nlO0i0l;
	assign		wire_nlOiO1l_dataout = (nlilllO === 1'b1) ? nlO0i0l : nlO0i0O;
	assign		wire_nlOiO1O_dataout = (nlilllO === 1'b1) ? nlO0i0O : nlO0iii;
	assign		wire_nlOiOii_dataout = (nlilllO === 1'b1) ? nlO0ili : nlO0ill;
	assign		wire_nlOiOil_dataout = (nlilllO === 1'b1) ? nlO0ill : nlO0ilO;
	assign		wire_nlOiOiO_dataout = (nlilllO === 1'b1) ? nlO0ilO : nlO0iOi;
	assign		wire_nlOiOli_dataout = (nlilllO === 1'b1) ? nlO0iOi : nlO0iOl;
	assign		wire_nlOiOll_dataout = (nlilllO === 1'b1) ? nlO0iOl : nlO0iOO;
	assign		wire_nlOiOlO_dataout = (nlilllO === 1'b1) ? nlO0iOO : nlO0l1i;
	assign		wire_nlOiOOi_dataout = (nlilllO === 1'b1) ? nlO0l1i : nlO0l1l;
	assign		wire_nlOiOOl_dataout = (nlilllO === 1'b1) ? nlO0l1l : nlO0l1O;
	assign		wire_nlOiOOO_dataout = (nlilllO === 1'b1) ? nlO0l1O : nlO0l0i;
	assign		wire_nlOl_dataout = (rwa_6g_en === 1'b1) ? nli1ii : n1ii1l;
	assign		wire_nlOl00i_dataout = (nlilllO === 1'b1) ? nlO0Oii : nlO0Oil;
	assign		wire_nlOl00l_dataout = (nlilllO === 1'b1) ? nlO0Oil : nlO0OiO;
	assign		wire_nlOl01i_dataout = (nlilllO === 1'b1) ? nlO0O0i : nlO0O0l;
	assign		wire_nlOl01l_dataout = (nlilllO === 1'b1) ? nlO0O0l : nlO0O0O;
	assign		wire_nlOl01O_dataout = (nlilllO === 1'b1) ? nlO0O0O : nlO0Oii;
	and(wire_nlOl0i_dataout, wire_nlOl0O_dataout, ~((~ wire_nli0i_dataout)));
	and(wire_nlOl0l_dataout, nlOill, ~(wire_n0iO_dataout));
	and(wire_nlOl0O_dataout, nlOO1l, ~(wire_n0iO_dataout));
	and(wire_nlOl0Ol_dataout, wire_nlOli0i_o[0], ~(nlillll));
	and(wire_nlOl0OO_dataout, wire_nlOli0i_o[1], ~(nlillll));
	assign		wire_nlOl10i_dataout = (nlilllO === 1'b1) ? nlO0lii : nlO0lil;
	assign		wire_nlOl10l_dataout = (nlilllO === 1'b1) ? nlO0lil : nlO0liO;
	assign		wire_nlOl10O_dataout = (nlilllO === 1'b1) ? nlO0liO : nlO0lli;
	assign		wire_nlOl11i_dataout = (nlilllO === 1'b1) ? nlO0OiO : nlO0l0l;
	assign		wire_nlOl11l_dataout = (nlilllO === 1'b1) ? nlO0l0l : nlO0l0O;
	assign		wire_nlOl11O_dataout = (nlilllO === 1'b1) ? nlO0l0O : nlO0lii;
	assign		wire_nlOl1ii_dataout = (nlilllO === 1'b1) ? nlO0lli : nlO0lll;
	assign		wire_nlOl1il_dataout = (nlilllO === 1'b1) ? nlO0lll : nlO0llO;
	assign		wire_nlOl1iO_dataout = (nlilllO === 1'b1) ? nlO0llO : nlO0lOi;
	and(wire_nlOl1l_dataout, wire_n0iO_dataout, ~((~ wire_nli0i_dataout)));
	assign		wire_nlOl1li_dataout = (nlilllO === 1'b1) ? nlO0lOi : nlO0lOl;
	assign		wire_nlOl1ll_dataout = (nlilllO === 1'b1) ? nlO0lOl : nlO0lOO;
	assign		wire_nlOl1lO_dataout = (nlilllO === 1'b1) ? nlO0lOO : nlO0O1i;
	and(wire_nlOl1O_dataout, wire_nlOl0l_dataout, ~((~ wire_nli0i_dataout)));
	assign		wire_nlOl1Oi_dataout = (nlilllO === 1'b1) ? nlO0O1i : nlO0O1l;
	assign		wire_nlOl1Ol_dataout = (nlilllO === 1'b1) ? nlO0O1l : nlO0O1O;
	assign		wire_nlOl1OO_dataout = (nlilllO === 1'b1) ? nlO0O1O : nlO0O0i;
	assign		wire_nlOli_dataout = (rwa_6g_en === 1'b1) ? nii1Ol : nlO0iOl;
	and(wire_nlOli1i_dataout, wire_nlOli0i_o[2], ~(nlillll));
	and(wire_nlOli1l_dataout, wire_nlOli0i_o[3], ~(nlillll));
	and(wire_nlOli1O_dataout, wire_nlOli0i_o[4], ~(nlillll));
	assign		wire_nlOlii_dataout = ((~ wire_nli0i_dataout) === 1'b1) ? nlOO1l : wire_nlOlli_dataout;
	assign		wire_nlOlil_dataout = ((~ wire_nli0i_dataout) === 1'b1) ? nlOill : wire_nlOlll_dataout;
	and(wire_nlOliO_dataout, (~ nll1O1l), ~((~ wire_nli0i_dataout)));
	assign		wire_nlOll_dataout = (rwa_6g_en === 1'b1) ? nii1OO : nlO0iOO;
	assign		wire_nlOlli_dataout = (nll1O1l === 1'b1) ? wire_n0ii_dataout : nlOO1l;
	assign		wire_nlOlll_dataout = (nll1O1l === 1'b1) ? wire_n0il_dataout : nlOill;
	assign		wire_nlOlO_dataout = (rwa_6g_en === 1'b1) ? nii01i : nlO0l1i;
	and(wire_nlOlOi_dataout, wire_n00O_dataout, wire_nli0i_dataout);
	and(wire_nlOlOOl_dataout, wire_nlOO0iO_dataout, ~(nliO0il));
	and(wire_nlOlOOO_dataout, wire_nlOO0li_dataout, ~(nliO0il));
	assign		wire_nlOO_dataout = (rwa_6g_en === 1'b1) ? nli1il : n1ii1O;
	and(wire_nlOO00i_dataout, wire_nlOOiOl_dataout, ~(nliO0il));
	and(wire_nlOO00l_dataout, wire_nlOOiOO_dataout, ~(nliO0il));
	and(wire_nlOO00O_dataout, wire_nlOOl1i_dataout, ~(nliO0il));
	and(wire_nlOO01i_dataout, wire_nlOOill_dataout, ~(nliO0il));
	and(wire_nlOO01l_dataout, wire_nlOOilO_dataout, ~(nliO0il));
	and(wire_nlOO01O_dataout, wire_nlOOiOi_dataout, ~(nliO0il));
	and(wire_nlOO0ii_dataout, wire_nlOOl1l_dataout, ~(nliO0il));
	and(wire_nlOO0il_dataout, wire_nlOOl1O_dataout, ~(nliO0il));
	assign		wire_nlOO0iO_dataout = (nliO00O === 1'b1) ? wire_n111ii_dataout : wire_nlOOl0i_dataout;
	assign		wire_nlOO0li_dataout = (nliO00O === 1'b1) ? wire_n111il_dataout : wire_nlOOl0l_dataout;
	assign		wire_nlOO0ll_dataout = (nliO00O === 1'b1) ? wire_n111iO_dataout : wire_nlOOl0O_dataout;
	assign		wire_nlOO0lO_dataout = (nliO00O === 1'b1) ? wire_n111li_dataout : wire_nlOOlii_dataout;
	assign		wire_nlOO0Oi_dataout = (nliO00O === 1'b1) ? wire_n111ll_dataout : wire_nlOOlil_dataout;
	assign		wire_nlOO0Ol_dataout = (nliO00O === 1'b1) ? nlOlOlO : wire_nlOOliO_dataout;
	assign		wire_nlOO0OO_dataout = (nliO00O === 1'b1) ? nlOllil : wire_nlOOlli_dataout;
	or(wire_nlOO10i_dataout, wire_nlOO0Ol_dataout, nliO0il);
	and(wire_nlOO10l_dataout, wire_nlOO0OO_dataout, ~(nliO0il));
	and(wire_nlOO10O_dataout, wire_nlOOi1i_dataout, ~(nliO0il));
	and(wire_nlOO11i_dataout, wire_nlOO0ll_dataout, ~(nliO0il));
	and(wire_nlOO11l_dataout, wire_nlOO0lO_dataout, ~(nliO0il));
	and(wire_nlOO11O_dataout, wire_nlOO0Oi_dataout, ~(nliO0il));
	and(wire_nlOO1ii_dataout, wire_nlOOi1l_dataout, ~(nliO0il));
	and(wire_nlOO1il_dataout, wire_nlOOi1O_dataout, ~(nliO0il));
	and(wire_nlOO1iO_dataout, wire_nlOOi0i_dataout, ~(nliO0il));
	and(wire_nlOO1li_dataout, wire_nlOOi0l_dataout, ~(nliO0il));
	and(wire_nlOO1ll_dataout, wire_nlOOi0O_dataout, ~(nliO0il));
	and(wire_nlOO1lO_dataout, wire_nlOOiii_dataout, ~(nliO0il));
	and(wire_nlOO1Oi_dataout, wire_nlOOiil_dataout, ~(nliO0il));
	and(wire_nlOO1Ol_dataout, wire_nlOOiiO_dataout, ~(nliO0il));
	and(wire_nlOO1OO_dataout, wire_nlOOili_dataout, ~(nliO0il));
	assign		wire_nlOOi_dataout = (rwa_6g_en === 1'b1) ? nii01l : nlO0l1l;
	assign		wire_nlOOi0i_dataout = (nliO00O === 1'b1) ? nlOlllO : wire_nlOOlOl_dataout;
	assign		wire_nlOOi0l_dataout = (nliO00O === 1'b1) ? nlOllOi : wire_nlOOlOO_dataout;
	assign		wire_nlOOi0O_dataout = (nliO00O === 1'b1) ? nlOllOl : wire_nlOOO1i_dataout;
	assign		wire_nlOOi1i_dataout = (nliO00O === 1'b1) ? nlOlliO : wire_nlOOlll_dataout;
	assign		wire_nlOOi1l_dataout = (nliO00O === 1'b1) ? nlOllli : wire_nlOOllO_dataout;
	assign		wire_nlOOi1O_dataout = (nliO00O === 1'b1) ? nlOllll : wire_nlOOlOi_dataout;
	assign		wire_nlOOiii_dataout = (nliO00O === 1'b1) ? nlOllOO : wire_nlOOO1l_dataout;
	assign		wire_nlOOiil_dataout = (nliO00O === 1'b1) ? nlOlO1i : wire_nlOOO1O_dataout;
	assign		wire_nlOOiiO_dataout = (nliO00O === 1'b1) ? nlOlO1l : wire_nlOOO0i_dataout;
	assign		wire_nlOOili_dataout = (nliO00O === 1'b1) ? nlOlO1O : wire_nlOOO0l_dataout;
	assign		wire_nlOOill_dataout = (nliO00O === 1'b1) ? nlOlO0i : wire_nlOOO0O_dataout;
	assign		wire_nlOOilO_dataout = (nliO00O === 1'b1) ? nlOlO0l : wire_nlOOOii_dataout;
	assign		wire_nlOOiOi_dataout = (nliO00O === 1'b1) ? nlOlO0O : wire_nlOOOil_dataout;
	assign		wire_nlOOiOl_dataout = (nliO00O === 1'b1) ? nlOlOii : wire_nlOOOiO_dataout;
	assign		wire_nlOOiOO_dataout = (nliO00O === 1'b1) ? nlOlOil : wire_nlOOOli_dataout;
	assign		wire_nlOOl_dataout = (rwa_6g_en === 1'b1) ? nii01O : nlO0l1O;
	assign		wire_nlOOl0i_dataout = (nlillOl === 1'b1) ? wire_nlOOOOl_dataout : nlO0Oli;
	assign		wire_nlOOl0l_dataout = (nlillOl === 1'b1) ? wire_nlOOOOO_dataout : nlOliiO;
	assign		wire_nlOOl0O_dataout = (nlillOl === 1'b1) ? wire_n1111i_dataout : nlOlili;
	assign		wire_nlOOl1i_dataout = (nliO00O === 1'b1) ? nlOlOiO : wire_nlOOOll_dataout;
	assign		wire_nlOOl1l_dataout = (nliO00O === 1'b1) ? nlOlOli : wire_nlOOOlO_dataout;
	assign		wire_nlOOl1O_dataout = (nliO00O === 1'b1) ? nlOlOll : wire_nlOOOOi_dataout;
	assign		wire_nlOOlii_dataout = (nlillOl === 1'b1) ? wire_n1111l_dataout : nlOlill;
	assign		wire_nlOOlil_dataout = (nlillOl === 1'b1) ? wire_n1111O_dataout : nlOlilO;
	assign		wire_nlOOliO_dataout = (nlillOl === 1'b1) ? nlOlliO : nlOllil;
	assign		wire_nlOOlli_dataout = (nlillOl === 1'b1) ? nlOllli : nlOlliO;
	assign		wire_nlOOlll_dataout = (nlillOl === 1'b1) ? nlOllll : nlOllli;
	assign		wire_nlOOllO_dataout = (nlillOl === 1'b1) ? nlOlllO : nlOllll;
	assign		wire_nlOOlOi_dataout = (nlillOl === 1'b1) ? nlOllOi : nlOlllO;
	assign		wire_nlOOlOl_dataout = (nlillOl === 1'b1) ? nlOllOl : nlOllOi;
	assign		wire_nlOOlOO_dataout = (nlillOl === 1'b1) ? nlOllOO : nlOllOl;
	assign		wire_nlOOO_dataout = (rwa_6g_en === 1'b1) ? nii00i : nlO0l0i;
	assign		wire_nlOOO0i_dataout = (nlillOl === 1'b1) ? nlOlO0i : nlOlO1O;
	assign		wire_nlOOO0l_dataout = (nlillOl === 1'b1) ? nlOlO0l : nlOlO0i;
	assign		wire_nlOOO0O_dataout = (nlillOl === 1'b1) ? nlOlO0O : nlOlO0l;
	assign		wire_nlOOO1i_dataout = (nlillOl === 1'b1) ? nlOlO1i : nlOllOO;
	assign		wire_nlOOO1l_dataout = (nlillOl === 1'b1) ? nlOlO1l : nlOlO1i;
	assign		wire_nlOOO1O_dataout = (nlillOl === 1'b1) ? nlOlO1O : nlOlO1l;
	assign		wire_nlOOOii_dataout = (nlillOl === 1'b1) ? nlOlOii : nlOlO0O;
	assign		wire_nlOOOil_dataout = (nlillOl === 1'b1) ? nlOlOil : nlOlOii;
	assign		wire_nlOOOiO_dataout = (nlillOl === 1'b1) ? nlOlOiO : nlOlOil;
	assign		wire_nlOOOli_dataout = (nlillOl === 1'b1) ? nlOlOli : nlOlOiO;
	assign		wire_nlOOOll_dataout = (nlillOl === 1'b1) ? nlOlOll : nlOlOli;
	assign		wire_nlOOOlO_dataout = (nlillOl === 1'b1) ? nlOlOlO : nlOlOll;
	assign		wire_nlOOOOi_dataout = (nlillOl === 1'b1) ? nlOllil : nlOlOlO;
	or(wire_nlOOOOl_dataout, wire_n1110i_o[1], nlillOi);
	or(wire_nlOOOOO_dataout, wire_n1110i_o[2], nlillOi);
	oper_add   n1110i
	( 
	.a({nlOlilO, nlOlill, nlOlili, nlOliiO, nlO0Oli, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1110i_o));
	defparam
		n1110i.sgate_representation = 0,
		n1110i.width_a = 6,
		n1110i.width_b = 6,
		n1110i.width_o = 6;
	oper_add   n111lO
	( 
	.a({nlOlilO, nlOlill, nlOlili, nlOliiO, nlO0Oli}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n111lO_o));
	defparam
		n111lO.sgate_representation = 0,
		n111lO.width_a = 5,
		n111lO.width_b = 5,
		n111lO.width_o = 5;
	oper_add   n1i0ll
	( 
	.a({1'b0, (~ ralempty[3]), (~ ralempty[2]), (~ ralempty[1]), (~ ralempty[0]), 1'b1}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1i0ll_o));
	defparam
		n1i0ll.sgate_representation = 0,
		n1i0ll.width_a = 6,
		n1i0ll.width_b = 6,
		n1i0ll.width_o = 6;
	oper_add   n1i0Ol
	( 
	.a({1'b0, ralfull[3:2]}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1i0Ol_o));
	defparam
		n1i0Ol.sgate_representation = 0,
		n1i0Ol.width_a = 3,
		n1i0Ol.width_b = 3,
		n1i0Ol.width_o = 3;
	oper_add   n1ilii
	( 
	.a({(~ wire_n1ilil_o[5]), (~ wire_n1ilil_o[4]), (~ wire_n1ilil_o[3]), (~ wire_n1ilil_o[2]), (~ wire_n1ilil_o[1]), 1'b1}),
	.b({1'b1, 1'b0, 1'b1, {2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1ilii_o));
	defparam
		n1ilii.sgate_representation = 0,
		n1ilii.width_a = 6,
		n1ilii.width_b = 6,
		n1ilii.width_o = 6;
	oper_add   n1ilil
	( 
	.a({nlOll1l, nliO1il, nliO1iO, nliO1li, nliO1ll, 1'b1}),
	.b({(~ nlOlilO), (~ nlOlill), (~ nlOlili), (~ nlOliiO), (~ nlO0Oli), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1ilil_o));
	defparam
		n1ilil.sgate_representation = 0,
		n1ilil.width_a = 6,
		n1ilil.width_b = 6,
		n1ilil.width_o = 6;
	oper_add   n1iliO
	( 
	.a({nlOlilO, nlOlill, nlOlili, nlOliiO, nlO0Oli, 1'b1}),
	.b({(~ nlOll1l), (~ nliO1il), (~ nliO1iO), (~ nliO1li), (~ nliO1ll), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1iliO_o));
	defparam
		n1iliO.sgate_representation = 0,
		n1iliO.width_a = 6,
		n1iliO.width_b = 6,
		n1iliO.width_o = 6;
	oper_add   n1llOl
	( 
	.a({n1li1i, n1l0OO, n1l0Ol, n1l0Oi, n1l0lO, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1llOl_o));
	defparam
		n1llOl.sgate_representation = 0,
		n1llOl.width_a = 6,
		n1llOl.width_b = 6,
		n1llOl.width_o = 6;
	oper_add   n1llOO
	( 
	.a({n1li1i, n1l0OO, n1l0Ol, n1l0Oi, n1l0lO}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1llOO_o));
	defparam
		n1llOO.sgate_representation = 0,
		n1llOO.width_a = 5,
		n1llOO.width_b = 5,
		n1llOO.width_o = 5;
	oper_add   n1lO0O
	( 
	.a({n1li1i, n1l0OO, n1l0Ol, n1l0Oi}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1lO0O_o));
	defparam
		n1lO0O.sgate_representation = 0,
		n1lO0O.width_a = 4,
		n1lO0O.width_b = 4,
		n1lO0O.width_o = 4;
	oper_add   n1lOil
	( 
	.a({n1li1i, n1l0OO, n1l0Ol, n1l0Oi, n1l0lO}),
	.b({{3{1'b0}}, {2{1'b1}}}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1lOil_o));
	defparam
		n1lOil.sgate_representation = 0,
		n1lOil.width_a = 5,
		n1lOil.width_b = 5,
		n1lOil.width_o = 5;
	oper_add   n1OilO
	( 
	.a({n1O0lO, n1O0ll, n1O0li}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1OilO_o));
	defparam
		n1OilO.sgate_representation = 0,
		n1OilO.width_a = 3,
		n1OilO.width_b = 3,
		n1OilO.width_o = 3;
	oper_add   niO10l
	( 
	.a({ni0OOl, ni0OOi, ni0OlO, ni0Oll, ni0Oli}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO10l_o));
	defparam
		niO10l.sgate_representation = 0,
		niO10l.width_a = 5,
		niO10l.width_b = 5,
		niO10l.width_o = 5;
	oper_add   nl10ll
	( 
	.a({niO1Ol, niO1Oi, niO1lO, niO1ll, niiill}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nl10ll_o));
	defparam
		nl10ll.sgate_representation = 0,
		nl10ll.width_a = 5,
		nl10ll.width_b = 5,
		nl10ll.width_o = 5;
	oper_add   nli0lO
	( 
	.a({(~ wire_nli0Oi_o[5]), (~ wire_nli0Oi_o[4]), (~ wire_nli0Oi_o[3]), (~ wire_nli0Oi_o[2]), (~ wire_nli0Oi_o[1]), 1'b1}),
	.b({1'b1, 1'b0, 1'b1, {2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0lO_o));
	defparam
		nli0lO.sgate_representation = 0,
		nli0lO.width_a = 6,
		nli0lO.width_b = 6,
		nli0lO.width_o = 6;
	oper_add   nli0Oi
	( 
	.a({niO00i, nll11il, nll11iO, nll11li, nll11ll, 1'b1}),
	.b({(~ niO1Ol), (~ niO1Oi), (~ niO1lO), (~ niO1ll), (~ niiill), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0Oi_o));
	defparam
		nli0Oi.sgate_representation = 0,
		nli0Oi.width_a = 6,
		nli0Oi.width_b = 6,
		nli0Oi.width_o = 6;
	oper_add   nli0Ol
	( 
	.a({niO1Ol, niO1Oi, niO1lO, niO1ll, niiill, 1'b1}),
	.b({(~ niO00i), (~ nll11il), (~ nll11iO), (~ nll11li), (~ nll11ll), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0Ol_o));
	defparam
		nli0Ol.sgate_representation = 0,
		nli0Ol.width_a = 6,
		nli0Ol.width_b = 6,
		nli0Ol.width_o = 6;
	oper_add   nli10i
	( 
	.a({1'b0, ralfull[3:2]}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli10i_o));
	defparam
		nli10i.sgate_representation = 0,
		nli10i.width_a = 3,
		nli10i.width_b = 3,
		nli10i.width_o = 3;
	oper_add   nli11i
	( 
	.a({1'b0, (~ ralempty[3]), (~ ralempty[2]), (~ ralempty[1]), (~ ralempty[0]), 1'b1}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli11i_o));
	defparam
		nli11i.sgate_representation = 0,
		nli11i.width_a = 6,
		nli11i.width_b = 6,
		nli11i.width_o = 6;
	oper_add   nlilOl
	( 
	.a({nliilO, nliill, nliili, nliiiO, nli1li, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlilOl_o));
	defparam
		nlilOl.sgate_representation = 0,
		nlilOl.width_a = 6,
		nlilOl.width_b = 6,
		nlilOl.width_o = 6;
	oper_add   nlilOO
	( 
	.a({nliilO, nliill, nliili, nliiiO, nli1li}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlilOO_o));
	defparam
		nlilOO.sgate_representation = 0,
		nlilOO.width_a = 5,
		nlilOO.width_b = 5,
		nlilOO.width_o = 5;
	oper_add   nlOli0i
	( 
	.a({nlO00Ol, nlO00Oi, nlO00lO, nlO00ll, nlO00li}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlOli0i_o));
	defparam
		nlOli0i.sgate_representation = 0,
		nlOli0i.width_a = 5,
		nlOli0i.width_b = 5,
		nlOli0i.width_o = 5;
	oper_decoder   n1010O
	( 
	.i({wire_n1il0O_dataout, wire_n1il0l_dataout, wire_n1il0i_dataout, wire_n1il1O_dataout, wire_n1il1l_dataout}),
	.o(wire_n1010O_o));
	defparam
		n1010O.width_i = 5,
		n1010O.width_o = 32;
	oper_decoder   n101il
	( 
	.i({wire_n1il0O_dataout, wire_n1il0i_dataout, wire_n1il1O_dataout}),
	.o(wire_n101il_o));
	defparam
		n101il.width_i = 3,
		n101il.width_o = 8;
	oper_decoder   n101ll
	( 
	.i({wire_n1il0O_dataout, wire_n1il0l_dataout, wire_n1il0i_dataout, wire_n1il1O_dataout}),
	.o(wire_n101ll_o));
	defparam
		n101ll.width_i = 4,
		n101ll.width_o = 16;
	oper_decoder   n101lO
	( 
	.i({wire_n1il0O_dataout, wire_n1il0l_dataout, wire_n1il0i_dataout}),
	.o(wire_n101lO_o));
	defparam
		n101lO.width_i = 3,
		n101lO.width_o = 8;
	oper_decoder   nilOil
	( 
	.i({ni0OOl, ni0OOi, ni0OlO, ni0Oll}),
	.o(wire_nilOil_o));
	defparam
		nilOil.width_i = 4,
		nilOil.width_o = 16;
	oper_decoder   nilOli
	( 
	.i({ni0OOl, ni0OlO, ni0Oll, ni0Oli}),
	.o(wire_nilOli_o));
	defparam
		nilOli.width_i = 4,
		nilOli.width_o = 16;
	oper_decoder   nilOOl
	( 
	.i({ni0OOl, ni0OOi, ni0OlO, ni0Oll, ni0Oli}),
	.o(wire_nilOOl_o));
	defparam
		nilOOl.width_i = 5,
		nilOOl.width_o = 32;
	oper_decoder   nl1O0i
	( 
	.i({wire_nli0ll_dataout, wire_nli0iO_dataout, wire_nli0il_dataout}),
	.o(wire_nl1O0i_o));
	defparam
		nl1O0i.width_i = 3,
		nl1O0i.width_o = 8;
	oper_decoder   nl1O1l
	( 
	.i({wire_nli0ll_dataout, wire_nli0li_dataout, wire_nli0iO_dataout, wire_nli0il_dataout, wire_nli0ii_dataout}),
	.o(wire_nl1O1l_o));
	defparam
		nl1O1l.width_i = 5,
		nl1O1l.width_o = 32;
	oper_decoder   nl1Oii
	( 
	.i({wire_nli0ll_dataout, wire_nli0li_dataout, wire_nli0iO_dataout, wire_nli0il_dataout}),
	.o(wire_nl1Oii_o));
	defparam
		nl1Oii.width_i = 4,
		nl1Oii.width_o = 16;
	oper_decoder   nl1Oil
	( 
	.i({wire_nli0ll_dataout, wire_nli0li_dataout, wire_nli0iO_dataout}),
	.o(wire_nl1Oil_o));
	defparam
		nl1Oil.width_i = 3,
		nl1Oil.width_o = 8;
	oper_decoder   nlOl0ii
	( 
	.i({nlO00Ol, nlO00Oi, nlO00lO, nlO00ll}),
	.o(wire_nlOl0ii_o));
	defparam
		nlOl0ii.width_i = 4,
		nlOl0ii.width_o = 16;
	oper_decoder   nlOl0iO
	( 
	.i({nlO00Ol, nlO00lO, nlO00ll, nlO00li}),
	.o(wire_nlOl0iO_o));
	defparam
		nlOl0iO.width_i = 4,
		nlOl0iO.width_o = 16;
	oper_decoder   nlOl0Oi
	( 
	.i({nlO00Ol, nlO00Oi, nlO00lO, nlO00ll, nlO00li}),
	.o(wire_nlOl0Oi_o));
	defparam
		nlOl0Oi.width_i = 5,
		nlOl0Oi.width_o = 32;
	oper_less_than   n11l0l
	( 
	.a({n1O0lO, n1O0ll, n1O0li}),
	.b({1'b1, 1'b0, 1'b1}),
	.cin(1'b0),
	.o(wire_n11l0l_o));
	defparam
		n11l0l.sgate_representation = 0,
		n11l0l.width_a = 3,
		n11l0l.width_b = 3;
	oper_less_than   n11lil
	( 
	.a({3{1'b0}}),
	.b({n1O0lO, n1O0ll, n1O0li}),
	.cin(1'b0),
	.o(wire_n11lil_o));
	defparam
		n11lil.sgate_representation = 0,
		n11lil.width_a = 3,
		n11lil.width_b = 3;
	oper_less_than   n11O0i
	( 
	.a({1'b0, 1'b1, 1'b0, {2{1'b1}}}),
	.b({n1001i, nlilO0O, nlilOii, nlilOil, nlilOiO}),
	.cin(1'b1),
	.o(wire_n11O0i_o));
	defparam
		n11O0i.sgate_representation = 0,
		n11O0i.width_a = 5,
		n11O0i.width_b = 5;
	oper_less_than   n1i0li
	( 
	.a({n1ii0i, n1ii1O, n1ii1l, n1ii1i, n1i1li}),
	.b({wire_n1i0ll_o[5:1]}),
	.cin(1'b0),
	.o(wire_n1i0li_o));
	defparam
		n1i0li.sgate_representation = 0,
		n1i0li.width_a = 5,
		n1i0li.width_b = 5;
	oper_less_than   n1i0Oi
	( 
	.a({wire_n1i0Ol_o[2:0], ralfull[1:0]}),
	.b({n1ii0i, n1ii1O, n1ii1l, n1ii1i, n1i1li}),
	.cin(1'b0),
	.o(wire_n1i0Oi_o));
	defparam
		n1i0Oi.sgate_representation = 0,
		n1i0Oi.width_a = 5,
		n1i0Oi.width_b = 5;
	oper_less_than   n1i0OO
	( 
	.a({5{1'b0}}),
	.b({nlOll1l, nliO1il, nliO1iO, nliO1li, nliO1ll}),
	.cin(1'b0),
	.o(wire_n1i0OO_o));
	defparam
		n1i0OO.sgate_representation = 0,
		n1i0OO.width_a = 5,
		n1i0OO.width_b = 5;
	oper_less_than   n1illi
	( 
	.a({nlOll1l, nliO1il, nliO1iO, nliO1li, nliO1ll}),
	.b({nlOlilO, nlOlill, nlOlili, nlOliiO, nlO0Oli}),
	.cin(1'b1),
	.o(wire_n1illi_o));
	defparam
		n1illi.sgate_representation = 0,
		n1illi.width_a = 5,
		n1illi.width_b = 5;
	oper_less_than   n1iOOO
	( 
	.a({1'b0, {2{1'b1}}, 1'b0, 1'b1}),
	.b({wire_n1il0O_dataout, wire_n1il0l_dataout, wire_n1il0i_dataout, wire_n1il1O_dataout, wire_n1il1l_dataout}),
	.cin(1'b0),
	.o(wire_n1iOOO_o));
	defparam
		n1iOOO.sgate_representation = 0,
		n1iOOO.width_a = 5,
		n1iOOO.width_b = 5;
	oper_less_than   n1l0ll
	( 
	.a({n1ii0i, n1ii1O, n1ii1l, n1ii1i, n1i1li}),
	.b({{2{1'b0}}, 1'b1, 1'b0, 1'b1}),
	.cin(1'b0),
	.o(wire_n1l0ll_o));
	defparam
		n1l0ll.sgate_representation = 0,
		n1l0ll.width_a = 5,
		n1l0ll.width_b = 5;
	oper_less_than   n1O00i
	( 
	.a({1'b0, {2{1'b1}}, 1'b0, 1'b1}),
	.b({n1ii0i, n1ii1O, n1ii1l, n1ii1i, n1i1li}),
	.cin(1'b0),
	.o(wire_n1O00i_o));
	defparam
		n1O00i.sgate_representation = 0,
		n1O00i.width_a = 5,
		n1O00i.width_b = 5;
	oper_less_than   n1O00l
	( 
	.a({n1ii0i, n1ii1O, n1ii1l, n1ii1i, n1i1li}),
	.b({1'b0, 1'b1, 1'b0, {2{1'b1}}}),
	.cin(1'b0),
	.o(wire_n1O00l_o));
	defparam
		n1O00l.sgate_representation = 0,
		n1O00l.width_a = 5,
		n1O00l.width_b = 5;
	oper_less_than   nl0OOO
	( 
	.a({nli1iO, nli1il, nli1ii, nli10O, nl0lOO}),
	.b({wire_nli11i_o[5:1]}),
	.cin(1'b0),
	.o(wire_nl0OOO_o));
	defparam
		nl0OOO.sgate_representation = 0,
		nl0OOO.width_a = 5,
		nl0OOO.width_b = 5;
	oper_less_than   nl1iOO
	( 
	.a({1'b0, 1'b1, 1'b0, {2{1'b1}}}),
	.b({nl1OlO, nliOO0l, nliOO0O, nliOOii, nliOOil}),
	.cin(1'b1),
	.o(wire_nl1iOO_o));
	defparam
		nl1iOO.sgate_representation = 0,
		nl1iOO.width_a = 5,
		nl1iOO.width_b = 5;
	oper_less_than   nli0OO
	( 
	.a({niO00i, nll11il, nll11iO, nll11li, nll11ll}),
	.b({niO1Ol, niO1Oi, niO1lO, niO1ll, niiill}),
	.cin(1'b1),
	.o(wire_nli0OO_o));
	defparam
		nli0OO.sgate_representation = 0,
		nli0OO.width_a = 5,
		nli0OO.width_b = 5;
	oper_less_than   nli10l
	( 
	.a({5{1'b0}}),
	.b({niO00i, nll11il, nll11iO, nll11li, nll11ll}),
	.cin(1'b0),
	.o(wire_nli10l_o));
	defparam
		nli10l.sgate_representation = 0,
		nli10l.width_a = 5,
		nli10l.width_b = 5;
	oper_less_than   nli11O
	( 
	.a({wire_nli10i_o[2:0], ralfull[1:0]}),
	.b({nli1iO, nli1il, nli1ii, nli10O, nl0lOO}),
	.cin(1'b0),
	.o(wire_nli11O_o));
	defparam
		nli11O.sgate_representation = 0,
		nli11O.width_a = 5,
		nli11O.width_b = 5;
	oper_less_than   nlii0l
	( 
	.a({1'b0, {2{1'b1}}, 1'b0, 1'b1}),
	.b({wire_nli0ll_dataout, wire_nli0li_dataout, wire_nli0iO_dataout, wire_nli0il_dataout, wire_nli0ii_dataout}),
	.cin(1'b0),
	.o(wire_nlii0l_o));
	defparam
		nlii0l.sgate_representation = 0,
		nlii0l.width_a = 5,
		nlii0l.width_b = 5;
	oper_less_than   nliiil
	( 
	.a({nli1iO, nli1il, nli1ii, nli10O, nl0lOO}),
	.b({{2{1'b0}}, 1'b1, 1'b0, 1'b1}),
	.cin(1'b0),
	.o(wire_nliiil_o));
	defparam
		nliiil.sgate_representation = 0,
		nliiil.width_a = 5,
		nliiil.width_b = 5;
	oper_less_than   nliOOO
	( 
	.a({1'b0, {2{1'b1}}, 1'b0, 1'b1}),
	.b({nli1iO, nli1il, nli1ii, nli10O, nl0lOO}),
	.cin(1'b0),
	.o(wire_nliOOO_o));
	defparam
		nliOOO.sgate_representation = 0,
		nliOOO.width_a = 5,
		nliOOO.width_b = 5;
	oper_less_than   nll11i
	( 
	.a({nli1iO, nli1il, nli1ii, nli10O, nl0lOO}),
	.b({1'b0, 1'b1, 1'b0, {2{1'b1}}}),
	.cin(1'b0),
	.o(wire_nll11i_o));
	defparam
		nll11i.sgate_representation = 0,
		nll11i.width_a = 5,
		nll11i.width_b = 5;
	oper_mux   n000iO
	( 
	.data({{3{rclkcmpsq1n[0]}}, rclkcmpsq1n[10], rclkcmpsq1p[10], rclkcmpsq1n[10], rclkcmpsq1p[0], rclkcmpsq1n[0]}),
	.o(wire_n000iO_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n000iO.width_data = 8,
		n000iO.width_sel = 3;
	oper_mux   n000li
	( 
	.data({{3{rclkcmpsq1n[1]}}, rclkcmpsq1n[11], rclkcmpsq1p[11], rclkcmpsq1n[11], rclkcmpsq1p[1], rclkcmpsq1n[1]}),
	.o(wire_n000li_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n000li.width_data = 8,
		n000li.width_sel = 3;
	oper_mux   n000ll
	( 
	.data({{3{rclkcmpsq1n[2]}}, rclkcmpsq1n[12], rclkcmpsq1p[12], rclkcmpsq1n[12], rclkcmpsq1p[2], rclkcmpsq1n[2]}),
	.o(wire_n000ll_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n000ll.width_data = 8,
		n000ll.width_sel = 3;
	oper_mux   n000lO
	( 
	.data({{3{rclkcmpsq1n[3]}}, rclkcmpsq1n[13], rclkcmpsq1p[13], rclkcmpsq1n[13], rclkcmpsq1p[3], rclkcmpsq1n[3]}),
	.o(wire_n000lO_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n000lO.width_data = 8,
		n000lO.width_sel = 3;
	oper_mux   n000Oi
	( 
	.data({{3{rclkcmpsq1n[4]}}, rclkcmpsq1n[14], rclkcmpsq1p[14], rclkcmpsq1n[14], rclkcmpsq1p[4], rclkcmpsq1n[4]}),
	.o(wire_n000Oi_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n000Oi.width_data = 8,
		n000Oi.width_sel = 3;
	oper_mux   n000Ol
	( 
	.data({{3{rclkcmpsq1n[5]}}, rclkcmpsq1n[15], rclkcmpsq1p[15], rclkcmpsq1n[15], rclkcmpsq1p[5], rclkcmpsq1n[5]}),
	.o(wire_n000Ol_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n000Ol.width_data = 8,
		n000Ol.width_sel = 3;
	oper_mux   n000OO
	( 
	.data({{3{rclkcmpsq1n[6]}}, rclkcmpsq1n[16], rclkcmpsq1p[16], rclkcmpsq1n[16], rclkcmpsq1p[6], rclkcmpsq1n[6]}),
	.o(wire_n000OO_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n000OO.width_data = 8,
		n000OO.width_sel = 3;
	oper_mux   n00i1i
	( 
	.data({{3{rclkcmpsq1n[7]}}, rclkcmpsq1n[17], rclkcmpsq1p[17], rclkcmpsq1n[17], rclkcmpsq1p[7], rclkcmpsq1n[7]}),
	.o(wire_n00i1i_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n00i1i.width_data = 8,
		n00i1i.width_sel = 3;
	oper_mux   n00i1l
	( 
	.data({{3{rclkcmpsq1n[8]}}, rclkcmpsq1n[18], rclkcmpsq1p[18], rclkcmpsq1n[18], rclkcmpsq1p[8], rclkcmpsq1n[8]}),
	.o(wire_n00i1l_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n00i1l.width_data = 8,
		n00i1l.width_sel = 3;
	oper_mux   n00i1O
	( 
	.data({{3{rclkcmpsq1n[9]}}, rclkcmpsq1n[19], rclkcmpsq1p[19], rclkcmpsq1n[19], rclkcmpsq1p[9], rclkcmpsq1n[9]}),
	.o(wire_n00i1O_o),
	.sel({rskpsetbased, rclkcmpsqmd, rclkcmppos}));
	defparam
		n00i1O.width_data = 8,
		n00i1O.width_sel = 3;
	oper_mux   nlOiOi
	( 
	.data({wire_nlOlii_dataout, ((nll1lOi32 ^ nll1lOi31) & wire_nlOl0i_dataout), {2{nlOO1l}}}),
	.o(wire_nlOiOi_o),
	.sel({nlOlOO, nlOilO}));
	defparam
		nlOiOi.width_data = 4,
		nlOiOi.width_sel = 2;
	oper_mux   nlOiOl
	( 
	.data({wire_nlOlil_dataout, wire_nlOl1O_dataout, ((nll1lOl30 ^ nll1lOl29) & nlOill), ((nll1lOO28 ^ nll1lOO27) & nlOill)}),
	.o(wire_nlOiOl_o),
	.sel({nlOlOO, nlOilO}));
	defparam
		nlOiOl.width_data = 4,
		nlOiOl.width_sel = 2;
	oper_mux   nlOiOO
	( 
	.data({wire_nlOliO_dataout, wire_nlOl1l_dataout, wire_nli0i_dataout, (wire_nli0l_dataout & wire_nli0i_dataout)}),
	.o(wire_nlOiOO_o),
	.sel({((nll1O1i26 ^ nll1O1i25) & nlOlOO), nlOilO}));
	defparam
		nlOiOO.width_data = 4,
		nlOiOO.width_sel = 2;
	oper_mux   nlOl1i
	( 
	.data({{2{wire_nli0i_dataout}}, wire_nlOlOi_dataout, 1'b0}),
	.o(wire_nlOl1i_o),
	.sel({nlOlOO, nlOilO}));
	defparam
		nlOl1i.width_data = 4,
		nlOl1i.width_sel = 2;
	stratixiigx_hssi_ram20x16_syn   nlOiiO
	( 
	.clk(clk_1),
	.data_in({wire_nl01l_dataout, wire_nl01i_dataout, wire_nl1OO_dataout, wire_nl1Ol_dataout, wire_nl1Oi_dataout, wire_nl1lO_dataout, wire_nl1ll_dataout, wire_nl1li_dataout, wire_nl1iO_dataout, wire_nl1il_dataout, wire_nl1ii_dataout, wire_nl10O_dataout, wire_nl10l_dataout, wire_nl10i_dataout, wire_nl11O_dataout, wire_nl11l_dataout}),
	.data_out1(wire_nlOiiO_data_out1),
	.data_out2(wire_nlOiiO_data_out2),
	.fifo_re1({wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout, wire_n1li_dataout, wire_n1iO_dataout, wire_n1il_dataout, wire_n1ii_dataout, wire_n10O_dataout, wire_n10l_dataout, wire_n10i_dataout, wire_n11O_dataout, wire_n11l_dataout, wire_n11i_dataout}),
	.fifo_re2({wire_nlOOO_dataout, wire_nlOOl_dataout, wire_nlOOi_dataout, wire_nlOlO_dataout, wire_nlOll_dataout, wire_nlOli_dataout, wire_nlOiO_dataout, wire_nlOil_dataout, wire_nlOii_dataout, wire_nlO0O_dataout, wire_nlO0l_dataout, wire_nlO0i_dataout, wire_nlO1O_dataout, wire_nlO1l_dataout, wire_nlO1i_dataout, wire_nllOO_dataout, wire_nllOl_dataout, wire_nllOi_dataout, wire_nlllO_dataout, wire_nllll_dataout}),
	.fifo_wr({wire_nllli_dataout, wire_nlliO_dataout, wire_nllil_dataout, wire_nllii_dataout, wire_nll0O_dataout, wire_nll0l_dataout, wire_nll0i_dataout, wire_nll1O_dataout, wire_nll1l_dataout, wire_nll1i_dataout, wire_nliOO_dataout, wire_nliOl_dataout, wire_nliOi_dataout, wire_nlilO_dataout, wire_nlill_dataout, wire_nlili_dataout, wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout}),
	.rst_l((~ wire_n1l_dataout)));
	defparam
		nlOiiO.ram_width = 16,
		nlOiiO.read_access_time = 0,
		nlOiiO.write_access_time = 0;
	stratixiigx_hssi_ram20x16_syn   nlOili
	( 
	.clk(clk_1),
	.data_in({wire_nli1O_dataout, wire_nli1l_dataout, wire_nli1i_dataout, wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout, wire_nl0ll_dataout, wire_nl0li_dataout, wire_nl0iO_dataout, wire_nl0il_dataout, wire_nl0ii_dataout, wire_nl00O_dataout, wire_nl00l_dataout, wire_nl00i_dataout, wire_nl01O_dataout}),
	.data_out1(wire_nlOili_data_out1),
	.data_out2(wire_nlOili_data_out2),
	.fifo_re1({wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout, wire_n1li_dataout, wire_n1iO_dataout, wire_n1il_dataout, wire_n1ii_dataout, wire_n10O_dataout, wire_n10l_dataout, wire_n10i_dataout, wire_n11O_dataout, wire_n11l_dataout, wire_n11i_dataout}),
	.fifo_re2({wire_nlOOO_dataout, wire_nlOOl_dataout, wire_nlOOi_dataout, wire_nlOlO_dataout, wire_nlOll_dataout, wire_nlOli_dataout, wire_nlOiO_dataout, wire_nlOil_dataout, wire_nlOii_dataout, wire_nlO0O_dataout, wire_nlO0l_dataout, wire_nlO0i_dataout, wire_nlO1O_dataout, wire_nlO1l_dataout, wire_nlO1i_dataout, wire_nllOO_dataout, wire_nllOl_dataout, wire_nllOi_dataout, wire_nlllO_dataout, wire_nllll_dataout}),
	.fifo_wr({wire_nllli_dataout, wire_nlliO_dataout, wire_nllil_dataout, wire_nllii_dataout, wire_nll0O_dataout, wire_nll0l_dataout, wire_nll0i_dataout, wire_nll1O_dataout, wire_nll1l_dataout, wire_nll1i_dataout, wire_nliOO_dataout, wire_nliOl_dataout, wire_nliOi_dataout, wire_nlilO_dataout, wire_nlill_dataout, wire_nlili_dataout, wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout}),
	.rst_l((~ wire_n1l_dataout)));
	defparam
		nlOili.ram_width = 16,
		nlOili.read_access_time = 0,
		nlOili.write_access_time = 0;
	assign
		align_status_sync = n10i0O,
		comp_curr_st = {nlOlOO, nlOilO},
		cudi = {wire_nlll_dataout, wire_nlli_dataout, wire_nliO_dataout, wire_nlil_dataout, wire_nlii_dataout, wire_nl0O_dataout, wire_nl0l_dataout, wire_nl0i_dataout, wire_nl1O_dataout, wire_nl1l_dataout, wire_nl1i_dataout, wire_niOO_dataout, wire_niOl_dataout, wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout},
		cudi_valid = wire_nilll_dataout,
		disable_fifo_rd = nll1O0l,
		disable_fifo_wr = nll1O0i,
		fifo_cnt = {wire_n1i_dataout, wire_nlOO_dataout, wire_nlOl_dataout, wire_nlOi_dataout, wire_nllO_dataout},
		fifo_rd_out_comp = n10ilO,
		nlill0i = (nlOll1i ^ nlOliOl),
		nlill0O = (rgenericfifo & (~ n100ii)),
		nlill1O = (n101OO ^ n101Oi),
		nlillii = (n100ii | ((~ rgenericfifo) & (~ wire_n110ll_dataout))),
		nlillil = ((((wire_nlOl0ii_o[8] | wire_nlOl0ii_o[6]) | wire_nlOl0ii_o[4]) | wire_nlOl0ii_o[2]) | wire_nlOl0ii_o[0]),
		nlilliO = (((((((wire_nlOl0Oi_o[10] | wire_nlOl0Oi_o[9]) | wire_nlOl0Oi_o[8]) | wire_nlOl0Oi_o[7]) | wire_nlOl0Oi_o[6]) | wire_nlOl0Oi_o[5]) | wire_nlOl0Oi_o[4]) | wire_nlOl0Oi_o[3]),
		nlillli = (((((((((wire_nlOl0Oi_o[16] | wire_nlOl0Oi_o[15]) | wire_nlOl0Oi_o[14]) | wire_nlOl0Oi_o[13]) | wire_nlOl0Oi_o[12]) | wire_nlOl0Oi_o[11]) | wire_nlOl0Oi_o[10]) | wire_nlOl0Oi_o[9]) | wire_nlOl0Oi_o[8]) | wire_nlOl0Oi_o[7]),
		nlillll = ((((nlO00Ol & (~ nlO00Oi)) & (~ nlO00lO)) & nlO00ll) & nlO00li),
		nlilllO = (((~ rgenericfifo) & (wire_n10lOi_dataout & (~ wire_n110ll_dataout))) | nlilOlO),
		nlillOi = (((((~ nlOlilO) & (~ nlOlill)) & (~ nlOlili)) & (~ nlOliiO)) & (~ nlO0Oli)),
		nlillOl = ((~ rgenericfifo) & nliO01O),
		nlillOO = ((((nlOlilO & (~ nlOlill)) & (~ nlOlili)) & nlOliiO) & nlO0Oli),
		nlilO0i = (((~ rclkcmpsqmd) & (~ nliOiiO)) & (rtruebac2bac | ((~ rtruebac2bac) & (~ n1O0il)))),
		nlilO0l = (((((~ n1001i) & nlilO0O) & (~ nlilOii)) & nlilOil) & (~ nlilOiO)),
		nlilO0O = ((~ n1001i) & n101OO),
		nlilO1i = ((((((((((~ (rclkcmpsq1n[0] ^ nllO10O)) & (~ (rclkcmpsq1n[1] ^ nlllOiO))) & (~ (rclkcmpsq1n[2] ^ nlllOli))) & (~ (rclkcmpsq1n[3] ^ nlllOll))) & (~ (rclkcmpsq1n[4] ^ nlllOlO))) & (~ (rclkcmpsq1n[5] ^ nlllOOi))) & (~ (rclkcmpsq1n[6] ^ nlllOOl))) & (~ (rclkcmpsq1n[7] ^ nlllOOO))) & (~ (rclkcmpsq1n[8] ^ nllO11i))) & (~ (rclkcmpsq1n[9] ^ nllO11l))),
		nlilO1l = ((((((((((~ (rclkcmpsq1p[0] ^ nllO10O)) & (~ (rclkcmpsq1p[1] ^ nlllOiO))) & (~ (rclkcmpsq1p[2] ^ nlllOli))) & (~ (rclkcmpsq1p[3] ^ nlllOll))) & (~ (rclkcmpsq1p[4] ^ nlllOlO))) & (~ (rclkcmpsq1p[5] ^ nlllOOi))) & (~ (rclkcmpsq1p[6] ^ nlllOOl))) & (~ (rclkcmpsq1p[7] ^ nlllOOO))) & (~ (rclkcmpsq1p[8] ^ nllO11i))) & (~ (rclkcmpsq1p[9] ^ nllO11l))),
		nlilO1O = (rskpsetbased & n10O0l),
		nlilOii = ((~ n1001i) & (n101OO ^ n101Ol)),
		nlilOil = (n1001i ^ (n101Ol ^ nlill1O)),
		nlilOiO = (n1001i ^ (nlill1O ^ (n101Ol ^ n11OiO))),
		nlilOli = (((((((((wire_n1010O_o[18] | wire_n1010O_o[17]) | wire_n1010O_o[14]) | wire_n1010O_o[13]) | wire_n1010O_o[10]) | wire_n1010O_o[9]) | wire_n1010O_o[6]) | wire_n1010O_o[5]) | wire_n1010O_o[2]) | wire_n1010O_o[1]),
		nlilOll = ((((wire_n101ll_o[8] | wire_n101ll_o[7]) | wire_n101ll_o[6]) | wire_n101ll_o[5]) | wire_n101ll_o[4]),
		nlilOlO = (rgenericfifo & n100ii),
		nlilOOi = (((((~ n1ii0i) & (~ n1ii1O)) & n1ii1l) & n1ii1i) & n1i1li),
		nlilOOl = (n10O0l | n10O1O),
		nlilOOO = ((((((((~ n1l1ii) & (~ n1l10O)) & (~ n1l10l)) & (~ n1l10i)) & (~ n1l11O)) & (~ n1l11l)) & (~ n1l11i)) & (~ n1ii0l)),
		nliO00i = (nliO0ii & (rclkcmpsqmd & ((nll1OOO | n1l1il) & wire_n1illl_dataout))),
		nliO00l = ((((n1li1i | n1l0OO) | n1l0Ol) | n1l0Oi) | n1l0lO),
		nliO00O = (((~ rgenericfifo) & (~ wire_n1illl_dataout)) | (rgenericfifo & nlOlOOi)),
		nliO01i = (nliO0ii & ((~ rclkcmpsqmd) & (((~ rgenericfifo) & wire_n1illl_dataout) | (rgenericfifo & (~ nlOlOOi))))),
		nliO01l = (nliO0ii & nliO01O),
		nliO01O = (rclkcmpsqmd & wire_n1illl_dataout),
		nliO0ii = ((~ rskpsetbased) | (~ nliO0li)),
		nliO0il = ((~ rgenericfifo) & (~ wire_n01i0i_dataout)),
		nliO0iO = ((rskpsetbased | ((~ rskpsetbased) & (~ wire_n1illl_dataout))) & nliO0li),
		nliO0li = ((~ nliO1lO) & nliO1ii),
		nliO0ll = ((wire_n0000l_dataout & (~ (((~ n1O0lO) & (~ n1O0ll)) & (~ n1O0li)))) & wire_n11l0l_o),
		nliO0lO = (wire_n11l0l_o & nliO0Oi),
		nliO0Oi = (((~ wire_n0000l_dataout) & ((n10ili & ((~ rrx_pipe_enable) & nlilO0i)) & wire_n11lil_o)) & wire_n11l0l_o),
		nliO0Ol = (wire_n0000l_dataout & wire_n001lO_dataout),
		nliO0OO = ((((((((((~ (rclkcmpsq1p[0] ^ wire_n011li_dataout)) & (~ (rclkcmpsq1p[1] ^ wire_n011ll_dataout))) & (~ (rclkcmpsq1p[2] ^ wire_n011lO_dataout))) & (~ (rclkcmpsq1p[3] ^ wire_n011Oi_dataout))) & (~ (rclkcmpsq1p[4] ^ wire_n011Ol_dataout))) & (~ (rclkcmpsq1p[5] ^ wire_n011OO_dataout))) & (~ (rclkcmpsq1p[6] ^ wire_n0101i_dataout))) & (~ (rclkcmpsq1p[7] ^ wire_n0101l_dataout))) & (~ (rclkcmpsq1p[8] ^ wire_n0101O_dataout))) & (~ (rclkcmpsq1p[9] ^ wire_n0100i_dataout))),
		nliO10i = (wire_n1i0iO_dataout | n1i10O),
		nliO10l = (wire_n1i0lO_dataout | n1i1il),
		nliO10O = (wire_n1illl_dataout & nliO1ii),
		nliO11i = (nliO0li | n1i11i),
		nliO11l = ((((n1ii0i & (~ n1ii1O)) & (~ n1ii1l)) & n1ii1i) & n1i1li),
		nliO11O = (((((~ wire_n1il0O_dataout) & (~ wire_n1il0l_dataout)) & (~ wire_n1il0i_dataout)) & (~ wire_n1il1O_dataout)) & (~ wire_n1il1l_dataout)),
		nliO1ii = (nliO11O & nliO11l),
		nliO1il = ((~ nlOll1l) & nlOll1i),
		nliO1iO = ((~ nlOll1l) & (nlOll1i ^ nlOliOO)),
		nliO1li = (nlOll1l ^ (nlOliOO ^ nlill0i)),
		nliO1ll = (nlOll1l ^ (nlill0i ^ (nlOliOO ^ nlOliOi))),
		nliO1lO = (((wire_n1iOOO_o & (nliOi1O & nlOO1l)) & (~ (rskpsetbased & (~ rrx_pipe_enable)))) | (wire_n1iOOO_o & (((rskpsetbased & (rtruebac2bac & (n1OlOl | (n1OlOi | (n1OllO | n1Olll))))) | ((~ rrx_pipe_enable) & (rskpsetbased & ((~ rtruebac2bac) & n1OlOl)))) & nlOO1l))),
		nliO1Oi = ((~ rgenericfifo) & (~ wire_n010ll_dataout)),
		nliO1Ol = (rgenericfifo | wire_n010ll_dataout),
		nliO1OO = (((((~ n1li1i) & (~ n1l0OO)) & (~ n1l0Ol)) & (~ n1l0Oi)) & (~ n1l0lO)),
		nliOi0i = (dskwclksel[0] & nliOi0O),
		nliOi0l = ((~ dskwclksel[0]) & nliOi0O),
		nliOi0O = ((~ is_lane0) & nll010i),
		nliOi1i = ((((((((((~ (rclkcmpsq1n[0] ^ wire_n011li_dataout)) & (~ (rclkcmpsq1n[1] ^ wire_n011ll_dataout))) & (~ (rclkcmpsq1n[2] ^ wire_n011lO_dataout))) & (~ (rclkcmpsq1n[3] ^ wire_n011Oi_dataout))) & (~ (rclkcmpsq1n[4] ^ wire_n011Ol_dataout))) & (~ (rclkcmpsq1n[5] ^ wire_n011OO_dataout))) & (~ (rclkcmpsq1n[6] ^ wire_n0101i_dataout))) & (~ (rclkcmpsq1n[7] ^ wire_n0101l_dataout))) & (~ (rclkcmpsq1n[8] ^ wire_n0101O_dataout))) & (~ (rclkcmpsq1n[9] ^ wire_n0100i_dataout))),
		nliOi1l = (nll1OlO & ((~ rclkcmpsqmd) | n1Olil)),
		nliOi1O = ((~ wire_n010il_dataout) & ((~ wire_n010ii_dataout) & n1OlOO)),
		nliOiii = ((~ rmatchen) | rgenericfifo),
		nliOiil = (((wire_n0000l_dataout & (wire_n001lO_dataout & (rrx_pipe_enable & nliOili))) & (~ nliOiiO)) & n10ili),
		nliOiiO = (wire_n11O0i_o | (n1O0il & nlilO0l)),
		nliOili = (rmatchen | rgenericfifo),
		nliOill = ((((((((((~ (rclkcmpsq1p[0] ^ nllO01O)) & (~ (rclkcmpsq1p[1] ^ nllO00i))) & (~ (rclkcmpsq1p[2] ^ nllO00l))) & (~ (rclkcmpsq1p[3] ^ nllO00O))) & (~ (rclkcmpsq1p[4] ^ nllO0ii))) & (~ (rclkcmpsq1p[5] ^ nllO0il))) & (~ (rclkcmpsq1p[6] ^ nllO0iO))) & (~ (rclkcmpsq1p[7] ^ nllO0li))) & (~ (rclkcmpsq1p[8] ^ nllO0ll))) & (~ (rclkcmpsq1p[9] ^ nllO0lO))),
		nliOilO = ((((((((((~ (rclkcmpsq1n[0] ^ nllO01O)) & (~ (rclkcmpsq1n[1] ^ nllO00i))) & (~ (rclkcmpsq1n[2] ^ nllO00l))) & (~ (rclkcmpsq1n[3] ^ nllO00O))) & (~ (rclkcmpsq1n[4] ^ nllO0ii))) & (~ (rclkcmpsq1n[5] ^ nllO0il))) & (~ (rclkcmpsq1n[6] ^ nllO0iO))) & (~ (rclkcmpsq1n[7] ^ nllO0li))) & (~ (rclkcmpsq1n[8] ^ nllO0ll))) & (~ (rclkcmpsq1n[9] ^ nllO0lO))),
		nliOiOi = ((((((((((~ (rclkcmpsq1n[0] ^ nllO10l)) & (~ (rclkcmpsq1n[1] ^ nllO1ii))) & (~ (rclkcmpsq1n[2] ^ nllO1il))) & (~ (rclkcmpsq1n[3] ^ nllO1iO))) & (~ (rclkcmpsq1n[4] ^ nllO1li))) & (~ (rclkcmpsq1n[5] ^ nllO1ll))) & (~ (rclkcmpsq1n[6] ^ nllO1lO))) & (~ (rclkcmpsq1n[7] ^ nllO1Oi))) & (~ (rclkcmpsq1n[8] ^ nllO1Ol))) & (~ (rclkcmpsq1n[9] ^ nllO1OO))),
		nliOiOl = ((((((((((~ (rclkcmpsq1p[0] ^ nllO10l)) & (~ (rclkcmpsq1p[1] ^ nllO1ii))) & (~ (rclkcmpsq1p[2] ^ nllO1il))) & (~ (rclkcmpsq1p[3] ^ nllO1iO))) & (~ (rclkcmpsq1p[4] ^ nllO1li))) & (~ (rclkcmpsq1p[5] ^ nllO1ll))) & (~ (rclkcmpsq1p[6] ^ nllO1lO))) & (~ (rclkcmpsq1p[7] ^ nllO1Oi))) & (~ (rclkcmpsq1p[8] ^ nllO1Ol))) & (~ (rclkcmpsq1p[9] ^ nllO1OO))),
		nliOiOO = ((((((((((~ (wire_n000iO_o ^ nllO01O)) & (~ (wire_n000li_o ^ nllO00i))) & (~ (wire_n000ll_o ^ nllO00l))) & (~ (wire_n000lO_o ^ nllO00O))) & (~ (wire_n000Oi_o ^ nllO0ii))) & (~ (wire_n000Ol_o ^ nllO0il))) & (~ (wire_n000OO_o ^ nllO0iO))) & (~ (wire_n00i1i_o ^ nllO0li))) & (~ (wire_n00i1l_o ^ nllO0ll))) & (~ (wire_n00i1O_o ^ nllO0lO))),
		nliOl0i = ((((((((((~ (wire_n000iO_o ^ wire_n011li_dataout)) & (~ (wire_n000li_o ^ wire_n011ll_dataout))) & (~ (wire_n000ll_o ^ wire_n011lO_dataout))) & (~ (wire_n000lO_o ^ wire_n011Oi_dataout))) & (~ (wire_n000Oi_o ^ wire_n011Ol_dataout))) & (~ (wire_n000Ol_o ^ wire_n011OO_dataout))) & (~ (wire_n000OO_o ^ wire_n0101i_dataout))) & (~ (wire_n00i1i_o ^ wire_n0101l_dataout))) & (~ (wire_n00i1l_o ^ wire_n0101O_dataout))) & (~ (wire_n00i1O_o ^ wire_n0100i_dataout))),
		nliOl0l = ((((((((((~ (wire_n00i0i_dataout ^ wire_n011li_dataout)) & (~ (wire_n00i0l_dataout ^ wire_n011ll_dataout))) & (~ (wire_n00i0O_dataout ^ wire_n011lO_dataout))) & (~ (wire_n00iii_dataout ^ wire_n011Oi_dataout))) & (~ (wire_n00iil_dataout ^ wire_n011Ol_dataout))) & (~ (wire_n00iiO_dataout ^ wire_n011OO_dataout))) & (~ (wire_n00ili_dataout ^ wire_n0101i_dataout))) & (~ (wire_n00ill_dataout ^ wire_n0101l_dataout))) & (~ (wire_n00ilO_dataout ^ wire_n0101O_dataout))) & (~ (wire_n00iOi_dataout ^ wire_n0100i_dataout))),
		nliOl0O = (rskpsetbased | rclkcmpsqmd),
		nliOl1i = ((((((((((~ (wire_n00i0i_dataout ^ nllO01O)) & (~ (wire_n00i0l_dataout ^ nllO00i))) & (~ (wire_n00i0O_dataout ^ nllO00l))) & (~ (wire_n00iii_dataout ^ nllO00O))) & (~ (wire_n00iil_dataout ^ nllO0ii))) & (~ (wire_n00iiO_dataout ^ nllO0il))) & (~ (wire_n00ili_dataout ^ nllO0iO))) & (~ (wire_n00ill_dataout ^ nllO0li))) & (~ (wire_n00ilO_dataout ^ nllO0ll))) & (~ (wire_n00iOi_dataout ^ nllO0lO))),
		nliOl1l = ((((((((((~ (wire_n000iO_o ^ nllO10l)) & (~ (wire_n000li_o ^ nllO1ii))) & (~ (wire_n000ll_o ^ nllO1il))) & (~ (wire_n000lO_o ^ nllO1iO))) & (~ (wire_n000Oi_o ^ nllO1li))) & (~ (wire_n000Ol_o ^ nllO1ll))) & (~ (wire_n000OO_o ^ nllO1lO))) & (~ (wire_n00i1i_o ^ nllO1Oi))) & (~ (wire_n00i1l_o ^ nllO1Ol))) & (~ (wire_n00i1O_o ^ nllO1OO))),
		nliOl1O = ((((((((((~ (wire_n00i0i_dataout ^ nllO10l)) & (~ (wire_n00i0l_dataout ^ nllO1ii))) & (~ (wire_n00i0O_dataout ^ nllO1il))) & (~ (wire_n00iii_dataout ^ nllO1iO))) & (~ (wire_n00iil_dataout ^ nllO1li))) & (~ (wire_n00iiO_dataout ^ nllO1ll))) & (~ (wire_n00ili_dataout ^ nllO1lO))) & (~ (wire_n00ill_dataout ^ nllO1Oi))) & (~ (wire_n00ilO_dataout ^ nllO1Ol))) & (~ (wire_n00iOi_dataout ^ nllO1OO))),
		nliOlii = (nl1Oll ^ nl1OiO),
		nliOlil = (niO01O ^ niO01i),
		nliOlll = (rgenericfifo & (~ nl011O)),
		nliOllO = (nl011O | ((~ rgenericfifo) & (~ nll10iO))),
		nliOlOi = ((((wire_nilOil_o[8] | wire_nilOil_o[6]) | wire_nilOil_o[4]) | wire_nilOil_o[2]) | wire_nilOil_o[0]),
		nliOlOl = (((((((wire_nilOOl_o[10] | wire_nilOOl_o[9]) | wire_nilOOl_o[8]) | wire_nilOOl_o[7]) | wire_nilOOl_o[6]) | wire_nilOOl_o[5]) | wire_nilOOl_o[4]) | wire_nilOOl_o[3]),
		nliOlOO = (((((((((wire_nilOOl_o[16] | wire_nilOOl_o[15]) | wire_nilOOl_o[14]) | wire_nilOOl_o[13]) | wire_nilOOl_o[12]) | wire_nilOOl_o[11]) | wire_nilOOl_o[10]) | wire_nilOOl_o[9]) | wire_nilOOl_o[8]) | wire_nilOOl_o[7]),
		nliOO0i = (((((~ nl1OlO) & nliOO0l) & (~ nliOO0O)) & nliOOii) & (~ nliOOil)),
		nliOO0l = ((~ nl1OlO) & nl1Oll),
		nliOO0O = ((~ nl1OlO) & (nl1Oll ^ nl1Oli)),
		nliOO1i = ((((ni0OOl & (~ ni0OOi)) & (~ ni0OlO)) & ni0Oll) & ni0Oli),
		nliOO1l = (((~ rgenericfifo) & (nl000O & (~ nll10iO))) | nliOOll),
		nliOO1O = ((((niO1Ol & (~ niO1Oi)) & (~ niO1lO)) & niO1ll) & niiill),
		nliOOii = (nl1OlO ^ (nl1Oli ^ nliOlii)),
		nliOOil = (nl1OlO ^ (nliOlii ^ (nl1Oli ^ nl1l0l))),
		nliOOiO = (((((((((wire_nl1O1l_o[18] | wire_nl1O1l_o[17]) | wire_nl1O1l_o[14]) | wire_nl1O1l_o[13]) | wire_nl1O1l_o[10]) | wire_nl1O1l_o[9]) | wire_nl1O1l_o[6]) | wire_nl1O1l_o[5]) | wire_nl1O1l_o[2]) | wire_nl1O1l_o[1]),
		nliOOli = ((((wire_nl1Oii_o[8] | wire_nl1Oii_o[7]) | wire_nl1Oii_o[6]) | wire_nl1Oii_o[5]) | wire_nl1Oii_o[4]),
		nliOOll = (rgenericfifo & nl011O),
		nliOOlO = (((((~ nli1iO) & (~ nli1il)) & nli1ii) & nli10O) & nl0lOO),
		nliOOOi = (nl0ill | nl0iiO),
		nliOOOl = ((~ rgenericfifo) & (~ wire_nlliiO_dataout)),
		nliOOOO = (nll100l | nl0l0l),
		nll000O = 1'b1,
		nll001i = (((((~ n1ii0i) & n1ii1O) & n1ii1l) & (~ n1ii1i)) & n1i1li),
		nll001l = 1'b0,
		nll00iO = ((wire_n0O_dataout | soft_reset) | (~ (nll001O6 ^ nll001O5))),
		nll010i = (dskwclksel[1] & rmatchen),
		nll011i = ((nll101l & (~ nll100l)) & nll101i),
		nll01iO = (((((~ nli1iO) & nli1il) & (~ nli1ii)) & nli10O) & nl0lOO),
		nll01lO = (((((~ nli1iO) & nli1il) & nli1ii) & (~ nli10O)) & (~ nl0lOO)),
		nll01Oi = (((((~ nli1iO) & nli1il) & nli1ii) & (~ nli10O)) & nl0lOO),
		nll01Ol = (((((~ n1ii0i) & n1ii1O) & (~ n1ii1l)) & n1ii1i) & n1i1li),
		nll01OO = (((((~ n1ii0i) & n1ii1O) & n1ii1l) & (~ n1ii1i)) & (~ n1i1li)),
		nll100i = ((~ rgenericfifo) & (~ wire_nllili_dataout)),
		nll100l = ((~ nll11lO) & nll11ii),
		nll100O = ((((((((((~ (rclkcmpsq1n[0] ^ wire_nlOili_data_out2[0])) & (~ (rclkcmpsq1n[1] ^ wire_nlOili_data_out2[1]))) & (~ (rclkcmpsq1n[2] ^ wire_nlOili_data_out2[2]))) & (~ (rclkcmpsq1n[3] ^ wire_nlOili_data_out2[3]))) & (~ (rclkcmpsq1n[4] ^ wire_nlOili_data_out2[4]))) & (~ (rclkcmpsq1n[5] ^ wire_nlOili_data_out2[5]))) & (~ (rclkcmpsq1n[6] ^ wire_nlOili_data_out2[6]))) & (~ (rclkcmpsq1n[7] ^ wire_nlOili_data_out2[7]))) & (~ (rclkcmpsq1n[8] ^ wire_nlOili_data_out2[8]))) & (~ (rclkcmpsq1n[9] ^ wire_nlOili_data_out2[9]))),
		nll101i = ((((nliilO | nliill) | nliili) | nliiiO) | nli1li),
		nll101l = (((~ rgenericfifo) & (~ nll101O)) | (rgenericfifo & niOiOO)),
		nll101O = (nll11lO | nll100l),
		nll10ii = ((((((((((~ (rclkcmpsq1p[0] ^ wire_nlOili_data_out2[0])) & (~ (rclkcmpsq1p[1] ^ wire_nlOili_data_out2[1]))) & (~ (rclkcmpsq1p[2] ^ wire_nlOili_data_out2[2]))) & (~ (rclkcmpsq1p[3] ^ wire_nlOili_data_out2[3]))) & (~ (rclkcmpsq1p[4] ^ wire_nlOili_data_out2[4]))) & (~ (rclkcmpsq1p[5] ^ wire_nlOili_data_out2[5]))) & (~ (rclkcmpsq1p[6] ^ wire_nlOili_data_out2[6]))) & (~ (rclkcmpsq1p[7] ^ wire_nlOili_data_out2[7]))) & (~ (rclkcmpsq1p[8] ^ wire_nlOili_data_out2[8]))) & (~ (rclkcmpsq1p[9] ^ wire_nlOili_data_out2[9]))),
		nll10iO = (nl0ill | (nll10l & (nl000i & (~ nll1i1i)))),
		nll10li = ((((((((((~ (rclkcmpsq1n[10] ^ wire_nlOiiO_data_out2[0])) & (~ (rclkcmpsq1n[11] ^ wire_nlOiiO_data_out2[1]))) & (~ (rclkcmpsq1n[12] ^ wire_nlOiiO_data_out2[2]))) & (~ (rclkcmpsq1n[13] ^ wire_nlOiiO_data_out2[3]))) & (~ (rclkcmpsq1n[14] ^ wire_nlOiiO_data_out2[4]))) & (~ (rclkcmpsq1n[15] ^ wire_nlOiiO_data_out2[5]))) & (~ (rclkcmpsq1n[16] ^ wire_nlOiiO_data_out2[6]))) & (~ (rclkcmpsq1n[17] ^ wire_nlOiiO_data_out2[7]))) & (~ (rclkcmpsq1n[18] ^ wire_nlOiiO_data_out2[8]))) & (~ (rclkcmpsq1n[19] ^ wire_nlOiiO_data_out2[9]))),
		nll10ll = ((((((((((~ (rclkcmpsq1p[10] ^ wire_nlOiiO_data_out2[0])) & (~ (rclkcmpsq1p[11] ^ wire_nlOiiO_data_out2[1]))) & (~ (rclkcmpsq1p[12] ^ wire_nlOiiO_data_out2[2]))) & (~ (rclkcmpsq1p[13] ^ wire_nlOiiO_data_out2[3]))) & (~ (rclkcmpsq1p[14] ^ wire_nlOiiO_data_out2[4]))) & (~ (rclkcmpsq1p[15] ^ wire_nlOiiO_data_out2[5]))) & (~ (rclkcmpsq1p[16] ^ wire_nlOiiO_data_out2[6]))) & (~ (rclkcmpsq1p[17] ^ wire_nlOiiO_data_out2[7]))) & (~ (rclkcmpsq1p[18] ^ wire_nlOiiO_data_out2[8]))) & (~ (rclkcmpsq1p[19] ^ wire_nlOiiO_data_out2[9]))),
		nll10lO = ((((((((((~ (rclkcmpsq1n[0] ^ n0Ol0i)) & (~ (rclkcmpsq1n[1] ^ n0OiiO))) & (~ (rclkcmpsq1n[2] ^ n0Oili))) & (~ (rclkcmpsq1n[3] ^ n0Oill))) & (~ (rclkcmpsq1n[4] ^ n0OilO))) & (~ (rclkcmpsq1n[5] ^ n0OiOi))) & (~ (rclkcmpsq1n[6] ^ n0OiOl))) & (~ (rclkcmpsq1n[7] ^ n0OiOO))) & (~ (rclkcmpsq1n[8] ^ n0Ol1i))) & (~ (rclkcmpsq1n[9] ^ n0Ol1l))),
		nll10Oi = ((((((((((~ (rclkcmpsq1p[0] ^ n0Ol0i)) & (~ (rclkcmpsq1p[1] ^ n0OiiO))) & (~ (rclkcmpsq1p[2] ^ n0Oili))) & (~ (rclkcmpsq1p[3] ^ n0Oill))) & (~ (rclkcmpsq1p[4] ^ n0OilO))) & (~ (rclkcmpsq1p[5] ^ n0OiOi))) & (~ (rclkcmpsq1p[6] ^ n0OiOl))) & (~ (rclkcmpsq1p[7] ^ n0OiOO))) & (~ (rclkcmpsq1p[8] ^ n0Ol1i))) & (~ (rclkcmpsq1p[9] ^ n0Ol1l))),
		nll10Ol = ((((((((((~ (rclkcmpsq1n[10] ^ n0Ol1O)) & (~ (rclkcmpsq1n[11] ^ n0Ol0l))) & (~ (rclkcmpsq1n[12] ^ n0Ol0O))) & (~ (rclkcmpsq1n[13] ^ n0Olii))) & (~ (rclkcmpsq1n[14] ^ n0Olil))) & (~ (rclkcmpsq1n[15] ^ n0OliO))) & (~ (rclkcmpsq1n[16] ^ n0Olli))) & (~ (rclkcmpsq1n[17] ^ n0Olll))) & (~ (rclkcmpsq1n[18] ^ n0OllO))) & (~ (rclkcmpsq1n[19] ^ n0OlOi))),
		nll10OO = ((((((((((~ (rclkcmpsq1p[10] ^ n0Ol1O)) & (~ (rclkcmpsq1p[11] ^ n0Ol0l))) & (~ (rclkcmpsq1p[12] ^ n0Ol0O))) & (~ (rclkcmpsq1p[13] ^ n0Olii))) & (~ (rclkcmpsq1p[14] ^ n0Olil))) & (~ (rclkcmpsq1p[15] ^ n0OliO))) & (~ (rclkcmpsq1p[16] ^ n0Olli))) & (~ (rclkcmpsq1p[17] ^ n0Olll))) & (~ (rclkcmpsq1p[18] ^ n0OllO))) & (~ (rclkcmpsq1p[19] ^ n0OlOi))),
		nll110i = (wire_nl0OOl_dataout | nl0lli),
		nll110l = (wire_nli11l_dataout | nl0lOi),
		nll110O = (nll101O & nll11ii),
		nll111i = ((((nli1iO & (~ nli1il)) & (~ nli1ii)) & nli10O) & nl0lOO),
		nll111l = (((((~ wire_nli0ll_dataout) & (~ wire_nli0li_dataout)) & (~ wire_nli0iO_dataout)) & (~ wire_nli0il_dataout)) & (~ wire_nli0ii_dataout)),
		nll11ii = (nll111l & nll111i),
		nll11il = ((~ niO00i) & niO01O),
		nll11iO = ((~ niO00i) & (niO01O ^ niO01l)),
		nll11li = (niO00i ^ (niO01l ^ nliOlil)),
		nll11ll = (niO00i ^ (nliOlil ^ (niO01l ^ niO1OO))),
		nll11lO = (wire_nlii0l_o & ((nll00i | nll1OO) & nlOO1l)),
		nll11Oi = (rgenericfifo | wire_nlliiO_dataout),
		nll11Ol = (((((~ nliilO) & (~ nliill)) & (~ nliili)) & (~ nliiiO)) & (~ nli1li)),
		nll11OO = ((((~ rgenericfifo) & nll101O) | (rgenericfifo & (~ niOiOO))) & (~ nll100l)),
		nll1i0i = ((((((((((~ (sudi[0] ^ rclkcmpsq1n[0])) & (~ (sudi[1] ^ rclkcmpsq1n[1]))) & (~ (sudi[2] ^ rclkcmpsq1n[2]))) & (~ (sudi[3] ^ rclkcmpsq1n[3]))) & (~ (sudi[4] ^ rclkcmpsq1n[4]))) & (~ (sudi[5] ^ rclkcmpsq1n[5]))) & (~ (sudi[6] ^ rclkcmpsq1n[6]))) & (~ (sudi[7] ^ rclkcmpsq1n[7]))) & (~ (sudi[8] ^ rclkcmpsq1n[8]))) & (~ (sudi[9] ^ rclkcmpsq1n[9]))),
		nll1i0l = ((((((((((~ (sudi[0] ^ rclkcmpsq1p[0])) & (~ (sudi[1] ^ rclkcmpsq1p[1]))) & (~ (sudi[2] ^ rclkcmpsq1p[2]))) & (~ (sudi[3] ^ rclkcmpsq1p[3]))) & (~ (sudi[4] ^ rclkcmpsq1p[4]))) & (~ (sudi[5] ^ rclkcmpsq1p[5]))) & (~ (sudi[6] ^ rclkcmpsq1p[6]))) & (~ (sudi[7] ^ rclkcmpsq1p[7]))) & (~ (sudi[8] ^ rclkcmpsq1p[8]))) & (~ (sudi[9] ^ rclkcmpsq1p[9]))),
		nll1i1i = (wire_nl1iOO_o | (nll11l & nliOO0i)),
		nll1iil = ((((((((((~ (sudi[14] ^ rclkcmpsq1n[0])) & (~ (sudi[15] ^ rclkcmpsq1n[1]))) & (~ (sudi[16] ^ rclkcmpsq1n[2]))) & (~ (sudi[17] ^ rclkcmpsq1n[3]))) & (~ (sudi[18] ^ rclkcmpsq1n[4]))) & (~ (sudi[19] ^ rclkcmpsq1n[5]))) & (~ (sudi[20] ^ rclkcmpsq1n[6]))) & (~ (sudi[21] ^ rclkcmpsq1n[7]))) & (~ (sudi[22] ^ rclkcmpsq1n[8]))) & (~ (sudi[23] ^ rclkcmpsq1n[9]))),
		nll1iiO = ((((((((((~ (sudi[14] ^ rclkcmpsq1p[0])) & (~ (sudi[15] ^ rclkcmpsq1p[1]))) & (~ (sudi[16] ^ rclkcmpsq1p[2]))) & (~ (sudi[17] ^ rclkcmpsq1p[3]))) & (~ (sudi[18] ^ rclkcmpsq1p[4]))) & (~ (sudi[19] ^ rclkcmpsq1p[5]))) & (~ (sudi[20] ^ rclkcmpsq1p[6]))) & (~ (sudi[21] ^ rclkcmpsq1p[7]))) & (~ (sudi[22] ^ rclkcmpsq1p[8]))) & (~ (sudi[23] ^ rclkcmpsq1p[9]))),
		nll1l0i = (rmatchen | rgenericfifo),
		nll1l0l = (nll1lii | nll1l0O),
		nll1l0O = ((((((((((~ (sudi[14] ^ rclkcmpsq1n[10])) & (~ (sudi[15] ^ rclkcmpsq1n[11]))) & (~ (sudi[16] ^ rclkcmpsq1n[12]))) & (~ (sudi[17] ^ rclkcmpsq1n[13]))) & (~ (sudi[18] ^ rclkcmpsq1n[14]))) & (~ (sudi[19] ^ rclkcmpsq1n[15]))) & (~ (sudi[20] ^ rclkcmpsq1n[16]))) & (~ (sudi[21] ^ rclkcmpsq1n[17]))) & (~ (sudi[22] ^ rclkcmpsq1n[18]))) & (~ (sudi[23] ^ rclkcmpsq1n[19]))),
		nll1l1i = (((~ rmatchen) | rgenericfifo) | (~ (nll1l1l36 ^ nll1l1l35))),
		nll1lii = ((((((((((~ (sudi[14] ^ rclkcmpsq1p[10])) & (~ (sudi[15] ^ rclkcmpsq1p[11]))) & (~ (sudi[16] ^ rclkcmpsq1p[12]))) & (~ (sudi[17] ^ rclkcmpsq1p[13]))) & (~ (sudi[18] ^ rclkcmpsq1p[14]))) & (~ (sudi[19] ^ rclkcmpsq1p[15]))) & (~ (sudi[20] ^ rclkcmpsq1p[16]))) & (~ (sudi[21] ^ rclkcmpsq1p[17]))) & (~ (sudi[22] ^ rclkcmpsq1p[18]))) & (~ (sudi[23] ^ rclkcmpsq1p[19]))),
		nll1lil = ((nll1llO | nll1lll) | (~ (nll1liO34 ^ nll1liO33))),
		nll1lll = ((((((((((~ (sudi[0] ^ rclkcmpsq1n[10])) & (~ (sudi[1] ^ rclkcmpsq1n[11]))) & (~ (sudi[2] ^ rclkcmpsq1n[12]))) & (~ (sudi[3] ^ rclkcmpsq1n[13]))) & (~ (sudi[4] ^ rclkcmpsq1n[14]))) & (~ (sudi[5] ^ rclkcmpsq1n[15]))) & (~ (sudi[6] ^ rclkcmpsq1n[16]))) & (~ (sudi[7] ^ rclkcmpsq1n[17]))) & (~ (sudi[8] ^ rclkcmpsq1n[18]))) & (~ (sudi[9] ^ rclkcmpsq1n[19]))),
		nll1llO = ((((((((((~ (sudi[0] ^ rclkcmpsq1p[10])) & (~ (sudi[1] ^ rclkcmpsq1p[11]))) & (~ (sudi[2] ^ rclkcmpsq1p[12]))) & (~ (sudi[3] ^ rclkcmpsq1p[13]))) & (~ (sudi[4] ^ rclkcmpsq1p[14]))) & (~ (sudi[5] ^ rclkcmpsq1p[15]))) & (~ (sudi[6] ^ rclkcmpsq1p[16]))) & (~ (sudi[7] ^ rclkcmpsq1p[17]))) & (~ (sudi[8] ^ rclkcmpsq1p[18]))) & (~ (sudi[9] ^ rclkcmpsq1p[19]))),
		nll1O0i = ((rskpsetbased & nliO0li) | nliO1lO),
		nll1O0l = ((wire_n0000l_dataout & (n10ili & ((~ rskpsetbased) & nlilO0i))) | ((n1O0iO | ((n10ili & ((rclkcmpsqmd & (~ nliOiiO)) & (rtruebac2bac | ((~ rtruebac2bac) & (~ n1O00O))))) & ((nliOl1O & nlilO1l) | (nliOl1l & nlilO1i)))) | (nliO0Oi | ((n1O0Oi & (n1O1Oi & (n10ili & (rrx_pipe_enable & ((~ rclkcmpsqmd) & ((~ rtruebac2bac) & (~ nliOiiO))))))) | nlilO1O)))),
		nll1O1l = (wire_n0il_dataout | wire_n0ii_dataout),
		nll1OlO = (nliOl0l | nliOl0i),
		nll1OOO = ((((~ rrx_pipe_enable) & nliO0ii) & nliO00O) & nliO00l),
		rdfifo_almost_empty = wire_nll_dataout,
		rdfifo_almost_full = wire_ni_dataout,
		rdfifo_empty = wire_nli_dataout,
		rdfifo_full = wire_nlO_dataout,
		rev_loop_data = {wire_nl11i_dataout, wire_niOOO_dataout, wire_niOOl_dataout, wire_niOOi_dataout, wire_niOlO_dataout, wire_niOll_dataout, wire_niOli_dataout, wire_niOiO_dataout, wire_niOil_dataout, wire_niOii_dataout, wire_niO0O_dataout, wire_niO0l_dataout, wire_niO0i_dataout, wire_niO1O_dataout, wire_niO1l_dataout, wire_niO1i_dataout, wire_nilOO_dataout, wire_nilOl_dataout, wire_nilOi_dataout, wire_nillO_dataout};
endmodule //stratixiigx_hssi_rx_comp_chnl_top
//synopsys translate_on
//VALID FILE

`timescale 1 ps / 1 ps
module stratixiigx_hssi_rx_byte_des (
    soft_reset,
    clk_2,
    rx_we_out,
    rdwidth,
    rx_wr_clk,
    soft_reset_wclk1,
    bo_en,
    bo_3g_en,
	rx_data_int,
    sync_resync_d,
    disp_err_d,
    pattern_det_d,
    ovr_undflow_d,
    disp_val_d,

    byte_des_fifo_data_in,
    byte_des_bo_3g_start
);

input           soft_reset;
input           clk_2;
input           rx_we_out;
input           rdwidth;
input           rx_wr_clk;
input           soft_reset_wclk1;

input           bo_en;
input           bo_3g_en;
	
input    [19:0] rx_data_int;
input    [1:0]  sync_resync_d;
input    [1:0]  disp_err_d;
input    [1:0]  pattern_det_d;
input    [3:0]  ovr_undflow_d;
input    [1:0]  disp_val_d;

output [63:0] byte_des_fifo_data_in;
output [1:0]  byte_des_bo_3g_start;

reg    [63:0] fifo_data_in;
reg    [1:0]  bo_3g_start;

reg    [31:0] data_lt_0_sync;
reg    [31:0] data_lt_0;
reg    [31:0] data_lt_1;

reg           bo_3g_en_lt_0_sync;
reg           bo_3g_en_lt_0;
reg           bo_3g_en_lt_1;

assign byte_des_fifo_data_in = fifo_data_in;
assign byte_des_bo_3g_start  = bo_3g_start;

always @(posedge soft_reset or posedge clk_2)
begin
   if (soft_reset)
      begin
         data_lt_1            <= 32'h00000000;
         data_lt_0            <= 32'h00000000;
         data_lt_0_sync       <= 32'h00000000;
         bo_3g_en_lt_1        <= 1'b0;
         bo_3g_en_lt_0        <= 1'b0;
         bo_3g_en_lt_0_sync   <= 1'b0;
      end
   else
      begin
         if (rdwidth && !rx_we_out)
            begin
               data_lt_1[7:0]  <= #1  rx_data_int[7:0];
               data_lt_1[8]    <= #1  rx_data_int[8];
               data_lt_1[9]    <= #1  rx_data_int[9];
               data_lt_1[10]   <= #1  sync_resync_d[0];
               data_lt_1[11]   <= #1  disp_err_d[0];
               data_lt_1[12]   <= #1  pattern_det_d[0];
               data_lt_1[13]   <= #1  ovr_undflow_d[0];
               data_lt_1[14]   <= #1  ovr_undflow_d[1];
               data_lt_1[15]   <= #1  disp_val_d[0];
               data_lt_1[23:16]<= #1  rx_data_int[17:10];
               data_lt_1[24]   <= #1  rx_data_int[18];
               data_lt_1[25]   <= #1  rx_data_int[19];
               data_lt_1[26]   <= #1  sync_resync_d[1];
               data_lt_1[27]   <= #1  disp_err_d[1];
               data_lt_1[28]   <= #1  pattern_det_d[1];
               data_lt_1[29]   <= #1  ovr_undflow_d[2];
               data_lt_1[30]   <= #1  ovr_undflow_d[3];
               data_lt_1[31]   <= #1  disp_val_d[1];
               bo_3g_en_lt_1   <= #1  bo_en | bo_3g_en;
            end

         if (rdwidth & rx_we_out)
            begin
               data_lt_0[7:0]  <= #1  rx_data_int[7:0];
               data_lt_0[8]    <= #1  rx_data_int[8];
               data_lt_0[9]    <= #1  rx_data_int[9];
               data_lt_0[10]   <= #1  sync_resync_d[0];
               data_lt_0[11]   <= #1  disp_err_d[0];
               data_lt_0[12]   <= #1  pattern_det_d[0];
               data_lt_0[13]   <= #1  ovr_undflow_d[0];
               data_lt_0[14]   <= #1  ovr_undflow_d[1];
               data_lt_0[15]   <= #1  disp_val_d[0];
               data_lt_0[23:16]<= #1  rx_data_int[17:10];
               data_lt_0[24]   <= #1  rx_data_int[18];
               data_lt_0[25]   <= #1  rx_data_int[19];
               data_lt_0[26]   <= #1  sync_resync_d[1];
               data_lt_0[27]   <= #1  disp_err_d[1];
               data_lt_0[28]   <= #1  pattern_det_d[1];
               data_lt_0[29]   <= #1  ovr_undflow_d[2];
               data_lt_0[30]   <= #1  ovr_undflow_d[3];
               data_lt_0[31]   <= #1  disp_val_d[1];
               bo_3g_en_lt_0   <= #1  bo_en | bo_3g_en;
            end

         if (!rdwidth)
            begin
               data_lt_0_sync[7:0]  <=  rx_data_int[7:0];
               data_lt_0_sync[8]    <=  rx_data_int[8];
               data_lt_0_sync[9]    <=  rx_data_int[9];
               data_lt_0_sync[10]   <=  sync_resync_d[0];
               data_lt_0_sync[11]   <=  disp_err_d[0];
               data_lt_0_sync[12]   <=  pattern_det_d[0];
               data_lt_0_sync[13]   <=  ovr_undflow_d[0];
               data_lt_0_sync[14]   <=  ovr_undflow_d[1];
               data_lt_0_sync[15]   <=  disp_val_d[0];
               data_lt_0_sync[23:16]<=  rx_data_int[17:10];
               data_lt_0_sync[24]   <=  rx_data_int[18];
               data_lt_0_sync[25]   <=  rx_data_int[19];
               data_lt_0_sync[26]   <=  sync_resync_d[1];
               data_lt_0_sync[27]   <=  disp_err_d[1];
               data_lt_0_sync[28]   <=  pattern_det_d[1];
               data_lt_0_sync[29]   <=  ovr_undflow_d[2];
               data_lt_0_sync[30]   <=  ovr_undflow_d[3];
               data_lt_0_sync[31]   <=  disp_val_d[1];
               bo_3g_en_lt_0_sync   <=  bo_en | bo_3g_en;
            end
         else 
            begin
               data_lt_0_sync     <= #1 data_lt_0;
               bo_3g_en_lt_0_sync <= #1 bo_3g_en_lt_0;
            end

      end
end

// write enable, fifo data in
always @(posedge rx_wr_clk or posedge soft_reset_wclk1)
begin
	if (soft_reset_wclk1)
	begin
		fifo_data_in <= 64'h0000000000000000;
		bo_3g_start <= 2'h0;
	end
	else
	begin
		// add one unit delay to help VCS to order the sampling 
		// sequence between clk_2 and rx_wr_clk
		fifo_data_in <= #1 {data_lt_1, data_lt_0_sync};	
		bo_3g_start  <= #1 {bo_3g_en_lt_1, bo_3g_en_lt_0_sync};	
	end
end

endmodule
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 364 mux21 1224 oper_decoder 7 oper_mux 200 oper_selector 2 stratixiigx_hssi_ram8x65_syn 1 stratixiigx_hssi_rx_byte_des 1 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_rx_ctrl
	( 
	bytord_valid_out,
	bytordplden,
	clk_2,
	dec_data_valid,
	dec_data_valid_pre,
	disp_err_delay,
	disp_val_delay,
	endec_rx,
	indv_rx,
	invalid_code_delay,
	ovr_undflow,
	ph_fifo_empty,
	ph_fifo_full,
	pld_re,
	pld_wr_dis,
	rautoinsdis,
	rbytord_2sym_en,
	rbytorden,
	rbytordpadval,
	rbytordpat,
	rbytordplden,
	rclkcmpinsertpad,
	rd_enable2,
	rd_enable_ch0,
	rd_enable_out,
	rd_enable_q0_ch0,
	rdwidth,
	rendec_data_sel_rx,
	rinvalid_code_err_only,
	rphfifo_master_sel_rx,
	rpmadatawidth,
	rptr_bin,
	rrxfifo_dis,
	rrxfifo_lowlatency_en,
	rrxfifo_urst_en,
	rrxphfifopldctl_en,
	rsync_comp_pat,
	rsync_comp_porn,
	rsync_comp_size,
	rsync_sm_dis,
	running_disp,
	rwa_6g_en,
	rx_control_dt,
	rx_control_rs,
	rx_data_dt,
	rx_data_rs,
	rx_rd_clk,
	rx_we_in_ch0,
	rx_we_in_q0_ch0,
	rx_we_out,
	rx_wr_clk,
	rxc,
	rxd,
	rxd_19,
	rxd_9,
	rxd_lpbk,
	rxfifo_urst,
	scan_mode,
	signal_detect_out,
	signal_detect_sync_st,
	soft_reset,
	soft_reset_rclk1,
	sync_resync_delay,
	sync_resync_pre,
	tenb_data,
	wptr_bin,
	wr_enable2,
	wr_enable_ch0,
	wr_enable_out,
	wr_enable_q0_ch0) /* synthesis synthesis_clearbox=1 */;
	output   bytord_valid_out;
	input   bytordplden;
	input   clk_2;
	input   [1:0]  dec_data_valid;
	input   [1:0]  dec_data_valid_pre;
	input   [1:0]  disp_err_delay;
	input   [1:0]  disp_val_delay;
	input   endec_rx;
	input   indv_rx;
	input   [1:0]  invalid_code_delay;
	input   [3:0]  ovr_undflow;
	output   ph_fifo_empty;
	output   ph_fifo_full;
	input   pld_re;
	input   pld_wr_dis;
	input   rautoinsdis;
	input   rbytord_2sym_en;
	input   [1:0]  rbytorden;
	input   [9:0]  rbytordpadval;
	input   [9:0]  rbytordpat;
	input   rbytordplden;
	input   rclkcmpinsertpad;
	output   rd_enable2;
	input   rd_enable_ch0;
	output   rd_enable_out;
	input   rd_enable_q0_ch0;
	input   rdwidth;
	input   rendec_data_sel_rx;
	input   rinvalid_code_err_only;
	input   rphfifo_master_sel_rx;
	input   rpmadatawidth;
	output   [2:0]  rptr_bin;
	input   rrxfifo_dis;
	input   rrxfifo_lowlatency_en;
	input   rrxfifo_urst_en;
	input   rrxphfifopldctl_en;
	input   [39:0]  rsync_comp_pat;
	input   rsync_comp_porn;
	input   [2:0]  rsync_comp_size;
	input   rsync_sm_dis;
	output   [1:0]  running_disp;
	input   rwa_6g_en;
	input   [1:0]  rx_control_dt;
	input   rx_control_rs;
	input   [15:0]  rx_data_dt;
	input   [7:0]  rx_data_rs;
	input   rx_rd_clk;
	input   rx_we_in_ch0;
	input   rx_we_in_q0_ch0;
	output   rx_we_out;
	input   rx_wr_clk;
	output   [3:0]  rxc;
	output   [63:0]  rxd;
	output   [1:0]  rxd_19;
	output   [1:0]  rxd_9;
	output   [39:0]  rxd_lpbk;
	input   rxfifo_urst;
	input   scan_mode;
	output   signal_detect_out;
	input   signal_detect_sync_st;
	input   soft_reset;
	output   soft_reset_rclk1;
	input   [1:0]  sync_resync_delay;
	input   [1:0]  sync_resync_pre;
	input   [19:0]  tenb_data;
	output   [2:0]  wptr_bin;
	output   wr_enable2;
	input   wr_enable_ch0;
	output   wr_enable_out;
	input   wr_enable_q0_ch0;

	reg	nl0000i61;
	reg	nl0000i62;
	reg	nl0000l59;
	reg	nl0000l60;
	reg	nl0000O57;
	reg	nl0000O58;
	reg	nl000il55;
	reg	nl000il56;
	reg	nl000iO53;
	reg	nl000iO54;
	reg	nl000Ol51;
	reg	nl000Ol52;
	reg	nl000OO49;
	reg	nl000OO50;
	reg	nl0i01O41;
	reg	nl0i01O42;
	reg	nl0i1ii47;
	reg	nl0i1ii48;
	reg	nl0i1il45;
	reg	nl0i1il46;
	reg	nl0i1iO43;
	reg	nl0i1iO44;
	reg	nl0illi39;
	reg	nl0illi40;
	reg	nl0ilOi37;
	reg	nl0ilOi38;
	reg	nl0iO0i33;
	reg	nl0iO0i34;
	reg	nl0iO1i35;
	reg	nl0iO1i36;
	reg	nl0iOii31;
	reg	nl0iOii32;
	reg	nl0iOil29;
	reg	nl0iOil30;
	reg	nl0iOlO27;
	reg	nl0iOlO28;
	reg	nl0l00i5;
	reg	nl0l00i6;
	reg	nl0l01i11;
	reg	nl0l01i12;
	reg	nl0l01l10;
	reg	nl0l01l9;
	reg	nl0l01O7;
	reg	nl0l01O8;
	reg	nl0l0ii3;
	reg	nl0l0ii4;
	reg	nl0l0li1;
	reg	nl0l0li2;
	reg	nl0l10i23;
	reg	nl0l10i24;
	reg	nl0l10O21;
	reg	nl0l10O22;
	reg	nl0l11i25;
	reg	nl0l11i26;
	reg	nl0l1il19;
	reg	nl0l1il20;
	reg	nl0l1iO17;
	reg	nl0l1iO18;
	reg	nl0l1ll15;
	reg	nl0l1ll16;
	reg	nl0l1Oi13;
	reg	nl0l1Oi14;
	reg	n110i;
	reg	n111i;
	reg	n111O_clk_prev;
	wire	wire_n111O_CLRN;
	wire	wire_n111O_PRN;
	reg	n11OOl;
	reg	n11OOi_clk_prev;
	wire	wire_n11OOi_CLRN;
	wire	wire_n11OOi_PRN;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n1010O;
	reg	n101i;
	reg	n101l;
	reg	n101O;
	reg	n10ii;
	reg	n10il;
	reg	n10iO;
	reg	n10li;
	reg	n10ll;
	reg	n10lO;
	reg	n10Oi;
	reg	n10Ol;
	reg	n10OO;
	reg	n110l;
	reg	n110O;
	reg	n11ii;
	reg	n11il;
	reg	n11iO;
	reg	n11li;
	reg	n11ll;
	reg	n11lO;
	reg	n11Oi;
	reg	n11Ol;
	reg	n11Oll;
	reg	n11OlO;
	reg	n11OO;
	reg	n1i0i;
	reg	n1i0l;
	reg	n1i0O;
	reg	n1i1i;
	reg	n1i1l;
	reg	n1i1O;
	reg	n1iii;
	reg	n1iil;
	reg	n1iiO;
	reg	n1ili;
	reg	n1ill;
	reg	n1ilO;
	reg	n1iOi;
	reg	n1iOl;
	reg	n1iOO;
	reg	n1l1i;
	reg	n1l1O;
	wire	wire_n1l1l_CLRN;
	reg	nl0OlOi;
	reg	nl0OllO_clk_prev;
	wire	wire_nl0OllO_CLRN;
	wire	wire_nl0OllO_PRN;
	wire	wire_nl0OllO_ENA;
	reg	nl0OO0l;
	reg	nl0OOOi;
	reg	nli101i;
	reg	nli10li;
	reg	nli11ii;
	wire	wire_nli10iO_PRN;
	reg	nli10Oi;
	reg	nli10lO_clk_prev;
	wire	wire_nli10lO_CLRN;
	wire	wire_nli10lO_PRN;
	reg	nl0llOi;
	reg	nl0lOil;
	reg	nl0lOiO;
	reg	nl0lOli;
	reg	nl0lOll;
	reg	nl0lOlO;
	reg	nl0lOOi;
	reg	nl0lOOl;
	reg	nl0lOOO;
	reg	nl0O00i;
	reg	nl0O00l;
	reg	nl0O00O;
	reg	nl0O01i;
	reg	nl0O01l;
	reg	nl0O01O;
	reg	nl0O0ii;
	reg	nl0O0il;
	reg	nl0O0iO;
	reg	nl0O0li;
	reg	nl0O0ll;
	reg	nl0O0lO;
	reg	nl0O0Oi;
	reg	nl0O0Ol;
	reg	nl0O0OO;
	reg	nl0O10i;
	reg	nl0O10l;
	reg	nl0O10O;
	reg	nl0O11i;
	reg	nl0O11l;
	reg	nl0O11O;
	reg	nl0O1ii;
	reg	nl0O1il;
	reg	nl0O1iO;
	reg	nl0O1li;
	reg	nl0O1ll;
	reg	nl0O1lO;
	reg	nl0O1Oi;
	reg	nl0O1Ol;
	reg	nl0O1OO;
	reg	nl0Oi0i;
	reg	nl0Oi0l;
	reg	nl0Oi0O;
	reg	nl0Oi1i;
	reg	nl0Oi1l;
	reg	nl0Oi1O;
	reg	nl0Oiii;
	reg	nl0Oiil;
	reg	nl0OiiO;
	reg	nl0Oili;
	reg	nl0Oill;
	reg	nl0OilO;
	reg	nl0OiOi;
	reg	nl0OiOl;
	reg	nl0OiOO;
	reg	nl0Ol0i;
	reg	nl0Ol0l;
	reg	nl0Ol0O;
	reg	nl0Ol1i;
	reg	nl0Ol1l;
	reg	nl0Ol1O;
	reg	nl0Olii;
	reg	nl0Olil;
	reg	nl0OliO;
	reg	nl0Olli;
	reg	nl0Olll;
	reg	nl0OlOl;
	reg	nl0OlOO;
	reg	nl0OO0i;
	reg	nl0OO0O;
	reg	nl0OO1i;
	reg	nl0OO1l;
	reg	nl0OO1O;
	reg	nl0OOii;
	reg	nl0OOil;
	reg	nl0OOiO;
	reg	nl0OOli;
	reg	nl0OOll;
	reg	nl0OOlO;
	reg	nl0OOOl;
	reg	nl0OOOO;
	reg	nli100i;
	reg	nli100l;
	reg	nli100O;
	reg	nli101l;
	reg	nli101O;
	reg	nli10ii;
	reg	nli10il;
	reg	nli10ll;
	reg	nli110i;
	reg	nli110l;
	reg	nli110O;
	reg	nli111i;
	reg	nli111l;
	reg	nli111O;
	reg	nli11il;
	reg	nli11iO;
	reg	nli11li;
	reg	nli11ll;
	reg	nli11lO;
	reg	nli11Oi;
	reg	nli11Ol;
	reg	nli11OO;
	reg	nlO0ll;
	reg	nlOl0l;
	reg	nlOl0O;
	reg	nlOlil;
	reg	n11OOO;
	reg	nli1lli;
	reg	nli1lll;
	reg	nli1llO;
	reg	nli1lOi;
	reg	nli1lOl;
	reg	nli1lOO;
	reg	nli1O1i;
	reg	nliliO;
	reg	nlilli;
	reg	nlilll;
	reg	nlillO;
	reg	nlilOi;
	reg	nlilOl;
	reg	nlilOO;
	reg	nliO0i;
	reg	nliO0l;
	reg	nliO0O;
	reg	nliO1i;
	reg	nliO1l;
	reg	nliO1O;
	reg	nliOii;
	reg	nliOil;
	reg	nliOiO;
	reg	nliOli;
	reg	nliOll;
	reg	nliOlO;
	reg	nliOOi;
	reg	nliOOl;
	reg	nliOOO;
	reg	nll00i;
	reg	nll00l;
	reg	nll00O;
	reg	nll01i;
	reg	nll01l;
	reg	nll01O;
	reg	nll0ii;
	reg	nll0il;
	reg	nll0iO;
	reg	nll0li;
	reg	nll0ll;
	reg	nll0lO;
	reg	nll0Oi;
	reg	nll0Ol;
	reg	nll0OO;
	reg	nll10i;
	reg	nll10l;
	reg	nll10O;
	reg	nll11i;
	reg	nll11l;
	reg	nll11O;
	reg	nll1ii;
	reg	nll1il;
	reg	nll1iO;
	reg	nll1li;
	reg	nll1ll;
	reg	nll1lO;
	reg	nll1Oi;
	reg	nll1Ol;
	reg	nll1OO;
	reg	nlli0i;
	reg	nlli0l;
	reg	nlli0O;
	reg	nlli1i;
	reg	nlli1l;
	reg	nlli1O;
	reg	nlliii;
	reg	nlliil;
	reg	nlliiO;
	reg	nllili;
	reg	nllill;
	reg	nllilO;
	reg	nlliOi;
	reg	nlliOl;
	reg	nlliOO;
	reg	nlll0i;
	reg	nlll0l;
	reg	nlll0O;
	reg	nlll1i;
	reg	nlll1l;
	reg	nlll1O;
	reg	nlllii;
	reg	nlllil;
	reg	nllliO;
	reg	nlllli;
	reg	nlllll;
	reg	nllllO;
	reg	nlllOi;
	reg	nlllOl;
	reg	nlllOO;
	reg	nllO0i;
	reg	nllO0l;
	reg	nllO0O;
	reg	nllO1i;
	reg	nllO1l;
	reg	nllO1O;
	reg	nllOii;
	reg	nllOil;
	reg	nllOiO;
	reg	nllOli;
	reg	nllOll;
	reg	nllOlO;
	reg	nllOOi;
	reg	nllOOl;
	reg	nllOOO;
	reg	nlO00i;
	reg	nlO00l;
	reg	nlO00O;
	reg	nlO01i;
	reg	nlO01l;
	reg	nlO01O;
	reg	nlO0ii;
	reg	nlO0il;
	reg	nlO0iO;
	reg	nlO0li;
	reg	nlO10i;
	reg	nlO10l;
	reg	nlO10O;
	reg	nlO11i;
	reg	nlO11l;
	reg	nlO11O;
	reg	nlO1ii;
	reg	nlO1il;
	reg	nlO1iO;
	reg	nlO1li;
	reg	nlO1ll;
	reg	nlO1lO;
	reg	nlO1Oi;
	reg	nlO1Ol;
	reg	nlO1OO;
	reg	nlOliO;
	reg	nlOlOl;
	reg	nlOlOO;
	reg	nlOO0i;
	reg	nlOO0O;
	reg	nlOO1i;
	reg	nlOO1l;
	reg	nlOO1O;
	reg	nlOOii;
	reg	nlOOOO;
	reg	nlOOOl_clk_prev;
	wire	wire_nlOOOl_CLRN;
	wire	wire_n0000i_dataout;
	wire	wire_n0000l_dataout;
	wire	wire_n0000O_dataout;
	wire	wire_n0001i_dataout;
	wire	wire_n0001l_dataout;
	wire	wire_n0001O_dataout;
	wire	wire_n000i_dataout;
	wire	wire_n000ii_dataout;
	wire	wire_n000il_dataout;
	wire	wire_n000iO_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000li_dataout;
	wire	wire_n000ll_dataout;
	wire	wire_n000lO_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n000Oi_dataout;
	wire	wire_n000Ol_dataout;
	wire	wire_n000OO_dataout;
	wire	wire_n0010i_dataout;
	wire	wire_n0010l_dataout;
	wire	wire_n0010O_dataout;
	wire	wire_n0011i_dataout;
	wire	wire_n0011l_dataout;
	wire	wire_n0011O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001ii_dataout;
	wire	wire_n001il_dataout;
	wire	wire_n001iO_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001li_dataout;
	wire	wire_n001ll_dataout;
	wire	wire_n001lO_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n001Oi_dataout;
	wire	wire_n001Ol_dataout;
	wire	wire_n001OO_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00i0i_dataout;
	wire	wire_n00i0l_dataout;
	wire	wire_n00i0O_dataout;
	wire	wire_n00i1i_dataout;
	wire	wire_n00i1l_dataout;
	wire	wire_n00i1O_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00iii_dataout;
	wire	wire_n00iil_dataout;
	wire	wire_n00iiO_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00ili_dataout;
	wire	wire_n00ill_dataout;
	wire	wire_n00ilO_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00iOi_dataout;
	wire	wire_n00iOl_dataout;
	wire	wire_n00iOO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00l0i_dataout;
	wire	wire_n00l0l_dataout;
	wire	wire_n00l0O_dataout;
	wire	wire_n00l1i_dataout;
	wire	wire_n00l1l_dataout;
	wire	wire_n00l1O_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00lii_dataout;
	wire	wire_n00lil_dataout;
	wire	wire_n00liO_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lli_dataout;
	wire	wire_n00lll_dataout;
	wire	wire_n00llO_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00lOi_dataout;
	wire	wire_n00lOl_dataout;
	wire	wire_n00lOO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00O0i_dataout;
	wire	wire_n00O0l_dataout;
	wire	wire_n00O0O_dataout;
	wire	wire_n00O1i_dataout;
	wire	wire_n00O1l_dataout;
	wire	wire_n00O1O_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n00Oii_dataout;
	wire	wire_n00Oil_dataout;
	wire	wire_n00OiO_dataout;
	wire	wire_n00Oli_dataout;
	wire	wire_n00Oll_dataout;
	wire	wire_n00OlO_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n00OOi_dataout;
	wire	wire_n00OOl_dataout;
	wire	wire_n00OOO_dataout;
	wire	wire_n0100i_dataout;
	wire	wire_n0100l_dataout;
	wire	wire_n0100O_dataout;
	wire	wire_n0101i_dataout;
	wire	wire_n0101l_dataout;
	wire	wire_n0101O_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010ii_dataout;
	wire	wire_n010il_dataout;
	wire	wire_n010iO_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010li_dataout;
	wire	wire_n010ll_dataout;
	wire	wire_n010lO_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n010Oi_dataout;
	wire	wire_n010Ol_dataout;
	wire	wire_n010OO_dataout;
	wire	wire_n0110i_dataout;
	wire	wire_n0110l_dataout;
	wire	wire_n0110O_dataout;
	wire	wire_n0111i_dataout;
	wire	wire_n0111l_dataout;
	wire	wire_n0111O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011ii_dataout;
	wire	wire_n011il_dataout;
	wire	wire_n011iO_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011li_dataout;
	wire	wire_n011ll_dataout;
	wire	wire_n011lO_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n011Oi_dataout;
	wire	wire_n011Ol_dataout;
	wire	wire_n011OO_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01i0i_dataout;
	wire	wire_n01i0l_dataout;
	wire	wire_n01i0O_dataout;
	wire	wire_n01i1i_dataout;
	wire	wire_n01i1l_dataout;
	wire	wire_n01i1O_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01iii_dataout;
	wire	wire_n01iil_dataout;
	wire	wire_n01iiO_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01ili_dataout;
	wire	wire_n01ill_dataout;
	wire	wire_n01ilO_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01iOi_dataout;
	wire	wire_n01iOl_dataout;
	wire	wire_n01iOO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01l0i_dataout;
	wire	wire_n01l0l_dataout;
	wire	wire_n01l0O_dataout;
	wire	wire_n01l1i_dataout;
	wire	wire_n01l1l_dataout;
	wire	wire_n01l1O_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01lii_dataout;
	wire	wire_n01lil_dataout;
	wire	wire_n01liO_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lli_dataout;
	wire	wire_n01lll_dataout;
	wire	wire_n01llO_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01lOi_dataout;
	wire	wire_n01lOl_dataout;
	wire	wire_n01lOO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01O0i_dataout;
	wire	wire_n01O0l_dataout;
	wire	wire_n01O0O_dataout;
	wire	wire_n01O1i_dataout;
	wire	wire_n01O1l_dataout;
	wire	wire_n01O1O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Oii_dataout;
	wire	wire_n01Oil_dataout;
	wire	wire_n01OiO_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01Oli_dataout;
	wire	wire_n01Oll_dataout;
	wire	wire_n01OlO_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n01OOi_dataout;
	wire	wire_n01OOl_dataout;
	wire	wire_n01OOO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i00i_dataout;
	wire	wire_n0i00l_dataout;
	wire	wire_n0i00O_dataout;
	wire	wire_n0i01i_dataout;
	wire	wire_n0i01l_dataout;
	wire	wire_n0i01O_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0ii_dataout;
	wire	wire_n0i0il_dataout;
	wire	wire_n0i0iO_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0li_dataout;
	wire	wire_n0i0ll_dataout;
	wire	wire_n0i0lO_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i0Oi_dataout;
	wire	wire_n0i0Ol_dataout;
	wire	wire_n0i0OO_dataout;
	wire	wire_n0i10i_dataout;
	wire	wire_n0i10l_dataout;
	wire	wire_n0i10O_dataout;
	wire	wire_n0i11i_dataout;
	wire	wire_n0i11l_dataout;
	wire	wire_n0i11O_dataout;
	wire	wire_n0i1ii_dataout;
	wire	wire_n0i1il_dataout;
	wire	wire_n0i1iO_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1li_dataout;
	wire	wire_n0i1ll_dataout;
	wire	wire_n0i1lO_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0i1Oi_dataout;
	wire	wire_n0i1Ol_dataout;
	wire	wire_n0i1OO_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0ii0i_dataout;
	wire	wire_n0ii0l_dataout;
	wire	wire_n0ii0O_dataout;
	wire	wire_n0ii1i_dataout;
	wire	wire_n0ii1l_dataout;
	wire	wire_n0ii1O_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iiii_dataout;
	wire	wire_n0iiil_dataout;
	wire	wire_n0iiiO_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iili_dataout;
	wire	wire_n0iill_dataout;
	wire	wire_n0iilO_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0iiOi_dataout;
	wire	wire_n0iiOl_dataout;
	wire	wire_n0iiOO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0il0i_dataout;
	wire	wire_n0il0l_dataout;
	wire	wire_n0il0O_dataout;
	wire	wire_n0il1i_dataout;
	wire	wire_n0il1l_dataout;
	wire	wire_n0il1O_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ilii_dataout;
	wire	wire_n0ilil_dataout;
	wire	wire_n0iliO_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0illi_dataout;
	wire	wire_n0illl_dataout;
	wire	wire_n0illO_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0ilOi_dataout;
	wire	wire_n0ilOl_dataout;
	wire	wire_n0ilOO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iO0i_dataout;
	wire	wire_n0iO0l_dataout;
	wire	wire_n0iO0O_dataout;
	wire	wire_n0iO1i_dataout;
	wire	wire_n0iO1l_dataout;
	wire	wire_n0iO1O_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOii_dataout;
	wire	wire_n0iOil_dataout;
	wire	wire_n0iOiO_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOli_dataout;
	wire	wire_n0iOll_dataout;
	wire	wire_n0iOlO_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0iOOi_dataout;
	wire	wire_n0iOOl_dataout;
	wire	wire_n0iOOO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l00i_dataout;
	wire	wire_n0l00l_dataout;
	wire	wire_n0l00O_dataout;
	wire	wire_n0l01i_dataout;
	wire	wire_n0l01l_dataout;
	wire	wire_n0l01O_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0ii_dataout;
	wire	wire_n0l0il_dataout;
	wire	wire_n0l0iO_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0li_dataout;
	wire	wire_n0l0ll_dataout;
	wire	wire_n0l0lO_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l0Oi_dataout;
	wire	wire_n0l0Ol_dataout;
	wire	wire_n0l0OO_dataout;
	wire	wire_n0l10i_dataout;
	wire	wire_n0l10l_dataout;
	wire	wire_n0l10O_dataout;
	wire	wire_n0l11i_dataout;
	wire	wire_n0l11l_dataout;
	wire	wire_n0l11O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1ii_dataout;
	wire	wire_n0l1il_dataout;
	wire	wire_n0l1iO_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1li_dataout;
	wire	wire_n0l1ll_dataout;
	wire	wire_n0l1lO_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0l1Oi_dataout;
	wire	wire_n0l1Ol_dataout;
	wire	wire_n0l1OO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0li0i_dataout;
	wire	wire_n0li0l_dataout;
	wire	wire_n0li0O_dataout;
	wire	wire_n0li1i_dataout;
	wire	wire_n0li1l_dataout;
	wire	wire_n0li1O_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0liii_dataout;
	wire	wire_n0liil_dataout;
	wire	wire_n0liiO_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0lili_dataout;
	wire	wire_n0lill_dataout;
	wire	wire_n0lilO_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0liOi_dataout;
	wire	wire_n0liOl_dataout;
	wire	wire_n0liOO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0ll0i_dataout;
	wire	wire_n0ll0l_dataout;
	wire	wire_n0ll0O_dataout;
	wire	wire_n0ll1i_dataout;
	wire	wire_n0ll1l_dataout;
	wire	wire_n0ll1O_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0llii_dataout;
	wire	wire_n0llil_dataout;
	wire	wire_n0lliO_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llli_dataout;
	wire	wire_n0llll_dataout;
	wire	wire_n0lllO_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0llOi_dataout;
	wire	wire_n0llOl_dataout;
	wire	wire_n0llOO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lO0i_dataout;
	wire	wire_n0lO0l_dataout;
	wire	wire_n0lO0O_dataout;
	wire	wire_n0lO1i_dataout;
	wire	wire_n0lO1l_dataout;
	wire	wire_n0lO1O_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOii_dataout;
	wire	wire_n0lOil_dataout;
	wire	wire_n0lOiO_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOli_dataout;
	wire	wire_n0lOll_dataout;
	wire	wire_n0lOlO_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0lOOi_dataout;
	wire	wire_n0lOOl_dataout;
	wire	wire_n0lOOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O00i_dataout;
	wire	wire_n0O00l_dataout;
	wire	wire_n0O00O_dataout;
	wire	wire_n0O01i_dataout;
	wire	wire_n0O01l_dataout;
	wire	wire_n0O01O_dataout;
	wire	wire_n0O0ii_dataout;
	wire	wire_n0O0il_dataout;
	wire	wire_n0O0iO_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0li_dataout;
	wire	wire_n0O0ll_dataout;
	wire	wire_n0O0lO_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O0Oi_dataout;
	wire	wire_n0O0Ol_dataout;
	wire	wire_n0O0OO_dataout;
	wire	wire_n0O10i_dataout;
	wire	wire_n0O10l_dataout;
	wire	wire_n0O10O_dataout;
	wire	wire_n0O11i_dataout;
	wire	wire_n0O11l_dataout;
	wire	wire_n0O11O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1ii_dataout;
	wire	wire_n0O1il_dataout;
	wire	wire_n0O1iO_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1li_dataout;
	wire	wire_n0O1ll_dataout;
	wire	wire_n0O1lO_dataout;
	wire	wire_n0O1Oi_dataout;
	wire	wire_n0O1Ol_dataout;
	wire	wire_n0O1OO_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oi0i_dataout;
	wire	wire_n0Oi0l_dataout;
	wire	wire_n0Oi0O_dataout;
	wire	wire_n0Oi1i_dataout;
	wire	wire_n0Oi1l_dataout;
	wire	wire_n0Oi1O_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oiii_dataout;
	wire	wire_n0Oiil_dataout;
	wire	wire_n0OiiO_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0Oili_dataout;
	wire	wire_n0Oill_dataout;
	wire	wire_n0OilO_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0OiOi_dataout;
	wire	wire_n0OiOl_dataout;
	wire	wire_n0OiOO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Ol0i_dataout;
	wire	wire_n0Ol0l_dataout;
	wire	wire_n0Ol0O_dataout;
	wire	wire_n0Ol1i_dataout;
	wire	wire_n0Ol1l_dataout;
	wire	wire_n0Ol1O_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Olii_dataout;
	wire	wire_n0Olil_dataout;
	wire	wire_n0OliO_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0Olli_dataout;
	wire	wire_n0Olll_dataout;
	wire	wire_n0OllO_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OlOi_dataout;
	wire	wire_n0OlOl_dataout;
	wire	wire_n0OlOO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OO0i_dataout;
	wire	wire_n0OO0l_dataout;
	wire	wire_n0OO0O_dataout;
	wire	wire_n0OO1i_dataout;
	wire	wire_n0OO1l_dataout;
	wire	wire_n0OO1O_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOii_dataout;
	wire	wire_n0OOil_dataout;
	wire	wire_n0OOiO_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOli_dataout;
	wire	wire_n0OOll_dataout;
	wire	wire_n0OOlO_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n0OOOi_dataout;
	wire	wire_n0OOOl_dataout;
	wire	wire_n0OOOO_dataout;
	wire	wire_n1010i_dataout;
	wire	wire_n1010l_dataout;
	wire	wire_n1011i_dataout;
	wire	wire_n1011l_dataout;
	wire	wire_n1011O_dataout;
	wire	wire_n101ii_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10OOi_dataout;
	wire	wire_n10OOl_dataout;
	wire	wire_n10OOO_dataout;
	wire	wire_n111l_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i00i_dataout;
	wire	wire_n1i00l_dataout;
	wire	wire_n1i00O_dataout;
	wire	wire_n1i01i_dataout;
	wire	wire_n1i01l_dataout;
	wire	wire_n1i01O_dataout;
	wire	wire_n1i0ii_dataout;
	wire	wire_n1i0il_dataout;
	wire	wire_n1i0iO_dataout;
	wire	wire_n1i0li_dataout;
	wire	wire_n1i0ll_dataout;
	wire	wire_n1i0lO_dataout;
	wire	wire_n1i0Oi_dataout;
	wire	wire_n1i0Ol_dataout;
	wire	wire_n1i0OO_dataout;
	wire	wire_n1i10i_dataout;
	wire	wire_n1i10l_dataout;
	wire	wire_n1i10O_dataout;
	wire	wire_n1i11i_dataout;
	wire	wire_n1i11l_dataout;
	wire	wire_n1i11O_dataout;
	wire	wire_n1i1ii_dataout;
	wire	wire_n1i1il_dataout;
	wire	wire_n1i1iO_dataout;
	wire	wire_n1i1li_dataout;
	wire	wire_n1i1ll_dataout;
	wire	wire_n1i1lO_dataout;
	wire	wire_n1i1Oi_dataout;
	wire	wire_n1i1Ol_dataout;
	wire	wire_n1i1OO_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1ii0i_dataout;
	wire	wire_n1ii0l_dataout;
	wire	wire_n1ii0O_dataout;
	wire	wire_n1ii1i_dataout;
	wire	wire_n1ii1l_dataout;
	wire	wire_n1ii1O_dataout;
	wire	wire_n1iiii_dataout;
	wire	wire_n1iiil_dataout;
	wire	wire_n1iiiO_dataout;
	wire	wire_n1iili_dataout;
	wire	wire_n1iill_dataout;
	wire	wire_n1iilO_dataout;
	wire	wire_n1iiOi_dataout;
	wire	wire_n1iiOl_dataout;
	wire	wire_n1iiOO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1il0i_dataout;
	wire	wire_n1il0l_dataout;
	wire	wire_n1il0O_dataout;
	wire	wire_n1il1i_dataout;
	wire	wire_n1il1l_dataout;
	wire	wire_n1il1O_dataout;
	wire	wire_n1ilii_dataout;
	wire	wire_n1ilil_dataout;
	wire	wire_n1iliO_dataout;
	wire	wire_n1illi_dataout;
	wire	wire_n1illl_dataout;
	wire	wire_n1illO_dataout;
	wire	wire_n1ilOi_dataout;
	wire	wire_n1ilOl_dataout;
	wire	wire_n1ilOO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iO0i_dataout;
	wire	wire_n1iO0l_dataout;
	wire	wire_n1iO0O_dataout;
	wire	wire_n1iO1i_dataout;
	wire	wire_n1iO1l_dataout;
	wire	wire_n1iO1O_dataout;
	wire	wire_n1iOii_dataout;
	wire	wire_n1iOil_dataout;
	wire	wire_n1iOiO_dataout;
	wire	wire_n1iOli_dataout;
	wire	wire_n1iOll_dataout;
	wire	wire_n1iOlO_dataout;
	wire	wire_n1iOOi_dataout;
	wire	wire_n1iOOl_dataout;
	wire	wire_n1iOOO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1l00i_dataout;
	wire	wire_n1l00l_dataout;
	wire	wire_n1l00O_dataout;
	wire	wire_n1l01i_dataout;
	wire	wire_n1l01l_dataout;
	wire	wire_n1l01O_dataout;
	wire	wire_n1l0ii_dataout;
	wire	wire_n1l0il_dataout;
	wire	wire_n1l0iO_dataout;
	wire	wire_n1l0li_dataout;
	wire	wire_n1l0ll_dataout;
	wire	wire_n1l0lO_dataout;
	wire	wire_n1l0Oi_dataout;
	wire	wire_n1l0Ol_dataout;
	wire	wire_n1l0OO_dataout;
	wire	wire_n1l10i_dataout;
	wire	wire_n1l10l_dataout;
	wire	wire_n1l10O_dataout;
	wire	wire_n1l11i_dataout;
	wire	wire_n1l11l_dataout;
	wire	wire_n1l11O_dataout;
	wire	wire_n1l1ii_dataout;
	wire	wire_n1l1il_dataout;
	wire	wire_n1l1iO_dataout;
	wire	wire_n1l1li_dataout;
	wire	wire_n1l1ll_dataout;
	wire	wire_n1l1lO_dataout;
	wire	wire_n1l1Oi_dataout;
	wire	wire_n1l1Ol_dataout;
	wire	wire_n1l1OO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1li0i_dataout;
	wire	wire_n1li0l_dataout;
	wire	wire_n1li0O_dataout;
	wire	wire_n1li1i_dataout;
	wire	wire_n1li1l_dataout;
	wire	wire_n1li1O_dataout;
	wire	wire_n1liii_dataout;
	wire	wire_n1liil_dataout;
	wire	wire_n1liiO_dataout;
	wire	wire_n1lili_dataout;
	wire	wire_n1lill_dataout;
	wire	wire_n1lilO_dataout;
	wire	wire_n1liOi_dataout;
	wire	wire_n1liOl_dataout;
	wire	wire_n1liOO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1ll0i_dataout;
	wire	wire_n1ll0l_dataout;
	wire	wire_n1ll1i_dataout;
	wire	wire_n1ll1l_dataout;
	wire	wire_n1ll1O_dataout;
	wire	wire_n1llii_dataout;
	wire	wire_n1llil_dataout;
	wire	wire_n1lliO_dataout;
	wire	wire_n1llli_dataout;
	wire	wire_n1llll_dataout;
	wire	wire_n1lllO_dataout;
	wire	wire_n1llOi_dataout;
	wire	wire_n1llOl_dataout;
	wire	wire_n1llOO_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lO0i_dataout;
	wire	wire_n1lO0l_dataout;
	wire	wire_n1lO0O_dataout;
	wire	wire_n1lO1i_dataout;
	wire	wire_n1lO1l_dataout;
	wire	wire_n1lO1O_dataout;
	wire	wire_n1lOii_dataout;
	wire	wire_n1lOil_dataout;
	wire	wire_n1lOiO_dataout;
	wire	wire_n1lOli_dataout;
	wire	wire_n1lOll_dataout;
	wire	wire_n1lOlO_dataout;
	wire	wire_n1lOOi_dataout;
	wire	wire_n1lOOl_dataout;
	wire	wire_n1lOOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O00i_dataout;
	wire	wire_n1O00l_dataout;
	wire	wire_n1O00O_dataout;
	wire	wire_n1O01i_dataout;
	wire	wire_n1O01l_dataout;
	wire	wire_n1O01O_dataout;
	wire	wire_n1O0ii_dataout;
	wire	wire_n1O0il_dataout;
	wire	wire_n1O0iO_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0ll_dataout;
	wire	wire_n1O0lO_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O0Oi_dataout;
	wire	wire_n1O0Ol_dataout;
	wire	wire_n1O0OO_dataout;
	wire	wire_n1O10i_dataout;
	wire	wire_n1O10l_dataout;
	wire	wire_n1O10O_dataout;
	wire	wire_n1O11i_dataout;
	wire	wire_n1O11l_dataout;
	wire	wire_n1O11O_dataout;
	wire	wire_n1O1ii_dataout;
	wire	wire_n1O1il_dataout;
	wire	wire_n1O1iO_dataout;
	wire	wire_n1O1li_dataout;
	wire	wire_n1O1ll_dataout;
	wire	wire_n1O1lO_dataout;
	wire	wire_n1O1Oi_dataout;
	wire	wire_n1O1Ol_dataout;
	wire	wire_n1O1OO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oi0i_dataout;
	wire	wire_n1Oi0l_dataout;
	wire	wire_n1Oi0O_dataout;
	wire	wire_n1Oi1i_dataout;
	wire	wire_n1Oi1l_dataout;
	wire	wire_n1Oi1O_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oiii_dataout;
	wire	wire_n1Oiil_dataout;
	wire	wire_n1OiiO_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1Oili_dataout;
	wire	wire_n1Oill_dataout;
	wire	wire_n1OilO_dataout;
	wire	wire_n1OiOi_dataout;
	wire	wire_n1OiOl_dataout;
	wire	wire_n1OiOO_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Ol0i_dataout;
	wire	wire_n1Ol0l_dataout;
	wire	wire_n1Ol0O_dataout;
	wire	wire_n1Ol1i_dataout;
	wire	wire_n1Ol1l_dataout;
	wire	wire_n1Ol1O_dataout;
	wire	wire_n1Olii_dataout;
	wire	wire_n1Olil_dataout;
	wire	wire_n1OliO_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1Olli_dataout;
	wire	wire_n1Olll_dataout;
	wire	wire_n1OllO_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OlOi_dataout;
	wire	wire_n1OlOl_dataout;
	wire	wire_n1OlOO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OO0i_dataout;
	wire	wire_n1OO0l_dataout;
	wire	wire_n1OO0O_dataout;
	wire	wire_n1OO1i_dataout;
	wire	wire_n1OO1l_dataout;
	wire	wire_n1OO1O_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOii_dataout;
	wire	wire_n1OOil_dataout;
	wire	wire_n1OOiO_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOli_dataout;
	wire	wire_n1OOll_dataout;
	wire	wire_n1OOlO_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_n1OOOi_dataout;
	wire	wire_n1OOOl_dataout;
	wire	wire_n1OOOO_dataout;
	wire	wire_ni000i_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni001i_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni001O_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni00ii_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00iO_dataout;
	wire	wire_ni00l_dataout;
	wire	wire_ni00li_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00O_dataout;
	wire	wire_ni00Oi_dataout;
	wire	wire_ni00Ol_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010l_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011i_dataout;
	wire	wire_ni011l_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni01ii_dataout;
	wire	wire_ni01il_dataout;
	wire	wire_ni01iO_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01ll_dataout;
	wire	wire_ni01lO_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni01Oi_dataout;
	wire	wire_ni01Ol_dataout;
	wire	wire_ni01OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0i0i_dataout;
	wire	wire_ni0i0l_dataout;
	wire	wire_ni0i0O_dataout;
	wire	wire_ni0i1i_dataout;
	wire	wire_ni0i1l_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0ii_dataout;
	wire	wire_ni0iii_dataout;
	wire	wire_ni0iil_dataout;
	wire	wire_ni0iiO_dataout;
	wire	wire_ni0ili_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0ilO_dataout;
	wire	wire_ni0iO_dataout;
	wire	wire_ni0iOi_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0l0i_dataout;
	wire	wire_ni0l0l_dataout;
	wire	wire_ni0l0O_dataout;
	wire	wire_ni0l1i_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0li_dataout;
	wire	wire_ni0lii_dataout;
	wire	wire_ni0lil_dataout;
	wire	wire_ni0liO_dataout;
	wire	wire_ni0ll_dataout;
	wire	wire_ni0lli_dataout;
	wire	wire_ni0lll_dataout;
	wire	wire_ni0llO_dataout;
	wire	wire_ni0lO_dataout;
	wire	wire_ni0lOi_dataout;
	wire	wire_ni0lOl_dataout;
	wire	wire_ni0lOO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0O0i_dataout;
	wire	wire_ni0O0l_dataout;
	wire	wire_ni0O0O_dataout;
	wire	wire_ni0O1i_dataout;
	wire	wire_ni0O1l_dataout;
	wire	wire_ni0O1O_dataout;
	wire	wire_ni0Oi_dataout;
	wire	wire_ni0Oii_dataout;
	wire	wire_ni0Oil_dataout;
	wire	wire_ni0OiO_dataout;
	wire	wire_ni0Ol_dataout;
	wire	wire_ni0Oli_dataout;
	wire	wire_ni0Oll_dataout;
	wire	wire_ni0OlO_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni0OOi_dataout;
	wire	wire_ni0OOl_dataout;
	wire	wire_ni0OOO_dataout;
	wire	wire_ni100i_dataout;
	wire	wire_ni100l_dataout;
	wire	wire_ni100O_dataout;
	wire	wire_ni101i_dataout;
	wire	wire_ni101l_dataout;
	wire	wire_ni101O_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10ii_dataout;
	wire	wire_ni10il_dataout;
	wire	wire_ni10iO_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10li_dataout;
	wire	wire_ni10ll_dataout;
	wire	wire_ni10lO_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni10Oi_dataout;
	wire	wire_ni10Ol_dataout;
	wire	wire_ni10OO_dataout;
	wire	wire_ni110i_dataout;
	wire	wire_ni110l_dataout;
	wire	wire_ni110O_dataout;
	wire	wire_ni111i_dataout;
	wire	wire_ni111l_dataout;
	wire	wire_ni111O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11ii_dataout;
	wire	wire_ni11il_dataout;
	wire	wire_ni11iO_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11li_dataout;
	wire	wire_ni11ll_dataout;
	wire	wire_ni11lO_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni11Oi_dataout;
	wire	wire_ni11Ol_dataout;
	wire	wire_ni11OO_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1i0i_dataout;
	wire	wire_ni1i0l_dataout;
	wire	wire_ni1i0O_dataout;
	wire	wire_ni1i1i_dataout;
	wire	wire_ni1i1l_dataout;
	wire	wire_ni1i1O_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1iii_dataout;
	wire	wire_ni1iil_dataout;
	wire	wire_ni1iiO_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1ili_dataout;
	wire	wire_ni1ill_dataout;
	wire	wire_ni1ilO_dataout;
	wire	wire_ni1iOi_dataout;
	wire	wire_ni1iOl_dataout;
	wire	wire_ni1iOO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0i_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1l1i_dataout;
	wire	wire_ni1l1l_dataout;
	wire	wire_ni1l1O_dataout;
	wire	wire_ni1lii_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1lll_dataout;
	wire	wire_ni1llO_dataout;
	wire	wire_ni1lOi_dataout;
	wire	wire_ni1lOl_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1O0i_dataout;
	wire	wire_ni1O0l_dataout;
	wire	wire_ni1O0O_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1O1l_dataout;
	wire	wire_ni1O1O_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1Oil_dataout;
	wire	wire_ni1OiO_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OlO_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_ni1OOi_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii01i_dataout;
	wire	wire_nii01l_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii10i_dataout;
	wire	wire_nii10l_dataout;
	wire	wire_nii10O_dataout;
	wire	wire_nii11i_dataout;
	wire	wire_nii11l_dataout;
	wire	wire_nii11O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1ii_dataout;
	wire	wire_nii1il_dataout;
	wire	wire_nii1iO_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1li_dataout;
	wire	wire_nii1ll_dataout;
	wire	wire_nii1lO_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_nii1Oi_dataout;
	wire	wire_nii1Ol_dataout;
	wire	wire_nii1OO_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil00i_dataout;
	wire	wire_nil00l_dataout;
	wire	wire_nil00O_dataout;
	wire	wire_nil01i_dataout;
	wire	wire_nil01l_dataout;
	wire	wire_nil01O_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0ii_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nil1ii_dataout;
	wire	wire_nil1il_dataout;
	wire	wire_nil1iO_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1li_dataout;
	wire	wire_nil1ll_dataout;
	wire	wire_nil1lO_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nil1Oi_dataout;
	wire	wire_nil1Ol_dataout;
	wire	wire_nil1OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili0O_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_nilii_dataout;
	wire	wire_niliii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilil_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliO_dataout;
	wire	wire_niliOi_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilliO_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillli_dataout;
	wire	wire_nillll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilO1l_dataout;
	wire	wire_nilO1O_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO0Ol_dataout;
	wire	wire_niO0OO_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1i_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOl1O_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl00il_dataout;
	wire	wire_nl00iO_dataout;
	wire	wire_nl00lO_dataout;
	wire	wire_nl00OO_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl011i_dataout;
	wire	wire_nl011l_dataout;
	wire	wire_nl011O_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0i1l_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0iiO_dataout;
	wire	wire_nl0ili_dataout;
	wire	wire_nl0iOi_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l0i_dataout;
	wire	wire_nl0l0O_dataout;
	wire	wire_nl0l1i_dataout;
	wire	wire_nl0l1O_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0O0l_dataout;
	wire	wire_nl0O1i_dataout;
	wire	wire_nl0Oll_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1iil_dataout;
	wire	wire_nl1iiO_dataout;
	wire	wire_nl1ili_dataout;
	wire	wire_nl1ill_dataout;
	wire	wire_nl1ilO_dataout;
	wire	wire_nl1iOi_dataout;
	wire	wire_nl1iOl_dataout;
	wire	wire_nl1iOO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l0i_dataout;
	wire	wire_nl1l0l_dataout;
	wire	wire_nl1l0O_dataout;
	wire	wire_nl1l1i_dataout;
	wire	wire_nl1l1l_dataout;
	wire	wire_nl1l1O_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O0l_dataout;
	wire	wire_nl1O0O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1OiO_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1Oll_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0lO_dataout;
	wire	wire_nli10Ol_dataout;
	wire	wire_nli10OO_dataout;
	wire	wire_nli11i_dataout;
	wire	wire_nli11l_dataout;
	wire	wire_nli1i0i_dataout;
	wire	wire_nli1i1O_dataout;
	wire	wire_nli1iii_dataout;
	wire	wire_nli1iil_dataout;
	wire	wire_nli1iiO_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1ili_dataout;
	wire	wire_nli1ill_dataout;
	wire	wire_nli1ilO_dataout;
	wire	wire_nli1iOi_dataout;
	wire	wire_nli1iOl_dataout;
	wire	wire_nli1iOO_dataout;
	wire	wire_nli1l0i_dataout;
	wire	wire_nli1l0l_dataout;
	wire	wire_nli1l0O_dataout;
	wire	wire_nli1l1i_dataout;
	wire	wire_nli1l1l_dataout;
	wire	wire_nli1l1O_dataout;
	wire	wire_nli1lii_dataout;
	wire	wire_nli1O0i_dataout;
	wire	wire_nli1O0l_dataout;
	wire	wire_nli1O0O_dataout;
	wire	wire_nli1O1l_dataout;
	wire	wire_nli1O1O_dataout;
	wire	wire_nli1Oii_dataout;
	wire	wire_nli1Oil_dataout;
	wire	wire_nli1OiO_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlii1i_dataout;
	wire	wire_nliiil_dataout;
	wire	wire_nliill_dataout;
	wire	wire_nliiOO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0i_dataout;
	wire	wire_nlil0l_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nlO0lO_dataout;
	wire	wire_nlO0Oi_dataout;
	wire	wire_nlO0OO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOi0i_dataout;
	wire	wire_nlOi0l_dataout;
	wire	wire_nlOi0O_dataout;
	wire	wire_nlOi1i_dataout;
	wire	wire_nlOiii_dataout;
	wire	wire_nlOiil_dataout;
	wire	wire_nlOiiO_dataout;
	wire	wire_nlOili_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllO_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOil_dataout;
	wire	wire_nlOOiO_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOli_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nlOOOi_dataout;
	wire  [3:0]   wire_nil0il_o;
	wire  [7:0]   wire_nilill_o;
	wire  [15:0]   wire_nillOl_o;
	wire  [255:0]   wire_nl0lO1O_o;
	wire  [255:0]   wire_nl0lOii_o;
	wire  [63:0]   wire_nl10i_o;
	wire  [63:0]   wire_nll0i_o;
	wire  wire_n1000i_o;
	wire  wire_n1000l_o;
	wire  wire_n1000O_o;
	wire  wire_n1001i_o;
	wire  wire_n1001l_o;
	wire  wire_n1001O_o;
	wire  wire_n100ii_o;
	wire  wire_n100il_o;
	wire  wire_n100iO_o;
	wire  wire_n100li_o;
	wire  wire_n100ll_o;
	wire  wire_n100lO_o;
	wire  wire_n100Oi_o;
	wire  wire_n100Ol_o;
	wire  wire_n100OO_o;
	wire  wire_n101iO_o;
	wire  wire_n101li_o;
	wire  wire_n101ll_o;
	wire  wire_n101lO_o;
	wire  wire_n101Oi_o;
	wire  wire_n101Ol_o;
	wire  wire_n101OO_o;
	wire  wire_n10i0i_o;
	wire  wire_n10i0l_o;
	wire  wire_n10i0O_o;
	wire  wire_n10i1i_o;
	wire  wire_n10i1l_o;
	wire  wire_n10i1O_o;
	wire  wire_n10iii_o;
	wire  wire_n10iil_o;
	wire  wire_n10iiO_o;
	wire  wire_n10ili_o;
	wire  wire_n10ill_o;
	wire  wire_n10ilO_o;
	wire  wire_n10iOi_o;
	wire  wire_n10iOl_o;
	wire  wire_n10iOO_o;
	wire  wire_n10l0i_o;
	wire  wire_n10l0l_o;
	wire  wire_n10l0O_o;
	wire  wire_n10l1i_o;
	wire  wire_n10l1l_o;
	wire  wire_n10l1O_o;
	wire  wire_n10lii_o;
	wire  wire_n10lil_o;
	wire  wire_n10liO_o;
	wire  wire_n10lli_o;
	wire  wire_n10lll_o;
	wire  wire_n10llO_o;
	wire  wire_n10lOi_o;
	wire  wire_n10lOl_o;
	wire  wire_n10lOO_o;
	wire  wire_n10O0i_o;
	wire  wire_n10O0l_o;
	wire  wire_n10O0O_o;
	wire  wire_n10O1i_o;
	wire  wire_n10O1l_o;
	wire  wire_n10O1O_o;
	wire  wire_n10Oii_o;
	wire  wire_n10Oil_o;
	wire  wire_n10OiO_o;
	wire  wire_n10Oli_o;
	wire  wire_n10Oll_o;
	wire  wire_n10OlO_o;
	wire  wire_nii00i_o;
	wire  wire_nii00l_o;
	wire  wire_nii00O_o;
	wire  wire_nii01O_o;
	wire  wire_nii0ii_o;
	wire  wire_nii0il_o;
	wire  wire_nii0iO_o;
	wire  wire_nii0li_o;
	wire  wire_nii0ll_o;
	wire  wire_nii0lO_o;
	wire  wire_nii0Oi_o;
	wire  wire_nii0Ol_o;
	wire  wire_nii0OO_o;
	wire  wire_niii0i_o;
	wire  wire_niii0l_o;
	wire  wire_niii0O_o;
	wire  wire_niii1i_o;
	wire  wire_niii1l_o;
	wire  wire_niii1O_o;
	wire  wire_niiiii_o;
	wire  wire_niiiil_o;
	wire  wire_niiiiO_o;
	wire  wire_niiili_o;
	wire  wire_niiill_o;
	wire  wire_niiilO_o;
	wire  wire_niiiOi_o;
	wire  wire_niiiOl_o;
	wire  wire_niiiOO_o;
	wire  wire_niil0i_o;
	wire  wire_niil0l_o;
	wire  wire_niil0O_o;
	wire  wire_niil1i_o;
	wire  wire_niil1l_o;
	wire  wire_niil1O_o;
	wire  wire_niilii_o;
	wire  wire_niilil_o;
	wire  wire_niiliO_o;
	wire  wire_niilli_o;
	wire  wire_niilll_o;
	wire  wire_niillO_o;
	wire  wire_niilOi_o;
	wire  wire_niilOl_o;
	wire  wire_niilOO_o;
	wire  wire_niiO0i_o;
	wire  wire_niiO0l_o;
	wire  wire_niiO0O_o;
	wire  wire_niiO1i_o;
	wire  wire_niiO1l_o;
	wire  wire_niiO1O_o;
	wire  wire_niiOii_o;
	wire  wire_niiOil_o;
	wire  wire_niiOiO_o;
	wire  wire_niiOli_o;
	wire  wire_niiOll_o;
	wire  wire_niiOlO_o;
	wire  wire_niiOOi_o;
	wire  wire_niiOOl_o;
	wire  wire_niiOOO_o;
	wire  wire_nil10i_o;
	wire  wire_nil10l_o;
	wire  wire_nil10O_o;
	wire  wire_nil11i_o;
	wire  wire_nil11l_o;
	wire  wire_nil11O_o;
	wire  wire_nili0i_o;
	wire  wire_nillii_o;
	wire  wire_niOl0i_o;
	wire  wire_niOl0l_o;
	wire  wire_niOl0O_o;
	wire  wire_niOlii_o;
	wire  wire_niOlil_o;
	wire  wire_niOliO_o;
	wire  wire_niOlli_o;
	wire  wire_niOlll_o;
	wire  wire_niOllO_o;
	wire  wire_niOlOi_o;
	wire  wire_niOlOl_o;
	wire  wire_niOlOO_o;
	wire  wire_niOO0i_o;
	wire  wire_niOO0l_o;
	wire  wire_niOO0O_o;
	wire  wire_niOO1i_o;
	wire  wire_niOO1l_o;
	wire  wire_niOO1O_o;
	wire  wire_niOOii_o;
	wire  wire_niOOil_o;
	wire  wire_niOOiO_o;
	wire  wire_niOOli_o;
	wire  wire_niOOll_o;
	wire  wire_niOOlO_o;
	wire  wire_niOOOi_o;
	wire  wire_niOOOl_o;
	wire  wire_niOOOO_o;
	wire  wire_nl001i_o;
	wire  wire_nl001l_o;
	wire  wire_nl001O_o;
	wire  wire_nl010l_o;
	wire  wire_nl01OO_o;
	wire  wire_nl100i_o;
	wire  wire_nl100l_o;
	wire  wire_nl100O_o;
	wire  wire_nl101i_o;
	wire  wire_nl101l_o;
	wire  wire_nl101O_o;
	wire  wire_nl10ii_o;
	wire  wire_nl10il_o;
	wire  wire_nl10iO_o;
	wire  wire_nl10li_o;
	wire  wire_nl10ll_o;
	wire  wire_nl10lO_o;
	wire  wire_nl10Oi_o;
	wire  wire_nl10Ol_o;
	wire  wire_nl10OO_o;
	wire  wire_nl110i_o;
	wire  wire_nl110l_o;
	wire  wire_nl110O_o;
	wire  wire_nl111i_o;
	wire  wire_nl111l_o;
	wire  wire_nl111O_o;
	wire  wire_nl11ii_o;
	wire  wire_nl11il_o;
	wire  wire_nl11iO_o;
	wire  wire_nl11li_o;
	wire  wire_nl11ll_o;
	wire  wire_nl11lO_o;
	wire  wire_nl11Oi_o;
	wire  wire_nl11Ol_o;
	wire  wire_nl11OO_o;
	wire  wire_nl1i0i_o;
	wire  wire_nl1i0l_o;
	wire  wire_nl1i0O_o;
	wire  wire_nl1i1i_o;
	wire  wire_nl1i1l_o;
	wire  wire_nl1i1O_o;
	wire  wire_nl1iii_o;
	wire  wire_nl1O0i_o;
	wire  wire_niOil_o;
	wire  wire_nliil_o;
	wire  [64:0]   wire_nl0l0OO_data_out;
	wire  [1:0]   wire_nl0l0Ol_byte_des_bo_3g_start;
	wire  [63:0]   wire_nl0l0Ol_byte_des_fifo_data_in;
	wire  nl000ii;
	wire  nl000li;
	wire  nl000ll;
	wire  nl000lO;
	wire  nl000Oi;
	wire  nl00i0i;
	wire  nl00i0l;
	wire  nl00i0O;
	wire  nl00i1i;
	wire  nl00i1l;
	wire  nl00i1O;
	wire  nl00iii;
	wire  nl00iil;
	wire  nl00iiO;
	wire  nl00ili;
	wire  nl00ill;
	wire  nl00ilO;
	wire  nl00iOi;
	wire  nl00iOl;
	wire  nl00iOO;
	wire  nl00l0i;
	wire  nl00l0l;
	wire  nl00l0O;
	wire  nl00l1i;
	wire  nl00l1l;
	wire  nl00l1O;
	wire  nl00lii;
	wire  nl00lil;
	wire  nl00liO;
	wire  nl00lli;
	wire  nl00lll;
	wire  nl00llO;
	wire  nl00lOi;
	wire  nl00lOl;
	wire  nl00lOO;
	wire  nl00O0i;
	wire  nl00O0l;
	wire  nl00O0O;
	wire  nl00O1i;
	wire  nl00O1l;
	wire  nl00O1O;
	wire  nl00Oii;
	wire  nl00Oil;
	wire  nl00OiO;
	wire  nl00Oli;
	wire  nl00Oll;
	wire  nl00OlO;
	wire  nl00OOi;
	wire  nl00OOl;
	wire  nl00OOO;
	wire  nl0i00i;
	wire  nl0i00l;
	wire  nl0i00O;
	wire  nl0i01i;
	wire  nl0i01l;
	wire  nl0i0ii;
	wire  nl0i0il;
	wire  nl0i0iO;
	wire  nl0i0li;
	wire  nl0i0ll;
	wire  nl0i0lO;
	wire  nl0i0Oi;
	wire  nl0i0Ol;
	wire  nl0i0OO;
	wire  nl0i10i;
	wire  nl0i10l;
	wire  nl0i10O;
	wire  nl0i11i;
	wire  nl0i11l;
	wire  nl0i11O;
	wire  nl0i1li;
	wire  nl0i1ll;
	wire  nl0i1lO;
	wire  nl0i1Oi;
	wire  nl0i1Ol;
	wire  nl0i1OO;
	wire  nl0ii0i;
	wire  nl0ii0l;
	wire  nl0ii0O;
	wire  nl0ii1i;
	wire  nl0ii1l;
	wire  nl0ii1O;
	wire  nl0iiii;
	wire  nl0iiil;
	wire  nl0iiiO;
	wire  nl0iili;
	wire  nl0iill;
	wire  nl0iilO;
	wire  nl0iiOi;
	wire  nl0iiOl;
	wire  nl0iiOO;
	wire  nl0il0i;
	wire  nl0il0l;
	wire  nl0il0O;
	wire  nl0il1i;
	wire  nl0il1l;
	wire  nl0il1O;
	wire  nl0ilii;
	wire  nl0ilil;
	wire  nl0iliO;
	wire  nl0illO;
	wire  nl0ilOO;
	wire  nl0iO0O;
	wire  nl0iO1O;
	wire  nl0iOli;
	wire  nl0iOll;
	wire  nl0iOOl;
	wire  nl0iOOO;
	wire  nl0l00O;
	wire  nl0l0iO;
	wire  nl0l11l;
	wire  nl0l11O;
	wire  nl0l1OO;

	initial
		nl0000i61 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0000i61 <= nl0000i62;
	event nl0000i61_event;
	initial
		#1 ->nl0000i61_event;
	always @(nl0000i61_event)
		nl0000i61 <= {1{1'b1}};
	initial
		nl0000i62 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0000i62 <= nl0000i61;
	initial
		nl0000l59 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0000l59 <= nl0000l60;
	event nl0000l59_event;
	initial
		#1 ->nl0000l59_event;
	always @(nl0000l59_event)
		nl0000l59 <= {1{1'b1}};
	initial
		nl0000l60 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0000l60 <= nl0000l59;
	initial
		nl0000O57 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0000O57 <= nl0000O58;
	event nl0000O57_event;
	initial
		#1 ->nl0000O57_event;
	always @(nl0000O57_event)
		nl0000O57 <= {1{1'b1}};
	initial
		nl0000O58 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0000O58 <= nl0000O57;
	initial
		nl000il55 = 0;
	always @ ( posedge rx_wr_clk)
		  nl000il55 <= nl000il56;
	event nl000il55_event;
	initial
		#1 ->nl000il55_event;
	always @(nl000il55_event)
		nl000il55 <= {1{1'b1}};
	initial
		nl000il56 = 0;
	always @ ( posedge rx_wr_clk)
		  nl000il56 <= nl000il55;
	initial
		nl000iO53 = 0;
	always @ ( posedge rx_wr_clk)
		  nl000iO53 <= nl000iO54;
	event nl000iO53_event;
	initial
		#1 ->nl000iO53_event;
	always @(nl000iO53_event)
		nl000iO53 <= {1{1'b1}};
	initial
		nl000iO54 = 0;
	always @ ( posedge rx_wr_clk)
		  nl000iO54 <= nl000iO53;
	initial
		nl000Ol51 = 0;
	always @ ( posedge rx_wr_clk)
		  nl000Ol51 <= nl000Ol52;
	event nl000Ol51_event;
	initial
		#1 ->nl000Ol51_event;
	always @(nl000Ol51_event)
		nl000Ol51 <= {1{1'b1}};
	initial
		nl000Ol52 = 0;
	always @ ( posedge rx_wr_clk)
		  nl000Ol52 <= nl000Ol51;
	initial
		nl000OO49 = 0;
	always @ ( posedge rx_wr_clk)
		  nl000OO49 <= nl000OO50;
	event nl000OO49_event;
	initial
		#1 ->nl000OO49_event;
	always @(nl000OO49_event)
		nl000OO49 <= {1{1'b1}};
	initial
		nl000OO50 = 0;
	always @ ( posedge rx_wr_clk)
		  nl000OO50 <= nl000OO49;
	initial
		nl0i01O41 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0i01O41 <= nl0i01O42;
	event nl0i01O41_event;
	initial
		#1 ->nl0i01O41_event;
	always @(nl0i01O41_event)
		nl0i01O41 <= {1{1'b1}};
	initial
		nl0i01O42 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0i01O42 <= nl0i01O41;
	initial
		nl0i1ii47 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0i1ii47 <= nl0i1ii48;
	event nl0i1ii47_event;
	initial
		#1 ->nl0i1ii47_event;
	always @(nl0i1ii47_event)
		nl0i1ii47 <= {1{1'b1}};
	initial
		nl0i1ii48 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0i1ii48 <= nl0i1ii47;
	initial
		nl0i1il45 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0i1il45 <= nl0i1il46;
	event nl0i1il45_event;
	initial
		#1 ->nl0i1il45_event;
	always @(nl0i1il45_event)
		nl0i1il45 <= {1{1'b1}};
	initial
		nl0i1il46 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0i1il46 <= nl0i1il45;
	initial
		nl0i1iO43 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0i1iO43 <= nl0i1iO44;
	event nl0i1iO43_event;
	initial
		#1 ->nl0i1iO43_event;
	always @(nl0i1iO43_event)
		nl0i1iO43 <= {1{1'b1}};
	initial
		nl0i1iO44 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0i1iO44 <= nl0i1iO43;
	initial
		nl0illi39 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0illi39 <= nl0illi40;
	event nl0illi39_event;
	initial
		#1 ->nl0illi39_event;
	always @(nl0illi39_event)
		nl0illi39 <= {1{1'b1}};
	initial
		nl0illi40 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0illi40 <= nl0illi39;
	initial
		nl0ilOi37 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0ilOi37 <= nl0ilOi38;
	event nl0ilOi37_event;
	initial
		#1 ->nl0ilOi37_event;
	always @(nl0ilOi37_event)
		nl0ilOi37 <= {1{1'b1}};
	initial
		nl0ilOi38 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0ilOi38 <= nl0ilOi37;
	initial
		nl0iO0i33 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iO0i33 <= nl0iO0i34;
	event nl0iO0i33_event;
	initial
		#1 ->nl0iO0i33_event;
	always @(nl0iO0i33_event)
		nl0iO0i33 <= {1{1'b1}};
	initial
		nl0iO0i34 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iO0i34 <= nl0iO0i33;
	initial
		nl0iO1i35 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iO1i35 <= nl0iO1i36;
	event nl0iO1i35_event;
	initial
		#1 ->nl0iO1i35_event;
	always @(nl0iO1i35_event)
		nl0iO1i35 <= {1{1'b1}};
	initial
		nl0iO1i36 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iO1i36 <= nl0iO1i35;
	initial
		nl0iOii31 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOii31 <= nl0iOii32;
	event nl0iOii31_event;
	initial
		#1 ->nl0iOii31_event;
	always @(nl0iOii31_event)
		nl0iOii31 <= {1{1'b1}};
	initial
		nl0iOii32 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOii32 <= nl0iOii31;
	initial
		nl0iOil29 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOil29 <= nl0iOil30;
	event nl0iOil29_event;
	initial
		#1 ->nl0iOil29_event;
	always @(nl0iOil29_event)
		nl0iOil29 <= {1{1'b1}};
	initial
		nl0iOil30 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOil30 <= nl0iOil29;
	initial
		nl0iOlO27 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOlO27 <= nl0iOlO28;
	event nl0iOlO27_event;
	initial
		#1 ->nl0iOlO27_event;
	always @(nl0iOlO27_event)
		nl0iOlO27 <= {1{1'b1}};
	initial
		nl0iOlO28 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOlO28 <= nl0iOlO27;
	initial
		nl0l00i5 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l00i5 <= nl0l00i6;
	event nl0l00i5_event;
	initial
		#1 ->nl0l00i5_event;
	always @(nl0l00i5_event)
		nl0l00i5 <= {1{1'b1}};
	initial
		nl0l00i6 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l00i6 <= nl0l00i5;
	initial
		nl0l01i11 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l01i11 <= nl0l01i12;
	event nl0l01i11_event;
	initial
		#1 ->nl0l01i11_event;
	always @(nl0l01i11_event)
		nl0l01i11 <= {1{1'b1}};
	initial
		nl0l01i12 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l01i12 <= nl0l01i11;
	initial
		nl0l01l10 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l01l10 <= nl0l01l9;
	initial
		nl0l01l9 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l01l9 <= nl0l01l10;
	event nl0l01l9_event;
	initial
		#1 ->nl0l01l9_event;
	always @(nl0l01l9_event)
		nl0l01l9 <= {1{1'b1}};
	initial
		nl0l01O7 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l01O7 <= nl0l01O8;
	event nl0l01O7_event;
	initial
		#1 ->nl0l01O7_event;
	always @(nl0l01O7_event)
		nl0l01O7 <= {1{1'b1}};
	initial
		nl0l01O8 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l01O8 <= nl0l01O7;
	initial
		nl0l0ii3 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l0ii3 <= nl0l0ii4;
	event nl0l0ii3_event;
	initial
		#1 ->nl0l0ii3_event;
	always @(nl0l0ii3_event)
		nl0l0ii3 <= {1{1'b1}};
	initial
		nl0l0ii4 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l0ii4 <= nl0l0ii3;
	initial
		nl0l0li1 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l0li1 <= nl0l0li2;
	event nl0l0li1_event;
	initial
		#1 ->nl0l0li1_event;
	always @(nl0l0li1_event)
		nl0l0li1 <= {1{1'b1}};
	initial
		nl0l0li2 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l0li2 <= nl0l0li1;
	initial
		nl0l10i23 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l10i23 <= nl0l10i24;
	event nl0l10i23_event;
	initial
		#1 ->nl0l10i23_event;
	always @(nl0l10i23_event)
		nl0l10i23 <= {1{1'b1}};
	initial
		nl0l10i24 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l10i24 <= nl0l10i23;
	initial
		nl0l10O21 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l10O21 <= nl0l10O22;
	event nl0l10O21_event;
	initial
		#1 ->nl0l10O21_event;
	always @(nl0l10O21_event)
		nl0l10O21 <= {1{1'b1}};
	initial
		nl0l10O22 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l10O22 <= nl0l10O21;
	initial
		nl0l11i25 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l11i25 <= nl0l11i26;
	event nl0l11i25_event;
	initial
		#1 ->nl0l11i25_event;
	always @(nl0l11i25_event)
		nl0l11i25 <= {1{1'b1}};
	initial
		nl0l11i26 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l11i26 <= nl0l11i25;
	initial
		nl0l1il19 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1il19 <= nl0l1il20;
	event nl0l1il19_event;
	initial
		#1 ->nl0l1il19_event;
	always @(nl0l1il19_event)
		nl0l1il19 <= {1{1'b1}};
	initial
		nl0l1il20 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1il20 <= nl0l1il19;
	initial
		nl0l1iO17 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1iO17 <= nl0l1iO18;
	event nl0l1iO17_event;
	initial
		#1 ->nl0l1iO17_event;
	always @(nl0l1iO17_event)
		nl0l1iO17 <= {1{1'b1}};
	initial
		nl0l1iO18 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1iO18 <= nl0l1iO17;
	initial
		nl0l1ll15 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1ll15 <= nl0l1ll16;
	event nl0l1ll15_event;
	initial
		#1 ->nl0l1ll15_event;
	always @(nl0l1ll15_event)
		nl0l1ll15 <= {1{1'b1}};
	initial
		nl0l1ll16 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1ll16 <= nl0l1ll15;
	initial
		nl0l1Oi13 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1Oi13 <= nl0l1Oi14;
	event nl0l1Oi13_event;
	initial
		#1 ->nl0l1Oi13_event;
	always @(nl0l1Oi13_event)
		nl0l1Oi13 <= {1{1'b1}};
	initial
		nl0l1Oi14 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1Oi14 <= nl0l1Oi13;
	initial
	begin
		n110i = 0;
		n111i = 0;
	end
	always @ (rx_wr_clk or wire_n111O_PRN or wire_n111O_CLRN)
	begin
		if (wire_n111O_PRN == 1'b0) 
		begin
			n110i <= 1;
			n111i <= 1;
		end
		else if  (wire_n111O_CLRN == 1'b0) 
		begin
			n110i <= 0;
			n111i <= 0;
		end
		else 
		if (rx_wr_clk != n111O_clk_prev && rx_wr_clk == 1'b1) 
		begin
			n110i <= nl0i1li;
			n111i <= n110i;
		end
		n111O_clk_prev <= rx_wr_clk;
	end
	assign
		wire_n111O_CLRN = (nl0i1iO44 ^ nl0i1iO43),
		wire_n111O_PRN = ((nl0i1il46 ^ nl0i1il45) & (~ nl0l0iO));
	initial
	begin
		n11OOl = 0;
	end
	always @ (clk_2 or wire_n11OOi_PRN or wire_n11OOi_CLRN)
	begin
		if (wire_n11OOi_PRN == 1'b0) 
		begin
			n11OOl <= 1;
		end
		else if  (wire_n11OOi_CLRN == 1'b0) 
		begin
			n11OOl <= 0;
		end
		else 
		if (clk_2 != n11OOi_clk_prev && clk_2 == 1'b1) 
		begin
			n11OOl <= wire_n1011i_dataout;
		end
		n11OOi_clk_prev <= clk_2;
	end
	assign
		wire_n11OOi_CLRN = (nl000OO50 ^ nl000OO49),
		wire_n11OOi_PRN = ((nl000Ol52 ^ nl000Ol51) & (~ soft_reset));
	initial
	begin
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n1010O = 0;
		n101i = 0;
		n101l = 0;
		n101O = 0;
		n10ii = 0;
		n10il = 0;
		n10iO = 0;
		n10li = 0;
		n10ll = 0;
		n10lO = 0;
		n10Oi = 0;
		n10Ol = 0;
		n10OO = 0;
		n110l = 0;
		n110O = 0;
		n11ii = 0;
		n11il = 0;
		n11iO = 0;
		n11li = 0;
		n11ll = 0;
		n11lO = 0;
		n11Oi = 0;
		n11Ol = 0;
		n11Oll = 0;
		n11OlO = 0;
		n11OO = 0;
		n1i0i = 0;
		n1i0l = 0;
		n1i0O = 0;
		n1i1i = 0;
		n1i1l = 0;
		n1i1O = 0;
		n1iii = 0;
		n1iil = 0;
		n1iiO = 0;
		n1ili = 0;
		n1ill = 0;
		n1ilO = 0;
		n1iOi = 0;
		n1iOl = 0;
		n1iOO = 0;
		n1l1i = 0;
		n1l1O = 0;
	end
	always @ ( posedge clk_2 or  negedge wire_n1l1l_CLRN)
	begin
		if (wire_n1l1l_CLRN == 1'b0) 
		begin
			n100i <= 0;
			n100l <= 0;
			n100O <= 0;
			n1010O <= 0;
			n101i <= 0;
			n101l <= 0;
			n101O <= 0;
			n10ii <= 0;
			n10il <= 0;
			n10iO <= 0;
			n10li <= 0;
			n10ll <= 0;
			n10lO <= 0;
			n10Oi <= 0;
			n10Ol <= 0;
			n10OO <= 0;
			n110l <= 0;
			n110O <= 0;
			n11ii <= 0;
			n11il <= 0;
			n11iO <= 0;
			n11li <= 0;
			n11ll <= 0;
			n11lO <= 0;
			n11Oi <= 0;
			n11Ol <= 0;
			n11Oll <= 0;
			n11OlO <= 0;
			n11OO <= 0;
			n1i0i <= 0;
			n1i0l <= 0;
			n1i0O <= 0;
			n1i1i <= 0;
			n1i1l <= 0;
			n1i1O <= 0;
			n1iii <= 0;
			n1iil <= 0;
			n1iiO <= 0;
			n1ili <= 0;
			n1ill <= 0;
			n1ilO <= 0;
			n1iOi <= 0;
			n1iOl <= 0;
			n1iOO <= 0;
			n1l1i <= 0;
			n1l1O <= 0;
		end
		else 
		begin
			n100i <= nl0il1O;
			n100l <= nl0iiii;
			n100O <= nl0iill;
			n1010O <= wire_n1010i_dataout;
			n101i <= (((((nl0i1Oi | nl0i1lO) & rsync_comp_porn) & (nl0ilil | nl0iliO)) | nl0i1ll) & n101l);
			n101l <= nl0iiOO;
			n101O <= (((((nl0i01i | nl0i1OO) & rsync_comp_porn) & (nl0iOli | nl0l00O)) | nl0i1Ol) & n100i);
			n10ii <= nl0iiOO;
			n10il <= nl0il1O;
			n10iO <= n10ll;
			n10li <= n10lO;
			n10ll <= wire_nliil_o;
			n10lO <= wire_niOil_o;
			n10Oi <= (n10OO & nl0l00O);
			n10Ol <= (n1i1i & nl0iiOi);
			n10OO <= (n1i1l & nl0iOll);
			n110l <= dec_data_valid[0];
			n110O <= dec_data_valid[1];
			n11ii <= wire_n1O0l_dataout;
			n11il <= n11lO;
			n11iO <= n11Oi;
			n11li <= n11Ol;
			n11ll <= n11OO;
			n11lO <= ovr_undflow[0];
			n11Oi <= ovr_undflow[1];
			n11Ol <= ovr_undflow[2];
			n11Oll <= n11OlO;
			n11OlO <= nl0i01l;
			n11OO <= ovr_undflow[3];
			n1i0i <= n1i0O;
			n1i0l <= n1iii;
			n1i0O <= disp_val_delay[0];
			n1i1i <= (n1i1O & nl0il0i);
			n1i1l <= nl0iOll;
			n1i1O <= nl0il0i;
			n1iii <= disp_val_delay[1];
			n1iil <= n1ili;
			n1iiO <= n1ill;
			n1ili <= disp_err_delay[0];
			n1ill <= disp_err_delay[1];
			n1ilO <= n1iOl;
			n1iOi <= n1iOO;
			n1iOl <= sync_resync_delay[0];
			n1iOO <= sync_resync_delay[1];
			n1l1i <= signal_detect_sync_st;
			n1l1O <= n1l1i;
		end
	end
	assign
		wire_n1l1l_CLRN = ((nl0i01O42 ^ nl0i01O41) & (~ soft_reset));
	initial
	begin
		nl0OlOi = 0;
	end
	always @ (rx_rd_clk or wire_nl0OllO_PRN or wire_nl0OllO_CLRN)
	begin
		if (wire_nl0OllO_PRN == 1'b0) 
		begin
			nl0OlOi <= 1;
		end
		else if  (wire_nl0OllO_CLRN == 1'b0) 
		begin
			nl0OlOi <= 0;
		end
		else if  (wire_nl0OllO_ENA == 1'b1) 
		if (rx_rd_clk != nl0OllO_clk_prev && rx_rd_clk == 1'b1) 
		begin
			nl0OlOi <= nl0i1li;
		end
		nl0OllO_clk_prev <= rx_rd_clk;
	end
	assign
		wire_nl0OllO_ENA = (nlO0ll & nl0OlOi),
		wire_nl0OllO_CLRN = (nl0000l60 ^ nl0000l59),
		wire_nl0OllO_PRN = ((nl0000i62 ^ nl0000i61) & (~ wire_nlOOOi_dataout));
	initial
	begin
		nl0OO0l = 0;
		nl0OOOi = 0;
		nli101i = 0;
		nli10li = 0;
		nli11ii = 0;
	end
	always @ ( posedge rx_rd_clk or  negedge wire_nli10iO_PRN)
	begin
		if (wire_nli10iO_PRN == 1'b0) 
		begin
			nl0OO0l <= 1;
			nl0OOOi <= 1;
			nli101i <= 1;
			nli10li <= 1;
			nli11ii <= 1;
		end
		else 
		begin
			nl0OO0l <= nl0OOOi;
			nl0OOOi <= nli110O;
			nli101i <= nli10li;
			nli10li <= wire_nl0lOii_o[2];
			nli11ii <= wire_nli1ilO_dataout;
		end
	end
	assign
		wire_nli10iO_PRN = ((nl0000O58 ^ nl0000O57) & (~ wire_nlOOOi_dataout));
	initial
	begin
		nli10Oi = 0;
	end
	always @ (rx_wr_clk or wire_nli10lO_PRN or wire_nli10lO_CLRN)
	begin
		if (wire_nli10lO_PRN == 1'b0) 
		begin
			nli10Oi <= 1;
		end
		else if  (wire_nli10lO_CLRN == 1'b0) 
		begin
			nli10Oi <= 0;
		end
		else 
		if (rx_wr_clk != nli10lO_clk_prev && rx_wr_clk == 1'b1) 
		begin
			nli10Oi <= wire_nli1O1l_dataout;
		end
		nli10lO_clk_prev <= rx_wr_clk;
	end
	assign
		wire_nli10lO_CLRN = (nl000iO54 ^ nl000iO53),
		wire_nli10lO_PRN = ((nl000il56 ^ nl000il55) & (~ wire_n111l_dataout));
	initial
	begin
		nl0llOi = 0;
		nl0lOil = 0;
		nl0lOiO = 0;
		nl0lOli = 0;
		nl0lOll = 0;
		nl0lOlO = 0;
		nl0lOOi = 0;
		nl0lOOl = 0;
		nl0lOOO = 0;
		nl0O00i = 0;
		nl0O00l = 0;
		nl0O00O = 0;
		nl0O01i = 0;
		nl0O01l = 0;
		nl0O01O = 0;
		nl0O0ii = 0;
		nl0O0il = 0;
		nl0O0iO = 0;
		nl0O0li = 0;
		nl0O0ll = 0;
		nl0O0lO = 0;
		nl0O0Oi = 0;
		nl0O0Ol = 0;
		nl0O0OO = 0;
		nl0O10i = 0;
		nl0O10l = 0;
		nl0O10O = 0;
		nl0O11i = 0;
		nl0O11l = 0;
		nl0O11O = 0;
		nl0O1ii = 0;
		nl0O1il = 0;
		nl0O1iO = 0;
		nl0O1li = 0;
		nl0O1ll = 0;
		nl0O1lO = 0;
		nl0O1Oi = 0;
		nl0O1Ol = 0;
		nl0O1OO = 0;
		nl0Oi0i = 0;
		nl0Oi0l = 0;
		nl0Oi0O = 0;
		nl0Oi1i = 0;
		nl0Oi1l = 0;
		nl0Oi1O = 0;
		nl0Oiii = 0;
		nl0Oiil = 0;
		nl0OiiO = 0;
		nl0Oili = 0;
		nl0Oill = 0;
		nl0OilO = 0;
		nl0OiOi = 0;
		nl0OiOl = 0;
		nl0OiOO = 0;
		nl0Ol0i = 0;
		nl0Ol0l = 0;
		nl0Ol0O = 0;
		nl0Ol1i = 0;
		nl0Ol1l = 0;
		nl0Ol1O = 0;
		nl0Olii = 0;
		nl0Olil = 0;
		nl0OliO = 0;
		nl0Olli = 0;
		nl0Olll = 0;
		nl0OlOl = 0;
		nl0OlOO = 0;
		nl0OO0i = 0;
		nl0OO0O = 0;
		nl0OO1i = 0;
		nl0OO1l = 0;
		nl0OO1O = 0;
		nl0OOii = 0;
		nl0OOil = 0;
		nl0OOiO = 0;
		nl0OOli = 0;
		nl0OOll = 0;
		nl0OOlO = 0;
		nl0OOOl = 0;
		nl0OOOO = 0;
		nli100i = 0;
		nli100l = 0;
		nli100O = 0;
		nli101l = 0;
		nli101O = 0;
		nli10ii = 0;
		nli10il = 0;
		nli10ll = 0;
		nli110i = 0;
		nli110l = 0;
		nli110O = 0;
		nli111i = 0;
		nli111l = 0;
		nli111O = 0;
		nli11il = 0;
		nli11iO = 0;
		nli11li = 0;
		nli11ll = 0;
		nli11lO = 0;
		nli11Oi = 0;
		nli11Ol = 0;
		nli11OO = 0;
		nlO0ll = 0;
		nlOl0l = 0;
		nlOl0O = 0;
		nlOlil = 0;
	end
	always @ ( posedge rx_rd_clk or  posedge wire_nlOOOi_dataout)
	begin
		if (wire_nlOOOi_dataout == 1'b1) 
		begin
			nl0llOi <= 0;
			nl0lOil <= 0;
			nl0lOiO <= 0;
			nl0lOli <= 0;
			nl0lOll <= 0;
			nl0lOlO <= 0;
			nl0lOOi <= 0;
			nl0lOOl <= 0;
			nl0lOOO <= 0;
			nl0O00i <= 0;
			nl0O00l <= 0;
			nl0O00O <= 0;
			nl0O01i <= 0;
			nl0O01l <= 0;
			nl0O01O <= 0;
			nl0O0ii <= 0;
			nl0O0il <= 0;
			nl0O0iO <= 0;
			nl0O0li <= 0;
			nl0O0ll <= 0;
			nl0O0lO <= 0;
			nl0O0Oi <= 0;
			nl0O0Ol <= 0;
			nl0O0OO <= 0;
			nl0O10i <= 0;
			nl0O10l <= 0;
			nl0O10O <= 0;
			nl0O11i <= 0;
			nl0O11l <= 0;
			nl0O11O <= 0;
			nl0O1ii <= 0;
			nl0O1il <= 0;
			nl0O1iO <= 0;
			nl0O1li <= 0;
			nl0O1ll <= 0;
			nl0O1lO <= 0;
			nl0O1Oi <= 0;
			nl0O1Ol <= 0;
			nl0O1OO <= 0;
			nl0Oi0i <= 0;
			nl0Oi0l <= 0;
			nl0Oi0O <= 0;
			nl0Oi1i <= 0;
			nl0Oi1l <= 0;
			nl0Oi1O <= 0;
			nl0Oiii <= 0;
			nl0Oiil <= 0;
			nl0OiiO <= 0;
			nl0Oili <= 0;
			nl0Oill <= 0;
			nl0OilO <= 0;
			nl0OiOi <= 0;
			nl0OiOl <= 0;
			nl0OiOO <= 0;
			nl0Ol0i <= 0;
			nl0Ol0l <= 0;
			nl0Ol0O <= 0;
			nl0Ol1i <= 0;
			nl0Ol1l <= 0;
			nl0Ol1O <= 0;
			nl0Olii <= 0;
			nl0Olil <= 0;
			nl0OliO <= 0;
			nl0Olli <= 0;
			nl0Olll <= 0;
			nl0OlOl <= 0;
			nl0OlOO <= 0;
			nl0OO0i <= 0;
			nl0OO0O <= 0;
			nl0OO1i <= 0;
			nl0OO1l <= 0;
			nl0OO1O <= 0;
			nl0OOii <= 0;
			nl0OOil <= 0;
			nl0OOiO <= 0;
			nl0OOli <= 0;
			nl0OOll <= 0;
			nl0OOlO <= 0;
			nl0OOOl <= 0;
			nl0OOOO <= 0;
			nli100i <= 0;
			nli100l <= 0;
			nli100O <= 0;
			nli101l <= 0;
			nli101O <= 0;
			nli10ii <= 0;
			nli10il <= 0;
			nli10ll <= 0;
			nli110i <= 0;
			nli110l <= 0;
			nli110O <= 0;
			nli111i <= 0;
			nli111l <= 0;
			nli111O <= 0;
			nli11il <= 0;
			nli11iO <= 0;
			nli11li <= 0;
			nli11ll <= 0;
			nli11lO <= 0;
			nli11Oi <= 0;
			nli11Ol <= 0;
			nli11OO <= 0;
			nlO0ll <= 0;
			nlOl0l <= 0;
			nlOl0O <= 0;
			nlOlil <= 0;
		end
		else 
		begin
			nl0llOi <= wire_nl0l0OO_data_out[0];
			nl0lOil <= wire_nl0l0OO_data_out[1];
			nl0lOiO <= wire_nl0l0OO_data_out[2];
			nl0lOli <= wire_nl0l0OO_data_out[3];
			nl0lOll <= wire_nl0l0OO_data_out[4];
			nl0lOlO <= wire_nl0l0OO_data_out[5];
			nl0lOOi <= wire_nl0l0OO_data_out[6];
			nl0lOOl <= wire_nl0l0OO_data_out[7];
			nl0lOOO <= wire_nl0l0OO_data_out[8];
			nl0O00i <= wire_nl0l0OO_data_out[27];
			nl0O00l <= wire_nl0l0OO_data_out[28];
			nl0O00O <= wire_nl0l0OO_data_out[29];
			nl0O01i <= wire_nl0l0OO_data_out[24];
			nl0O01l <= wire_nl0l0OO_data_out[25];
			nl0O01O <= wire_nl0l0OO_data_out[26];
			nl0O0ii <= wire_nl0l0OO_data_out[30];
			nl0O0il <= wire_nl0l0OO_data_out[31];
			nl0O0iO <= wire_nl0l0OO_data_out[32];
			nl0O0li <= wire_nl0l0OO_data_out[33];
			nl0O0ll <= wire_nl0l0OO_data_out[34];
			nl0O0lO <= wire_nl0l0OO_data_out[35];
			nl0O0Oi <= wire_nl0l0OO_data_out[36];
			nl0O0Ol <= wire_nl0l0OO_data_out[37];
			nl0O0OO <= wire_nl0l0OO_data_out[38];
			nl0O10i <= wire_nl0l0OO_data_out[12];
			nl0O10l <= wire_nl0l0OO_data_out[13];
			nl0O10O <= wire_nl0l0OO_data_out[14];
			nl0O11i <= wire_nl0l0OO_data_out[9];
			nl0O11l <= wire_nl0l0OO_data_out[10];
			nl0O11O <= wire_nl0l0OO_data_out[11];
			nl0O1ii <= wire_nl0l0OO_data_out[15];
			nl0O1il <= wire_nl0l0OO_data_out[16];
			nl0O1iO <= wire_nl0l0OO_data_out[17];
			nl0O1li <= wire_nl0l0OO_data_out[18];
			nl0O1ll <= wire_nl0l0OO_data_out[19];
			nl0O1lO <= wire_nl0l0OO_data_out[20];
			nl0O1Oi <= wire_nl0l0OO_data_out[21];
			nl0O1Ol <= wire_nl0l0OO_data_out[22];
			nl0O1OO <= wire_nl0l0OO_data_out[23];
			nl0Oi0i <= wire_nl0l0OO_data_out[42];
			nl0Oi0l <= wire_nl0l0OO_data_out[43];
			nl0Oi0O <= wire_nl0l0OO_data_out[44];
			nl0Oi1i <= wire_nl0l0OO_data_out[39];
			nl0Oi1l <= wire_nl0l0OO_data_out[40];
			nl0Oi1O <= wire_nl0l0OO_data_out[41];
			nl0Oiii <= wire_nl0l0OO_data_out[45];
			nl0Oiil <= wire_nl0l0OO_data_out[46];
			nl0OiiO <= wire_nl0l0OO_data_out[47];
			nl0Oili <= wire_nl0l0OO_data_out[48];
			nl0Oill <= wire_nl0l0OO_data_out[49];
			nl0OilO <= wire_nl0l0OO_data_out[50];
			nl0OiOi <= wire_nl0l0OO_data_out[51];
			nl0OiOl <= wire_nl0l0OO_data_out[52];
			nl0OiOO <= wire_nl0l0OO_data_out[53];
			nl0Ol0i <= wire_nl0l0OO_data_out[57];
			nl0Ol0l <= wire_nl0l0OO_data_out[58];
			nl0Ol0O <= wire_nl0l0OO_data_out[59];
			nl0Ol1i <= wire_nl0l0OO_data_out[54];
			nl0Ol1l <= wire_nl0l0OO_data_out[55];
			nl0Ol1O <= wire_nl0l0OO_data_out[56];
			nl0Olii <= wire_nl0l0OO_data_out[60];
			nl0Olil <= wire_nl0l0OO_data_out[61];
			nl0OliO <= wire_nl0l0OO_data_out[62];
			nl0Olli <= wire_nl0l0OO_data_out[63];
			nl0Olll <= wire_nl0l0OO_data_out[64];
			nl0OlOl <= wire_nli10Ol_dataout;
			nl0OlOO <= wire_nli1i1O_dataout;
			nl0OO0i <= nl0OOlO;
			nl0OO0O <= nl0OOOl;
			nl0OO1i <= nl0OOiO;
			nl0OO1l <= nl0OOli;
			nl0OO1O <= nl0OOll;
			nl0OOii <= nl0OOOO;
			nl0OOil <= nli111i;
			nl0OOiO <= nli111l;
			nl0OOli <= nli111O;
			nl0OOll <= nli110i;
			nl0OOlO <= nli110l;
			nl0OOOl <= nli11ii;
			nl0OOOO <= nli11il;
			nli100i <= wire_nl0lOii_o[16];
			nli100l <= wire_nl0lOii_o[64];
			nli100O <= wire_nl0lOii_o[128];
			nli101l <= nli10ll;
			nli101O <= wire_nl0lOii_o[32];
			nli10ii <= wire_nl0lOii_o[4];
			nli10il <= wire_nl0lOii_o[8];
			nli10ll <= (~ nl000ii);
			nli110i <= wire_nli1iiO_dataout;
			nli110l <= wire_nli1ili_dataout;
			nli110O <= wire_nli1ill_dataout;
			nli111i <= nli11iO;
			nli111l <= wire_nli1iii_dataout;
			nli111O <= wire_nli1iil_dataout;
			nli11il <= wire_nli1iOi_dataout;
			nli11iO <= wire_nli1iOl_dataout;
			nli11li <= nli101O;
			nli11ll <= nli100i;
			nli11lO <= nli100l;
			nli11Oi <= nli100O;
			nli11Ol <= nli10ii;
			nli11OO <= nli10il;
			nlO0ll <= wire_nlOlli_dataout;
			nlOl0l <= wire_nlOllO_dataout;
			nlOl0O <= nlOlil;
			nlOlil <= nl0i01l;
		end
	end
	initial
	begin
		n11OOO = 0;
		nli1lli = 0;
		nli1lll = 0;
		nli1llO = 0;
		nli1lOi = 0;
		nli1lOl = 0;
		nli1lOO = 0;
		nli1O1i = 0;
		nliliO = 0;
		nlilli = 0;
		nlilll = 0;
		nlillO = 0;
		nlilOi = 0;
		nlilOl = 0;
		nlilOO = 0;
		nliO0i = 0;
		nliO0l = 0;
		nliO0O = 0;
		nliO1i = 0;
		nliO1l = 0;
		nliO1O = 0;
		nliOii = 0;
		nliOil = 0;
		nliOiO = 0;
		nliOli = 0;
		nliOll = 0;
		nliOlO = 0;
		nliOOi = 0;
		nliOOl = 0;
		nliOOO = 0;
		nll00i = 0;
		nll00l = 0;
		nll00O = 0;
		nll01i = 0;
		nll01l = 0;
		nll01O = 0;
		nll0ii = 0;
		nll0il = 0;
		nll0iO = 0;
		nll0li = 0;
		nll0ll = 0;
		nll0lO = 0;
		nll0Oi = 0;
		nll0Ol = 0;
		nll0OO = 0;
		nll10i = 0;
		nll10l = 0;
		nll10O = 0;
		nll11i = 0;
		nll11l = 0;
		nll11O = 0;
		nll1ii = 0;
		nll1il = 0;
		nll1iO = 0;
		nll1li = 0;
		nll1ll = 0;
		nll1lO = 0;
		nll1Oi = 0;
		nll1Ol = 0;
		nll1OO = 0;
		nlli0i = 0;
		nlli0l = 0;
		nlli0O = 0;
		nlli1i = 0;
		nlli1l = 0;
		nlli1O = 0;
		nlliii = 0;
		nlliil = 0;
		nlliiO = 0;
		nllili = 0;
		nllill = 0;
		nllilO = 0;
		nlliOi = 0;
		nlliOl = 0;
		nlliOO = 0;
		nlll0i = 0;
		nlll0l = 0;
		nlll0O = 0;
		nlll1i = 0;
		nlll1l = 0;
		nlll1O = 0;
		nlllii = 0;
		nlllil = 0;
		nllliO = 0;
		nlllli = 0;
		nlllll = 0;
		nllllO = 0;
		nlllOi = 0;
		nlllOl = 0;
		nlllOO = 0;
		nllO0i = 0;
		nllO0l = 0;
		nllO0O = 0;
		nllO1i = 0;
		nllO1l = 0;
		nllO1O = 0;
		nllOii = 0;
		nllOil = 0;
		nllOiO = 0;
		nllOli = 0;
		nllOll = 0;
		nllOlO = 0;
		nllOOi = 0;
		nllOOl = 0;
		nllOOO = 0;
		nlO00i = 0;
		nlO00l = 0;
		nlO00O = 0;
		nlO01i = 0;
		nlO01l = 0;
		nlO01O = 0;
		nlO0ii = 0;
		nlO0il = 0;
		nlO0iO = 0;
		nlO0li = 0;
		nlO10i = 0;
		nlO10l = 0;
		nlO10O = 0;
		nlO11i = 0;
		nlO11l = 0;
		nlO11O = 0;
		nlO1ii = 0;
		nlO1il = 0;
		nlO1iO = 0;
		nlO1li = 0;
		nlO1ll = 0;
		nlO1lO = 0;
		nlO1Oi = 0;
		nlO1Ol = 0;
		nlO1OO = 0;
		nlOliO = 0;
		nlOlOl = 0;
		nlOlOO = 0;
		nlOO0i = 0;
		nlOO0O = 0;
		nlOO1i = 0;
		nlOO1l = 0;
		nlOO1O = 0;
	end
	always @ ( posedge rx_wr_clk or  posedge wire_n111l_dataout)
	begin
		if (wire_n111l_dataout == 1'b1) 
		begin
			n11OOO <= 0;
			nli1lli <= 0;
			nli1lll <= 0;
			nli1llO <= 0;
			nli1lOi <= 0;
			nli1lOl <= 0;
			nli1lOO <= 0;
			nli1O1i <= 0;
			nliliO <= 0;
			nlilli <= 0;
			nlilll <= 0;
			nlillO <= 0;
			nlilOi <= 0;
			nlilOl <= 0;
			nlilOO <= 0;
			nliO0i <= 0;
			nliO0l <= 0;
			nliO0O <= 0;
			nliO1i <= 0;
			nliO1l <= 0;
			nliO1O <= 0;
			nliOii <= 0;
			nliOil <= 0;
			nliOiO <= 0;
			nliOli <= 0;
			nliOll <= 0;
			nliOlO <= 0;
			nliOOi <= 0;
			nliOOl <= 0;
			nliOOO <= 0;
			nll00i <= 0;
			nll00l <= 0;
			nll00O <= 0;
			nll01i <= 0;
			nll01l <= 0;
			nll01O <= 0;
			nll0ii <= 0;
			nll0il <= 0;
			nll0iO <= 0;
			nll0li <= 0;
			nll0ll <= 0;
			nll0lO <= 0;
			nll0Oi <= 0;
			nll0Ol <= 0;
			nll0OO <= 0;
			nll10i <= 0;
			nll10l <= 0;
			nll10O <= 0;
			nll11i <= 0;
			nll11l <= 0;
			nll11O <= 0;
			nll1ii <= 0;
			nll1il <= 0;
			nll1iO <= 0;
			nll1li <= 0;
			nll1ll <= 0;
			nll1lO <= 0;
			nll1Oi <= 0;
			nll1Ol <= 0;
			nll1OO <= 0;
			nlli0i <= 0;
			nlli0l <= 0;
			nlli0O <= 0;
			nlli1i <= 0;
			nlli1l <= 0;
			nlli1O <= 0;
			nlliii <= 0;
			nlliil <= 0;
			nlliiO <= 0;
			nllili <= 0;
			nllill <= 0;
			nllilO <= 0;
			nlliOi <= 0;
			nlliOl <= 0;
			nlliOO <= 0;
			nlll0i <= 0;
			nlll0l <= 0;
			nlll0O <= 0;
			nlll1i <= 0;
			nlll1l <= 0;
			nlll1O <= 0;
			nlllii <= 0;
			nlllil <= 0;
			nllliO <= 0;
			nlllli <= 0;
			nlllll <= 0;
			nllllO <= 0;
			nlllOi <= 0;
			nlllOl <= 0;
			nlllOO <= 0;
			nllO0i <= 0;
			nllO0l <= 0;
			nllO0O <= 0;
			nllO1i <= 0;
			nllO1l <= 0;
			nllO1O <= 0;
			nllOii <= 0;
			nllOil <= 0;
			nllOiO <= 0;
			nllOli <= 0;
			nllOll <= 0;
			nllOlO <= 0;
			nllOOi <= 0;
			nllOOl <= 0;
			nllOOO <= 0;
			nlO00i <= 0;
			nlO00l <= 0;
			nlO00O <= 0;
			nlO01i <= 0;
			nlO01l <= 0;
			nlO01O <= 0;
			nlO0ii <= 0;
			nlO0il <= 0;
			nlO0iO <= 0;
			nlO0li <= 0;
			nlO10i <= 0;
			nlO10l <= 0;
			nlO10O <= 0;
			nlO11i <= 0;
			nlO11l <= 0;
			nlO11O <= 0;
			nlO1ii <= 0;
			nlO1il <= 0;
			nlO1iO <= 0;
			nlO1li <= 0;
			nlO1ll <= 0;
			nlO1lO <= 0;
			nlO1Oi <= 0;
			nlO1Ol <= 0;
			nlO1OO <= 0;
			nlOliO <= 0;
			nlOlOl <= 0;
			nlOlOO <= 0;
			nlOO0i <= 0;
			nlOO0O <= 0;
			nlOO1i <= 0;
			nlOO1l <= 0;
			nlOO1O <= 0;
		end
		else 
		begin
			n11OOO <= wire_nlOi0i_dataout;
			nli1lli <= wire_nli1O1O_dataout;
			nli1lll <= wire_nli1O0i_dataout;
			nli1llO <= wire_nli1O0l_dataout;
			nli1lOi <= wire_nli1O0O_dataout;
			nli1lOl <= wire_nli1Oii_dataout;
			nli1lOO <= wire_nli1Oil_dataout;
			nli1O1i <= wire_nli1OiO_dataout;
			nliliO <= wire_nlOi0l_dataout;
			nlilli <= wire_nlOi0O_dataout;
			nlilll <= wire_nlOiii_dataout;
			nlillO <= wire_nlO0lO_dataout;
			nlilOi <= nlll1l;
			nlilOl <= nlll1O;
			nlilOO <= nlll0i;
			nliO0i <= nlllil;
			nliO0l <= nllliO;
			nliO0O <= nlllli;
			nliO1i <= nlll0l;
			nliO1l <= nlll0O;
			nliO1O <= nlllii;
			nliOii <= nlllll;
			nliOil <= nllllO;
			nliOiO <= nlllOi;
			nliOli <= nlllOl;
			nliOll <= nlllOO;
			nliOlO <= nllO1i;
			nliOOi <= nllO1l;
			nliOOl <= nllO1O;
			nliOOO <= nllO0i;
			nll00i <= nlO1il;
			nll00l <= nlO1iO;
			nll00O <= nlO1li;
			nll01i <= nlO10l;
			nll01l <= nlO10O;
			nll01O <= nlO1ii;
			nll0ii <= nlO1ll;
			nll0il <= nlO1lO;
			nll0iO <= nlO1Oi;
			nll0li <= nlO1Ol;
			nll0ll <= nlO1OO;
			nll0lO <= nlO01i;
			nll0Oi <= nlO01l;
			nll0Ol <= nlO01O;
			nll0OO <= nlO00i;
			nll10i <= nllOil;
			nll10l <= nllOiO;
			nll10O <= nllOli;
			nll11i <= nllO0l;
			nll11l <= nllO0O;
			nll11O <= nllOii;
			nll1ii <= nllOll;
			nll1il <= nllOlO;
			nll1iO <= nllOOi;
			nll1li <= nllOOl;
			nll1ll <= nllOOO;
			nll1lO <= nlO11i;
			nll1Oi <= nlO11l;
			nll1Ol <= nlO11O;
			nll1OO <= nlO10i;
			nlli0i <= wire_nl0l0Ol_byte_des_fifo_data_in[3];
			nlli0l <= wire_nl0l0Ol_byte_des_fifo_data_in[4];
			nlli0O <= wire_nl0l0Ol_byte_des_fifo_data_in[5];
			nlli1i <= wire_nl0l0Ol_byte_des_fifo_data_in[0];
			nlli1l <= wire_nl0l0Ol_byte_des_fifo_data_in[1];
			nlli1O <= wire_nl0l0Ol_byte_des_fifo_data_in[2];
			nlliii <= wire_nl0l0Ol_byte_des_fifo_data_in[6];
			nlliil <= wire_nl0l0Ol_byte_des_fifo_data_in[7];
			nlliiO <= wire_nl0l0Ol_byte_des_fifo_data_in[8];
			nllili <= wire_nl0l0Ol_byte_des_fifo_data_in[9];
			nllill <= wire_nl0l0Ol_byte_des_fifo_data_in[10];
			nllilO <= wire_nl0l0Ol_byte_des_fifo_data_in[11];
			nlliOi <= wire_nl0l0Ol_byte_des_fifo_data_in[12];
			nlliOl <= wire_nl0l0Ol_byte_des_fifo_data_in[13];
			nlliOO <= wire_nl0l0Ol_byte_des_fifo_data_in[14];
			nlll0i <= wire_nl0l0Ol_byte_des_fifo_data_in[18];
			nlll0l <= wire_nl0l0Ol_byte_des_fifo_data_in[19];
			nlll0O <= wire_nl0l0Ol_byte_des_fifo_data_in[20];
			nlll1i <= wire_nl0l0Ol_byte_des_fifo_data_in[15];
			nlll1l <= wire_nl0l0Ol_byte_des_fifo_data_in[16];
			nlll1O <= wire_nl0l0Ol_byte_des_fifo_data_in[17];
			nlllii <= wire_nl0l0Ol_byte_des_fifo_data_in[21];
			nlllil <= wire_nl0l0Ol_byte_des_fifo_data_in[22];
			nllliO <= wire_nl0l0Ol_byte_des_fifo_data_in[23];
			nlllli <= wire_nl0l0Ol_byte_des_fifo_data_in[24];
			nlllll <= wire_nl0l0Ol_byte_des_fifo_data_in[25];
			nllllO <= wire_nl0l0Ol_byte_des_fifo_data_in[26];
			nlllOi <= wire_nl0l0Ol_byte_des_fifo_data_in[27];
			nlllOl <= wire_nl0l0Ol_byte_des_fifo_data_in[28];
			nlllOO <= wire_nl0l0Ol_byte_des_fifo_data_in[29];
			nllO0i <= wire_nl0l0Ol_byte_des_fifo_data_in[33];
			nllO0l <= wire_nl0l0Ol_byte_des_fifo_data_in[34];
			nllO0O <= wire_nl0l0Ol_byte_des_fifo_data_in[35];
			nllO1i <= wire_nl0l0Ol_byte_des_fifo_data_in[30];
			nllO1l <= wire_nl0l0Ol_byte_des_fifo_data_in[31];
			nllO1O <= wire_nl0l0Ol_byte_des_fifo_data_in[32];
			nllOii <= wire_nl0l0Ol_byte_des_fifo_data_in[36];
			nllOil <= wire_nl0l0Ol_byte_des_fifo_data_in[37];
			nllOiO <= wire_nl0l0Ol_byte_des_fifo_data_in[38];
			nllOli <= wire_nl0l0Ol_byte_des_fifo_data_in[39];
			nllOll <= wire_nl0l0Ol_byte_des_fifo_data_in[40];
			nllOlO <= wire_nl0l0Ol_byte_des_fifo_data_in[41];
			nllOOi <= wire_nl0l0Ol_byte_des_fifo_data_in[42];
			nllOOl <= wire_nl0l0Ol_byte_des_fifo_data_in[43];
			nllOOO <= wire_nl0l0Ol_byte_des_fifo_data_in[44];
			nlO00i <= wire_nl0l0Ol_byte_des_fifo_data_in[63];
			nlO00l <= wire_nlOilO_dataout;
			nlO00O <= wire_nlOiOi_dataout;
			nlO01i <= wire_nl0l0Ol_byte_des_fifo_data_in[60];
			nlO01l <= wire_nl0l0Ol_byte_des_fifo_data_in[61];
			nlO01O <= wire_nl0l0Ol_byte_des_fifo_data_in[62];
			nlO0ii <= wire_nlO0OO_dataout;
			nlO0il <= nlO0iO;
			nlO0iO <= nlO0li;
			nlO0li <= bytordplden;
			nlO10i <= wire_nl0l0Ol_byte_des_fifo_data_in[48];
			nlO10l <= wire_nl0l0Ol_byte_des_fifo_data_in[49];
			nlO10O <= wire_nl0l0Ol_byte_des_fifo_data_in[50];
			nlO11i <= wire_nl0l0Ol_byte_des_fifo_data_in[45];
			nlO11l <= wire_nl0l0Ol_byte_des_fifo_data_in[46];
			nlO11O <= wire_nl0l0Ol_byte_des_fifo_data_in[47];
			nlO1ii <= wire_nl0l0Ol_byte_des_fifo_data_in[51];
			nlO1il <= wire_nl0l0Ol_byte_des_fifo_data_in[52];
			nlO1iO <= wire_nl0l0Ol_byte_des_fifo_data_in[53];
			nlO1li <= wire_nl0l0Ol_byte_des_fifo_data_in[54];
			nlO1ll <= wire_nl0l0Ol_byte_des_fifo_data_in[55];
			nlO1lO <= wire_nl0l0Ol_byte_des_fifo_data_in[56];
			nlO1Oi <= wire_nl0l0Ol_byte_des_fifo_data_in[57];
			nlO1Ol <= wire_nl0l0Ol_byte_des_fifo_data_in[58];
			nlO1OO <= wire_nl0l0Ol_byte_des_fifo_data_in[59];
			nlOliO <= wire_nlOOil_dataout;
			nlOlOl <= wire_nlOOli_dataout;
			nlOlOO <= nlOO1i;
			nlOO0i <= nlOO0O;
			nlOO0O <= pld_wr_dis;
			nlOO1i <= nl0i01l;
			nlOO1l <= (nlOO0i ^ nlOO1O);
			nlOO1O <= nlOO0i;
		end
	end
	initial
	begin
		nlOOii = 0;
		nlOOOO = 0;
	end
	always @ (rx_rd_clk or nl0l0iO or wire_nlOOOl_CLRN)
	begin
		if (nl0l0iO == 1'b1) 
		begin
			nlOOii <= 1;
			nlOOOO <= 1;
		end
		else if  (wire_nlOOOl_CLRN == 1'b0) 
		begin
			nlOOii <= 0;
			nlOOOO <= 0;
		end
		else 
		if (rx_rd_clk != nlOOOl_clk_prev && rx_rd_clk == 1'b1) 
		begin
			nlOOii <= nlOOOO;
			nlOOOO <= nl0i1li;
		end
		nlOOOl_clk_prev <= rx_rd_clk;
	end
	assign
		wire_nlOOOl_CLRN = (nl0i1ii48 ^ nl0i1ii47);
	and(wire_n0000i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[31], ~((~ nl00i1l)));
	assign		wire_n0000l_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[0] : wire_nl0l0Ol_byte_des_fifo_data_in[32];
	assign		wire_n0000O_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[1] : wire_nl0l0Ol_byte_des_fifo_data_in[33];
	and(wire_n0001i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[28], ~((~ nl00i1l)));
	and(wire_n0001l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[29], ~((~ nl00i1l)));
	and(wire_n0001O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[30], ~((~ nl00i1l)));
	assign		wire_n000i_dataout = (endec_rx === 1'b1) ? wire_n0liO_dataout : ovr_undflow[1];
	assign		wire_n000ii_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[2] : wire_nl0l0Ol_byte_des_fifo_data_in[34];
	assign		wire_n000il_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[3] : wire_nl0l0Ol_byte_des_fifo_data_in[35];
	assign		wire_n000iO_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[4] : wire_nl0l0Ol_byte_des_fifo_data_in[36];
	assign		wire_n000l_dataout = (endec_rx === 1'b1) ? wire_n0lli_dataout : ovr_undflow[2];
	assign		wire_n000li_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[5] : wire_nl0l0Ol_byte_des_fifo_data_in[37];
	assign		wire_n000ll_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[6] : wire_nl0l0Ol_byte_des_fifo_data_in[38];
	assign		wire_n000lO_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[7] : wire_nl0l0Ol_byte_des_fifo_data_in[39];
	assign		wire_n000O_dataout = (endec_rx === 1'b1) ? wire_n0lll_dataout : ovr_undflow[3];
	assign		wire_n000Oi_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[8] : wire_nl0l0Ol_byte_des_fifo_data_in[40];
	assign		wire_n000Ol_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[9] : wire_nl0l0Ol_byte_des_fifo_data_in[41];
	assign		wire_n000OO_dataout = ((~ nl00i1l) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[10] : wire_nl0l0Ol_byte_des_fifo_data_in[42];
	and(wire_n0010i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[16], ~((~ nl00i1l)));
	and(wire_n0010l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[17], ~((~ nl00i1l)));
	and(wire_n0010O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[18], ~((~ nl00i1l)));
	assign		wire_n0011i_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[29] : wire_nl0l0Ol_byte_des_fifo_data_in[61];
	assign		wire_n0011l_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[30] : wire_nl0l0Ol_byte_des_fifo_data_in[62];
	assign		wire_n0011O_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[31] : wire_nl0l0Ol_byte_des_fifo_data_in[63];
	assign		wire_n001i_dataout = (endec_rx === 1'b1) ? wire_n0lii_dataout : tenb_data[18];
	and(wire_n001ii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[19], ~((~ nl00i1l)));
	and(wire_n001il_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[20], ~((~ nl00i1l)));
	and(wire_n001iO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[21], ~((~ nl00i1l)));
	assign		wire_n001l_dataout = (endec_rx === 1'b1) ? wire_nll_dataout : tenb_data[19];
	and(wire_n001li_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[22], ~((~ nl00i1l)));
	and(wire_n001ll_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[23], ~((~ nl00i1l)));
	and(wire_n001lO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[24], ~((~ nl00i1l)));
	assign		wire_n001O_dataout = (endec_rx === 1'b1) ? wire_n0lil_dataout : ovr_undflow[0];
	and(wire_n001Oi_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[25], ~((~ nl00i1l)));
	and(wire_n001Ol_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[26], ~((~ nl00i1l)));
	and(wire_n001OO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[27], ~((~ nl00i1l)));
	assign		wire_n00i_dataout = (rrxfifo_dis === 1'b1) ? wire_n100ii_o : nl0O10l;
	and(wire_n00i0i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[46], ~((~ nl00i1l)));
	and(wire_n00i0l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[47], ~((~ nl00i1l)));
	and(wire_n00i0O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[48], ~((~ nl00i1l)));
	and(wire_n00i1i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[43], ~((~ nl00i1l)));
	and(wire_n00i1l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[44], ~((~ nl00i1l)));
	and(wire_n00i1O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[45], ~((~ nl00i1l)));
	assign		wire_n00ii_dataout = (endec_rx === 1'b1) ? wire_n0llO_dataout : disp_val_delay[0];
	and(wire_n00iii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[49], ~((~ nl00i1l)));
	and(wire_n00iil_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[50], ~((~ nl00i1l)));
	and(wire_n00iiO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[51], ~((~ nl00i1l)));
	assign		wire_n00il_dataout = (endec_rx === 1'b1) ? wire_n0lOi_dataout : disp_val_delay[1];
	and(wire_n00ili_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[52], ~((~ nl00i1l)));
	and(wire_n00ill_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[53], ~((~ nl00i1l)));
	and(wire_n00ilO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[54], ~((~ nl00i1l)));
	assign		wire_n00iO_dataout = (endec_rx === 1'b1) ? wire_n0lOl_dataout : disp_err_delay[0];
	and(wire_n00iOi_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[55], ~((~ nl00i1l)));
	and(wire_n00iOl_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[56], ~((~ nl00i1l)));
	and(wire_n00iOO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[57], ~((~ nl00i1l)));
	assign		wire_n00l_dataout = (rrxfifo_dis === 1'b1) ? wire_n100il_o : nl0O10O;
	and(wire_n00l0i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[61], ~((~ nl00i1l)));
	and(wire_n00l0l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[62], ~((~ nl00i1l)));
	and(wire_n00l0O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[63], ~((~ nl00i1l)));
	and(wire_n00l1i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[58], ~((~ nl00i1l)));
	and(wire_n00l1l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[59], ~((~ nl00i1l)));
	and(wire_n00l1O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[60], ~((~ nl00i1l)));
	assign		wire_n00li_dataout = (endec_rx === 1'b1) ? wire_n0lOO_dataout : disp_err_delay[1];
	assign		wire_n00lii_dataout = (nl00i1O === 1'b1) ? nlli1i : wire_n0iill_dataout;
	assign		wire_n00lil_dataout = (nl00i1O === 1'b1) ? nlli1l : wire_n0iilO_dataout;
	assign		wire_n00liO_dataout = (nl00i1O === 1'b1) ? nlli1O : wire_n0iiOi_dataout;
	assign		wire_n00ll_dataout = (endec_rx === 1'b1) ? wire_n0O1i_dataout : sync_resync_delay[0];
	assign		wire_n00lli_dataout = (nl00i1O === 1'b1) ? nlli0i : wire_n0iiOl_dataout;
	assign		wire_n00lll_dataout = (nl00i1O === 1'b1) ? nlli0l : wire_n0iiOO_dataout;
	assign		wire_n00llO_dataout = (nl00i1O === 1'b1) ? nlli0O : wire_n0il1i_dataout;
	assign		wire_n00lO_dataout = (endec_rx === 1'b1) ? wire_n0O1l_dataout : sync_resync_delay[1];
	assign		wire_n00lOi_dataout = (nl00i1O === 1'b1) ? nlliii : wire_n0il1l_dataout;
	assign		wire_n00lOl_dataout = (nl00i1O === 1'b1) ? nlliil : wire_n0il1O_dataout;
	assign		wire_n00lOO_dataout = (nl00i1O === 1'b1) ? nlliiO : wire_n0il0i_dataout;
	assign		wire_n00O_dataout = (rrxfifo_dis === 1'b1) ? wire_n100iO_o : nl0O1ii;
	assign		wire_n00O0i_dataout = (nl00i1O === 1'b1) ? nlliOi : wire_n0ilil_dataout;
	assign		wire_n00O0l_dataout = (nl00i1O === 1'b1) ? nlliOl : wire_n0iliO_dataout;
	assign		wire_n00O0O_dataout = (nl00i1O === 1'b1) ? nlliOO : wire_n0illi_dataout;
	assign		wire_n00O1i_dataout = (nl00i1O === 1'b1) ? nllili : wire_n0il0l_dataout;
	assign		wire_n00O1l_dataout = (nl00i1O === 1'b1) ? nllill : wire_n0il0O_dataout;
	assign		wire_n00O1O_dataout = (nl00i1O === 1'b1) ? nllilO : wire_n0ilii_dataout;
	and(wire_n00Oi_dataout, wire_niOil_o, ~(((~ n110O) & (~ rsync_sm_dis))));
	assign		wire_n00Oii_dataout = (nl00i1O === 1'b1) ? nlll1i : wire_n0illl_dataout;
	assign		wire_n00Oil_dataout = (nl00i1O === 1'b1) ? wire_n0l0OO_dataout : wire_n0illO_dataout;
	assign		wire_n00OiO_dataout = (nl00i1O === 1'b1) ? wire_n0li1i_dataout : wire_n0ilOi_dataout;
	assign		wire_n00Oli_dataout = (nl00i1O === 1'b1) ? wire_n0li1l_dataout : wire_n0ilOl_dataout;
	assign		wire_n00Oll_dataout = (nl00i1O === 1'b1) ? wire_n0li1O_dataout : wire_n0ilOO_dataout;
	assign		wire_n00OlO_dataout = (nl00i1O === 1'b1) ? wire_n0li0i_dataout : wire_n0iO1i_dataout;
	and(wire_n00OO_dataout, wire_nliil_o, ~(((~ n110l) & (~ rsync_sm_dis))));
	assign		wire_n00OOi_dataout = (nl00i1O === 1'b1) ? wire_n0li0l_dataout : wire_n0iO1l_dataout;
	assign		wire_n00OOl_dataout = (nl00i1O === 1'b1) ? wire_n0li0O_dataout : wire_n0iO1O_dataout;
	assign		wire_n00OOO_dataout = (nl00i1O === 1'b1) ? wire_n0liii_dataout : wire_n0iO0i_dataout;
	assign		wire_n0100i_dataout = ((~ nl00i1i) === 1'b1) ? nllOii : wire_nl0l0Ol_byte_des_fifo_data_in[4];
	assign		wire_n0100l_dataout = ((~ nl00i1i) === 1'b1) ? nllOil : wire_nl0l0Ol_byte_des_fifo_data_in[5];
	assign		wire_n0100O_dataout = ((~ nl00i1i) === 1'b1) ? nllOiO : wire_nl0l0Ol_byte_des_fifo_data_in[6];
	assign		wire_n0101i_dataout = ((~ nl00i1i) === 1'b1) ? nllO0i : wire_nl0l0Ol_byte_des_fifo_data_in[1];
	assign		wire_n0101l_dataout = ((~ nl00i1i) === 1'b1) ? nllO0l : wire_nl0l0Ol_byte_des_fifo_data_in[2];
	assign		wire_n0101O_dataout = ((~ nl00i1i) === 1'b1) ? nllO0O : wire_nl0l0Ol_byte_des_fifo_data_in[3];
	assign		wire_n010i_dataout = (endec_rx === 1'b1) ? wire_n0ili_dataout : tenb_data[6];
	assign		wire_n010ii_dataout = ((~ nl00i1i) === 1'b1) ? nllOli : wire_nl0l0Ol_byte_des_fifo_data_in[7];
	assign		wire_n010il_dataout = ((~ nl00i1i) === 1'b1) ? nllOll : wire_nl0l0Ol_byte_des_fifo_data_in[8];
	assign		wire_n010iO_dataout = ((~ nl00i1i) === 1'b1) ? nllOlO : wire_nl0l0Ol_byte_des_fifo_data_in[9];
	assign		wire_n010l_dataout = (endec_rx === 1'b1) ? wire_n0ill_dataout : tenb_data[7];
	assign		wire_n010li_dataout = ((~ nl00i1i) === 1'b1) ? nllOOi : wire_nl0l0Ol_byte_des_fifo_data_in[10];
	assign		wire_n010ll_dataout = ((~ nl00i1i) === 1'b1) ? nllOOl : wire_nl0l0Ol_byte_des_fifo_data_in[11];
	assign		wire_n010lO_dataout = ((~ nl00i1i) === 1'b1) ? nllOOO : wire_nl0l0Ol_byte_des_fifo_data_in[12];
	assign		wire_n010O_dataout = (endec_rx === 1'b1) ? wire_n0ilO_dataout : tenb_data[8];
	assign		wire_n010Oi_dataout = ((~ nl00i1i) === 1'b1) ? nlO11i : wire_nl0l0Ol_byte_des_fifo_data_in[13];
	assign		wire_n010Ol_dataout = ((~ nl00i1i) === 1'b1) ? nlO11l : wire_nl0l0Ol_byte_des_fifo_data_in[14];
	assign		wire_n010OO_dataout = ((~ nl00i1i) === 1'b1) ? nlO11O : wire_nl0l0Ol_byte_des_fifo_data_in[15];
	assign		wire_n0110i_dataout = (nl0i10i === 1'b1) ? wire_n00ill_dataout : wire_n01Oil_dataout;
	assign		wire_n0110l_dataout = (nl0i10i === 1'b1) ? wire_n00ilO_dataout : wire_n01OiO_dataout;
	assign		wire_n0110O_dataout = (nl0i10i === 1'b1) ? wire_n00iOi_dataout : wire_n01Oli_dataout;
	assign		wire_n0111i_dataout = (nl0i10i === 1'b1) ? wire_n00iil_dataout : wire_n01O0l_dataout;
	assign		wire_n0111l_dataout = (nl0i10i === 1'b1) ? wire_n00iiO_dataout : wire_n01O0O_dataout;
	assign		wire_n0111O_dataout = (nl0i10i === 1'b1) ? wire_n00ili_dataout : wire_n01Oii_dataout;
	assign		wire_n011i_dataout = (endec_rx === 1'b1) ? wire_n0iii_dataout : tenb_data[3];
	assign		wire_n011ii_dataout = (nl0i10i === 1'b1) ? wire_n00iOl_dataout : wire_n01Oll_dataout;
	assign		wire_n011il_dataout = (nl0i10i === 1'b1) ? wire_n00iOO_dataout : wire_n01OlO_dataout;
	assign		wire_n011iO_dataout = (nl0i10i === 1'b1) ? wire_n00l1i_dataout : wire_n01OOi_dataout;
	assign		wire_n011l_dataout = (endec_rx === 1'b1) ? wire_n0iil_dataout : tenb_data[4];
	assign		wire_n011li_dataout = (nl0i10i === 1'b1) ? wire_n00l1l_dataout : wire_n01OOl_dataout;
	assign		wire_n011ll_dataout = (nl0i10i === 1'b1) ? wire_n00l1O_dataout : wire_n01OOO_dataout;
	assign		wire_n011lO_dataout = (nl0i10i === 1'b1) ? wire_n00l0i_dataout : wire_n0011i_dataout;
	assign		wire_n011O_dataout = (endec_rx === 1'b1) ? wire_n0iiO_dataout : tenb_data[5];
	assign		wire_n011Oi_dataout = (nl0i10i === 1'b1) ? wire_n00l0l_dataout : wire_n0011l_dataout;
	assign		wire_n011Ol_dataout = (nl0i10i === 1'b1) ? wire_n00l0O_dataout : wire_n0011O_dataout;
	assign		wire_n011OO_dataout = ((~ nl00i1i) === 1'b1) ? nllO1O : wire_nl0l0Ol_byte_des_fifo_data_in[0];
	assign		wire_n01i_dataout = (rrxfifo_dis === 1'b1) ? wire_n1000i_o : nl0O11l;
	assign		wire_n01i0i_dataout = ((~ nl00i1i) === 1'b1) ? nlO1ii : wire_nl0l0Ol_byte_des_fifo_data_in[19];
	assign		wire_n01i0l_dataout = ((~ nl00i1i) === 1'b1) ? nlO1il : wire_nl0l0Ol_byte_des_fifo_data_in[20];
	assign		wire_n01i0O_dataout = ((~ nl00i1i) === 1'b1) ? nlO1iO : wire_nl0l0Ol_byte_des_fifo_data_in[21];
	assign		wire_n01i1i_dataout = ((~ nl00i1i) === 1'b1) ? nlO10i : wire_nl0l0Ol_byte_des_fifo_data_in[16];
	assign		wire_n01i1l_dataout = ((~ nl00i1i) === 1'b1) ? nlO10l : wire_nl0l0Ol_byte_des_fifo_data_in[17];
	assign		wire_n01i1O_dataout = ((~ nl00i1i) === 1'b1) ? nlO10O : wire_nl0l0Ol_byte_des_fifo_data_in[18];
	assign		wire_n01ii_dataout = (endec_rx === 1'b1) ? wire_n0iOi_dataout : tenb_data[9];
	assign		wire_n01iii_dataout = ((~ nl00i1i) === 1'b1) ? nlO1li : wire_nl0l0Ol_byte_des_fifo_data_in[22];
	assign		wire_n01iil_dataout = ((~ nl00i1i) === 1'b1) ? nlO1ll : wire_nl0l0Ol_byte_des_fifo_data_in[23];
	assign		wire_n01iiO_dataout = ((~ nl00i1i) === 1'b1) ? nlO1lO : wire_nl0l0Ol_byte_des_fifo_data_in[24];
	assign		wire_n01il_dataout = (endec_rx === 1'b1) ? wire_n0iOl_dataout : tenb_data[10];
	assign		wire_n01ili_dataout = ((~ nl00i1i) === 1'b1) ? nlO1Oi : wire_nl0l0Ol_byte_des_fifo_data_in[25];
	assign		wire_n01ill_dataout = ((~ nl00i1i) === 1'b1) ? nlO1Ol : wire_nl0l0Ol_byte_des_fifo_data_in[26];
	assign		wire_n01ilO_dataout = ((~ nl00i1i) === 1'b1) ? nlO1OO : wire_nl0l0Ol_byte_des_fifo_data_in[27];
	assign		wire_n01iO_dataout = (endec_rx === 1'b1) ? wire_n0iOO_dataout : tenb_data[11];
	assign		wire_n01iOi_dataout = ((~ nl00i1i) === 1'b1) ? nlO01i : wire_nl0l0Ol_byte_des_fifo_data_in[28];
	assign		wire_n01iOl_dataout = ((~ nl00i1i) === 1'b1) ? nlO01l : wire_nl0l0Ol_byte_des_fifo_data_in[29];
	assign		wire_n01iOO_dataout = ((~ nl00i1i) === 1'b1) ? nlO01O : wire_nl0l0Ol_byte_des_fifo_data_in[30];
	assign		wire_n01l_dataout = (rrxfifo_dis === 1'b1) ? wire_n1000l_o : nl0O11O;
	assign		wire_n01l0i_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[2] : wire_nl0l0Ol_byte_des_fifo_data_in[34];
	assign		wire_n01l0l_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[3] : wire_nl0l0Ol_byte_des_fifo_data_in[35];
	assign		wire_n01l0O_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[4] : wire_nl0l0Ol_byte_des_fifo_data_in[36];
	assign		wire_n01l1i_dataout = ((~ nl00i1i) === 1'b1) ? nlO00i : wire_nl0l0Ol_byte_des_fifo_data_in[31];
	assign		wire_n01l1l_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[0] : wire_nl0l0Ol_byte_des_fifo_data_in[32];
	assign		wire_n01l1O_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[1] : wire_nl0l0Ol_byte_des_fifo_data_in[33];
	assign		wire_n01li_dataout = (endec_rx === 1'b1) ? wire_n0l1i_dataout : tenb_data[12];
	assign		wire_n01lii_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[5] : wire_nl0l0Ol_byte_des_fifo_data_in[37];
	assign		wire_n01lil_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[6] : wire_nl0l0Ol_byte_des_fifo_data_in[38];
	assign		wire_n01liO_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[7] : wire_nl0l0Ol_byte_des_fifo_data_in[39];
	assign		wire_n01ll_dataout = (endec_rx === 1'b1) ? wire_n0l1l_dataout : tenb_data[13];
	assign		wire_n01lli_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[8] : wire_nl0l0Ol_byte_des_fifo_data_in[40];
	assign		wire_n01lll_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[9] : wire_nl0l0Ol_byte_des_fifo_data_in[41];
	assign		wire_n01llO_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[10] : wire_nl0l0Ol_byte_des_fifo_data_in[42];
	assign		wire_n01lO_dataout = (endec_rx === 1'b1) ? wire_n0l1O_dataout : tenb_data[14];
	assign		wire_n01lOi_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[11] : wire_nl0l0Ol_byte_des_fifo_data_in[43];
	assign		wire_n01lOl_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[12] : wire_nl0l0Ol_byte_des_fifo_data_in[44];
	assign		wire_n01lOO_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[13] : wire_nl0l0Ol_byte_des_fifo_data_in[45];
	assign		wire_n01O_dataout = (rrxfifo_dis === 1'b1) ? wire_n1000O_o : nl0O10i;
	assign		wire_n01O0i_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[17] : wire_nl0l0Ol_byte_des_fifo_data_in[49];
	assign		wire_n01O0l_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[18] : wire_nl0l0Ol_byte_des_fifo_data_in[50];
	assign		wire_n01O0O_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[19] : wire_nl0l0Ol_byte_des_fifo_data_in[51];
	assign		wire_n01O1i_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[14] : wire_nl0l0Ol_byte_des_fifo_data_in[46];
	assign		wire_n01O1l_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[15] : wire_nl0l0Ol_byte_des_fifo_data_in[47];
	assign		wire_n01O1O_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[16] : wire_nl0l0Ol_byte_des_fifo_data_in[48];
	assign		wire_n01Oi_dataout = (endec_rx === 1'b1) ? wire_n0l0i_dataout : tenb_data[15];
	assign		wire_n01Oii_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[20] : wire_nl0l0Ol_byte_des_fifo_data_in[52];
	assign		wire_n01Oil_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[21] : wire_nl0l0Ol_byte_des_fifo_data_in[53];
	assign		wire_n01OiO_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[22] : wire_nl0l0Ol_byte_des_fifo_data_in[54];
	assign		wire_n01Ol_dataout = (endec_rx === 1'b1) ? wire_n0l0l_dataout : tenb_data[16];
	assign		wire_n01Oli_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[23] : wire_nl0l0Ol_byte_des_fifo_data_in[55];
	assign		wire_n01Oll_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[24] : wire_nl0l0Ol_byte_des_fifo_data_in[56];
	assign		wire_n01OlO_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[25] : wire_nl0l0Ol_byte_des_fifo_data_in[57];
	assign		wire_n01OO_dataout = (endec_rx === 1'b1) ? wire_n0l0O_dataout : tenb_data[17];
	assign		wire_n01OOi_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[26] : wire_nl0l0Ol_byte_des_fifo_data_in[58];
	assign		wire_n01OOl_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[27] : wire_nl0l0Ol_byte_des_fifo_data_in[59];
	assign		wire_n01OOO_dataout = ((~ nl00i1i) === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[28] : wire_nl0l0Ol_byte_des_fifo_data_in[60];
	assign		wire_n0i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10Oii_o : nl0Ol0l;
	assign		wire_n0i00i_dataout = (nl00i1O === 1'b1) ? wire_n0llll_dataout : wire_n0l1il_dataout;
	assign		wire_n0i00l_dataout = (nl00i1O === 1'b1) ? wire_n0lllO_dataout : wire_n0l1iO_dataout;
	assign		wire_n0i00O_dataout = (nl00i1O === 1'b1) ? wire_n0llOi_dataout : wire_n0l1li_dataout;
	assign		wire_n0i01i_dataout = (nl00i1O === 1'b1) ? wire_n0llil_dataout : wire_n0l10l_dataout;
	assign		wire_n0i01l_dataout = (nl00i1O === 1'b1) ? wire_n0lliO_dataout : wire_n0l10O_dataout;
	assign		wire_n0i01O_dataout = (nl00i1O === 1'b1) ? wire_n0llli_dataout : wire_n0l1ii_dataout;
	assign		wire_n0i0i_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0li_dataout : rx_data_rs[0];
	assign		wire_n0i0ii_dataout = (nl00i1O === 1'b1) ? wire_n0llOl_dataout : wire_n0l1ll_dataout;
	assign		wire_n0i0il_dataout = (nl00i1O === 1'b1) ? wire_n0llOO_dataout : wire_n0l1lO_dataout;
	assign		wire_n0i0iO_dataout = (nl00i1O === 1'b1) ? wire_n0lO1i_dataout : wire_n0l1Oi_dataout;
	assign		wire_n0i0l_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0ll_dataout : rx_data_rs[1];
	assign		wire_n0i0li_dataout = (nl00i1O === 1'b1) ? wire_n0lO1l_dataout : wire_n0l1Ol_dataout;
	assign		wire_n0i0ll_dataout = (nl00i1O === 1'b1) ? wire_n0lO1O_dataout : wire_n0l1OO_dataout;
	assign		wire_n0i0lO_dataout = (nl00i1O === 1'b1) ? wire_n0lO0i_dataout : wire_n0l01i_dataout;
	assign		wire_n0i0O_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0lO_dataout : rx_data_rs[2];
	assign		wire_n0i0Oi_dataout = (nl00i1O === 1'b1) ? wire_n0lO0l_dataout : wire_n0l01l_dataout;
	assign		wire_n0i0Ol_dataout = (nl00i1O === 1'b1) ? wire_n0lO0O_dataout : wire_n0l01O_dataout;
	assign		wire_n0i0OO_dataout = (nl00i1O === 1'b1) ? wire_n0lOii_dataout : wire_n0l00i_dataout;
	assign		wire_n0i10i_dataout = (nl00i1O === 1'b1) ? wire_n0lill_dataout : wire_n0iOil_dataout;
	assign		wire_n0i10l_dataout = (nl00i1O === 1'b1) ? wire_n0lilO_dataout : wire_n0iOiO_dataout;
	assign		wire_n0i10O_dataout = (nl00i1O === 1'b1) ? wire_n0liOi_dataout : wire_n0iOli_dataout;
	assign		wire_n0i11i_dataout = (nl00i1O === 1'b1) ? wire_n0liil_dataout : wire_n0iO0l_dataout;
	assign		wire_n0i11l_dataout = (nl00i1O === 1'b1) ? wire_n0liiO_dataout : wire_n0iO0O_dataout;
	assign		wire_n0i11O_dataout = (nl00i1O === 1'b1) ? wire_n0lili_dataout : wire_n0iOii_dataout;
	assign		wire_n0i1ii_dataout = (nl00i1O === 1'b1) ? wire_n0liOl_dataout : wire_n0iOll_dataout;
	assign		wire_n0i1il_dataout = (nl00i1O === 1'b1) ? wire_n0liOO_dataout : wire_n0iOlO_dataout;
	assign		wire_n0i1iO_dataout = (nl00i1O === 1'b1) ? wire_n0ll1i_dataout : wire_n0iOOi_dataout;
	assign		wire_n0i1l_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0iO_dataout : n10iO;
	assign		wire_n0i1li_dataout = (nl00i1O === 1'b1) ? wire_n0ll1l_dataout : wire_n0iOOl_dataout;
	assign		wire_n0i1ll_dataout = (nl00i1O === 1'b1) ? wire_n0ll1O_dataout : wire_n0iOOO_dataout;
	assign		wire_n0i1lO_dataout = (nl00i1O === 1'b1) ? wire_n0ll0i_dataout : wire_n0l11i_dataout;
	assign		wire_n0i1O_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0O0l_dataout : n10li;
	assign		wire_n0i1Oi_dataout = (nl00i1O === 1'b1) ? wire_n0ll0l_dataout : wire_n0l11l_dataout;
	assign		wire_n0i1Ol_dataout = (nl00i1O === 1'b1) ? wire_n0ll0O_dataout : wire_n0l11O_dataout;
	assign		wire_n0i1OO_dataout = (nl00i1O === 1'b1) ? wire_n0llii_dataout : wire_n0l10i_dataout;
	assign		wire_n0ii_dataout = (rrxfifo_dis === 1'b1) ? wire_n100li_o : nl0O1il;
	assign		wire_n0ii0i_dataout = (nl00i1O === 1'b1) ? wire_n0lOll_dataout : wire_n0l0il_dataout;
	assign		wire_n0ii0l_dataout = (nl00i1O === 1'b1) ? wire_n0lOlO_dataout : wire_n0l0iO_dataout;
	assign		wire_n0ii0O_dataout = (nl00i1O === 1'b1) ? wire_n0lOOi_dataout : wire_n0l0li_dataout;
	assign		wire_n0ii1i_dataout = (nl00i1O === 1'b1) ? wire_n0lOil_dataout : wire_n0l00l_dataout;
	assign		wire_n0ii1l_dataout = (nl00i1O === 1'b1) ? wire_n0lOiO_dataout : wire_n0l00O_dataout;
	assign		wire_n0ii1O_dataout = (nl00i1O === 1'b1) ? wire_n0lOli_dataout : wire_n0l0ii_dataout;
	assign		wire_n0iii_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0Oi_dataout : rx_data_rs[3];
	assign		wire_n0iiii_dataout = (nl00i1O === 1'b1) ? wire_n0lOOl_dataout : wire_n0l0ll_dataout;
	assign		wire_n0iiil_dataout = (nl00i1O === 1'b1) ? wire_n0lOOO_dataout : wire_n0l0lO_dataout;
	assign		wire_n0iiiO_dataout = (nl00i1O === 1'b1) ? wire_n0O11i_dataout : wire_n0l0Oi_dataout;
	assign		wire_n0iil_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0Ol_dataout : rx_data_rs[4];
	assign		wire_n0iili_dataout = (nl00i1O === 1'b1) ? wire_n0O11l_dataout : wire_n0l0Ol_dataout;
	assign		wire_n0iill_dataout = (nl00i0i === 1'b1) ? nlilOi : nlli1i;
	assign		wire_n0iilO_dataout = (nl00i0i === 1'b1) ? nlilOl : nlli1l;
	assign		wire_n0iiO_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0OO_dataout : rx_data_rs[5];
	assign		wire_n0iiOi_dataout = (nl00i0i === 1'b1) ? nlilOO : nlli1O;
	assign		wire_n0iiOl_dataout = (nl00i0i === 1'b1) ? nliO1i : nlli0i;
	assign		wire_n0iiOO_dataout = (nl00i0i === 1'b1) ? nliO1l : nlli0l;
	assign		wire_n0il_dataout = (rrxfifo_dis === 1'b1) ? wire_n100ll_o : nl0O1iO;
	assign		wire_n0il0i_dataout = (nl00i0i === 1'b1) ? nliO0O : nlliiO;
	assign		wire_n0il0l_dataout = (nl00i0i === 1'b1) ? nliOii : nllili;
	assign		wire_n0il0O_dataout = (nl00i0i === 1'b1) ? nliOil : nllill;
	assign		wire_n0il1i_dataout = (nl00i0i === 1'b1) ? nliO1O : nlli0O;
	assign		wire_n0il1l_dataout = (nl00i0i === 1'b1) ? nliO0i : nlliii;
	assign		wire_n0il1O_dataout = (nl00i0i === 1'b1) ? nliO0l : nlliil;
	assign		wire_n0ili_dataout = (rendec_data_sel_rx === 1'b1) ? wire_nii1i_dataout : rx_data_rs[6];
	assign		wire_n0ilii_dataout = (nl00i0i === 1'b1) ? nliOiO : nllilO;
	assign		wire_n0ilil_dataout = (nl00i0i === 1'b1) ? nliOli : nlliOi;
	assign		wire_n0iliO_dataout = (nl00i0i === 1'b1) ? nliOll : nlliOl;
	assign		wire_n0ill_dataout = (rendec_data_sel_rx === 1'b1) ? wire_nii1l_dataout : rx_data_rs[7];
	assign		wire_n0illi_dataout = (nl00i0i === 1'b1) ? nliOlO : nlliOO;
	assign		wire_n0illl_dataout = (nl00i0i === 1'b1) ? nliOOi : nlll1i;
	assign		wire_n0illO_dataout = (nl00i0i === 1'b1) ? nlli1i : nlll1l;
	assign		wire_n0ilO_dataout = (rendec_data_sel_rx === 1'b1) ? wire_nii1O_dataout : rx_control_rs;
	assign		wire_n0ilOi_dataout = (nl00i0i === 1'b1) ? nlli1l : nlll1O;
	assign		wire_n0ilOl_dataout = (nl00i0i === 1'b1) ? nlli1O : nlll0i;
	assign		wire_n0ilOO_dataout = (nl00i0i === 1'b1) ? nlli0i : nlll0l;
	assign		wire_n0iO_dataout = (rrxfifo_dis === 1'b1) ? wire_n100lO_o : nl0O1li;
	assign		wire_n0iO0i_dataout = (nl00i0i === 1'b1) ? nlliil : nllliO;
	assign		wire_n0iO0l_dataout = (nl00i0i === 1'b1) ? nlliiO : nlllli;
	assign		wire_n0iO0O_dataout = (nl00i0i === 1'b1) ? nllili : nlllll;
	assign		wire_n0iO1i_dataout = (nl00i0i === 1'b1) ? nlli0l : nlll0O;
	assign		wire_n0iO1l_dataout = (nl00i0i === 1'b1) ? nlli0O : nlllii;
	assign		wire_n0iO1O_dataout = (nl00i0i === 1'b1) ? nlliii : nlllil;
	assign		wire_n0iOi_dataout = (rendec_data_sel_rx === 1'b1) ? wire_nli_dataout : ((~ nl0i00i) & rx_control_rs);
	assign		wire_n0iOii_dataout = (nl00i0i === 1'b1) ? nllill : nllllO;
	assign		wire_n0iOil_dataout = (nl00i0i === 1'b1) ? nllilO : nlllOi;
	assign		wire_n0iOiO_dataout = (nl00i0i === 1'b1) ? nlliOi : nlllOl;
	assign		wire_n0iOl_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0O0O_dataout : rx_data_dt[8];
	assign		wire_n0iOli_dataout = (nl00i0i === 1'b1) ? nlliOl : nlllOO;
	assign		wire_n0iOll_dataout = (nl00i0i === 1'b1) ? nlliOO : nllO1i;
	assign		wire_n0iOlO_dataout = (nl00i0i === 1'b1) ? nlll1i : nllO1l;
	assign		wire_n0iOO_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0Oii_dataout : rx_data_dt[9];
	and(wire_n0iOOi_dataout, nllO1O, ~(nl00i0i));
	and(wire_n0iOOl_dataout, nllO0i, ~(nl00i0i));
	and(wire_n0iOOO_dataout, nllO0l, ~(nl00i0i));
	assign		wire_n0l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10Oil_o : nl0Ol0O;
	and(wire_n0l00i_dataout, nlO1iO, ~(nl00i0i));
	and(wire_n0l00l_dataout, nlO1li, ~(nl00i0i));
	and(wire_n0l00O_dataout, nlO1ll, ~(nl00i0i));
	and(wire_n0l01i_dataout, nlO10O, ~(nl00i0i));
	and(wire_n0l01l_dataout, nlO1ii, ~(nl00i0i));
	and(wire_n0l01O_dataout, nlO1il, ~(nl00i0i));
	assign		wire_n0l0i_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0Oll_dataout : rx_data_dt[13];
	and(wire_n0l0ii_dataout, nlO1lO, ~(nl00i0i));
	and(wire_n0l0il_dataout, nlO1Oi, ~(nl00i0i));
	and(wire_n0l0iO_dataout, nlO1Ol, ~(nl00i0i));
	assign		wire_n0l0l_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0OlO_dataout : rx_data_dt[14];
	and(wire_n0l0li_dataout, nlO1OO, ~(nl00i0i));
	and(wire_n0l0ll_dataout, nlO01i, ~(nl00i0i));
	and(wire_n0l0lO_dataout, nlO01l, ~(nl00i0i));
	assign		wire_n0l0O_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0OOi_dataout : rx_data_dt[15];
	and(wire_n0l0Oi_dataout, nlO01O, ~(nl00i0i));
	and(wire_n0l0Ol_dataout, nlO00i, ~(nl00i0i));
	assign		wire_n0l0OO_dataout = (nl00i0l === 1'b1) ? rbytordpadval[0] : nlll1l;
	and(wire_n0l10i_dataout, nllOiO, ~(nl00i0i));
	and(wire_n0l10l_dataout, nllOli, ~(nl00i0i));
	and(wire_n0l10O_dataout, nllOll, ~(nl00i0i));
	and(wire_n0l11i_dataout, nllO0O, ~(nl00i0i));
	and(wire_n0l11l_dataout, nllOii, ~(nl00i0i));
	and(wire_n0l11O_dataout, nllOil, ~(nl00i0i));
	assign		wire_n0l1i_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0Oil_dataout : rx_data_dt[10];
	and(wire_n0l1ii_dataout, nllOlO, ~(nl00i0i));
	and(wire_n0l1il_dataout, nllOOi, ~(nl00i0i));
	and(wire_n0l1iO_dataout, nllOOl, ~(nl00i0i));
	assign		wire_n0l1l_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0OiO_dataout : rx_data_dt[11];
	and(wire_n0l1li_dataout, nllOOO, ~(nl00i0i));
	and(wire_n0l1ll_dataout, nlO11i, ~(nl00i0i));
	and(wire_n0l1lO_dataout, nlO11l, ~(nl00i0i));
	assign		wire_n0l1O_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0Oli_dataout : rx_data_dt[12];
	and(wire_n0l1Oi_dataout, nlO11O, ~(nl00i0i));
	and(wire_n0l1Ol_dataout, nlO10i, ~(nl00i0i));
	and(wire_n0l1OO_dataout, nlO10l, ~(nl00i0i));
	assign		wire_n0li_dataout = (rrxfifo_dis === 1'b1) ? wire_n100Oi_o : nl0O1ll;
	assign		wire_n0li0i_dataout = (nl00i0l === 1'b1) ? rbytordpadval[4] : nlll0O;
	assign		wire_n0li0l_dataout = (nl00i0l === 1'b1) ? rbytordpadval[5] : nlllii;
	assign		wire_n0li0O_dataout = (nl00i0l === 1'b1) ? rbytordpadval[6] : nlllil;
	assign		wire_n0li1i_dataout = (nl00i0l === 1'b1) ? rbytordpadval[1] : nlll1O;
	assign		wire_n0li1l_dataout = (nl00i0l === 1'b1) ? rbytordpadval[2] : nlll0i;
	assign		wire_n0li1O_dataout = (nl00i0l === 1'b1) ? rbytordpadval[3] : nlll0l;
	assign		wire_n0lii_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0OOl_dataout : rx_control_dt[1];
	assign		wire_n0liii_dataout = (nl00i0l === 1'b1) ? rbytordpadval[7] : nllliO;
	assign		wire_n0liil_dataout = (nl00i0l === 1'b1) ? rbytordpadval[8] : nlllli;
	assign		wire_n0liiO_dataout = (nl00i0l === 1'b1) ? rbytordpadval[9] : nlllll;
	assign		wire_n0lil_dataout = (rendec_data_sel_rx === 1'b1) ? ovr_undflow[0] : n11il;
	assign		wire_n0lili_dataout = (nl00i0l === 1'b1) ? nllill : nllllO;
	and(wire_n0lill_dataout, nlllOi, ~(nl00i0l));
	and(wire_n0lilO_dataout, nlllOl, ~(nl00i0l));
	assign		wire_n0liO_dataout = (rendec_data_sel_rx === 1'b1) ? ovr_undflow[1] : n11iO;
	and(wire_n0liOi_dataout, nlllOO, ~(nl00i0l));
	and(wire_n0liOl_dataout, nllO1i, ~(nl00i0l));
	and(wire_n0liOO_dataout, nllO1l, ~(nl00i0l));
	assign		wire_n0ll_dataout = (rrxfifo_dis === 1'b1) ? wire_n100Ol_o : nl0O1lO;
	and(wire_n0ll0i_dataout, nllO0O, ~(nl00i0l));
	and(wire_n0ll0l_dataout, nllOii, ~(nl00i0l));
	and(wire_n0ll0O_dataout, nllOil, ~(nl00i0l));
	and(wire_n0ll1i_dataout, nllO1O, ~(nl00i0l));
	and(wire_n0ll1l_dataout, nllO0i, ~(nl00i0l));
	and(wire_n0ll1O_dataout, nllO0l, ~(nl00i0l));
	assign		wire_n0lli_dataout = (rendec_data_sel_rx === 1'b1) ? ovr_undflow[2] : n11li;
	and(wire_n0llii_dataout, nllOiO, ~(nl00i0l));
	and(wire_n0llil_dataout, nllOli, ~(nl00i0l));
	and(wire_n0lliO_dataout, nllOll, ~(nl00i0l));
	assign		wire_n0lll_dataout = (rendec_data_sel_rx === 1'b1) ? ovr_undflow[3] : n11ll;
	and(wire_n0llli_dataout, nllOlO, ~(nl00i0l));
	and(wire_n0llll_dataout, nllOOi, ~(nl00i0l));
	and(wire_n0lllO_dataout, nllOOl, ~(nl00i0l));
	assign		wire_n0llO_dataout = (rendec_data_sel_rx === 1'b1) ? disp_val_delay[0] : n1i0i;
	and(wire_n0llOi_dataout, nllOOO, ~(nl00i0l));
	and(wire_n0llOl_dataout, nlO11i, ~(nl00i0l));
	and(wire_n0llOO_dataout, nlO11l, ~(nl00i0l));
	assign		wire_n0lO_dataout = (rrxfifo_dis === 1'b1) ? wire_n100OO_o : nl0O1Oi;
	and(wire_n0lO0i_dataout, nlO10O, ~(nl00i0l));
	and(wire_n0lO0l_dataout, nlO1ii, ~(nl00i0l));
	and(wire_n0lO0O_dataout, nlO1il, ~(nl00i0l));
	and(wire_n0lO1i_dataout, nlO11O, ~(nl00i0l));
	and(wire_n0lO1l_dataout, nlO10i, ~(nl00i0l));
	and(wire_n0lO1O_dataout, nlO10l, ~(nl00i0l));
	assign		wire_n0lOi_dataout = (rendec_data_sel_rx === 1'b1) ? disp_val_delay[1] : n1i0l;
	and(wire_n0lOii_dataout, nlO1iO, ~(nl00i0l));
	and(wire_n0lOil_dataout, nlO1li, ~(nl00i0l));
	and(wire_n0lOiO_dataout, nlO1ll, ~(nl00i0l));
	assign		wire_n0lOl_dataout = (rendec_data_sel_rx === 1'b1) ? disp_err_delay[0] : n1iil;
	and(wire_n0lOli_dataout, nlO1lO, ~(nl00i0l));
	and(wire_n0lOll_dataout, nlO1Oi, ~(nl00i0l));
	and(wire_n0lOlO_dataout, nlO1Ol, ~(nl00i0l));
	assign		wire_n0lOO_dataout = (rendec_data_sel_rx === 1'b1) ? disp_err_delay[1] : n1iiO;
	and(wire_n0lOOi_dataout, nlO1OO, ~(nl00i0l));
	and(wire_n0lOOl_dataout, nlO01i, ~(nl00i0l));
	and(wire_n0lOOO_dataout, nlO01l, ~(nl00i0l));
	assign		wire_n0O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10OiO_o : nl0Olii;
	assign		wire_n0O00i_dataout = (nl00i1O === 1'b1) ? wire_ni1lll_dataout : wire_ni11il_dataout;
	assign		wire_n0O00l_dataout = (nl00i1O === 1'b1) ? wire_ni1llO_dataout : wire_ni11iO_dataout;
	assign		wire_n0O00O_dataout = (nl00i1O === 1'b1) ? wire_ni1lOi_dataout : wire_ni11li_dataout;
	assign		wire_n0O01i_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[13] : wire_ni110l_dataout;
	assign		wire_n0O01l_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[14] : wire_ni110O_dataout;
	assign		wire_n0O01O_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[15] : wire_ni11ii_dataout;
	assign		wire_n0O0ii_dataout = (nl00i1O === 1'b1) ? wire_ni1lOl_dataout : wire_ni11ll_dataout;
	assign		wire_n0O0il_dataout = (nl00i1O === 1'b1) ? wire_ni1lOO_dataout : wire_ni11lO_dataout;
	assign		wire_n0O0iO_dataout = (nl00i1O === 1'b1) ? wire_ni1O1i_dataout : wire_ni11Oi_dataout;
	assign		wire_n0O0l_dataout = ((~ n110O) === 1'b1) ? wire_ni1Oi_dataout : wire_niOil_o;
	assign		wire_n0O0li_dataout = (nl00i1O === 1'b1) ? wire_ni1O1l_dataout : wire_ni11Ol_dataout;
	assign		wire_n0O0ll_dataout = (nl00i1O === 1'b1) ? wire_ni1O1O_dataout : wire_ni11OO_dataout;
	assign		wire_n0O0lO_dataout = (nl00i1O === 1'b1) ? wire_ni1O0i_dataout : wire_ni101i_dataout;
	assign		wire_n0O0O_dataout = ((~ n110O) === 1'b1) ? wire_ni1Ol_dataout : wire_n0OOO_dataout;
	assign		wire_n0O0Oi_dataout = (nl00i1O === 1'b1) ? wire_ni1O0l_dataout : wire_ni101l_dataout;
	assign		wire_n0O0Ol_dataout = (nl00i1O === 1'b1) ? wire_ni1O0O_dataout : wire_ni101O_dataout;
	assign		wire_n0O0OO_dataout = (nl00i1O === 1'b1) ? wire_ni1Oii_dataout : wire_ni100i_dataout;
	assign		wire_n0O10i_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[1] : wire_n0OOil_dataout;
	assign		wire_n0O10l_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[2] : wire_n0OOiO_dataout;
	assign		wire_n0O10O_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[3] : wire_n0OOli_dataout;
	and(wire_n0O11i_dataout, nlO01O, ~(nl00i0l));
	and(wire_n0O11l_dataout, nlO00i, ~(nl00i0l));
	assign		wire_n0O11O_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[0] : wire_n0OOii_dataout;
	assign		wire_n0O1i_dataout = (rendec_data_sel_rx === 1'b1) ? sync_resync_delay[0] : n1ilO;
	assign		wire_n0O1ii_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[4] : wire_n0OOll_dataout;
	assign		wire_n0O1il_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[5] : wire_n0OOlO_dataout;
	assign		wire_n0O1iO_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[6] : wire_n0OOOi_dataout;
	assign		wire_n0O1l_dataout = (rendec_data_sel_rx === 1'b1) ? sync_resync_delay[1] : n1iOi;
	assign		wire_n0O1li_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[7] : wire_n0OOOl_dataout;
	assign		wire_n0O1ll_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[8] : wire_n0OOOO_dataout;
	assign		wire_n0O1lO_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[9] : wire_ni111i_dataout;
	assign		wire_n0O1Oi_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[10] : wire_ni111l_dataout;
	assign		wire_n0O1Ol_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[11] : wire_ni111O_dataout;
	assign		wire_n0O1OO_dataout = (nl00i1O === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[12] : wire_ni110i_dataout;
	assign		wire_n0Oi_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i1i_o : nl0O1Ol;
	assign		wire_n0Oi0i_dataout = (nl00i1O === 1'b1) ? wire_ni1Oll_dataout : wire_ni10il_dataout;
	assign		wire_n0Oi0l_dataout = (nl00i1O === 1'b1) ? wire_ni1OlO_dataout : wire_ni10iO_dataout;
	assign		wire_n0Oi0O_dataout = (nl00i1O === 1'b1) ? wire_ni1OOi_dataout : wire_ni10li_dataout;
	assign		wire_n0Oi1i_dataout = (nl00i1O === 1'b1) ? wire_ni1Oil_dataout : wire_ni100l_dataout;
	assign		wire_n0Oi1l_dataout = (nl00i1O === 1'b1) ? wire_ni1OiO_dataout : wire_ni100O_dataout;
	assign		wire_n0Oi1O_dataout = (nl00i1O === 1'b1) ? wire_ni1Oli_dataout : wire_ni10ii_dataout;
	assign		wire_n0Oii_dataout = ((~ n110O) === 1'b1) ? wire_ni1OO_dataout : wire_ni11i_dataout;
	assign		wire_n0Oiii_dataout = (nl00i1O === 1'b1) ? wire_ni1OOl_dataout : wire_ni10ll_dataout;
	assign		wire_n0Oiil_dataout = (nl00i1O === 1'b1) ? wire_ni1OOO_dataout : wire_ni10lO_dataout;
	assign		wire_n0OiiO_dataout = (nl00i1O === 1'b1) ? wire_ni011i_dataout : wire_ni10Oi_dataout;
	assign		wire_n0Oil_dataout = ((~ n110O) === 1'b1) ? wire_ni01i_dataout : wire_ni11l_dataout;
	assign		wire_n0Oili_dataout = (nl00i1O === 1'b1) ? wire_ni011l_dataout : wire_ni10Ol_dataout;
	assign		wire_n0Oill_dataout = (nl00i1O === 1'b1) ? wire_ni011O_dataout : wire_ni10OO_dataout;
	assign		wire_n0OilO_dataout = (nl00i1O === 1'b1) ? wire_ni010i_dataout : wire_ni1i1i_dataout;
	assign		wire_n0OiO_dataout = ((~ n110O) === 1'b1) ? wire_ni01l_dataout : wire_ni11O_dataout;
	assign		wire_n0OiOi_dataout = (nl00i1O === 1'b1) ? wire_ni010l_dataout : wire_ni1i1l_dataout;
	assign		wire_n0OiOl_dataout = (nl00i1O === 1'b1) ? wire_ni010O_dataout : wire_ni1i1O_dataout;
	assign		wire_n0OiOO_dataout = (nl00i1O === 1'b1) ? wire_ni01ii_dataout : wire_ni1i0i_dataout;
	assign		wire_n0Ol_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i1l_o : nl0O1OO;
	assign		wire_n0Ol0i_dataout = (nl00i1O === 1'b1) ? wire_ni01ll_dataout : wire_ni1iil_dataout;
	assign		wire_n0Ol0l_dataout = (nl00i1O === 1'b1) ? wire_ni01lO_dataout : wire_ni1iiO_dataout;
	assign		wire_n0Ol0O_dataout = (nl00i1O === 1'b1) ? wire_ni01Oi_dataout : wire_ni1ili_dataout;
	assign		wire_n0Ol1i_dataout = (nl00i1O === 1'b1) ? wire_ni01il_dataout : wire_ni1i0l_dataout;
	assign		wire_n0Ol1l_dataout = (nl00i1O === 1'b1) ? wire_ni01iO_dataout : wire_ni1i0O_dataout;
	assign		wire_n0Ol1O_dataout = (nl00i1O === 1'b1) ? wire_ni01li_dataout : wire_ni1iii_dataout;
	assign		wire_n0Oli_dataout = ((~ n110O) === 1'b1) ? wire_ni01O_dataout : wire_ni10i_dataout;
	assign		wire_n0Olii_dataout = (nl00i1O === 1'b1) ? wire_ni01Ol_dataout : wire_ni1ill_dataout;
	assign		wire_n0Olil_dataout = (nl00i1O === 1'b1) ? wire_ni01OO_dataout : wire_ni1ilO_dataout;
	assign		wire_n0OliO_dataout = (nl00i1O === 1'b1) ? wire_ni001i_dataout : wire_ni1iOi_dataout;
	assign		wire_n0Oll_dataout = ((~ n110O) === 1'b1) ? wire_ni00i_dataout : wire_ni10l_dataout;
	assign		wire_n0Olli_dataout = (nl00i1O === 1'b1) ? wire_ni001l_dataout : wire_ni1iOl_dataout;
	assign		wire_n0Olll_dataout = (nl00i1O === 1'b1) ? wire_ni001O_dataout : wire_ni1iOO_dataout;
	assign		wire_n0OllO_dataout = (nl00i1O === 1'b1) ? wire_ni000i_dataout : wire_ni1l1i_dataout;
	assign		wire_n0OlO_dataout = ((~ n110O) === 1'b1) ? wire_ni00l_dataout : wire_ni10O_dataout;
	assign		wire_n0OlOi_dataout = (nl00i1O === 1'b1) ? wire_ni000l_dataout : wire_ni1l1l_dataout;
	assign		wire_n0OlOl_dataout = (nl00i1O === 1'b1) ? wire_ni000O_dataout : wire_ni1l1O_dataout;
	assign		wire_n0OlOO_dataout = (nl00i1O === 1'b1) ? wire_ni00ii_dataout : wire_ni1l0i_dataout;
	assign		wire_n0OO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i1O_o : nl0O01i;
	assign		wire_n0OO0i_dataout = (nl00i1O === 1'b1) ? wire_ni00ll_dataout : wire_ni1lil_dataout;
	assign		wire_n0OO0l_dataout = (nl00i1O === 1'b1) ? wire_ni00lO_dataout : wire_ni1liO_dataout;
	assign		wire_n0OO0O_dataout = (nl00i1O === 1'b1) ? wire_ni00Oi_dataout : wire_ni1lli_dataout;
	assign		wire_n0OO1i_dataout = (nl00i1O === 1'b1) ? wire_ni00il_dataout : wire_ni1l0l_dataout;
	assign		wire_n0OO1l_dataout = (nl00i1O === 1'b1) ? wire_ni00iO_dataout : wire_ni1l0O_dataout;
	assign		wire_n0OO1O_dataout = (nl00i1O === 1'b1) ? wire_ni00li_dataout : wire_ni1lii_dataout;
	assign		wire_n0OOi_dataout = ((~ n110O) === 1'b1) ? wire_ni00O_dataout : wire_ni1ii_dataout;
	assign		wire_n0OOii_dataout = (nl00i0i === 1'b1) ? nlll1l : wire_nl0l0Ol_byte_des_fifo_data_in[0];
	assign		wire_n0OOil_dataout = (nl00i0i === 1'b1) ? nlll1O : wire_nl0l0Ol_byte_des_fifo_data_in[1];
	assign		wire_n0OOiO_dataout = (nl00i0i === 1'b1) ? nlll0i : wire_nl0l0Ol_byte_des_fifo_data_in[2];
	assign		wire_n0OOl_dataout = ((~ n110O) === 1'b1) ? wire_ni0ii_dataout : wire_ni1il_dataout;
	assign		wire_n0OOli_dataout = (nl00i0i === 1'b1) ? nlll0l : wire_nl0l0Ol_byte_des_fifo_data_in[3];
	assign		wire_n0OOll_dataout = (nl00i0i === 1'b1) ? nlll0O : wire_nl0l0Ol_byte_des_fifo_data_in[4];
	assign		wire_n0OOlO_dataout = (nl00i0i === 1'b1) ? nlllii : wire_nl0l0Ol_byte_des_fifo_data_in[5];
	assign		wire_n0OOO_dataout = (nl0i00l === 1'b1) ? rclkcmpinsertpad : rx_data_dt[8];
	assign		wire_n0OOOi_dataout = (nl00i0i === 1'b1) ? nlllil : wire_nl0l0Ol_byte_des_fifo_data_in[6];
	assign		wire_n0OOOl_dataout = (nl00i0i === 1'b1) ? nllliO : wire_nl0l0Ol_byte_des_fifo_data_in[7];
	assign		wire_n0OOOO_dataout = (nl00i0i === 1'b1) ? nlllli : wire_nl0l0Ol_byte_des_fifo_data_in[8];
	and(wire_n1010i_dataout, wire_n1010l_dataout, n11Oll);
	or(wire_n1010l_dataout, nlOliO, n1010O);
	and(wire_n1011i_dataout, wire_n1011l_dataout, n1010O);
	assign		wire_n1011l_dataout = (rphfifo_master_sel_rx === 1'b1) ? wire_n1011O_dataout : (~ rx_we_in_q0_ch0);
	assign		wire_n1011O_dataout = (indv_rx === 1'b1) ? (~ n11OOl) : (~ rx_we_in_ch0);
	or(wire_n101ii_dataout, nlillO, (wire_nlOilO_dataout & wire_nl01ll_dataout));
	assign		wire_n10i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l0i_o : nl0Oi1l;
	assign		wire_n10l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O0l_o : nl0Ol1O;
	assign		wire_n10O_dataout = (rrxfifo_dis === 1'b1) ? wire_n101iO_o : nl0llOi;
	assign		wire_n10OOi_dataout = (nl0i10i === 1'b1) ? nlli1i : wire_n1iO1l_dataout;
	assign		wire_n10OOl_dataout = (nl0i10i === 1'b1) ? nlli1l : wire_n1iO1O_dataout;
	assign		wire_n10OOO_dataout = (nl0i10i === 1'b1) ? nlli1O : wire_n1iO0i_dataout;
	and(wire_n111l_dataout, n111i, ~(scan_mode));
	assign		wire_n11i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i0i_o : nl0O01l;
	assign		wire_n11l_dataout = (rrxfifo_dis === 1'b1) ? wire_n1001l_o : nl0lOOO;
	assign		wire_n11O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i1O_o : nl0O01i;
	assign		wire_n1i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O0i_o : nl0Ol1l;
	assign		wire_n1i00i_dataout = (nl0i10i === 1'b1) ? wire_n1lllO_dataout : wire_n1l1il_dataout;
	assign		wire_n1i00l_dataout = (nl0i10i === 1'b1) ? wire_n1llOi_dataout : wire_n1l1iO_dataout;
	assign		wire_n1i00O_dataout = (nl0i10i === 1'b1) ? wire_n1llOl_dataout : wire_n1l1li_dataout;
	assign		wire_n1i01i_dataout = (nl0i10i === 1'b1) ? wire_n1lliO_dataout : wire_n1l10l_dataout;
	assign		wire_n1i01l_dataout = (nl0i10i === 1'b1) ? wire_n1llli_dataout : wire_n1l10O_dataout;
	assign		wire_n1i01O_dataout = (nl0i10i === 1'b1) ? wire_n1llll_dataout : wire_n1l1ii_dataout;
	assign		wire_n1i0ii_dataout = (nl0i10i === 1'b1) ? wire_n1llOO_dataout : wire_n1l1ll_dataout;
	assign		wire_n1i0il_dataout = (nl0i10i === 1'b1) ? wire_n1lO1i_dataout : wire_n1l1lO_dataout;
	assign		wire_n1i0iO_dataout = (nl0i10i === 1'b1) ? wire_n1lO1l_dataout : wire_n1l1Oi_dataout;
	assign		wire_n1i0li_dataout = (nl0i10i === 1'b1) ? wire_n1lO1O_dataout : wire_n1l1Ol_dataout;
	assign		wire_n1i0ll_dataout = (nl0i10i === 1'b1) ? wire_n1lO0i_dataout : wire_n1l1OO_dataout;
	assign		wire_n1i0lO_dataout = (nl0i10i === 1'b1) ? wire_n1lO0l_dataout : wire_n1l01i_dataout;
	assign		wire_n1i0Oi_dataout = (nl0i10i === 1'b1) ? wire_n1lO0O_dataout : wire_n1l01l_dataout;
	assign		wire_n1i0Ol_dataout = (nl0i10i === 1'b1) ? wire_n1lOii_dataout : wire_n1l01O_dataout;
	assign		wire_n1i0OO_dataout = (nl0i10i === 1'b1) ? wire_n1lOil_dataout : wire_n1l00i_dataout;
	assign		wire_n1i10i_dataout = (nl0i10i === 1'b1) ? nlliii : wire_n1iOil_dataout;
	assign		wire_n1i10l_dataout = (nl0i10i === 1'b1) ? nlliil : wire_n1iOiO_dataout;
	assign		wire_n1i10O_dataout = (nl0i10i === 1'b1) ? nlliiO : wire_n1iOli_dataout;
	assign		wire_n1i11i_dataout = (nl0i10i === 1'b1) ? nlli0i : wire_n1iO0l_dataout;
	assign		wire_n1i11l_dataout = (nl0i10i === 1'b1) ? nlli0l : wire_n1iO0O_dataout;
	assign		wire_n1i11O_dataout = (nl0i10i === 1'b1) ? nlli0O : wire_n1iOii_dataout;
	assign		wire_n1i1ii_dataout = (nl0i10i === 1'b1) ? nllili : wire_n1iOll_dataout;
	assign		wire_n1i1il_dataout = (nl0i10i === 1'b1) ? nllill : wire_n1iOlO_dataout;
	assign		wire_n1i1iO_dataout = (nl0i10i === 1'b1) ? nllilO : wire_n1iOOi_dataout;
	assign		wire_n1i1li_dataout = (nl0i10i === 1'b1) ? nlliOi : wire_n1iOOl_dataout;
	assign		wire_n1i1ll_dataout = (nl0i10i === 1'b1) ? nlliOl : wire_n1iOOO_dataout;
	assign		wire_n1i1lO_dataout = (nl0i10i === 1'b1) ? nlliOO : wire_n1l11i_dataout;
	assign		wire_n1i1Oi_dataout = (nl0i10i === 1'b1) ? nlll1i : wire_n1l11l_dataout;
	assign		wire_n1i1Ol_dataout = (nl0i10i === 1'b1) ? wire_n1llii_dataout : wire_n1l11O_dataout;
	assign		wire_n1i1OO_dataout = (nl0i10i === 1'b1) ? wire_n1llil_dataout : wire_n1l10i_dataout;
	assign		wire_n1ii_dataout = (rrxfifo_dis === 1'b1) ? wire_n101li_o : nl0lOil;
	assign		wire_n1ii0i_dataout = (nl0i10i === 1'b1) ? wire_n1lOlO_dataout : wire_n1l0il_dataout;
	assign		wire_n1ii0l_dataout = (nl0i10i === 1'b1) ? wire_n1lOOi_dataout : wire_n1l0iO_dataout;
	assign		wire_n1ii0O_dataout = (nl0i10i === 1'b1) ? wire_n1lOOl_dataout : wire_n1l0li_dataout;
	assign		wire_n1ii1i_dataout = (nl0i10i === 1'b1) ? wire_n1lOiO_dataout : wire_n1l00l_dataout;
	assign		wire_n1ii1l_dataout = (nl0i10i === 1'b1) ? wire_n1lOli_dataout : wire_n1l00O_dataout;
	assign		wire_n1ii1O_dataout = (nl0i10i === 1'b1) ? wire_n1lOll_dataout : wire_n1l0ii_dataout;
	assign		wire_n1iiii_dataout = (nl0i10i === 1'b1) ? wire_n1lOOO_dataout : wire_n1l0ll_dataout;
	assign		wire_n1iiil_dataout = (nl0i10i === 1'b1) ? wire_n1O11i_dataout : wire_n1l0lO_dataout;
	assign		wire_n1iiiO_dataout = (nl0i10i === 1'b1) ? wire_n1O11l_dataout : wire_n1l0Oi_dataout;
	assign		wire_n1iili_dataout = (nl0i10i === 1'b1) ? wire_n1O11O_dataout : wire_n1l0Ol_dataout;
	assign		wire_n1iill_dataout = (nl0i10i === 1'b1) ? wire_n1O10i_dataout : wire_n1l0OO_dataout;
	assign		wire_n1iilO_dataout = (nl0i10i === 1'b1) ? wire_n1O10l_dataout : wire_n1li1i_dataout;
	assign		wire_n1iiOi_dataout = (nl0i10i === 1'b1) ? wire_n1O10O_dataout : wire_n1li1l_dataout;
	assign		wire_n1iiOl_dataout = (nl0i10i === 1'b1) ? wire_n1O1ii_dataout : wire_n1li1O_dataout;
	assign		wire_n1iiOO_dataout = (nl0i10i === 1'b1) ? wire_n1O1il_dataout : wire_n1li0i_dataout;
	assign		wire_n1il_dataout = (rrxfifo_dis === 1'b1) ? wire_n101ll_o : nl0lOiO;
	assign		wire_n1il0i_dataout = (nl0i10i === 1'b1) ? wire_n1O1lO_dataout : wire_n1liil_dataout;
	assign		wire_n1il0l_dataout = (nl0i10i === 1'b1) ? wire_n1O1Oi_dataout : wire_n1liiO_dataout;
	assign		wire_n1il0O_dataout = (nl0i10i === 1'b1) ? wire_n1O1Ol_dataout : wire_n1lili_dataout;
	assign		wire_n1il1i_dataout = (nl0i10i === 1'b1) ? wire_n1O1iO_dataout : wire_n1li0l_dataout;
	assign		wire_n1il1l_dataout = (nl0i10i === 1'b1) ? wire_n1O1li_dataout : wire_n1li0O_dataout;
	assign		wire_n1il1O_dataout = (nl0i10i === 1'b1) ? wire_n1O1ll_dataout : wire_n1liii_dataout;
	assign		wire_n1ilii_dataout = (nl0i10i === 1'b1) ? wire_n1O1OO_dataout : wire_n1lill_dataout;
	assign		wire_n1ilil_dataout = (nl0i10i === 1'b1) ? wire_n1O01i_dataout : wire_n1lilO_dataout;
	assign		wire_n1iliO_dataout = (nl0i10i === 1'b1) ? wire_n1O01l_dataout : wire_n1liOi_dataout;
	assign		wire_n1illi_dataout = (nl0i10i === 1'b1) ? wire_n1O01O_dataout : wire_n1liOl_dataout;
	assign		wire_n1illl_dataout = (nl0i10i === 1'b1) ? wire_n1O00i_dataout : wire_n1liOO_dataout;
	assign		wire_n1illO_dataout = (nl0i10i === 1'b1) ? wire_n1O00l_dataout : wire_n1ll1i_dataout;
	assign		wire_n1ilOi_dataout = (nl0i10i === 1'b1) ? wire_n1O00O_dataout : wire_n1ll1l_dataout;
	assign		wire_n1ilOl_dataout = (nl0i10i === 1'b1) ? wire_n1O0ii_dataout : wire_n1ll1O_dataout;
	assign		wire_n1ilOO_dataout = (nl0i10i === 1'b1) ? wire_n1O0il_dataout : wire_n1ll0i_dataout;
	assign		wire_n1iO_dataout = (rrxfifo_dis === 1'b1) ? wire_n101lO_o : nl0lOli;
	assign		wire_n1iO0i_dataout = ((~ nl00i1i) === 1'b1) ? nll11i : nlli1O;
	assign		wire_n1iO0l_dataout = ((~ nl00i1i) === 1'b1) ? nll11l : nlli0i;
	assign		wire_n1iO0O_dataout = ((~ nl00i1i) === 1'b1) ? nll11O : nlli0l;
	assign		wire_n1iO1i_dataout = (nl0i10i === 1'b1) ? wire_n1O0iO_dataout : wire_n1ll0l_dataout;
	assign		wire_n1iO1l_dataout = ((~ nl00i1i) === 1'b1) ? nliOOl : nlli1i;
	assign		wire_n1iO1O_dataout = ((~ nl00i1i) === 1'b1) ? nliOOO : nlli1l;
	assign		wire_n1iOii_dataout = ((~ nl00i1i) === 1'b1) ? nll10i : nlli0O;
	assign		wire_n1iOil_dataout = ((~ nl00i1i) === 1'b1) ? nll10l : nlliii;
	assign		wire_n1iOiO_dataout = ((~ nl00i1i) === 1'b1) ? nll10O : nlliil;
	assign		wire_n1iOli_dataout = ((~ nl00i1i) === 1'b1) ? nll1ii : nlliiO;
	assign		wire_n1iOll_dataout = ((~ nl00i1i) === 1'b1) ? nll1il : nllili;
	assign		wire_n1iOlO_dataout = ((~ nl00i1i) === 1'b1) ? nll1iO : nllill;
	assign		wire_n1iOOi_dataout = ((~ nl00i1i) === 1'b1) ? nll1li : nllilO;
	assign		wire_n1iOOl_dataout = ((~ nl00i1i) === 1'b1) ? nll1ll : nlliOi;
	assign		wire_n1iOOO_dataout = ((~ nl00i1i) === 1'b1) ? nll1lO : nlliOl;
	assign		wire_n1l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O0l_o : nl0Ol1O;
	assign		wire_n1l00i_dataout = ((~ nl00i1i) === 1'b1) ? nlli1i : nllO1O;
	assign		wire_n1l00l_dataout = ((~ nl00i1i) === 1'b1) ? nlli1l : nllO0i;
	assign		wire_n1l00O_dataout = ((~ nl00i1i) === 1'b1) ? nlli1O : nllO0l;
	assign		wire_n1l01i_dataout = ((~ nl00i1i) === 1'b1) ? nll0Oi : nlllOO;
	assign		wire_n1l01l_dataout = ((~ nl00i1i) === 1'b1) ? nll0Ol : nllO1i;
	assign		wire_n1l01O_dataout = ((~ nl00i1i) === 1'b1) ? nll0OO : nllO1l;
	assign		wire_n1l0ii_dataout = ((~ nl00i1i) === 1'b1) ? nlli0i : nllO0O;
	assign		wire_n1l0il_dataout = ((~ nl00i1i) === 1'b1) ? nlli0l : nllOii;
	assign		wire_n1l0iO_dataout = ((~ nl00i1i) === 1'b1) ? nlli0O : nllOil;
	assign		wire_n1l0li_dataout = ((~ nl00i1i) === 1'b1) ? nlliii : nllOiO;
	assign		wire_n1l0ll_dataout = ((~ nl00i1i) === 1'b1) ? nlliil : nllOli;
	assign		wire_n1l0lO_dataout = ((~ nl00i1i) === 1'b1) ? nlliiO : nllOll;
	assign		wire_n1l0Oi_dataout = ((~ nl00i1i) === 1'b1) ? nllili : nllOlO;
	assign		wire_n1l0Ol_dataout = ((~ nl00i1i) === 1'b1) ? nllill : nllOOi;
	assign		wire_n1l0OO_dataout = ((~ nl00i1i) === 1'b1) ? nllilO : nllOOl;
	assign		wire_n1l10i_dataout = ((~ nl00i1i) === 1'b1) ? nll01i : nlll1O;
	assign		wire_n1l10l_dataout = ((~ nl00i1i) === 1'b1) ? nll01l : nlll0i;
	assign		wire_n1l10O_dataout = ((~ nl00i1i) === 1'b1) ? nll01O : nlll0l;
	assign		wire_n1l11i_dataout = ((~ nl00i1i) === 1'b1) ? nll1Oi : nlliOO;
	assign		wire_n1l11l_dataout = ((~ nl00i1i) === 1'b1) ? nll1Ol : nlll1i;
	assign		wire_n1l11O_dataout = ((~ nl00i1i) === 1'b1) ? nll1OO : nlll1l;
	assign		wire_n1l1ii_dataout = ((~ nl00i1i) === 1'b1) ? nll00i : nlll0O;
	assign		wire_n1l1il_dataout = ((~ nl00i1i) === 1'b1) ? nll00l : nlllii;
	assign		wire_n1l1iO_dataout = ((~ nl00i1i) === 1'b1) ? nll00O : nlllil;
	assign		wire_n1l1li_dataout = ((~ nl00i1i) === 1'b1) ? nll0ii : nllliO;
	assign		wire_n1l1ll_dataout = ((~ nl00i1i) === 1'b1) ? nll0il : nlllli;
	assign		wire_n1l1lO_dataout = ((~ nl00i1i) === 1'b1) ? nll0iO : nlllll;
	assign		wire_n1l1Oi_dataout = ((~ nl00i1i) === 1'b1) ? nll0li : nllllO;
	assign		wire_n1l1Ol_dataout = ((~ nl00i1i) === 1'b1) ? nll0ll : nlllOi;
	assign		wire_n1l1OO_dataout = ((~ nl00i1i) === 1'b1) ? nll0lO : nlllOl;
	assign		wire_n1li_dataout = (rrxfifo_dis === 1'b1) ? wire_n101Oi_o : nl0lOll;
	assign		wire_n1li0i_dataout = ((~ nl00i1i) === 1'b1) ? nlll1i : nlO11O;
	assign		wire_n1li0l_dataout = ((~ nl00i1i) === 1'b1) ? nlll1l : nlO10i;
	assign		wire_n1li0O_dataout = ((~ nl00i1i) === 1'b1) ? nlll1O : nlO10l;
	assign		wire_n1li1i_dataout = ((~ nl00i1i) === 1'b1) ? nlliOi : nllOOO;
	assign		wire_n1li1l_dataout = ((~ nl00i1i) === 1'b1) ? nlliOl : nlO11i;
	assign		wire_n1li1O_dataout = ((~ nl00i1i) === 1'b1) ? nlliOO : nlO11l;
	assign		wire_n1liii_dataout = ((~ nl00i1i) === 1'b1) ? nlll0i : nlO10O;
	assign		wire_n1liil_dataout = ((~ nl00i1i) === 1'b1) ? nlll0l : nlO1ii;
	assign		wire_n1liiO_dataout = ((~ nl00i1i) === 1'b1) ? nlll0O : nlO1il;
	assign		wire_n1lili_dataout = ((~ nl00i1i) === 1'b1) ? nlllii : nlO1iO;
	assign		wire_n1lill_dataout = ((~ nl00i1i) === 1'b1) ? nlllil : nlO1li;
	assign		wire_n1lilO_dataout = ((~ nl00i1i) === 1'b1) ? nllliO : nlO1ll;
	assign		wire_n1liOi_dataout = ((~ nl00i1i) === 1'b1) ? nlllli : nlO1lO;
	assign		wire_n1liOl_dataout = ((~ nl00i1i) === 1'b1) ? nlllll : nlO1Oi;
	assign		wire_n1liOO_dataout = ((~ nl00i1i) === 1'b1) ? nllllO : nlO1Ol;
	assign		wire_n1ll_dataout = (rrxfifo_dis === 1'b1) ? wire_n101Ol_o : nl0lOlO;
	assign		wire_n1ll0i_dataout = ((~ nl00i1i) === 1'b1) ? nllO1i : nlO01O;
	assign		wire_n1ll0l_dataout = ((~ nl00i1i) === 1'b1) ? nllO1l : nlO00i;
	assign		wire_n1ll1i_dataout = ((~ nl00i1i) === 1'b1) ? nlllOi : nlO1OO;
	assign		wire_n1ll1l_dataout = ((~ nl00i1i) === 1'b1) ? nlllOl : nlO01i;
	assign		wire_n1ll1O_dataout = ((~ nl00i1i) === 1'b1) ? nlllOO : nlO01l;
	and(wire_n1llii_dataout, nlll1l, ~((~ nl00i1l)));
	and(wire_n1llil_dataout, nlll1O, ~((~ nl00i1l)));
	and(wire_n1lliO_dataout, nlll0i, ~((~ nl00i1l)));
	and(wire_n1llli_dataout, nlll0l, ~((~ nl00i1l)));
	and(wire_n1llll_dataout, nlll0O, ~((~ nl00i1l)));
	and(wire_n1lllO_dataout, nlllii, ~((~ nl00i1l)));
	and(wire_n1llOi_dataout, nlllil, ~((~ nl00i1l)));
	and(wire_n1llOl_dataout, nllliO, ~((~ nl00i1l)));
	and(wire_n1llOO_dataout, nlllli, ~((~ nl00i1l)));
	assign		wire_n1lO_dataout = (rrxfifo_dis === 1'b1) ? wire_n101OO_o : nl0lOOi;
	and(wire_n1lO0i_dataout, nlllOl, ~((~ nl00i1l)));
	and(wire_n1lO0l_dataout, nlllOO, ~((~ nl00i1l)));
	and(wire_n1lO0O_dataout, nllO1i, ~((~ nl00i1l)));
	and(wire_n1lO1i_dataout, nlllll, ~((~ nl00i1l)));
	and(wire_n1lO1l_dataout, nllllO, ~((~ nl00i1l)));
	and(wire_n1lO1O_dataout, nlllOi, ~((~ nl00i1l)));
	and(wire_n1lOii_dataout, nllO1l, ~((~ nl00i1l)));
	assign		wire_n1lOil_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[0] : nllO1O;
	assign		wire_n1lOiO_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[1] : nllO0i;
	assign		wire_n1lOli_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[2] : nllO0l;
	assign		wire_n1lOll_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[3] : nllO0O;
	assign		wire_n1lOlO_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[4] : nllOii;
	assign		wire_n1lOOi_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[5] : nllOil;
	assign		wire_n1lOOl_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[6] : nllOiO;
	assign		wire_n1lOOO_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[7] : nllOli;
	assign		wire_n1O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O0O_o : nl0Ol0i;
	and(wire_n1O00i_dataout, nlO1Ol, ~((~ nl00i1l)));
	and(wire_n1O00l_dataout, nlO1OO, ~((~ nl00i1l)));
	and(wire_n1O00O_dataout, nlO01i, ~((~ nl00i1l)));
	and(wire_n1O01i_dataout, nlO1ll, ~((~ nl00i1l)));
	and(wire_n1O01l_dataout, nlO1lO, ~((~ nl00i1l)));
	and(wire_n1O01O_dataout, nlO1Oi, ~((~ nl00i1l)));
	and(wire_n1O0ii_dataout, nlO01l, ~((~ nl00i1l)));
	and(wire_n1O0il_dataout, nlO01O, ~((~ nl00i1l)));
	and(wire_n1O0iO_dataout, nlO00i, ~((~ nl00i1l)));
	or(wire_n1O0l_dataout, wire_n1O0O_dataout, n11ii);
	assign		wire_n1O0ll_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[0] : wire_n011OO_dataout;
	assign		wire_n1O0lO_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[1] : wire_n0101i_dataout;
	assign		wire_n1O0O_dataout = (rwa_6g_en === 1'b1) ? (sync_resync_delay[0] | sync_resync_delay[1]) : wire_n1Oii_dataout;
	assign		wire_n1O0Oi_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[2] : wire_n0101l_dataout;
	assign		wire_n1O0Ol_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[3] : wire_n0101O_dataout;
	assign		wire_n1O0OO_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[4] : wire_n0100i_dataout;
	and(wire_n1O10i_dataout, nllOOl, ~((~ nl00i1l)));
	and(wire_n1O10l_dataout, nllOOO, ~((~ nl00i1l)));
	and(wire_n1O10O_dataout, nlO11i, ~((~ nl00i1l)));
	assign		wire_n1O11i_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[8] : nllOll;
	assign		wire_n1O11l_dataout = ((~ nl00i1l) === 1'b1) ? rbytordpadval[9] : nllOlO;
	assign		wire_n1O11O_dataout = ((~ nl00i1l) === 1'b1) ? nllill : nllOOi;
	and(wire_n1O1ii_dataout, nlO11l, ~((~ nl00i1l)));
	and(wire_n1O1il_dataout, nlO11O, ~((~ nl00i1l)));
	and(wire_n1O1iO_dataout, nlO10i, ~((~ nl00i1l)));
	and(wire_n1O1li_dataout, nlO10l, ~((~ nl00i1l)));
	and(wire_n1O1ll_dataout, nlO10O, ~((~ nl00i1l)));
	and(wire_n1O1lO_dataout, nlO1ii, ~((~ nl00i1l)));
	and(wire_n1O1Oi_dataout, nlO1il, ~((~ nl00i1l)));
	and(wire_n1O1Ol_dataout, nlO1iO, ~((~ nl00i1l)));
	and(wire_n1O1OO_dataout, nlO1li, ~((~ nl00i1l)));
	assign		wire_n1Oi_dataout = (rrxfifo_dis === 1'b1) ? wire_n1001i_o : nl0lOOl;
	assign		wire_n1Oi0i_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[8] : wire_n010il_dataout;
	assign		wire_n1Oi0l_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[9] : wire_n010iO_dataout;
	assign		wire_n1Oi0O_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[10] : wire_n010li_dataout;
	assign		wire_n1Oi1i_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[5] : wire_n0100l_dataout;
	assign		wire_n1Oi1l_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[6] : wire_n0100O_dataout;
	assign		wire_n1Oi1O_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[7] : wire_n010ii_dataout;
	assign		wire_n1Oii_dataout = (rsync_sm_dis === 1'b1) ? wire_n1Oil_dataout : dec_data_valid_pre[0];
	assign		wire_n1Oiii_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[11] : wire_n010ll_dataout;
	assign		wire_n1Oiil_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[12] : wire_n010lO_dataout;
	assign		wire_n1OiiO_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[13] : wire_n010Oi_dataout;
	assign		wire_n1Oil_dataout = (((~ rpmadatawidth) & tenb_data[8]) === 1'b1) ? sync_resync_pre[0] : sync_resync_delay[0];
	assign		wire_n1Oili_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[14] : wire_n010Ol_dataout;
	assign		wire_n1Oill_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[15] : wire_n010OO_dataout;
	assign		wire_n1OilO_dataout = (nl0i10i === 1'b1) ? wire_n0010i_dataout : wire_n01i1i_dataout;
	assign		wire_n1OiOi_dataout = (nl0i10i === 1'b1) ? wire_n0010l_dataout : wire_n01i1l_dataout;
	assign		wire_n1OiOl_dataout = (nl0i10i === 1'b1) ? wire_n0010O_dataout : wire_n01i1O_dataout;
	assign		wire_n1OiOO_dataout = (nl0i10i === 1'b1) ? wire_n001ii_dataout : wire_n01i0i_dataout;
	assign		wire_n1Ol_dataout = (rrxfifo_dis === 1'b1) ? wire_n1001l_o : nl0lOOO;
	assign		wire_n1Ol0i_dataout = (nl0i10i === 1'b1) ? wire_n001ll_dataout : wire_n01iil_dataout;
	assign		wire_n1Ol0l_dataout = (nl0i10i === 1'b1) ? wire_n001lO_dataout : wire_n01iiO_dataout;
	assign		wire_n1Ol0O_dataout = (nl0i10i === 1'b1) ? wire_n001Oi_dataout : wire_n01ili_dataout;
	assign		wire_n1Ol1i_dataout = (nl0i10i === 1'b1) ? wire_n001il_dataout : wire_n01i0l_dataout;
	assign		wire_n1Ol1l_dataout = (nl0i10i === 1'b1) ? wire_n001iO_dataout : wire_n01i0O_dataout;
	assign		wire_n1Ol1O_dataout = (nl0i10i === 1'b1) ? wire_n001li_dataout : wire_n01iii_dataout;
	assign		wire_n1Olii_dataout = (nl0i10i === 1'b1) ? wire_n001Ol_dataout : wire_n01ill_dataout;
	assign		wire_n1Olil_dataout = (nl0i10i === 1'b1) ? wire_n001OO_dataout : wire_n01ilO_dataout;
	assign		wire_n1OliO_dataout = (nl0i10i === 1'b1) ? wire_n0001i_dataout : wire_n01iOi_dataout;
	assign		wire_n1Oll_dataout = (endec_rx === 1'b1) ? wire_n0i1l_dataout : wire_n00OO_dataout;
	assign		wire_n1Olli_dataout = (nl0i10i === 1'b1) ? wire_n0001l_dataout : wire_n01iOl_dataout;
	assign		wire_n1Olll_dataout = (nl0i10i === 1'b1) ? wire_n0001O_dataout : wire_n01iOO_dataout;
	assign		wire_n1OllO_dataout = (nl0i10i === 1'b1) ? wire_n0000i_dataout : wire_n01l1i_dataout;
	assign		wire_n1OlO_dataout = (endec_rx === 1'b1) ? wire_n0i1O_dataout : wire_n00Oi_dataout;
	assign		wire_n1OlOi_dataout = (nl0i10i === 1'b1) ? wire_n0000l_dataout : wire_n01l1l_dataout;
	assign		wire_n1OlOl_dataout = (nl0i10i === 1'b1) ? wire_n0000O_dataout : wire_n01l1O_dataout;
	assign		wire_n1OlOO_dataout = (nl0i10i === 1'b1) ? wire_n000ii_dataout : wire_n01l0i_dataout;
	assign		wire_n1OO_dataout = (rrxfifo_dis === 1'b1) ? wire_n1001O_o : nl0O11i;
	assign		wire_n1OO0i_dataout = (nl0i10i === 1'b1) ? wire_n000ll_dataout : wire_n01lil_dataout;
	assign		wire_n1OO0l_dataout = (nl0i10i === 1'b1) ? wire_n000lO_dataout : wire_n01liO_dataout;
	assign		wire_n1OO0O_dataout = (nl0i10i === 1'b1) ? wire_n000Oi_dataout : wire_n01lli_dataout;
	assign		wire_n1OO1i_dataout = (nl0i10i === 1'b1) ? wire_n000il_dataout : wire_n01l0l_dataout;
	assign		wire_n1OO1l_dataout = (nl0i10i === 1'b1) ? wire_n000iO_dataout : wire_n01l0O_dataout;
	assign		wire_n1OO1O_dataout = (nl0i10i === 1'b1) ? wire_n000li_dataout : wire_n01lii_dataout;
	assign		wire_n1OOi_dataout = (endec_rx === 1'b1) ? wire_n0i0i_dataout : tenb_data[0];
	assign		wire_n1OOii_dataout = (nl0i10i === 1'b1) ? wire_n000Ol_dataout : wire_n01lll_dataout;
	assign		wire_n1OOil_dataout = (nl0i10i === 1'b1) ? wire_n000OO_dataout : wire_n01llO_dataout;
	assign		wire_n1OOiO_dataout = (nl0i10i === 1'b1) ? wire_n00i1i_dataout : wire_n01lOi_dataout;
	assign		wire_n1OOl_dataout = (endec_rx === 1'b1) ? wire_n0i0l_dataout : tenb_data[1];
	assign		wire_n1OOli_dataout = (nl0i10i === 1'b1) ? wire_n00i1l_dataout : wire_n01lOl_dataout;
	assign		wire_n1OOll_dataout = (nl0i10i === 1'b1) ? wire_n00i1O_dataout : wire_n01lOO_dataout;
	assign		wire_n1OOlO_dataout = (nl0i10i === 1'b1) ? wire_n00i0i_dataout : wire_n01O1i_dataout;
	assign		wire_n1OOO_dataout = (endec_rx === 1'b1) ? wire_n0i0O_dataout : tenb_data[2];
	assign		wire_n1OOOi_dataout = (nl0i10i === 1'b1) ? wire_n00i0l_dataout : wire_n01O1l_dataout;
	assign		wire_n1OOOl_dataout = (nl0i10i === 1'b1) ? wire_n00i0O_dataout : wire_n01O1O_dataout;
	assign		wire_n1OOOO_dataout = (nl0i10i === 1'b1) ? wire_n00iii_dataout : wire_n01O0i_dataout;
	and(wire_ni000i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[54], ~(nl00i0l));
	and(wire_ni000l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[55], ~(nl00i0l));
	and(wire_ni000O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[56], ~(nl00i0l));
	and(wire_ni001i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[51], ~(nl00i0l));
	and(wire_ni001l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[52], ~(nl00i0l));
	and(wire_ni001O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[53], ~(nl00i0l));
	and(wire_ni00i_dataout, rx_data_dt[13], ~(nl0i00O));
	and(wire_ni00ii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[57], ~(nl00i0l));
	and(wire_ni00il_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[58], ~(nl00i0l));
	and(wire_ni00iO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[59], ~(nl00i0l));
	and(wire_ni00l_dataout, rx_data_dt[14], ~(nl0i00O));
	and(wire_ni00li_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[60], ~(nl00i0l));
	and(wire_ni00ll_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[61], ~(nl00i0l));
	and(wire_ni00lO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[62], ~(nl00i0l));
	or(wire_ni00O_dataout, rx_data_dt[15], nl0i00O);
	and(wire_ni00Oi_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[63], ~(nl00i0l));
	assign		wire_ni00Ol_dataout = (nl0i10i === 1'b1) ? nlli1i : wire_nii01O_o;
	assign		wire_ni00OO_dataout = (nl0i10i === 1'b1) ? nlli1l : wire_nii00i_o;
	and(wire_ni010i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[39], ~(nl00i0l));
	and(wire_ni010l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[40], ~(nl00i0l));
	and(wire_ni010O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[41], ~(nl00i0l));
	and(wire_ni011i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[36], ~(nl00i0l));
	and(wire_ni011l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[37], ~(nl00i0l));
	and(wire_ni011O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[38], ~(nl00i0l));
	or(wire_ni01i_dataout, rx_data_dt[10], nl0i00O);
	and(wire_ni01ii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[42], ~(nl00i0l));
	and(wire_ni01il_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[43], ~(nl00i0l));
	and(wire_ni01iO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[44], ~(nl00i0l));
	or(wire_ni01l_dataout, rx_data_dt[11], nl0i00O);
	and(wire_ni01li_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[45], ~(nl00i0l));
	and(wire_ni01ll_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[46], ~(nl00i0l));
	and(wire_ni01lO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[47], ~(nl00i0l));
	or(wire_ni01O_dataout, rx_data_dt[12], nl0i00O);
	and(wire_ni01Oi_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[48], ~(nl00i0l));
	and(wire_ni01Ol_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[49], ~(nl00i0l));
	and(wire_ni01OO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[50], ~(nl00i0l));
	assign		wire_ni0i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iii_o : nl0O00l;
	assign		wire_ni0i0i_dataout = (nl0i10i === 1'b1) ? nlli0O : wire_nii0il_o;
	assign		wire_ni0i0l_dataout = (nl0i10i === 1'b1) ? nlliii : wire_nii0iO_o;
	assign		wire_ni0i0O_dataout = (nl0i10i === 1'b1) ? nlliil : wire_nii0li_o;
	assign		wire_ni0i1i_dataout = (nl0i10i === 1'b1) ? nlli1O : wire_nii00l_o;
	assign		wire_ni0i1l_dataout = (nl0i10i === 1'b1) ? nlli0i : wire_nii00O_o;
	assign		wire_ni0i1O_dataout = (nl0i10i === 1'b1) ? nlli0l : wire_nii0ii_o;
	or(wire_ni0ii_dataout, rx_control_dt[1], nl0i00O);
	assign		wire_ni0iii_dataout = (nl0i10i === 1'b1) ? nlliiO : wire_nii0ll_o;
	assign		wire_ni0iil_dataout = (nl0i10i === 1'b1) ? nllili : wire_nii0lO_o;
	assign		wire_ni0iiO_dataout = (nl0i10i === 1'b1) ? nllill : wire_nii0Oi_o;
	assign		wire_ni0ili_dataout = (nl0i10i === 1'b1) ? nllilO : wire_nii0Ol_o;
	assign		wire_ni0ill_dataout = (nl0i10i === 1'b1) ? nlliOi : wire_nii0OO_o;
	assign		wire_ni0ilO_dataout = (nl0i10i === 1'b1) ? nlliOl : wire_niii1i_o;
	assign		wire_ni0iO_dataout = ((~ n110l) === 1'b1) ? wire_nil1l_dataout : wire_nliil_o;
	assign		wire_ni0iOi_dataout = (nl0i10i === 1'b1) ? nlliOO : wire_niii1l_o;
	assign		wire_ni0iOl_dataout = (nl0i10i === 1'b1) ? nlll1i : wire_niii1O_o;
	assign		wire_ni0iOO_dataout = (nl0i10i === 1'b1) ? wire_nil1ii_dataout : wire_niii0i_o;
	assign		wire_ni0l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iil_o : nl0O00O;
	assign		wire_ni0l0i_dataout = (nl0i10i === 1'b1) ? wire_nil1ll_dataout : wire_niiiil_o;
	assign		wire_ni0l0l_dataout = (nl0i10i === 1'b1) ? wire_nil1lO_dataout : wire_niiiiO_o;
	assign		wire_ni0l0O_dataout = (nl0i10i === 1'b1) ? wire_nil1Oi_dataout : wire_niiili_o;
	assign		wire_ni0l1i_dataout = (nl0i10i === 1'b1) ? wire_nil1il_dataout : wire_niii0l_o;
	assign		wire_ni0l1l_dataout = (nl0i10i === 1'b1) ? wire_nil1iO_dataout : wire_niii0O_o;
	assign		wire_ni0l1O_dataout = (nl0i10i === 1'b1) ? wire_nil1li_dataout : wire_niiiii_o;
	assign		wire_ni0li_dataout = ((~ n110l) === 1'b1) ? wire_nil1O_dataout : wire_nii0i_dataout;
	assign		wire_ni0lii_dataout = (nl0i10i === 1'b1) ? wire_nil1Ol_dataout : wire_niiill_o;
	assign		wire_ni0lil_dataout = (nl0i10i === 1'b1) ? wire_nil1OO_dataout : wire_niiilO_o;
	assign		wire_ni0liO_dataout = (nl0i10i === 1'b1) ? wire_nil01i_dataout : wire_niiiOi_o;
	assign		wire_ni0ll_dataout = ((~ n110l) === 1'b1) ? wire_nil0i_dataout : wire_nii0l_dataout;
	assign		wire_ni0lli_dataout = (nl0i10i === 1'b1) ? wire_nil01l_dataout : wire_niiiOl_o;
	assign		wire_ni0lll_dataout = (nl0i10i === 1'b1) ? wire_nil01O_dataout : wire_niiiOO_o;
	assign		wire_ni0llO_dataout = (nl0i10i === 1'b1) ? wire_nil00i_dataout : wire_niil1i_o;
	assign		wire_ni0lO_dataout = ((~ n110l) === 1'b1) ? wire_nil0l_dataout : wire_nii0O_dataout;
	assign		wire_ni0lOi_dataout = (nl0i10i === 1'b1) ? wire_nil00l_dataout : wire_niil1l_o;
	assign		wire_ni0lOl_dataout = (nl0i10i === 1'b1) ? wire_nil00O_dataout : wire_niil1O_o;
	assign		wire_ni0lOO_dataout = (nl0i10i === 1'b1) ? wire_nil0ii_dataout : wire_niil0i_o;
	assign		wire_ni0O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iiO_o : nl0O0ii;
	assign		wire_ni0O0i_dataout = (nl0i10i === 1'b1) ? wire_nil0lO_dataout : wire_niilil_o;
	assign		wire_ni0O0l_dataout = (nl0i10i === 1'b1) ? wire_nil0Oi_dataout : wire_niiliO_o;
	assign		wire_ni0O0O_dataout = (nl0i10i === 1'b1) ? wire_nil0Ol_dataout : wire_niilli_o;
	assign		wire_ni0O1i_dataout = (nl0i10i === 1'b1) ? wire_nil0iO_dataout : wire_niil0l_o;
	assign		wire_ni0O1l_dataout = (nl0i10i === 1'b1) ? wire_nil0li_dataout : wire_niil0O_o;
	assign		wire_ni0O1O_dataout = (nl0i10i === 1'b1) ? wire_nil0ll_dataout : wire_niilii_o;
	assign		wire_ni0Oi_dataout = ((~ n110l) === 1'b1) ? wire_nil0O_dataout : wire_niiii_dataout;
	assign		wire_ni0Oii_dataout = (nl0i10i === 1'b1) ? wire_nil0OO_dataout : wire_niilll_o;
	assign		wire_ni0Oil_dataout = (nl0i10i === 1'b1) ? wire_nili1i_dataout : wire_niillO_o;
	assign		wire_ni0OiO_dataout = (nl0i10i === 1'b1) ? wire_nili1l_dataout : wire_niilOi_o;
	assign		wire_ni0Ol_dataout = ((~ n110l) === 1'b1) ? wire_nilii_dataout : wire_niiil_dataout;
	assign		wire_ni0Oli_dataout = (nl0i10i === 1'b1) ? wire_nili1O_dataout : wire_niilOl_o;
	assign		wire_ni0Oll_dataout = (nl0i10i === 1'b1) ? wire_nili0i_o : wire_niilOO_o;
	assign		wire_ni0OlO_dataout = (nl0i10i === 1'b1) ? wire_nili0l_dataout : wire_niiO1i_o;
	assign		wire_ni0OO_dataout = ((~ n110l) === 1'b1) ? wire_nilil_dataout : wire_niiiO_dataout;
	assign		wire_ni0OOi_dataout = (nl0i10i === 1'b1) ? wire_nili0O_dataout : wire_niiO1l_o;
	assign		wire_ni0OOl_dataout = (nl0i10i === 1'b1) ? wire_niliii_dataout : wire_niiO1O_o;
	assign		wire_ni0OOO_dataout = (nl0i10i === 1'b1) ? wire_niliil_dataout : wire_niiO0i_o;
	assign		wire_ni100i_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[11] : wire_nl0l0Ol_byte_des_fifo_data_in[27];
	assign		wire_ni100l_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[12] : wire_nl0l0Ol_byte_des_fifo_data_in[28];
	assign		wire_ni100O_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[13] : wire_nl0l0Ol_byte_des_fifo_data_in[29];
	assign		wire_ni101i_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[8] : wire_nl0l0Ol_byte_des_fifo_data_in[24];
	assign		wire_ni101l_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[9] : wire_nl0l0Ol_byte_des_fifo_data_in[25];
	assign		wire_ni101O_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[10] : wire_nl0l0Ol_byte_des_fifo_data_in[26];
	or(wire_ni10i_dataout, rx_data_dt[12], nl0i00l);
	assign		wire_ni10ii_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[14] : wire_nl0l0Ol_byte_des_fifo_data_in[30];
	assign		wire_ni10il_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[15] : wire_nl0l0Ol_byte_des_fifo_data_in[31];
	and(wire_ni10iO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[32], ~(nl00i0i));
	or(wire_ni10l_dataout, rx_data_dt[13], nl0i00l);
	and(wire_ni10li_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[33], ~(nl00i0i));
	and(wire_ni10ll_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[34], ~(nl00i0i));
	and(wire_ni10lO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[35], ~(nl00i0i));
	or(wire_ni10O_dataout, rx_data_dt[14], nl0i00l);
	and(wire_ni10Oi_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[36], ~(nl00i0i));
	and(wire_ni10Ol_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[37], ~(nl00i0i));
	and(wire_ni10OO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[38], ~(nl00i0i));
	assign		wire_ni110i_dataout = (nl00i0i === 1'b1) ? nlllOl : wire_nl0l0Ol_byte_des_fifo_data_in[12];
	assign		wire_ni110l_dataout = (nl00i0i === 1'b1) ? nlllOO : wire_nl0l0Ol_byte_des_fifo_data_in[13];
	assign		wire_ni110O_dataout = (nl00i0i === 1'b1) ? nllO1i : wire_nl0l0Ol_byte_des_fifo_data_in[14];
	assign		wire_ni111i_dataout = (nl00i0i === 1'b1) ? nlllll : wire_nl0l0Ol_byte_des_fifo_data_in[9];
	assign		wire_ni111l_dataout = (nl00i0i === 1'b1) ? nllllO : wire_nl0l0Ol_byte_des_fifo_data_in[10];
	assign		wire_ni111O_dataout = (nl00i0i === 1'b1) ? nlllOi : wire_nl0l0Ol_byte_des_fifo_data_in[11];
	or(wire_ni11i_dataout, rx_data_dt[9], nl0i00l);
	assign		wire_ni11ii_dataout = (nl00i0i === 1'b1) ? nllO1l : wire_nl0l0Ol_byte_des_fifo_data_in[15];
	assign		wire_ni11il_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[0] : wire_nl0l0Ol_byte_des_fifo_data_in[16];
	assign		wire_ni11iO_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[1] : wire_nl0l0Ol_byte_des_fifo_data_in[17];
	or(wire_ni11l_dataout, rx_data_dt[10], nl0i00l);
	assign		wire_ni11li_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[2] : wire_nl0l0Ol_byte_des_fifo_data_in[18];
	assign		wire_ni11ll_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[3] : wire_nl0l0Ol_byte_des_fifo_data_in[19];
	assign		wire_ni11lO_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[4] : wire_nl0l0Ol_byte_des_fifo_data_in[20];
	assign		wire_ni11O_dataout = (nl0i00l === 1'b1) ? (~ rclkcmpinsertpad) : rx_data_dt[11];
	assign		wire_ni11Oi_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[5] : wire_nl0l0Ol_byte_des_fifo_data_in[21];
	assign		wire_ni11Ol_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[6] : wire_nl0l0Ol_byte_des_fifo_data_in[22];
	assign		wire_ni11OO_dataout = (nl00i0i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[7] : wire_nl0l0Ol_byte_des_fifo_data_in[23];
	assign		wire_ni1i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i0i_o : nl0O01l;
	and(wire_ni1i0i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[42], ~(nl00i0i));
	and(wire_ni1i0l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[43], ~(nl00i0i));
	and(wire_ni1i0O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[44], ~(nl00i0i));
	and(wire_ni1i1i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[39], ~(nl00i0i));
	and(wire_ni1i1l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[40], ~(nl00i0i));
	and(wire_ni1i1O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[41], ~(nl00i0i));
	or(wire_ni1ii_dataout, rx_data_dt[15], nl0i00l);
	and(wire_ni1iii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[45], ~(nl00i0i));
	and(wire_ni1iil_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[46], ~(nl00i0i));
	and(wire_ni1iiO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[47], ~(nl00i0i));
	or(wire_ni1il_dataout, rx_control_dt[1], nl0i00l);
	and(wire_ni1ili_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[48], ~(nl00i0i));
	and(wire_ni1ill_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[49], ~(nl00i0i));
	and(wire_ni1ilO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[50], ~(nl00i0i));
	and(wire_ni1iOi_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[51], ~(nl00i0i));
	and(wire_ni1iOl_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[52], ~(nl00i0i));
	and(wire_ni1iOO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[53], ~(nl00i0i));
	assign		wire_ni1l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i0l_o : nl0O01O;
	and(wire_ni1l0i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[57], ~(nl00i0i));
	and(wire_ni1l0l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[58], ~(nl00i0i));
	and(wire_ni1l0O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[59], ~(nl00i0i));
	and(wire_ni1l1i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[54], ~(nl00i0i));
	and(wire_ni1l1l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[55], ~(nl00i0i));
	and(wire_ni1l1O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[56], ~(nl00i0i));
	and(wire_ni1lii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[60], ~(nl00i0i));
	and(wire_ni1lil_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[61], ~(nl00i0i));
	and(wire_ni1liO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[62], ~(nl00i0i));
	and(wire_ni1lli_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[63], ~(nl00i0i));
	assign		wire_ni1lll_dataout = (nl00i0l === 1'b1) ? rbytordpadval[0] : wire_nl0l0Ol_byte_des_fifo_data_in[16];
	assign		wire_ni1llO_dataout = (nl00i0l === 1'b1) ? rbytordpadval[1] : wire_nl0l0Ol_byte_des_fifo_data_in[17];
	assign		wire_ni1lOi_dataout = (nl00i0l === 1'b1) ? rbytordpadval[2] : wire_nl0l0Ol_byte_des_fifo_data_in[18];
	assign		wire_ni1lOl_dataout = (nl00i0l === 1'b1) ? rbytordpadval[3] : wire_nl0l0Ol_byte_des_fifo_data_in[19];
	assign		wire_ni1lOO_dataout = (nl00i0l === 1'b1) ? rbytordpadval[4] : wire_nl0l0Ol_byte_des_fifo_data_in[20];
	assign		wire_ni1O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i0O_o : nl0O00i;
	assign		wire_ni1O0i_dataout = (nl00i0l === 1'b1) ? rbytordpadval[8] : wire_nl0l0Ol_byte_des_fifo_data_in[24];
	assign		wire_ni1O0l_dataout = (nl00i0l === 1'b1) ? rbytordpadval[9] : wire_nl0l0Ol_byte_des_fifo_data_in[25];
	assign		wire_ni1O0O_dataout = (nl00i0l === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[10] : wire_nl0l0Ol_byte_des_fifo_data_in[26];
	assign		wire_ni1O1i_dataout = (nl00i0l === 1'b1) ? rbytordpadval[5] : wire_nl0l0Ol_byte_des_fifo_data_in[21];
	assign		wire_ni1O1l_dataout = (nl00i0l === 1'b1) ? rbytordpadval[6] : wire_nl0l0Ol_byte_des_fifo_data_in[22];
	assign		wire_ni1O1O_dataout = (nl00i0l === 1'b1) ? rbytordpadval[7] : wire_nl0l0Ol_byte_des_fifo_data_in[23];
	and(wire_ni1Oi_dataout, wire_niOil_o, ~(nl0i00O));
	and(wire_ni1Oii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[27], ~(nl00i0l));
	and(wire_ni1Oil_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[28], ~(nl00i0l));
	and(wire_ni1OiO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[29], ~(nl00i0l));
	and(wire_ni1Ol_dataout, rx_data_dt[8], ~(nl0i00O));
	and(wire_ni1Oli_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[30], ~(nl00i0l));
	and(wire_ni1Oll_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[31], ~(nl00i0l));
	and(wire_ni1OlO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[32], ~(nl00i0l));
	and(wire_ni1OO_dataout, rx_data_dt[9], ~(nl0i00O));
	and(wire_ni1OOi_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[33], ~(nl00i0l));
	and(wire_ni1OOl_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[34], ~(nl00i0l));
	and(wire_ni1OOO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[35], ~(nl00i0l));
	assign		wire_nii_dataout = (rrxfifo_dis === 1'b1) ? wire_n10Oli_o : nl0Olil;
	assign		wire_nii01i_dataout = (nl0i10i === 1'b1) ? wire_nillll_dataout : wire_nil10l_o;
	assign		wire_nii01l_dataout = (nl0i10i === 1'b1) ? wire_nilllO_dataout : wire_nil10O_o;
	assign		wire_nii0i_dataout = (nl0i0ii === 1'b1) ? rclkcmpinsertpad : rx_data_dt[0];
	or(wire_nii0l_dataout, rx_data_dt[1], nl0i0ii);
	or(wire_nii0O_dataout, rx_data_dt[2], nl0i0ii);
	assign		wire_nii10i_dataout = (nl0i10i === 1'b1) ? wire_niliOl_dataout : wire_niiOil_o;
	assign		wire_nii10l_dataout = (nl0i10i === 1'b1) ? wire_niliOO_dataout : wire_niiOiO_o;
	assign		wire_nii10O_dataout = (nl0i10i === 1'b1) ? wire_nill1i_dataout : wire_niiOli_o;
	assign		wire_nii11i_dataout = (nl0i10i === 1'b1) ? wire_niliiO_dataout : wire_niiO0l_o;
	assign		wire_nii11l_dataout = (nl0i10i === 1'b1) ? wire_nililO_dataout : wire_niiO0O_o;
	assign		wire_nii11O_dataout = (nl0i10i === 1'b1) ? wire_niliOi_dataout : wire_niiOii_o;
	assign		wire_nii1i_dataout = ((~ n110l) === 1'b1) ? wire_niliO_dataout : wire_niili_dataout;
	assign		wire_nii1ii_dataout = (nl0i10i === 1'b1) ? wire_nill1l_dataout : wire_niiOll_o;
	assign		wire_nii1il_dataout = (nl0i10i === 1'b1) ? wire_nill1O_dataout : wire_niiOlO_o;
	assign		wire_nii1iO_dataout = (nl0i10i === 1'b1) ? wire_nill0i_dataout : wire_niiOOi_o;
	assign		wire_nii1l_dataout = ((~ n110l) === 1'b1) ? wire_nilli_dataout : wire_niill_dataout;
	assign		wire_nii1li_dataout = (nl0i10i === 1'b1) ? wire_nill0l_dataout : wire_niiOOl_o;
	assign		wire_nii1ll_dataout = (nl0i10i === 1'b1) ? wire_nill0O_dataout : wire_niiOOO_o;
	assign		wire_nii1lO_dataout = (nl0i10i === 1'b1) ? wire_nillii_o : wire_nil11i_o;
	assign		wire_nii1O_dataout = ((~ n110l) === 1'b1) ? wire_nilll_dataout : wire_niilO_dataout;
	assign		wire_nii1Oi_dataout = (nl0i10i === 1'b1) ? wire_nillil_dataout : wire_nil11l_o;
	assign		wire_nii1Ol_dataout = (nl0i10i === 1'b1) ? wire_nilliO_dataout : wire_nil11O_o;
	assign		wire_nii1OO_dataout = (nl0i10i === 1'b1) ? wire_nillli_dataout : wire_nil10i_o;
	assign		wire_niii_dataout = (rrxfifo_dis === 1'b1) ? wire_n10ili_o : nl0O0il;
	assign		wire_niiii_dataout = (nl0i0ii === 1'b1) ? (~ rclkcmpinsertpad) : rx_data_dt[3];
	or(wire_niiil_dataout, rx_data_dt[4], nl0i0ii);
	or(wire_niiiO_dataout, rx_data_dt[5], nl0i0ii);
	assign		wire_niil_dataout = (rrxfifo_dis === 1'b1) ? wire_n10ill_o : nl0O0iO;
	or(wire_niili_dataout, rx_data_dt[6], nl0i0ii);
	or(wire_niill_dataout, rx_data_dt[7], nl0i0ii);
	or(wire_niilO_dataout, rx_control_dt[0], nl0i0ii);
	assign		wire_niiO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10ilO_o : nl0O0li;
	assign		wire_nil_dataout = (rrxfifo_dis === 1'b1) ? wire_n10Oll_o : nl0OliO;
	and(wire_nil00i_dataout, nlllOl, ~(wire_nil0il_o[2]));
	and(wire_nil00l_dataout, nlllOO, ~(wire_nil0il_o[2]));
	and(wire_nil00O_dataout, nllO1i, ~(wire_nil0il_o[2]));
	assign		wire_nil01i_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[9] : nlllll;
	assign		wire_nil01l_dataout = (wire_nil0il_o[2] === 1'b1) ? nllill : nllllO;
	and(wire_nil01O_dataout, nlllOi, ~(wire_nil0il_o[2]));
	and(wire_nil0i_dataout, rx_data_dt[1], ~(nl0i0il));
	and(wire_nil0ii_dataout, nllO1l, ~(wire_nil0il_o[2]));
	assign		wire_nil0iO_dataout = (nl00i0O === 1'b1) ? rbytordpadval[0] : nllO1O;
	or(wire_nil0l_dataout, rx_data_dt[2], nl0i0il);
	assign		wire_nil0li_dataout = (nl00i0O === 1'b1) ? rbytordpadval[1] : nllO0i;
	assign		wire_nil0ll_dataout = (nl00i0O === 1'b1) ? rbytordpadval[2] : nllO0l;
	assign		wire_nil0lO_dataout = (nl00i0O === 1'b1) ? rbytordpadval[3] : nllO0O;
	or(wire_nil0O_dataout, rx_data_dt[3], nl0i0il);
	assign		wire_nil0Oi_dataout = (nl00i0O === 1'b1) ? rbytordpadval[4] : nllOii;
	assign		wire_nil0Ol_dataout = (nl00i0O === 1'b1) ? rbytordpadval[5] : nllOil;
	assign		wire_nil0OO_dataout = (nl00i0O === 1'b1) ? rbytordpadval[6] : nllOiO;
	assign		wire_nil1ii_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[0] : nlll1l;
	assign		wire_nil1il_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[1] : nlll1O;
	assign		wire_nil1iO_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[2] : nlll0i;
	and(wire_nil1l_dataout, wire_nliil_o, ~(nl0i0il));
	assign		wire_nil1li_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[3] : nlll0l;
	assign		wire_nil1ll_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[4] : nlll0O;
	assign		wire_nil1lO_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[5] : nlllii;
	and(wire_nil1O_dataout, rx_data_dt[0], ~(nl0i0il));
	assign		wire_nil1Oi_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[6] : nlllil;
	assign		wire_nil1Ol_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[7] : nllliO;
	assign		wire_nil1OO_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[8] : nlllli;
	assign		wire_nili_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iOi_o : nl0O0ll;
	and(wire_nili0l_dataout, nllOOl, ~(nl00i0O));
	and(wire_nili0O_dataout, nllOOO, ~(nl00i0O));
	assign		wire_nili1i_dataout = (nl00i0O === 1'b1) ? rbytordpadval[7] : nllOli;
	assign		wire_nili1l_dataout = (nl00i0O === 1'b1) ? rbytordpadval[8] : nllOll;
	assign		wire_nili1O_dataout = (nl00i0O === 1'b1) ? rbytordpadval[9] : nllOlO;
	or(wire_nilii_dataout, rx_data_dt[4], nl0i0il);
	and(wire_niliii_dataout, nlO11i, ~(nl00i0O));
	and(wire_niliil_dataout, nlO11l, ~(nl00i0O));
	and(wire_niliiO_dataout, nlO11O, ~(nl00i0O));
	and(wire_nilil_dataout, rx_data_dt[5], ~(nl0i0il));
	assign		wire_nililO_dataout = (nl00iii === 1'b1) ? rbytordpadval[0] : nlO10i;
	and(wire_niliO_dataout, rx_data_dt[6], ~(nl0i0il));
	assign		wire_niliOi_dataout = (nl00iii === 1'b1) ? rbytordpadval[1] : nlO10l;
	assign		wire_niliOl_dataout = (nl00iii === 1'b1) ? rbytordpadval[2] : nlO10O;
	assign		wire_niliOO_dataout = (nl00iii === 1'b1) ? rbytordpadval[3] : nlO1ii;
	assign		wire_nill_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iOl_o : nl0O0lO;
	assign		wire_nill0i_dataout = (nl00iii === 1'b1) ? rbytordpadval[7] : nlO1ll;
	assign		wire_nill0l_dataout = (nl00iii === 1'b1) ? rbytordpadval[8] : nlO1lO;
	assign		wire_nill0O_dataout = (nl00iii === 1'b1) ? rbytordpadval[9] : nlO1Oi;
	assign		wire_nill1i_dataout = (nl00iii === 1'b1) ? rbytordpadval[4] : nlO1il;
	assign		wire_nill1l_dataout = (nl00iii === 1'b1) ? rbytordpadval[5] : nlO1iO;
	assign		wire_nill1O_dataout = (nl00iii === 1'b1) ? rbytordpadval[6] : nlO1li;
	or(wire_nilli_dataout, rx_data_dt[7], nl0i0il);
	and(wire_nillil_dataout, nlO1OO, ~(nl00iii));
	and(wire_nilliO_dataout, nlO01i, ~(nl00iii));
	or(wire_nilll_dataout, rx_control_dt[0], nl0i0il);
	and(wire_nillli_dataout, nlO01l, ~(nl00iii));
	and(wire_nillll_dataout, nlO01O, ~(nl00iii));
	and(wire_nilllO_dataout, nlO00i, ~(nl00iii));
	assign		wire_nillOO_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[0] : wire_niOl0i_o;
	assign		wire_nilO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iOO_o : nl0O0Oi;
	assign		wire_nilO0i_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[4] : wire_niOlil_o;
	assign		wire_nilO0l_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[5] : wire_niOliO_o;
	assign		wire_nilO0O_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[6] : wire_niOlli_o;
	assign		wire_nilO1i_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[1] : wire_niOl0l_o;
	assign		wire_nilO1l_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[2] : wire_niOl0O_o;
	assign		wire_nilO1O_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[3] : wire_niOlii_o;
	assign		wire_nilOii_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[7] : wire_niOlll_o;
	assign		wire_nilOil_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[8] : wire_niOllO_o;
	assign		wire_nilOiO_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[9] : wire_niOlOi_o;
	assign		wire_nilOli_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[10] : wire_niOlOl_o;
	assign		wire_nilOll_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[11] : wire_niOlOO_o;
	assign		wire_nilOlO_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[12] : wire_niOO1i_o;
	assign		wire_nilOOi_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[13] : wire_niOO1l_o;
	assign		wire_nilOOl_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[14] : wire_niOO1O_o;
	assign		wire_nilOOO_dataout = (nl0i10i === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[15] : wire_niOO0i_o;
	assign		wire_niO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10OlO_o : nl0Olli;
	assign		wire_niO00i_dataout = (nl0i10i === 1'b1) ? wire_nl1lll_dataout : wire_nl11il_o;
	assign		wire_niO00l_dataout = (nl0i10i === 1'b1) ? wire_nl1llO_dataout : wire_nl11iO_o;
	assign		wire_niO00O_dataout = (nl0i10i === 1'b1) ? wire_nl1lOi_dataout : wire_nl11li_o;
	assign		wire_niO01i_dataout = (nl0i10i === 1'b1) ? wire_nl1lil_dataout : wire_nl110l_o;
	assign		wire_niO01l_dataout = (nl0i10i === 1'b1) ? wire_nl1liO_dataout : wire_nl110O_o;
	assign		wire_niO01O_dataout = (nl0i10i === 1'b1) ? wire_nl1lli_dataout : wire_nl11ii_o;
	assign		wire_niO0ii_dataout = (nl0i10i === 1'b1) ? wire_nl1lOl_dataout : wire_nl11ll_o;
	assign		wire_niO0il_dataout = (nl0i10i === 1'b1) ? wire_nl1lOO_dataout : wire_nl11lO_o;
	assign		wire_niO0iO_dataout = (nl0i10i === 1'b1) ? wire_nl1O1i_dataout : wire_nl11Oi_o;
	assign		wire_niO0li_dataout = (nl0i10i === 1'b1) ? wire_nl1O1l_dataout : wire_nl11Ol_o;
	assign		wire_niO0ll_dataout = (nl0i10i === 1'b1) ? wire_nl1O1O_dataout : wire_nl11OO_o;
	assign		wire_niO0lO_dataout = (nl0i10i === 1'b1) ? wire_nl1O0i_o : wire_nl101i_o;
	assign		wire_niO0Oi_dataout = (nl0i10i === 1'b1) ? wire_nl1O0l_dataout : wire_nl101l_o;
	assign		wire_niO0Ol_dataout = (nl0i10i === 1'b1) ? wire_nl1O0O_dataout : wire_nl101O_o;
	assign		wire_niO0OO_dataout = (nl0i10i === 1'b1) ? wire_nl1Oii_dataout : wire_nl100i_o;
	assign		wire_niO10i_dataout = (nl0i10i === 1'b1) ? wire_nl1ill_dataout : wire_niOOil_o;
	assign		wire_niO10l_dataout = (nl0i10i === 1'b1) ? wire_nl1ilO_dataout : wire_niOOiO_o;
	assign		wire_niO10O_dataout = (nl0i10i === 1'b1) ? wire_nl1iOi_dataout : wire_niOOli_o;
	assign		wire_niO11i_dataout = (nl0i10i === 1'b1) ? wire_nl1iil_dataout : wire_niOO0l_o;
	assign		wire_niO11l_dataout = (nl0i10i === 1'b1) ? wire_nl1iiO_dataout : wire_niOO0O_o;
	assign		wire_niO11O_dataout = (nl0i10i === 1'b1) ? wire_nl1ili_dataout : wire_niOOii_o;
	assign		wire_niO1ii_dataout = (nl0i10i === 1'b1) ? wire_nl1iOl_dataout : wire_niOOll_o;
	assign		wire_niO1il_dataout = (nl0i10i === 1'b1) ? wire_nl1iOO_dataout : wire_niOOlO_o;
	assign		wire_niO1iO_dataout = (nl0i10i === 1'b1) ? wire_nl1l1i_dataout : wire_niOOOi_o;
	assign		wire_niO1li_dataout = (nl0i10i === 1'b1) ? wire_nl1l1l_dataout : wire_niOOOl_o;
	assign		wire_niO1ll_dataout = (nl0i10i === 1'b1) ? wire_nl1l1O_dataout : wire_niOOOO_o;
	assign		wire_niO1lO_dataout = (nl0i10i === 1'b1) ? wire_nl1l0i_dataout : wire_nl111i_o;
	assign		wire_niO1Oi_dataout = (nl0i10i === 1'b1) ? wire_nl1l0l_dataout : wire_nl111l_o;
	assign		wire_niO1Ol_dataout = (nl0i10i === 1'b1) ? wire_nl1l0O_dataout : wire_nl111O_o;
	assign		wire_niO1OO_dataout = (nl0i10i === 1'b1) ? wire_nl1lii_dataout : wire_nl110i_o;
	assign		wire_niOi_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l1i_o : nl0O0Ol;
	assign		wire_niOi0i_dataout = (nl0i10i === 1'b1) ? wire_nl1Oll_dataout : wire_nl10il_o;
	assign		wire_niOi0l_dataout = (nl0i10i === 1'b1) ? wire_nl1OlO_dataout : wire_nl10iO_o;
	assign		wire_niOi0O_dataout = (nl0i10i === 1'b1) ? wire_nl1OOi_dataout : wire_nl10li_o;
	assign		wire_niOi1i_dataout = (nl0i10i === 1'b1) ? wire_nl1Oil_dataout : wire_nl100l_o;
	assign		wire_niOi1l_dataout = (nl0i10i === 1'b1) ? wire_nl1OiO_dataout : wire_nl100O_o;
	assign		wire_niOi1O_dataout = (nl0i10i === 1'b1) ? wire_nl1Oli_dataout : wire_nl10ii_o;
	assign		wire_niOiii_dataout = (nl0i10i === 1'b1) ? wire_nl1OOl_dataout : wire_nl10ll_o;
	assign		wire_niOiil_dataout = (nl0i10i === 1'b1) ? wire_nl1OOO_dataout : wire_nl10lO_o;
	assign		wire_niOiiO_dataout = (nl0i10i === 1'b1) ? wire_nl011i_dataout : wire_nl10Oi_o;
	assign		wire_niOili_dataout = (nl0i10i === 1'b1) ? wire_nl011l_dataout : wire_nl10Ol_o;
	assign		wire_niOill_dataout = (nl0i10i === 1'b1) ? wire_nl011O_dataout : wire_nl10OO_o;
	assign		wire_niOilO_dataout = (nl0i10i === 1'b1) ? wire_nl010i_dataout : wire_nl1i1i_o;
	assign		wire_niOiOi_dataout = (nl0i10i === 1'b1) ? wire_nl010l_o : wire_nl1i1l_o;
	assign		wire_niOiOl_dataout = (nl0i10i === 1'b1) ? wire_nl010O_dataout : wire_nl1i1O_o;
	assign		wire_niOiOO_dataout = (nl0i10i === 1'b1) ? wire_nl01ii_dataout : wire_nl1i0i_o;
	assign		wire_niOl_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l1l_o : nl0O0OO;
	assign		wire_niOl1i_dataout = (nl0i10i === 1'b1) ? wire_nl01il_dataout : wire_nl1i0l_o;
	assign		wire_niOl1l_dataout = (nl0i10i === 1'b1) ? wire_nl01iO_dataout : wire_nl1i0O_o;
	assign		wire_niOl1O_dataout = (nl0i10i === 1'b1) ? wire_nl01li_dataout : wire_nl1iii_o;
	assign		wire_niOO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l1O_o : nl0Oi1i;
	assign		wire_nl000i_dataout = (rwa_6g_en === 1'b1) ? (nl00iil & nl00iiO) : (nlO00l & (nl00ili & nl00iiO));
	and(wire_nl00il_dataout, wire_nl00iO_dataout, rwa_6g_en);
	assign		wire_nl00iO_dataout = (rdwidth === 1'b1) ? (nl00ili & nl00ill) : (nl00iOi & nl00ill);
	assign		wire_nl00lO_dataout = (rwa_6g_en === 1'b1) ? wire_nl00OO_dataout : (nlO00O & (nl00iOi & nl00O0O));
	and(wire_nl00OO_dataout, (nl00ilO & nl00O0O), rdwidth);
	assign		wire_nl010i_dataout = (nl00iii === 1'b1) ? rbytordpadval[9] : wire_nl0l0Ol_byte_des_fifo_data_in[57];
	and(wire_nl010O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[59], ~(nl00iii));
	assign		wire_nl011i_dataout = (nl00iii === 1'b1) ? rbytordpadval[6] : wire_nl0l0Ol_byte_des_fifo_data_in[54];
	assign		wire_nl011l_dataout = (nl00iii === 1'b1) ? rbytordpadval[7] : wire_nl0l0Ol_byte_des_fifo_data_in[55];
	assign		wire_nl011O_dataout = (nl00iii === 1'b1) ? rbytordpadval[8] : wire_nl0l0Ol_byte_des_fifo_data_in[56];
	and(wire_nl01ii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[60], ~(nl00iii));
	and(wire_nl01il_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[61], ~(nl00iii));
	and(wire_nl01iO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[62], ~(nl00iii));
	and(wire_nl01li_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[63], ~(nl00iii));
	and(wire_nl01ll_dataout, wire_nl01OO_o, ~(nl0i10l));
	and(wire_nl01lO_dataout, wire_nl001i_o, ~(nl0i10l));
	and(wire_nl01Oi_dataout, wire_nl001l_o, ~(nl0i10l));
	and(wire_nl01Ol_dataout, wire_nl001O_o, ~(nl0i10l));
	assign		wire_nl0i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lii_o : nl0Oi0l;
	assign		wire_nl0i0l_dataout = (rwa_6g_en === 1'b1) ? (nl00iOl & nl00iOO) : (nlO00O & (nl00l1i & nl00iOO));
	and(wire_nl0i1l_dataout, wire_nl0i1O_dataout, rwa_6g_en);
	and(wire_nl0i1O_dataout, (nl00O0l & nl00iOi), rdwidth);
	and(wire_nl0iiO_dataout, wire_nl0ili_dataout, rwa_6g_en);
	assign		wire_nl0ili_dataout = (rdwidth === 1'b1) ? (nl00l1i & nl00l1l) : (nl00l0i & nl00l1l);
	assign		wire_nl0iOi_dataout = (rwa_6g_en === 1'b1) ? wire_nl0l1i_dataout : (wire_nlOilO_dataout & (nl00l0i & nl00OOi));
	assign		wire_nl0l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lil_o : nl0Oi0O;
	and(wire_nl0l0i_dataout, (nl00OlO & nl00l0i), rdwidth);
	assign		wire_nl0l0O_dataout = (rwa_6g_en === 1'b1) ? (wire_nlOilO_dataout & ((((~ nl00l0O) & (~ nl00l0l)) | (~ rbytordplden)) & nl00liO)) : (wire_nlOilO_dataout & ((((~ nl00lil) & (~ nl00lii)) | (~ rbytordplden)) & nl00liO));
	and(wire_nl0l1i_dataout, (nl00l1O & nl00OOi), rdwidth);
	and(wire_nl0l1O_dataout, wire_nl0l0i_dataout, rwa_6g_en);
	assign		wire_nl0O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10liO_o : nl0Oiii;
	assign		wire_nl0O0l_dataout = (rwa_6g_en === 1'b1) ? wire_nl0Oll_dataout : (wire_nlOiOi_dataout & (nl00lli & nl00lOi));
	and(wire_nl0O1i_dataout, (wire_nlOilO_dataout & (nl00lli & (nl00lOO | nl00lOl))), rwa_6g_en);
	and(wire_nl0Oll_dataout, (wire_nlOiOi_dataout & ((((~ nl00lOO) & (~ nl00lOl)) | (~ rbytordplden)) & nl00lOi)), rdwidth);
	assign		wire_nl10l_dataout = (tenb_data[18] === 1'b1) ? (n10Ol & nl0iiOi) : (n1i1O & nl0iiOi);
	assign		wire_nl1i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l0i_o : nl0Oi1l;
	assign		wire_nl1iil_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[0] : wire_nl0l0Ol_byte_des_fifo_data_in[16];
	assign		wire_nl1iiO_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[1] : wire_nl0l0Ol_byte_des_fifo_data_in[17];
	assign		wire_nl1ili_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[2] : wire_nl0l0Ol_byte_des_fifo_data_in[18];
	assign		wire_nl1ill_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[3] : wire_nl0l0Ol_byte_des_fifo_data_in[19];
	assign		wire_nl1ilO_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[4] : wire_nl0l0Ol_byte_des_fifo_data_in[20];
	assign		wire_nl1iOi_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[5] : wire_nl0l0Ol_byte_des_fifo_data_in[21];
	assign		wire_nl1iOl_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[6] : wire_nl0l0Ol_byte_des_fifo_data_in[22];
	assign		wire_nl1iOO_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[7] : wire_nl0l0Ol_byte_des_fifo_data_in[23];
	assign		wire_nl1l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l0l_o : nl0Oi1O;
	and(wire_nl1l0i_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[27], ~(wire_nil0il_o[2]));
	and(wire_nl1l0l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[28], ~(wire_nil0il_o[2]));
	and(wire_nl1l0O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[29], ~(wire_nil0il_o[2]));
	assign		wire_nl1l1i_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[8] : wire_nl0l0Ol_byte_des_fifo_data_in[24];
	assign		wire_nl1l1l_dataout = (wire_nil0il_o[2] === 1'b1) ? rbytordpadval[9] : wire_nl0l0Ol_byte_des_fifo_data_in[25];
	assign		wire_nl1l1O_dataout = (wire_nil0il_o[2] === 1'b1) ? wire_nl0l0Ol_byte_des_fifo_data_in[10] : wire_nl0l0Ol_byte_des_fifo_data_in[26];
	and(wire_nl1lii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[30], ~(wire_nil0il_o[2]));
	and(wire_nl1lil_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[31], ~(wire_nil0il_o[2]));
	assign		wire_nl1liO_dataout = (nl00i0O === 1'b1) ? rbytordpadval[0] : wire_nl0l0Ol_byte_des_fifo_data_in[32];
	assign		wire_nl1lli_dataout = (nl00i0O === 1'b1) ? rbytordpadval[1] : wire_nl0l0Ol_byte_des_fifo_data_in[33];
	assign		wire_nl1lll_dataout = (nl00i0O === 1'b1) ? rbytordpadval[2] : wire_nl0l0Ol_byte_des_fifo_data_in[34];
	assign		wire_nl1llO_dataout = (nl00i0O === 1'b1) ? rbytordpadval[3] : wire_nl0l0Ol_byte_des_fifo_data_in[35];
	assign		wire_nl1lOi_dataout = (nl00i0O === 1'b1) ? rbytordpadval[4] : wire_nl0l0Ol_byte_des_fifo_data_in[36];
	assign		wire_nl1lOl_dataout = (nl00i0O === 1'b1) ? rbytordpadval[5] : wire_nl0l0Ol_byte_des_fifo_data_in[37];
	assign		wire_nl1lOO_dataout = (nl00i0O === 1'b1) ? rbytordpadval[6] : wire_nl0l0Ol_byte_des_fifo_data_in[38];
	assign		wire_nl1O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l0O_o : nl0Oi0i;
	and(wire_nl1O0l_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[43], ~(nl00i0O));
	and(wire_nl1O0O_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[44], ~(nl00i0O));
	assign		wire_nl1O1i_dataout = (nl00i0O === 1'b1) ? rbytordpadval[7] : wire_nl0l0Ol_byte_des_fifo_data_in[39];
	assign		wire_nl1O1l_dataout = (nl00i0O === 1'b1) ? rbytordpadval[8] : wire_nl0l0Ol_byte_des_fifo_data_in[40];
	assign		wire_nl1O1O_dataout = (nl00i0O === 1'b1) ? rbytordpadval[9] : wire_nl0l0Ol_byte_des_fifo_data_in[41];
	and(wire_nl1Oii_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[45], ~(nl00i0O));
	and(wire_nl1Oil_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[46], ~(nl00i0O));
	and(wire_nl1OiO_dataout, wire_nl0l0Ol_byte_des_fifo_data_in[47], ~(nl00i0O));
	assign		wire_nl1Oli_dataout = (nl00iii === 1'b1) ? rbytordpadval[0] : wire_nl0l0Ol_byte_des_fifo_data_in[48];
	assign		wire_nl1Oll_dataout = (nl00iii === 1'b1) ? rbytordpadval[1] : wire_nl0l0Ol_byte_des_fifo_data_in[49];
	assign		wire_nl1OlO_dataout = (nl00iii === 1'b1) ? rbytordpadval[2] : wire_nl0l0Ol_byte_des_fifo_data_in[50];
	assign		wire_nl1OOi_dataout = (nl00iii === 1'b1) ? rbytordpadval[3] : wire_nl0l0Ol_byte_des_fifo_data_in[51];
	assign		wire_nl1OOl_dataout = (nl00iii === 1'b1) ? rbytordpadval[4] : wire_nl0l0Ol_byte_des_fifo_data_in[52];
	assign		wire_nl1OOO_dataout = (nl00iii === 1'b1) ? rbytordpadval[5] : wire_nl0l0Ol_byte_des_fifo_data_in[53];
	assign		wire_nli_dataout = (rinvalid_code_err_only === 1'b1) ? invalid_code_delay[0] : (invalid_code_delay[0] | disp_err_delay[0]);
	assign		wire_nli01O_dataout = (rwa_6g_en === 1'b1) ? wire_nli0ii_dataout : (wire_nlOiOi_dataout & (nl00Oii & nl00Oll));
	and(wire_nli0ii_dataout, (wire_nlOiOi_dataout & (((~ rbytordplden) | (~ nl00OiO)) & nl00Oll)), rdwidth);
	and(wire_nli0ll_dataout, wire_nli0lO_dataout, rwa_6g_en);
	and(wire_nli0lO_dataout, (wire_nlOiOi_dataout & (((~ rbytordplden) | (~ nl00Oll)) & nl00Oli)), rdwidth);
	or(wire_nli10Ol_dataout, wire_nli10OO_dataout, nl000li);
	and(wire_nli10OO_dataout, nl0OlOl, ~(((nl0OlOl & (~ nl000li)) & (~ nl000ll))));
	and(wire_nli11i_dataout, wire_nli11l_dataout, rwa_6g_en);
	and(wire_nli11l_dataout, (wire_nlOiOi_dataout & ((((~ nl00O0i) & (~ nl00O1O)) | (~ rbytordplden)) & (nl00O1l | nl00O1i))), rdwidth);
	and(wire_nli1i0i_dataout, nl0OlOO, ~(((nl0OlOO & (~ nl000lO)) & (~ nl000ll))));
	or(wire_nli1i1O_dataout, wire_nli1i0i_dataout, nl000lO);
	assign		wire_nli1iii_dataout = (nlO0ll === 1'b1) ? wire_nli1iOO_dataout : nli111l;
	assign		wire_nli1iil_dataout = (nlO0ll === 1'b1) ? wire_nli1l1i_dataout : nli111O;
	assign		wire_nli1iiO_dataout = (nlO0ll === 1'b1) ? wire_nli1l1l_dataout : nli110i;
	assign		wire_nli1il_dataout = (rwa_6g_en === 1'b1) ? (wire_nlOilO_dataout & (((~ rbytordplden) | (~ nl00O0l)) & nl00Oil)) : (wire_nlOilO_dataout & (((~ rbytordplden) | (~ nl00O0O)) & nl00Oil));
	assign		wire_nli1ili_dataout = (nlO0ll === 1'b1) ? wire_nli1l1O_dataout : nli110l;
	assign		wire_nli1ill_dataout = (nlO0ll === 1'b1) ? wire_nli1l0i_dataout : nli110O;
	assign		wire_nli1ilO_dataout = (nlO0ll === 1'b1) ? wire_nli1l0l_dataout : nli11ii;
	assign		wire_nli1iOi_dataout = (nlO0ll === 1'b1) ? wire_nli1l0O_dataout : nli11il;
	assign		wire_nli1iOl_dataout = (nlO0ll === 1'b1) ? wire_nli1lii_dataout : nli11iO;
	assign		wire_nli1iOO_dataout = (nl000Oi === 1'b1) ? nli11il : nli11iO;
	assign		wire_nli1l0i_dataout = (nl000Oi === 1'b1) ? nli110i : nli110l;
	assign		wire_nli1l0l_dataout = (nl000Oi === 1'b1) ? nli110l : nli110O;
	assign		wire_nli1l0O_dataout = (nl000Oi === 1'b1) ? nli110O : nli11ii;
	assign		wire_nli1l1i_dataout = (nl000Oi === 1'b1) ? nli11iO : nli111l;
	assign		wire_nli1l1l_dataout = (nl000Oi === 1'b1) ? nli111l : nli111O;
	assign		wire_nli1l1O_dataout = (nl000Oi === 1'b1) ? nli111O : nli110i;
	assign		wire_nli1lii_dataout = (nl000Oi === 1'b1) ? nli11ii : nli11il;
	assign		wire_nli1O0i_dataout = (nlOliO === 1'b1) ? nli1lli : nli1lll;
	assign		wire_nli1O0l_dataout = (nlOliO === 1'b1) ? nli1lll : nli1llO;
	assign		wire_nli1O0O_dataout = (nlOliO === 1'b1) ? nli1llO : nli1lOi;
	assign		wire_nli1O1l_dataout = (nlOliO === 1'b1) ? nli1O1i : nli10Oi;
	assign		wire_nli1O1O_dataout = (nlOliO === 1'b1) ? nli10Oi : nli1lli;
	assign		wire_nli1Oii_dataout = (nlOliO === 1'b1) ? nli1lOi : nli1lOl;
	assign		wire_nli1Oil_dataout = (nlOliO === 1'b1) ? nli1lOl : nli1lOO;
	assign		wire_nli1OiO_dataout = (nlOliO === 1'b1) ? nli1lOO : nli1O1i;
	and(wire_nli1OO_dataout, (wire_nlOilO_dataout & (nl00Oii & nl00OiO)), rwa_6g_en);
	assign		wire_nlii_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lli_o : nl0Oiil;
	assign		wire_nlii1i_dataout = (rwa_6g_en === 1'b1) ? (wire_nlOilO_dataout & (((~ rbytordplden) | (~ nl00OlO)) & nl00OOO)) : (wire_nlOilO_dataout & (((~ rbytordplden) | (~ nl00OOi)) & nl00OOO));
	and(wire_nliiil_dataout, (wire_nlOilO_dataout & (nl00OOl & nl0i11i)), rwa_6g_en);
	assign		wire_nliill_dataout = (rwa_6g_en === 1'b1) ? wire_nliiOO_dataout : (wire_nlOiOi_dataout & (nl00OOl & nl0i11O));
	and(wire_nliiOO_dataout, (wire_nlOiOi_dataout & (((~ rbytordplden) | (~ nl0i11i)) & nl0i11O)), rdwidth);
	assign		wire_nlil_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lll_o : nl0OiiO;
	and(wire_nlil0i_dataout, wire_nlil0l_dataout, rwa_6g_en);
	and(wire_nlil0l_dataout, (wire_nlOiOi_dataout & (((~ rbytordplden) | (~ nl0i11O)) & nl0i11l)), rdwidth);
	assign		wire_nliO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10llO_o : nl0Oili;
	assign		wire_nll_dataout = (rinvalid_code_err_only === 1'b1) ? invalid_code_delay[1] : ((invalid_code_delay[1] | disp_err_delay[1]) | (~ (nl0l0ii4 ^ nl0l0ii3)));
	assign		wire_nll0l_dataout = (tenb_data[8] === 1'b1) ? (n10Oi & nl0l00O) : ((n1i1l & nl0l00O) & (nl0l00i6 ^ nl0l00i5));
	assign		wire_nlli_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lOi_o : nl0Oill;
	assign		wire_nlll_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lOl_o : nl0OilO;
	assign		wire_nllO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lOO_o : nl0OiOi;
	and(wire_nlO0lO_dataout, wire_nlO0Oi_dataout, ~(nl0i10l));
	or(wire_nlO0Oi_dataout, nlillO, (((wire_nl01Ol_dataout | wire_nl01Oi_dataout) | wire_nl01lO_dataout) | wire_nl01ll_dataout));
	and(wire_nlO0OO_dataout, wire_nlOi1i_dataout, ~((nlO0iO & (~ nlO0il))));
	assign		wire_nlOi_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O1i_o : nl0OiOl;
	assign		wire_nlOi0i_dataout = (nl0i10i === 1'b1) ? wire_nl01ll_dataout : wire_nlOiil_dataout;
	assign		wire_nlOi0l_dataout = (nl0i10i === 1'b1) ? wire_nl01lO_dataout : wire_nlOiiO_dataout;
	assign		wire_nlOi0O_dataout = (nl0i10i === 1'b1) ? wire_nl01Oi_dataout : wire_nlOili_dataout;
	or(wire_nlOi1i_dataout, nlO0ii, (nlO0il & (~ nlO0ii)));
	assign		wire_nlOiii_dataout = (nl0i10i === 1'b1) ? wire_nl01Ol_dataout : wire_nlOill_dataout;
	and(wire_nlOiil_dataout, n11OOO, ~(nl0i10l));
	and(wire_nlOiiO_dataout, nliliO, ~(nl0i10l));
	and(wire_nlOili_dataout, nlilli, ~(nl0i10l));
	and(wire_nlOill_dataout, nlilll, ~(nl0i10l));
	and(wire_nlOilO_dataout, wire_nlOiOl_dataout, ~(nl0i10O));
	and(wire_nlOiOi_dataout, wire_nlOiOO_dataout, ~(nl0i10O));
	assign		wire_nlOiOl_dataout = (rbytordplden === 1'b1) ? nlO0ii : wire_nlOl1i_dataout;
	assign		wire_nlOiOO_dataout = (rbytordplden === 1'b1) ? nlO0ii : wire_nlOl1l_dataout;
	assign		wire_nlOl_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O1l_o : nl0OiOO;
	assign		wire_nlOl1i_dataout = (rwa_6g_en === 1'b1) ? (wire_nl0l0Ol_byte_des_fifo_data_in[26] | wire_nl0l0Ol_byte_des_fifo_data_in[10]) : wire_nl0l0Ol_byte_des_bo_3g_start[0];
	assign		wire_nlOl1l_dataout = (rwa_6g_en === 1'b1) ? (wire_nl0l0Ol_byte_des_fifo_data_in[58] | wire_nl0l0Ol_byte_des_fifo_data_in[42]) : wire_nl0l0Ol_byte_des_bo_3g_start[1];
	assign		wire_nlOlli_dataout = (rphfifo_master_sel_rx === 1'b1) ? wire_nlOlll_dataout : rd_enable_q0_ch0;
	assign		wire_nlOlll_dataout = (indv_rx === 1'b1) ? nlOl0l : rd_enable_ch0;
	assign		wire_nlOllO_dataout = (rrxphfifopldctl_en === 1'b1) ? (nlOl0O & pld_re) : nlOl0O;
	assign		wire_nlOlO_dataout = (rrxfifo_dis === 1'b1) ? wire_n101ii_dataout : nl0Olll;
	assign		wire_nlOO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O1O_o : nl0Ol1i;
	assign		wire_nlOOi_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l0l_o : nl0Oi1O;
	assign		wire_nlOOil_dataout = (rphfifo_master_sel_rx === 1'b1) ? wire_nlOOiO_dataout : wr_enable_q0_ch0;
	assign		wire_nlOOiO_dataout = (indv_rx === 1'b1) ? nlOlOl : wr_enable_ch0;
	assign		wire_nlOOl_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O0O_o : nl0Ol0i;
	assign		wire_nlOOli_dataout = (rrxphfifopldctl_en === 1'b1) ? ((~ nlOO1l) & nlOlOO) : nlOlOO;
	assign		wire_nlOOO_dataout = (rrxfifo_dis === 1'b1) ? wire_n1001O_o : nl0O11i;
	and(wire_nlOOOi_dataout, nlOOii, ~(scan_mode));
	oper_decoder   nil0il
	( 
	.i({wire_nl01lO_dataout, wire_nl01ll_dataout}),
	.o(wire_nil0il_o));
	defparam
		nil0il.width_i = 2,
		nil0il.width_o = 4;
	oper_decoder   nilill
	( 
	.i({wire_nl01Oi_dataout, wire_nl01lO_dataout, wire_nl01ll_dataout}),
	.o(wire_nilill_o));
	defparam
		nilill.width_i = 3,
		nilill.width_o = 8;
	oper_decoder   nillOl
	( 
	.i({wire_nl01Ol_dataout, wire_nl01Oi_dataout, wire_nl01lO_dataout, wire_nl01ll_dataout}),
	.o(wire_nillOl_o));
	defparam
		nillOl.width_i = 4,
		nillOl.width_o = 16;
	oper_decoder   nl0lO1O
	( 
	.i({nli11iO, nli11il, nli11ii, nli110O, nli110l, nli110i, nli111O, nli111l}),
	.o(wire_nl0lO1O_o));
	defparam
		nl0lO1O.width_i = 8,
		nl0lO1O.width_o = 256;
	oper_decoder   nl0lOii
	( 
	.i({nli1O1i, nli1lOO, nli1lOl, nli1lOi, nli1llO, nli1lll, nli1lli, nli10Oi}),
	.o(wire_nl0lOii_o));
	defparam
		nl0lOii.width_i = 8,
		nl0lOii.width_o = 256;
	oper_decoder   nl10i
	( 
	.i({rwa_6g_en, rpmadatawidth, rsync_comp_size[2:0], tenb_data[18]}),
	.o(wire_nl10i_o));
	defparam
		nl10i.width_i = 6,
		nl10i.width_o = 64;
	oper_decoder   nll0i
	( 
	.i({((nl0l01i12 ^ nl0l01i11) & rwa_6g_en), rpmadatawidth, ((nl0l01l10 ^ nl0l01l9) & rsync_comp_size[2]), ((nl0l01O8 ^ nl0l01O7) & rsync_comp_size[1]), rsync_comp_size[0], tenb_data[8]}),
	.o(wire_nll0i_o));
	defparam
		nll0i.width_i = 6,
		nll0i.width_o = 64;
	oper_mux   n1000i
	( 
	.data({wire_ni0iiO_dataout, wire_nilOli_dataout, wire_n00O1l_dataout, wire_n0O1Oi_dataout, wire_n1i1il_dataout, wire_n1Oi0O_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[10]}}}),
	.o(wire_n1000i_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n1000i.width_data = 8,
		n1000i.width_sel = 3;
	oper_mux   n1000l
	( 
	.data({wire_ni0ili_dataout, wire_nilOll_dataout, wire_n00O1O_dataout, wire_n0O1Ol_dataout, wire_n1i1iO_dataout, wire_n1Oiii_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[11]}}}),
	.o(wire_n1000l_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n1000l.width_data = 8,
		n1000l.width_sel = 3;
	oper_mux   n1000O
	( 
	.data({wire_ni0ill_dataout, wire_nilOlO_dataout, wire_n00O0i_dataout, wire_n0O1OO_dataout, wire_n1i1li_dataout, wire_n1Oiil_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[12]}}}),
	.o(wire_n1000O_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n1000O.width_data = 8,
		n1000O.width_sel = 3;
	oper_mux   n1001i
	( 
	.data({wire_ni0i0O_dataout, wire_nilOii_dataout, wire_n00lOl_dataout, wire_n0O1li_dataout, wire_n1i10l_dataout, wire_n1Oi1O_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[7]}}}),
	.o(wire_n1001i_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n1001i.width_data = 8,
		n1001i.width_sel = 3;
	oper_mux   n1001l
	( 
	.data({wire_ni0iii_dataout, wire_nilOil_dataout, wire_n00lOO_dataout, wire_n0O1ll_dataout, wire_n1i10O_dataout, wire_n1Oi0i_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[8]}}}),
	.o(wire_n1001l_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n1001l.width_data = 8,
		n1001l.width_sel = 3;
	oper_mux   n1001O
	( 
	.data({wire_ni0iil_dataout, wire_nilOiO_dataout, wire_n00O1i_dataout, wire_n0O1lO_dataout, wire_n1i1ii_dataout, wire_n1Oi0l_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[9]}}}),
	.o(wire_n1001O_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n1001O.width_data = 8,
		n1001O.width_sel = 3;
	oper_mux   n100ii
	( 
	.data({wire_ni0ilO_dataout, wire_nilOOi_dataout, wire_n00O0l_dataout, wire_n0O01i_dataout, wire_n1i1ll_dataout, wire_n1OiiO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[13]}}}),
	.o(wire_n100ii_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100ii.width_data = 8,
		n100ii.width_sel = 3;
	oper_mux   n100il
	( 
	.data({wire_ni0iOi_dataout, wire_nilOOl_dataout, wire_n00O0O_dataout, wire_n0O01l_dataout, wire_n1i1lO_dataout, wire_n1Oili_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[14]}}}),
	.o(wire_n100il_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100il.width_data = 8,
		n100il.width_sel = 3;
	oper_mux   n100iO
	( 
	.data({wire_ni0iOl_dataout, wire_nilOOO_dataout, wire_n00Oii_dataout, wire_n0O01O_dataout, wire_n1i1Oi_dataout, wire_n1Oill_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[15]}}}),
	.o(wire_n100iO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100iO.width_data = 8,
		n100iO.width_sel = 3;
	oper_mux   n100li
	( 
	.data({wire_ni0iOO_dataout, wire_niO11i_dataout, wire_n00Oil_dataout, wire_n0O00i_dataout, wire_n1i1Ol_dataout, wire_n1OilO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[16]}}}),
	.o(wire_n100li_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100li.width_data = 8,
		n100li.width_sel = 3;
	oper_mux   n100ll
	( 
	.data({wire_ni0l1i_dataout, wire_niO11l_dataout, wire_n00OiO_dataout, wire_n0O00l_dataout, wire_n1i1OO_dataout, wire_n1OiOi_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[17]}}}),
	.o(wire_n100ll_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100ll.width_data = 8,
		n100ll.width_sel = 3;
	oper_mux   n100lO
	( 
	.data({wire_ni0l1l_dataout, wire_niO11O_dataout, wire_n00Oli_dataout, wire_n0O00O_dataout, wire_n1i01i_dataout, wire_n1OiOl_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[18]}}}),
	.o(wire_n100lO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100lO.width_data = 8,
		n100lO.width_sel = 3;
	oper_mux   n100Oi
	( 
	.data({wire_ni0l1O_dataout, wire_niO10i_dataout, wire_n00Oll_dataout, wire_n0O0ii_dataout, wire_n1i01l_dataout, wire_n1OiOO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[19]}}}),
	.o(wire_n100Oi_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100Oi.width_data = 8,
		n100Oi.width_sel = 3;
	oper_mux   n100Ol
	( 
	.data({wire_ni0l0i_dataout, wire_niO10l_dataout, wire_n00OlO_dataout, wire_n0O0il_dataout, wire_n1i01O_dataout, wire_n1Ol1i_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[20]}}}),
	.o(wire_n100Ol_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100Ol.width_data = 8,
		n100Ol.width_sel = 3;
	oper_mux   n100OO
	( 
	.data({wire_ni0l0l_dataout, wire_niO10O_dataout, wire_n00OOi_dataout, wire_n0O0iO_dataout, wire_n1i00i_dataout, wire_n1Ol1l_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[21]}}}),
	.o(wire_n100OO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n100OO.width_data = 8,
		n100OO.width_sel = 3;
	oper_mux   n101iO
	( 
	.data({wire_ni00Ol_dataout, wire_nillOO_dataout, wire_n00lii_dataout, wire_n0O11O_dataout, wire_n10OOi_dataout, wire_n1O0ll_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[0]}}}),
	.o(wire_n101iO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n101iO.width_data = 8,
		n101iO.width_sel = 3;
	oper_mux   n101li
	( 
	.data({wire_ni00OO_dataout, wire_nilO1i_dataout, wire_n00lil_dataout, wire_n0O10i_dataout, wire_n10OOl_dataout, wire_n1O0lO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[1]}}}),
	.o(wire_n101li_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n101li.width_data = 8,
		n101li.width_sel = 3;
	oper_mux   n101ll
	( 
	.data({wire_ni0i1i_dataout, wire_nilO1l_dataout, wire_n00liO_dataout, wire_n0O10l_dataout, wire_n10OOO_dataout, wire_n1O0Oi_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[2]}}}),
	.o(wire_n101ll_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n101ll.width_data = 8,
		n101ll.width_sel = 3;
	oper_mux   n101lO
	( 
	.data({wire_ni0i1l_dataout, wire_nilO1O_dataout, wire_n00lli_dataout, wire_n0O10O_dataout, wire_n1i11i_dataout, wire_n1O0Ol_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[3]}}}),
	.o(wire_n101lO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n101lO.width_data = 8,
		n101lO.width_sel = 3;
	oper_mux   n101Oi
	( 
	.data({wire_ni0i1O_dataout, wire_nilO0i_dataout, wire_n00lll_dataout, wire_n0O1ii_dataout, wire_n1i11l_dataout, wire_n1O0OO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[4]}}}),
	.o(wire_n101Oi_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n101Oi.width_data = 8,
		n101Oi.width_sel = 3;
	oper_mux   n101Ol
	( 
	.data({wire_ni0i0i_dataout, wire_nilO0l_dataout, wire_n00llO_dataout, wire_n0O1il_dataout, wire_n1i11O_dataout, wire_n1Oi1i_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[5]}}}),
	.o(wire_n101Ol_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n101Ol.width_data = 8,
		n101Ol.width_sel = 3;
	oper_mux   n101OO
	( 
	.data({wire_ni0i0l_dataout, wire_nilO0O_dataout, wire_n00lOi_dataout, wire_n0O1iO_dataout, wire_n1i10i_dataout, wire_n1Oi1l_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[6]}}}),
	.o(wire_n101OO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n101OO.width_data = 8,
		n101OO.width_sel = 3;
	oper_mux   n10i0i
	( 
	.data({wire_ni0liO_dataout, wire_niO1li_dataout, wire_n0i11l_dataout, wire_n0O0Oi_dataout, wire_n1i0il_dataout, wire_n1Ol0O_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[25]}}}),
	.o(wire_n10i0i_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10i0i.width_data = 8,
		n10i0i.width_sel = 3;
	oper_mux   n10i0l
	( 
	.data({wire_ni0lli_dataout, wire_niO1ll_dataout, wire_n0i11O_dataout, wire_n0O0Ol_dataout, wire_n1i0iO_dataout, wire_n1Olii_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[26]}}}),
	.o(wire_n10i0l_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10i0l.width_data = 8,
		n10i0l.width_sel = 3;
	oper_mux   n10i0O
	( 
	.data({wire_ni0lll_dataout, wire_niO1lO_dataout, wire_n0i10i_dataout, wire_n0O0OO_dataout, wire_n1i0li_dataout, wire_n1Olil_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[27]}}}),
	.o(wire_n10i0O_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10i0O.width_data = 8,
		n10i0O.width_sel = 3;
	oper_mux   n10i1i
	( 
	.data({wire_ni0l0O_dataout, wire_niO1ii_dataout, wire_n00OOl_dataout, wire_n0O0li_dataout, wire_n1i00l_dataout, wire_n1Ol1O_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[22]}}}),
	.o(wire_n10i1i_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10i1i.width_data = 8,
		n10i1i.width_sel = 3;
	oper_mux   n10i1l
	( 
	.data({wire_ni0lii_dataout, wire_niO1il_dataout, wire_n00OOO_dataout, wire_n0O0ll_dataout, wire_n1i00O_dataout, wire_n1Ol0i_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[23]}}}),
	.o(wire_n10i1l_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10i1l.width_data = 8,
		n10i1l.width_sel = 3;
	oper_mux   n10i1O
	( 
	.data({wire_ni0lil_dataout, wire_niO1iO_dataout, wire_n0i11i_dataout, wire_n0O0lO_dataout, wire_n1i0ii_dataout, wire_n1Ol0l_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[24]}}}),
	.o(wire_n10i1O_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10i1O.width_data = 8,
		n10i1O.width_sel = 3;
	oper_mux   n10iii
	( 
	.data({wire_ni0llO_dataout, wire_niO1Oi_dataout, wire_n0i10l_dataout, wire_n0Oi1i_dataout, wire_n1i0ll_dataout, wire_n1OliO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[28]}}}),
	.o(wire_n10iii_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10iii.width_data = 8,
		n10iii.width_sel = 3;
	oper_mux   n10iil
	( 
	.data({wire_ni0lOi_dataout, wire_niO1Ol_dataout, wire_n0i10O_dataout, wire_n0Oi1l_dataout, wire_n1i0lO_dataout, wire_n1Olli_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[29]}}}),
	.o(wire_n10iil_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10iil.width_data = 8,
		n10iil.width_sel = 3;
	oper_mux   n10iiO
	( 
	.data({wire_ni0lOl_dataout, wire_niO1OO_dataout, wire_n0i1ii_dataout, wire_n0Oi1O_dataout, wire_n1i0Oi_dataout, wire_n1Olll_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[30]}}}),
	.o(wire_n10iiO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10iiO.width_data = 8,
		n10iiO.width_sel = 3;
	oper_mux   n10ili
	( 
	.data({wire_ni0lOO_dataout, wire_niO01i_dataout, wire_n0i1il_dataout, wire_n0Oi0i_dataout, wire_n1i0Ol_dataout, wire_n1OllO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[31]}}}),
	.o(wire_n10ili_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10ili.width_data = 8,
		n10ili.width_sel = 3;
	oper_mux   n10ill
	( 
	.data({wire_ni0O1i_dataout, wire_niO01l_dataout, wire_n0i1iO_dataout, wire_n0Oi0l_dataout, wire_n1i0OO_dataout, wire_n1OlOi_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[32]}}}),
	.o(wire_n10ill_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10ill.width_data = 8,
		n10ill.width_sel = 3;
	oper_mux   n10ilO
	( 
	.data({wire_ni0O1l_dataout, wire_niO01O_dataout, wire_n0i1li_dataout, wire_n0Oi0O_dataout, wire_n1ii1i_dataout, wire_n1OlOl_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[33]}}}),
	.o(wire_n10ilO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10ilO.width_data = 8,
		n10ilO.width_sel = 3;
	oper_mux   n10iOi
	( 
	.data({wire_ni0O1O_dataout, wire_niO00i_dataout, wire_n0i1ll_dataout, wire_n0Oiii_dataout, wire_n1ii1l_dataout, wire_n1OlOO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[34]}}}),
	.o(wire_n10iOi_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10iOi.width_data = 8,
		n10iOi.width_sel = 3;
	oper_mux   n10iOl
	( 
	.data({wire_ni0O0i_dataout, wire_niO00l_dataout, wire_n0i1lO_dataout, wire_n0Oiil_dataout, wire_n1ii1O_dataout, wire_n1OO1i_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[35]}}}),
	.o(wire_n10iOl_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10iOl.width_data = 8,
		n10iOl.width_sel = 3;
	oper_mux   n10iOO
	( 
	.data({wire_ni0O0l_dataout, wire_niO00O_dataout, wire_n0i1Oi_dataout, wire_n0OiiO_dataout, wire_n1ii0i_dataout, wire_n1OO1l_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[36]}}}),
	.o(wire_n10iOO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10iOO.width_data = 8,
		n10iOO.width_sel = 3;
	oper_mux   n10l0i
	( 
	.data({wire_ni0OiO_dataout, wire_niO0li_dataout, wire_n0i01l_dataout, wire_n0OiOi_dataout, wire_n1iiil_dataout, wire_n1OO0O_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[40]}}}),
	.o(wire_n10l0i_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10l0i.width_data = 8,
		n10l0i.width_sel = 3;
	oper_mux   n10l0l
	( 
	.data({wire_ni0Oli_dataout, wire_niO0ll_dataout, wire_n0i01O_dataout, wire_n0OiOl_dataout, wire_n1iiiO_dataout, wire_n1OOii_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[41]}}}),
	.o(wire_n10l0l_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10l0l.width_data = 8,
		n10l0l.width_sel = 3;
	oper_mux   n10l0O
	( 
	.data({wire_ni0Oll_dataout, wire_niO0lO_dataout, wire_n0i00i_dataout, wire_n0OiOO_dataout, wire_n1iili_dataout, wire_n1OOil_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[42]}}}),
	.o(wire_n10l0O_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10l0O.width_data = 8,
		n10l0O.width_sel = 3;
	oper_mux   n10l1i
	( 
	.data({wire_ni0O0O_dataout, wire_niO0ii_dataout, wire_n0i1Ol_dataout, wire_n0Oili_dataout, wire_n1ii0l_dataout, wire_n1OO1O_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[37]}}}),
	.o(wire_n10l1i_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10l1i.width_data = 8,
		n10l1i.width_sel = 3;
	oper_mux   n10l1l
	( 
	.data({wire_ni0Oii_dataout, wire_niO0il_dataout, wire_n0i1OO_dataout, wire_n0Oill_dataout, wire_n1ii0O_dataout, wire_n1OO0i_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[38]}}}),
	.o(wire_n10l1l_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10l1l.width_data = 8,
		n10l1l.width_sel = 3;
	oper_mux   n10l1O
	( 
	.data({wire_ni0Oil_dataout, wire_niO0iO_dataout, wire_n0i01i_dataout, wire_n0OilO_dataout, wire_n1iiii_dataout, wire_n1OO0l_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[39]}}}),
	.o(wire_n10l1O_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10l1O.width_data = 8,
		n10l1O.width_sel = 3;
	oper_mux   n10lii
	( 
	.data({wire_ni0OlO_dataout, wire_niO0Oi_dataout, wire_n0i00l_dataout, wire_n0Ol1i_dataout, wire_n1iill_dataout, wire_n1OOiO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[43]}}}),
	.o(wire_n10lii_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10lii.width_data = 8,
		n10lii.width_sel = 3;
	oper_mux   n10lil
	( 
	.data({wire_ni0OOi_dataout, wire_niO0Ol_dataout, wire_n0i00O_dataout, wire_n0Ol1l_dataout, wire_n1iilO_dataout, wire_n1OOli_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[44]}}}),
	.o(wire_n10lil_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10lil.width_data = 8,
		n10lil.width_sel = 3;
	oper_mux   n10liO
	( 
	.data({wire_ni0OOl_dataout, wire_niO0OO_dataout, wire_n0i0ii_dataout, wire_n0Ol1O_dataout, wire_n1iiOi_dataout, wire_n1OOll_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[45]}}}),
	.o(wire_n10liO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10liO.width_data = 8,
		n10liO.width_sel = 3;
	oper_mux   n10lli
	( 
	.data({wire_ni0OOO_dataout, wire_niOi1i_dataout, wire_n0i0il_dataout, wire_n0Ol0i_dataout, wire_n1iiOl_dataout, wire_n1OOlO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[46]}}}),
	.o(wire_n10lli_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10lli.width_data = 8,
		n10lli.width_sel = 3;
	oper_mux   n10lll
	( 
	.data({wire_nii11i_dataout, wire_niOi1l_dataout, wire_n0i0iO_dataout, wire_n0Ol0l_dataout, wire_n1iiOO_dataout, wire_n1OOOi_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[47]}}}),
	.o(wire_n10lll_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10lll.width_data = 8,
		n10lll.width_sel = 3;
	oper_mux   n10llO
	( 
	.data({wire_nii11l_dataout, wire_niOi1O_dataout, wire_n0i0li_dataout, wire_n0Ol0O_dataout, wire_n1il1i_dataout, wire_n1OOOl_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[48]}}}),
	.o(wire_n10llO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10llO.width_data = 8,
		n10llO.width_sel = 3;
	oper_mux   n10lOi
	( 
	.data({wire_nii11O_dataout, wire_niOi0i_dataout, wire_n0i0ll_dataout, wire_n0Olii_dataout, wire_n1il1l_dataout, wire_n1OOOO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[49]}}}),
	.o(wire_n10lOi_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10lOi.width_data = 8,
		n10lOi.width_sel = 3;
	oper_mux   n10lOl
	( 
	.data({wire_nii10i_dataout, wire_niOi0l_dataout, wire_n0i0lO_dataout, wire_n0Olil_dataout, wire_n1il1O_dataout, wire_n0111i_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[50]}}}),
	.o(wire_n10lOl_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10lOl.width_data = 8,
		n10lOl.width_sel = 3;
	oper_mux   n10lOO
	( 
	.data({wire_nii10l_dataout, wire_niOi0O_dataout, wire_n0i0Oi_dataout, wire_n0OliO_dataout, wire_n1il0i_dataout, wire_n0111l_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[51]}}}),
	.o(wire_n10lOO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10lOO.width_data = 8,
		n10lOO.width_sel = 3;
	oper_mux   n10O0i
	( 
	.data({wire_nii1iO_dataout, wire_niOili_dataout, wire_n0ii1l_dataout, wire_n0OlOi_dataout, wire_n1ilil_dataout, wire_n0110O_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[55]}}}),
	.o(wire_n10O0i_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10O0i.width_data = 8,
		n10O0i.width_sel = 3;
	oper_mux   n10O0l
	( 
	.data({wire_nii1li_dataout, wire_niOill_dataout, wire_n0ii1O_dataout, wire_n0OlOl_dataout, wire_n1iliO_dataout, wire_n011ii_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[56]}}}),
	.o(wire_n10O0l_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10O0l.width_data = 8,
		n10O0l.width_sel = 3;
	oper_mux   n10O0O
	( 
	.data({wire_nii1ll_dataout, wire_niOilO_dataout, wire_n0ii0i_dataout, wire_n0OlOO_dataout, wire_n1illi_dataout, wire_n011il_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[57]}}}),
	.o(wire_n10O0O_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10O0O.width_data = 8,
		n10O0O.width_sel = 3;
	oper_mux   n10O1i
	( 
	.data({wire_nii10O_dataout, wire_niOiii_dataout, wire_n0i0Ol_dataout, wire_n0Olli_dataout, wire_n1il0l_dataout, wire_n0111O_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[52]}}}),
	.o(wire_n10O1i_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10O1i.width_data = 8,
		n10O1i.width_sel = 3;
	oper_mux   n10O1l
	( 
	.data({wire_nii1ii_dataout, wire_niOiil_dataout, wire_n0i0OO_dataout, wire_n0Olll_dataout, wire_n1il0O_dataout, wire_n0110i_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[53]}}}),
	.o(wire_n10O1l_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10O1l.width_data = 8,
		n10O1l.width_sel = 3;
	oper_mux   n10O1O
	( 
	.data({wire_nii1il_dataout, wire_niOiiO_dataout, wire_n0ii1i_dataout, wire_n0OllO_dataout, wire_n1ilii_dataout, wire_n0110l_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[54]}}}),
	.o(wire_n10O1O_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10O1O.width_data = 8,
		n10O1O.width_sel = 3;
	oper_mux   n10Oii
	( 
	.data({wire_nii1lO_dataout, wire_niOiOi_dataout, wire_n0ii0l_dataout, wire_n0OO1i_dataout, wire_n1illl_dataout, wire_n011iO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[58]}}}),
	.o(wire_n10Oii_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10Oii.width_data = 8,
		n10Oii.width_sel = 3;
	oper_mux   n10Oil
	( 
	.data({wire_nii1Oi_dataout, wire_niOiOl_dataout, wire_n0ii0O_dataout, wire_n0OO1l_dataout, wire_n1illO_dataout, wire_n011li_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[59]}}}),
	.o(wire_n10Oil_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10Oil.width_data = 8,
		n10Oil.width_sel = 3;
	oper_mux   n10OiO
	( 
	.data({wire_nii1Ol_dataout, wire_niOiOO_dataout, wire_n0iiii_dataout, wire_n0OO1O_dataout, wire_n1ilOi_dataout, wire_n011ll_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[60]}}}),
	.o(wire_n10OiO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10OiO.width_data = 8,
		n10OiO.width_sel = 3;
	oper_mux   n10Oli
	( 
	.data({wire_nii1OO_dataout, wire_niOl1i_dataout, wire_n0iiil_dataout, wire_n0OO0i_dataout, wire_n1ilOl_dataout, wire_n011lO_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[61]}}}),
	.o(wire_n10Oli_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10Oli.width_data = 8,
		n10Oli.width_sel = 3;
	oper_mux   n10Oll
	( 
	.data({wire_nii01i_dataout, wire_niOl1l_dataout, wire_n0iiiO_dataout, wire_n0OO0l_dataout, wire_n1ilOO_dataout, wire_n011Oi_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[62]}}}),
	.o(wire_n10Oll_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10Oll.width_data = 8,
		n10Oll.width_sel = 3;
	oper_mux   n10OlO
	( 
	.data({wire_nii01l_dataout, wire_niOl1O_dataout, wire_n0iili_dataout, wire_n0OO0O_dataout, wire_n1iO1i_dataout, wire_n011Ol_dataout, {2{wire_nl0l0Ol_byte_des_fifo_data_in[63]}}}),
	.o(wire_n10OlO_o),
	.sel({rwa_6g_en, rdwidth, rbytord_2sym_en}));
	defparam
		n10OlO.width_data = 8,
		n10OlO.width_sel = 3;
	oper_mux   nii00i
	( 
	.data({nlli1l, nlilOl, nlli1l, nliOOO, nlli1l, nlilOl, nlli1l, nll01i, nlli1l, nlilOl, nlli1l, nliOOO, nlli1l, nlilOl, {2{nlli1l}}}),
	.o(wire_nii00i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii00i.width_data = 16,
		nii00i.width_sel = 4;
	oper_mux   nii00l
	( 
	.data({nlli1O, nlilOO, nlli1O, nll11i, nlli1O, nlilOO, nlli1O, nll01l, nlli1O, nlilOO, nlli1O, nll11i, nlli1O, nlilOO, {2{nlli1O}}}),
	.o(wire_nii00l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii00l.width_data = 16,
		nii00l.width_sel = 4;
	oper_mux   nii00O
	( 
	.data({nlli0i, nliO1i, nlli0i, nll11l, nlli0i, nliO1i, nlli0i, nll01O, nlli0i, nliO1i, nlli0i, nll11l, nlli0i, nliO1i, {2{nlli0i}}}),
	.o(wire_nii00O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii00O.width_data = 16,
		nii00O.width_sel = 4;
	oper_mux   nii01O
	( 
	.data({nlli1i, nlilOi, nlli1i, nliOOl, nlli1i, nlilOi, nlli1i, nll1OO, nlli1i, nlilOi, nlli1i, nliOOl, nlli1i, nlilOi, {2{nlli1i}}}),
	.o(wire_nii01O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii01O.width_data = 16,
		nii01O.width_sel = 4;
	oper_mux   nii0ii
	( 
	.data({nlli0l, nliO1l, nlli0l, nll11O, nlli0l, nliO1l, nlli0l, nll00i, nlli0l, nliO1l, nlli0l, nll11O, nlli0l, nliO1l, {2{nlli0l}}}),
	.o(wire_nii0ii_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0ii.width_data = 16,
		nii0ii.width_sel = 4;
	oper_mux   nii0il
	( 
	.data({nlli0O, nliO1O, nlli0O, nll10i, nlli0O, nliO1O, nlli0O, nll00l, nlli0O, nliO1O, nlli0O, nll10i, nlli0O, nliO1O, {2{nlli0O}}}),
	.o(wire_nii0il_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0il.width_data = 16,
		nii0il.width_sel = 4;
	oper_mux   nii0iO
	( 
	.data({nlliii, nliO0i, nlliii, nll10l, nlliii, nliO0i, nlliii, nll00O, nlliii, nliO0i, nlliii, nll10l, nlliii, nliO0i, {2{nlliii}}}),
	.o(wire_nii0iO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0iO.width_data = 16,
		nii0iO.width_sel = 4;
	oper_mux   nii0li
	( 
	.data({nlliil, nliO0l, nlliil, nll10O, nlliil, nliO0l, nlliil, nll0ii, nlliil, nliO0l, nlliil, nll10O, nlliil, nliO0l, {2{nlliil}}}),
	.o(wire_nii0li_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0li.width_data = 16,
		nii0li.width_sel = 4;
	oper_mux   nii0ll
	( 
	.data({nlliiO, nliO0O, nlliiO, nll1ii, nlliiO, nliO0O, nlliiO, nll0il, nlliiO, nliO0O, nlliiO, nll1ii, nlliiO, nliO0O, {2{nlliiO}}}),
	.o(wire_nii0ll_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0ll.width_data = 16,
		nii0ll.width_sel = 4;
	oper_mux   nii0lO
	( 
	.data({nllili, nliOii, nllili, nll1il, nllili, nliOii, nllili, nll0iO, nllili, nliOii, nllili, nll1il, nllili, nliOii, {2{nllili}}}),
	.o(wire_nii0lO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0lO.width_data = 16,
		nii0lO.width_sel = 4;
	oper_mux   nii0Oi
	( 
	.data({nllill, nliOil, nllill, nll1iO, nllill, nliOil, nllill, nll0li, nllill, nliOil, nllill, nll1iO, nllill, nliOil, {2{nllill}}}),
	.o(wire_nii0Oi_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0Oi.width_data = 16,
		nii0Oi.width_sel = 4;
	oper_mux   nii0Ol
	( 
	.data({nllilO, nliOiO, nllilO, nll1li, nllilO, nliOiO, nllilO, nll0ll, nllilO, nliOiO, nllilO, nll1li, nllilO, nliOiO, {2{nllilO}}}),
	.o(wire_nii0Ol_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0Ol.width_data = 16,
		nii0Ol.width_sel = 4;
	oper_mux   nii0OO
	( 
	.data({nlliOi, nliOli, nlliOi, nll1ll, nlliOi, nliOli, nlliOi, nll0lO, nlliOi, nliOli, nlliOi, nll1ll, nlliOi, nliOli, {2{nlliOi}}}),
	.o(wire_nii0OO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nii0OO.width_data = 16,
		nii0OO.width_sel = 4;
	oper_mux   niii0i
	( 
	.data({nlll1l, nliOOl, nlll1l, nll1OO, nlll1l, nliOOl, nlll1l, nlli1i, nlll1l, nliOOl, nlll1l, nll1OO, nlll1l, nliOOl, {2{nlll1l}}}),
	.o(wire_niii0i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niii0i.width_data = 16,
		niii0i.width_sel = 4;
	oper_mux   niii0l
	( 
	.data({nlll1O, nliOOO, nlll1O, nll01i, nlll1O, nliOOO, nlll1O, nlli1l, nlll1O, nliOOO, nlll1O, nll01i, nlll1O, nliOOO, {2{nlll1O}}}),
	.o(wire_niii0l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niii0l.width_data = 16,
		niii0l.width_sel = 4;
	oper_mux   niii0O
	( 
	.data({nlll0i, nll11i, nlll0i, nll01l, nlll0i, nll11i, nlll0i, nlli1O, nlll0i, nll11i, nlll0i, nll01l, nlll0i, nll11i, {2{nlll0i}}}),
	.o(wire_niii0O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niii0O.width_data = 16,
		niii0O.width_sel = 4;
	oper_mux   niii1i
	( 
	.data({nlliOl, nliOll, nlliOl, nll1lO, nlliOl, nliOll, nlliOl, nll0Oi, nlliOl, nliOll, nlliOl, nll1lO, nlliOl, nliOll, {2{nlliOl}}}),
	.o(wire_niii1i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niii1i.width_data = 16,
		niii1i.width_sel = 4;
	oper_mux   niii1l
	( 
	.data({nlliOO, nliOlO, nlliOO, nll1Oi, nlliOO, nliOlO, nlliOO, nll0Ol, nlliOO, nliOlO, nlliOO, nll1Oi, nlliOO, nliOlO, {2{nlliOO}}}),
	.o(wire_niii1l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niii1l.width_data = 16,
		niii1l.width_sel = 4;
	oper_mux   niii1O
	( 
	.data({nlll1i, nliOOi, nlll1i, nll1Ol, nlll1i, nliOOi, nlll1i, nll0OO, nlll1i, nliOOi, nlll1i, nll1Ol, nlll1i, nliOOi, {2{nlll1i}}}),
	.o(wire_niii1O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niii1O.width_data = 16,
		niii1O.width_sel = 4;
	oper_mux   niiiii
	( 
	.data({nlll0l, nll11l, nlll0l, nll01O, nlll0l, nll11l, nlll0l, nlli0i, nlll0l, nll11l, nlll0l, nll01O, nlll0l, nll11l, {2{nlll0l}}}),
	.o(wire_niiiii_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiiii.width_data = 16,
		niiiii.width_sel = 4;
	oper_mux   niiiil
	( 
	.data({nlll0O, nll11O, nlll0O, nll00i, nlll0O, nll11O, nlll0O, nlli0l, nlll0O, nll11O, nlll0O, nll00i, nlll0O, nll11O, {2{nlll0O}}}),
	.o(wire_niiiil_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiiil.width_data = 16,
		niiiil.width_sel = 4;
	oper_mux   niiiiO
	( 
	.data({nlllii, nll10i, nlllii, nll00l, nlllii, nll10i, nlllii, nlli0O, nlllii, nll10i, nlllii, nll00l, nlllii, nll10i, {2{nlllii}}}),
	.o(wire_niiiiO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiiiO.width_data = 16,
		niiiiO.width_sel = 4;
	oper_mux   niiili
	( 
	.data({nlllil, nll10l, nlllil, nll00O, nlllil, nll10l, nlllil, nlliii, nlllil, nll10l, nlllil, nll00O, nlllil, nll10l, {2{nlllil}}}),
	.o(wire_niiili_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiili.width_data = 16,
		niiili.width_sel = 4;
	oper_mux   niiill
	( 
	.data({nllliO, nll10O, nllliO, nll0ii, nllliO, nll10O, nllliO, nlliil, nllliO, nll10O, nllliO, nll0ii, nllliO, nll10O, {2{nllliO}}}),
	.o(wire_niiill_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiill.width_data = 16,
		niiill.width_sel = 4;
	oper_mux   niiilO
	( 
	.data({nlllli, nll1ii, nlllli, nll0il, nlllli, nll1ii, nlllli, nlliiO, nlllli, nll1ii, nlllli, nll0il, nlllli, nll1ii, {2{nlllli}}}),
	.o(wire_niiilO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiilO.width_data = 16,
		niiilO.width_sel = 4;
	oper_mux   niiiOi
	( 
	.data({nlllll, nll1il, nlllll, nll0iO, nlllll, nll1il, nlllll, nllili, nlllll, nll1il, nlllll, nll0iO, nlllll, nll1il, {2{nlllll}}}),
	.o(wire_niiiOi_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiiOi.width_data = 16,
		niiiOi.width_sel = 4;
	oper_mux   niiiOl
	( 
	.data({nllllO, nll1iO, nllllO, nll0li, nllllO, nll1iO, nllllO, nllill, nllllO, nll1iO, nllllO, nll0li, nllllO, nll1iO, {2{nllllO}}}),
	.o(wire_niiiOl_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiiOl.width_data = 16,
		niiiOl.width_sel = 4;
	oper_mux   niiiOO
	( 
	.data({nlllOi, nll1li, nlllOi, nll0ll, nlllOi, nll1li, nlllOi, nllilO, nlllOi, nll1li, nlllOi, nll0ll, nlllOi, nll1li, {2{nlllOi}}}),
	.o(wire_niiiOO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiiOO.width_data = 16,
		niiiOO.width_sel = 4;
	oper_mux   niil0i
	( 
	.data({nllO1l, nll1Ol, nllO1l, nll0OO, nllO1l, nll1Ol, nllO1l, nlll1i, nllO1l, nll1Ol, nllO1l, nll0OO, nllO1l, nll1Ol, {2{nllO1l}}}),
	.o(wire_niil0i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niil0i.width_data = 16,
		niil0i.width_sel = 4;
	oper_mux   niil0l
	( 
	.data({nllO1O, nll1OO, nllO1O, nlli1i, nllO1O, nll1OO, nllO1O, nlll1l, nllO1O, nll1OO, nllO1O, nlli1i, nllO1O, nll1OO, {2{nllO1O}}}),
	.o(wire_niil0l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niil0l.width_data = 16,
		niil0l.width_sel = 4;
	oper_mux   niil0O
	( 
	.data({nllO0i, nll01i, nllO0i, nlli1l, nllO0i, nll01i, nllO0i, nlll1O, nllO0i, nll01i, nllO0i, nlli1l, nllO0i, nll01i, {2{nllO0i}}}),
	.o(wire_niil0O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niil0O.width_data = 16,
		niil0O.width_sel = 4;
	oper_mux   niil1i
	( 
	.data({nlllOl, nll1ll, nlllOl, nll0lO, nlllOl, nll1ll, nlllOl, nlliOi, nlllOl, nll1ll, nlllOl, nll0lO, nlllOl, nll1ll, {2{nlllOl}}}),
	.o(wire_niil1i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niil1i.width_data = 16,
		niil1i.width_sel = 4;
	oper_mux   niil1l
	( 
	.data({nlllOO, nll1lO, nlllOO, nll0Oi, nlllOO, nll1lO, nlllOO, nlliOl, nlllOO, nll1lO, nlllOO, nll0Oi, nlllOO, nll1lO, {2{nlllOO}}}),
	.o(wire_niil1l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niil1l.width_data = 16,
		niil1l.width_sel = 4;
	oper_mux   niil1O
	( 
	.data({nllO1i, nll1Oi, nllO1i, nll0Ol, nllO1i, nll1Oi, nllO1i, nlliOO, nllO1i, nll1Oi, nllO1i, nll0Ol, nllO1i, nll1Oi, {2{nllO1i}}}),
	.o(wire_niil1O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niil1O.width_data = 16,
		niil1O.width_sel = 4;
	oper_mux   niilii
	( 
	.data({nllO0l, nll01l, nllO0l, nlli1O, nllO0l, nll01l, nllO0l, nlll0i, nllO0l, nll01l, nllO0l, nlli1O, nllO0l, nll01l, {2{nllO0l}}}),
	.o(wire_niilii_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niilii.width_data = 16,
		niilii.width_sel = 4;
	oper_mux   niilil
	( 
	.data({nllO0O, nll01O, nllO0O, nlli0i, nllO0O, nll01O, nllO0O, nlll0l, nllO0O, nll01O, nllO0O, nlli0i, nllO0O, nll01O, {2{nllO0O}}}),
	.o(wire_niilil_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niilil.width_data = 16,
		niilil.width_sel = 4;
	oper_mux   niiliO
	( 
	.data({nllOii, nll00i, nllOii, nlli0l, nllOii, nll00i, nllOii, nlll0O, nllOii, nll00i, nllOii, nlli0l, nllOii, nll00i, {2{nllOii}}}),
	.o(wire_niiliO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiliO.width_data = 16,
		niiliO.width_sel = 4;
	oper_mux   niilli
	( 
	.data({nllOil, nll00l, nllOil, nlli0O, nllOil, nll00l, nllOil, nlllii, nllOil, nll00l, nllOil, nlli0O, nllOil, nll00l, {2{nllOil}}}),
	.o(wire_niilli_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niilli.width_data = 16,
		niilli.width_sel = 4;
	oper_mux   niilll
	( 
	.data({nllOiO, nll00O, nllOiO, nlliii, nllOiO, nll00O, nllOiO, nlllil, nllOiO, nll00O, nllOiO, nlliii, nllOiO, nll00O, {2{nllOiO}}}),
	.o(wire_niilll_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niilll.width_data = 16,
		niilll.width_sel = 4;
	oper_mux   niillO
	( 
	.data({nllOli, nll0ii, nllOli, nlliil, nllOli, nll0ii, nllOli, nllliO, nllOli, nll0ii, nllOli, nlliil, nllOli, nll0ii, {2{nllOli}}}),
	.o(wire_niillO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niillO.width_data = 16,
		niillO.width_sel = 4;
	oper_mux   niilOi
	( 
	.data({nllOll, nll0il, nllOll, nlliiO, nllOll, nll0il, nllOll, nlllli, nllOll, nll0il, nllOll, nlliiO, nllOll, nll0il, {2{nllOll}}}),
	.o(wire_niilOi_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niilOi.width_data = 16,
		niilOi.width_sel = 4;
	oper_mux   niilOl
	( 
	.data({nllOlO, nll0iO, nllOlO, nllili, nllOlO, nll0iO, nllOlO, nlllll, nllOlO, nll0iO, nllOlO, nllili, nllOlO, nll0iO, {2{nllOlO}}}),
	.o(wire_niilOl_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niilOl.width_data = 16,
		niilOl.width_sel = 4;
	oper_mux   niilOO
	( 
	.data({nllOOi, nll0li, nllOOi, nllill, nllOOi, nll0li, nllOOi, nllllO, nllOOi, nll0li, nllOOi, nllill, nllOOi, nll0li, {2{nllOOi}}}),
	.o(wire_niilOO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niilOO.width_data = 16,
		niilOO.width_sel = 4;
	oper_mux   niiO0i
	( 
	.data({nlO11l, nll0Ol, nlO11l, nlliOO, nlO11l, nll0Ol, nlO11l, nllO1i, nlO11l, nll0Ol, nlO11l, nlliOO, nlO11l, nll0Ol, {2{nlO11l}}}),
	.o(wire_niiO0i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiO0i.width_data = 16,
		niiO0i.width_sel = 4;
	oper_mux   niiO0l
	( 
	.data({nlO11O, nll0OO, nlO11O, nlll1i, nlO11O, nll0OO, nlO11O, nllO1l, nlO11O, nll0OO, nlO11O, nlll1i, nlO11O, nll0OO, {2{nlO11O}}}),
	.o(wire_niiO0l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiO0l.width_data = 16,
		niiO0l.width_sel = 4;
	oper_mux   niiO0O
	( 
	.data({nlO10i, nlli1i, nlO10i, nlll1l, nlO10i, nlli1i, nlO10i, nllO1O, nlO10i, nlli1i, nlO10i, nlll1l, nlO10i, nlli1i, {2{nlO10i}}}),
	.o(wire_niiO0O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiO0O.width_data = 16,
		niiO0O.width_sel = 4;
	oper_mux   niiO1i
	( 
	.data({nllOOl, nll0ll, nllOOl, nllilO, nllOOl, nll0ll, nllOOl, nlllOi, nllOOl, nll0ll, nllOOl, nllilO, nllOOl, nll0ll, {2{nllOOl}}}),
	.o(wire_niiO1i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiO1i.width_data = 16,
		niiO1i.width_sel = 4;
	oper_mux   niiO1l
	( 
	.data({nllOOO, nll0lO, nllOOO, nlliOi, nllOOO, nll0lO, nllOOO, nlllOl, nllOOO, nll0lO, nllOOO, nlliOi, nllOOO, nll0lO, {2{nllOOO}}}),
	.o(wire_niiO1l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiO1l.width_data = 16,
		niiO1l.width_sel = 4;
	oper_mux   niiO1O
	( 
	.data({nlO11i, nll0Oi, nlO11i, nlliOl, nlO11i, nll0Oi, nlO11i, nlllOO, nlO11i, nll0Oi, nlO11i, nlliOl, nlO11i, nll0Oi, {2{nlO11i}}}),
	.o(wire_niiO1O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiO1O.width_data = 16,
		niiO1O.width_sel = 4;
	oper_mux   niiOii
	( 
	.data({nlO10l, nlli1l, nlO10l, nlll1O, nlO10l, nlli1l, nlO10l, nllO0i, nlO10l, nlli1l, nlO10l, nlll1O, nlO10l, nlli1l, {2{nlO10l}}}),
	.o(wire_niiOii_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOii.width_data = 16,
		niiOii.width_sel = 4;
	oper_mux   niiOil
	( 
	.data({nlO10O, nlli1O, nlO10O, nlll0i, nlO10O, nlli1O, nlO10O, nllO0l, nlO10O, nlli1O, nlO10O, nlll0i, nlO10O, nlli1O, {2{nlO10O}}}),
	.o(wire_niiOil_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOil.width_data = 16,
		niiOil.width_sel = 4;
	oper_mux   niiOiO
	( 
	.data({nlO1ii, nlli0i, nlO1ii, nlll0l, nlO1ii, nlli0i, nlO1ii, nllO0O, nlO1ii, nlli0i, nlO1ii, nlll0l, nlO1ii, nlli0i, {2{nlO1ii}}}),
	.o(wire_niiOiO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOiO.width_data = 16,
		niiOiO.width_sel = 4;
	oper_mux   niiOli
	( 
	.data({nlO1il, nlli0l, nlO1il, nlll0O, nlO1il, nlli0l, nlO1il, nllOii, nlO1il, nlli0l, nlO1il, nlll0O, nlO1il, nlli0l, {2{nlO1il}}}),
	.o(wire_niiOli_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOli.width_data = 16,
		niiOli.width_sel = 4;
	oper_mux   niiOll
	( 
	.data({nlO1iO, nlli0O, nlO1iO, nlllii, nlO1iO, nlli0O, nlO1iO, nllOil, nlO1iO, nlli0O, nlO1iO, nlllii, nlO1iO, nlli0O, {2{nlO1iO}}}),
	.o(wire_niiOll_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOll.width_data = 16,
		niiOll.width_sel = 4;
	oper_mux   niiOlO
	( 
	.data({nlO1li, nlliii, nlO1li, nlllil, nlO1li, nlliii, nlO1li, nllOiO, nlO1li, nlliii, nlO1li, nlllil, nlO1li, nlliii, {2{nlO1li}}}),
	.o(wire_niiOlO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOlO.width_data = 16,
		niiOlO.width_sel = 4;
	oper_mux   niiOOi
	( 
	.data({nlO1ll, nlliil, nlO1ll, nllliO, nlO1ll, nlliil, nlO1ll, nllOli, nlO1ll, nlliil, nlO1ll, nllliO, nlO1ll, nlliil, {2{nlO1ll}}}),
	.o(wire_niiOOi_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOOi.width_data = 16,
		niiOOi.width_sel = 4;
	oper_mux   niiOOl
	( 
	.data({nlO1lO, nlliiO, nlO1lO, nlllli, nlO1lO, nlliiO, nlO1lO, nllOll, nlO1lO, nlliiO, nlO1lO, nlllli, nlO1lO, nlliiO, {2{nlO1lO}}}),
	.o(wire_niiOOl_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOOl.width_data = 16,
		niiOOl.width_sel = 4;
	oper_mux   niiOOO
	( 
	.data({nlO1Oi, nllili, nlO1Oi, nlllll, nlO1Oi, nllili, nlO1Oi, nllOlO, nlO1Oi, nllili, nlO1Oi, nlllll, nlO1Oi, nllili, {2{nlO1Oi}}}),
	.o(wire_niiOOO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niiOOO.width_data = 16,
		niiOOO.width_sel = 4;
	oper_mux   nil10i
	( 
	.data({nlO01l, nlliOl, nlO01l, nlllOO, nlO01l, nlliOl, nlO01l, nlO11i, nlO01l, nlliOl, nlO01l, nlllOO, nlO01l, nlliOl, {2{nlO01l}}}),
	.o(wire_nil10i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nil10i.width_data = 16,
		nil10i.width_sel = 4;
	oper_mux   nil10l
	( 
	.data({nlO01O, nlliOO, nlO01O, nllO1i, nlO01O, nlliOO, nlO01O, nlO11l, nlO01O, nlliOO, nlO01O, nllO1i, nlO01O, nlliOO, {2{nlO01O}}}),
	.o(wire_nil10l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nil10l.width_data = 16,
		nil10l.width_sel = 4;
	oper_mux   nil10O
	( 
	.data({nlO00i, nlll1i, nlO00i, nllO1l, nlO00i, nlll1i, nlO00i, nlO11O, nlO00i, nlll1i, nlO00i, nllO1l, nlO00i, nlll1i, {2{nlO00i}}}),
	.o(wire_nil10O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nil10O.width_data = 16,
		nil10O.width_sel = 4;
	oper_mux   nil11i
	( 
	.data({nlO1Ol, nllill, nlO1Ol, nllllO, nlO1Ol, nllill, nlO1Ol, nllOOi, nlO1Ol, nllill, nlO1Ol, nllllO, nlO1Ol, nllill, {2{nlO1Ol}}}),
	.o(wire_nil11i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nil11i.width_data = 16,
		nil11i.width_sel = 4;
	oper_mux   nil11l
	( 
	.data({nlO1OO, nllilO, nlO1OO, nlllOi, nlO1OO, nllilO, nlO1OO, nllOOl, nlO1OO, nllilO, nlO1OO, nlllOi, nlO1OO, nllilO, {2{nlO1OO}}}),
	.o(wire_nil11l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nil11l.width_data = 16,
		nil11l.width_sel = 4;
	oper_mux   nil11O
	( 
	.data({nlO01i, nlliOi, nlO01i, nlllOl, nlO01i, nlliOi, nlO01i, nllOOO, nlO01i, nlliOi, nlO01i, nlllOl, nlO01i, nlliOi, {2{nlO01i}}}),
	.o(wire_nil11O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nil11O.width_data = 16,
		nil11O.width_sel = 4;
	oper_mux   nili0i
	( 
	.data({nllOOi, nllill, nllOOi, nllllO, nllOOi, nllill, {2{nllOOi}}}),
	.o(wire_nili0i_o),
	.sel({wire_nl01Oi_dataout, wire_nl01lO_dataout, wire_nl01ll_dataout}));
	defparam
		nili0i.width_data = 8,
		nili0i.width_sel = 3;
	oper_mux   nillii
	( 
	.data({nlO1Ol, nllill, nlO1Ol, nllllO, nlO1Ol, nllill, nlO1Ol, nllOOi, nlO1Ol, nllill, nlO1Ol, nllllO, nlO1Ol, nllill, {2{nlO1Ol}}}),
	.o(wire_nillii_o),
	.sel({wire_nl01Ol_dataout, wire_nl01Oi_dataout, wire_nl01lO_dataout, wire_nl01ll_dataout}));
	defparam
		nillii.width_data = 16,
		nillii.width_sel = 4;
	oper_mux   niOl0i
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[0], nlll1l, wire_nl0l0Ol_byte_des_fifo_data_in[0], nllO1O, wire_nl0l0Ol_byte_des_fifo_data_in[0], nlll1l, wire_nl0l0Ol_byte_des_fifo_data_in[0], nlO10i, wire_nl0l0Ol_byte_des_fifo_data_in[0], nlll1l, wire_nl0l0Ol_byte_des_fifo_data_in[0], nllO1O, wire_nl0l0Ol_byte_des_fifo_data_in[0], nlll1l, {2{wire_nl0l0Ol_byte_des_fifo_data_in[0]}}}),
	.o(wire_niOl0i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOl0i.width_data = 16,
		niOl0i.width_sel = 4;
	oper_mux   niOl0l
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[1], nlll1O, wire_nl0l0Ol_byte_des_fifo_data_in[1], nllO0i, wire_nl0l0Ol_byte_des_fifo_data_in[1], nlll1O, wire_nl0l0Ol_byte_des_fifo_data_in[1], nlO10l, wire_nl0l0Ol_byte_des_fifo_data_in[1], nlll1O, wire_nl0l0Ol_byte_des_fifo_data_in[1], nllO0i, wire_nl0l0Ol_byte_des_fifo_data_in[1], nlll1O, {2{wire_nl0l0Ol_byte_des_fifo_data_in[1]}}}),
	.o(wire_niOl0l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOl0l.width_data = 16,
		niOl0l.width_sel = 4;
	oper_mux   niOl0O
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[2], nlll0i, wire_nl0l0Ol_byte_des_fifo_data_in[2], nllO0l, wire_nl0l0Ol_byte_des_fifo_data_in[2], nlll0i, wire_nl0l0Ol_byte_des_fifo_data_in[2], nlO10O, wire_nl0l0Ol_byte_des_fifo_data_in[2], nlll0i, wire_nl0l0Ol_byte_des_fifo_data_in[2], nllO0l, wire_nl0l0Ol_byte_des_fifo_data_in[2], nlll0i, {2{wire_nl0l0Ol_byte_des_fifo_data_in[2]}}}),
	.o(wire_niOl0O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOl0O.width_data = 16,
		niOl0O.width_sel = 4;
	oper_mux   niOlii
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[3], nlll0l, wire_nl0l0Ol_byte_des_fifo_data_in[3], nllO0O, wire_nl0l0Ol_byte_des_fifo_data_in[3], nlll0l, wire_nl0l0Ol_byte_des_fifo_data_in[3], nlO1ii, wire_nl0l0Ol_byte_des_fifo_data_in[3], nlll0l, wire_nl0l0Ol_byte_des_fifo_data_in[3], nllO0O, wire_nl0l0Ol_byte_des_fifo_data_in[3], nlll0l, {2{wire_nl0l0Ol_byte_des_fifo_data_in[3]}}}),
	.o(wire_niOlii_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOlii.width_data = 16,
		niOlii.width_sel = 4;
	oper_mux   niOlil
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[4], nlll0O, wire_nl0l0Ol_byte_des_fifo_data_in[4], nllOii, wire_nl0l0Ol_byte_des_fifo_data_in[4], nlll0O, wire_nl0l0Ol_byte_des_fifo_data_in[4], nlO1il, wire_nl0l0Ol_byte_des_fifo_data_in[4], nlll0O, wire_nl0l0Ol_byte_des_fifo_data_in[4], nllOii, wire_nl0l0Ol_byte_des_fifo_data_in[4], nlll0O, {2{wire_nl0l0Ol_byte_des_fifo_data_in[4]}}}),
	.o(wire_niOlil_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOlil.width_data = 16,
		niOlil.width_sel = 4;
	oper_mux   niOliO
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[5], nlllii, wire_nl0l0Ol_byte_des_fifo_data_in[5], nllOil, wire_nl0l0Ol_byte_des_fifo_data_in[5], nlllii, wire_nl0l0Ol_byte_des_fifo_data_in[5], nlO1iO, wire_nl0l0Ol_byte_des_fifo_data_in[5], nlllii, wire_nl0l0Ol_byte_des_fifo_data_in[5], nllOil, wire_nl0l0Ol_byte_des_fifo_data_in[5], nlllii, {2{wire_nl0l0Ol_byte_des_fifo_data_in[5]}}}),
	.o(wire_niOliO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOliO.width_data = 16,
		niOliO.width_sel = 4;
	oper_mux   niOlli
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[6], nlllil, wire_nl0l0Ol_byte_des_fifo_data_in[6], nllOiO, wire_nl0l0Ol_byte_des_fifo_data_in[6], nlllil, wire_nl0l0Ol_byte_des_fifo_data_in[6], nlO1li, wire_nl0l0Ol_byte_des_fifo_data_in[6], nlllil, wire_nl0l0Ol_byte_des_fifo_data_in[6], nllOiO, wire_nl0l0Ol_byte_des_fifo_data_in[6], nlllil, {2{wire_nl0l0Ol_byte_des_fifo_data_in[6]}}}),
	.o(wire_niOlli_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOlli.width_data = 16,
		niOlli.width_sel = 4;
	oper_mux   niOlll
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[7], nllliO, wire_nl0l0Ol_byte_des_fifo_data_in[7], nllOli, wire_nl0l0Ol_byte_des_fifo_data_in[7], nllliO, wire_nl0l0Ol_byte_des_fifo_data_in[7], nlO1ll, wire_nl0l0Ol_byte_des_fifo_data_in[7], nllliO, wire_nl0l0Ol_byte_des_fifo_data_in[7], nllOli, wire_nl0l0Ol_byte_des_fifo_data_in[7], nllliO, {2{wire_nl0l0Ol_byte_des_fifo_data_in[7]}}}),
	.o(wire_niOlll_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOlll.width_data = 16,
		niOlll.width_sel = 4;
	oper_mux   niOllO
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[8], nlllli, wire_nl0l0Ol_byte_des_fifo_data_in[8], nllOll, wire_nl0l0Ol_byte_des_fifo_data_in[8], nlllli, wire_nl0l0Ol_byte_des_fifo_data_in[8], nlO1lO, wire_nl0l0Ol_byte_des_fifo_data_in[8], nlllli, wire_nl0l0Ol_byte_des_fifo_data_in[8], nllOll, wire_nl0l0Ol_byte_des_fifo_data_in[8], nlllli, {2{wire_nl0l0Ol_byte_des_fifo_data_in[8]}}}),
	.o(wire_niOllO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOllO.width_data = 16,
		niOllO.width_sel = 4;
	oper_mux   niOlOi
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[9], nlllll, wire_nl0l0Ol_byte_des_fifo_data_in[9], nllOlO, wire_nl0l0Ol_byte_des_fifo_data_in[9], nlllll, wire_nl0l0Ol_byte_des_fifo_data_in[9], nlO1Oi, wire_nl0l0Ol_byte_des_fifo_data_in[9], nlllll, wire_nl0l0Ol_byte_des_fifo_data_in[9], nllOlO, wire_nl0l0Ol_byte_des_fifo_data_in[9], nlllll, {2{wire_nl0l0Ol_byte_des_fifo_data_in[9]}}}),
	.o(wire_niOlOi_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOlOi.width_data = 16,
		niOlOi.width_sel = 4;
	oper_mux   niOlOl
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[10], nllllO, wire_nl0l0Ol_byte_des_fifo_data_in[10], nllOOi, wire_nl0l0Ol_byte_des_fifo_data_in[10], nllllO, wire_nl0l0Ol_byte_des_fifo_data_in[10], nlO1Ol, wire_nl0l0Ol_byte_des_fifo_data_in[10], nllllO, wire_nl0l0Ol_byte_des_fifo_data_in[10], nllOOi, wire_nl0l0Ol_byte_des_fifo_data_in[10], nllllO, {2{wire_nl0l0Ol_byte_des_fifo_data_in[10]}}}),
	.o(wire_niOlOl_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOlOl.width_data = 16,
		niOlOl.width_sel = 4;
	oper_mux   niOlOO
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[11], nlllOi, wire_nl0l0Ol_byte_des_fifo_data_in[11], nllOOl, wire_nl0l0Ol_byte_des_fifo_data_in[11], nlllOi, wire_nl0l0Ol_byte_des_fifo_data_in[11], nlO1OO, wire_nl0l0Ol_byte_des_fifo_data_in[11], nlllOi, wire_nl0l0Ol_byte_des_fifo_data_in[11], nllOOl, wire_nl0l0Ol_byte_des_fifo_data_in[11], nlllOi, {2{wire_nl0l0Ol_byte_des_fifo_data_in[11]}}}),
	.o(wire_niOlOO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOlOO.width_data = 16,
		niOlOO.width_sel = 4;
	oper_mux   niOO0i
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[15], nllO1l, wire_nl0l0Ol_byte_des_fifo_data_in[15], nlO11O, wire_nl0l0Ol_byte_des_fifo_data_in[15], nllO1l, wire_nl0l0Ol_byte_des_fifo_data_in[15], nlO00i, wire_nl0l0Ol_byte_des_fifo_data_in[15], nllO1l, wire_nl0l0Ol_byte_des_fifo_data_in[15], nlO11O, wire_nl0l0Ol_byte_des_fifo_data_in[15], nllO1l, {2{wire_nl0l0Ol_byte_des_fifo_data_in[15]}}}),
	.o(wire_niOO0i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOO0i.width_data = 16,
		niOO0i.width_sel = 4;
	oper_mux   niOO0l
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[16], nllO1O, wire_nl0l0Ol_byte_des_fifo_data_in[16], nlO10i, wire_nl0l0Ol_byte_des_fifo_data_in[16], nllO1O, wire_nl0l0Ol_byte_des_fifo_data_in[16], wire_nl0l0Ol_byte_des_fifo_data_in[0], wire_nl0l0Ol_byte_des_fifo_data_in[16], nllO1O, wire_nl0l0Ol_byte_des_fifo_data_in[16], nlO10i, wire_nl0l0Ol_byte_des_fifo_data_in[16], nllO1O, {2{wire_nl0l0Ol_byte_des_fifo_data_in[16]}}}),
	.o(wire_niOO0l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOO0l.width_data = 16,
		niOO0l.width_sel = 4;
	oper_mux   niOO0O
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[17], nllO0i, wire_nl0l0Ol_byte_des_fifo_data_in[17], nlO10l, wire_nl0l0Ol_byte_des_fifo_data_in[17], nllO0i, wire_nl0l0Ol_byte_des_fifo_data_in[17], wire_nl0l0Ol_byte_des_fifo_data_in[1], wire_nl0l0Ol_byte_des_fifo_data_in[17], nllO0i, wire_nl0l0Ol_byte_des_fifo_data_in[17], nlO10l, wire_nl0l0Ol_byte_des_fifo_data_in[17], nllO0i, {2{wire_nl0l0Ol_byte_des_fifo_data_in[17]}}}),
	.o(wire_niOO0O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOO0O.width_data = 16,
		niOO0O.width_sel = 4;
	oper_mux   niOO1i
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[12], nlllOl, wire_nl0l0Ol_byte_des_fifo_data_in[12], nllOOO, wire_nl0l0Ol_byte_des_fifo_data_in[12], nlllOl, wire_nl0l0Ol_byte_des_fifo_data_in[12], nlO01i, wire_nl0l0Ol_byte_des_fifo_data_in[12], nlllOl, wire_nl0l0Ol_byte_des_fifo_data_in[12], nllOOO, wire_nl0l0Ol_byte_des_fifo_data_in[12], nlllOl, {2{wire_nl0l0Ol_byte_des_fifo_data_in[12]}}}),
	.o(wire_niOO1i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOO1i.width_data = 16,
		niOO1i.width_sel = 4;
	oper_mux   niOO1l
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[13], nlllOO, wire_nl0l0Ol_byte_des_fifo_data_in[13], nlO11i, wire_nl0l0Ol_byte_des_fifo_data_in[13], nlllOO, wire_nl0l0Ol_byte_des_fifo_data_in[13], nlO01l, wire_nl0l0Ol_byte_des_fifo_data_in[13], nlllOO, wire_nl0l0Ol_byte_des_fifo_data_in[13], nlO11i, wire_nl0l0Ol_byte_des_fifo_data_in[13], nlllOO, {2{wire_nl0l0Ol_byte_des_fifo_data_in[13]}}}),
	.o(wire_niOO1l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOO1l.width_data = 16,
		niOO1l.width_sel = 4;
	oper_mux   niOO1O
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[14], nllO1i, wire_nl0l0Ol_byte_des_fifo_data_in[14], nlO11l, wire_nl0l0Ol_byte_des_fifo_data_in[14], nllO1i, wire_nl0l0Ol_byte_des_fifo_data_in[14], nlO01O, wire_nl0l0Ol_byte_des_fifo_data_in[14], nllO1i, wire_nl0l0Ol_byte_des_fifo_data_in[14], nlO11l, wire_nl0l0Ol_byte_des_fifo_data_in[14], nllO1i, {2{wire_nl0l0Ol_byte_des_fifo_data_in[14]}}}),
	.o(wire_niOO1O_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOO1O.width_data = 16,
		niOO1O.width_sel = 4;
	oper_mux   niOOii
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[18], nllO0l, wire_nl0l0Ol_byte_des_fifo_data_in[18], nlO10O, wire_nl0l0Ol_byte_des_fifo_data_in[18], nllO0l, wire_nl0l0Ol_byte_des_fifo_data_in[18], wire_nl0l0Ol_byte_des_fifo_data_in[2], wire_nl0l0Ol_byte_des_fifo_data_in[18], nllO0l, wire_nl0l0Ol_byte_des_fifo_data_in[18], nlO10O, wire_nl0l0Ol_byte_des_fifo_data_in[18], nllO0l, {2{wire_nl0l0Ol_byte_des_fifo_data_in[18]}}}),
	.o(wire_niOOii_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOii.width_data = 16,
		niOOii.width_sel = 4;
	oper_mux   niOOil
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[19], nllO0O, wire_nl0l0Ol_byte_des_fifo_data_in[19], nlO1ii, wire_nl0l0Ol_byte_des_fifo_data_in[19], nllO0O, wire_nl0l0Ol_byte_des_fifo_data_in[19], wire_nl0l0Ol_byte_des_fifo_data_in[3], wire_nl0l0Ol_byte_des_fifo_data_in[19], nllO0O, wire_nl0l0Ol_byte_des_fifo_data_in[19], nlO1ii, wire_nl0l0Ol_byte_des_fifo_data_in[19], nllO0O, {2{wire_nl0l0Ol_byte_des_fifo_data_in[19]}}}),
	.o(wire_niOOil_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOil.width_data = 16,
		niOOil.width_sel = 4;
	oper_mux   niOOiO
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[20], nllOii, wire_nl0l0Ol_byte_des_fifo_data_in[20], nlO1il, wire_nl0l0Ol_byte_des_fifo_data_in[20], nllOii, wire_nl0l0Ol_byte_des_fifo_data_in[20], wire_nl0l0Ol_byte_des_fifo_data_in[4], wire_nl0l0Ol_byte_des_fifo_data_in[20], nllOii, wire_nl0l0Ol_byte_des_fifo_data_in[20], nlO1il, wire_nl0l0Ol_byte_des_fifo_data_in[20], nllOii, {2{wire_nl0l0Ol_byte_des_fifo_data_in[20]}}}),
	.o(wire_niOOiO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOiO.width_data = 16,
		niOOiO.width_sel = 4;
	oper_mux   niOOli
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[21], nllOil, wire_nl0l0Ol_byte_des_fifo_data_in[21], nlO1iO, wire_nl0l0Ol_byte_des_fifo_data_in[21], nllOil, wire_nl0l0Ol_byte_des_fifo_data_in[21], wire_nl0l0Ol_byte_des_fifo_data_in[5], wire_nl0l0Ol_byte_des_fifo_data_in[21], nllOil, wire_nl0l0Ol_byte_des_fifo_data_in[21], nlO1iO, wire_nl0l0Ol_byte_des_fifo_data_in[21], nllOil, {2{wire_nl0l0Ol_byte_des_fifo_data_in[21]}}}),
	.o(wire_niOOli_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOli.width_data = 16,
		niOOli.width_sel = 4;
	oper_mux   niOOll
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[22], nllOiO, wire_nl0l0Ol_byte_des_fifo_data_in[22], nlO1li, wire_nl0l0Ol_byte_des_fifo_data_in[22], nllOiO, wire_nl0l0Ol_byte_des_fifo_data_in[22], wire_nl0l0Ol_byte_des_fifo_data_in[6], wire_nl0l0Ol_byte_des_fifo_data_in[22], nllOiO, wire_nl0l0Ol_byte_des_fifo_data_in[22], nlO1li, wire_nl0l0Ol_byte_des_fifo_data_in[22], nllOiO, {2{wire_nl0l0Ol_byte_des_fifo_data_in[22]}}}),
	.o(wire_niOOll_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOll.width_data = 16,
		niOOll.width_sel = 4;
	oper_mux   niOOlO
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[23], nllOli, wire_nl0l0Ol_byte_des_fifo_data_in[23], nlO1ll, wire_nl0l0Ol_byte_des_fifo_data_in[23], nllOli, wire_nl0l0Ol_byte_des_fifo_data_in[23], wire_nl0l0Ol_byte_des_fifo_data_in[7], wire_nl0l0Ol_byte_des_fifo_data_in[23], nllOli, wire_nl0l0Ol_byte_des_fifo_data_in[23], nlO1ll, wire_nl0l0Ol_byte_des_fifo_data_in[23], nllOli, {2{wire_nl0l0Ol_byte_des_fifo_data_in[23]}}}),
	.o(wire_niOOlO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOlO.width_data = 16,
		niOOlO.width_sel = 4;
	oper_mux   niOOOi
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[24], nllOll, wire_nl0l0Ol_byte_des_fifo_data_in[24], nlO1lO, wire_nl0l0Ol_byte_des_fifo_data_in[24], nllOll, wire_nl0l0Ol_byte_des_fifo_data_in[24], wire_nl0l0Ol_byte_des_fifo_data_in[8], wire_nl0l0Ol_byte_des_fifo_data_in[24], nllOll, wire_nl0l0Ol_byte_des_fifo_data_in[24], nlO1lO, wire_nl0l0Ol_byte_des_fifo_data_in[24], nllOll, {2{wire_nl0l0Ol_byte_des_fifo_data_in[24]}}}),
	.o(wire_niOOOi_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOOi.width_data = 16,
		niOOOi.width_sel = 4;
	oper_mux   niOOOl
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[25], nllOlO, wire_nl0l0Ol_byte_des_fifo_data_in[25], nlO1Oi, wire_nl0l0Ol_byte_des_fifo_data_in[25], nllOlO, wire_nl0l0Ol_byte_des_fifo_data_in[25], wire_nl0l0Ol_byte_des_fifo_data_in[9], wire_nl0l0Ol_byte_des_fifo_data_in[25], nllOlO, wire_nl0l0Ol_byte_des_fifo_data_in[25], nlO1Oi, wire_nl0l0Ol_byte_des_fifo_data_in[25], nllOlO, {2{wire_nl0l0Ol_byte_des_fifo_data_in[25]}}}),
	.o(wire_niOOOl_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOOl.width_data = 16,
		niOOOl.width_sel = 4;
	oper_mux   niOOOO
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[26], nllOOi, wire_nl0l0Ol_byte_des_fifo_data_in[26], nlO1Ol, wire_nl0l0Ol_byte_des_fifo_data_in[26], nllOOi, wire_nl0l0Ol_byte_des_fifo_data_in[26], wire_nl0l0Ol_byte_des_fifo_data_in[10], wire_nl0l0Ol_byte_des_fifo_data_in[26], nllOOi, wire_nl0l0Ol_byte_des_fifo_data_in[26], nlO1Ol, wire_nl0l0Ol_byte_des_fifo_data_in[26], nllOOi, {2{wire_nl0l0Ol_byte_des_fifo_data_in[26]}}}),
	.o(wire_niOOOO_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		niOOOO.width_data = 16,
		niOOOO.width_sel = 4;
	oper_mux   nl001i
	( 
	.data({1'b0, wire_nl00il_dataout, wire_nl0iiO_dataout, 1'b0, wire_nl0O1i_dataout, wire_nli1OO_dataout, wire_nliiil_dataout, 1'b0}),
	.o(wire_nl001i_o),
	.sel({rbytord_2sym_en, rbytorden[1:0]}));
	defparam
		nl001i.width_data = 8,
		nl001i.width_sel = 3;
	oper_mux   nl001l
	( 
	.data({1'b0, wire_nl00lO_dataout, wire_nl0iOi_dataout, 1'b0, wire_nl0O0l_dataout, wire_nli01O_dataout, wire_nliill_dataout, 1'b0}),
	.o(wire_nl001l_o),
	.sel({rbytord_2sym_en, rbytorden[1:0]}));
	defparam
		nl001l.width_data = 8,
		nl001l.width_sel = 3;
	oper_mux   nl001O
	( 
	.data({1'b0, wire_nl0i1l_dataout, wire_nl0l1O_dataout, 1'b0, wire_nli11i_dataout, wire_nli0ll_dataout, wire_nlil0i_dataout, 1'b0}),
	.o(wire_nl001O_o),
	.sel({rbytord_2sym_en, rbytorden[1:0]}));
	defparam
		nl001O.width_data = 8,
		nl001O.width_sel = 3;
	oper_mux   nl010l
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[58], wire_nl0l0Ol_byte_des_fifo_data_in[10], wire_nl0l0Ol_byte_des_fifo_data_in[58], wire_nl0l0Ol_byte_des_fifo_data_in[26], wire_nl0l0Ol_byte_des_fifo_data_in[58], wire_nl0l0Ol_byte_des_fifo_data_in[10], wire_nl0l0Ol_byte_des_fifo_data_in[58], wire_nl0l0Ol_byte_des_fifo_data_in[42], wire_nl0l0Ol_byte_des_fifo_data_in[58], wire_nl0l0Ol_byte_des_fifo_data_in[10], wire_nl0l0Ol_byte_des_fifo_data_in[58], wire_nl0l0Ol_byte_des_fifo_data_in[26], wire_nl0l0Ol_byte_des_fifo_data_in[58], wire_nl0l0Ol_byte_des_fifo_data_in[10], {2{wire_nl0l0Ol_byte_des_fifo_data_in[58]}}}),
	.o(wire_nl010l_o),
	.sel({wire_nl01Ol_dataout, wire_nl01Oi_dataout, wire_nl01lO_dataout, wire_nl01ll_dataout}));
	defparam
		nl010l.width_data = 16,
		nl010l.width_sel = 4;
	oper_mux   nl01OO
	( 
	.data({1'b0, wire_nl000i_dataout, wire_nl0i0l_dataout, 1'b0, wire_nl0l0O_dataout, wire_nli1il_dataout, wire_nlii1i_dataout, 1'b0}),
	.o(wire_nl01OO_o),
	.sel({rbytord_2sym_en, rbytorden[1:0]}));
	defparam
		nl01OO.width_data = 8,
		nl01OO.width_sel = 3;
	oper_mux   nl100i
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[45], nlO01l, wire_nl0l0Ol_byte_des_fifo_data_in[45], wire_nl0l0Ol_byte_des_fifo_data_in[13], wire_nl0l0Ol_byte_des_fifo_data_in[45], nlO01l, wire_nl0l0Ol_byte_des_fifo_data_in[45], wire_nl0l0Ol_byte_des_fifo_data_in[29], wire_nl0l0Ol_byte_des_fifo_data_in[45], nlO01l, wire_nl0l0Ol_byte_des_fifo_data_in[45], wire_nl0l0Ol_byte_des_fifo_data_in[13], wire_nl0l0Ol_byte_des_fifo_data_in[45], nlO01l, {2{wire_nl0l0Ol_byte_des_fifo_data_in[45]}}}),
	.o(wire_nl100i_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nl100i.width_data = 16,
		nl100i.width_sel = 4;
	oper_mux   nl100l
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[46], nlO01O, wire_nl0l0Ol_byte_des_fifo_data_in[46], wire_nl0l0Ol_byte_des_fifo_data_in[14], wire_nl0l0Ol_byte_des_fifo_data_in[46], nlO01O, wire_nl0l0Ol_byte_des_fifo_data_in[46], wire_nl0l0Ol_byte_des_fifo_data_in[30], wire_nl0l0Ol_byte_des_fifo_data_in[46], nlO01O, wire_nl0l0Ol_byte_des_fifo_data_in[46], wire_nl0l0Ol_byte_des_fifo_data_in[14], wire_nl0l0Ol_byte_des_fifo_data_in[46], nlO01O, {2{wire_nl0l0Ol_byte_des_fifo_data_in[46]}}}),
	.o(wire_nl100l_o),
	.sel({nlilll, nlilli, nliliO, n11OOO}));
	defparam
		nl100l.width_data = 16,
		nl100l.width_sel = 4;
	oper_mux   nl100O
	( 
	.data({wire_nl0l0Ol_byte_des_fifo_data_in[47], nlO00i, wire_nl0l0Ol_byte_des_fifo_data_in[47], wire_nl0l0Ol_byte_des_fifo_data_in[15], wire_nl0l0Ol_byte_des_fifo_data_in[47], nlO00i, wire_nl0l0Ol_byte_des_fifo_data_in[47], wire_nl0l0Ol_byte_des_fifo_data_in[31], wire_nl0l0Ol_byte_des_fifo_data_in[47], nlO00i, wire_nl0l0Ol_byte_des_fifo_data_in[47], wire_nl0l0Ol_byte_des_fifo_data_in[15], wire_nl0l0Ol_byte_des_fifo_data_in[